/*
 *========================================================================
 * $Id: get_system_users.c 163 2005-09-14 22:54:20Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include "xmlsysd.h"

/*
 * This routine gets the system time and returns it as a formatted
 * time string AND as tv_sec/tv_usec.  The former conversion could
 * of course be done at the other end, but it is nice to be able to
 * READ xml output.
 */

void get_system_users(xmlNodePtr system)
{

 int i,numfields;
 struct timeval tv;
 struct utmp *utmpstruct;
 int numusers = 0;
 xmlNodePtr users;

 if(verbose==102){
   fprintf(stderr,"Starting get_system_users().\n");
 }

 /* 
  * Get the number of users and return it as a node/value of system.
  * We timestamp it so one CAN get tv_sec or tv_usec if desired.
  */

 /* count the number of users */
 setutent();
 while ((utmpstruct = getutent())) {
   if((utmpstruct->ut_type == USER_PROCESS) &&
              (utmpstruct->ut_name[0] != '\0')) numusers++;
 }
 endutent();
 if(verbose==102){
   fprintf(stderr,"Found %d users.\n",numusers);
 }

 sprintf(outbuf,"%d",numusers);

 users = xmlNewChild(system,NULL,(xmlChar*) "users",(xmlChar*) outbuf);
 gettimeofday(&tv,0);
 sprintf(outbuf,"%d",tv.tv_sec);
 xmlSetProp(users,(xmlChar*) "tv_sec",(xmlChar*) outbuf);
 sprintf(outbuf,"%d",tv.tv_usec);
 xmlSetProp(users,(xmlChar*) "tv_usec",(xmlChar*) outbuf);

}

