/*
 *========================================================================
 * $Id: work.c 72 2006-07-20 18:04:33Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

/*
 *========================================================================
 * This is the main loop of the program.  We should remain here looping
 * until the program is terminated.
 *========================================================================
 */

#include "wulflogger.h"

void work()
{

 struct timeval sleepytime;
 fd_set in;
 char keyin;

 if((verbose == D_ALL) || (verbose == D_WORK)){
   printf("D_WORK: Starting wulfstat_work().  Use -v %d to focus.\n",D_WORK);
   sleep(1);
   /* printf("D_WORK: Starting wulfstat_work().  Use -v %d to focus.\n",D_WORK); */
 }

 /* 
  * Zero the cycle counter and off to work-loop we go...
  */
 cycle_cnt = 0;

 /*
  * We loop forever, with a variable (user selectable) delay and a keyboard
  * escape (where we CAN do e.g. dynamic reconfiguration therein).
  */
 while(1){

   if((verbose == D_ALL) || (verbose == D_WORK)){
     printf("D_WORK: About to wait for %d seconds\n",update_delay);
   }
   sleep(update_delay);

   /* 
    * Increment cycle counter
    */
   cycle_cnt++;
   if((verbose == D_ALL) || (verbose == D_WORK)){
     printf("D_WORK: cycle counter = %d\n",cycle_cnt);
   }

   /*
    * receive the results and put them where they belong.
    */
   update_host_values(hostlist);

   /*
    * display them.
    */
   display_values();

   if(count != -1 && cycle_cnt >= count) exit(0);

 }

}
