/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.awt;

import edu.hws.jcm.awt.Computable;
import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.InputObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ContainerEvent;

public class JCMPanel
extends Panel {
    private int insetGap;
    private Controller controller;

    public JCMPanel(LayoutManager layoutManager) {
        this.enableEvents(2L);
        this.setLayout(layoutManager);
    }

    public JCMPanel() {
        this(3);
    }

    public JCMPanel(int n) {
        this(new BorderLayout(n, n));
    }

    public JCMPanel(int n, int n2) {
        this(n, n2, 3);
    }

    public JCMPanel(int n, int n2, int n3) {
        this(new GridLayout(n, n2, n3, n3));
    }

    public void setInsetGap(int n) {
        this.insetGap = n;
    }

    @Override
    public Insets getInsets() {
        return new Insets(this.insetGap, this.insetGap, this.insetGap, this.insetGap);
    }

    public Controller getController() {
        if (this.controller == null) {
            this.controller = new Controller();
        }
        return this.controller;
    }

    public void gatherInputs() {
        Controller controller = this.getController();
        controller.notifyControllerOnChange(controller);
    }

    @Override
    public void processContainerEvent(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        if (component instanceof JCMPanel) {
            if (containerEvent.getID() == 300) {
                this.getController().add(((JCMPanel)component).getController());
            } else if (containerEvent.getID() == 301) {
                this.getController().remove(((JCMPanel)component).getController());
            }
        } else if (component instanceof Computable || component instanceof InputObject) {
            if (containerEvent.getID() == 300) {
                this.getController().add(component);
            } else if (containerEvent.getID() == 301) {
                this.getController().remove(component);
            }
        }
    }
}

