/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.weirdx;

import com.jcraft.weirdx.Client;
import com.jcraft.weirdx.IO;
import java.io.IOException;
import java.util.Hashtable;

final class Atom {
    private static int lastAtom = 0;
    private static String[] idTable = new String[]{null, "PRIMARY", "SECONDARY", "ARC", "ATOM", "BITMAP", "CARDINAL", "COLORMAP", "CURSOR", "CUT_BUFFER0", "CUT_BUFFER1", "CUT_BUFFER2", "CUT_BUFFER3", "CUT_BUFFER4", "CUT_BUFFER5", "CUT_BUFFER6", "CUT_BUFFER7", "DRAWABLE", "FONT", "INTEGER", "PIXMAP", "POINT", "RECTANGLE", "RESOURCE_MANAGER", "RGB_COLOR_MAP", "RGB_BEST_MAP", "RGB_BLUE_MAP", "RGB_DEFAULT_MAP", "RGB_GRAY_MAP", "RGB_GREEN_MAP", "RGB_RED_MAP", "STRING", "VISUALID", "WINDOW", "WM_COMMAND", "WM_HINTS", "WM_CLIENT_MACHINE", "WM_ICON_NAME", "WM_ICON_SIZE", "WM_NAME", "WM_NORMAL_HINTS", "WM_SIZE_HINTS", "WM_ZOOM_HINTS", "MIN_SPACE", "NORM_SPACE", "MAX_SPACE", "END_SPACE", "SUPERSC.LPT_X", "SUPERSC.LPT_Y", "SUBSC.LPT_X", "SUBSC.LPT_Y", "UNDERLINE_POSITION", "UNDERLINE_THICKNESS", "STRIKEOUT_ASCENT", "STRIKEOUT_DESCENT", "ITALIC_ANGLE", "X_HEIGHT", "QUAD_WIDTH", "WEIGHT", "POINT_SIZE", "RESOLUTION", "COPYRIGHT", "NOTICE", "FONT_NAME", "FAMILY_NAME", "FULL_NAME", "CAP_HEIGHT", "WM_CLASS", "WM_TRANSIENT_FOR"};
    private static final int lastPredefined = idTable.length - 1;
    private static final Hashtable nameTable;

    Atom() {
    }

    private static Hashtable nameTablePredefined() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        int n = 1;
        while (idTable[n] != null) {
            hashtable.put(idTable[n], new Integer(n));
            ++n;
        }
        return hashtable;
    }

    static int make(byte[] byArray, int n, int n2, boolean bl) {
        return Atom.make(new String(byArray, n, n2), bl);
    }

    static int make(byte[] byArray, boolean bl) {
        return Atom.make(new String(byArray), bl);
    }

    static synchronized int make(String string, boolean bl) {
        int n = Atom.find(string);
        if (n != 0) {
            return n;
        }
        if (!bl) {
            return 0;
        }
        if (idTable.length <= ++lastAtom) {
            String[] stringArray = new String[idTable.length * 2];
            System.arraycopy(idTable, 0, stringArray, 0, idTable.length);
            idTable = stringArray;
        }
        Atom.idTable[Atom.lastAtom] = string;
        nameTable.put(string, new Integer(lastAtom));
        return lastAtom;
    }

    static boolean valid(int n) {
        return n != 0 && n <= lastAtom;
    }

    static String find(int n) {
        if (n == 0) {
            return null;
        }
        if (n <= lastAtom) {
            return idTable[n];
        }
        return null;
    }

    static int find(String string) {
        if (string == null) {
            return 0;
        }
        try {
            Integer n = (Integer)nameTable.get(string);
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    static int find(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        try {
            Integer n = (Integer)nameTable.get(new String(byArray));
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reqInternAtom(Client client) throws IOException {
        int n = 0;
        IO iO = client.client;
        int n2 = client.data;
        n = iO.readShort();
        iO.readPad(2);
        client.length -= 2;
        if (n <= 0) {
            client.errorReason = 11;
            return;
        }
        byte[] byArray = client.bbuffer;
        iO.readByte(byArray, 0, n);
        iO.readPad(-n & 3);
        client.length = 0;
        int n3 = Atom.make(byArray, 0, n, n2 == 0);
        IO iO2 = iO;
        synchronized (iO2) {
            iO.writeByte(1);
            iO.writePad(1);
            iO.writeShort(client.seq);
            iO.writeInt(0);
            iO.writeInt(n3);
            iO.writePad(20);
            iO.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reqGetAtomName(Client client) throws IOException {
        IO iO = client.client;
        int n = iO.readInt();
        if (n < 0) {
            n &= Integer.MAX_VALUE;
        }
        if (!Atom.valid(n)) {
            IO iO2 = iO;
            synchronized (iO2) {
                iO.writeByte(0);
                iO.writeByte(5);
                iO.writeShort(client.seq);
                iO.writeInt(n);
                iO.writeShort(0);
                iO.writeByte(17);
                iO.writePad(21);
                iO.flush();
            }
        }
        String string = Atom.find(n);
        IO iO3 = iO;
        synchronized (iO3) {
            iO.writeByte(1);
            iO.writePad(1);
            iO.writeShort(client.seq);
            iO.writeInt((string.length() + 3) / 4);
            iO.writeShort(string.length());
            iO.writePad(22);
            iO.writeByte(string.getBytes());
            if (string.length() > 0) {
                iO.writePad(-string.length() & 3);
            }
            iO.flush();
        }
    }

    static {
        String[] stringArray = new String[100];
        System.arraycopy(idTable, 0, stringArray, 0, idTable.length);
        lastAtom = idTable.length - 1;
        idTable = stringArray;
        nameTable = Atom.nameTablePredefined();
    }
}

