# frozen_string_literal: true

require 'test_helper'
require 'files/models/traffic_light'

class TrafficLightCautionTest < Minitest::Test
  def setup
    @light = TrafficLight.new
    @light.state = 'caution'
  end

  def test_should_use_caution_color
    assert_equal 'yellow', @light.color
  end

  def test_should_use_caution_capture_violations
    assert @light.capture_violations?
  end
end
