#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "sphere.icc"
int main(int argc, char**argv) {
  environment rheolef(argc, argv);
  geo gamma (argv[1]);
  size_t d = gamma.dimension();
  space Wh (gamma, argv[2]);
  trial u (Wh); test v (Wh);
  form  a  = integrate (u*v + dot(grad_s(u),grad_s(v)));
  field lh = integrate (f(d)*v);
  field uh (Wh);
  solver sa (a.uu());
  uh.set_u() = sa.solve (lh.u() - a.ub()*uh.b());
  dout << uh;
}
