# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [2.4.0] - 2024-03-03

### Added

- Highlight the selected connection in the connections list.
- Made the trip details page keyboard-navigable.
- Improved accessibility

### Changed

- Improved positioning for arrival and departure labels in the connections list.
- Minor UI update regarding journey remarks.

### Fixed

- Some strings not being translatable or using incorrect forms of a plural.
- Also allow `Ctrl+Q` to close the window.
- Performance issues with showing the details of large journeys.
- Bug where an incorrect timezone was used.

## [2.3.0] - 2024-02-11

### Added

- Keyboard navigation to station search.
- Label for frequency of trains.

### Changed

- Strings used in the UI.
- Improved remarks for journey legs.
- Many minor UI improvements.

### Fixed

- For the station search, clear the place when the entry is cleared.

## [2.2.0] - 2023-12-11

### Added

- Translation support using Weblate.
- Filter for providers.
- Indicate when journey was last refreshed.
- Save window height between startups.

### Changed

- Improved UI for date-dividers.
- Disable search button while search is in progress.
- Disable refresh button while refreshing journey is in progress.
- Added timeout to all requests.

### Fixed

- Don't collapse journey legs stopovers and remarks after refreshing.
- Build on i386.

## [2.1.0] - 2023-10-07

### Added

- Keyboard shortcuts
- Date dividers between journeys.

### Changed

- UI improvements on the preferences.
- Don't display walk destination, unless it is the final walk.

### Fixed

- Spinners in the time dropdown not being two-digit sometimes.
- Duration of over one day being displayed incorrectly.
- The date and time cards having a different color than the rest when in dark mode.

### Packaging

- `hafas-rs` is now taken from `crates.io` instead of git.

## [2.0.0] - 2023-09-21

### Changed

- Complete UI overhaul

[Unreleased]: https://gitlab.com/schmiddi-on-mobile/railway/-/compare/2.4.0...master
[2.4.0]: https://gitlab.com/schmiddi-on-mobile/railway/-/compare/2.3.0...2.4.0
[2.3.0]: https://gitlab.com/schmiddi-on-mobile/railway/-/compare/2.2.0...2.3.0
[2.2.0]: https://gitlab.com/schmiddi-on-mobile/railway/-/compare/2.1.0...2.2.0
[2.1.0]: https://gitlab.com/schmiddi-on-mobile/railway/-/compare/2.0.0...2.1.0
[2.0.0]: https://gitlab.com/schmiddi-on-mobile/railway/-/compare/1.5.0...2.0.0
