% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WDI.R
\name{WDIsearch}
\alias{WDIsearch}
\title{Search names and descriptions of available WDI series}
\usage{
WDIsearch(string = "gdp", field = "name", short = TRUE,
  cache = NULL)
}
\arguments{
\item{string}{Character string. Search for this string using \code{grep} with
\code{ignore.case=TRUE}.}

\item{field}{Character string. Search this field. Admissible fields:
'indicator', 'name', 'description', 'sourceDatabase', 'sourceOrganization'}

\item{short}{TRUE: Returns only the indicator's code and name. FALSE: Returns
the indicator's code, name, description, and source.}

\item{cache}{Data list generated by the \code{WDIcache} function. If omitted,
\code{WDIsearch} will search a local list of series.}
}
\value{
Data frame with code, name, source, and description of all series which
    match the criteria.
}
\description{
Data frame with series code, name, description, and source for the WDI series
which match the given criteria
}
\examples{
WDIsearch(string='gdp', field='name', cache=NULL)
WDIsearch(string='AG.AGR.TRAC.NO', field='indicator', cache=NULL)
}
