context("context")

test_that("graphs get added and stacked in the context", {
  context <- ContextBuilder$new()
  expect_false(context$alive())
  gr1 <- create_ring(5)
  context$set(gr1)
  expect_true(context$alive())
  expect_equal(context$active(), active(gr1))
  expect_equal(context$graph(), gr1)
  expect_equal(context$nodes(), as_tibble(gr1, 'nodes'))
  expect_equal(context$edges(), as_tibble(gr1, 'edges'))
  gr2 <- create_lattice(c(4, 5)) %>% activate(edges)
  context$set(gr2)
  expect_equal(context$active(), active(gr2))
  expect_equal(context$graph(), gr2)
  context$clear()
  expect_equal(context$graph(), gr1)
  context$clear()
  expect_false(context$alive())
})
