% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WLpdist.R
\name{WLpdist}
\alias{WLpdist}
\title{Pairwise Wasserstein-like Distance between two vMF distributions}
\usage{
WLpdist(means, concentrations)
}
\arguments{
\item{means}{An \eqn{(n \times p)} matrix where each row represents the mean 
direction of one of the \eqn{n} vMF distributions.}

\item{concentrations}{A length-\eqn{n} vector of nonnegative concentration parameters.}
}
\value{
An \eqn{(n \times n)} matrix of pairwise distances.
}
\description{
Given a collection of von Misees-Fisher (vMF) distributions, compute the pairwise 
distance using the Wasserstein-like distance from an approximate Wasserstein geometry.
}
\examples{
\donttest{
# Set seed for reproducibility
set.seed(123)

# Generate two classes of mean directions around north and south poles
means1 = array(0,c(50,2)); means1[,2] = rnorm(50, mean=1, sd=0.25)
means2 = array(0,c(50,2)); means2[,2] = rnorm(50, mean=-1, sd=0.25)
means1 = means1/sqrt(rowSums(means1^2))
means2 = means2/sqrt(rowSums(means2^2))

# Concatenate the mean directions
data_means = rbind(means1, means2)

# Generate concentration parameters
data_concentrations = rnorm(100, mean=20, sd=1)

# Compute the pairwise distance matrix
pdmat = WLpdist(data_means, data_concentrations)

# Visualise the pairwise distance matrix
opar <- par(no.readonly=TRUE)
image(pdmat, main="Pairwise Wasserstein-like Distance")
par(opar)
}

}
