% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid.R
\name{valid}
\alias{valid}
\alias{st_make_valid}
\title{Make an invalid geometry valid}
\usage{
st_make_valid(x)
}
\arguments{
\item{x}{object of class \code{sfg}, \code{sfg} or \code{sf}}
}
\value{
Object of the same class as \code{x}
}
\description{
Make an invalid geometry valid
}
\details{
\code{st_make_valid} uses the \code{lwgeom_makevalid} method also used by the PostGIS command \code{ST_makevalid}.
}
\examples{
library(sf)
x = st_sfc(st_polygon(list(rbind(c(0,0),c(0.5,0),c(0.5,0.5),c(0.5,0),c(1,0),c(1,1),c(0,1),c(0,0)))))
suppressWarnings(st_is_valid(x))
y = lwgeom::st_make_valid(x)
st_is_valid(y)
y \%>\% st_cast()
}
