% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{erdos.renyi.game}
\alias{erdos.renyi.game}
\alias{random.graph.game}
\title{Generate random graphs according to the Erdős-Rényi model}
\usage{
erdos.renyi.game(
  n,
  p.or.m,
  type = c("gnp", "gnm"),
  directed = FALSE,
  loops = FALSE
)
}
\arguments{
\item{n}{The number of vertices in the graph.}

\item{p.or.m}{Either the probability for drawing an edge between two
arbitrary vertices (\eqn{G(n,p)} graph), or the number of edges in
the graph (for \eqn{G(n,m)} graphs).}

\item{type}{The type of the random graph to create, either \code{gnp()}
(\eqn{G(n,p)} graph) or \code{gnm()} (\eqn{G(n,m)} graph).}

\item{directed}{Logical, whether the graph will be directed, defaults to
\code{FALSE}.}

\item{loops}{Logical, whether to add loop edges, defaults to \code{FALSE}.}
}
\value{
A graph object.
}
\description{
Simple random graph model, specifying the edge count either precisely
(\eqn{G(n,m)} model) or on average through a connection probability
(\eqn{G(n,p)} model).
}
\details{
In \eqn{G(n,m)} graphs, there are precisely \code{m} edges.

In \eqn{G(n,p)} graphs, all vertex pairs are connected with the same
probability \code{p}.

\code{random.graph.game()} is an alias to this function.
}
\section{Deprecated}{


Since igraph version 0.8.0, both \code{erdos.renyi.game()} and
\code{random.graph.game()} are deprecated, and \code{\link[=sample_gnp]{sample_gnp()}} and
\code{\link[=sample_gnm]{sample_gnm()}} should be used instead. See these for more details.
}

\examples{

g <- erdos.renyi.game(1000, 1 / 1000)
degree_distribution(g)

}
\references{
Erdős, P. and Rényi, A., On random graphs, \emph{Publicationes
Mathematicae} 6, 290--297 (1959).
}
\seealso{
Random graph models (games)
\code{\link{sample_bipartite}()},
\code{\link{sample_correlated_gnp_pair}()},
\code{\link{sample_correlated_gnp}()},
\code{\link{sample_degseq}()},
\code{\link{sample_dot_product}()},
\code{\link{sample_fitness_pl}()},
\code{\link{sample_fitness}()},
\code{\link{sample_forestfire}()},
\code{\link{sample_gnm}()},
\code{\link{sample_gnp}()},
\code{\link{sample_grg}()},
\code{\link{sample_growing}()},
\code{\link{sample_hierarchical_sbm}()},
\code{\link{sample_islands}()},
\code{\link{sample_k_regular}()},
\code{\link{sample_last_cit}()},
\code{\link{sample_pa_age}()},
\code{\link{sample_pa}()},
\code{\link{sample_pref}()},
\code{\link{sample_sbm}()},
\code{\link{sample_smallworld}()},
\code{\link{sample_traits_callaway}()},
\code{\link{sample_tree}()},
\code{\link{sample_}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{games}
\keyword{graphs}
\keyword{internal}
