% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tableGrob.r
\name{tableGrob}
\alias{grid.table}
\alias{tableGrob}
\alias{ttheme_default}
\alias{ttheme_default,}
\alias{ttheme_minimal}
\title{Graphical display of a textual table}
\usage{
tableGrob(d, rows = rownames(d), cols = colnames(d),
  theme = ttheme_default(), ...)

grid.table(...)

ttheme_default(...)

ttheme_minimal(...)
}
\arguments{
\item{d}{data.frame or matrix}

\item{rows}{optional vector to specify row names}

\item{cols}{optional vector to specify column names}

\item{theme}{list of theme parameters}

\item{...}{further arguments to control the gtable}
}
\value{
a gtable
}
\description{
Create a gtable containing text grobs representing a character matrix
}
\section{Functions}{
\itemize{
\item \code{tableGrob}: return a grob

\item \code{grid.table}: draw a text table

\item \code{ttheme_default}: default theme for text tables

\item \code{ttheme_minimal}: minimalist theme for text tables
}}
\examples{
library(grid)
d <- head(iris, 3)
g <- tableGrob(d)
grid.newpage()
grid.draw(g)
}

