% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/googlesheets4-package.R, R/utils-ui.R
\name{googlesheets4-configuration}
\alias{googlesheets4-configuration}
\alias{local_gs4_quiet}
\alias{with_gs4_quiet}
\title{googlesheets4 configuration}
\usage{
local_gs4_quiet(env = parent.frame())

with_gs4_quiet(code)
}
\arguments{
\item{env}{The environment to use for scoping}

\item{code}{Code to execute quietly}
}
\description{
Some aspects of googlesheets4 behaviour can be controlled via an option.
}
\section{Messages}{


The \code{googlesheets4_quiet} option can be used to suppress messages from
googlesheets4. By default, googlesheets4 always messages, i.e. it is \emph{not}
quiet.

Set \code{googlesheets4_quiet} to \code{TRUE} to suppress messages, by one of these
means, in order of decreasing scope:
\itemize{
\item Put \code{options(googlesheets4_quiet = TRUE)} in a start-up file, such as
\code{.Rprofile}, or in your R script
\item Use \code{local_gs4_quiet()} to silence googlesheets4 in a specific scope
\item Use \code{with_gs4_quiet()} to run a small bit of code silently
}

\code{local_gs4_quiet()} and \code{with_gs4_quiet()} follow the conventions of the
the withr package (\url{https://withr.r-lib.org}).
}

\section{Auth}{


Read about googlesheets4's main auth function, \code{\link[=gs4_auth]{gs4_auth()}}. It is powered
by the gargle package, which consults several options:
\itemize{
\item Default Google user or, more precisely, \code{email}: see
\code{\link[gargle:gargle_options]{gargle::gargle_oauth_email()}}
\item Whether or where to cache OAuth tokens: see
\code{\link[gargle:gargle_options]{gargle::gargle_oauth_cache()}}
\item Whether to prefer "out-of-band" auth: see
\code{\link[gargle:gargle_options]{gargle::gargle_oob_default()}}
\item Application Default Credentials: see \code{\link[gargle:credentials_app_default]{gargle::credentials_app_default()}}
}
}

\examples{
\dontshow{if (gs4_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# message: "Creating new Sheet ..."
(ss <- gs4_create("gs4-quiet-demo", sheets = "alpha"))

# message: "Editing ..., Writing ..."
range_write(ss, data = data.frame(x = 1, y = "a"))

# suppress messages for a small amount of code
with_gs4_quiet(
  ss \%>\% sheet_append(data.frame(x = 2, y = "b"))
)

# message: "Writing ..., Appending ..."
ss \%>\% sheet_append(data.frame(x = 3, y = "c"))

# suppress messages until end of current scope
local_gs4_quiet()
ss \%>\% sheet_append(data.frame(x = 4, y = "d"))

# see that all the data was, in fact, written
read_sheet(ss)

# clean up
gs4_find("gs4-quiet-demo") \%>\%
  googledrive::drive_trash()
\dontshow{\}) # examplesIf}
}
