% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggfacet.R
\name{ggfacet}
\alias{ggfacet}
\title{ggfacet - single ggplot2 plot matrix with facet_grid}
\usage{
ggfacet(data, mapping = NULL, columnsX = 1:ncol(data),
  columnsY = 1:ncol(data), fn = ggally_points, ...,
  columnLabelsX = names(data[columnsX]),
  columnLabelsY = names(data[columnsY]), xlab = NULL, ylab = NULL,
  title = NULL, scales = "free")
}
\arguments{
\item{data}{data.frame that contains all columns to be displayed.  This data will be melted before being passed into the function \code{fn}}

\item{mapping}{aesthetic mapping (besides \code{x} and \code{y}).  See \code{\link[ggplot2]{aes}()}}

\item{columnsX}{columns to be displayed in the plot matrix}

\item{columnsY}{rows to be displayed in the plot matrix}

\item{fn}{function to be executed. Similar to \code{\link{ggpairs}} and \code{\link{ggduo}}, the function may either be a string identifier or a real function that \code{\link{wrap}} understands.}

\item{...}{extra arguments passed directly to \code{fn}}

\item{columnLabelsX, columnLabelsY}{column and row labels to display in the plot matrix}

\item{xlab, ylab, title}{plot matrix labels}

\item{scales}{parameter supplied to \code{ggplot2::\link[ggplot2]{facet_grid}}. Default behavior is \code{"free"}}
}
\description{
ggfacet - single ggplot2 plot matrix with facet_grid
}
\examples{
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive
if (requireNamespace("chemometrics", quietly = TRUE)) {
  data(NIR, package = "chemometrics")
  NIR_sub <- data.frame(NIR$yGlcEtOH, NIR$xNIR[,1:3])
  str(NIR_sub)
  x_cols <- c("X1115.0", "X1120.0", "X1125.0")
  y_cols <- c("Glucose", "Ethanol")

  # using ggduo directly
  p <- ggduo(NIR_sub, x_cols, y_cols, types = list(continuous = "points"))
  p_(p)

  # using ggfacet
  p <- ggfacet(NIR_sub, x_cols, y_cols)
  p_(p)

  # add a smoother
  p <- ggfacet(NIR_sub, x_cols, y_cols, fn = 'smooth_loess')
  p_(p)
  # same output
  p <- ggfacet(NIR_sub, x_cols, y_cols, fn = ggally_smooth_loess)
  p_(p)

  # Change scales to be the same in for every row and for every column
  p <- ggfacet(NIR_sub, x_cols, y_cols, scales = "fixed")
  p_(p)
}
}
