% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_language.R
\name{cles}
\alias{cles}
\alias{common_language}
\alias{cohens_u3}
\alias{p_superiority}
\alias{p_overlap}
\title{Estimate Common Language Effect Sizes (CLES)}
\usage{
cles(
  x,
  y = NULL,
  data = NULL,
  mu = 0,
  ci = 0.95,
  alternative = "two.sided",
  parametric = TRUE,
  verbose = TRUE,
  iterations = 200,
  ...
)

common_language(
  x,
  y = NULL,
  data = NULL,
  mu = 0,
  ci = 0.95,
  alternative = "two.sided",
  parametric = TRUE,
  verbose = TRUE,
  iterations = 200,
  ...
)

cohens_u3(...)

p_superiority(...)

p_overlap(...)
}
\arguments{
\item{x}{A formula, a numeric vector, or a character name of one in \code{data}.}

\item{y}{A numeric vector, a grouping (character / factor) vector, a or a
character  name of one in \code{data}. Ignored if \code{x} is a formula.}

\item{data}{An optional data frame containing the variables.}

\item{mu}{a number indicating the true value of the mean (or
    difference in means if you are performing a two sample test).}

\item{ci}{Confidence Interval (CI) level}

\item{alternative}{a character string specifying the alternative hypothesis;
Controls the type of CI returned: \code{"two.sided"} (default, two-sided CI),
\code{"greater"} or \code{"less"} (one-sided CI). Partial matching is allowed (e.g.,
\code{"g"}, \code{"l"}, \code{"two"}...). See \emph{One-Sided CIs} in \link{effectsize_CIs}.}

\item{parametric}{Use parametric estimation (see \code{\link[=cohens_d]{cohens_d()}}) or
non-parametric estimation (see \code{\link[=rank_biserial]{rank_biserial()}}).}

\item{verbose}{Toggle warnings and messages on or off.}

\item{iterations}{The number of bootstrap replicates for computing confidence
intervals. Only applies when \code{ci} is not \code{NULL} and \code{parametric = FALSE}.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data frame containing the common language effect sizes (and
optionally their CIs).
}
\description{
\code{cohens_u3()}, \code{p_superiority()}, and \code{p_overlap()} give only one of the
CLESs.
}
\details{
These measures of effect size present group differences in probabilistic
terms:
\itemize{
\item \strong{Probability of superiority} is the probability that, when sampling an
observation from each of the groups at random, that the observation from
the second group will be larger than the sample from the first group.
\item \strong{Cohen's U3} is the proportion of the second group that is smaller than
the median of the first group.
\item \strong{Overlap} (OVL) is the proportional overlap between the distributions.
(When \code{parametric = FALSE}, \code{\link[bayestestR:overlap]{bayestestR::overlap()}} is used.)
}

For unequal group sizes, it is recommended to use the non-parametric based
CLES (\code{parametric = FALSE}).
}
\section{Confidence Intervals (CIs)}{

For parametric CLES, the CIs are transformed CIs for Cohen's \emph{d}
(\code{\link[=d_to_cles]{d_to_cles()}}). For non-parametric (\code{parametric = FALSE}) CLES, the CI of
\emph{Pr(superiority)} is a transformed CI of the rank-biserial correlation
(\code{\link[=rb_to_cles]{rb_to_cles()}}), while for Cohen's \emph{U3} and the Overlap coefficient the
confidence intervals are bootstrapped (requires the \code{boot} package).
}

\examples{
cles(mpg ~ am, data = mtcars)

set.seed(4)
cles(mpg ~ am, data = mtcars, parametric = FALSE)

\dontrun{
## Individual CLES
p_superiority(extra ~ group, data = sleep)

cohens_u3(extra ~ group, data = sleep, parametric = FALSE)

p_overlap(extra ~ group, data = sleep)
}

}
\references{
\itemize{
\item Cohen, J. (1977). Statistical power analysis for the behavioral sciences.
New York: Routledge.
\item Reiser, B., & Faraggi, D. (1999). Confidence intervals for the overlapping
coefficient: the normal equal variance case. Journal of the Royal Statistical
Society, 48(3), 413-418.
\item Ruscio, J. (2008). A probability-based measure of effect size: robustness
to base rates and other factors. Psychological methods, 13(1), 19–30.
}
}
\seealso{
\code{\link[=d_to_cles]{d_to_cles()}} \code{\link[=sd_pooled]{sd_pooled()}}

Other effect size indices: 
\code{\link{cohens_d}()},
\code{\link{effectsize.BFBayesFactor}()},
\code{\link{eta_squared}()},
\code{\link{phi}()},
\code{\link{rank_biserial}()},
\code{\link{standardize_parameters}()}
}
\concept{effect size indices}
