% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{as.data.frame.brmsfit}
\alias{as.data.frame.brmsfit}
\alias{as.matrix.brmsfit}
\alias{as.array.brmsfit}
\title{Extract Posterior Draws}
\usage{
\method{as.data.frame}{brmsfit}(
  x,
  row.names = NULL,
  optional = TRUE,
  pars = NA,
  variable = NULL,
  draw = NULL,
  subset = NULL,
  ...
)

\method{as.matrix}{brmsfit}(x, pars = NA, variable = NULL, draw = NULL, subset = NULL, ...)

\method{as.array}{brmsfit}(x, pars = NA, variable = NULL, draw = NULL, subset = NULL, ...)
}
\arguments{
\item{x}{A \code{brmsfit} object or another \R object for which
the methods are defined.}

\item{row.names, optional}{Unused and only added for consistency with
the \code{\link[base:as.data.frame]{as.data.frame}} generic.}

\item{pars}{Deprecated alias of \code{variable}. For reasons of backwards
compatibility, \code{pars} is interpreted as a vector of regular
expressions by default unless \code{fixed = TRUE} is specified.}

\item{variable}{A character vector providing the variables to extract.
By default, all variables are extracted.}

\item{draw}{The draw indices to be select. Subsetting draw indices will lead
to an automatic merging of chains.}

\item{subset}{Deprecated alias of \code{draw}.}

\item{...}{Further arguments to be passed to the corresponding
\code{\link[brms:draws-brms]{as_draws_*}} methods as well as to
\code{\link[posterior:subset_draws]{subset_draws}}.}
}
\value{
A data.frame, matrix, or array containing the posterior draws.
}
\description{
Extract posterior draws in conventional formats
as data.frames, matrices, or arrays.
}
\seealso{
\code{\link[brms:draws-brms]{as_draws}},
  \code{\link[posterior:subset_draws]{subset_draws}}
}
