########################################################################
# Vers 2.10 16 July 2008, (c)2004-2008 John Lim (jlim#natsoft.com) All Rights Reserved
# Released under a BSD-style license. See LICENSE.txt.
# Download: http://adodb.sourceforge.net/#pydownload
########################################################################

import adodb,adodb_pyodbc,datetime

try:
    True, False
except NameError:
    # Maintain compatibility with Python 2.2
    True, False = 1, 0
        
class adodb_mssql(adodb_pyodbc.adodb_pyodbc):
    databaseType = 'mssql'
    dataProvider = 'pyodbc'
    sysDate = 'convert(datetime,convert(char,GetDate(),102),102)'
    sysTimeStamp = 'GetDate()'
    replaceQuote = "''"
    
    def _newcursor(self,rs):
        return cursor_mssql(rs,self)    
        
class cursor_mssql(adodb_pyodbc.cursor_pyodbc):
    def __init__(self,rs,conn):
        adodb_pyodbc.cursor_pyodbc.__init__(self,rs,conn)

    def Affected_Rows(self):
        return self._conn.GetOne('select @@rowcount')

    def Insert_ID(self):
        return self._conn.GetOne('select @@IDENTITY')

if __name__ == '__main__':
    db = adodb_mssql()
    db.Connect("PROVIDER=MSDASQL;DRIVER={SQL Server};SERVER=sherkhan;DATABASE=NorthWind;UID=adodb;PWD=natsoft;Trusted_Connection=No")
    adodb.Test(db)