package collector

import (
	"encoding/base64"
	"fmt"
	"net/http"
	"net/http/httptest"
	"net/url"
	"strings"
	"testing"

	"github.com/go-kit/kit/log"
)

func TestNodesStats(t *testing.T) {
	// Testcases created using:
	//  docker run -d -p 9200:9200 elasticsearch:VERSION-alpine
	//  curl -XPUT http://localhost:9200/twitter
	//  curl http://localhost:9200/_nodes/stats
	tcs := map[string]string{
		"1.7.6": `{"cluster_name":"elasticsearch","nodes":{"vKnRv2bPThCJIDTj92NvQg":{"timestamp":1498820641883,"name":"Overmind","transport_address":"inet[/172.17.0.4:9300]","host":"2603876b583f","ip":["inet[/172.17.0.4:9300]","NONE"],"indices":{"docs":{"count":0,"deleted":0},"store":{"size_in_bytes":575,"throttle_time_in_millis":0},"indexing":{"index_total":0,"index_time_in_millis":0,"index_current":0,"delete_total":0,"delete_time_in_millis":0,"delete_current":0,"noop_update_total":0,"is_throttled":false,"throttle_time_in_millis":0},"get":{"total":0,"time_in_millis":0,"exists_total":0,"exists_time_in_millis":0,"missing_total":0,"missing_time_in_millis":0,"current":0},"search":{"open_contexts":0,"query_total":0,"query_time_in_millis":0,"query_current":0,"fetch_total":0,"fetch_time_in_millis":0,"fetch_current":0},"merges":{"current":0,"current_docs":0,"current_size_in_bytes":0,"total":0,"total_time_in_millis":0,"total_docs":0,"total_size_in_bytes":0},"refresh":{"total":0,"total_time_in_millis":0},"flush":{"total":0,"total_time_in_millis":0},"warmer":{"current":0,"total":10,"total_time_in_millis":52},"filter_cache":{"memory_size_in_bytes":0,"evictions":0},"id_cache":{"memory_size_in_bytes":0},"fielddata":{"memory_size_in_bytes":0,"evictions":0},"percolate":{"total":0,"time_in_millis":0,"current":0,"memory_size_in_bytes":-1,"memory_size":"-1b","queries":0},"completion":{"size_in_bytes":0},"segments":{"count":0,"memory_in_bytes":0,"index_writer_memory_in_bytes":0,"index_writer_max_memory_in_bytes":335544320,"version_map_memory_in_bytes":0,"fixed_bit_set_memory_in_bytes":0},"translog":{"operations":0,"size_in_bytes":17},"suggest":{"total":0,"time_in_millis":0,"current":0},"query_cache":{"memory_size_in_bytes":0,"evictions":0,"hit_count":0,"miss_count":0},"recovery":{"current_as_source":0,"current_as_target":0,"throttle_time_in_millis":0}},"os":{"timestamp":1498820641896},"process":{"timestamp":1498820641896,"open_file_descriptors":123},"jvm":{"timestamp":1498820641896,"uptime_in_millis":17871,"mem":{"heap_used_in_bytes":82958528,"heap_used_percent":7,"heap_committed_in_bytes":251002880,"heap_max_in_bytes":1056309248,"non_heap_used_in_bytes":44442536,"non_heap_committed_in_bytes":45400064,"pools":{"young":{"used_in_bytes":62150064,"max_in_bytes":139591680,"peak_used_in_bytes":139591680,"peak_max_in_bytes":139591680},"survivor":{"used_in_bytes":17432576,"max_in_bytes":17432576,"peak_used_in_bytes":17432576,"peak_max_in_bytes":17432576},"old":{"used_in_bytes":3375888,"max_in_bytes":899284992,"peak_used_in_bytes":10899920,"peak_max_in_bytes":899284992}}},"threads":{"count":36,"peak_count":36},"gc":{"collectors":{"young":{"collection_count":1,"collection_time_in_millis":40},"old":{"collection_count":1,"collection_time_in_millis":42}}},"buffer_pools":{"direct":{"count":27,"used_in_bytes":4981411,"total_capacity_in_bytes":4981411},"mapped":{"count":0,"used_in_bytes":0,"total_capacity_in_bytes":0}}},"thread_pool":{"percolate":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_started":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"listener":{"threads":1,"queue":0,"active":0,"rejected":0,"largest":1,"completed":1},"index":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"refresh":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"suggest":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"generic":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":14},"warmer":{"threads":1,"queue":0,"active":0,"rejected":0,"largest":1,"completed":5},"search":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"flush":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"optimize":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_store":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"management":{"threads":1,"queue":0,"active":1,"rejected":0,"largest":1,"completed":1},"get":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"merge":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"bulk":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"snapshot":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0}},"network":{},"fs":{"timestamp":1498820641898,"total":{"total_in_bytes":63375708160,"free_in_bytes":59667320832,"available_in_bytes":56424390656},"data":[{"path":"/usr/share/elasticsearch/data/elasticsearch/nodes/0","mount":"/usr/share/elasticsearch/data (/dev/sda2)","type":"ext4","total_in_bytes":63375708160,"free_in_bytes":59667320832,"available_in_bytes":56424390656}]},"transport":{"server_open":13,"rx_count":6,"rx_size_in_bytes":1428,"tx_count":6,"tx_size_in_bytes":1428},"http":{"current_open":1,"total_opened":2},"breakers":{"request":{"limit_size_in_bytes":422523699,"limit_size":"402.9mb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0},"fielddata":{"limit_size_in_bytes":633785548,"limit_size":"604.4mb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.03,"tripped":0},"parent":{"limit_size_in_bytes":739416473,"limit_size":"705.1mb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0}}}}}`,
		"2.4.5": `{"cluster_name":"elasticsearch","nodes":{"VnnrklnAQ7KRXhW2WkgPxA":{"timestamp":1498820602662,"name":"Battering Ram","transport_address":"172.17.0.4:9300","host":"172.17.0.4","ip":["172.17.0.4:9300","NONE"],"indices":{"docs":{"count":0,"deleted":0},"store":{"size_in_bytes":650,"throttle_time_in_millis":0},"indexing":{"index_total":0,"index_time_in_millis":0,"index_current":0,"index_failed":0,"delete_total":0,"delete_time_in_millis":0,"delete_current":0,"noop_update_total":0,"is_throttled":false,"throttle_time_in_millis":0},"get":{"total":0,"time_in_millis":0,"exists_total":0,"exists_time_in_millis":0,"missing_total":0,"missing_time_in_millis":0,"current":0},"search":{"open_contexts":0,"query_total":0,"query_time_in_millis":0,"query_current":0,"fetch_total":0,"fetch_time_in_millis":0,"fetch_current":0,"scroll_total":0,"scroll_time_in_millis":0,"scroll_current":0},"merges":{"current":0,"current_docs":0,"current_size_in_bytes":0,"total":0,"total_time_in_millis":0,"total_docs":0,"total_size_in_bytes":0,"total_stopped_time_in_millis":0,"total_throttled_time_in_millis":0,"total_auto_throttle_in_bytes":104857600},"refresh":{"total":0,"total_time_in_millis":0},"flush":{"total":0,"total_time_in_millis":0},"warmer":{"current":0,"total":10,"total_time_in_millis":60},"query_cache":{"memory_size_in_bytes":0,"total_count":0,"hit_count":0,"miss_count":0,"cache_size":0,"cache_count":0,"evictions":0},"fielddata":{"memory_size_in_bytes":0,"evictions":0},"percolate":{"total":0,"time_in_millis":0,"current":0,"memory_size_in_bytes":-1,"memory_size":"-1b","queries":0},"completion":{"size_in_bytes":0},"segments":{"count":0,"memory_in_bytes":0,"terms_memory_in_bytes":0,"stored_fields_memory_in_bytes":0,"term_vectors_memory_in_bytes":0,"norms_memory_in_bytes":0,"doc_values_memory_in_bytes":0,"index_writer_memory_in_bytes":0,"index_writer_max_memory_in_bytes":105630920,"version_map_memory_in_bytes":0,"fixed_bit_set_memory_in_bytes":0},"translog":{"operations":0,"size_in_bytes":215},"suggest":{"total":0,"time_in_millis":0,"current":0},"request_cache":{"memory_size_in_bytes":0,"evictions":0,"hit_count":0,"miss_count":0},"recovery":{"current_as_source":0,"current_as_target":0,"throttle_time_in_millis":0}},"os":{"timestamp":1498820602670,"cpu_percent":7,"load_average":0.32861328125,"mem":{"total_in_bytes":2096177152,"free_in_bytes":1624637440,"used_in_bytes":471539712,"free_percent":78,"used_percent":22},"swap":{"total_in_bytes":4195348480,"free_in_bytes":4005060608,"used_in_bytes":190287872}},"process":{"timestamp":1498820602670,"open_file_descriptors":116,"max_file_descriptors":1048576,"cpu":{"percent":7,"total_in_millis":10270},"mem":{"total_virtual_in_bytes":2681352192}},"jvm":{"timestamp":1498820602671,"uptime_in_millis":38833,"mem":{"heap_used_in_bytes":88986784,"heap_used_percent":8,"heap_committed_in_bytes":251002880,"heap_max_in_bytes":1056309248,"non_heap_used_in_bytes":49185912,"non_heap_committed_in_bytes":49987584,"pools":{"young":{"used_in_bytes":58281984,"max_in_bytes":139591680,"peak_used_in_bytes":139591680,"peak_max_in_bytes":139591680},"survivor":{"used_in_bytes":17432576,"max_in_bytes":17432576,"peak_used_in_bytes":17432576,"peak_max_in_bytes":17432576},"old":{"used_in_bytes":13272224,"max_in_bytes":899284992,"peak_used_in_bytes":13272224,"peak_max_in_bytes":899284992}}},"threads":{"count":35,"peak_count":38},"gc":{"collectors":{"young":{"collection_count":2,"collection_time_in_millis":87},"old":{"collection_count":1,"collection_time_in_millis":74}}},"buffer_pools":{"direct":{"count":23,"used_in_bytes":3416836,"total_capacity_in_bytes":3416836},"mapped":{"count":0,"used_in_bytes":0,"total_capacity_in_bytes":0}},"classes":{"current_loaded_count":7221,"total_loaded_count":7221,"total_unloaded_count":0}},"thread_pool":{"bulk":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_started":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_store":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"flush":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"force_merge":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"generic":{"threads":1,"queue":0,"active":0,"rejected":0,"largest":5,"completed":28},"get":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"index":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"listener":{"threads":1,"queue":0,"active":0,"rejected":0,"largest":1,"completed":2},"management":{"threads":2,"queue":0,"active":1,"rejected":0,"largest":2,"completed":5},"percolate":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"refresh":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"search":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"snapshot":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"suggest":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"warmer":{"threads":1,"queue":0,"active":0,"rejected":0,"largest":1,"completed":5}},"fs":{"timestamp":1498820602672,"total":{"total_in_bytes":63375708160,"free_in_bytes":59667599360,"available_in_bytes":56424669184,"spins":"true"},"data":[{"path":"/usr/share/elasticsearch/data/elasticsearch/nodes/0","mount":"/usr/share/elasticsearch/data (/dev/sda2)","type":"ext4","total_in_bytes":63375708160,"free_in_bytes":59667599360,"available_in_bytes":56424669184,"spins":"true"}]},"transport":{"server_open":0,"rx_count":6,"rx_size_in_bytes":2028,"tx_count":6,"tx_size_in_bytes":2028},"http":{"current_open":1,"total_opened":3},"breakers":{"request":{"limit_size_in_bytes":422523699,"limit_size":"402.9mb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0},"fielddata":{"limit_size_in_bytes":633785548,"limit_size":"604.4mb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.03,"tripped":0},"in_flight_requests":{"limit_size_in_bytes":1056309248,"limit_size":"1007.3mb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0},"parent":{"limit_size_in_bytes":739416473,"limit_size":"705.1mb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0}},"script":{"compilations":0,"cache_evictions":0}}}}`,
		"5.4.2": `{"_nodes":{"total":1,"successful":1,"failed":0},"cluster_name":"elasticsearch","nodes":{"0hHcEFK1S7qMlk8hQCm7wQ":{"timestamp":1498820489394,"name":"0hHcEFK","transport_address":"127.0.0.1:9300","host":"127.0.0.1","ip":"127.0.0.1:9300","roles":["master","data","ingest"],"indices":{"docs":{"count":0,"deleted":0},"store":{"size_in_bytes":650,"throttle_time_in_millis":0},"indexing":{"index_total":0,"index_time_in_millis":0,"index_current":0,"index_failed":0,"delete_total":0,"delete_time_in_millis":0,"delete_current":0,"noop_update_total":0,"is_throttled":false,"throttle_time_in_millis":0},"get":{"total":0,"time_in_millis":0,"exists_total":0,"exists_time_in_millis":0,"missing_total":0,"missing_time_in_millis":0,"current":0},"search":{"open_contexts":0,"query_total":0,"query_time_in_millis":0,"query_current":0,"fetch_total":0,"fetch_time_in_millis":0,"fetch_current":0,"scroll_total":0,"scroll_time_in_millis":0,"scroll_current":0,"suggest_total":0,"suggest_time_in_millis":0,"suggest_current":0},"merges":{"current":0,"current_docs":0,"current_size_in_bytes":0,"total":0,"total_time_in_millis":0,"total_docs":0,"total_size_in_bytes":0,"total_stopped_time_in_millis":0,"total_throttled_time_in_millis":0,"total_auto_throttle_in_bytes":104857600},"refresh":{"total":0,"total_time_in_millis":0,"listeners":0},"flush":{"total":0,"total_time_in_millis":0},"warmer":{"current":0,"total":5,"total_time_in_millis":27},"query_cache":{"memory_size_in_bytes":0,"total_count":0,"hit_count":0,"miss_count":0,"cache_size":0,"cache_count":0,"evictions":0},"fielddata":{"memory_size_in_bytes":0,"evictions":0},"completion":{"size_in_bytes":0},"segments":{"count":0,"memory_in_bytes":0,"terms_memory_in_bytes":0,"stored_fields_memory_in_bytes":0,"term_vectors_memory_in_bytes":0,"norms_memory_in_bytes":0,"points_memory_in_bytes":0,"doc_values_memory_in_bytes":0,"index_writer_memory_in_bytes":0,"version_map_memory_in_bytes":0,"fixed_bit_set_memory_in_bytes":0,"max_unsafe_auto_id_timestamp":-1,"file_sizes":{}},"translog":{"operations":0,"size_in_bytes":215},"request_cache":{"memory_size_in_bytes":0,"evictions":0,"hit_count":0,"miss_count":0},"recovery":{"current_as_source":0,"current_as_target":0,"throttle_time_in_millis":0}},"os":{"timestamp":1498820489400,"cpu":{"percent":0,"load_average":{"1m":0.35,"5m":0.28,"15m":0.12}},"mem":{"total_in_bytes":2096177152,"free_in_bytes":83501056,"used_in_bytes":2012676096,"free_percent":4,"used_percent":96},"swap":{"total_in_bytes":4195348480,"free_in_bytes":3487707136,"used_in_bytes":707641344}},"process":{"timestamp":1498820489400,"open_file_descriptors":139,"max_file_descriptors":1048576,"cpu":{"percent":0,"total_in_millis":26600},"mem":{"total_virtual_in_bytes":3823181824}},"jvm":{"timestamp":1498820489400,"uptime_in_millis":185693,"mem":{"heap_used_in_bytes":114959064,"heap_used_percent":5,"heap_committed_in_bytes":2130051072,"heap_max_in_bytes":2130051072,"non_heap_used_in_bytes":65471864,"non_heap_committed_in_bytes":69906432,"pools":{"young":{"used_in_bytes":82057312,"max_in_bytes":139591680,"peak_used_in_bytes":139591680,"peak_max_in_bytes":139591680},"survivor":{"used_in_bytes":17432576,"max_in_bytes":17432576,"peak_used_in_bytes":17432576,"peak_max_in_bytes":17432576},"old":{"used_in_bytes":15469176,"max_in_bytes":1973026816,"peak_used_in_bytes":15469176,"peak_max_in_bytes":1973026816}}},"threads":{"count":26,"peak_count":29},"gc":{"collectors":{"young":{"collection_count":4,"collection_time_in_millis":1618},"old":{"collection_count":1,"collection_time_in_millis":76}}},"buffer_pools":{"direct":{"count":16,"used_in_bytes":33776600,"total_capacity_in_bytes":33776599},"mapped":{"count":0,"used_in_bytes":0,"total_capacity_in_bytes":0}},"classes":{"current_loaded_count":9995,"total_loaded_count":9995,"total_unloaded_count":0}},"thread_pool":{"bulk":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_started":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_store":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"flush":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"force_merge":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"generic":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":28},"get":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"index":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"listener":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"management":{"threads":2,"queue":0,"active":1,"rejected":0,"largest":2,"completed":20},"refresh":{"threads":1,"queue":0,"active":0,"rejected":0,"largest":1,"completed":31},"search":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"snapshot":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"warmer":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0}},"fs":{"timestamp":1498820489401,"total":{"total_in_bytes":63375708160,"free_in_bytes":59668226048,"available_in_bytes":56425295872,"spins":"true"},"data":[{"path":"/usr/share/elasticsearch/data/nodes/0","mount":"/usr/share/elasticsearch/data (/dev/sda2)","type":"ext4","total_in_bytes":63375708160,"free_in_bytes":59668226048,"available_in_bytes":56425295872,"spins":"true"}],"io_stats":{"devices":[{"device_name":"sda2","operations":3017,"read_operations":1800,"write_operations":1217,"read_kilobytes":24816,"write_kilobytes":6580}],"total":{"operations":3017,"read_operations":1800,"write_operations":1217,"read_kilobytes":24816,"write_kilobytes":6580}}},"transport":{"server_open":0,"rx_count":0,"rx_size_in_bytes":0,"tx_count":0,"tx_size_in_bytes":0},"http":{"current_open":2,"total_opened":3},"breakers":{"request":{"limit_size_in_bytes":1278030643,"limit_size":"1.1gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0},"fielddata":{"limit_size_in_bytes":1278030643,"limit_size":"1.1gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.03,"tripped":0},"in_flight_requests":{"limit_size_in_bytes":2130051072,"limit_size":"1.9gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0},"parent":{"limit_size_in_bytes":1491035750,"limit_size":"1.3gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0}},"script":{"compilations":0,"cache_evictions":0},"discovery":{"cluster_state_queue":{"total":0,"pending":0,"committed":0}},"ingest":{"total":{"count":0,"time_in_millis":0,"current":0,"failed":0},"pipelines":{}}}}}`,
		"5.5.0": `{"_nodes":{"total":13,"successful":13,"failed":0},"cluster_name":"multinode","nodes":{"IAMD9JnLR4qOa-dl3cDaig":{"timestamp":1511714498349,"name":"elasticin-02","transport_address":"10.0.0.108:9300","host":"elasticin-02","ip":"10.0.0.108:9300","roles":["ingest"],"attributes":{"ml.enabled":"true"},"indices":{"docs":{"count":0,"deleted":0},"store":{"size_in_bytes":0,"throttle_time_in_millis":0},"indexing":{"index_total":0,"index_time_in_millis":0,"index_current":0,"index_failed":0,"delete_total":0,"delete_time_in_millis":0,"delete_current":0,"noop_update_total":0,"is_throttled":false,"throttle_time_in_millis":0},"get":{"total":0,"time_in_millis":0,"exists_total":0,"exists_time_in_millis":0,"missing_total":0,"missing_time_in_millis":0,"current":0},"search":{"open_contexts":0,"query_total":0,"query_time_in_millis":0,"query_current":0,"fetch_total":0,"fetch_time_in_millis":0,"fetch_current":0,"scroll_total":0,"scroll_time_in_millis":0,"scroll_current":0,"suggest_total":0,"suggest_time_in_millis":0,"suggest_current":0},"merges":{"current":0,"current_docs":0,"current_size_in_bytes":0,"total":0,"total_time_in_millis":0,"total_docs":0,"total_size_in_bytes":0,"total_stopped_time_in_millis":0,"total_throttled_time_in_millis":0,"total_auto_throttle_in_bytes":0},"refresh":{"total":0,"total_time_in_millis":0,"listeners":0},"flush":{"total":0,"total_time_in_millis":0},"warmer":{"current":0,"total":0,"total_time_in_millis":0},"query_cache":{"memory_size_in_bytes":0,"total_count":0,"hit_count":0,"miss_count":0,"cache_size":0,"cache_count":0,"evictions":0},"fielddata":{"memory_size_in_bytes":0,"evictions":0},"completion":{"size_in_bytes":0},"segments":{"count":0,"memory_in_bytes":0,"terms_memory_in_bytes":0,"stored_fields_memory_in_bytes":0,"term_vectors_memory_in_bytes":0,"norms_memory_in_bytes":0,"points_memory_in_bytes":0,"doc_values_memory_in_bytes":0,"index_writer_memory_in_bytes":0,"version_map_memory_in_bytes":0,"fixed_bit_set_memory_in_bytes":0,"max_unsafe_auto_id_timestamp":-9223372036854775808,"file_sizes":{}},"translog":{"operations":0,"size_in_bytes":0},"request_cache":{"memory_size_in_bytes":0,"evictions":0,"hit_count":0,"miss_count":0},"recovery":{"current_as_source":0,"current_as_target":0,"throttle_time_in_millis":0}},"os":{"timestamp":1511714497950,"cpu":{"percent":1,"load_average":{"1m":0.06,"5m":0.21,"15m":0.29}},"mem":{"total_in_bytes":8375726080,"free_in_bytes":545091584,"used_in_bytes":7830634496,"free_percent":7,"used_percent":93},"swap":{"total_in_bytes":1073737728,"free_in_bytes":1073737728,"used_in_bytes":0},"cgroup":{"cpuacct":{"control_group":"/","usage_nanos":37998635799304},"cpu":{"control_group":"/","cfs_period_micros":100000,"cfs_quota_micros":-1,"stat":{"number_of_elapsed_periods":0,"number_of_times_throttled":0,"time_throttled_nanos":0}}}},"process":{"timestamp":1511714497950,"open_file_descriptors":507,"max_file_descriptors":1048576,"cpu":{"percent":0,"total_in_millis":37998520},"mem":{"total_virtual_in_bytes":8281767936}},"jvm":{"timestamp":1511714497950,"uptime_in_millis":589198476,"mem":{"heap_used_in_bytes":1092031200,"heap_used_percent":25,"heap_committed_in_bytes":4260102144,"heap_max_in_bytes":4260102144,"non_heap_used_in_bytes":114726896,"non_heap_committed_in_bytes":121688064,"pools":{"young":{"used_in_bytes":158592080,"max_in_bytes":279183360,"peak_used_in_bytes":279183360,"peak_max_in_bytes":279183360},"survivor":{"used_in_bytes":2988992,"max_in_bytes":34865152,"peak_used_in_bytes":34865152,"peak_max_in_bytes":34865152},"old":{"used_in_bytes":930450128,"max_in_bytes":3946053632,"peak_used_in_bytes":3806199632,"peak_max_in_bytes":3946053632}}},"threads":{"count":60,"peak_count":185},"gc":{"collectors":{"young":{"collection_count":60237,"collection_time_in_millis":1196377},"old":{"collection_count":287,"collection_time_in_millis":38202}}},"buffer_pools":{"direct":{"count":40,"used_in_bytes":135831560,"total_capacity_in_bytes":135831559},"mapped":{"count":0,"used_in_bytes":0,"total_capacity_in_bytes":0}},"classes":{"current_loaded_count":13297,"total_loaded_count":13364,"total_unloaded_count":67}},"thread_pool":{"bulk":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":404400},"fetch_shard_started":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_store":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"flush":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"force_merge":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"generic":{"threads":8,"queue":0,"active":0,"rejected":0,"largest":128,"completed":765207},"get":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"index":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"listener":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"management":{"threads":5,"queue":0,"active":1,"rejected":0,"largest":5,"completed":1289143},"ml_autodetect":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_datafeed":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_utility":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"refresh":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"search":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"snapshot":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"warmer":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"watcher":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0}},"fs":{"timestamp":1511714497951,"total":{"total_in_bytes":39836917760,"free_in_bytes":35574710272,"available_in_bytes":33527472128,"spins":"true"},"data":[{"path":"/usr/share/elasticsearch/data/nodes/0","mount":"/ (overlay)","type":"overlay","total_in_bytes":39836917760,"free_in_bytes":35574710272,"available_in_bytes":33527472128,"spins":"true"}],"io_stats":{}},"transport":{"server_open":135,"rx_count":5047176,"rx_size_in_bytes":154154850912,"tx_count":5049542,"tx_size_in_bytes":228013049059},"http":{"current_open":2,"total_opened":581038},"breakers":{"request":{"limit_size_in_bytes":2556061286,"limit_size":"2.3gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0},"fielddata":{"limit_size_in_bytes":2556061286,"limit_size":"2.3gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.03,"tripped":0},"in_flight_requests":{"limit_size_in_bytes":4260102144,"limit_size":"3.9gb","estimated_size_in_bytes":1916,"estimated_size":"1.8kb","overhead":1.0,"tripped":0},"parent":{"limit_size_in_bytes":2982071500,"limit_size":"2.7gb","estimated_size_in_bytes":1916,"estimated_size":"1.8kb","overhead":1.0,"tripped":0}},"script":{"compilations":1,"cache_evictions":0},"discovery":{"cluster_state_queue":{"total":0,"pending":0,"committed":0}},"ingest":{"total":{"count":0,"time_in_millis":0,"current":0,"failed":0},"pipelines":{"xpack_monitoring_6":{"count":0,"time_in_millis":0,"current":0,"failed":0},"xpack_monitoring_2":{"count":0,"time_in_millis":0,"current":0,"failed":0}}}},"o9MvLOdySpmaelLxYnLJDg":{"timestamp":1511714498348,"name":"elasticmaster-01","transport_address":"10.0.0.150:9300","host":"elasticmaster-01","ip":"10.0.0.150:9300","roles":["master"],"attributes":{"ml.enabled":"true"},"indices":{"docs":{"count":0,"deleted":0},"store":{"size_in_bytes":0,"throttle_time_in_millis":0},"indexing":{"index_total":0,"index_time_in_millis":0,"index_current":0,"index_failed":0,"delete_total":0,"delete_time_in_millis":0,"delete_current":0,"noop_update_total":0,"is_throttled":false,"throttle_time_in_millis":0},"get":{"total":0,"time_in_millis":0,"exists_total":0,"exists_time_in_millis":0,"missing_total":0,"missing_time_in_millis":0,"current":0},"search":{"open_contexts":0,"query_total":0,"query_time_in_millis":0,"query_current":0,"fetch_total":0,"fetch_time_in_millis":0,"fetch_current":0,"scroll_total":0,"scroll_time_in_millis":0,"scroll_current":0,"suggest_total":0,"suggest_time_in_millis":0,"suggest_current":0},"merges":{"current":0,"current_docs":0,"current_size_in_bytes":0,"total":0,"total_time_in_millis":0,"total_docs":0,"total_size_in_bytes":0,"total_stopped_time_in_millis":0,"total_throttled_time_in_millis":0,"total_auto_throttle_in_bytes":0},"refresh":{"total":0,"total_time_in_millis":0,"listeners":0},"flush":{"total":0,"total_time_in_millis":0},"warmer":{"current":0,"total":0,"total_time_in_millis":0},"query_cache":{"memory_size_in_bytes":0,"total_count":0,"hit_count":0,"miss_count":0,"cache_size":0,"cache_count":0,"evictions":0},"fielddata":{"memory_size_in_bytes":0,"evictions":0},"completion":{"size_in_bytes":0},"segments":{"count":0,"memory_in_bytes":0,"terms_memory_in_bytes":0,"stored_fields_memory_in_bytes":0,"term_vectors_memory_in_bytes":0,"norms_memory_in_bytes":0,"points_memory_in_bytes":0,"doc_values_memory_in_bytes":0,"index_writer_memory_in_bytes":0,"version_map_memory_in_bytes":0,"fixed_bit_set_memory_in_bytes":0,"max_unsafe_auto_id_timestamp":-9223372036854775808,"file_sizes":{}},"translog":{"operations":0,"size_in_bytes":0},"request_cache":{"memory_size_in_bytes":0,"evictions":0,"hit_count":0,"miss_count":0},"recovery":{"current_as_source":0,"current_as_target":0,"throttle_time_in_millis":0}},"os":{"timestamp":1511714498349,"cpu":{"percent":44,"load_average":{"1m":0.25,"5m":0.33,"15m":0.25}},"mem":{"total_in_bytes":8375730176,"free_in_bytes":2545594368,"used_in_bytes":5830135808,"free_percent":30,"used_percent":70},"swap":{"total_in_bytes":1073737728,"free_in_bytes":1072058368,"used_in_bytes":1679360},"cgroup":{"cpuacct":{"control_group":"/","usage_nanos":20472909415977},"cpu":{"control_group":"/","cfs_period_micros":100000,"cfs_quota_micros":-1,"stat":{"number_of_elapsed_periods":0,"number_of_times_throttled":0,"time_throttled_nanos":0}}}},"process":{"timestamp":1511714498349,"open_file_descriptors":519,"max_file_descriptors":1048576,"cpu":{"percent":2,"total_in_millis":20472800},"mem":{"total_virtual_in_bytes":6048481280}},"jvm":{"timestamp":1511714498349,"uptime_in_millis":455012435,"mem":{"heap_used_in_bytes":1196945872,"heap_used_percent":56,"heap_committed_in_bytes":2112618496,"heap_max_in_bytes":2112618496,"non_heap_used_in_bytes":113206520,"non_heap_committed_in_bytes":120074240,"pools":{"young":{"used_in_bytes":109972848,"max_in_bytes":279183360,"peak_used_in_bytes":279183360,"peak_max_in_bytes":279183360},"survivor":{"used_in_bytes":2172240,"max_in_bytes":34865152,"peak_used_in_bytes":34865152,"peak_max_in_bytes":34865152},"old":{"used_in_bytes":1084800784,"max_in_bytes":1798569984,"peak_used_in_bytes":1798569984,"peak_max_in_bytes":1798569984}}},"threads":{"count":52,"peak_count":56},"gc":{"collectors":{"young":{"collection_count":32035,"collection_time_in_millis":355769},"old":{"collection_count":1002,"collection_time_in_millis":476417}}},"buffer_pools":{"direct":{"count":41,"used_in_bytes":135839401,"total_capacity_in_bytes":135839400},"mapped":{"count":0,"used_in_bytes":0,"total_capacity_in_bytes":0}},"classes":{"current_loaded_count":13299,"total_loaded_count":13359,"total_unloaded_count":60}},"thread_pool":{"bulk":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_started":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_store":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"flush":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"force_merge":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"generic":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":590358},"get":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"index":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"listener":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"management":{"threads":5,"queue":0,"active":1,"rejected":0,"largest":5,"completed":949237},"ml_autodetect":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_datafeed":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_utility":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"refresh":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"search":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"snapshot":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"warmer":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"watcher":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0}},"fs":{"timestamp":1511714498349,"total":{"total_in_bytes":39836917760,"free_in_bytes":27525136384,"available_in_bytes":25477898240,"spins":"true"},"data":[{"path":"/usr/share/elasticsearch/data/nodes/0","mount":"/ (overlay)","type":"overlay","total_in_bytes":39836917760,"free_in_bytes":27525136384,"available_in_bytes":25477898240,"spins":"true"}],"io_stats":{}},"transport":{"server_open":134,"rx_count":3128979,"rx_size_in_bytes":44609852501,"tx_count":3128980,"tx_size_in_bytes":91308571728},"http":{"current_open":2,"total_opened":407857},"breakers":{"request":{"limit_size_in_bytes":1267571097,"limit_size":"1.1gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0},"fielddata":{"limit_size_in_bytes":1267571097,"limit_size":"1.1gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.03,"tripped":0},"in_flight_requests":{"limit_size_in_bytes":2112618496,"limit_size":"1.9gb","estimated_size_in_bytes":1916,"estimated_size":"1.8kb","overhead":1.0,"tripped":0},"parent":{"limit_size_in_bytes":1478832947,"limit_size":"1.3gb","estimated_size_in_bytes":1916,"estimated_size":"1.8kb","overhead":1.0,"tripped":0}},"script":{"compilations":1,"cache_evictions":0},"discovery":{"cluster_state_queue":{"total":0,"pending":0,"committed":0}},"ingest":{"total":{"count":0,"time_in_millis":0,"current":0,"failed":0},"pipelines":{"xpack_monitoring_2":{"count":0,"time_in_millis":0,"current":0,"failed":0},"xpack_monitoring_6":{"count":0,"time_in_millis":0,"current":0,"failed":0}}}},"QJMwXyZDTVaEupifVTFAXg":{"timestamp":1511714498348,"name":"elasticmaster-03","transport_address":"10.0.0.57:9300","host":"elasticmaster-03","ip":"10.0.0.57:9300","roles":["master"],"attributes":{"ml.enabled":"true"},"indices":{"docs":{"count":0,"deleted":0},"store":{"size_in_bytes":0,"throttle_time_in_millis":0},"indexing":{"index_total":0,"index_time_in_millis":0,"index_current":0,"index_failed":0,"delete_total":0,"delete_time_in_millis":0,"delete_current":0,"noop_update_total":0,"is_throttled":false,"throttle_time_in_millis":0},"get":{"total":0,"time_in_millis":0,"exists_total":0,"exists_time_in_millis":0,"missing_total":0,"missing_time_in_millis":0,"current":0},"search":{"open_contexts":0,"query_total":0,"query_time_in_millis":0,"query_current":0,"fetch_total":0,"fetch_time_in_millis":0,"fetch_current":0,"scroll_total":0,"scroll_time_in_millis":0,"scroll_current":0,"suggest_total":0,"suggest_time_in_millis":0,"suggest_current":0},"merges":{"current":0,"current_docs":0,"current_size_in_bytes":0,"total":0,"total_time_in_millis":0,"total_docs":0,"total_size_in_bytes":0,"total_stopped_time_in_millis":0,"total_throttled_time_in_millis":0,"total_auto_throttle_in_bytes":0},"refresh":{"total":0,"total_time_in_millis":0,"listeners":0},"flush":{"total":0,"total_time_in_millis":0},"warmer":{"current":0,"total":0,"total_time_in_millis":0},"query_cache":{"memory_size_in_bytes":0,"total_count":0,"hit_count":0,"miss_count":0,"cache_size":0,"cache_count":0,"evictions":0},"fielddata":{"memory_size_in_bytes":0,"evictions":0},"completion":{"size_in_bytes":0},"segments":{"count":0,"memory_in_bytes":0,"terms_memory_in_bytes":0,"stored_fields_memory_in_bytes":0,"term_vectors_memory_in_bytes":0,"norms_memory_in_bytes":0,"points_memory_in_bytes":0,"doc_values_memory_in_bytes":0,"index_writer_memory_in_bytes":0,"version_map_memory_in_bytes":0,"fixed_bit_set_memory_in_bytes":0,"max_unsafe_auto_id_timestamp":-9223372036854775808,"file_sizes":{}},"translog":{"operations":0,"size_in_bytes":0},"request_cache":{"memory_size_in_bytes":0,"evictions":0,"hit_count":0,"miss_count":0},"recovery":{"current_as_source":0,"current_as_target":0,"throttle_time_in_millis":0}},"os":{"timestamp":1511714497945,"cpu":{"percent":23,"load_average":{"1m":0.81,"5m":0.67,"15m":0.53}},"mem":{"total_in_bytes":8375726080,"free_in_bytes":2463612928,"used_in_bytes":5912113152,"free_percent":29,"used_percent":71},"swap":{"total_in_bytes":1073737728,"free_in_bytes":1071788032,"used_in_bytes":1949696},"cgroup":{"cpuacct":{"control_group":"/","usage_nanos":72007272720599},"cpu":{"control_group":"/","cfs_period_micros":100000,"cfs_quota_micros":-1,"stat":{"number_of_elapsed_periods":0,"number_of_times_throttled":0,"time_throttled_nanos":0}}}},"process":{"timestamp":1511714497945,"open_file_descriptors":519,"max_file_descriptors":1048576,"cpu":{"percent":0,"total_in_millis":72007150},"mem":{"total_virtual_in_bytes":6073102336}},"jvm":{"timestamp":1511714497945,"uptime_in_millis":456828928,"mem":{"heap_used_in_bytes":830571920,"heap_used_percent":39,"heap_committed_in_bytes":2112618496,"heap_max_in_bytes":2112618496,"non_heap_used_in_bytes":131650000,"non_heap_committed_in_bytes":140623872,"pools":{"young":{"used_in_bytes":42273680,"max_in_bytes":279183360,"peak_used_in_bytes":279183360,"peak_max_in_bytes":279183360},"survivor":{"used_in_bytes":8297248,"max_in_bytes":34865152,"peak_used_in_bytes":34865152,"peak_max_in_bytes":34865152},"old":{"used_in_bytes":780000992,"max_in_bytes":1798569984,"peak_used_in_bytes":1798569984,"peak_max_in_bytes":1798569984}}},"threads":{"count":74,"peak_count":75},"gc":{"collectors":{"young":{"collection_count":187631,"collection_time_in_millis":2346463},"old":{"collection_count":1570,"collection_time_in_millis":494403}}},"buffer_pools":{"direct":{"count":41,"used_in_bytes":135839383,"total_capacity_in_bytes":135839382},"mapped":{"count":0,"used_in_bytes":0,"total_capacity_in_bytes":0}},"classes":{"current_loaded_count":14015,"total_loaded_count":14100,"total_unloaded_count":85}},"thread_pool":{"bulk":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_started":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_store":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"flush":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"force_merge":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"generic":{"threads":18,"queue":0,"active":1,"rejected":0,"largest":18,"completed":592984},"get":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"index":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"listener":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"management":{"threads":5,"queue":0,"active":1,"rejected":0,"largest":5,"completed":1026939},"ml_autodetect":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_datafeed":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_utility":{"threads":5,"queue":0,"active":0,"rejected":0,"largest":5,"completed":5},"refresh":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"search":{"threads":2,"queue":0,"active":0,"rejected":0,"largest":2,"completed":2},"snapshot":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"warmer":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"watcher":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0}},"fs":{"timestamp":1511714497945,"total":{"total_in_bytes":39836917760,"free_in_bytes":31222030336,"available_in_bytes":29174792192,"spins":"true"},"data":[{"path":"/usr/share/elasticsearch/data/nodes/0","mount":"/ (overlay)","type":"overlay","total_in_bytes":39836917760,"free_in_bytes":31222030336,"available_in_bytes":29174792192,"spins":"true"}],"io_stats":{}},"transport":{"server_open":134,"rx_count":17417277,"rx_size_in_bytes":388077081117,"tx_count":17417313,"tx_size_in_bytes":320472005934},"http":{"current_open":2,"total_opened":407233},"breakers":{"request":{"limit_size_in_bytes":1267571097,"limit_size":"1.1gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0},"fielddata":{"limit_size_in_bytes":1267571097,"limit_size":"1.1gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.03,"tripped":0},"in_flight_requests":{"limit_size_in_bytes":2112618496,"limit_size":"1.9gb","estimated_size_in_bytes":1916,"estimated_size":"1.8kb","overhead":1.0,"tripped":0},"parent":{"limit_size_in_bytes":1478832947,"limit_size":"1.3gb","estimated_size_in_bytes":1916,"estimated_size":"1.8kb","overhead":1.0,"tripped":0}},"script":{"compilations":1,"cache_evictions":0},"discovery":{"cluster_state_queue":{"total":0,"pending":0,"committed":0}},"ingest":{"total":{"count":0,"time_in_millis":0,"current":0,"failed":0},"pipelines":{"xpack_monitoring_2":{"count":0,"time_in_millis":0,"current":0,"failed":0},"xpack_monitoring_6":{"count":0,"time_in_millis":0,"current":0,"failed":0}}}},"EN05ytfQQvStXdW4Q6RatA":{"timestamp":1511714498348,"name":"elasticdata-01","transport_address":"10.0.0.119:9300","host":"elasticdata-01","ip":"10.0.0.119:9300","roles":["data"],"attributes":{"ml.enabled":"true"},"indices":{"docs":{"count":375322138,"deleted":1037878},"store":{"size_in_bytes":259394317595,"throttle_time_in_millis":0},"indexing":{"index_total":448977978,"index_time_in_millis":118716971,"index_current":0,"index_failed":0,"delete_total":0,"delete_time_in_millis":0,"delete_current":0,"noop_update_total":0,"is_throttled":false,"throttle_time_in_millis":0},"get":{"total":11762,"time_in_millis":941,"exists_total":11762,"exists_time_in_millis":941,"missing_total":0,"missing_time_in_millis":0,"current":0},"search":{"open_contexts":0,"query_total":482173,"query_time_in_millis":3748653,"query_current":0,"fetch_total":21577,"fetch_time_in_millis":528409,"fetch_current":0,"scroll_total":2,"scroll_time_in_millis":188893,"scroll_current":0,"suggest_total":0,"suggest_time_in_millis":0,"suggest_current":0},"merges":{"current":2,"current_docs":9550,"current_size_in_bytes":6050542,"total":169074,"total_time_in_millis":105409372,"total_docs":1390928712,"total_size_in_bytes":869934290826,"total_stopped_time_in_millis":0,"total_throttled_time_in_millis":50576302,"total_auto_throttle_in_bytes":14087997090},"refresh":{"total":1476283,"total_time_in_millis":27373898,"listeners":0},"flush":{"total":1184,"total_time_in_millis":518446},"warmer":{"current":0,"total":1441617,"total_time_in_millis":520582},"query_cache":{"memory_size_in_bytes":154620318,"total_count":1276959,"hit_count":655594,"miss_count":621365,"cache_size":8688,"cache_count":11271,"evictions":2583},"fielddata":{"memory_size_in_bytes":50488,"evictions":0},"completion":{"size_in_bytes":0},"segments":{"count":4460,"memory_in_bytes":906650903,"terms_memory_in_bytes":814497094,"stored_fields_memory_in_bytes":62547264,"term_vectors_memory_in_bytes":0,"norms_memory_in_bytes":8536576,"points_memory_in_bytes":4277057,"doc_values_memory_in_bytes":16792912,"index_writer_memory_in_bytes":0,"version_map_memory_in_bytes":0,"fixed_bit_set_memory_in_bytes":192,"max_unsafe_auto_id_timestamp":1511481600647,"file_sizes":{}},"translog":{"operations":3209732,"size_in_bytes":3144619388},"request_cache":{"memory_size_in_bytes":162916154,"evictions":12109,"hit_count":19313,"miss_count":37864},"recovery":{"current_as_source":0,"current_as_target":0,"throttle_time_in_millis":743800}},"os":{"timestamp":1511714497945,"cpu":{"percent":5,"load_average":{"1m":0.98,"5m":0.92,"15m":0.81}},"mem":{"total_in_bytes":33742192640,"free_in_bytes":1784082432,"used_in_bytes":31958110208,"free_percent":5,"used_percent":95},"swap":{"total_in_bytes":1073737728,"free_in_bytes":791388160,"used_in_bytes":282349568},"cgroup":{"cpuacct":{"control_group":"/","usage_nanos":377534011797418},"cpu":{"control_group":"/","cfs_period_micros":100000,"cfs_quota_micros":-1,"stat":{"number_of_elapsed_periods":0,"number_of_times_throttled":0,"time_throttled_nanos":0}}}},"process":{"timestamp":1511714497945,"open_file_descriptors":1341,"max_file_descriptors":1048576,"cpu":{"percent":4,"total_in_millis":377531950},"mem":{"total_virtual_in_bytes":281489690624}},"jvm":{"timestamp":1511714497946,"uptime_in_millis":456177136,"mem":{"heap_used_in_bytes":12360895776,"heap_used_percent":72,"heap_committed_in_bytes":17110138880,"heap_max_in_bytes":17110138880,"non_heap_used_in_bytes":169873944,"non_heap_committed_in_bytes":179277824,"pools":{"young":{"used_in_bytes":418031976,"max_in_bytes":558432256,"peak_used_in_bytes":558432256,"peak_max_in_bytes":558432256},"survivor":{"used_in_bytes":41567680,"max_in_bytes":69730304,"peak_used_in_bytes":69730304,"peak_max_in_bytes":69730304},"old":{"used_in_bytes":11901296120,"max_in_bytes":16481976320,"peak_used_in_bytes":12805122832,"peak_max_in_bytes":16481976320}}},"threads":{"count":134,"peak_count":141},"gc":{"collectors":{"young":{"collection_count":138863,"collection_time_in_millis":4901025},"old":{"collection_count":109,"collection_time_in_millis":28223}}},"buffer_pools":{"direct":{"count":153,"used_in_bytes":272389833,"total_capacity_in_bytes":272389832},"mapped":{"count":9987,"used_in_bytes":257693104518,"total_capacity_in_bytes":257693104518}},"classes":{"current_loaded_count":15279,"total_loaded_count":15425,"total_unloaded_count":146}},"thread_pool":{"bulk":{"threads":8,"queue":0,"active":0,"rejected":8829,"largest":8,"completed":4533781},"fetch_shard_started":{"threads":1,"queue":0,"active":0,"rejected":0,"largest":1,"completed":1},"fetch_shard_store":{"threads":1,"queue":0,"active":0,"rejected":0,"largest":16,"completed":527},"flush":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":183951},"force_merge":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"generic":{"threads":16,"queue":0,"active":0,"rejected":0,"largest":16,"completed":685858},"get":{"threads":8,"queue":0,"active":0,"rejected":0,"largest":8,"completed":11757},"index":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"listener":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"management":{"threads":5,"queue":0,"active":2,"rejected":0,"largest":5,"completed":1482328},"ml_autodetect":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_datafeed":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_utility":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"refresh":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":96747907},"search":{"threads":13,"queue":0,"active":0,"rejected":0,"largest":13,"completed":492085},"snapshot":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"warmer":{"threads":3,"queue":0,"active":0,"rejected":0,"largest":3,"completed":1478002},"watcher":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0}},"fs":{"timestamp":1511714497946,"total":{"total_in_bytes":528311836672,"free_in_bytes":259901870080,"available_in_bytes":233041600512,"spins":"true"},"data":[{"path":"/mnt/data/nodes/0","mount":"/mnt/data (/dev/sdb1)","type":"ext4","total_in_bytes":528311836672,"free_in_bytes":259901870080,"available_in_bytes":233041600512,"spins":"true"}],"io_stats":{"devices":[{"device_name":"sdb1","operations":21613740,"read_operations":757427,"write_operations":20856313,"read_kilobytes":82400388,"write_kilobytes":1355771052}],"total":{"operations":21613740,"read_operations":757427,"write_operations":20856313,"read_kilobytes":82400388,"write_kilobytes":1355771052}}},"transport":{"server_open":133,"rx_count":11869543,"rx_size_in_bytes":477850961639,"tx_count":11869509,"tx_size_in_bytes":538588051057},"http":{"current_open":2,"total_opened":396888},"breakers":{"request":{"limit_size_in_bytes":10266083328,"limit_size":"9.5gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0},"fielddata":{"limit_size_in_bytes":10266083328,"limit_size":"9.5gb","estimated_size_in_bytes":50488,"estimated_size":"49.3kb","overhead":1.03,"tripped":0},"in_flight_requests":{"limit_size_in_bytes":17110138880,"limit_size":"15.9gb","estimated_size_in_bytes":38028,"estimated_size":"37.1kb","overhead":1.0,"tripped":0},"parent":{"limit_size_in_bytes":11977097216,"limit_size":"11.1gb","estimated_size_in_bytes":88516,"estimated_size":"86.4kb","overhead":1.0,"tripped":0}},"script":{"compilations":1,"cache_evictions":0},"discovery":{"cluster_state_queue":{"total":0,"pending":0,"committed":0}},"ingest":{"total":{"count":0,"time_in_millis":0,"current":0,"failed":0},"pipelines":{"xpack_monitoring_2":{"count":0,"time_in_millis":0,"current":0,"failed":0},"xpack_monitoring_6":{"count":0,"time_in_millis":0,"current":0,"failed":0}}}},"CC7h3_tGQTm7sUk0sMAPjg":{"timestamp":1511714498349,"name":"elasticmaster-02","transport_address":"10.0.0.149:9300","host":"elasticmaster-02","ip":"10.0.0.149:9300","roles":["master"],"attributes":{"ml.enabled":"true"},"indices":{"docs":{"count":0,"deleted":0},"store":{"size_in_bytes":0,"throttle_time_in_millis":0},"indexing":{"index_total":0,"index_time_in_millis":0,"index_current":0,"index_failed":0,"delete_total":0,"delete_time_in_millis":0,"delete_current":0,"noop_update_total":0,"is_throttled":false,"throttle_time_in_millis":0},"get":{"total":0,"time_in_millis":0,"exists_total":0,"exists_time_in_millis":0,"missing_total":0,"missing_time_in_millis":0,"current":0},"search":{"open_contexts":0,"query_total":0,"query_time_in_millis":0,"query_current":0,"fetch_total":0,"fetch_time_in_millis":0,"fetch_current":0,"scroll_total":0,"scroll_time_in_millis":0,"scroll_current":0,"suggest_total":0,"suggest_time_in_millis":0,"suggest_current":0},"merges":{"current":0,"current_docs":0,"current_size_in_bytes":0,"total":0,"total_time_in_millis":0,"total_docs":0,"total_size_in_bytes":0,"total_stopped_time_in_millis":0,"total_throttled_time_in_millis":0,"total_auto_throttle_in_bytes":0},"refresh":{"total":0,"total_time_in_millis":0,"listeners":0},"flush":{"total":0,"total_time_in_millis":0},"warmer":{"current":0,"total":0,"total_time_in_millis":0},"query_cache":{"memory_size_in_bytes":0,"total_count":0,"hit_count":0,"miss_count":0,"cache_size":0,"cache_count":0,"evictions":0},"fielddata":{"memory_size_in_bytes":0,"evictions":0},"completion":{"size_in_bytes":0},"segments":{"count":0,"memory_in_bytes":0,"terms_memory_in_bytes":0,"stored_fields_memory_in_bytes":0,"term_vectors_memory_in_bytes":0,"norms_memory_in_bytes":0,"points_memory_in_bytes":0,"doc_values_memory_in_bytes":0,"index_writer_memory_in_bytes":0,"version_map_memory_in_bytes":0,"fixed_bit_set_memory_in_bytes":0,"max_unsafe_auto_id_timestamp":-9223372036854775808,"file_sizes":{}},"translog":{"operations":0,"size_in_bytes":0},"request_cache":{"memory_size_in_bytes":0,"evictions":0,"hit_count":0,"miss_count":0},"recovery":{"current_as_source":0,"current_as_target":0,"throttle_time_in_millis":0}},"os":{"timestamp":1511714497946,"cpu":{"percent":11,"load_average":{"1m":0.04,"5m":0.03,"15m":0.05}},"mem":{"total_in_bytes":8375726080,"free_in_bytes":2514419712,"used_in_bytes":5861306368,"free_percent":30,"used_percent":70},"swap":{"total_in_bytes":1073737728,"free_in_bytes":1070624768,"used_in_bytes":3112960},"cgroup":{"cpuacct":{"control_group":"/","usage_nanos":15116859468711},"cpu":{"control_group":"/","cfs_period_micros":100000,"cfs_quota_micros":-1,"stat":{"number_of_elapsed_periods":0,"number_of_times_throttled":0,"time_throttled_nanos":0}}}},"process":{"timestamp":1511714497946,"open_file_descriptors":519,"max_file_descriptors":1048576,"cpu":{"percent":0,"total_in_millis":15116720},"mem":{"total_virtual_in_bytes":6050123776}},"jvm":{"timestamp":1511714497946,"uptime_in_millis":439476155,"mem":{"heap_used_in_bytes":723824488,"heap_used_percent":34,"heap_committed_in_bytes":2112618496,"heap_max_in_bytes":2112618496,"non_heap_used_in_bytes":111904440,"non_heap_committed_in_bytes":119291904,"pools":{"young":{"used_in_bytes":215917352,"max_in_bytes":279183360,"peak_used_in_bytes":279183360,"peak_max_in_bytes":279183360},"survivor":{"used_in_bytes":6213480,"max_in_bytes":34865152,"peak_used_in_bytes":34865152,"peak_max_in_bytes":34865152},"old":{"used_in_bytes":501693656,"max_in_bytes":1798569984,"peak_used_in_bytes":1669293512,"peak_max_in_bytes":1798569984}}},"threads":{"count":52,"peak_count":57},"gc":{"collectors":{"young":{"collection_count":21247,"collection_time_in_millis":216235},"old":{"collection_count":155,"collection_time_in_millis":16680}}},"buffer_pools":{"direct":{"count":41,"used_in_bytes":135839407,"total_capacity_in_bytes":135839406},"mapped":{"count":0,"used_in_bytes":0,"total_capacity_in_bytes":0}},"classes":{"current_loaded_count":13220,"total_loaded_count":13275,"total_unloaded_count":55}},"thread_pool":{"bulk":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_started":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_store":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"flush":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"force_merge":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"generic":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":570794},"get":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"index":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"listener":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"management":{"threads":5,"queue":0,"active":1,"rejected":0,"largest":5,"completed":896859},"ml_autodetect":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_datafeed":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_utility":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"refresh":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"search":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"snapshot":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"warmer":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"watcher":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0}},"fs":{"timestamp":1511714497946,"total":{"total_in_bytes":39836917760,"free_in_bytes":24176267264,"available_in_bytes":22129029120,"spins":"true"},"data":[{"path":"/usr/share/elasticsearch/data/nodes/0","mount":"/ (overlay)","type":"overlay","total_in_bytes":39836917760,"free_in_bytes":24176267264,"available_in_bytes":22129029120,"spins":"true"}],"io_stats":{}},"transport":{"server_open":134,"rx_count":2973754,"rx_size_in_bytes":41620665024,"tx_count":2973754,"tx_size_in_bytes":68323082688},"http":{"current_open":2,"total_opened":389190},"breakers":{"request":{"limit_size_in_bytes":1267571097,"limit_size":"1.1gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0},"fielddata":{"limit_size_in_bytes":1267571097,"limit_size":"1.1gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.03,"tripped":0},"in_flight_requests":{"limit_size_in_bytes":2112618496,"limit_size":"1.9gb","estimated_size_in_bytes":1916,"estimated_size":"1.8kb","overhead":1.0,"tripped":0},"parent":{"limit_size_in_bytes":1478832947,"limit_size":"1.3gb","estimated_size_in_bytes":1916,"estimated_size":"1.8kb","overhead":1.0,"tripped":0}},"script":{"compilations":1,"cache_evictions":0},"discovery":{"cluster_state_queue":{"total":0,"pending":0,"committed":0}},"ingest":{"total":{"count":0,"time_in_millis":0,"current":0,"failed":0},"pipelines":{"xpack_monitoring_2":{"count":0,"time_in_millis":0,"current":0,"failed":0},"xpack_monitoring_6":{"count":0,"time_in_millis":0,"current":0,"failed":0}}}},"Pc2mK8pWQ9icfpJRpEqLWw":{"timestamp":1511714498348,"name":"elasticdata-04","transport_address":"10.0.0.56:9300","host":"elasticdata-04","ip":"10.0.0.56:9300","roles":["data"],"attributes":{"ml.enabled":"true"},"indices":{"docs":{"count":425699379,"deleted":1373715},"store":{"size_in_bytes":296033664114,"throttle_time_in_millis":0},"indexing":{"index_total":642934027,"index_time_in_millis":171016063,"index_current":0,"index_failed":35069830,"delete_total":1721,"delete_time_in_millis":132,"delete_current":0,"noop_update_total":2,"is_throttled":false,"throttle_time_in_millis":0},"get":{"total":15655,"time_in_millis":905,"exists_total":15647,"exists_time_in_millis":905,"missing_total":8,"missing_time_in_millis":0,"current":0},"search":{"open_contexts":0,"query_total":650749,"query_time_in_millis":3957392,"query_current":0,"fetch_total":21133,"fetch_time_in_millis":611629,"fetch_current":0,"scroll_total":49,"scroll_time_in_millis":2195819,"scroll_current":0,"suggest_total":0,"suggest_time_in_millis":0,"suggest_current":0},"merges":{"current":0,"current_docs":0,"current_size_in_bytes":0,"total":208750,"total_time_in_millis":151039152,"total_docs":1916131698,"total_size_in_bytes":1226965745190,"total_stopped_time_in_millis":0,"total_throttled_time_in_millis":83417760,"total_auto_throttle_in_bytes":41028302003},"refresh":{"total":1825950,"total_time_in_millis":35474740,"listeners":0},"flush":{"total":3138,"total_time_in_millis":707216},"warmer":{"current":0,"total":1453839,"total_time_in_millis":657162},"query_cache":{"memory_size_in_bytes":87457278,"total_count":479101,"hit_count":109644,"miss_count":369457,"cache_size":15020,"cache_count":15792,"evictions":772},"fielddata":{"memory_size_in_bytes":0,"evictions":0},"completion":{"size_in_bytes":0},"segments":{"count":4558,"memory_in_bytes":1094352149,"terms_memory_in_bytes":997400697,"stored_fields_memory_in_bytes":72061816,"term_vectors_memory_in_bytes":0,"norms_memory_in_bytes":8919296,"points_memory_in_bytes":2447676,"doc_values_memory_in_bytes":13522664,"index_writer_memory_in_bytes":2321128,"version_map_memory_in_bytes":10230,"fixed_bit_set_memory_in_bytes":96,"max_unsafe_auto_id_timestamp":1511222737106,"file_sizes":{}},"translog":{"operations":4076380,"size_in_bytes":3763408908},"request_cache":{"memory_size_in_bytes":522081,"evictions":0,"hit_count":1057,"miss_count":715},"recovery":{"current_as_source":0,"current_as_target":0,"throttle_time_in_millis":6095665}},"os":{"timestamp":1511714497945,"cpu":{"percent":8,"load_average":{"1m":0.49,"5m":0.75,"15m":0.83}},"mem":{"total_in_bytes":33742192640,"free_in_bytes":326279168,"used_in_bytes":33415913472,"free_percent":1,"used_percent":99},"swap":{"total_in_bytes":1073737728,"free_in_bytes":734015488,"used_in_bytes":339722240},"cgroup":{"cpuacct":{"control_group":"/","usage_nanos":505471512208338},"cpu":{"control_group":"/","cfs_period_micros":100000,"cfs_quota_micros":-1,"stat":{"number_of_elapsed_periods":0,"number_of_times_throttled":0,"time_throttled_nanos":0}}}},"process":{"timestamp":1511714497945,"open_file_descriptors":1495,"max_file_descriptors":1048576,"cpu":{"percent":8,"total_in_millis":505469110},"mem":{"total_virtual_in_bytes":317985972224}},"jvm":{"timestamp":1511714497946,"uptime_in_millis":584091461,"mem":{"heap_used_in_bytes":8628353304,"heap_used_percent":50,"heap_committed_in_bytes":17110138880,"heap_max_in_bytes":17110138880,"non_heap_used_in_bytes":182671192,"non_heap_committed_in_bytes":192577536,"pools":{"young":{"used_in_bytes":318839256,"max_in_bytes":558432256,"peak_used_in_bytes":558432256,"peak_max_in_bytes":558432256},"survivor":{"used_in_bytes":25041808,"max_in_bytes":69730304,"peak_used_in_bytes":69730304,"peak_max_in_bytes":69730304},"old":{"used_in_bytes":8284472240,"max_in_bytes":16481976320,"peak_used_in_bytes":16481976320,"peak_max_in_bytes":16481976320}}},"threads":{"count":140,"peak_count":220},"gc":{"collectors":{"young":{"collection_count":198328,"collection_time_in_millis":7115355},"old":{"collection_count":229,"collection_time_in_millis":602402}}},"buffer_pools":{"direct":{"count":143,"used_in_bytes":272254590,"total_capacity_in_bytes":272254589},"mapped":{"count":10120,"used_in_bytes":293958375802,"total_capacity_in_bytes":293958375802}},"classes":{"current_loaded_count":15336,"total_loaded_count":15495,"total_unloaded_count":159}},"thread_pool":{"bulk":{"threads":8,"queue":0,"active":0,"rejected":106834,"largest":8,"completed":6643785},"fetch_shard_started":{"threads":1,"queue":0,"active":0,"rejected":0,"largest":16,"completed":2854},"fetch_shard_store":{"threads":1,"queue":0,"active":0,"rejected":0,"largest":16,"completed":10424},"flush":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":234813},"force_merge":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"generic":{"threads":12,"queue":0,"active":0,"rejected":0,"largest":60,"completed":1065873},"get":{"threads":8,"queue":0,"active":0,"rejected":0,"largest":8,"completed":15629},"index":{"threads":8,"queue":0,"active":0,"rejected":0,"largest":8,"completed":12},"listener":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"management":{"threads":5,"queue":0,"active":2,"rejected":0,"largest":5,"completed":1911527},"ml_autodetect":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_datafeed":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_utility":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"refresh":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":124094775},"search":{"threads":13,"queue":0,"active":0,"rejected":0,"largest":13,"completed":657456},"snapshot":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"warmer":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":1831272},"watcher":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0}},"fs":{"timestamp":1511714497946,"total":{"total_in_bytes":528310788096,"free_in_bytes":219653083136,"available_in_bytes":219636305920,"spins":"true"},"data":[{"path":"/mnt/data/nodes/0","mount":"/mnt/data (/dev/sdb1)","type":"ext4","total_in_bytes":528310788096,"free_in_bytes":219653083136,"available_in_bytes":219636305920,"spins":"true"}],"io_stats":{"devices":[{"device_name":"sdb1","operations":34428907,"read_operations":4433749,"write_operations":29995158,"read_kilobytes":530811024,"write_kilobytes":2036811840}],"total":{"operations":34428907,"read_operations":4433749,"write_operations":29995158,"read_kilobytes":530811024,"write_kilobytes":2036811840}}},"transport":{"server_open":133,"rx_count":16198439,"rx_size_in_bytes":900601319307,"tx_count":16201772,"tx_size_in_bytes":1162809703365},"http":{"current_open":2,"total_opened":498058},"breakers":{"request":{"limit_size_in_bytes":10266083328,"limit_size":"9.5gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0},"fielddata":{"limit_size_in_bytes":10266083328,"limit_size":"9.5gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.03,"tripped":0},"in_flight_requests":{"limit_size_in_bytes":17110138880,"limit_size":"15.9gb","estimated_size_in_bytes":38013,"estimated_size":"37.1kb","overhead":1.0,"tripped":0},"parent":{"limit_size_in_bytes":11977097216,"limit_size":"11.1gb","estimated_size_in_bytes":38013,"estimated_size":"37.1kb","overhead":1.0,"tripped":0}},"script":{"compilations":1,"cache_evictions":0},"discovery":{"cluster_state_queue":{"total":0,"pending":0,"committed":0}},"ingest":{"total":{"count":0,"time_in_millis":0,"current":0,"failed":0},"pipelines":{"xpack_monitoring_6":{"count":0,"time_in_millis":0,"current":0,"failed":0},"xpack_monitoring_2":{"count":0,"time_in_millis":0,"current":0,"failed":0}}}},"vQxBfSGXTuyFRZ0qVrNrDA":{"timestamp":1511714498348,"name":"elasticdata-05","transport_address":"10.0.0.98:9300","host":"elasticdata-05","ip":"10.0.0.98:9300","roles":["data"],"attributes":{"ml.enabled":"true"},"indices":{"docs":{"count":464562958,"deleted":1135485},"store":{"size_in_bytes":293883305118,"throttle_time_in_millis":0},"indexing":{"index_total":332603493,"index_time_in_millis":105361198,"index_current":0,"index_failed":0,"delete_total":0,"delete_time_in_millis":0,"delete_current":0,"noop_update_total":0,"is_throttled":false,"throttle_time_in_millis":0},"get":{"total":166531,"time_in_millis":13112,"exists_total":166531,"exists_time_in_millis":13112,"missing_total":0,"missing_time_in_millis":0,"current":0},"search":{"open_contexts":0,"query_total":654756,"query_time_in_millis":3925477,"query_current":0,"fetch_total":168250,"fetch_time_in_millis":168976,"fetch_current":0,"scroll_total":1,"scroll_time_in_millis":93623,"scroll_current":0,"suggest_total":0,"suggest_time_in_millis":0,"suggest_current":0},"merges":{"current":0,"current_docs":0,"current_size_in_bytes":0,"total":166059,"total_time_in_millis":126117143,"total_docs":1332039112,"total_size_in_bytes":927972166158,"total_stopped_time_in_millis":0,"total_throttled_time_in_millis":71787253,"total_auto_throttle_in_bytes":9894986790},"refresh":{"total":1435483,"total_time_in_millis":25368823,"listeners":0},"flush":{"total":966,"total_time_in_millis":304725},"warmer":{"current":0,"total":1429821,"total_time_in_millis":655606},"query_cache":{"memory_size_in_bytes":58846620,"total_count":962195,"hit_count":493138,"miss_count":469057,"cache_size":15951,"cache_count":16868,"evictions":917},"fielddata":{"memory_size_in_bytes":50008,"evictions":0},"completion":{"size_in_bytes":0},"segments":{"count":4349,"memory_in_bytes":1064790107,"terms_memory_in_bytes":968028700,"stored_fields_memory_in_bytes":69207552,"term_vectors_memory_in_bytes":0,"norms_memory_in_bytes":8031040,"points_memory_in_bytes":4115219,"doc_values_memory_in_bytes":15407596,"index_writer_memory_in_bytes":2463588,"version_map_memory_in_bytes":9020,"fixed_bit_set_memory_in_bytes":680,"max_unsafe_auto_id_timestamp":1511291784471,"file_sizes":{}},"translog":{"operations":3779808,"size_in_bytes":3315625571},"request_cache":{"memory_size_in_bytes":163650616,"evictions":0,"hit_count":24539,"miss_count":33213},"recovery":{"current_as_source":0,"current_as_target":0,"throttle_time_in_millis":2115817}},"os":{"timestamp":1511714497945,"cpu":{"percent":9,"load_average":{"1m":0.78,"5m":0.81,"15m":0.96}},"mem":{"total_in_bytes":33742192640,"free_in_bytes":398262272,"used_in_bytes":33343930368,"free_percent":1,"used_percent":99},"swap":{"total_in_bytes":1073737728,"free_in_bytes":759992320,"used_in_bytes":313745408},"cgroup":{"cpuacct":{"control_group":"/","usage_nanos":354202797708211},"cpu":{"control_group":"/","cfs_period_micros":100000,"cfs_quota_micros":-1,"stat":{"number_of_elapsed_periods":0,"number_of_times_throttled":0,"time_throttled_nanos":0}}}},"process":{"timestamp":1511714497945,"open_file_descriptors":1342,"max_file_descriptors":1048576,"cpu":{"percent":6,"total_in_millis":354200650},"mem":{"total_virtual_in_bytes":315156033536}},"jvm":{"timestamp":1511714497946,"uptime_in_millis":431765693,"mem":{"heap_used_in_bytes":6319079512,"heap_used_percent":36,"heap_committed_in_bytes":17110138880,"heap_max_in_bytes":17110138880,"non_heap_used_in_bytes":170115336,"non_heap_committed_in_bytes":178569216,"pools":{"young":{"used_in_bytes":443763064,"max_in_bytes":558432256,"peak_used_in_bytes":558432256,"peak_max_in_bytes":558432256},"survivor":{"used_in_bytes":14138776,"max_in_bytes":69730304,"peak_used_in_bytes":69730304,"peak_max_in_bytes":69730304},"old":{"used_in_bytes":5861177672,"max_in_bytes":16481976320,"peak_used_in_bytes":12466824144,"peak_max_in_bytes":16481976320}}},"threads":{"count":123,"peak_count":129},"gc":{"collectors":{"young":{"collection_count":120635,"collection_time_in_millis":4020956},"old":{"collection_count":34,"collection_time_in_millis":7882}}},"buffer_pools":{"direct":{"count":121,"used_in_bytes":272138248,"total_capacity_in_bytes":272138247},"mapped":{"count":9931,"used_in_bytes":291373910869,"total_capacity_in_bytes":291373910869}},"classes":{"current_loaded_count":15157,"total_loaded_count":15278,"total_unloaded_count":121}},"thread_pool":{"bulk":{"threads":8,"queue":0,"active":0,"rejected":0,"largest":8,"completed":4880397},"fetch_shard_started":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_store":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"flush":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":172938},"force_merge":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"generic":{"threads":6,"queue":0,"active":0,"rejected":0,"largest":6,"completed":988384},"get":{"threads":8,"queue":0,"active":0,"rejected":0,"largest":8,"completed":166525},"index":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"listener":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"management":{"threads":5,"queue":0,"active":4,"rejected":0,"largest":5,"completed":1392916},"ml_autodetect":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_datafeed":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_utility":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"refresh":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":95595890},"search":{"threads":13,"queue":0,"active":0,"rejected":0,"largest":13,"completed":656498},"snapshot":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"warmer":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":1436871},"watcher":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0}},"fs":{"timestamp":1511714497946,"total":{"total_in_bytes":528310788096,"free_in_bytes":230955548672,"available_in_bytes":230938771456,"spins":"true"},"data":[{"path":"/mnt/data/nodes/0","mount":"/mnt/data (/dev/sdb1)","type":"ext4","total_in_bytes":528310788096,"free_in_bytes":230955548672,"available_in_bytes":230938771456,"spins":"true"}],"io_stats":{"devices":[{"device_name":"sdb1","operations":23957106,"read_operations":1813100,"write_operations":22144006,"read_kilobytes":208071952,"write_kilobytes":1567856356}],"total":{"operations":23957106,"read_operations":1813100,"write_operations":22144006,"read_kilobytes":208071952,"write_kilobytes":1567856356}}},"transport":{"server_open":133,"rx_count":11052974,"rx_size_in_bytes":548594647188,"tx_count":11052976,"tx_size_in_bytes":267372947055},"http":{"current_open":3,"total_opened":383162},"breakers":{"request":{"limit_size_in_bytes":10266083328,"limit_size":"9.5gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0},"fielddata":{"limit_size_in_bytes":10266083328,"limit_size":"9.5gb","estimated_size_in_bytes":50008,"estimated_size":"48.8kb","overhead":1.03,"tripped":0},"in_flight_requests":{"limit_size_in_bytes":17110138880,"limit_size":"15.9gb","estimated_size_in_bytes":73996,"estimated_size":"72.2kb","overhead":1.0,"tripped":0},"parent":{"limit_size_in_bytes":11977097216,"limit_size":"11.1gb","estimated_size_in_bytes":124004,"estimated_size":"121kb","overhead":1.0,"tripped":0}},"script":{"compilations":1,"cache_evictions":0},"discovery":{"cluster_state_queue":{"total":0,"pending":0,"committed":0}},"ingest":{"total":{"count":0,"time_in_millis":0,"current":0,"failed":0},"pipelines":{"xpack_monitoring_2":{"count":0,"time_in_millis":0,"current":0,"failed":0},"xpack_monitoring_6":{"count":0,"time_in_millis":0,"current":0,"failed":0}}}},"sJu6S4ZOSNKj2GewgLAA6w":{"timestamp":1511714498348,"name":"elasticin-01","transport_address":"10.0.0.109:9300","host":"elasticin-01","ip":"10.0.0.109:9300","roles":["ingest"],"attributes":{"ml.enabled":"true"},"indices":{"docs":{"count":0,"deleted":0},"store":{"size_in_bytes":0,"throttle_time_in_millis":0},"indexing":{"index_total":0,"index_time_in_millis":0,"index_current":0,"index_failed":0,"delete_total":0,"delete_time_in_millis":0,"delete_current":0,"noop_update_total":0,"is_throttled":false,"throttle_time_in_millis":0},"get":{"total":0,"time_in_millis":0,"exists_total":0,"exists_time_in_millis":0,"missing_total":0,"missing_time_in_millis":0,"current":0},"search":{"open_contexts":0,"query_total":0,"query_time_in_millis":0,"query_current":0,"fetch_total":0,"fetch_time_in_millis":0,"fetch_current":0,"scroll_total":0,"scroll_time_in_millis":0,"scroll_current":0,"suggest_total":0,"suggest_time_in_millis":0,"suggest_current":0},"merges":{"current":0,"current_docs":0,"current_size_in_bytes":0,"total":0,"total_time_in_millis":0,"total_docs":0,"total_size_in_bytes":0,"total_stopped_time_in_millis":0,"total_throttled_time_in_millis":0,"total_auto_throttle_in_bytes":0},"refresh":{"total":0,"total_time_in_millis":0,"listeners":0},"flush":{"total":0,"total_time_in_millis":0},"warmer":{"current":0,"total":0,"total_time_in_millis":0},"query_cache":{"memory_size_in_bytes":0,"total_count":0,"hit_count":0,"miss_count":0,"cache_size":0,"cache_count":0,"evictions":0},"fielddata":{"memory_size_in_bytes":0,"evictions":0},"completion":{"size_in_bytes":0},"segments":{"count":0,"memory_in_bytes":0,"terms_memory_in_bytes":0,"stored_fields_memory_in_bytes":0,"term_vectors_memory_in_bytes":0,"norms_memory_in_bytes":0,"points_memory_in_bytes":0,"doc_values_memory_in_bytes":0,"index_writer_memory_in_bytes":0,"version_map_memory_in_bytes":0,"fixed_bit_set_memory_in_bytes":0,"max_unsafe_auto_id_timestamp":-9223372036854775808,"file_sizes":{}},"translog":{"operations":0,"size_in_bytes":0},"request_cache":{"memory_size_in_bytes":0,"evictions":0,"hit_count":0,"miss_count":0},"recovery":{"current_as_source":0,"current_as_target":0,"throttle_time_in_millis":0}},"os":{"timestamp":1511714497945,"cpu":{"percent":5,"load_average":{"1m":0.33,"5m":0.37,"15m":0.32}},"mem":{"total_in_bytes":8375726080,"free_in_bytes":518225920,"used_in_bytes":7857500160,"free_percent":6,"used_percent":94},"swap":{"total_in_bytes":1073737728,"free_in_bytes":1073737728,"used_in_bytes":0},"cgroup":{"cpuacct":{"control_group":"/","usage_nanos":36799094034870},"cpu":{"control_group":"/","cfs_period_micros":100000,"cfs_quota_micros":-1,"stat":{"number_of_elapsed_periods":0,"number_of_times_throttled":0,"time_throttled_nanos":0}}}},"process":{"timestamp":1511714497945,"open_file_descriptors":507,"max_file_descriptors":1048576,"cpu":{"percent":0,"total_in_millis":36798970},"mem":{"total_virtual_in_bytes":8281767936}},"jvm":{"timestamp":1511714497945,"uptime_in_millis":589205044,"mem":{"heap_used_in_bytes":1052113704,"heap_used_percent":24,"heap_committed_in_bytes":4260102144,"heap_max_in_bytes":4260102144,"non_heap_used_in_bytes":115304704,"non_heap_committed_in_bytes":122564608,"pools":{"young":{"used_in_bytes":49586432,"max_in_bytes":279183360,"peak_used_in_bytes":279183360,"peak_max_in_bytes":279183360},"survivor":{"used_in_bytes":3992336,"max_in_bytes":34865152,"peak_used_in_bytes":34865152,"peak_max_in_bytes":34865152},"old":{"used_in_bytes":998591504,"max_in_bytes":3946053632,"peak_used_in_bytes":3585864320,"peak_max_in_bytes":3946053632}}},"threads":{"count":59,"peak_count":161},"gc":{"collectors":{"young":{"collection_count":57750,"collection_time_in_millis":1081864},"old":{"collection_count":257,"collection_time_in_millis":23972}}},"buffer_pools":{"direct":{"count":40,"used_in_bytes":135831560,"total_capacity_in_bytes":135831559},"mapped":{"count":0,"used_in_bytes":0,"total_capacity_in_bytes":0}},"classes":{"current_loaded_count":13399,"total_loaded_count":13478,"total_unloaded_count":79}},"thread_pool":{"bulk":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":404291},"fetch_shard_started":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_store":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"flush":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"force_merge":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"generic":{"threads":7,"queue":0,"active":0,"rejected":0,"largest":109,"completed":765856},"get":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"index":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"listener":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"management":{"threads":5,"queue":0,"active":1,"rejected":0,"largest":5,"completed":1288944},"ml_autodetect":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_datafeed":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_utility":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"refresh":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"search":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"snapshot":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"warmer":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"watcher":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0}},"fs":{"timestamp":1511714497945,"total":{"total_in_bytes":39836917760,"free_in_bytes":35580149760,"available_in_bytes":33532911616,"spins":"true"},"data":[{"path":"/usr/share/elasticsearch/data/nodes/0","mount":"/ (overlay)","type":"overlay","total_in_bytes":39836917760,"free_in_bytes":35580149760,"available_in_bytes":33532911616,"spins":"true"}],"io_stats":{}},"transport":{"server_open":135,"rx_count":5045776,"rx_size_in_bytes":152482073745,"tx_count":5048384,"tx_size_in_bytes":224365671464},"http":{"current_open":2,"total_opened":580259},"breakers":{"request":{"limit_size_in_bytes":2556061286,"limit_size":"2.3gb","estimated_size_in_bytes":230160,"estimated_size":"224.7kb","overhead":1.0,"tripped":0},"fielddata":{"limit_size_in_bytes":2556061286,"limit_size":"2.3gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.03,"tripped":0},"in_flight_requests":{"limit_size_in_bytes":4260102144,"limit_size":"3.9gb","estimated_size_in_bytes":1916,"estimated_size":"1.8kb","overhead":1.0,"tripped":0},"parent":{"limit_size_in_bytes":2982071500,"limit_size":"2.7gb","estimated_size_in_bytes":232076,"estimated_size":"226.6kb","overhead":1.0,"tripped":0}},"script":{"compilations":1,"cache_evictions":0},"discovery":{"cluster_state_queue":{"total":0,"pending":0,"committed":0}},"ingest":{"total":{"count":0,"time_in_millis":0,"current":0,"failed":0},"pipelines":{"xpack_monitoring_6":{"count":0,"time_in_millis":0,"current":0,"failed":0},"xpack_monitoring_2":{"count":0,"time_in_millis":0,"current":0,"failed":0}}}},"bGzxfiCWT5KcR7jF4ADJ_g":{"timestamp":1511714498349,"name":"elasticdata-03","transport_address":"10.0.0.55:9300","host":"elasticdata-03","ip":"10.0.0.55:9300","roles":["data"],"attributes":{"ml.enabled":"true"},"indices":{"docs":{"count":501080121,"deleted":1190750},"store":{"size_in_bytes":315723703383,"throttle_time_in_millis":0},"indexing":{"index_total":650070635,"index_time_in_millis":167204215,"index_current":0,"index_failed":1332739,"delete_total":1968,"delete_time_in_millis":194,"delete_current":0,"noop_update_total":133,"is_throttled":false,"throttle_time_in_millis":0},"get":{"total":30909,"time_in_millis":2520,"exists_total":30907,"exists_time_in_millis":2520,"missing_total":2,"missing_time_in_millis":0,"current":0},"search":{"open_contexts":0,"query_total":639532,"query_time_in_millis":4571412,"query_current":0,"fetch_total":37389,"fetch_time_in_millis":510596,"fetch_current":0,"scroll_total":38,"scroll_time_in_millis":1484669,"scroll_current":1,"suggest_total":0,"suggest_time_in_millis":0,"suggest_current":0},"merges":{"current":0,"current_docs":0,"current_size_in_bytes":0,"total":207892,"total_time_in_millis":156215892,"total_docs":1938519154,"total_size_in_bytes":1192900048810,"total_stopped_time_in_millis":0,"total_throttled_time_in_millis":85295109,"total_auto_throttle_in_bytes":56331279192},"refresh":{"total":1794344,"total_time_in_millis":35971432,"listeners":0},"flush":{"total":3365,"total_time_in_millis":678944},"warmer":{"current":0,"total":1484801,"total_time_in_millis":689654},"query_cache":{"memory_size_in_bytes":111403405,"total_count":556164,"hit_count":117910,"miss_count":438254,"cache_size":17962,"cache_count":19094,"evictions":1132},"fielddata":{"memory_size_in_bytes":0,"evictions":0},"completion":{"size_in_bytes":0},"segments":{"count":4518,"memory_in_bytes":1141279472,"terms_memory_in_bytes":1037548187,"stored_fields_memory_in_bytes":77990264,"term_vectors_memory_in_bytes":0,"norms_memory_in_bytes":8918784,"points_memory_in_bytes":2803229,"doc_values_memory_in_bytes":14019008,"index_writer_memory_in_bytes":3135060,"version_map_memory_in_bytes":4650,"fixed_bit_set_memory_in_bytes":96,"max_unsafe_auto_id_timestamp":1511222421028,"file_sizes":{}},"translog":{"operations":3730929,"size_in_bytes":3098662483},"request_cache":{"memory_size_in_bytes":246594,"evictions":0,"hit_count":497,"miss_count":396},"recovery":{"current_as_source":0,"current_as_target":0,"throttle_time_in_millis":7727317}},"os":{"timestamp":1511714497945,"cpu":{"percent":7,"load_average":{"1m":0.57,"5m":0.47,"15m":0.66}},"mem":{"total_in_bytes":33742192640,"free_in_bytes":307798016,"used_in_bytes":33434394624,"free_percent":1,"used_percent":99},"swap":{"total_in_bytes":1073737728,"free_in_bytes":725217280,"used_in_bytes":348520448},"cgroup":{"cpuacct":{"control_group":"/","usage_nanos":511903359994882},"cpu":{"control_group":"/","cfs_period_micros":100000,"cfs_quota_micros":-1,"stat":{"number_of_elapsed_periods":0,"number_of_times_throttled":0,"time_throttled_nanos":0}}}},"process":{"timestamp":1511714497945,"open_file_descriptors":1518,"max_file_descriptors":1048576,"cpu":{"percent":5,"total_in_millis":511900740},"mem":{"total_virtual_in_bytes":338006835200}},"jvm":{"timestamp":1511714497946,"uptime_in_millis":584100083,"mem":{"heap_used_in_bytes":4294670120,"heap_used_percent":25,"heap_committed_in_bytes":17110138880,"heap_max_in_bytes":17110138880,"non_heap_used_in_bytes":179614824,"non_heap_committed_in_bytes":189874176,"pools":{"young":{"used_in_bytes":236457480,"max_in_bytes":558432256,"peak_used_in_bytes":558432256,"peak_max_in_bytes":558432256},"survivor":{"used_in_bytes":22430736,"max_in_bytes":69730304,"peak_used_in_bytes":69730304,"peak_max_in_bytes":69730304},"old":{"used_in_bytes":4035781904,"max_in_bytes":16481976320,"peak_used_in_bytes":13487381760,"peak_max_in_bytes":16481976320}}},"threads":{"count":136,"peak_count":273},"gc":{"collectors":{"young":{"collection_count":193711,"collection_time_in_millis":6942549},"old":{"collection_count":255,"collection_time_in_millis":56702}}},"buffer_pools":{"direct":{"count":111,"used_in_bytes":288779021,"total_capacity_in_bytes":288779020},"mapped":{"count":10210,"used_in_bytes":313880786534,"total_capacity_in_bytes":313880786534}},"classes":{"current_loaded_count":15315,"total_loaded_count":15459,"total_unloaded_count":144}},"thread_pool":{"bulk":{"threads":8,"queue":0,"active":0,"rejected":96063,"largest":8,"completed":6843393},"fetch_shard_started":{"threads":1,"queue":0,"active":0,"rejected":0,"largest":16,"completed":2821},"fetch_shard_store":{"threads":1,"queue":0,"active":0,"rejected":0,"largest":16,"completed":10417},"flush":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":235466},"force_merge":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"generic":{"threads":9,"queue":0,"active":0,"rejected":0,"largest":128,"completed":1203023},"get":{"threads":8,"queue":0,"active":0,"rejected":0,"largest":8,"completed":30308},"index":{"threads":8,"queue":0,"active":0,"rejected":0,"largest":8,"completed":1047},"listener":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"management":{"threads":5,"queue":0,"active":3,"rejected":0,"largest":5,"completed":1911510},"ml_autodetect":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_datafeed":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_utility":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"refresh":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":122518082},"search":{"threads":13,"queue":0,"active":0,"rejected":0,"largest":13,"completed":647893},"snapshot":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"warmer":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":1799955},"watcher":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0}},"fs":{"timestamp":1511714497946,"total":{"total_in_bytes":528310788096,"free_in_bytes":203463053312,"available_in_bytes":203446276096,"spins":"true"},"data":[{"path":"/mnt/data/nodes/0","mount":"/mnt/data (/dev/sdb1)","type":"ext4","total_in_bytes":528310788096,"free_in_bytes":203463053312,"available_in_bytes":203446276096,"spins":"true"}],"io_stats":{"devices":[{"device_name":"sdb1","operations":35923102,"read_operations":5207659,"write_operations":30715443,"read_kilobytes":618782872,"write_kilobytes":2076833544}],"total":{"operations":35923102,"read_operations":5207659,"write_operations":30715443,"read_kilobytes":618782872,"write_kilobytes":2076833544}}},"transport":{"server_open":133,"rx_count":17156365,"rx_size_in_bytes":1032986412750,"tx_count":17159929,"tx_size_in_bytes":933277781744},"http":{"current_open":2,"total_opened":500007},"breakers":{"request":{"limit_size_in_bytes":10266083328,"limit_size":"9.5gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0},"fielddata":{"limit_size_in_bytes":10266083328,"limit_size":"9.5gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.03,"tripped":0},"in_flight_requests":{"limit_size_in_bytes":17110138880,"limit_size":"15.9gb","estimated_size_in_bytes":39799,"estimated_size":"38.8kb","overhead":1.0,"tripped":0},"parent":{"limit_size_in_bytes":11977097216,"limit_size":"11.1gb","estimated_size_in_bytes":39799,"estimated_size":"38.8kb","overhead":1.0,"tripped":0}},"script":{"compilations":1,"cache_evictions":0},"discovery":{"cluster_state_queue":{"total":0,"pending":0,"committed":0}},"ingest":{"total":{"count":0,"time_in_millis":0,"current":0,"failed":0},"pipelines":{"xpack_monitoring_6":{"count":0,"time_in_millis":0,"current":0,"failed":0},"xpack_monitoring_2":{"count":0,"time_in_millis":0,"current":0,"failed":0}}}},"mr05ujLDTdq-vCnCNuCL8Q":{"timestamp":1511714498348,"name":"elasticcli-01","transport_address":"10.0.0.115:9300","host":"elasticcli-01","ip":"10.0.0.115:9300","roles":[],"attributes":{"ml.enabled":"true"},"indices":{"docs":{"count":0,"deleted":0},"store":{"size_in_bytes":0,"throttle_time_in_millis":0},"indexing":{"index_total":0,"index_time_in_millis":0,"index_current":0,"index_failed":0,"delete_total":0,"delete_time_in_millis":0,"delete_current":0,"noop_update_total":0,"is_throttled":false,"throttle_time_in_millis":0},"get":{"total":0,"time_in_millis":0,"exists_total":0,"exists_time_in_millis":0,"missing_total":0,"missing_time_in_millis":0,"current":0},"search":{"open_contexts":0,"query_total":0,"query_time_in_millis":0,"query_current":0,"fetch_total":0,"fetch_time_in_millis":0,"fetch_current":0,"scroll_total":0,"scroll_time_in_millis":0,"scroll_current":0,"suggest_total":0,"suggest_time_in_millis":0,"suggest_current":0},"merges":{"current":0,"current_docs":0,"current_size_in_bytes":0,"total":0,"total_time_in_millis":0,"total_docs":0,"total_size_in_bytes":0,"total_stopped_time_in_millis":0,"total_throttled_time_in_millis":0,"total_auto_throttle_in_bytes":0},"refresh":{"total":0,"total_time_in_millis":0,"listeners":0},"flush":{"total":0,"total_time_in_millis":0},"warmer":{"current":0,"total":0,"total_time_in_millis":0},"query_cache":{"memory_size_in_bytes":0,"total_count":0,"hit_count":0,"miss_count":0,"cache_size":0,"cache_count":0,"evictions":0},"fielddata":{"memory_size_in_bytes":0,"evictions":0},"completion":{"size_in_bytes":0},"segments":{"count":0,"memory_in_bytes":0,"terms_memory_in_bytes":0,"stored_fields_memory_in_bytes":0,"term_vectors_memory_in_bytes":0,"norms_memory_in_bytes":0,"points_memory_in_bytes":0,"doc_values_memory_in_bytes":0,"index_writer_memory_in_bytes":0,"version_map_memory_in_bytes":0,"fixed_bit_set_memory_in_bytes":0,"max_unsafe_auto_id_timestamp":-9223372036854775808,"file_sizes":{}},"translog":{"operations":0,"size_in_bytes":0},"request_cache":{"memory_size_in_bytes":0,"evictions":0,"hit_count":0,"miss_count":0},"recovery":{"current_as_source":0,"current_as_target":0,"throttle_time_in_millis":0}},"os":{"timestamp":1511714497945,"cpu":{"percent":8,"load_average":{"1m":0.3,"5m":0.24,"15m":0.27}},"mem":{"total_in_bytes":8375726080,"free_in_bytes":252256256,"used_in_bytes":8123469824,"free_percent":3,"used_percent":97},"swap":{"total_in_bytes":1073737728,"free_in_bytes":726077440,"used_in_bytes":347660288},"cgroup":{"cpuacct":{"control_group":"/","usage_nanos":30184458419459},"cpu":{"control_group":"/","cfs_period_micros":100000,"cfs_quota_micros":-1,"stat":{"number_of_elapsed_periods":0,"number_of_times_throttled":0,"time_throttled_nanos":0}}}},"process":{"timestamp":1511714497945,"open_file_descriptors":518,"max_file_descriptors":1048576,"cpu":{"percent":2,"total_in_millis":30184300},"mem":{"total_virtual_in_bytes":6093246464}},"jvm":{"timestamp":1511714497945,"uptime_in_millis":445557994,"mem":{"heap_used_in_bytes":1203681360,"heap_used_percent":56,"heap_committed_in_bytes":2112618496,"heap_max_in_bytes":2112618496,"non_heap_used_in_bytes":122900392,"non_heap_committed_in_bytes":130781184,"pools":{"young":{"used_in_bytes":192372408,"max_in_bytes":279183360,"peak_used_in_bytes":279183360,"peak_max_in_bytes":279183360},"survivor":{"used_in_bytes":34865152,"max_in_bytes":34865152,"peak_used_in_bytes":34865152,"peak_max_in_bytes":34865152},"old":{"used_in_bytes":976443800,"max_in_bytes":1798569984,"peak_used_in_bytes":1798569944,"peak_max_in_bytes":1798569984}}},"threads":{"count":63,"peak_count":64},"gc":{"collectors":{"young":{"collection_count":47488,"collection_time_in_millis":897897},"old":{"collection_count":544,"collection_time_in_millis":140989}}},"buffer_pools":{"direct":{"count":41,"used_in_bytes":152608776,"total_capacity_in_bytes":152608775},"mapped":{"count":0,"used_in_bytes":0,"total_capacity_in_bytes":0}},"classes":{"current_loaded_count":13664,"total_loaded_count":13736,"total_unloaded_count":72}},"thread_pool":{"bulk":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_started":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_store":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"flush":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"force_merge":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"generic":{"threads":8,"queue":0,"active":0,"rejected":0,"largest":8,"completed":578181},"get":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"index":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"listener":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"management":{"threads":5,"queue":0,"active":1,"rejected":0,"largest":5,"completed":1268638},"ml_autodetect":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_datafeed":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_utility":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"refresh":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"search":{"threads":7,"queue":0,"active":0,"rejected":0,"largest":7,"completed":365840},"snapshot":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"warmer":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"watcher":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0}},"fs":{"timestamp":1511714497945,"total":{"total_in_bytes":39836917760,"free_in_bytes":21528715264,"available_in_bytes":19481477120,"spins":"true"},"data":[{"path":"/usr/share/elasticsearch/data/nodes/0","mount":"/ (overlay)","type":"overlay","total_in_bytes":39836917760,"free_in_bytes":21528715264,"available_in_bytes":19481477120,"spins":"true"}],"io_stats":{}},"transport":{"server_open":135,"rx_count":9063293,"rx_size_in_bytes":184591046718,"tx_count":9063303,"tx_size_in_bytes":82805398412},"http":{"current_open":14,"total_opened":410363},"breakers":{"request":{"limit_size_in_bytes":1267571097,"limit_size":"1.1gb","estimated_size_in_bytes":131520,"estimated_size":"128.4kb","overhead":1.0,"tripped":0},"fielddata":{"limit_size_in_bytes":1267571097,"limit_size":"1.1gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.03,"tripped":0},"in_flight_requests":{"limit_size_in_bytes":2112618496,"limit_size":"1.9gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0},"parent":{"limit_size_in_bytes":1478832947,"limit_size":"1.3gb","estimated_size_in_bytes":131520,"estimated_size":"128.4kb","overhead":1.0,"tripped":0}},"script":{"compilations":1,"cache_evictions":0},"discovery":{"cluster_state_queue":{"total":0,"pending":0,"committed":0}},"ingest":{"total":{"count":0,"time_in_millis":0,"current":0,"failed":0},"pipelines":{"xpack_monitoring_2":{"count":0,"time_in_millis":0,"current":0,"failed":0},"xpack_monitoring_6":{"count":0,"time_in_millis":0,"current":0,"failed":0}}}},"1rpMsJDnTFaSPdkBQM110g":{"timestamp":1511714498348,"name":"elasticdata-02","transport_address":"10.0.0.116:9300","host":"elasticdata-02","ip":"10.0.0.116:9300","roles":["data"],"attributes":{"ml.enabled":"true"},"indices":{"docs":{"count":408294223,"deleted":1074290},"store":{"size_in_bytes":257612662026,"throttle_time_in_millis":0},"indexing":{"index_total":568986485,"index_time_in_millis":135970122,"index_current":0,"index_failed":24361127,"delete_total":232,"delete_time_in_millis":29,"delete_current":0,"noop_update_total":113,"is_throttled":false,"throttle_time_in_millis":0},"get":{"total":15516,"time_in_millis":1369,"exists_total":15485,"exists_time_in_millis":1368,"missing_total":31,"missing_time_in_millis":1,"current":0},"search":{"open_contexts":0,"query_total":480400,"query_time_in_millis":4147683,"query_current":0,"fetch_total":25811,"fetch_time_in_millis":555392,"fetch_current":0,"scroll_total":19,"scroll_time_in_millis":1307018,"scroll_current":0,"suggest_total":0,"suggest_time_in_millis":0,"suggest_current":0},"merges":{"current":0,"current_docs":0,"current_size_in_bytes":0,"total":199042,"total_time_in_millis":117076364,"total_docs":1647292265,"total_size_in_bytes":1026463665180,"total_stopped_time_in_millis":0,"total_throttled_time_in_millis":52910999,"total_auto_throttle_in_bytes":64807275536},"refresh":{"total":1782072,"total_time_in_millis":31882918,"listeners":0},"flush":{"total":2504,"total_time_in_millis":562585},"warmer":{"current":0,"total":1453580,"total_time_in_millis":429293},"query_cache":{"memory_size_in_bytes":167693059,"total_count":1256138,"hit_count":657110,"miss_count":599028,"cache_size":9740,"cache_count":11960,"evictions":2220},"fielddata":{"memory_size_in_bytes":46760,"evictions":0},"completion":{"size_in_bytes":0},"segments":{"count":4310,"memory_in_bytes":890541030,"terms_memory_in_bytes":798812291,"stored_fields_memory_in_bytes":63063768,"term_vectors_memory_in_bytes":0,"norms_memory_in_bytes":8041856,"points_memory_in_bytes":4360995,"doc_values_memory_in_bytes":16262120,"index_writer_memory_in_bytes":0,"version_map_memory_in_bytes":0,"fixed_bit_set_memory_in_bytes":344,"max_unsafe_auto_id_timestamp":1511654404456,"file_sizes":{}},"translog":{"operations":2491457,"size_in_bytes":2453361251},"request_cache":{"memory_size_in_bytes":150055283,"evictions":16383,"hit_count":19785,"miss_count":38600},"recovery":{"current_as_source":0,"current_as_target":0,"throttle_time_in_millis":7657996}},"os":{"timestamp":1511714497945,"cpu":{"percent":9,"load_average":{"1m":0.88,"5m":0.92,"15m":0.87}},"mem":{"total_in_bytes":33742192640,"free_in_bytes":657498112,"used_in_bytes":33084694528,"free_percent":2,"used_percent":98},"swap":{"total_in_bytes":1073737728,"free_in_bytes":762204160,"used_in_bytes":311533568},"cgroup":{"cpuacct":{"control_group":"/","usage_nanos":473118153915722},"cpu":{"control_group":"/","cfs_period_micros":100000,"cfs_quota_micros":-1,"stat":{"number_of_elapsed_periods":0,"number_of_times_throttled":0,"time_throttled_nanos":0}}}},"process":{"timestamp":1511714497945,"open_file_descriptors":1499,"max_file_descriptors":1048576,"cpu":{"percent":9,"total_in_millis":473115920},"mem":{"total_virtual_in_bytes":279946231808}},"jvm":{"timestamp":1511714497946,"uptime_in_millis":584148847,"mem":{"heap_used_in_bytes":11282849256,"heap_used_percent":65,"heap_committed_in_bytes":17110138880,"heap_max_in_bytes":17110138880,"non_heap_used_in_bytes":182476568,"non_heap_committed_in_bytes":192057344,"pools":{"young":{"used_in_bytes":386452168,"max_in_bytes":558432256,"peak_used_in_bytes":558432256,"peak_max_in_bytes":558432256},"survivor":{"used_in_bytes":29119144,"max_in_bytes":69730304,"peak_used_in_bytes":69730304,"peak_max_in_bytes":69730304},"old":{"used_in_bytes":10867277944,"max_in_bytes":16481976320,"peak_used_in_bytes":16388546600,"peak_max_in_bytes":16481976320}}},"threads":{"count":135,"peak_count":195},"gc":{"collectors":{"young":{"collection_count":175896,"collection_time_in_millis":6408288},"old":{"collection_count":146,"collection_time_in_millis":58079}}},"buffer_pools":{"direct":{"count":136,"used_in_bytes":272251175,"total_capacity_in_bytes":272251174},"mapped":{"count":9822,"used_in_bytes":256092821621,"total_capacity_in_bytes":256092821621}},"classes":{"current_loaded_count":15342,"total_loaded_count":15513,"total_unloaded_count":171}},"thread_pool":{"bulk":{"threads":8,"queue":0,"active":0,"rejected":99626,"largest":8,"completed":5768105},"fetch_shard_started":{"threads":1,"queue":0,"active":0,"rejected":0,"largest":16,"completed":3316},"fetch_shard_store":{"threads":1,"queue":0,"active":0,"rejected":0,"largest":16,"completed":10424},"flush":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":232408},"force_merge":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"generic":{"threads":8,"queue":0,"active":0,"rejected":0,"largest":52,"completed":1355815},"get":{"threads":8,"queue":0,"active":0,"rejected":0,"largest":8,"completed":15129},"index":{"threads":8,"queue":0,"active":0,"rejected":0,"largest":8,"completed":477},"listener":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"management":{"threads":5,"queue":0,"active":3,"rejected":0,"largest":5,"completed":1911497},"ml_autodetect":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_datafeed":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_utility":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"refresh":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":123430269},"search":{"threads":13,"queue":0,"active":0,"rejected":0,"largest":13,"completed":492351},"snapshot":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"warmer":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":1788033},"watcher":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0}},"fs":{"timestamp":1511714497946,"total":{"total_in_bytes":528311836672,"free_in_bytes":259594153984,"available_in_bytes":232733884416,"spins":"true"},"data":[{"path":"/mnt/data/nodes/0","mount":"/mnt/data (/dev/sdb1)","type":"ext4","total_in_bytes":528311836672,"free_in_bytes":259594153984,"available_in_bytes":232733884416,"spins":"true"}],"io_stats":{"devices":[{"device_name":"sdb1","operations":29499136,"read_operations":3305656,"write_operations":26193480,"read_kilobytes":412087356,"write_kilobytes":1819822768}],"total":{"operations":29499136,"read_operations":3305656,"write_operations":26193480,"read_kilobytes":412087356,"write_kilobytes":1819822768}}},"transport":{"server_open":133,"rx_count":15001696,"rx_size_in_bytes":1002526189002,"tx_count":15004766,"tx_size_in_bytes":1130024582664},"http":{"current_open":2,"total_opened":508442},"breakers":{"request":{"limit_size_in_bytes":10266083328,"limit_size":"9.5gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0},"fielddata":{"limit_size_in_bytes":10266083328,"limit_size":"9.5gb","estimated_size_in_bytes":46760,"estimated_size":"45.6kb","overhead":1.03,"tripped":0},"in_flight_requests":{"limit_size_in_bytes":17110138880,"limit_size":"15.9gb","estimated_size_in_bytes":78944,"estimated_size":"77kb","overhead":1.0,"tripped":0},"parent":{"limit_size_in_bytes":11977097216,"limit_size":"11.1gb","estimated_size_in_bytes":125704,"estimated_size":"122.7kb","overhead":1.0,"tripped":0}},"script":{"compilations":1,"cache_evictions":0},"discovery":{"cluster_state_queue":{"total":0,"pending":0,"committed":0}},"ingest":{"total":{"count":0,"time_in_millis":0,"current":0,"failed":0},"pipelines":{"xpack_monitoring_6":{"count":0,"time_in_millis":0,"current":0,"failed":0},"xpack_monitoring_2":{"count":0,"time_in_millis":0,"current":0,"failed":0}}}},"mJtnri1LTJaymDIay6aJLQ":{"timestamp":1511714498349,"name":"elasticdata-06","transport_address":"10.0.0.97:9300","host":"elasticdata-06","ip":"10.0.0.97:9300","roles":["data"],"attributes":{"ml.enabled":"true"},"indices":{"docs":{"count":458706036,"deleted":1011663},"store":{"size_in_bytes":305879051264,"throttle_time_in_millis":0},"indexing":{"index_total":352418731,"index_time_in_millis":96827787,"index_current":0,"index_failed":0,"delete_total":0,"delete_time_in_millis":0,"delete_current":0,"noop_update_total":0,"is_throttled":false,"throttle_time_in_millis":0},"get":{"total":166624,"time_in_millis":12473,"exists_total":166624,"exists_time_in_millis":12473,"missing_total":0,"missing_time_in_millis":0,"current":0},"search":{"open_contexts":0,"query_total":482343,"query_time_in_millis":2076387,"query_current":0,"fetch_total":169199,"fetch_time_in_millis":184224,"fetch_current":0,"scroll_total":2,"scroll_time_in_millis":240038,"scroll_current":0,"suggest_total":0,"suggest_time_in_millis":0,"suggest_current":0},"merges":{"current":0,"current_docs":0,"current_size_in_bytes":0,"total":182114,"total_time_in_millis":127605140,"total_docs":1363877914,"total_size_in_bytes":960500345231,"total_stopped_time_in_millis":0,"total_throttled_time_in_millis":73083213,"total_auto_throttle_in_bytes":9823313645},"refresh":{"total":1567704,"total_time_in_millis":26218140,"listeners":0},"flush":{"total":1045,"total_time_in_millis":321661},"warmer":{"current":0,"total":1568611,"total_time_in_millis":696377},"query_cache":{"memory_size_in_bytes":80475461,"total_count":786337,"hit_count":444550,"miss_count":341787,"cache_size":8871,"cache_count":10021,"evictions":1150},"fielddata":{"memory_size_in_bytes":55288,"evictions":0},"completion":{"size_in_bytes":0},"segments":{"count":4465,"memory_in_bytes":1098390078,"terms_memory_in_bytes":996710745,"stored_fields_memory_in_bytes":72784232,"term_vectors_memory_in_bytes":0,"norms_memory_in_bytes":8683072,"points_memory_in_bytes":4155561,"doc_values_memory_in_bytes":16056468,"index_writer_memory_in_bytes":911700,"version_map_memory_in_bytes":4650,"fixed_bit_set_memory_in_bytes":528,"max_unsafe_auto_id_timestamp":1511481600745,"file_sizes":{}},"translog":{"operations":3503036,"size_in_bytes":3357895432},"request_cache":{"memory_size_in_bytes":98505744,"evictions":0,"hit_count":26090,"miss_count":34723},"recovery":{"current_as_source":0,"current_as_target":0,"throttle_time_in_millis":1793510}},"os":{"timestamp":1511714497945,"cpu":{"percent":9,"load_average":{"1m":0.54,"5m":0.66,"15m":0.89}},"mem":{"total_in_bytes":33742192640,"free_in_bytes":329875456,"used_in_bytes":33412317184,"free_percent":1,"used_percent":99},"swap":{"total_in_bytes":1073737728,"free_in_bytes":755060736,"used_in_bytes":318676992},"cgroup":{"cpuacct":{"control_group":"/","usage_nanos":345265404353469},"cpu":{"control_group":"/","cfs_period_micros":100000,"cfs_quota_micros":-1,"stat":{"number_of_elapsed_periods":0,"number_of_times_throttled":0,"time_throttled_nanos":0}}}},"process":{"timestamp":1511714497945,"open_file_descriptors":1347,"max_file_descriptors":1048576,"cpu":{"percent":8,"total_in_millis":345263060},"mem":{"total_virtual_in_bytes":326659825664}},"jvm":{"timestamp":1511714497946,"uptime_in_millis":431203379,"mem":{"heap_used_in_bytes":6856054400,"heap_used_percent":40,"heap_committed_in_bytes":17110138880,"heap_max_in_bytes":17110138880,"non_heap_used_in_bytes":168673048,"non_heap_committed_in_bytes":177786880,"pools":{"young":{"used_in_bytes":481488392,"max_in_bytes":558432256,"peak_used_in_bytes":558432256,"peak_max_in_bytes":558432256},"survivor":{"used_in_bytes":21141648,"max_in_bytes":69730304,"peak_used_in_bytes":69730304,"peak_max_in_bytes":69730304},"old":{"used_in_bytes":6353424360,"max_in_bytes":16481976320,"peak_used_in_bytes":12677713896,"peak_max_in_bytes":16481976320}}},"threads":{"count":128,"peak_count":135},"gc":{"collectors":{"young":{"collection_count":127223,"collection_time_in_millis":4468108},"old":{"collection_count":35,"collection_time_in_millis":13393}}},"buffer_pools":{"direct":{"count":125,"used_in_bytes":272179208,"total_capacity_in_bytes":272179207},"mapped":{"count":10044,"used_in_bytes":302869020633,"total_capacity_in_bytes":302869020633}},"classes":{"current_loaded_count":15194,"total_loaded_count":15397,"total_unloaded_count":203}},"thread_pool":{"bulk":{"threads":8,"queue":0,"active":0,"rejected":656,"largest":8,"completed":5424968},"fetch_shard_started":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_store":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"flush":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":172578},"force_merge":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"generic":{"threads":7,"queue":0,"active":0,"rejected":0,"largest":7,"completed":981787},"get":{"threads":8,"queue":0,"active":0,"rejected":0,"largest":8,"completed":166535},"index":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":4},"listener":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"management":{"threads":5,"queue":0,"active":2,"rejected":0,"largest":5,"completed":1391304},"ml_autodetect":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_datafeed":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_utility":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"refresh":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":95745951},"search":{"threads":13,"queue":0,"active":0,"rejected":0,"largest":13,"completed":485078},"snapshot":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"warmer":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":1569132},"watcher":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0}},"fs":{"timestamp":1511714497946,"total":{"total_in_bytes":528310788096,"free_in_bytes":218908598272,"available_in_bytes":218891821056,"spins":"true"},"data":[{"path":"/mnt/data/nodes/0","mount":"/mnt/data (/dev/sdb1)","type":"ext4","total_in_bytes":528310788096,"free_in_bytes":218908598272,"available_in_bytes":218891821056,"spins":"true"}],"io_stats":{"devices":[{"device_name":"sdb1","operations":25942355,"read_operations":1681165,"write_operations":24261190,"read_kilobytes":193190936,"write_kilobytes":1621218228}],"total":{"operations":25942355,"read_operations":1681165,"write_operations":24261190,"read_kilobytes":193190936,"write_kilobytes":1621218228}}},"transport":{"server_open":133,"rx_count":12260547,"rx_size_in_bytes":541703802431,"tx_count":12260545,"tx_size_in_bytes":346776082145},"http":{"current_open":2,"total_opened":381606},"breakers":{"request":{"limit_size_in_bytes":10266083328,"limit_size":"9.5gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0},"fielddata":{"limit_size_in_bytes":10266083328,"limit_size":"9.5gb","estimated_size_in_bytes":55288,"estimated_size":"53.9kb","overhead":1.03,"tripped":0},"in_flight_requests":{"limit_size_in_bytes":17110138880,"limit_size":"15.9gb","estimated_size_in_bytes":37927,"estimated_size":"37kb","overhead":1.0,"tripped":0},"parent":{"limit_size_in_bytes":11977097216,"limit_size":"11.1gb","estimated_size_in_bytes":93215,"estimated_size":"91kb","overhead":1.0,"tripped":0}},"script":{"compilations":1,"cache_evictions":0},"discovery":{"cluster_state_queue":{"total":0,"pending":0,"committed":0}},"ingest":{"total":{"count":0,"time_in_millis":0,"current":0,"failed":0},"pipelines":{"xpack_monitoring_2":{"count":0,"time_in_millis":0,"current":0,"failed":0},"xpack_monitoring_6":{"count":0,"time_in_millis":0,"current":0,"failed":0}}}},"UM8bpuowTXq2xX5B_w96jg":{"timestamp":1511714498349,"name":"elasticcli-02","transport_address":"10.0.0.114:9300","host":"elasticcli-02","ip":"10.0.0.114:9300","roles":[],"attributes":{"ml.enabled":"true"},"indices":{"docs":{"count":0,"deleted":0},"store":{"size_in_bytes":0,"throttle_time_in_millis":0},"indexing":{"index_total":0,"index_time_in_millis":0,"index_current":0,"index_failed":0,"delete_total":0,"delete_time_in_millis":0,"delete_current":0,"noop_update_total":0,"is_throttled":false,"throttle_time_in_millis":0},"get":{"total":0,"time_in_millis":0,"exists_total":0,"exists_time_in_millis":0,"missing_total":0,"missing_time_in_millis":0,"current":0},"search":{"open_contexts":0,"query_total":0,"query_time_in_millis":0,"query_current":0,"fetch_total":0,"fetch_time_in_millis":0,"fetch_current":0,"scroll_total":0,"scroll_time_in_millis":0,"scroll_current":0,"suggest_total":0,"suggest_time_in_millis":0,"suggest_current":0},"merges":{"current":0,"current_docs":0,"current_size_in_bytes":0,"total":0,"total_time_in_millis":0,"total_docs":0,"total_size_in_bytes":0,"total_stopped_time_in_millis":0,"total_throttled_time_in_millis":0,"total_auto_throttle_in_bytes":0},"refresh":{"total":0,"total_time_in_millis":0,"listeners":0},"flush":{"total":0,"total_time_in_millis":0},"warmer":{"current":0,"total":0,"total_time_in_millis":0},"query_cache":{"memory_size_in_bytes":0,"total_count":0,"hit_count":0,"miss_count":0,"cache_size":0,"cache_count":0,"evictions":0},"fielddata":{"memory_size_in_bytes":0,"evictions":0},"completion":{"size_in_bytes":0},"segments":{"count":0,"memory_in_bytes":0,"terms_memory_in_bytes":0,"stored_fields_memory_in_bytes":0,"term_vectors_memory_in_bytes":0,"norms_memory_in_bytes":0,"points_memory_in_bytes":0,"doc_values_memory_in_bytes":0,"index_writer_memory_in_bytes":0,"version_map_memory_in_bytes":0,"fixed_bit_set_memory_in_bytes":0,"max_unsafe_auto_id_timestamp":-9223372036854775808,"file_sizes":{}},"translog":{"operations":0,"size_in_bytes":0},"request_cache":{"memory_size_in_bytes":0,"evictions":0,"hit_count":0,"miss_count":0},"recovery":{"current_as_source":0,"current_as_target":0,"throttle_time_in_millis":0}},"os":{"timestamp":1511714497945,"cpu":{"percent":8,"load_average":{"1m":0.11,"5m":0.29,"15m":0.38}},"mem":{"total_in_bytes":8375726080,"free_in_bytes":242339840,"used_in_bytes":8133386240,"free_percent":3,"used_percent":97},"swap":{"total_in_bytes":1073737728,"free_in_bytes":666390528,"used_in_bytes":407347200},"cgroup":{"cpuacct":{"control_group":"/","usage_nanos":24933856576484},"cpu":{"control_group":"/","cfs_period_micros":100000,"cfs_quota_micros":-1,"stat":{"number_of_elapsed_periods":0,"number_of_times_throttled":0,"time_throttled_nanos":0}}}},"process":{"timestamp":1511714497945,"open_file_descriptors":516,"max_file_descriptors":1048576,"cpu":{"percent":0,"total_in_millis":24933720},"mem":{"total_virtual_in_bytes":6057439232}},"jvm":{"timestamp":1511714497945,"uptime_in_millis":439494501,"mem":{"heap_used_in_bytes":630212256,"heap_used_percent":29,"heap_committed_in_bytes":2112618496,"heap_max_in_bytes":2112618496,"non_heap_used_in_bytes":123008888,"non_heap_committed_in_bytes":130932736,"pools":{"young":{"used_in_bytes":43037928,"max_in_bytes":279183360,"peak_used_in_bytes":279183360,"peak_max_in_bytes":279183360},"survivor":{"used_in_bytes":28583072,"max_in_bytes":34865152,"peak_used_in_bytes":34865152,"peak_max_in_bytes":34865152},"old":{"used_in_bytes":558591256,"max_in_bytes":1798569984,"peak_used_in_bytes":1783141720,"peak_max_in_bytes":1798569984}}},"threads":{"count":59,"peak_count":62},"gc":{"collectors":{"young":{"collection_count":39584,"collection_time_in_millis":605986},"old":{"collection_count":200,"collection_time_in_millis":25256}}},"buffer_pools":{"direct":{"count":40,"used_in_bytes":135831560,"total_capacity_in_bytes":135831559},"mapped":{"count":0,"used_in_bytes":0,"total_capacity_in_bytes":0}},"classes":{"current_loaded_count":13655,"total_loaded_count":13724,"total_unloaded_count":69}},"thread_pool":{"bulk":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_started":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"fetch_shard_store":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"flush":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"force_merge":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"generic":{"threads":4,"queue":0,"active":0,"rejected":0,"largest":4,"completed":570734},"get":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"index":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"listener":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"management":{"threads":5,"queue":0,"active":1,"rejected":0,"largest":5,"completed":1243282},"ml_autodetect":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_datafeed":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"ml_utility":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"refresh":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"search":{"threads":7,"queue":0,"active":0,"rejected":0,"largest":7,"completed":339462},"snapshot":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"warmer":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0},"watcher":{"threads":0,"queue":0,"active":0,"rejected":0,"largest":0,"completed":0}},"fs":{"timestamp":1511714497946,"total":{"total_in_bytes":39836917760,"free_in_bytes":21595881472,"available_in_bytes":19548643328,"spins":"true"},"data":[{"path":"/usr/share/elasticsearch/data/nodes/0","mount":"/ (overlay)","type":"overlay","total_in_bytes":39836917760,"free_in_bytes":21595881472,"available_in_bytes":19548643328,"spins":"true"}],"io_stats":{}},"transport":{"server_open":135,"rx_count":8721285,"rx_size_in_bytes":169344861699,"tx_count":8721284,"tx_size_in_bytes":73698352750},"http":{"current_open":11,"total_opened":403280},"breakers":{"request":{"limit_size_in_bytes":1267571097,"limit_size":"1.1gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.0,"tripped":0},"fielddata":{"limit_size_in_bytes":1267571097,"limit_size":"1.1gb","estimated_size_in_bytes":0,"estimated_size":"0b","overhead":1.03,"tripped":0},"in_flight_requests":{"limit_size_in_bytes":2112618496,"limit_size":"1.9gb","estimated_size_in_bytes":1916,"estimated_size":"1.8kb","overhead":1.0,"tripped":0},"parent":{"limit_size_in_bytes":1478832947,"limit_size":"1.3gb","estimated_size_in_bytes":1916,"estimated_size":"1.8kb","overhead":1.0,"tripped":0}},"script":{"compilations":1,"cache_evictions":0},"discovery":{"cluster_state_queue":{"total":0,"pending":0,"committed":0}},"ingest":{"total":{"count":0,"time_in_millis":0,"current":0,"failed":0},"pipelines":{"xpack_monitoring_2":{"count":0,"time_in_millis":0,"current":0,"failed":0},"xpack_monitoring_6":{"count":0,"time_in_millis":0,"current":0,"failed":0}}}}}}`,
	}
	for ver, out := range tcs {
		for hn, handler := range map[string]http.Handler{
			"plain": http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
				fmt.Fprintln(w, out)
			}),
			"basicauth": &basicAuth{
				User: "elastic",
				Pass: "changeme",
				Next: http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
					fmt.Fprintln(w, out)
				}),
			},
		} {
			ts := httptest.NewServer(handler)
			defer ts.Close()

			u, err := url.Parse(ts.URL)
			if err != nil {
				t.Fatalf("Failed to parse URL: %s", err)
			}
			u.User = url.UserPassword("elastic", "changeme")
			c := NewNodes(log.NewNopLogger(), http.DefaultClient, u, true, "_local")
			nsr, err := c.fetchAndDecodeNodeStats()
			if err != nil {
				t.Fatalf("Failed to fetch or decode node stats: %s", err)
			}
			t.Logf("[%s/%s] Node Stats Response: %+v", hn, ver, nsr)
			if nsr.ClusterName == "elasticsearch" {
				for _, nsnr := range nsr.Nodes {
					if nsnr.Indices.Docs.Count > 0 {
						t.Errorf("Wrong doc count")
					}
				}
			}
			if nsr.ClusterName == "multinode" {
				for _, node := range nsr.Nodes {
					labels := defaultNodeLabelValues(nsr.ClusterName, node)
					esMasterNode := labels[3]
					esDataNode := labels[4]
					esIngestNode := labels[5]
					esClientNode := labels[6]
					t.Logf(
						"Node: %s - Master: %s - Data: %s - Ingest: %s - Client: %s",
						node.Name,
						esMasterNode,
						esDataNode,
						esIngestNode,
						esClientNode,
					)
					if strings.HasPrefix(node.Name, "elasticmaster") {
						if esMasterNode != "true" {
							t.Errorf("Master should be master")
						}
						if esDataNode == "true" {
							t.Errorf("Master should be not data")
						}
						if esIngestNode == "true" {
							t.Errorf("Master should be not ingest")
						}
					}
					if strings.HasPrefix(node.Name, "elasticdata") {
						if esMasterNode == "true" {
							t.Errorf("Data should not be master")
						}
						if esDataNode != "true" {
							t.Errorf("Data should be data")
						}
						if esIngestNode == "true" {
							t.Errorf("Data should be not ingest")
						}
					}
					if strings.HasPrefix(node.Name, "elasticin") {
						if esMasterNode == "true" {
							t.Errorf("Ingest should not be master")
						}
						if esDataNode == "true" {
							t.Errorf("Ingest should be data")
						}
						if esIngestNode != "true" {
							t.Errorf("Ingest should be not ingest")
						}
					}
					if strings.HasPrefix(node.Name, "elasticcli") {
						if esMasterNode == "true" {
							t.Errorf("CLI should not be master")
						}
						if esDataNode == "true" {
							t.Errorf("CLI should be data")
						}
						if esIngestNode == "true" {
							t.Errorf("CLI should be not ingest")
						}
					}
				}
			}
		}
	}
}

type basicAuth struct {
	User string
	Pass string
	Next http.Handler
}

func (h *basicAuth) checkAuth(w http.ResponseWriter, r *http.Request) bool {
	s := strings.SplitN(r.Header.Get("Authorization"), " ", 2)
	if len(s) != 2 {
		return false
	}

	b, err := base64.StdEncoding.DecodeString(s[1])
	if err != nil {
		return false
	}

	pair := strings.SplitN(string(b), ":", 2)
	if len(pair) != 2 {
		return false
	}

	if h.User == pair[0] && h.Pass == pair[1] {
		return true
	}
	return false
}

func (h *basicAuth) ServeHTTP(w http.ResponseWriter, r *http.Request) {
	if !h.checkAuth(w, r) {
		w.Header().Set("WWW-Authenticate", "Basic realm=\"ES\"")
		w.WriteHeader(401)
		w.Write([]byte("401 Unauthorized\n"))
		return
	}

	h.Next.ServeHTTP(w, r)
}
