#define NUM_STATES 59

    static const char *states[NUM_STATES] = 
        {"AK","AL","AR","AS","AZ","CA","CO","CT","DC","DE","FL","FM","GA","GU","HI","IA","ID","IL","IN","KS","KY","LA","MA","MD","ME","MH","MI","MN","MO","MP","MS","MT","NC","ND","NE","NH","NJ","NM","NV","NY","OH","OK","OR","PA","PR","PW","RI","SC","SD","TN","TX","UT","VA","VI","VT","WA","WI","WV","WY"};

    static const char *stcities[NUM_STATES] = {
  /* -- AK -- AK -- AK -- AK -- AK -- AK -- AK -- AK -- AK -- AK -- */
  "(?:\\b)((?^:(?i:(?:S(?:T(?:E(?:VENS V(?:ILLAGE|LG)|BBINS|RLING|ES"
  "E)| (?:GEORGE IS|PAUL ISLE)|ONY RIVER)|A(?:INT (?:(?:GEORGE|PAUL)"
  " ISLAND|M(?:ICHAEL|ARYS))|(?:VOONG|LCH)A|ND POINT)|H(?:(?:A(?:KTO"
  "OLI|GELU)|UNGNA)K|ISHMAREF)|E(?:L(?:DOVIA|AWIK)|WARD)|O(?:UTH NAK"
  "NEK|LDOTNA)|K(?:WENTNA|AGWAY)|L(?:EETMUTE|ANA)|CAMMON BAY|UTTON|I"
  "TKA)|C(?:H(?:I(?:GNIK(?: LA(?:G(?:OO)?N|KE))?|CK(?:ALOO|E)N|NIAK|"
  "TINA)|(?:U(?:ATHBALU|GIA)|ALKYITSI)K|E(?:(?:FORN|V)AK|NEGA BAY))|"
  "O(?:OPER L(?:ANDIN|ND)G|LD(?: BAY|FOOT)|PPER CENTER|FFMAN COVE|RD"
  "OVA)|L(?:A(?:RKS POINT|M GULCH)|EAR)|R(?:OOKED CREEK|AIG)|(?:ANTW"
  "EL|ENTRA)L|IRCLE)|K(?:O(?:(?:(?:Y(?:UK)?|B)U|(?:NGIGAN|DI)A|LIGAN"
  "E|KHANO)K|T(?:ZEBUE|LIK))|A(?:S(?:I(?:GLUK|LOF)|AAN)|K(?:TOVIK|E)"
  "|L(?:SK|T)AG|RLUK)|I(?:NG (?:SALMON|COVE)|(?:VALI|A)NA|PNUK)|(?:W"
  "(?:IGILLINGO|ETHLU)|LAWOC)K|E(?:TCHIKAN|NAI))|N(?:I(?:K(?:OL(?:A("
  "?:EVSK|I)|SKI)|ISKI)|GHTMUTE|NILCHIK)|O(?:RTH(?: POLE|WAY)|(?:ORV"
  "I|ATA)K|NDALTON|ME)|A(?:(?:(?:NWAL|KN)E|PAS?KIA)K|UKATI BAY)|E(?:"
  "W(?: STUYAH|T)OK|LSON LAGOON|NANA)|U(?:NA(?:PITCHUK|M IQUA)|IQSUT"
  "|LATO))|A(?:N(?:CHOR(?: POINT|AGE)|AKTUVUK(?: PASS)?|(?:DERS|GO)O"
  "N|(?:IA|VI)K)|L(?:(?:EKNAGI|AKANU)K|LAKAKET)|K(?:(?:I(?:ACH)?A|HI"
  "O)K|UTAN)|T(?:(?:MAUTLUA|QASU)K|KA)|RCTIC V(?:ILLAGE|LG)|UKE BAY|"
  "MBLER|DAK)|T(?:(?:U(?:N(?:TUTULI|UN)|LUKS)A|(?:RAPPER CRE|YON)E)K"
  "|A(?:(?:LKEE|KO)TNA|NA(?:CROSS|NA)|TITLEK)|E(?:NAKEE SP(?:RIN)?GS"
  "|LLER)|O(?:K(?:SOOK BAY)?|GIAK)|W(?:IN HILL|O RIVER)S|HORNE BAY)|"
  "P(?:O(?:RT (?:AL(?:EXANDER|SWORTH)|GRAHAM|HEIDEN|LIONS)|INT (?:BA"
  "KER|HOPE|LAY))|E(?:RRYVILLE|TERSBURG|DRO BAY|LICAN)|R(?:T ALEXAND"
  "ER|UDHOE BAY)|ILOT (?:STATION|POINT)|LATINUM|ALMER)|M(?:A(?:N(?:L"
  "EY (?:HOT SPRIN|SP)GS|OKOTAK)|RSHALL)|E(?:(?:YERS CHUC|KORYU)K|NT"
  "ASTA LAKE|TLAKATLA)|O(?:UNTAIN V(?:ILLAGE|LG)|OSE PASS)|I(?:ERS L"
  "AKE|NTO)|C GRATH)|D(?:E(?:NALI(?: NATIONAL)? PARK|LTA J(?:UNCTION"
  "|CT)|ERING)|I(?:LLINGHAM|OMEDE)|O(?:T LAKE|UGLAS)|UTCH HARBOR)|F("
  "?:ORT (?:(?:RICHARDS|YUK)ON|WAINWRIGHT|GREELY)|T (?:RICHARDSON|WA"
  "INWRIGHT)|A(?:LSE PAS|IRBANK)S|RITZ CREEK)|E(?:L(?:MENDORF AFB|FI"
  "N COVE|IM)|(?:MMONA|GEGI|KWO|E)K|(?:NGLISH|DNA) BAY|AGLE(?: RIVER"
  ")?|IELSON AFB|STER)|H(?:O(?:O(?:PER BAY|NAH)|LY CROSS|USTON|MER|P"
  "E)|A(?:LIBUT COVE|INES)|U(?:GHES|SLIA)|YD(?:ABURG|ER)|EALY)|L(?:A"
  "(?:KE MINCHUMINA|RSEN BAY)|(?:ITTLE|TL) DIOMEDE|K MINCHUMINA|OWER"
  " KALSKAG|EVELOCK)|B(?:E(?:T(?:TLES FIELD|HEL)|AVER)|REVIG M(?:ISS"
  "IO|S)N|A(?:DGER|RROW)|IG LAKE|UCKLAND)|G(?:A(?:(?:KO|LE)NA|MBELL)"
  "|O(?:ODNEWS BAY|LOVIN)|LENNALLEN|IRDWOOD|RAYLING|USTAVUS)|W(?:A(?"
  ":INWRIGHT|RD COVE|SILLA|LES)|HIT(?:E M(?:OUNTAI|T)N|TIER)|RANGELL"
  "|ILLOW)|R(?:U(?:SSIAN M(?:ISSIO|S)N|BY)|ED DEVIL|AMPART)|I(?:GIUG"
  "IG|LIAMNA|NDIAN)|O(?:LD HARBOR|UZINKIE)|UNALA(?:KLEET|SKA)|V(?:EN"
  "ETIE|ALDEZ)|QUINHAGAK|YAKUTAT|JUNEAU))))$"
  ,
  /* -- AL -- AL -- AL -- AL -- AL -- AL -- AL -- AL -- AL -- AL -- */
  "(?:\\b)((?^:(?i:(?:C(?:O(?:O(?:SA(?: PINES|DA)|K SPRINGS)|FFEE(?:"
  " SP(?:RIN)?GS|VILLE)|L(?:UMBI(?:AN)?A|LINSVILLE)|A(?:L(?:BUR|IN)G"
  "|TOPA)|TTON(?:DALE|WOOD|TON)|URTLAND|RDOVA|WARTS|DEN|KER|Y)|A(?:R"
  "(?:(?:ROL)?LTON|BON HILL|DIFF)|M(?:P(?: HI|BE)LL|DEN)|HABA (?:HEI"
  "G)?HTS|L(?:VERT|ERA)|STLEBERRY|THERINE|PSHAW)|H(?:A(?:NCELLOR|PMA"
  "N|TOM)|I(?:LDERSBURG|CKASAW)|E(?:ROKEE|LSEA)|OCCOLOCCO|UNCHULA)|R"
  "(?:E(?:STLINE (?:HEIG)?HTS|OLA)|A(?:NE HILL|GFORD)|O(?:SSVILLE|PW"
  "ELL))|L(?:A(?:Y(?:TON)?|NTON)|O(?:VERDALE|PTON)|I(?:NTON|O)|EVELA"
  "ND)|E(?:NT(?:R(?:EVILL)?E|ER POINT)|DAR BLUFF|CIL)|U(?:(?:SSET|B)"
  "A|LLMAN)|ITRONELLE|YPRESS)|S(?:A(?:R(?:DIS(?: CITY)?|ALAND)|INT ("
  "?:STEPHENS|ELMO)|(?:WYERVILL|YR)E|M(?:ANTHA|SON)|L(?:IPTA|EM)|ND "
  "?ROCK|FFORD|GINAW|TSUMA)|T(?:E(?:(?:RRET|WAR)T|VENSON|ELE)|(?:A(?"
  ":PLE|N)|OCK)TON| STEPHENS)|H(?:O(?:RTER(?:VILLE)?|AL CREEK)|E(?:F"
  "FIELD|LBY)|ANNON)|P(?:R(?:ING(?: GARDEN|VILLE)|UCE PINE|OTT)|ANIS"
  "H FORT)|Y(?:L(?:VAN(?: SP(?:RIN)?GS|IA)|ACAUGA)|CAMORE)|U(?:M(?:M"
  "ERDALE|ITON)|LLIGENT|NFLOWER)|(?:O(?:MERVILL|UTHSID)|KIPPERVILL)E"
  "|E(?:M(?:INOLE|MES)|CTION|ALE|LMA)|I(?:L(?:VERHILL|URIA|AS)|PSEY)"
  "|MITHS(?: STA(?:TION)?)?|N(?:OW HILL|EAD)|WEET WATER|COTTSBORO|LO"
  "COMB)|M(?:A(?:R(?:ION(?: J(?:UNCTION|CT))?|GARET|BURY)|G(?:NOLIA("
  "?: SP(?:RIN)?GS)?|AZINE)|XWELL AFB(?: GUNTER ANNEX)?|(?:PLESVILL|"
  "YLEN)E|L(?:COLM|VERN)|FB GUN ANNX|DISON|THEWS)|O(?:U(?:N(?:T(?: ("
  "?:(?:OLIV|HOP)E|VERNON|MEIGS)|AIN BR(?:OO)?K)|DVILLE)|LTON)|N(?:T"
  "(?:EVALLO|GOMERY|ROSE)|ROEVILLE)|O(?:RESVILLE|DY)|R(?:RIS|VIN)|BI"
  "LE)|C(?: (?:C(?:ULLOUGH|ALLA)|WILLIAMS|INTOSH|KENZIE|SHAN)|CULLOU"
  "GH|KENZIE)|I(?:D(?:(?:LAND CIT|WA)Y|FIELD)|LL(?:ERVILLE|BROOK|POR"
  "T|RY)|NTER)|E(?:(?:RIDIANVILL|NTON)E|ADOWBROOK|GARGEL|LVIN|XIA)|U"
  "(?:SC(?:LE SHOALS|ADINE)|NFORD|LGA)|YRTLEWOOD)|B(?:R(?:O(?:OK(?:L"
  "(?:EY F(?:IE)?LD|YN)|SIDE|WOOD)|WNSBORO)|I(?:(?:DGEPOR|LLIAN)T|ER"
  "FIELD|GHTON)|E(?:(?:WTO|ME)N|NT)|AN(?:CHVILLE|TLEY)|DN SPRNGS|UND"
  "IDGE|YANT)|E(?:L(?:L(?:E MINA|WOOD|AMY)|K)|A(?:R CREEK|VERTON|TRI"
  "CE)|SSEMER|NTON|RRY)|O(?:N (?:SECOU|AI)R|LI(?:NGER|GEE)|RDEN SPRI"
  "NGS|YKIN|OTH|AZ)|A(?:Y(?:OU LA ?BATR| MINETT)E|NKS(?:TON)?|ILEYTO"
  "N|KERHILL)|U(?:R(?:N(?:T CORN|WELL)|KVILLE)|TLER|CKS|HL)|L(?:U(?:"
  "E MOUNTAIN|FF PARK)|OUNTSVILLE|ACK)|I(?:G(?: COV|BE)E|LLINGSLEY|R"
  "MINGHAM)|YNUM)|H(?:A(?:R(?:T(?:SELLE|FORD)|PERSVILLE|DAWAY|VEST)|"
  "M(?:(?:MONDVILL|PTON COV)E|ILTON)|(?:(?:LEY|NCE)VILL|TCHECHUBBE)E"
  "|Y(?:NEVILLE|DEN)|ZEL GREEN|CKLEBURG|VANA)|O(?:L(?:L(?:Y(?:(?: PO"
  "N|WOO)D|TREE)|INS)|Y TRINITY|T)|(?:US|R)TON|KES BLUFF|NORAVILLE|P"
  "E HULL|MEWOOD|DGES|OVER)|I(?:G(?:HLAND (?:HOM|LAK)E|DON)|LLSBORO)"
  "|U(?:NTSVILLE|RTSBORO|EYTOWN|XFORD)|E(?:ADLAND|NAGAR|FLIN|LENA)|Y"
  "TOP)|A(?:L(?:EX(?:AND(?:ER CITY|RIA)| CITY)|(?:ICEVILL|PIN)E|BERT"
  "(?:VILLE|A)|L(?:GOOD|EN)|TO(?:ONA|N)|ABASTER|MA)|U(?:BURN(?: UNIV"
  "(?:ERSITY)?)?|TAUGAVILLE)|N(?:D(?:ALUSIA|ERSON)|N(?:EMANIE|ISTON)"
  ")|R(?:L(?:INGTON|EY)|DMORE|ITON|AB)|SH(?:(?:FOR|LAN)D|VILLE)|D(?:"
  "AMSVILLE|DISON|GER)|T(?:TALLA|HENS|MORE)|B(?:BEVILLE|ERNANT)|CMAR"
  "|KRON|XIS)|P(?:I(?:N(?:E (?:(?:LEVE|HIL)L|APPLE)|CKARD|SON)|CKENS"
  "VILLE|KE ROAD|TTSVIEW|EDMONT|SGAH)|E(?:R(?:D(?:UE HILL|IDO)|OTE)|"
  "T(?:ER(?:MA|SO)N|REY)|L(?:L CITY|HAM)|NNINGTON)|A(?:N(?:OLA|SEY)|"
  "INT ROCK|LMERDALE|RRISH)|R(?:I(?:NCETON|CHARD)|A(?:TTVILL|IRI)E)|"
  "L(?:EASANT GR(?:OVE|V)|ANTERSVILLE)|H(?:IL CAMPBELL|ENIX CITY)|OI"
  "NT CLEAR)|F(?:O(?:R(?:T (?:M(?:C CLELLAN|ITCHELL)|D(?:EPOSIT|AVIS"
  ")|RUCKER|PAYNE)|EST(?: HOM|DAL)E|KLAND)|STERS|LEY)|A(?:(?:(?:LKVI"
  "L|UNSDA)L|YETT)E|IR(?:FIELD|HOPE)|CKLER)|R(?:UIT(?:HURST|DALE)|AN"
  "K(?:VILLE|LIN)|ISCO CITY)|L(?:O(?:R(?:ENCE|ALA)|MATON)|AT ROCK)|I"
  "(?:TZPATRICK|VE POINTS)|U(?:LTON(?:DALE)?|RMAN)|T MC ?CLELLAN|YFF"
  "E)|L(?:O(?:W(?:(?:ER PEACH TRE| PEACH TR)E|NDESBORO)|C(?:UST FORK"
  "|KHART)|ACHAPOKA|UISVILLE|XLEY|GAN)|A(?:(?:FAYETT|PIN)E|N(?:GSTON"
  "|ETT)|CEYS SPRING|KE VIEW|VACA|WLEY)|I(?:(?:(?:LLI|SM)A|VINGSTO)N"
  "|N(?:(?:COL|DE)N|EVILLE)|TTLE RIVER)|E(?:(?:XING|IGH)TON|E(?:SBUR"
  "G|DS)|TOHATCHEE|STER|NOX|ROY)|(?:WR PCH TRE|UVERN)E|YNN)|G(?:R(?:"
  "A(?:N(?:D BAY|T)|YSVILLE|HAM|DY)|EEN(?: POND|SBORO|VILLE)|OVE(?: "
  "HILL|OAK))|A(?:INES(?:VILLE|TOWN)|RDEN(?: CITY|DALE)|LL(?:ANT|ION"
  ")|YLESVILLE|DSDEN|NTT)|O(?:OD(?:WA(?:TER|Y)|SPRINGS)|RDON?|SHEN)|"
  "U(?:NTERSVILLE|LF SHORES|RLEY|IN)|E(?:(?:ORGIAN|NEV)A|RALDINE)|LE"
  "N(?: ALLEN|WOOD|COE)|ILBERTOWN)|W(?:A(?:L(?:KER SP(?:RIN)?GS|NUT "
  "GROVE)|T(?:TSVILLE|ERLOO|SON)|(?:VERL|DLE)Y|R(?:RIOR|D)|GARVILLE)"
  "|E(?:ST(?: (?:BLOCTON|GREENE)|OVER)|(?:OGUF|TUMP)KA|LLINGTON|DOWE"
  "E|AVER|BB)|I(?:L(?:SONVILLE|MER|TON)|N(?:FIELD|G))|OOD(?:STOCK|VI"
  "LLE|LAND)|H(?:ISTLER|ATLEY))|D(?:E(?:(?: ARMAN|ATS)VILLE|L(?:MAR|"
  "TA)|ER PARK|MOPOLIS|CATUR|TROIT)|A(?:(?:(?:[DL]E|N)VILL|PHN)E|(?:"
  "(?:VIS|Y)T|WS)ON|UPHIN ISLA?ND)|O(?:U(?:BLE SP(?:RIN)?G|GLA)S|(?:"
  "CEN|R)A|LOMITE|THAN|ZIER)|I(?:X(?:ONS MILLS|IANA)|CKINSON)|U(?:NC"
  "ANVILLE|TTON))|E(?:(?:(?:(?:DWARD|THEL)SVIL|IGHT MI)L|M(?:ELL|PIR"
  ")| TALLASSE)E|L(?:(?:DRIDG|MOR)E|B(?:ERT)?A|KMONT|ROD)|AST(?: (?:"
  "TALLASSEE|BREWTON)|ABOGA)|N(?:TERPRISE|SLEY)|C(?:LECTIC|HOLA)|U(?"
  ":FAULA|TAW)|V(?:ERGREEN|A)|STILLFORK|QUALITY|XCEL|PES)|T(?:US(?:K"
  "EGEE(?: INST(?:ITUTE)?)?|C(?:ALOOS|UMBI)A)|R(?:I(?:NITY|ANA)|USSV"
  "ILLE|AFFORD|ENTON|OY)|H(?:O(?:MAS(?:VILLE|TON)|RSBY)|EODORE)|A(?:"
  "LLA(?:DEGA|SSEE)|(?:NNE|YLO)R)|O(?:WN(?: CREEK|LEY)|[NX]EY)|I(?:B"
  "BIE|TUS)|YLER)|R(?:A(?:N(?:(?:BURN|G)E|DOLPH)|IN(?:BOW CITY|SVILL"
  "E)|GLAND|LPH|MER)|O(?:(?:(?:BERTSDA|GERSVIL)L|ANOK)E|CKFORD|SA)|E"
  "(?:D (?:LEVEL|BAY)|HOBETH|FORM|MLAP|PTON)|U(?:SSELLVILL|TLEDG)E|I"
  "VER(?: FALLS|SIDE)|YLAND)|V(?:A(?:L(?:LEY(?: (?:GRANDE|HEAD))?|HE"
  "RMOSO SP(?:RINGS|G)?)|N(?:DIVER|CE))|E(?:STAVIA(?: H(?:IL)?LS)?|R"
  "(?:BENA|NON))|IN(?:E(?:GAR BEND|MONT)|CENT|A)|LHRMOSO SPGS|REDENB"
  "URGH)|N(?:E(?:W(?: (?:(?:CASTL|HOP|SIT)E|BROCKTON|MARKET)|(?:BER|"
  "TO)N|VILLE|ELL)|EDHAM)|A(?:TURAL BR(?:IDGE|G)|NAFALIA|UVOO)|O(?:R"
  "(?:THPORT|MAL)|TASULGA))|O(?:AK(?: (?:GROVE|HILL)|MAN)|WENS (?:CR"
  "OSS ROA|X R)DS|R(?:ANGE BEACH|RVILLE)|(?:DENVILL|HATCHE)E|P(?:ELI"
  "KA|P)|NEONTA|XFORD|ZARK)|K(?:E(?:LL(?:ERMA|YTO)N|N(?:NEDY|T))|I(?"
  ":NS(?:TON|EY)|MBERLY|LLEN)|NOXVILLE|ANSAS)|J(?:A(?:C(?:K(?:SON(?:"
  "S GAP|VILLE)?)?|HIN)|SPER)|E(?:FFER|MI)SON|O(?:NES|PPA))|I(?:ND(?"
  ":IAN SP(?:RINGS(?: VILLAGE)?|GS)|N SPGS VLG)|R(?:VINGTON|ONDALE)|"
  "DER)|U(?:NION(?: (?:SPRINGS|GROVE)|TOWN)|RIAH)|QUINTON|YORK))))$"
  ,
  /* -- AR -- AR -- AR -- AR -- AR -- AR -- AR -- AR -- AR -- AR -- */
  "(?:\\b)((?^:(?i:(?:C(?:A(?:M(?:MACK V(?:ILLAGE|LG)|P(?: ROBINSON)"
  "?|DEN)|L(?:I(?:CO ROCK|ON)|(?:AMIN)?E|DWELL)|R(?:(?:LISL|THAG)E|A"
  "WAY)|VE (?:SPRINGS|CITY)|DDO (?:VALLEY|GAP)|S(?:[AH]|SCOE)|NEHILL"
  "|BOT)|O(?:L(?:L(?:EGE STA(?:TION)?|INS)|UMBUS|T)|TT(?:ON PLANT|ER"
  ")|N(?:CORD|WAY)|(?:ZAHOM|V)E|M(?:PTON|BS)|R(?:NING|D)|AL HILL|Y)|"
  "H(?:E(?:R(?:OKEE V(?:ILLAGE|LG)|RY VALLEY)|STER)|ARL(?:ESTON|OTTE"
  ")|IDESTER|OCTAW)|E(?:NT(?:ER(?:(?: RIDG|VILL)E|TON)|RAL CITY)|DAR"
  "VILLE|CIL)|L(?:AR(?:K(?:(?:SVIL|EDA)L|RIDG)E|ENDON)|EVELAND|INTON"
  ")|R(?:O(?:CKETTS BL(?:UF)?F|SSETT)|AWFORDSVI?LLE|UMROD)|U(?:SHMAN"
  "|RTIS))|M(?:A(?:R(?:(?:KED TRE|MADUK)E|(?:SHA|VE)LL|I(?:ANNA|ON)|"
  "BLE FALLS|CELLA)|G(?:N(?:OLIA|ESS)|AZINE)|Y(?:FLOWER|SVILLE|NARD)"
  "|N(?:SFIELD|NING|ILA)|MMOTH SP(?:RIN)?G|(?:BELVA|UMEL)LE|(?:DISO|"
  "LVER)N)|O(?:UNT(?: (?:(?:JUDE|ID)A|PLEASANT|VERNON|HOLLY)|AIN(?: "
  "(?:(?:HOM|PIN)E|VIEW)|BURG))|N(?:T(?:ICELLO|ROSE)|(?:ETT|RO)E)|R("
  "?:R(?:ILTON|OW)|O)|SCOW|KO)|C(?: (?:C(?:ASKILL|RORY)|(?:DOUGA|NEI"
  ")L|(?:GEHE|RA)E)|CRORY|GEHEE)|I(?:N(?:ERAL SP(?:RIN)?GS|TURN)|D(?"
  ":LAND|WAY))|E(?:L(?:BOURNE|LWOOD)|N(?:IFEE|A))|U(?:RFREESBORO|LBE"
  "RRY)|T PLEASANT)|B(?:E(?:E(?:(?:CH GROV|DEVILL|B)E| BRANCH)|N(?:T"
  "ON(?:VILLE)?| LOMOND)|LL(?:A VISTA|EVILLE)|R(?:RYVILLE|GMAN)|THEL"
  " (?:HEIG)?HTS|A(?:RDEN|VER)|IRNE|XAR)|R(?:I(?:GGSVILLE|CKEYS|NKLE"
  "Y)|A(?:D(?:FORD|LEY)|NCH)|O(?:CKWELL|OKLAND)|YANT|UNO)|L(?:U(?:FF"
  "(?: CITY|TON)|E MOUNTAIN)|ACK(?: (?:ROC|OA)K|WELL)|YTHEVILLE|EVIN"
  "S)|A(?:L(?:D KNOB|CH)|R(?:LING|TON)|TES(?:VILLE)?|SS(?:ETT)?|UXIT"
  "E|NKS|Y)|O(?:N(?:NERDALE|ANZA|O)|ARD CAMP|ONEVILLE|SWELL|LES)|I(?"
  ":G(?: FLAT|ELOW|GERS)|S(?:MARCK|COE)|RDEYE)|U(?:CK(?:VILLE|NER)|L"
  "L SHOALS|RDETTE|SCH))|H(?:A(?:R(?:R(?:I(?:S(?:BURG|ON)|ET)|ELL)|T"
  "(?:FORD|MAN)|(?:VE|D)Y)|T(?:T(?:IEVILLE|ON)|FIELD)|M(?:BURG|PTON)"
  "|S(?:KELL|TY)|GARVILLE|CKETT|NOVER|VANA|YNES|ZEN)|O(?:T SPRINGS(?"
  ": (?:NATIONAL PARK|VILLAGE))?|L(?:IDAY ISL(?:AND|E)|L(?:Y GROVE|A"
  "ND))|R(?:SESHOE (?:L(?:AKE|K)|BE?ND)|ATIO)|(?:XI|P)E|USTON|WELL)|"
  "I(?:CKORY (?:PL(?:AI)?NS|RIDGE)|G(?:(?:GINSO|DE)N|HLAND)|(?:NDSVI"
  "LL|WASS)E)|E(?:N(?:DERSON|SLEY)|BER SPRINGS|RMITAGE|CTOR|LENA|TH)"
  "|U(?:NT(?:INGTON|SVILLE|ER)?|M(?:PHREY|NOKE)|GHES|TTIG))|S(?:T(?:"
  "A(?:TE UNIV(?:ERSITY)?|R CITY|MPS)|R(?:AWBERRY|ONG)|U(?:TTGART|RK"
  "IE)|EP(?:HENS|ROCK)|ORY)|A(?:INT (?:(?:CHARLE|FRANCI)S|PAUL|JOE)|"
  "L(?:E(?:SVILLE|M)|ADO)|RATOGA|FFELL|GE)|U(?:LPHUR (?:SP(?:RIN)?GS"
  "|ROCK)|MM(?:ERS|IT)|BIACO|CCESS)|H(?:ER(?:IDAN|RILL|WOOD)|ANNON H"
  "ILLS|IRLEY)|P(?:RING(?:FIELD|DALE|TOWN)|ARKMAN)|I(?:(?:LOAM SP(?:"
  "RIN)?G|M)S|DNEY)|C(?:OT(?:LAND|T)|RANTON)|M(?:ITHVILLE|ACKOVER)|W"
  "(?:EET HOME|IFTON)|E(?:DGWICK|ARCY)|OLGOHACHIA|NOW LAKE)|W(?:I(?:"
  "L(?:LI(?:(?:AMS BAPTIST COLLEG|SVILL)E|FORD)|(?:[ST]O|BUR)N|M(?:A"
  "R|OT))|N(?:CHESTER|THROP|SLOW)|EDERKEHR V(?:ILLAGE|G)|TT(?:S SPRI"
  "NGS|ER)|DE(?:MAN|NER)|SEMAN|CKES)|A(?:L(?:D(?:ENBURG|RON|O)|NUT R"
  "IDGE|COTT)|R(?:M SPRINGS|REN|D)|(?:SHINGT|TS)ON|B(?:BASEKA|ASH)|V"
  "ELAND)|E(?:S(?:T(?: (?:MEMPHIS|HELENA|POINT|RIDGE|FORK)|ERN GROVE"
  ")|LEY)|INER)|H(?:E(?:LEN SP(?:RIN)?GS|ATLEY|ELER)|ITE HALL)|(?:MS"
  " COLLEG|YNN)E|RIGHT(?:SVILLE)?|OO(?:DSON|STER))|P(?:O(?:(?:PLAR G"
  "ROV|UGHKEEPSI|TTSVILL)E|(?:WHATA|YE)N|RT(?:LAND|IA)|CAHONTAS|LLAR"
  "D|NCA)|A(?:R(?:K(?:DALE|IN|S)|(?:THEN)?ON|AGOULD|IS)|(?:TTERSO|NG"
  "BUR)N|LESTINE)|E(?:A(?:CH ORCHARD| RIDGE|RCY)|RRY(?:VILLE)?|NCIL "
  "BLUFF|TTIGREW|LSOR|EL)|L(?:EASANT (?:GR(?:OVE|V)|PL(?:AI)?NS)|UME"
  "RVILLE|AINVIEW)|I(?:N(?:E(?: (?:BLUFF|RIDGE)|VILLE)|DALL)|CKENS|G"
  "GOTT)|R(?:A(?:IRIE GROV|TTSVILL)E|ESCOTT|OCTOR|IM)|YATT)|G(?:R(?:"
  "E(?:E(?:N(?:W(?:OOD|AY)| FOREST|BRIER|LAND)|RS FERRY)|GORY)|A(?:V"
  "E(?:L(?: RIDGE|LY)|TTE)|PEVINE|NNIS|DY)|IFFITHVILLE|UBBS)|A(?:R(?"
  ":LAND CITY|FIELD|NER)|SSVILLE|MALIEL|TEWAY)|E(?:N(?:TRY|OA)|ORGET"
  "OWN|PP)|IL(?:L(?:ETT|HAM)|BERT|MORE)|O(?:S(?:NELL|HEN)|ODWIN|ULD)"
  "|U(?:(?:RD|I)ON|Y)|LEN(?:WOOD|COE))|L(?:A(?:KE(?: (?:HAMILTON|VIL"
  "LAGE|CITY)|VIEW)|N(?:EBURG|GLEY)|(?: GRANG|F)E|M(?:BROOK|AR)|VACA"
  "|WSON)|E(?:A(?:CHVILLE|D HILL)|(?:WISVILL|SLI)E|(?:TON|OL|X)A|PAN"
  "TO)|O(?:C(?:UST GROVE|KESBURG)|N(?:(?:SDAL|OK)E|DON)|UANN|WELL)|I"
  "(?:TTLE ROCK(?: A(?:IR FORCE BASE|FB))?|NCOLN|GHT)|R ?AFB|UXORA|Y"
  "NN)|D(?:E(?: (?:VALLS BL(?:UF)?F|QUEEN|WITT)|L(?:A(?:PLAIN|WAR)E|"
  "IGHT|L)|(?:RMO|WI)TT|S(?: ARC|HA)|(?:CATU|E)R|VALLS BLUFF|NNARD)|"
  "A(?:(?:RDANE|NVI)LLE|MASCUS|TTO)|O(?:DDRIDGE|NALDSON|LPH|VER)|I(?"
  ":A(?:MOND CITY|Z)|ERKS)|R(?:ASCO|IVER)|YE(?:SS|R)|UMAS)|E(?:L(?:("
  "?:M SPRING|KIN)S| (?:DORAD|PAS)O|IZABETH|AINE)|V(?:E(?:NING SHADE"
  "|RTON)|ANSVILLE)|U(?:REKA SP(?:RIN)?GS|DORA)|D(?:MONDSON|GEMONT)|"
  "A(?:ST CAMDEN|RLE)|M(?:ERSON|MET)|N(?:GLAND|OLA)|T(?:OWAH|HEL)|GY"
  "PT)|F(?:O(?:R(?:REST CITY|T SMITH|DYCE|EMAN)|U(?:NTAIN (?:HILL|LA"
  "KE)|KE)|X)|A(?:IR(?:FIELD BAY| OAKS)|YETTEVILLE|RMINGTON)|R(?:ENC"
  "HMAN(?:S BAYO| BY)U|IENDSHIP|ANKLIN)|I(?:FTY SIX|SHER)|L(?:IPPIN|"
  "ORAL)|ULTON)|A(?:L(?:T(?:HEIMER|US)|P(?:ENA|INE)|I(?:CIA|X)|M(?:Y"
  "R)?A|EXANDER|LEENE|CO)|R(?:KA(?:NSAS CITY|DELPHIA)|MOREL)|U(?:GUS"
  "TA|BREY|STIN)|SH(?: FLAT|DOWN)|M(?:AGON|ITY)|(?:DON|VOC)A|PPLETON"
  "|NTOINE|TKINS)|R(?:O(?:S(?:E BUD|STON|IE)|(?:UND PO|LA)ND|(?:HW|V"
  ")ER|(?:MANC)?E|CKPORT|GERS|YAL)|A(?:VENDEN(?: SP(?:RIN)?GS)?|TCLI"
  "FF)|E(?:Y(?:DELL|NO)|DFIELD|CTOR)|U(?:SSELL(?:VILLE)?|DY)|I(?:VER"
  "VALE|SON))|T(?:U(?:MBLING SH(?:OA)?LS|R(?:RELL|NER)|CKER(?:MAN)?|"
  "PELO|LL)|I(?:LL(?:AR|Y)|CHNOR|MBO)|(?:EXARKAN|YRONZ)A|R(?:ASKWOOD"
  "|UMANN)|WI(?:N GROVES|ST)|H(?:ORNTON|IDA)|ONTITOWN|AYLOR)|J(?:E(?"
  ":(?:SSIEVILL|NNI)E|R(?:USALEM|SEY)|FFERSON)|O(?:NES(?: MILL|BORO)"
  "|(?:HNSO|RDA)N|INER)|A(?:CKSON(?:VILLE|PORT)|SPER)|U(?:NCTION CIT"
  "Y|DSONIA))|N(?:O(?:R(?:(?:TH LITTLE ROC|FOR)K|PHLET|MAN)| LITTLE "
  "ROCK)|EW(?: (?:EDINBURG|BLAINE)|HOPE|PORT|ARK)|A(?:TURAL DAM|SHVI"
  "LLE)| LITTLE ROCK|LR)|O(?:(?:N(?:EID|I)|KOLON|SCEOL|MAH)A|A(?:K(?"
  ": GROVE|LAND)|RK)|Z(?:A(?:RK|N)|ONE)|(?: KEA|G?DE)N|L(?:D JOE|A)|"
  "IL TROUGH|PPELO|XFORD)|V(?:A(?:N(?:DERVOORT| BUREN|NDALE)|LLEY SP"
  "(?:RIN)?GS)|I(?:OL(?:ET HILL|A)|L(?:LAGE|ONIA))|ENDOR)|K(?:I(?:NG"
  "S(?:LAND|TON)|RBY)|E(?:NSETT|ISER|O)|NO(?:XVILLE|BEL))|U(?:NIONTO"
  "WN|MPIRE|RBANA|LM)|I(?:(?:MBODE|VA)N|DA)|Y(?:ELLVILLE|ORKTOWN)|(?"
  ":QUITMA|ZIO)N))))$"
  ,
  /* -- AS -- AS -- AS -- AS -- AS -- AS -- AS -- AS -- AS -- AS -- */
  "(?:\\b)((?^:(?i:PAGO PAGO)))$"
  ,
  /* -- AZ -- AZ -- AZ -- AZ -- AZ -- AZ -- AZ -- AZ -- AZ -- AZ -- */
  "(?:\\b)((?^:(?i:(?:S(?:A(?:N(?: (?:(?:CARLO|LUI)S|MANUEL|SIMON)|T"
  "A RITA(?: FOOTHILLS)?|DERS)|INT (?:(?:MICHAEL|JOHN)S|DAVID)|(?:DD"
  "LEBROOK|LOM|SAB)E|HUARITA|CATON|FFORD)|U(?:N(?: (?:CITY(?: WEST)?"
  "|VALLEY|LAKES)|SITES)|P(?:ER(?:STITION MTN|IOR)|RSTON MTN|AI)|RPR"
  "ISE)|T(?:A(?:R VALLEY|NFIELD)| MICHAELS|RAWBERRY)|E(?:(?:COND MES"
  "|DON)A|L(?:IGMAN|LS))|O(?:(?:MERT|LOM)ON|NOITA)|PRING(?: VALLEY|E"
  "RVILLE)|(?:COTTSDAL|NOWFLAK)E|HO(?:W LOW|NTO)|IERRA VISTA|KULL VA"
  "LLEY)|C(?:O(?:R(?:ONA(?: DE TUC(?:SON)?)?|DES LAKES|NVILLE|TARO)|"
  "(?:OLIDG|CHIS)E|N(?:GRESS|CHO)|LORADO CITY|TTONWOOD)|A(?:S(?:A GR"
  "ANDE|HION)|M(?:P VERDE|ERON)|VE CREEK|REFREE|TALINA)|H(?:A(?:NDLE"
  "R(?: (?:HEIG)?HTS)?|MBERS)|IN(?:O VALLEY|LE)|LORIDE)|L(?:A(?:Y(?:"
  " SPRINGS|POOL)|RKDALE)|IFTON)|IB(?:ECUE|OLA)|ROWN KING|ENTRAL|TC)"
  "|P(?:A(?:R(?:K(?:S(?: COMM PO)?|ER)|ADISE V(?:ALLE|L)Y)|(?:LO VER"
  "D|G)E|(?:ULDE|YSO)N|TAGONIA)|E(?:TRIFIED FOR(?:EST NATL PK)?|A(?:"
  "CH SPRINGS|RCE)|EPLES V(?:ALLE|L)Y|RIDOT|ORIA)|I(?:SINEMO(?: TRAD"
  "ING POST)?|N(?:E(?:DALE|TOP)?|ON)|RTLEVILLE|CACHO|MA)|O(?:MERENE|"
  "LACCA|RTAL|STON)|RESCOTT(?: V(?:ALLE|L)Y)?|HOENIX)|T(?:O(?:N(?:TO"
  " BASIN|ALEA|OPAH)|L(?:LESON|TEC)|P(?:AWA|OCK)|RTILLA FLAT|MBSTONE"
  ")|E(?:MP(?:L(?:E BAR MARINA| BAR MAR)|E)|EC NOS POS)|U(?:BA(?: CI"
  "TY|C)|MACACORI|CSON)|A(?:YLOR|CNA)|HATCHER|SAILE)|M(?:A(?:R(?:(?:"
  "ICOP|AN)A|BLE CANYON|TINEZ LAKE)|DERA CANYON|NY FARMS|MMOTH|YER)|"
  "O(?:R(?:MON LAKE|RISTOWN|ENCI)|HAVE VALLEY|UNT LEMMON|BILE)|C(?: "
  "NEAL|NARY)|E(?:ADVIEW|SA)|UNDS PARK|IAMI)|G(?:R(?:A(?:Y MOUNTAI|N"
  "D CANYO)N|EE(?:N VALLEY|R)|OOM CREEK)|O(?:LD(?:EN VALLEY| CANYON)"
  "|ODYEAR)|L(?:ENDALE(?: LUKE AFB)?|OBE)|IL(?:A BEND|BERT)|A(?:DSDE"
  "N|NADO)|UADALUPE|BAFAF)|W(?:I(?:N(?:DOW ROCK|KELMAN|SLOW)|LL(?:OW"
  " BEACH|IAMS|COX)|CKENBURG|TTMANN|KIEUP)|H(?:ITE(?: (?:M(?:OUNTAIN"
  " LAKE|TN LK)|HILLS)|RIVER)|Y)|E(?:LLTO|NDE)N|OODRUFF|ADDELL)|L(?:"
  "A(?:KE(?: (?:HAVASU CITY|MONTEZUMA)|SIDE)|VEEN)|U(?:K(?:E(?:VILLE"
  "| AFB)|ACHUKAI)|PTON)|IT(?:CHFIELD P(?:AR)?K|TLEFIELD)|K (?:HAVAS"
  "U CTY|MONTEZUMA)|EUPP)|B(?:L(?:ACK C(?:ANYON CI|YN C)TY|UE(?: GAP"
  ")?)|E(?:NS(?:CH RANCH|ON)|LLEMONT)|U(?:LLHEAD CITY|CKEYE)|(?:O(?:"
  "US|WI)|ISBE)E|A(?:PCHULE|GDAD)|YLAS)|F(?:O(?:R(?:T (?:(?:DEFIANC|"
  "APACH)E|M(?:CDOWELL|OHAVE)|HUACHUCA|THOMAS)|EST LAKES)|UNTAIN H(?"
  ":IL)?LS)|L(?:AGSTAFF|ORENCE)|REDONIA|T GRANT)|A(?:R(?:I(?:ZONA (?"
  ":STATE UNIVERS|C)ITY|VACA)|LINGTON)|PACHE J(?:UNCTION|CT)|(?:VOND"
  "AL|LPIN)E|S(?:H FORK|U)|(?:MAD|J)O|GUILA|NTHEM)|D(?:E(?:SERT HILL"
  "S|NNEHOTSO|WEY)|A(?:VIS MONTHAN AFB|TELAND)|O(?:LAN SPRING|UGLA)S"
  "|U(?:DLEYVILLE|NCAN)|RAGOON|M AFB)|H(?:U(?:A(?:CHUCA CITY|LAPAI)|"
  "MBOLDT)|A(?:PPY JACK|CKBERRY|YDEN)|O(?:(?:LBROO|UC)K|TEVILLA)|E(?"
  ":REFORD|BER)|IGLEY)|R(?:O(?:CK (?:SPRINGS|POINT)|UND ROCK|OSEVELT"
  "|LL)|I(?:O (?:VERDE|RICO)|LLITO|MROCK)|ED (?:VALLEY|ROCK))|K(?:YK"
  "OTSMOVI(?: VILLAGE)?|EA(?:MS CANYON|RNY)|I(?:RKLAND|NGMAN)|A(?:IB"
  "ETO|YENTA))|E(?:L(?:EVEN MILE(?: CORNER)?| MIRAGE|FRIDA|GIN|OY)|H"
  "RENBERG|AGAR|DEN)|Y(?:U(?:MA(?: PROVING GROUND)?|CCA)|OUNG(?:TOWN"
  ")?|ARNELL|PG)|N(?:O(?:RTH RIM|GALES)|A(?:ZLINI|CO)|EW RIVER|UTRIO"
  "SO)|V(?:A(?:L(?:LEY FARMS|ENTINE)|IL)|ERNON)|O(?:R(?:O VALLEY|ACL"
  "E)|VERGAARD|ATMAN)|QU(?:EEN (?:VALLEY|CREEK)|ARTZSITE)|I(?:NDIAN "
  "WELL|RON SPRING)S|J(?:OSEPH CITY|EROME)))))$"
  ,
  /* -- CA -- CA -- CA -- CA -- CA -- CA -- CA -- CA -- CA -- CA -- */
  "(?:\\b)((?^:(?i:(?:S(?:A(?:N(?: (?:(?:F(?:RANCISC|ERNAND)|B(?:ERN"
  "ARDI|RU)N|P(?:ABL|EDR)|YSIDR)O|J(?:UAN (?:CAP(?:ISTRAN)?O|BAUTIST"
  "A)|O(?:AQUIN|SE)|ACINTO)|L(?:U(?:IS (?:OBISPO|REY)|CAS)|(?:EANDR|"
  "ORENZ)O)|M(?:A(?:R(?:COS|INO|TIN)|TEO)|IGUEL)|G(?:(?:ERONIM|REGOR"
  "I)O|ABRIEL)|A(?:N(?:DREAS|SELMO)|RDO)|C(?:LEMENTE|ARLOS)|(?:QUENT"
  "I|SIMEO)N|RA(?:FAEL|MON)|DI(?:EGO|MAS))|T(?:A (?:R(?:OSA(?: VA(?:"
  "LLEY)?)?|ITA P(?:AR)?K)|(?:(?:NEL|PAU)L|(?:SUS)?AN|BARBAR)A|M(?:A"
  "R(?:GAR(?:ITA)?|IA)|ONICA)|C(?:LAR(?:IT)?A|RUZ)|FE SP(?:RIN)?GS|Y"
  "(?:SABEL|NEZ))|EE)|D CITY|FORD|GER)|L(?:I(?:NAS|DA)|TON CITY|YER)"
  "|RATOGA(?: H(?:IL)?LS)?|(?:INT HELEN|MO)A|U(?:SALITO|GUS)|WYERS B"
  "AR|CRAMENTO|TTLEY)|T(?:RA(?:WB(?:ERR(?:Y VALLE)?|RRY VL)Y|T(?:HMO"
  "RE|FORD))|A(?:N(?:D(?:ARD|ISH)|FORD|TON)|LLION SP(?:RIN)?GS)|E(?:"
  "V(?:ENSON R(?:ANC|N)H|INSON)|WARTS P(?:OIN)?T)|I(?:NSON BEACH|RLI"
  "NG CITY)|O(?:NYFORD|CKTON|RRIE)|UDIO CITY)|O(?:U(?:TH (?:(?:(?:EL"
  " MON|GA)T|LAKE TAHO)E|SAN FRANCISCO|DOS PALOS|PASADENA)|LSBYVILLE"
  ")|L(?:ANA BEACH|EDAD|VANG)|M(?:E(?:S BAR|RSET)|IS)|DA SPRINGS|NO["
  "MR]A|QUEL)|H(?:E(?:R(?:MAN (?:V(?:ILLAGE|LG)|OAKS)|IDAN)|(?:EP RA"
  "N|LL BEA)CH)|A(?:STA(?: LAKE)?|DOW HILLS|VER LAKE|FTER|NDON)|INGL"
  "E(?: SP(?:RIN)?GS|TOWN)|OSHONE)|U(?:N(?: (?:V(?:ILLAGE|ALLEY)|CIT"
  "Y)|SET BEACH|NYVALE|LAND|OL)|MM(?:IT CITY|ERLAND)|(?:SANVILL|RFSI"
  "D)E|TTER(?: CREEK)?|ISUN CITY|GARLOAF|LTANA)|E(?:Q(?:UOIA NATIONA"
  "L PAR| NATL P)K|A(?:L BEACH|SIDE)|(?:IAD VAL|E)LEY|(?:PULVED|LM)A"
  "|BASTOPOL)|P(?:R(?:ING(?: (?:VALLEY(?: LAKE)?|GARDEN)|VILLE)|ECKE"
  "LS)|G VALLEY LK|ANISH FLAT)|I(?:ERRA(?: (?:MADRE|CITY)|VILLE)|GNA"
  "L HILL|MI VALLEY|LVERADO)| (?:(?:LAKE TAHO|EL MONT)E|DOS PALOS|PA"
  "SADENA|SAN FRAN)|N(?: (?:JUN BATSTA|LUIS OBISP|BERNRDNO)|ELLING)|"
  "COT(?:T(?:S VALLEY| BAR)|IA)|M(?:ITH RIVER|ARTVILLE)|WALL MEADOWS"
  "|QUAW VALLEY|LOUGHHOUSE|KYFOREST|YLMAR)|C(?:A(?:L(?:I(?:F(?:ORNIA"
  " (?:HOT SPRINGS|CITY)| (?:HOT SPG|CITY))|(?:PATRI|STOG|MES)A|ENTE"
  ")| POLY (?:UNIVERSITY|SLO)|ABASAS(?: H(?:IL)?LS)?|P(?:ELLA|INE)|E"
  "XICO|LAHAN)|R(?:M(?:EL(?: (?:BY THE(?: SEA)?|VALLEY))?|ICHAEL)|DI"
  "FF(?: BY THE SEA)?|L(?:OTTA|SBAD)|NELIAN BAY|PINTERIA|UTHERS|TAGO"
  "|SON)|M(?:P(?: (?:(?:PENDLET|NELS)ON|CONNELL|MEEKER)|(?:O SEC)?O|"
  "TONVILLE|BELL)|(?:ARILL|IN)O|ERON PARK|BRIA)|N(?:YON(?: (?:C(?:OU"
  ")?NTRY|LAKE|DAM))?|T(?:UA CREEK|IL)|OGA PARK|BY)|S(?:T(?:RO(?: VA"
  "LLEY|VILLE)|ELLA|AIC)|MALIA|PAR|SEL)|P(?:I(?:STRANO BEACH|TOLA)|O"
  " BEACH|AY)|THE(?:YS V(?:ALLE|L)|DRAL CI?T)Y|ZADERO|BAZON|YUCOS|DI"
  "Z)|O(?:R(?:RAL(?: DE TIE(?:RRA)?|ITOS)|ONA(?: DE?L MAR|DO)?|N(?:E"
  "LL|ING)|TE MADERA|CORAN)|L(?:(?:U(?:MBI|S)|O?M)A|D SPRINGS|LEGE C"
  "ITY|EVILLE|FAX|TON)|A(?:(?:CHELL|LING)A|RSEGOLD)|T(?:O DE CAZA|TO"
  "NWOOD|ATI)|(?:WAN HEIGHT|PPEROPOLI)S|M(?:PT(?:CHE|ON)|MERCE)|U(?:"
  "LTERVILLE|RTLAND)|V(?:ELO|INA)|STA MESA|HASSET|NCORD|YOTE|BB|OL)|"
  "H(?:I(?:(?:RIACO S(?:UMMI|M)|LCOO)T|N(?:O(?: HILLS)?|ESE CAMP)|C("
  "?:AGO PARK|O))|A(?:L(?:FANT(?: V(?:ALLE|L)Y)?|LENGE)|TSWORTH)|E(?"
  ":RRY VALLEY|STER)|U(?:LA VISTA|ALAR)|OWCHILLA)|R(?:ES(?:CENT (?:M"
  "(?:IL)?LS|CITY)|T(?: PARK|LINE|ON)|SEY)|O(?:W(?:S LANDING|LEY LAK"
  "E)|CKETT|MBERG)|YSTAL(?: CITY|AIRE))|L(?:E(?:ARLAKE(?: (?:P(?:AR)"
  "?K|OA?KS))?|MENTS)|A(?:R(?:KSBURG|EMONT)|YTON)|I(?:PPER MILLS|O)|"
  "OV(?:ERDALE|IS))|E(?:DAR(?: (?:RIDGE|GLEN)|PINES P(?:AR)?K|VILLE)"
  "|NT(?:RAL V(?:ALLE|L)|URY CIT)Y|R(?:RITO|E)S)|I(?:T(?:Y (?:(?:OF "
  ")?INDUSTRY|RANCH)|RUS (?:HEIG)?HTS)|MA)|U(?:(?:LVER CIT|DAH)Y|T(?"
  ":LER|TEN)|PERTINO|YAMA)|MP PENDLETON|TY OF CMMRCE|YPRESS)|P(?:A(?"
  ":L(?:O(?:S VERDES (?:PENINSULA|ESTATES)|MAR (?:M(?:OUNTAI|T)N|PAR"
  "K)| (?:(?:CEDR|ALT)O|VERDE))|M(?: (?:SPRINGS|DESERT)|DALE)|ERMO|A"
  ")|C(?:IFIC(?: (?:P(?:ALISADE|LSD)S|(?:GROV|HOUS)E)|A)|HECO|OIMA)|"
  "R(?:K(?:ER DAM|FIELD)|A(?:MOUNT|DISE)|LIER)|S(?:(?:ADEN|KENT)A|O "
  "ROBLES)|(?:NORAMA CIT|UMA VALLE)Y|TT(?:ERS)?ON|YNES CREEK|ICINES|"
  "JARO)|O(?:RT(?: (?:HUENEM(?:E CBC BAS)?E|COSTA)|OLA(?: (?:VALLE?Y"
  "|HILLS))?|ER(?: RANCH|VILLE))|INT (?:R(?:EYES STATION|ICHMOND)|MU"
  "GU NAWC|ARENA)|T(?:TER VALLEY|RERO)|P(?:E VALLEY|LAR)|LLOCK PINES"
  "|(?:SE|WA)Y|MONA)|I(?:N(?:E(?: (?:M(?:OUNTAIN CLU|TN CL)B|VALLEY|"
  "GROVE)|CREST|DALE)|O(?:N HILLS|LE))|E(?:D(?:MONT|RA)|RCY)|ONEER(?"
  ":TOWN)?|CO RIVERA|SMO BEACH|LOT HILL|TTSBURG|XLEY|RU)|L(?:A(?:YA "
  "(?:DEL REY|VISTA)|CE(?:RVILLE|NTIA)|(?:NAD|TIN)A)|EASANT(?: (?:GR"
  "(?:OVE|V)|HILL)|ON)|S VRDS (?:PNSL|EST)|UMAS LAKE|YMOUTH)|E(?:N(?"
  ":N(?: VALLEY|GROVE)|RYN)|AR(?:SONVILLE|BLOSSOM)|R(?:MANENTE|RIS)|"
  "T(?:ALUM|ROLI)A|BBLE BEACH|SCADERO)|R(?:ESIDIO (?:OF MONTERE|MTR)"
  "Y|(?:T HUENEM|UNEDAL)E|O(?:JECT CITY|BERTA)|INCETON|ATHER)|H(?:IL"
  "(?:LIPS(?: RA?NCH|VILLE)|O)|ELAN)|T (?:R(?:EYES STA|ICHMOND)|MUGU"
  " NAWC)|U(?:MPKIN C(?:ENTE|T)R|LGA))|L(?:A(?: (?:C(?:ANADA(?: FL(?"
  ":INTRIDGE|T))?|RESCENTA)|H(?:ABRA(?: H(?:EIGH|G)TS)?|ONDA)|(?:M(?"
  ":IRAD|ES)|QUINT|JOLL)A|P(?:(?:UEN|OR)TE|ALMA)|SELVA B(?:EA)?CH|(?"
  ":GRANG|VERN)E)|KE(?: (?:A(?:RROWHEAD|LMANOR)|(?:ISABELL|BALBO)A|L"
  "(?:OS ANGELES|A)|VIEW TER(?:RACE)?|ELSINORE|SHERWOOD|FOREST|HUGHE"
  "S|CITY)|(?:HEA|WOO)D|S(?:HOR|ID)E|PORT|VIEW)|GUN(?:A (?:(?:HILL|W"
  "OOD)S|NIGUEL|BEACH)|ITAS)|(?:(?:YTONVIL|WNDA)L|FAYETT)E|T(?:HROP|"
  "ROBE|ON)|N(?:CASTER|DERS)|RK(?:FIELD|SPUR)|M(?:IRADA|ONT)|DERA RA"
  "NCH)|O(?:S(?: (?:A(?:L(?:TO(?:S HILL)?|AM(?:IT)?O)S|NG(?:ELES(?: "
  "AFB)?|LS AFB))|(?:(?:MOLI|BA)N|(?:NIE|GA)T|O(?:LIV|S))OS)|T HILLS"
  ")|M(?:A (?:(?:LIND|RIC)A|MAR)|ITA|POC)|C(?:K(?:EFOR|WOO)|H LOMON)"
  "D|N(?:G B(?:EACH|ARN)|E PINE)|O(?:KOUT|MIS)|WER LAKE|YALTON|LETA|"
  "TUS|DI)|I(?:T(?:TLE(?: (?:VALLEY|RIVER|LAKE)|R(?:IVER|OCK))|CHFIE"
  "LD)|N(?:COLN(?: (?:(?:HEIG)?HT|ACRE)S)?|D(?:SAY|EN|A))|V(?:E(?:RM"
  "ORE| OAK)|INGSTON)|BERTY FARMS|KELY)|E(?:MO(?:ORE(?: NA(?:VAL AIR"
  " STATION|S))?|N (?:GR|C)OVE)|IMERT PARK|ONA VALLEY|E VINING| GRAN"
  "D|WISTON|GGETT|NNOX|BEC)|U(?:CERNE(?: V(?:ALLE|L)Y)?|DLOW)|Y(?:TL"
  "E CREEK|NWOOD|OTH)|K ARROWHEAD|LANO)|M(?:O(?:N(?:T(?:E(?: (?:(?:S"
  "EREN|NID|RI)O|VISTA)|(?:BELL|CIT)O|REY(?: PARK)?)|GOM(?:ERY CREE|"
  "RY CR)K|A(?:GUE|RA)|CLAIR|ROSE)|O(?: HOT SP(?:RIN)?GS|LITH)|ARCH "
  "B(?:EACH|AY)|ROVIA)|UNT(?: (?:(?:(?:H(?:AMILT|ERM)|WILS)O|EDE)N|("
  "?:LAGUN|SHAST)A|AUKUM)|AIN (?:C(?:ENTE|T)R|HOUSE|RANCH|MESA|PASS|"
  "VIEW))|R(?:(?:ONGO V(?:ALLE|L)|ENO VALLE|RO BA)Y|GAN HILL|A[DG]A)"
  "|SS (?:LANDING|BEACH)|KELUMNE H(?:IL)?L|FFETT FIELD|CCASIN|ORPARK"
  "|DESTO|JAVE)|A(?:R(?:I(?:NA(?: DE?L REY)?|(?:COP|POS)A)|CH A(?:IR"
  " RESERVE BASE|RB)|(?:KLEE|YS)VILLE|T(?:INEZ|ELL)|SHALL)|N(?:HATTA"
  "N B(?:EA)?CH|T(?:ECA|ON)|CHESTER)|D(?:E(?:LINE|RA)| RIVER|ISON)|("
  "?:CDOE|XWEL)L|MMOTH LAKES|GALIA|YWOOD|LIBU|THER)|I(?:L(?:L(?: (?:"
  "VALLEY|CREEK)|(?:VILL|BRA)E)|PITAS|FORD)|D(?:WAY CITY|DLETOWN|PIN"
  "ES)|RA(?:(?: LOM|N?D)A|MONTE)|SSION (?:HILLS|VIEJO)| WUK V(?:ILLA"
  "GE|LG)|NERAL)|E(?:N(?:DO(?:CINO|TA)|(?:IFE|TON)E|LO PARK)|ADOW V("
  "?:ALLEY|ISTA)|R(?:IDIAN|CED)|CCA)|C(?: (?:KI(?:NLEYVILLE|TTRICK)|"
  "FARLAND)|CL(?:ELLAN|OUD)|KINLEYVILLE|ARTHUR)|T(?: (?:HAMILTON|BAL"
  "DY)|N (?:HOUSE|RANCH))|U(?:R(?:RIETA|PHYS)|IR BEACH|SCOY)|YERS FL"
  "AT)|B(?:E(?:L(?:L(?: (?:GARDENS|CANYON)|A VISTA|FLOWER)?|VEDERE(?"
  ": TIBURON)?|(?: TIBURO|DE)N|MONT)|A(?:R V(?:ALLEY(?: SPRINGS)?|LY"
  " SPGS)|LE AFB|UMONT)|R(?:MUDA DUNES|RY CREEK|KELEY|ENDA)|N(?: LOM"
  "OND|ICIA|TON)|THEL ISLAND|VERLY HILLS|CKWOURTH)|R(?:O(?:WNS(?: VA"
  "LLEY|VILLE)|OK(?:DALE|S)|ADMOOR VLG|DERICK)|A(?:(?:D(?:BUR|LE)|WL"
  "E)Y|N(?:SCOMB|DEIS))|I(?:DGE(?:VILLE|PORT)|SBANE|ONES)|Y(?:(?:LAN"
  "|T)E|N MAWR)|E(?:NTWOOD|A))|O(?:R(?:REGO SP(?:RIN)?GS|ON)|D(?:EGA"
  "(?: BAY)?|FISH)|N(?:NY DOON|SALL|ITA)|UL(?:DER CREEK|EVARD)|YES H"
  "OT SP(?:RINGS|G)|(?:X CANYO|WMA)N|ONVILLE|LINAS)|A(?:L(?:DWIN (?:"
  "HILLS|PARK)|BOA(?: ISLAND)?|L(?:ARD|ICO))|N(?:NING|GOR|TA)|Y(?: P"
  "OINT|SIDE)|SS(?: LAKE|ETT)|KER(?:SFIELD)?|R(?:STOW|D)|DGER)|I(?:G"
  "(?: (?:B(?:E(?:AR (?:CITY|LAKE)|ND)|AR)|OAK (?:V(?:ALLE|L)Y|FLAT)"
  "|(?:RIVE|SU)R|CREEK|PINE)|GS)|RDS L(?:ANDIN|ND)G|EBER|SHOP|OLA)|U"
  "(?:TT(?:E (?:(?:VALLE|CIT)Y|MEADOWS)|ONWILLOW)|R(?:N(?:T RANCH|EY"
  ")|LINGAME|BANK|REL|SON)|E(?:NA PARK|LLTON))|L(?:A(?:IRSDEN(?:-GRA"
  "EAGLE)?|CKHAWK)|O(?:OMINGTON|CKSBURG)|UE (?:LAKE|JAY)|RSDN-GREAGL"
  "|YTHE)|YRON)|R(?:A(?:N(?:CH(?:O (?:S(?:ANTA (?:MARGARITA|FE)|TA M"
  "ARG)|C(?:UCAMONG|ORDOV)A|PA(?:LOS VERDES|RK)|M(?:URIETA|IRAGE)|DO"
  "MINGUEZ|BELAGO)|ITA)|DSBURG)|I(?:L R(?:OA)?D FLAT|SIN CITY)|GGED "
  "POINT|VENDALE|CKERBY|YMOND|MONA)|O(?:(?:LLING HILL(?:S ESTATE)?|W"
  "LAND H(?:EIGH|GH?)T|YAL OAK)S|S(?:E(?:(?:MEA|WOO)D|VILLE)|S(?:MOO"
  "R)?|AMOND)|U(?:GH(?: AND)? READY|ND M(?:OUNTAI|T)N)|B(?:INSON RA?"
  "NCH|BINS)|HNERT PARK|MOLAND|CKLIN|DEO)|I(?:O (?:(?:LIND|VIST)A|(?"
  ":NID|OS)O|DELL)|VER(?:(?:DAL|SID)E| PINES|BANK)|CH(?:(?:GROV|VAL)"
  "E|MOND)|(?:DGEC|MFO)REST|P(?:LEY|ON)|ALTO)|E(?:D(?:W(?:OOD (?:(?:"
  "V(?:ALLE|L)|CIT)Y|EST(?:ATES)?)|AY)| (?:MOUNTAIN|BLUFF)|ONDO BEAC"
  "H|CREST|LANDS|DING)|S(?:CUE|EDA)|EDLEY|PRESA)|U(?:SSIAN RIVER(?: "
  "MDWS)?|NNING SP(?:RIN)?GS|TH(?:ERFORD)?|BIDOUX|MSEY)|CH(?: (?:CUC"
  "AMONGA|PALOS VRD)|O S(?:ANTA FE|TA MARG))|NCHO (?:(?:CORDOV|MURIE"
  "T)A|DOMINGZ)|LLNG HLS EST|YDE|SM)|W(?:E(?:ST(?: (?:H(?:OLLYWOOD|I"
  "LLS)|LOS ANGELES|TOLUCA LAKE|MENLO PARK|SACRAMENTO|COVINA|POINT)|"
  "L(?:AKE V(?:ILLAGE|LG)|EY)|M(?:INSTER|ORLAND)|CHESTER|PORT|WOOD)|"
  "AVERVILLE|IMAR|LDON|NDEL|OTT|ED)|I(?:L(?:L(?:OW(?: (?:SP(?:RIN)?G"
  "S|CREEK)|S)|I(?:AM|T)S)|D(?:OMAR|WOOD)|(?:MING)?TON|SEYVILLE)|N(?"
  ":T(?:ER(?:HAVEN|S)|ON)|DSOR(?: HILLS)?|CHESTER|NETKA)|TTER SP(?:R"
  "IN)?GS|SHON)|A(?:L(?:NUT(?: (?:(?:CREE|PAR)K|GROVE))?|LACE)|T(?:S"
  "ONVILLE|ERFORD|TS)|RNER SP(?:RIN)?GS|S(?:HINGTON|CO)|(?:UKE|WO)NA"
  ")|O(?:OD(?:LA(?:ND(?: H(?:IL)?LS)?|KE)|(?:BRIDG|VILL|ACR|SID)E|Y)"
  "|FFORD (?:HEIG)?HTS)| (?:LOS ANGELES|TOLUCA LAKE|MENLO PARK|SACRA"
  "MENTO|HOLLYWOOD)|H(?:I(?:T(?:E(?: WATER|THORN)|MORE|TIER)|SKEYTOW"
  "N)|EATLAND)|RIGHTWOOD)|H(?:A(?:(?:M(?:ILTON CIT|MIL VALLE)|R(?:BO"
  "R CIT|MON)|LF MOON BA)Y|W(?:AIIAN G(?:ARDE|D)NS|THORNE)|T(?:HAWAY"
  " PI?NES| CREEK)|CIENDA (?:HEIG)?HTS|N(?:SEN HILLS|FORD)|Y(?:FORK|"
  "WARD)|PPY CAMP|VILAH|ZARD)|O(?:L(?:L(?:Y(?: PARK|GLEN|WOOD)|ISTER"
  ")|T(?:VILLE)?|Y CITY)|R(?:N(?:BROOK|ITOS)|SE CREEK)|P(?:E VALLEY|"
  "LAND)|ME(?:LAN|WOO)D|O(?:PA|D)|NEYDEW)|I(?:DDEN (?:V(?:ALLEY(?: L"
  "AKE)?|L LK)|HILLS)|L(?:L(?:SBOROUGH|TOP MALL)|MAR)|GHLAND(?: PARK"
  ")?| VISTA|CKMAN|NKLEY)|E(?:R(?:(?:ITAGE RA?N|MOSA BEA)CH|CULES|LO"
  "NG|ALD)|L(?:EN(?:DALE|A)|M)|ALDSBURG|SPERIA|BER|MET)|U(?:NTINGT(?"
  ":ON (?:P(?:AR)?K|BEACH)|N BCH)|(?:GHS|R)ON|ME)|Y(?:DESVILLE|AMPOM"
  "))|A(?:L(?:T(?:A(?:(?: LOM|DEN)A|VILLE)?|URAS)|P(?:INE(?: M(?:EAD"
  "O|D)WS)?|AUGH)|(?:ISO VIEJ|VIS)O|B(?:ANY|ION)|AM(?:EDA|O)|DERPOIN"
  "T|LEGHANY|HAMBRA)|R(?:RO(?:W(?:HE(?:AD FARMS|D FARM)|BEAR L(?:AKE"
  "|K))|YO GRANDE)|(?:CA(?:DI|T)|LET|MON)A|B(?:UCKLE|OGA)|T(?:ESIA|O"
  "IS)|(?:OMA|GU)S|NOLD|VIN)|N(?:G(?:EL(?:US OAKS|S CAMP)|WIN)|T(?:E"
  "LOPE|IOCH)|NAPOLIS|DERSON|AHEIM|ZA)|M(?:ERICAN C(?:ANYO|Y)N|(?:AD"
  "OR CIT|BO)Y)|G(?:UA(?: DULCE|NGA)|OURA(?: HILLS)?)|T(?:W(?:ATER|O"
  "OD)|ASCADERO|HERTON)|V(?:E(?:NAL|RY)|ILA BEACH|ALON)|U(?:B(?:ERRY"
  "|URN)|GUST F. HAW)|P(?:PLE(?: VALLEY|GATE)|TOS)|D(?:ELA(?:IDE|NTO"
  ")|IN)|C(?:AMPO|TON)|ERIAL ACRES|HWAHNEE|ZUSA)|F(?:O(?:R(?:T(?: (?"
  ":B(?:IDWELL|RAGG)|HUNTER LIGGETT|IRWIN|JONES|DICK)|UNA)|EST(?: (?"
  ":(?:KNO|FA)LLS|RANCH)|VILLE|HILL)|(?:KS OF SALMO|BESTOW)N)|(?:UNT"
  "AIN V(?:ALLE|L)|STER CIT)Y|OTHILL RA?NCH|NTANA|LSOM|WLER)|A(?:IR("
  "?: (?:OAKS|PLAY)|F(?:IELD|AX))|LL(?: RIVER MILLS|EN LEAF|BROOK)|R"
  "M(?:ERSVILLE|INGTON)|WNSKIN)|I(?:RE(?:STONE P(?:AR)?K|BAUGH)|ELDS"
  " L(?:ANDIN|D)G|VE POINTS|DDLETOWN|SH CAMP|LLMORE|NLEY)|R(?:E(?:NC"
  "H (?:GULCH|CAMP)|E(?:STONE|DOM)|MONT|SNO)|K OF SALMON|AZIER PARK|"
  "IANT)|E(?:L(?:ICITY|LOWS|TON)|ATHER FALLS|RNDALE)|L(?:O(?:RISTON|"
  "URNOY)| RIVER MLS|INTRIDGE)|UL(?:LER)?TON|T H LIGGETT)|T(?:R(?:A("
  "?:BUCO(?: C(?:ANYO|Y)N)?|(?:NQUILLIT|C)Y|V(?:IS AFB|ER))|INI(?:TY"
  " C(?:ENTE|T)R|DAD)|O(?:WBRIDGE|NA)|ES PINOS|UCKEE)|E(?:M(?:PLE(?:"
  " CITY|TON)|ECULA)|R(?:RA BELLA|MO)|HA(?:CHAPI|MA)|C(?:ATE|OPA))|U"
  "(?:OLUMNE(?: M(?:EADO|D)WS)?|STIN(?: MCAS)?|L(?:ELAK|AR)E|JUNGA|R"
  "LOCK|PMAN)|W(?:ENTYNIN(?:E PALMS(?: MCB)?| PLM)|IN (?:BRIDGE|PEAK"
  ")S|AIN(?: HARTE)?)|H(?:O(?:USAND (?:PA?LM|OAK)S|RNTON)|E(?: SEA R"
  "ANCH|RMAL)|REE RIVERS)|O(?:L(?:UCA (?:TER(?:RACE)?|LAKE)|LHOUSE)|"
  "PA(?:NGA|Z)|RRANCE|MALES)|A(?:HO(?:E (?:VISTA|CITY)|MA)|(?:YLORSV"
  "ILL|LMAG)E|RZANA|FT)|I(?:(?:BUR|PT)ON|ONESTA))|E(?:L(?: (?:S(?:E("
  "?:RENO CAR|GUNDO)|OBRANTE)|C(?:E(?:RRIT|NTR)O|AJON)|M(?:(?:IRAG|O"
  "NT)E|ACERO)|DORADO(?: H(?:IL)?LS)?|(?:VERAN|NID|TOR)O|GRANADA|POR"
  "TAL)|K(?: (?:CREEK|GROVE))?|IZABETH L(?:AKE|K)|(?:VERT|MIR)A|DRID"
  "GE)|A(?:ST (?:(?:LOS ANGELE|NICOLAU)S|RANCHO DOMINGUEZ|PALO ALTO|"
  "IRVINE)|GLE(?: (?:M(?:OUNTAI|T)N|ROCK)|VILLE)|R(?:LIMART|P))|M(?:"
  "ER(?:ALD HILLS|YVILLE)|IGRANT GAP|PIRE)|S(?:C(?:ONDIDO|ALON)|T LS"
  " ANGLS|PARTO|SEX)|D(?:WARDS(?: AFB)?|EN VALLEY|GEWOOD|ISON)| (?:R"
  "NCHO DMNGZ|PALO ALTO)|(?:T(?:IWAND|N)|UREK)A|NCIN(?:ITAS|O)|CHO L"
  "AKE|XETER)|G(?:R(?:E(?:EN(?: V(?:ALLEY(?: LAKE)?|LY LK)|(?:FIEL|W"
  "OO)D|VI(?:LLE|EW)|BRAE)|NADA)|A(?:N(?:ADA HILLS|D TERRACE|ITE BAY"
  ")|SS VALLEY|EAGLE|TON)|I(?:(?:ZZLY FLAT|ME)S|DLEY)|OVE(?:R BEACH|"
  "LAND))|L(?:EN(?:(?: ELL|HAV)EN|D(?:ALE|ORA)|N(?:VILLE)?|COE)|ASSE"
  "LL(?: PARK)?|MN HOT SPGS)|O(?:L(?:D(?: R(?:IVER|UN)|EN HILLS)|ETA"
  ")|(?:RMA|SHE)N|ODYEARS BAR|NZALES)|A(?:R(?:DEN(?: (?:VALLEY|GROVE"
  ")|A)|BERVILLE)|(?:SQUE|L)T|VIOTA|ZELLE)|U(?:A(?:DALUPE|LALA|STI|T"
  "AY)|(?:ERNEVILL|STIN)E|INDA)|E(?:ORGE(?: AFB|TOWN)|YSERVILLE|RBER"
  ")|IL(?:MAN HOT SPRINGS|ROY))|D(?:E(?:L(?: (?:REY(?: OAKS)?|(?:MA|"
  "SU)R)|ANO|HI)|S(?:ERT (?:HOT SPRINGS|CENTER)|CANSO)|VORE H(?:EI)?"
  "GHTS|ATH VALLEY|ER PARK|NAIR)|O(?:(?:S (?:PAL|RI)O|BBIN|RRI)S|UGL"
  "AS (?:CITY|FLAT)|WN(?:IEVILLE|EY)|VE CANYON|CKWEILER|YLE)|A(?:V(?"
  ":IS(?: CREEK)?|ENPORT)|N(?:A POINT|VILLE)|R(?:DANELLE|WIN)|LY CIT"
  "Y|GGETT)|I(?:A(?:MOND (?:SP(?:RIN)?GS|BAR)|BLO)|SCOVERY BAY|LLON "
  "BEACH| GIORGIO|NUBA|XON)|U(?:N(?:CANS MILLS|NIGAN|SMUIR|LAP)|TCH "
  "FLAT|LZURA|ARTE|BLIN|RHAM|COR)|SRT HOT SPGS|RYTOWN)|N(?:O(?:R(?:T"
  "H(?: (?:H(?:I(?:GHLAND|LL)S|OLLYWOOD)|(?:PALM SPRING|EDWARD)S|(?:"
  "SAN JUA|TUSTI)N|RICHMOND|FORK)|RIDGE|STAR)|WALK|DEN|CO)| PALM SPR"
  "INGS|VATO)|E(?:W(?:B(?:ERRY SP(?:RIN)?GS|URY PARK)|PORT (?:BEACH|"
  "COAST)| (?:ALMADEN|CUYAMA)|(?:HA|E)LL|CASTLE|ARK|MAN)|VADA CITY|E"
  "DLES|LSON|STOR)| (?:H(?:IGHLANDS|OLLYWOOD)|PALM SP(?:RIN)?GS|RICH"
  "MOND|SAN JUAN)|I(?:C(?:OLAUS|ASIO|E)|P(?:OMO|TON)|LAND)|A(?:TIONA"
  "L CITY|VARRO|PA)|U(?:BIEBER|T TREE|EVO))|V(?:A(?:L(?:LE(?:Y (?:V("
  "?:ILLAGE|LG)|SP(?:RIN)?GS|CENTER|FORD|HOME)|(?:CIT|J)O)| VERDE|EN"
  "CIA|YERMO)|N(?:DENBE?RG AFB| NUYS)|CAVILLE|FB)|E(?:R(?:D(?:UGO CI"
  "TY|EMONT)|N(?:ALIS|ON))|TERANS ADM(?:(?:I(?:NISTRATIO)?)?N)?|N(?:"
  "TURA|ICE))|I(?:LLA (?:GRANDE|PARK)|N(?:EBURG|TON|A)|CTOR(?:VILLE)"
  "?|S(?:ALI|T)A|EW PARK|DAL)|OLCANO)|O(?:R(?:O(?:(?: GRAND|VILL)E|S"
  "I)|ANGE(?:(?: COV|VAL)E)?|L(?:EANS|AND)|I(?:NDA|CK)|EGON HOUSE|CU"
  "TT)|AK(?: (?:(?:GLE|RU)N|HILLS|PARK|VIEW)|(?:VIL|DA)LE|L(?:AND|EY"
  ")|HURST|WOOD)|L(?:YMPIC V(?:ALLE|L)Y|(?:ANCH|EM)A|D STATION|IVEHU"
  "RST)|C(?:EAN(?:SIDE|O)|CIDENTAL|OTILLO)|N(?:IZUKA AFB|TARIO|YX)| "
  "NEALS|BRIEN|XNARD|JAI)|K(?:E(?:N(?:(?:TFIEL|WOO)D|SINGTON)|LS(?:E"
  "Y(?:VILLE)?|O)|R(?:NVILLE|MAN)|TTLEMAN CI?TY|E(?:LER|NE)|YES)|I(?"
  ":NG(?:S(?: (?:CANYON(?: NAT(?:IONAL P|L PAR)K)?|BEACH)|BURG)| CIT"
  "Y)|T CARSON|RKWOOD)|N(?:IGHTS(?: (?:L(?:ANDIN|ND)G|FERRY)|EN)|EEL"
  "AND)|A(?:GEL CANYON|WEAH)|LAMATH(?: RIVER)?|ORBEL|YBURZ|CNP)|J(?:"
  "O(?:H(?:NSON V(?:ALLE|L)Y|ANNESBURG)|SHUA TREE|LON)|A(?:C(?:KSON|"
  "UMBA)|M(?:ESTOWN|UL)|NESVILLE)|U(?:N(?:CTION CITY|IPER HILLS|E LA"
  "KE)|LIAN)|E(?:SS RANCH|NNER))|I(?:N(?:D(?:I(?:AN WELLS|O)|EPENDEN"
  "CE)|GLEWOOD|VERNESS|YOKERN)|(?:R(?:WINDAL|VIN)|VANHO)E|MPERIAL(?:"
  " B(?:EA)?CH)?|SL(?:A VISTA|ETON)|O(?:WA HILL|NE)|DYLLWILD|GO)|Y(?"
  ":O(?:SEMITE N(?:ATIONAL PAR|TP)K|R(?:BA LINDA|KVILLE)|UNTVILLE|LO"
  ")|U(?:C(?:CA VALLEY|AIPA)|BA CITY)|E(?:TTEM|RMO)|ANKEE HILL|REKA)"
  "|U(?:NI(?:V(?: OF CAL SANTA BARBARA|ERSAL CI?TY)|ON CITY)|C(?: BE"
  "RKELEY|LA|SB|I)|P(?:PER LAKE|LAND)|KIAH)|QU(?:A(?:IL VALLEY|RTZ H"
  "ILL)|INCY)|Z(?:AMOR|ENI)A|29 PALMS))))$"
  ,
  /* -- CO -- CO -- CO -- CO -- CO -- CO -- CO -- CO -- CO -- CO -- */
  "(?:\\b)((?^:(?i:(?:C(?:O(?:L(?:O(?:RADO (?:SP(?:RIN)?GS|CITY)| (?"
  ":CITY|SPGS))|UMBINE V(?:ALLE|L)Y|LBRAN)|AL(?: CREEK|DALE|MONT)|R("
  "?:DILLERA|TEZ|Y)|M(?:MERCE CITY|O)|N(?:EJOS|IFER)|(?:KEDAL|P)E|TO"
  "PAXI| SPGS|WDREY)|H(?:E(?:Y(?:ENNE (?:MOUNTAIN AFB|W(?:EL)?LS)| M"
  "TN AFB)|R(?:RY H(?:ILLS(?: VILLAGE)?|L VLG)|AW))|I(?:MNEY ROCK|VI"
  "NGTON)|ROMO|AMA)|A(?:D(?:ET STATION|DOA)|S(?:TLE ROCK|CADE)|R(?:B"
  "ONDALE|R)|(?:PULI|LHA)N|NON CITY|HONE|MPO)|R(?:E(?:ST(?:ED BUTT|O"
  "N)|ED)E|A(?:WFORD|IG)|O(?:WLEY|OK)|IPPLE CREEK)|E(?:NT(?:E(?:NNIA"
  "L|R)|RAL CITY)|DAREDGE)|L(?:I(?:FTON|MAX)|ARK)|IMARRON)|S(?:A(?:N"
  "(?:GRE DE CRI(?:STO RANCHES)?| (?:(?:ACACI|PABL)O|LUIS)|D DUNES M"
  "O|FORD)|GUACHE|PINERO|RGENTS|LIDA)|T(?:E(?:AMBOAT SPR(?:INGS)?|RL"
  "ING)|RA(?:SBURG|TTON)|ARKVILLE|ONEHAM)|I(?:L(?:VER(?: (?:CLIFF|PL"
  "UME)|T(?:HORNE|ON))|T)|MLA)|O(?:UTH(?:ERN UTE INDIAN RESERVAT| FO"
  "RK)|MERSET|PRIS)|N(?:OWMASS(?: V(?:ILLAGE|LG))?|YDER)|E(?:D(?:GWI"
  "CK|ALIA)|VERANCE|IBERT)|H(?:ERIDAN(?: LAKE)?|AWNEE)|U(?:GAR CITY|"
  "PERIOR)|L(?:ICK ROCK|ATER)|CHRIEVER AFB| UTE INDIAN|PRINGFIELD|WI"
  "NK)|L(?:A(?: (?:(?:J(?:UNT|AR)|VET)A|SALLE)|KE(?: (?:GEORGE|CITY)"
  "|WOOD)|S(?:T CHANCE| ANIMAS)|(?:(?:ZE|M)A|RKSPU)R|(?:FAYET|POR)TE"
  "|IRD)|O(?:G LANE V(?:ILLAGE|LG)|N(?:E ?TREE|GMONT)|U(?:ISVILLE|VI"
  "ERS)|CHBUIE|VELAND|WRY|MA)|I(?:MON(?: C(?:ORRECTIONAL FACILITY|RR"
  "CTNL))?|(?:TTLET|ND)ON|VERMORE)|E(?:ADVILLE|WIS)|Y(?:CAN|ONS)|UCE"
  "RNE)|G(?:R(?:E(?:E(?:N(?: M(?:OUNTAIN FAL|TN F)LS|WOOD V(?:ILLAGE"
  "|LG))|LEY)|AT SAND DUNES NATIONAL MO)|AN(?:D (?:J(?:UNCTION|CT)|L"
  "AKE)|ADA|ITE|BY|T)|OVER)|L(?:EN(?:WOOD SP(?:RIN)?GS| HAVEN|DALE)|"
  "ADE PARK)|A(?:R(?:D(?:EN CITY|NER)|CIA)|LETON|TEWAY)|E(?:ORGETOWN"
  "|NOA)|IL(?:CREST|MAN|L)|U(?:NNISON|FFEY)|OLDEN|YPSUM)|M(?:O(?:N(?"
  ":T(?:E(?: VIST|ZUM)A|BELLO|CLAIR|ROSE)|UMENT|ARCH)|UNTAIN V(?:ILL"
  "AGE|LG)|(?:LIN|SC)A|RRISON|FFAT|DEL)|A(?:N(?:(?:ITOU SP(?:RIN)?G|"
  "CO)S|(?:ZANOL|ASS)A)|R(?:BLE|VEL)|SONVILLE|THESON|YBELL|HER|CK)|E"
  "(?:S(?:A(?: VERDE(?: NATIONAL PARK)?)?|ITA)|R(?:EDITH|INO)|EKER|A"
  "D)|I(?:LLIKE|NTUR)N|C C(?:LAVE|OY))|P(?:A(?:R(?:A(?:CHUTE|DOX)|SH"
  "ALL|KER|LIN)|L(?:MER LAK|ISAD)E|GOSA SP(?:RIN)?GS|O(?:NIA|LI)|DRO"
  "NI)|UEBLO(?: (?:DEP(?:OT ACTIVITY| AC)|WEST))?|L(?:A(?:CER|TTE)VI"
  "LLE|EASANT VIEW)|I(?:(?:N(?:ECLIFF)?|ERC)E|TKIN)|O(?:NCHA SP(?:RI"
  "N)?GS|WDERHORN)|E(?:TERSON AFB|NROSE|YTON|ETZ)|HIPPSBURG|RITCHETT"
  ")|B(?:R(?:I(?:G(?:GSDALE|HTON)|STOL)|ECKENRIDGE|AN[DS]ON|OOMFIELD"
  "|USH)|E(?:(?:AVER CREE|DROC)K|(?:LLVU|THUN)E|RTHOUD|NNETT|ULAH)|U"
  "(?:R(?:LINGTON|NS)|FFALO CREEK|ENA VISTA)|O(?:(?:ULDE|W MA)R|N(?:"
  "CARBO|D)|YERO|ONE)|A(?:TTLEMENT MESA|YFIELD|ILEY|SALT)|LA(?:CK HA"
  "WK|NCA)|TLMT MESA|YERS)|H(?:O(?:T(?: S(?:ULPHUR SPRINGS|LPHR SPR)"
  "|CHKISS)|(?:MELAK|EHN)E|L(?:YOKE|LY)|OPER|WARD|YT)|A(?:(?:MILTO|X"
  "TU|YDE)N|RT(?:MAN|SEL)|S(?:WELL|TY)|LE)|I(?:LL(?:ROS|SID)E|GHLAND"
  "S RANCH)|E(?:NDERSON|REFORD|SPERUS|ENEY)|GHLNDS RANCH|U(?:DSON|GO"
  ")|YGIENE)|F(?:O(?:RT (?:(?:L(?:UPT|Y)O|MORGA)N|C(?:OLLINS|ARSON)|"
  "GARLAND)|X(?:FIELD|TON)|UNTAIN|WLER)|R(?:A(?:NKTOWN|SER)|UIT(?:VA"
  "LE|A)|EDERICK|ISCO)|L(?:OR(?:ISSANT|ENCE)|AGLER|EMING)|EDERAL H(?"
  ":EIGH|G)TS|A(?:IRPLAY|RISTA)|IRESTONE|T CARSON)|W(?:E(?:ST(?:MINS"
  "TER|CLIFFE|ON)|L(?:LINGTON|DONA)|TMORE)|I(?:L(?:D HORSE|LARD|EY)|"
  "N(?:TER PARK|DSOR)|GGINS)|A(?:L(?:S(?:ENBURG|H)|DEN)|T(?:TENBURG|"
  "KINS)|RD)|O(?:OD(?:(?:LAND PAR|Y CREE)K|ROW)|LCOTT)|H(?:EAT RIDGE"
  "|ITEWATER)|RAY)|E(?:L(?:DORADO SPR(?:INGS|G)|K SPRINGS|IZABETH| J"
  "EBEL|BERT)|A(?:(?:STLAK|GL)E|TON|DS)|D(?:GEWATER|WARDS)|V(?:ERGRE"
  "EN|ANS)|CK(?:ERT|LEY)|(?:MPIR|RI)E|STES PARK|NGLEWOOD|GNAR)|A(?:R"
  "(?:(?:RIB|VAD)A|LINGTON|APAHOE|BOLES)|L(?:M(?:ONT|A)|LENSPARK|AMO"
  "SA)|U(?:RORA|STIN|LT)|G(?:UILAR|ATE)|(?:KRO|SPE)N|NTON(?:ITO)?|VO"
  "N(?:DALE)?|MHERST|TWOOD)|R(?:ED(?: (?:FE(?:ATHER LAKE| LK)S|CLIFF"
  ")|(?:STON|VAL)E)|O(?:CK(?:Y FORD|VALE)|LLINSVILLE|GGEN|MEO)|A(?:N"
  "(?:GELY|D)|MAH)|I(?:DGWAY|FLE|CO)|USH|YE)|N(?:OR(?:TH(?: (?:AVOND"
  "ALE|GLENN)|GLENN)|WOOD)|E(?:W (?:CASTLE|RAYMER)|DERLAND)|AT(?:URI"
  "TA|HROP)|I(?:NAVIEW|WOT)|U(?:CLA|NN)| AVONDALE)|D(?:E(?:L(?: NORT"
  "E|HI|TA)|ER TRAIL| BEQUE|CKERS|NVER|ORA)|I(?:NOSAUR|LLON|VIDE)|O("
  "?:VE CREEK|LORES)|U(?:[MP]ONT|RANGO)|ACONO|RAKE)|T(?:O(?:W(?:AOC|"
  "NER)|PONAS)|W(?:IN LAK|O BUTT)ES|H(?:ATCHER|ORNTON)|(?:ELLURID|YR"
  "ON)E|RIN(?:CHERA|IDAD)|IM(?:NATH|PAS)|ABERNASH)|O(?:R(?:CHARD(?: "
  "CITY)?|DWAY)|L(?:NEY SPRINGS|ATHE)|(?:HIO CIT|URA)Y|AK CREEK|PHIR"
  "|TIS|VID)|U(?:NITED STATES AIR FORCE ACAD|S(?: AIR FORCE|AF ACADE"
  "MY)| S A F ACADEMY|TLEYVILLE)|K(?:I(?:T(?: CARSON|TREDGE)|OWA|RK|"
  "M)|E(?:ENESBURG|YSTONE|RSEY)|REMMLING|ARVAL)|V(?:I(?:L(?:L(?:A GR"
  "OVE|EGREEN)|AS)|RGINIA DALE|CTOR)|ERNON|AIL|ONA)|J(?:A(?:(?:MESTO"
  "W|NSE)N|ROSO)|O(?:HNSTOWN|ES)|EFFERSON|ULESBURG)|I(?:D(?:A(?:HO S"
  "PRINGS|LIA)|LEDALE)|NDIAN HILLS|GNACIO|LIFF)|Y(?:ELLOW JACKET|(?:"
  "AMP|UM)A|ODER)))))$"
  ,
  /* -- CT -- CT -- CT -- CT -- CT -- CT -- CT -- CT -- CT -- CT -- */
  "(?:\\b)((?^:(?i:(?:W(?:E(?:ST(?: (?:HA(?:RT(?:FO?R|LAN)D|VEN)|S(?"
  ":IMSBURY|UFFIELD)|CORNWALL|REDDING|GRANBY|MYSTIC)|BROOK|PORT|ON)|"
  "THERSFIELD|ATOGUE)|I(?:N(?:D(?:SOR(?: LOCKS|VILLE)?|HAM)|CHEST(?:"
  "ER CENTE|R CT)R|STED)|L(?:LI(?:MANTIC|NGTON)|TON))|A(?:SHINGTON(?"
  ": D(?:EPO)?T)?|TER(?:BURY|FORD|TOWN)|RREN(?:VILLE)?|LLINGFORD|URE"
  "GAN)|O(?:OD(?:STOCK(?: V(?:ALLE|L)Y)?|B(?:RIDGE|URY))|LCOTT)|HITN"
  "EYVILLE| HAVEN)|S(?:O(?:UTH(?: (?:W(?:I(?:ND(?:HAM|SOR)|LLINGTON)"
  "|OODSTOCK)|GLASTONBURY|BRITAIN|KENT|LYME)|INGTON|BURY|PORT)|MERS("
  "?:VILLE)?)|T(?:A(?:FFORD(?: SP(?:RIN)?GS|VILLE)?|MFORD)|O(?:RRS M"
  "AN(?:SFIE|F)LD|NINGTON)|E(?:VENSON|RLING)|RATFORD)| (?:W(?:ILLING"
  "TON|OODSTOCK)|GLASTONBURY)|A(?:L(?:ISBURY|EM)|NDY HOOK)|H(?:E(?:L"
  "TO|RMA)|ARO)N|I(?:LVER LANE|MSBURY)|(?:COTLAN|UFFIEL)D|EYMOUR)|N("
  "?:OR(?:TH(?: (?:(?:(?:STONING|CAN)TO|FRANKLI|HAVE)N|GR(?:OSVENORD"
  "ALE|ANBY)|W(?:ESTCHESTER|INDHAM)|BRANFORD)|F(?:IEL|OR)D)|W(?:ALK|"
  "ICH)|FOLK)|EW(?: (?:PRESTON(?: MARBLE DALE)?|(?:BRITAI|CANAA|LOND"
  "O)N|(?:FAIRFIEL|MILFOR)D|HA(?:RTFORD|VEN))|(?:INGTO|TOW)N)| (?:(?"
  ":STONINGTO|FRANKLI)N|GROSVENORDL|WESTCHESTER|BRANFORD)|AUGATUCK|I"
  "ANTIC)|E(?:AST(?: (?:HA(?:RT(?:FOR|LAN)D|(?:MPTO|VE)N|DDAM)|(?:G("
  "?:LASTONBUR|RANB)|KILLINGL)Y|W(?:INDSOR(?: HILL)?|OODSTOCK)|(?:BE"
  "RLI|CANAA)N|LYME)|FORD|ON)| (?:(?:GLASTONBUR|KILLINGL)Y|W(?:INDSO"
  "R HL|OODSTOCK))|LLINGTON|NFIELD|SSEX)|B(?:R(?:O(?:OK(?:F(?:LD CTR"
  "|IELD)|LYN)|AD BROOK)|I(?:DGE(?:WATER|PORT)|STOL)|ANFORD)|E(?:TH("
  "?:LEHEM|ANY|EL)|ACON FALLS|RLIN)|A(?:L(?:LOUVILLE|TIC)|RKHAMSTED|"
  "NTAM)|O(?:TSFORD|LTON|ZRAH)|ISHOPS CO(?:RNE)?R|LOOMFIELD|URLINGTO"
  "N)|M(?:A(?:N(?:SFIELD (?:C(?:ENTE|T)R|D(?:EPO|P)T)|CHESTER)|R(?:L"
  "BOROUGH|ION)|CYS BY MAIL|SHANTUCKET|DISON)|I(?:DDLE(?: HADDAM|FIE"
  "LD|BURY|TOWN)|L(?:LDALE|FORD))|O(?:N(?:TVILL|RO)E|O(?:DUS|SUP)|RR"
  "IS)|E(?:LROSE|RIDEN)|YSTIC)|C(?:O(?:L(?:LINSVILLE|CHESTER|EBROOK|"
  "UMBIA)|RNWALL(?: BR(?:IDGE|G))?|VENTRY|S COB|BALT)|AN(?:T(?:ON(?:"
  " CENTER)?|ERBURY)|AAN)|ENT(?:RAL V(?:ILLAGE|LG)|ERBROOK)|H(?:ES(?"
  ":HIRE|TER)|APLIN)|ROMWELL|LINTON)|P(?:L(?:A(?:IN(?:FIELD|VILLE)|N"
  "TSVILLE)|EASANT V(?:ALLE|L)Y|YMOUTH)|O(?:MFRET(?: C(?:ENTE|T)R)?|"
  "QUONOCK|RTLAND)|(?:AWCAT|EQUAB)UCK|R(?:OSPECT|ESTON)|INE MEADOW|U"
  "TNAM)|G(?:R(?:O(?:SVENOR D(?:ALE|L)|TON)|EEN(?:S FARMS|WICH)|ISWO"
  "LD|ANBY)|A(?:YLORDSVILLE|LES FERRY)|(?:EORGETOW|ILMA|OSHE)N|LAS(?"
  ":TONBURY|GO)|UILFORD)|R(?:I(?:DGE(?:FIELD|WAY)|VER(?:SIDE|TON))|E"
  "DDING(?: (?:CEN(?:TER)?|RIDGE))?|O(?:CK(?:Y HI|FA)LL|XBURY|GERS))"
  "|H(?:A(?:D(?:DAM(?: NECK)?|LYME)|R(?:WINTON|TFORD)|M(?:PTO|DE)N|W"
  "LEYVILLE|NOVER)|(?:UNTINGT|EBR)ON|IGGANUM)|T(?:A(?:(?:RIFF|FT)VIL"
  "LE|CONIC)|O(?:RRINGTON|LLAND)|HOM(?:AST|PS)ON|ERRYVILLE|RUMBULL)|"
  "O(?:LD (?:GREENWICH|SAYBROOK|MYSTIC|LYME)|(?:AK(?:VIL|DA)L|RANG)E"
  "|XFORD|NECO)|L(?:(?:AKE(?:VILL|SID)|YM)E|I(?:TCHFIELD|SBON)|E(?:B"
  "ANON|DYARD))|D(?:A(?:N(?:IELSON|BURY)|YVILLE|RIEN)|E(?:EP RIVER|R"
  "BY)|URHAM)|V(?:ER(?:NON(?: ROCKV(?:ILLE|L))?|SAILLES)|OLUNTOWN)|A"
  "(?:(?:(?:BING|MS)T|V)ON|N(?:DOVER|SONIA)|SHFORD)|FA(?:(?:RMINGTO|"
  "BYA)N|LLS VILLAGE|IRFIELD)|K(?:EN(?:SINGTON|T)|ILLINGWORTH)|UN(?:"
  "ION(?:VILLE)?|CASVILLE)|QU(?:AKER HILL|INEBAUG)|YA(?:LESVILLE|NTI"
  "C)|JEWETT CITY|IVORYTON))))$"
  ,
  /* -- DC -- DC -- DC -- DC -- DC -- DC -- DC -- DC -- DC -- DC -- */
  "(?:\\b)((?^:(?i:(?:NAV(?:AL (?:SEA SYS(?:TEMS COMMAND)?|ANACOST A"
  "NNEX)|Y ANNEX)|(?:US MARINE CORPS BARRAC|MARINE BARR)KS|F(?:ORT(?"
  ": LESLEY J)?|T L J) MCNAIR|WASHINGTON(?: NA(?:VY YARD)?)?|ANACOST"
  "IA(?: ANX)?|BOLLING AFB|RIGGS BANK|PENTAGON))))$"
  ,
  /* -- DE -- DE -- DE -- DE -- DE -- DE -- DE -- DE -- DE -- DE -- */
  "(?:\\b)((?^:(?i:(?:M(?:I(?:L(?:L(?:SBORO|VILLE)|FORD|TON)|DDLETOW"
  "N)|A(?:R(?:SHALLTON|YDEL)|GNOLIA|NOR)|ONTCHANIN|BNA)|C(?:LA(?:Y(?"
  ":MONT|TON)|RKSVILLE)|AMDEN(?: WYO(?:MING)?)?|H(?:RISTIANA|ESWOLD)"
  ")|D(?:OVER(?: A(?:IR FORCE BASE|FB))?|EL(?:AWARE CITY|MAR)|AGSBOR"
  "O)|F(?:E(?:NWICK ISL(?:AND|E)|LTON)|R(?:ANKFORD|EDERICA)|ARMINGTO"
  "N)|L(?:I(?:TTLE CREEK|NCOLN)|E(?:IPSIC|WES)|ONG NECK|AUREL)|S(?:E"
  "(?:LBYVILLE|AFORD)|AINT GEORGES|TANTON|MYRNA)|B(?:E(?:TH(?:ANY BE"
  "ACH|EL)|AR)|RIDGEVILLE|LADES)|H(?:AR(?:(?:RINGT|BES)ON|TLY)|O(?:C"
  "KESSI|USTO)N)|W(?:I(?:LMINGTON|NTERTHUR)|OODSIDE|YOMING)|G(?:REEN"
  "(?:VILLE|WOOD)|EORGETOWN)|N(?:EW(?: CASTLE|PORT|ARK)|ASSAU)|R(?:E"
  "HOBOTH B(?:EA)?CH|OCKLAND)|E(?:L(?:LENDAL|SMER)E|DGEMOOR)|T(?:ALL"
  "EYVILLE|OWNSEND)|(?:PORT PEN|YORKLY)N|O(?:CEAN VIEW|DESSA)|K(?:IR"
  "KWOOD|ENTON)|VIOLA))))$"
  ,
  /* -- FL -- FL -- FL -- FL -- FL -- FL -- FL -- FL -- FL -- FL -- */
  "(?:\\b)((?^:(?i:(?:S(?:A(?:INT (?:(?:GEORGE ISLAN|CLOU)D|PETE(?: "
  "BEACH|RSBURG)|J(?:AMES CITY|OHNS)|L(?:UCIE WEST|EO)|AUGUSTINE|TER"
  "ESA|MARKS)|N(?:TA (?:R(?:OSA BEA|SA B)CH|FE)|D(?:E(?:RSO|STI)N| L"
  "AKE)| (?:ANTONI|MATE)O|FORD|IBEL)|T(?:ELLITE B(?:EA)?CH|SUMA)|L(?"
  ":T SPRINGS|EM)|FETY HARBOR|RASOTA)|U(?:N(?:NY (?:ISL(?:ES BEA| B)"
  "CH|HILLS)| CITY(?: C(?:ENTE|T)R)?|RISE)|M(?:M(?:ER(?:LAND KEY|FIE"
  "LD)|RLND KEY)|TERVILLE|ATRA)|GARL(?:OAF(?: (?:SHRS|KEY))?|F SHRS)"
  "|(?:RFSID|WANNE)E)|T(?: (?:PETE(?:RSBURG(?: BEACH)?| B(?:EA)?CH)?"
  "|GEORGE ISL|JAMES CITY|LUCIE WEST|AUGUSTINE|TERESA)|(?:EINHATCHE|"
  "ARK)E|OCK ISLAND|UART)|O(?:UTH(?: (?:PA(?:LM BEACH|SADENA)|(?:DAY"
  "TON|FLORID)A|MIAMI|BAY)|WEST RANCHES|PORT)|PCHOPPY|RRENTO)|E(?:A("
  "?: RANCH L(?:AKE|K)S|CREST)|B(?:ASTIAN|RING)|(?:MINO|VIL)LE|WALLS"
  " POINT|FFNER)|I(?:LVER SP(?:RIN)?GS|NGER ISLAND|ESTA KEY|DELL)| ("
  "?:PA(?:LM BCH|SADENA)|DAYTONA(?: BCH)?)|HA(?:DY (?:GROVE|HILLS)|L"
  "IMAR|RPES)|W(?:ITZERLAND| RANCHES)|P(?:RING HILL|ARR)|COTTSMOOR|N"
  "EADS|YDNEY)|C(?:A(?:P(?:E (?:C(?:ORAL(?: S(?:OUTH)?)?|ANAVERAL)|S"
  "AN BLAS|HAZE)|TIVA)|N(?:A(?:VERAL A(?:IR STATION|S)|L POINT)|TONM"
  "ENT|DLER)|R(?:R(?:OLLWOOD|ABELLE)|L FISHER|OL CITY|YVILLE)|SS(?:E"
  "LBERRY|ADAGA)|LLA(?:HAN|WAY)|MPBELLTON)|O(?:CO(?:NUT(?: (?:CREEK|"
  "GROVE)|CREEK)|A(?: BEACH)?| RIVER)|R(?:AL (?:SPRING|GABLE)S|TEZ)|"
  "(?:OPER CIT|NCH KE)Y|TTONDALE|PELAND|LEMAN)|H(?:A(?:MPIONS G(?:AT"
  "E|T)|TTAHOOCHEE)|O(?:CTAW BEACH|KOLOSKEE)|I(?:EFLAND|PLEY)|RISTMA"
  "S|ULUOTA)|R(?:YSTAL (?:SP(?:RIN)?GS|BEACH|RIVER)|ES(?:CENT CITY|T"
  "VIEW)|OSS C(?:REEK|ITY)|AWFORDVILLE)|L(?:A(?:R(?:KSVILLE|CONA)|IR"
  " MEL(?: CITY)?)|E(?:ARWATER(?: BEACH)?|WISTON|RMONT)|OUD LAKE)|IT"
  "(?:R(?:US (?:(?:SP(?:RIN)?G|HILL)S|RIDGE)|A)|Y OF SUNRISE)|E(?:NT"
  "(?:ER HILL|URY)|CIL FIELD|LEBRATION|DAR KEY)|U(?:TLER (?:RIDGE|BA"
  "Y)|DJOE KEY)|YPRESS(?: G(?:ARDE|D)NS)?|PE CANAVERAL)|P(?:A(?:L(?:"
  "M(?: (?:B(?:EACH(?: (?:GARDEN|SHORE)S)?|CH (?:GDN|SHR)S|AY)|S(?:P"
  "RING|HORE)S|C(?:OAST|ITY)|HARBOR)|A (?:CEI|SOL)A|ETTO(?: BAY)?|DA"
  "LE)|ATKA)|NA(?:MA CITY(?: BEACH)?|CEA)|TRICK A(?:IR FORCE BASE|FB"
  ")|SS A GRILLE(?: BEACH)?|R(?:KLAND|RISH)|(?:HOKE|C)E|ISLEY|XTON)|"
  "O(?:RT (?:S(?:A(?:INT (?:JO(?:HN|E)|LUCIE)|LERNO)|T (?:JO(?:HN|E)"
  "|LUCIE))|C(?:ANAVERAL|HARLOTTE)|ORANGE|RICHEY)|N(?:CE (?:DE LEON|"
  "INLET)|TE VEDRA(?: BEACH)?)|IN(?:T WASHINGTON|CIANA)|M(?:PANO BEA"
  "CH|ONA PARK)|LK CITY)|I(?:NE(?:CR(?:EST(?: POSTAL STORE)?|AFT)| ("
  "?:(?:CASTL|RIDG)E|HILLS)|L(?:LAS PARK|AND)|TTA)|ERSON)|E(?:N(?:SA"
  "COLA(?: B(?:EA)?CH)?|NEY FARMS)|MBROKE P(?:I?NES|ARK)|RR(?:INE|Y)"
  ")|T (?:C(?:ANAVERAL|HARLOTTE)|WASHINGTON|ORANGE)|L(?:A(?:NT(?: CI"
  "TY|ATION)|CIDA)|YMOUTH)|U(?:NTA GORDA|TNAM HALL)| C BEACH|RINCETO"
  "N)|M(?:A(?:R(?:ATHON(?: SH(?:ORE|R)S)?|CO ISLAND|Y ESTHER|IANNA|G"
  "ATE)|Y(?:PORT NAV(?:AL STATION| S)|O)|N(?:A(?:LAPAN|SOTA)|GO)|C(?"
  ":DILL AFB|CLENNY)|D(?:EIRA BEACH|ISON)|S(?:ARYKTOWN|COTTE)|GNOLIA"
  " SQ(?:UARE)?|TLACHA(?: ISLES?)?|L(?:ABAR|ONE)|ITLAND|XVILLE)|I(?:"
  "D(?: (?:TORCH KEY|FLORIDA)|DLE(?: TORCH KEY|BURG)|WAY)|AMI(?: (?:"
  "(?:S(?:PRING|HORE)|GARDEN|LAKE)S|BEACH))?|R(?:AMAR(?: BEACH)?|OMA"
  "R LAKES)|C(?:CO(?:SUKEE)?|ANOPY)|L(?:LIGA|TO)N|NNEOLA|MS)|O(?:UNT"
  " (?:PL(?:EASANT|YMOUTH)|DORA)|(?:ORE HAVE|RRISTO)N|NT(?:ICELLO|VE"
  "RDE)|SSY HEAD|LINO)|E(?:L(?:BOURNE(?: (?:V(?:ILLAGE|LG)|B(?:EA)?C"
  "H))?|ROSE)|RRITT IS(?:LAND)?|XICO BEACH|DLEY)|C (?:INTOSH|ALPIN|D"
  "AVID)|T PL(?:EASANT|YMOUTH)|U(?:LBERRY|RDOCK)|YAKKA CITY)|L(?:A(?"
  ":KE(?: (?:C(?:LARKE(?: SHORES)?|ITY|OMO)|P(?:A(?:NASOFFKEE|RK)|LA"
  "CID)|H(?:A(?:MILTON|RBOR)|ELEN)|BU(?:ENA VISTA|TLER)|M(?:ONROE|AR"
  "Y)|W(?:ALES|ORTH)|ALFRED|GENEVA|SUZY)|WOOD R(?:AN)?CH|SHORE|LAND)"
  "|U(?:D(?:ER(?:DALE (?:BY THE SEA|LAKES)|HILL)| (?:BY SEA|LAKES))|"
  "RE(?:L HIL)?L)|N(?:ARK V(?:ILLAGE|LG)|D O LAKES|TANA)|(?:[DZ]Y LA"
  "K| CROSS|COOCHE|BELL)E|MONT|WTEY|RGO)|O(?:NG(?:(?:BOAT)? KEY|WOOD"
  ")|WE(?:R SUGARLOAF KEY|LL)|XAHATCHEE(?: GROVES)?|C(?:HLOOSA|KHART"
  ")|UGHMAN|RIDA)|I(?:T(?:TLE TORCH KEY|HIA)|GHTHOUSE P(?:OIN)?T|VE "
  "OAK)|E(?:E(?:SBURG)?|HIGH ACRES|CANTO)|K (?:PANASOFFKE|BUENA VIS)"
  "|U(?:DLAM|LU|TZ)|TL TORCH KEY|WR SUGARLOAF|XHTCHEE GRVS|YNN HAVEN"
  "|LOYD)|B(?:A(?:Y(?: (?:HARBOR I(?:SLAND)?|PINE)S|ONET POINT)|R(?:"
  "EFOOT B(?:(?:EA)?CH|AY)|BERVILLE|TOW)|L(?: HARBOUR|DWIN|M)|S(?:IN"
  "GER|COM)|BSON PARK|GDAD|KER)|R(?:A(?:D(?:EN(?:TON(?: B(?:EA)?CH)?"
  "| RIVER)|LEY)|N(?:FORD|DON))|O(?:OK(?:SVILLE|ER)|NSON)|I(?:NY BRE"
  "EZES|STOL)|Y(?:CEVILLE|ANT)|UCE)|E(?:LL(?:E(?:AIR(?: (?:B(?:L(?:U"
  "FFS|F)|(?:EA)?CH)|SH(?:ORE|R)S))?| (?:GLAD|ISL)E|VIEW)|VIEW)?|VER"
  "LY HILLS)|O(?:NI(?:TA SP(?:RIN)?GS|FAY)|CA (?:GRANDE|RATON)|WLING"
  " GREEN|YNTON BEACH|KEELIA|STWICK)|I(?:G (?:TORCH|PINE) KEY|SCAYNE"
  " PARK)|U(?:ENA VENTURA LAKES|(?:SH|N)NELL)|LOUNTSTOWN|VL)|W(?:E(?"
  ":S(?:T(?: (?:PA(?:LM B(?:EA)?CH|RK)|M(?:ELBOURNE|IAMI)|DELRAY BEA"
  "CH|HOLLYWOOD)|(?:CHAS|VILL)E|ON)|LEY CHAPEL)|L(?:L(?:INGTO|BOR)N|"
  "AKA)|(?:EKI WACHE|IRSDAL)E|KIVA SP(?:RINGS|G)|WAHITCHKA|BSTER)|I("
  "?:N(?:TER (?:(?:GARD|HAV)EN|SP(?:RIN)?GS|BEACH|PARK)|DERMERE)|L(?"
  ":BUR BY(?: THE)? SEA|TON MANORS|LISTON|DWOOD)|MAUMA)|A(?:KULLA SP"
  "(?:RIN)?GS|L(?:NUT HILL|DO)|(?:CISS|HNET)A|U(?:CHULA|SAU)|TERSOUN"
  "D|BASSO|VERLY)| (?:(?:DELRAY|PLM) BCH|HOLLYWOOD|MELBOURNE)|O(?:RT"
  "H(?:INGTON SPRINGS|NGTN SPG)|ODVILLE)|HITE SPRINGS)|H(?:O(?:M(?:E"
  "(?:STEAD(?: A(?:IR FORCE BASE|FB))?| SHOPPING|LAND)|OSASSA(?: SP("
  "?:RINGS|G))?)|L(?:L(?:Y(?: HILL|WOOD)|ISTER)|MES BEACH|IDAY|DER|T"
  ")|WEY IN (?:THE HIL|H)LS|RSESHOE B(?:EA)?CH|(?:BE SOUN|SFOR)D)|I("
  "?:GH(?:LAND (?:B(?:EA)?CH|CITY)| SPRINGS)|A(?:LEAH(?: G(?:ARDE|D)"
  "NS)?|WASSEE)|LL(?:SBORO B(?:EA)?CH|IARD))|A(?:L(?:LANDALE(?: BEAC"
  "H)?|NDLE BCH)|INES C(?:REEK|ITY)|V(?:ERHILL|ANA)|WTHORNE|STINGS|M"
  "PTON|RMONY)|U(?:TCHINSON IS(?:LAND)?|RLBURT F(?:IE)?LD|DSON)|E(?:"
  "RNANDO(?: B(?:EA)?CH)?|ATHROW)|YPOLUXO)|F(?:L(?:OR(?:IDA (?:A (?:"
  "AND M UNIVERSITY|& M)|STATE(?: UNIVERSITY)?|CITY)|A(?:L CITY|HOME"
  ")|ENCE VILLA?)|A(?:MINGO LO?DGE|GLER BEACH)|EMING ISL(?:AND|E))|O"
  "(?:R(?:T (?:M(?:YERS(?: BEACH)?|C COY|EADE)|W(?:ALTON BEACH|HITE)"
  "|(?:LAUDERDAL|PIERC)E|DENAUD|OGDEN)|EST CITY)|UNTAIN)|E(?:RN(?:AN"
  "DINA(?: BEACH)?| PARK|DALE)|L(?:LSMERE|DA)|DHAVEN)|R(?:UIT(?:LAND"
  " P(?:AR)?K| COVE)|OSTPROOF|EEPORT)|T (?:(?:WALTON|MYERS) BCH|LAUD"
  "ERDALE|DENAUD)|A(?:NNING SP(?:RIN)?GS|IRFIELD))|T(?:A(?:M(?:PA(?:"
  " PALMS)?|ARAC)|RPON SP(?:(?:RI)?N)?GS|LL(?:AHASSEE|EVAST)|V(?:ERN"
  "IER|ARES)|NGERINE)|E(?:RRA CEIA(?: IS(?:LAND)?)?|MPLE TER(?:RACE)"
  "?|(?:QUEST|LOGI)A)|R(?:E(?:ASURE IS(?:LAND)?|NTON)|AILER EST(?:AT"
  "ES)?|I(?:NIT|LB)Y)|I(?:M(?:E CUSTOMER SERVIC)?E INC|(?:ERRA VERD|"
  "TUSVILL|C)E|OGA)|OWN (?:OF NOCATEE|N COUNTRY)|H(?:E VILLAGES|ONOT"
  "OSASSA)|N OF NOCATEE|WN N CNTRY|YNDALL AFB)|N(?:O(?:RTH(?: (?:(?:"
  "LAUDERDAL|VENIC)E|BAY V(?:ILLAGE|LG)|P(?:ALM BEACH|ORT)|MIAMI(?: "
  "BEACH)?|F(?:OR)?T MYERS|REDINGTON BEACH)|DALE)|(?: F(?:OR)?T MYER"
  "|KOMI)S|BLETON|CATEE|MA)|E(?:W(?: (?:P(?:(?:OR)?T RICHE|RT RCH)Y|"
  "SMYRNA(?: BEACH)?)|BERRY)|PTUNE BEACH)| (?:(?:(?:MIAMI|PALM) BEA|"
  "REDNGTN B)CH|F(?:OR)?T MYERS|LAUDERDALE)|A(?:LCREST|RANJA|VARRE|P"
  "LES)|IC(?:EVILLE|HOLS)|W PRT RCHY)|G(?:R(?:A(?:N(?:D(?: (?:ISLAND"
  "|RIDGE)|E POINTE|IN)|T(?: V(?:ALKA|LK)RIA)?)|CEVILLE|SSY KEY|HAM)"
  "|E(?:EN(?:(?: (?:C(?:OVE SPRIN|V SP)G|ACRE)|ACRE)S|SBORO|VILLE|WO"
  "OD)|TNA)|OVE(?: CITY|LAND))|O(?:LDEN(?: BEACH|ROD)|NZALEZ|ODLAND|"
  "ULDS|THA)|LEN(?: (?:S(?:AIN)?T MARY|RIDGE)|WOOD)|ULF(?: (?:HAMMOC"
  "K|BREEZE|STREAM)|PORT)|E(?:ORGETOWN|NEVA)|AINESVILLE|IBSONTON)|O("
  "?:R(?:ANGE (?:SP(?:RIN)?GS|CITY|LAKE|PARK)|L(?:O VISTA|ANDO)|MOND"
  " BEACH|CHID)|C(?:H(?:LOCKONEE(?: BAY)?|OPEE)|(?:EAN RIDG|OE)E|(?:"
  "KLAWAH|AL)A)|L(?:YMPIA H(?:EIGH|G)TS|D(?: TOWN|SMAR)|USTEE)|AK(?:"
  "LAND(?: PARK)?| HILL)|(?:PA LOCK|DESS|ZON)A|K(?:EECHOBEE|AHUMPKA)"
  "|V(?:ERSTREET|IEDO)|S(?:PREY|TEEN)|N(?:ECO|A)|TTER CREEK| BRIEN|X"
  "FORD|JUS)|A(?:L(?:T(?:AMONTE SP(?:RINGS|G)|(?:OON|H)A|URAS)|L(?:I"
  "GATOR P(?:OIN)?T|ANDALE)|(?:A(?:CHU|FAY)|OM|V)A|YS BEACH|FORD)|P("
  "?:O(?:LLO BEACH|PKA)|ALACHICOLA)|R(?:C(?:ADIA|HER)|IPEKA|GYLE)|V("
  "?:E(?: MARI|NTUR)A|ON PARK)|TLANTI(?:C B(?:EA)?CH|S)|N(?:NA MARIA"
  "|THONY)|ST(?:ATULA|OR)|MELIA ISLAND|ZALEA PARK|UBURNDALE)|D(?:E(?"
  ":ER(?:FIELD B(?:EA)?CH| ISLAND)|(?:FUNIAK| LEON) SP(?:RIN)?GS|L(?"
  ":RAY BEACH|TONA|AND)|BARY|STIN)|A(?:Y(?:T(?:ONA BEACH(?: SHORES)?"
  "| BCH SH))?|NIA(?: BEACH)?|V(?:ENPORT|IE)|DE CITY)|U(?:N(?:(?:NEL"
  "LO|EDI)N|DEE)|KE FIELD AFS|CK KEY|ETTE|RANT)|O(?:CTORS INLET|WLIN"
  "G PARK|NA VISTA|RAL|VER)|INSMORE|FAFS)|I(?:N(?:D(?:IA(?:N(?: (?:R"
  "(?:(?:K(?:S BEA| B)|OCKS BEA)CH|IVER SHORES)|L(?:AKE ESTATES|K ES"
  "T)|CREEK VILLAGE|HARBOUR BEACH|SHORES)|TOWN)|LANTIC)|N (?:RIV SHR"
  "S|HBR BCH)| (?:CRK VLG|HBR BCH))|T(?:ER(?:CESSION CITY|LACHEN)|RC"
  "SION CTY)|(?:VERNES|GLI)S|LET BEACH)|S(?:LA(?:ND GROVE|MORADA)|TA"
  "CHATTA)|MMOKALEE)|E(?:A(?:ST(?: (?:ROCKLAND KEY|PALATKA)|LAKE WEI"
  "R|POINT)|(?:GLE LAK|U GALLI)E|TON(?: PARK|VILLE)|RLETON)|L(?: (?:"
  "JOBEAN|PORTAL)|(?:LEN|K)TON|FERS|OISE)|V(?:ERGLADES(?: CITY)?|INS"
  "TON)|DG(?:EW(?:ATER|OOD)|AR)|N(?:TERPRISE|GLEWOOD)| ROCKLAND KE?Y"
  "|(?:STE|B)RO|GLIN AFB|USTIS)|R(?:O(?:SE(?:MARY B(?:EA)?CH|LAND)|Y"
  "AL P(?:ALM BEA|LM B)CH|TONDA WEST|CKLEDGE)|E(?:D(?:INGT(?:ON (?:B"
  "(?:EA)?CH|SHORES)|N SHOR)| BAY|DICK|LAND)|UNION)|I(?:V(?:ER(?: RA"
  "NCH|VIEW)|IERA BEACH)|DGE MANOR(?: ESTATES)?|CHLAND)|A(?:MROD KEY"
  "|IFORD)|U(?:BONIA|SKIN)|DG MNR EST)|K(?:E(?:Y(?: (?:WEST(?: NA(?:"
  "VAL AIR STATION|S))?|COL(?:ONY BEA| B)CH|BISCAYNE|LARGO)|STONE H("
  "?:EIGH|G)TS)|N(?:NE(?:DY SP(?:ACE CENTER| CT)|TH CITY)|ANSVILLE|D"
  "ALL))|I(?:N(?:GSLEY LAKE|ARD)|LLARNEY|SSIMMEE)|NGSLY LK|ATHLEEN)|"
  "J(?:A(?:C(?:KSONVILLE(?: (?:BEACH|N A S))?|OB)|X (?:NAVAL AIR|BCH"
  ")|SPER|Y)|U(?:PITER(?: INLET(?: COLONY)?)?|LINGTON CR(?:EE)?K|NO "
  "BEACH)|E(?:N(?:SEN BEACH|NINGS)|ROME)|ONESVILLE|PV)|V(?:I(?:LLAGE"
  " OF (?:PALMETTO BAY|WELLINGTON|GOLF)|RGINIA G(?:ARDE|D)NS|ERA)|A("
  "?:NDERBILT(?: BEACH)?|L(?:PARAIS|RIC)O)|E(?:R(?:O BEACH|NON)|N(?:"
  "ICE|US))|LG (?:WELLINGTN|OF GOLF))|U(?:NI(?:V(?:ERSITY (?:OF(?: ("
  "?:(?:SOUTH FLORID|TAMP)A|MIAMI))?|P(?:AR)?K)| OF (?:MIAMI|TAMPA))"
  "|ON PARK)|P(?:PER SUGARLOAF KEY|R SUGARLOAF)|(?:MATILL|LET)A)|Y(?"
  ":EEHAW(?: JUNCTION)?|A(?:NKEETOWN|LAHA)|OUNGSTOWN|BOR CITY|ULEE)|"
  "Z(?:E(?:PHYRHILLS|LLWOOD)|OLFO SPRINGS)|QU(?:AIL HEIGHTS|INCY))))"
  ")$"
  ,
  /* -- FM -- FM -- FM -- FM -- FM -- FM -- FM -- FM -- FM -- FM -- */
  "(?:\\b)((?^:(?i:(?:POHNPEI|KOSRAE|CHUUK|YAP))))$"
  ,
  /* -- GA -- GA -- GA -- GA -- GA -- GA -- GA -- GA -- GA -- GA -- */
  "(?:\\b)((?^:(?i:(?:S(?:A(?:INT (?:SIMONS IS(?:LAND)?|GEORGE|MARYS"
  ")|ND(?:Y SP(?:RIN)?GS|ERSVILLE)|UTE(?:E NACOOCHE|[- ]NACOCH)E|R(?"
  ":GENT|DIS)|PELO ISLAND|LE CITY|VANNAH|SSER)|T(?:O(?:NE M(?:OUNTAI"
  "|T)N|CK(?:BRIDGE|TON)|VALL)|A(?:T(?:E(?:NVILLE|SBORO)|HAM)|PLETON"
  ")| SIMONS IS(?:LAND)?|ILL(?:MORE|WELL)|EPHENS)|U(?:M(?:MER(?:VILL"
  "E|TOWN)|NER)|GAR (?:VALLEY|HILL)|(?:NNY SID|WANE)E|RRENCY|CHES)|H"
  "(?:A(?:R(?:PSBURG|ON)|DY DALE|NNON)|ELLMAN(?: BL(?:UF)?F)?|ILOH)|"
  "O(?:(?:CIAL CIRCL|UTH BAS)E|PERTON)|Y(?:LV(?:ESTER|ANIA)|CAMORE)|"
  "C(?:OT(?:TDALE|LAND)|REVEN)|P(?:AR(?:KS|TA)|RINGFIELD)|E(?:A ISLA"
  "ND|VILLE|NOIA)|M(?:ITHVILLE|YRNA|ARR)|IL(?:VER CREEK|OAM)|KY VALL"
  "EY|NELLVILLE|WAINSBORO)|C(?:O(?:L(?:L(?:EGE PARK|INS)|(?:QUIT|BER"
  ")T|UMBUS|EMAN)|N(?:CORD|YERS|LEY)|R(?:NELIA|DELE)|V(?:INGTON|ENA)"
  "|(?:CHRA|TTO)N|M(?:MERCE|ER)|O(?:LIDGE|SA)|BB(?:TOWN)?|GDELL|HUTT"
  "A)|A(?:R(?:(?:TER|NE)SVILLE|(?:ROL)?LTON)|L(?:HOUN|VARY)|M(?:ILLA"
  "|AK)|VE SPRING|SSVILLE|DWELL|NT?ON|TAULA|IRO)|L(?:A(?:RK(?:(?:ESV"
  "IL|DA)LE|STON)|[XY]TON)|E(?:VELAND|RMONT)|I(?:NCHFIELD|MAX)|Y(?:A"
  "TTVILLE|O)|OUDLAND)|H(?:E(?:ST(?:NUT M(?:OUNTAI|T)N|ER)|RRYLOG)|A"
  "(?:TSWORTH|MBLEE|UNCEY)|(?:ICKAMAUG|UL)A)|E(?:DAR(?: SPRINGS|TOWN"
  ")|NTERVILLE|CIL)|R(?:A(?:WFORD(?:VILLE)?|NDALL)|ESCENT)|U(?:LLODE"
  "N|THBERT|MMING|SSETA)|ISCO)|M(?:O(?:U(?:NT(?: (?:(?:VERN|ZI)ON|(?"
  ":BER|AI)RY)|AIN CITY|VILLE)|LTRIE)|R(?:(?:GA(?:NTO)?|VE)N|R(?:IS|"
  "OW)|ELAND)|N(?:T(?:ICELLO|EZUMA|ROSE)|ROE)|ODY A(?: F |F)B|LENA)|"
  "A(?:R(?:SHALLVILLE|TIN(?:EZ)?|BLE HILL|IETTA)|N(?:(?:CHESTE|O)R|S"
  "FIELD|ASSAS)|Y(?:SVILLE|FIELD)|(?:BLET|DIS|C)ON|(?:TTHEW|XEY)S|UK"
  ")|I(?:L(?:L(?:E(?:DGEVILLE|N)|WOOD)|(?:TO|A)N|NER)|D(?:VILLE|LAND"
  "|WAY)|NERAL BLUFF|TCHELL)|E(?:R(?:CER UNIVERSITY|(?:IDIA|SHO)N)|T"
  "(?:CALF|TER)|ANSVILLE|LDRIM|SENA|IGS|NLO)|C(?: (?:CAYSVILL|INTYR|"
  "RA)E|DONOUGH)|U(?:RRAYVILLE|SELLA)|YSTIC)|B(?:O(?:W(?:DON(?: J(?:"
  "UNCTION|CT))?|ERSVILLE|MAN)|(?:N(?:EVILL|AIR)|LINGBROK)E|ST(?:WIC"
  "K|ON)|X SPRINGS|GART)|R(?:O(?:OK(?:FIELD|LET|S)|NWOOD|XTON)|I(?:D"
  "GEBORO|NSON|STOL)|(?:ASELTO|EME)N|UNSWICK)|L(?:A(?:CK(?: CREEK|SH"
  "EAR)|IRSVILLE|KELY)|(?:OOMINGDAL|YTH)E|U(?:E RIDGE|FFTON))|A(?:R("
  "?:NE(?:SVILLE|Y)|WICK|TOW)|L(?:L GROUND|DWIN)|INBRIDGE|CONTON|XLE"
  "Y)|U(?:C(?:HANAN|KHEAD)|ENA VISTA|FORD|TLER)|E(?:R(?:KELEY LAKE|L"
  "IN)|LLVILLE|THLEHEM)|I(?:G CANOE|SHOP)|YRO(?:MVILLE|N))|W(?:A(?:R"
  "(?:(?:NER ROBIN|M SPRING)S|(?:RENTO|THE)N|ESBORO|WICK)|Y(?:NES(?:"
  "VILLE|BORO)|CROSS)|L(?:THOURVILLE|ESKA)|VERLY(?: HALL)?|TKINSVILL"
  "E|SHINGTON|DLEY|CO)|I(?:L(?:L(?:ACOOCHEE|IAMSON)|DWOOD|EY)|N(?:TE"
  "RVILLE|STON|DER))|OO(?:D(?:B(?:INE|URY)|STOCK|VILLE|LAND)|LSEY)|H"
  "I(?:TE(?: (?:PLAINS|OAK)|SBURG)?|GHAM)|EST(?: (?:GREEN|POINT)|ON)"
  "|R(?:IGHTSVILLE|ENS|AY))|A(?:L(?:LEN(?:HURST|TOWN)|(?:PHARETT|M)A"
  "|A(?:PAHA|MO)|BANY|STON|TO)|R(?:(?:(?:NOLDSVIL|GY)L|MUCHE)E|A(?:G"
  "ON|BI)|LINGTON)|B(?:(?:RAHAM BALDWIN COLLEG|BEVILL)E|AC)|V(?:ONDA"
  "LE EST(?:ATES)?|ERA)|T(?:(?:TAPULGU|HEN)S|LANTA)|D(?:AIRSVILLE|RI"
  "AN|EL)|U(?:GUSTA|STELL|BURN)|M(?:ERICUS|BROSE)|(?:SHBUR|XSO)N|NDE"
  "RSONVILLE|CWORTH|PPLING|ILEY)|L(?:A(?:KE(?: (?:(?:SPIVE|CIT)Y|PAR"
  "K)|LAND|MONT)|(?:WRENCEVILL| FAYETT|GRANG)E|VONIA)|O(?:(?:(?:U(?:"
  "ISVIL|VA)|GANVIL)L|CUST GROV)E|OKOUT M(?:OUNTAI|T)N|VEJOY)|I(?:TH"
  "(?:IA SP(?:RIN)?GS|ONIA)|N(?:COLNTON|DALE)|L(?:BURN|LY)|ZELLA)|U("
  "?:M(?:BER CITY|PKIN)|THERSVILLE|DOWICI|LA)|E(?:(?:XINGT|BAN)ON|ES"
  "BURG|SLIE|ARY|NOX)|Y(?:ERLY|ONS))|R(?:O(?:C(?:K(?:Y F(?:ACE|ORD)|"
  " SPRING|LEDGE|MART)|HELLE)|B(?:INS A(?: F |F)B|ERTA)|S(?:SVILLE|W"
  "ELL)|(?:OPVILL|M)E|UND OAK|YSTON)|I(?:C(?:H(?:MOND HILL|LAND)|EBO"
  "RO)|N(?:GGOLD|CON)|SING FAWN|VERDALE)|E(?:(?:BEC|SA)CA|D(?: OAK|A"
  "N)|IDSVILLE|GISTER|YNOLDS|NTZ|X)|A(?:Y(?: CITY|MOND|LE)|BUN GAP|N"
  "GER)|U(?:TLEDGE|PERT)|HINE|YDAL)|F(?:O(?:R(?:T(?: (?:G(?:AINES|IL"
  "LEM|ORDON)|OGLETHORPE|MCPHERSON|BENNING|STEWART|VALLEY)|SON)|EST "
  "PARK|SYTH)|(?:WLSTOW|LKSTO)N)|A(?:IR(?:MOUNT|BURN)|R(?:MINGTON|GO"
  ")|YETTEVILLE)|L(?:O(?:WERY BR(?:ANCH)?|VILLA)|INTSTONE|EMING)|T ("
  "?:OGLETHORPE|MCPHERSON)|RANKLIN(?: SP(?:RIN)?GS)?|I(?:TZGERALD|NG"
  "ERHUT)|(?:UNS|EL)TON)|P(?:O(?:W(?:DER SP(?:RIN)?GS|ERSVILLE)|RT(?"
  ": WENTWORTH|ERDALE|AL)|OLER|ULAN)|I(?:NE(?: (?:M(?:OUNTAIN(?: VAL"
  "LEY)?|TN VALY)|LAKE)|HURST|VIEW)|TTS)|E(?:A(?:CHTREE CI?TY|RSON)|"
  "R(?:KINS|RY)|NDERGRASS|MBROKE|LHAM)|A(?:(?:LMETT|V)O|TTERSON|RROT"
  "T)|R(?:T WENTWORTH|ESTON)|LAIN(?:FIELD|VILLE|S)|U(?:LASKI|TNEY)|H"
  "ILOMATH)|T(?:A(?:L(?:L(?:ULAH F(?:AL)?LS|APOOSA)|KING ROCK|BOTTON"
  "|MO)|(?:YLORSVILL|T)E|RRYTOWN|ZEWELL)|H(?:OM(?:AS(?:VILLE|TON)|SO"
  "N)|UNDERBOLT|E ROCK)|U(?:R(?:NERVILLE|IN)|NNEL HILL|CKER)|O(?:CCO"
  "A(?: FALLS)?|OMSBORO|WNSEND)|Y(?:BEE ISLAND|RONE| TY)|E(?:NN(?:IL"
  "LE|GA)|MPLE)|I(?:G(?:NALL|ER)|FTON)|R(?:ENT|I)ON|WIN CITY)|H(?:A("
  "?:R(?:T(?:SFIELD|WELL)|(?:AL|RI)SON|DWICK|LEM)|(?:M(?:IL|P)TO|GA)"
  "N|(?:WKINS|PE)VILLE|ZLEHURST|BERSHAM|DDOCK|HIRA)|O(?:ME(?:R(?:VIL"
  "LE)?|LAND)|(?:GANSVILL|RTENS)E|(?:SCHTO|BOKE)N|LLY SPRINGS|WARD)|"
  "I(?:(?:NESVILL|AWASSE)E|L(?:LSBORO|TONIA)|GH SHOALS|RAM)|U(?:NTER"
  " AAF|BER|LL)|E(?:PHZIBAH|LENA?))|D(?:A(?:N(?:(?:IELS)?VILLE|BURG)"
  "|(?:HLONEG|CUL)A|WSON(?:VILLE)?|L(?:LAS|TON)|VISBORO|MASCUS|RIEN|"
  "ISY)|O(?:(?:NALSON|RA)VILLE|UGLAS(?:VILLE)?|BBINS AFB|ERUN|VER)|E"
  "(?:(?:CATU|XTE)R|WY ROSE|EPSTEP|MOREST| SOTO|ARING|NTON)|U(?:(?:N"
  "WOOD|DLE)Y| PONT|BLIN|LUTH)|I(?:LLARD|XIE)|RY BRANCH)|E(?:L(?:L(?"
  ":E(?:N(?:WOOD|TON)|RSLIE)|A(?:VILLE|BELL)|IJAY)|BERTON|KO)|A(?:ST"
  "(?: (?:ELLIJAY|DUBLIN|POINT)|ANOLLEE|MAN)|TONTON)|D(?:(?:ISO|E)N|"
  "GE HILL)|M(?:ERSON|PIRE)|(?: DUBLI|TO)N|XPERIMENT|SOM HILL|UHARLE"
  "E|PWORTH|NIGMA|VANS)|G(?:R(?:A(?:Y(?:S(?:VILLE|ON))?|NTVILLE|CEWO"
  "OD)|EEN(?:SBORO|VILLE)|(?:OVETOW|IFFI)N)|A(?:R(?:DEN CI?TY|FIELD)"
  "|INESVILLE|Y)|I(?:LLSVILLE|BSON|RARD)|LEN(?:N(?:VILLE)?|WOOD)|O(?"
  ":OD HOPE|RDON|UGH)|E(?:ORGETOWN|NEVA)|UYTON)|J(?:E(?:FFERSON(?:VI"
  "?LLE)?|KYLL ISLAND|NKINSBURG|RSEY|WELL|SUP)|U(?:N(?:CTION CITY|IP"
  "ER)|LIETTE)|A(?:CKSON(?:VILLE)?|SPER|KIN)|O(?:HNS CREEK|NESBORO))"
  "|N(?:OR(?:MAN PARK|TH METRO|RISTOWN|CROSS|WOOD)|E(?:(?:W(?:(?:ING"
  ")?TO|BOR|NA)|LSO)N|VILS)|A(?:SHVILLE|HUNTA|YLOR)|ICHOL(?:SON|LS)|"
  "UNEZ)|O(?:AK(?:(?:FIEL|WOO)D| PARK|MAN)|C(?:(?:HLOCK|O)NEE|ILLA)|"
  "M(?:AH|EG)A|RCHARD HILL|GLETHORPE|FFERMAN|LIVER|XFORD|DUM)|K(?:I("
  "?:NGS(?: BAY|LAND|TON)|TE)|E(?:YSVILLE|NNESAW)|NOXVILLE|ATHLEEN)|"
  "V(?:A(?:L(?:DOST|ON)A|RNELL)|I(?:LLA RIC|DALI|ENN)A)|U(?:N(?:ION "
  "(?:POINT|CITY)|ADILLA)|PATOI|VALDA)|I(?:R(?:WIN(?:VILLE|TON)|ON C"
  "ITY)|DEAL|VEY|LA)|Y(?:OUNG HARRIS|ATESVILLE)|(?:QUITMA|ZEBULO)N))"
  "))$"
  ,
  /* -- GU -- GU -- GU -- GU -- GU -- GU -- GU -- GU -- GU -- GU -- */
  "(?:\\b)((?^:(?i:(?:(?:S(?:ANTA RIT|INAJAN)|BARRIGAD|HAGATN)A|M(?:"
  "(?:ANGILA|ERIZ)O|ONGMONG)|A(?:GA(?:NA HEIGHTS|T)|SAN)|(?:CHALAN P"
  "AG|DEDED)O|TA(?:LOFOFO|MUNING)|Y(?:IGO|ONA)|INARAJAN|UMATAC|ORDOT"
  "|PITI))))$"
  ,
  /* -- HI -- HI -- HI -- HI -- HI -- HI -- HI -- HI -- HI -- HI -- */
  "(?:\\b)((?^:(?i:(?:K(?:A(?:(?:ILU(?:A KON)?|MUEL|AAW)A|U(?:NAKAKA"
  "|MAKAN)I|LA(?:UPAPA|HEO)|P(?:AAU?|OLEI)|HU(?:LUI|KU)|NEOHE)|E(?:A"
  "(?:L(?:AKEKU|I)A|(?:UHO|A)U)|KAHA)|U(?:(?:NI|L)A|RTISTOWN|ALAPUU)"
  "|I(?:LAUEA|HEI)|OLOA)|H(?:A(?:W(?:AII NATIONAL PARK|I)|NA(?:MAULU"
  "|PEPE|LEI)?|(?:LEIW|UUL)A|(?:KALA|IK)U)|O(?:N(?:O(?:(?:LUL|M)U|KA"
  "A)|AUNAU)|(?:LUALO|OLEHU)A)|I(?: NATL PARK|CKAM AFB|LO))|P(?:A(?:"
  "(?:H(?:AL|O)|I)A|PA(?:ALOA|IKOU)|AU(?:HAU|ILO))|E(?:ARL (?:HARBOR"
  "|CITY)|PEEKEO)|U(?:KALANI|UNENE)|RINCEVILLE)|W(?:A(?:I(?:M(?:ANAL"
  "O|EA)|A(?:LUA|NAE)|L(?:UKU|EA)|KOLOA|PAHU)|KE ISLAND|HIAWA)|HEELE"
  "R A(?:RMY AIRFIELD|AF))|M(?:(?: C B H K(?:ANEOHE)?|CBH K) BAY|A(?"
  ":KAW(?:ELI|AO)|UNALOA)|OUNTAIN VIEW|ILILANI)|L(?:A(?:(?:UPAHOEHO|"
  "I)E|NAI CITY|HAINA|WAI)|IHUE)|CA(?:MP(?: H M)? SMITH|PTAIN COOK)|"
  "TRIPLER A(?:RMY MEDICAL CENTER|MC)|SCHOFIELD(?: BARRACKS)?|O(?:CE"
  "AN VIEW|OKALA)|E(?:WA BEACH|LEELE)|N(?:AALEHU|INOLE)|A(?:NAHOL|IE"
  ")A|FORT SHAFTER|VOLCANO))))$"
  ,
  /* -- IA -- IA -- IA -- IA -- IA -- IA -- IA -- IA -- IA -- IA -- */
  "(?:\\b)((?^:(?i:(?:M(?:A(?:R(?:T(?:E(?:NSDA|L)LE|INSBURG)|(?:(?:A"
  "TH|I)O|SHALLTOW)N|(?:QUETT|N)E|BLE ROCK|ENGO|CUS)|N(?:(?:ILL|AW)A"
  "|CHESTER|NING|SON|LY)|S(?:ON(?: CITY|VILLE)|SENA)|Y(?:SVILLE| CIT"
  "Y|NARD)|C(?:EDONIA|KSBURG)|L(?:LARD|VERN|COM)|(?:QUOKET|GNOLI)A|P"
  "LETON|TLOCK|URICE|XWELL|DRID)|O(?:U(?:NT (?:(?:VERN|UNI)ON|A(?:UB"
  "URN|YR)|PLEASANT|STERLING)|LTON)|N(?:T(?:(?:PELIE|OU)R|ICELLO|EZU"
  "MA|ROSE)|DAMIN|MOUTH|ONA|ROE)|R(?:(?:NING SU|RISO)N|AVIA|LEY)|OR("
  "?:HEA|LAN)D|(?:VIL|DA)LE| VALLEY|SCOW)|I(?:L(?:LER(?:SBURG|TON)|F"
  "ORD|TON|ES|O)|N(?:(?:BUR|DE)N|EOLA|GO)|DDLE(?: AMANA|TOWN)?|SSOUR"
  "I V(?:ALLE|L)Y|TCHELL(?:VILLE)?)|E(?:L(?:CHER(?: DAL(?:LAS)?)?|(?"
  ":BOURN|ROS)E|VIN)|R(?:IDEN|RILL)|CHANICSVI?LLE|DIAPOLIS|SERVEY|NL"
  "O)|C (?:C(?:A(?:LLSBURG|USLAND)|LELLAND)|GREGOR|INTIRE)|T (?:PLEA"
  "SANT|STERLING|UNION)|U(?:SCATINE|RRAY)|YSTIC)|C(?:O(?:L(?:UMB(?:U"
  "S (?:J(?:UNCTION|CT)|CITY)|IA)|L(?:EGE SPR(?:IN)?G|IN)S|ESBURG|WE"
  "LL|FAX|O)|R(?:(?:RECTIONV(?:IL)?|ALVIL)LE|NING|WITH|YDON)|U(?:NCI"
  "L BL(?:UF)?FS|LTER)|N(?:R(?:AD|OY)|ESVILLE)|O(?:N RAPIDS|PER)|(?:"
  "GGO|I)N)|A(?:R(?:(?:TER LAK|LISL)E|(?:[BS]|NARV)ON|PENTER|ROLL)|L"
  "(?:(?:LENDE|MA)R|AMUS|UMET)|S(?:TA(?:LI|N)A|CADE|EY)|M(?:BRIDG|AN"
  "CH)E|NTRIL)|L(?:E(?:AR(?: LAKE|FIELD)|GHORN|RMONT|MONS)|AR(?:(?:("
  "?:ENC)?|KSVILL)E|I(?:NDA|ON))|I(?:MBING HILL|NTON|VE|O)|UTIER)|H("
  "?:A(?:R(?:L(?:ES CITY|OTTE)|TER OAK|ITON)|TSWORTH|PIN)|E(?:ROKEE|"
  "LSEA|STER)|ILLICOTHE|URDAN)|E(?:NT(?:ER(?: (?:J(?:UNCTION|CT)|POI"
  "NT)|VILLE)|RAL CITY)|DAR(?: (?:RAPID|FALL)S)?)|R(?:(?:AWFORDSVI?L"
  "L|YSTAL LAK)E|ES(?:C(?:ENT|O)|TON)|OMWELL)|U(?:M(?:BERLAND|MING)|"
  "SHING|RLEW)|INCINNATI|YLINDER)|S(?:T(?:A(?:N(?:HOPE|WOOD|LEY|TON)"
  "|TE CENTER|CYVILLE)|O(?:R(?:M LAKE|Y CITY)|CK(?:PORT|TON)|UT)|RA("
  "?:WBERRY P(?:OIN)?T|TFORD)|EAMBOAT R(?:OC)?K|UART)|A(?:INT (?:(?:"
  "CHARLE|DONATU|LUCA|MARY)S|AN(?:THONY|SGAR)|OLAF|PAUL)|(?:RATOG|BU"
  "L)A|L(?:EM|IX)|C CITY|NBORN)|H(?:E(?:L(?:L(?: ROCK|SBURG)|D(?:AHL"
  "|ON)|BY)|NANDOAH|FFIELD|RRILL)|A(?:NNON CITY|RPSBURG|MBAUGH))|P(?"
  ":R(?:ING(?: HILL|BROOK|VILLE)|AGUEVILLE)|I(?:RIT LAK|LLVILL)E|E(?"
  ":NCER|RRY))|I(?:(?:(?:(?:GOUR|D)N|BL)E|LVER CIT)Y|OUX (?:C(?:ENTE"
  "R|ITY)|RAPIDS))|C(?:(?:OTCH GROV|ARVILL)E|H(?:LESWIG|ALLER)|RANTO"
  "N)|E(?:RGEANT BL(?:UF)?F|ARSBORO|YMOUR|LMA|WAL)|O(?:UTH (?:ENGLIS"
  "H|AMANA)|L(?:DIER|ON)|MERS)|W(?:E(?:DESBURG|A CITY)|A(?:LEDALE|N)"
  "|ISHER)|U(?:(?:PERIO|MNE)R|THERLAND|LLY)|L(?:ATER|OAN)|MITHLAND)|"
  "W(?:E(?:S(?:T(?: (?:B(?:URLINGTON|RANCH|END)|DES MOINES|CHESTER|L"
  "IBERTY|OKOBOJI|AMANA|GROVE|POINT|UNION)|(?:GAT|SID)E|PHALIA|FIELD"
  ")|LEY)|L(?:L(?:SBURG|MAN)|[DT]ON)|B(?:STER(?: CITY)?|B)|VER)|A(?:"
  "L(?:L(?:INGFORD| LAKE)|(?:COT|NU)T|FORD|KER)|T(?:ER(?:VILLE|LOO)|"
  "KINS)|SH(?:(?:INGTO|BUR)N|TA)|U(?:K(?:EE|ON)|COMA)|PELLO|VERLY|YL"
  "AND|DENA)|I(?:N(?:DSOR (?:HEIG)?HTS|T(?:ERSET|HROP)|FIELD)|L(?:LI"
  "AMS(?:BURG|ON)?|TON)|OTA)|O(?:O(?:D(?:B(?:INE|URN)|WARD)|LSTOCK)|"
  "(?:RTHINGTO|DE)N)|H(?:IT(?:T(?:E(?:MORE|N)|IER)|ING)|AT CHEER|EAT"
  "LAND)| (?:BURLINGTON|DES MOINES|OKOBOJI)|YOMING)|L(?:A(?:K(?:E(?:"
  " (?:MILLS|CITY|PARK|VIEW)|SIDE)|OTA)|N(?:GWORTHY|ESBORO|SING)| (?"
  ":PORTE CITY|MOTTE)|R(?:CHWOOD|RABEE)|(?:CON|DOR)A|W(?:LER|TON)|UR"
  "E(?:NS|L)|MON[IT]|TIMER)|I(?:N(?:(?:N GROV|EVILL)E|(?:COL|DE)N)|T"
  "TLE(?: (?:CEDAR|SIOUX|ROCK)|PORT)|BERTY(?: C(?:ENTE|T)R|VILLE)|(?"
  ":DDERDAL|VERMOR)E|S(?:COMB|BON)|ME SPRINGS)|O(?:N(?:E (?:ROCK|TRE"
  "E)|G GROVE)|(?:CKRIDG|HRVILL)E|W(?: MOOR|DEN|ELL)|(?:ST NATIO|GA)"
  "N|RIMOR|VILIA)|E(?: (?:CLAIRE|GRAND|MARS)|(?:DYAR|LAN)D|(?:IGHT)?"
  "ON|(?:TT|WI)S|CLAIRE|HIGH|STER|NOX)|U(?:(?: V|Z)ERNE|XEMBURG|THER"
  "|ANA|CAS)|Y(?:NNVILLE|TTON))|B(?:R(?:A(?:D(?:(?:DYVILL|GAT)E|FORD"
  ")|(?:ND|YT)ON)|I(?:DGEWATER|GHTON|STOW|TT)|O(?:OKLY|NSO)N|E(?:MER"
  "|DA)|UNSVILLE|YANT)|E(?:A(?:CON(?:SFIELD)?|MAN|VER)|L(?:LE(?: PLA"
  "IN|VU)E|MOND)|R(?:NARD|WICK)|N(?:NETT|TON)|TTENDORF|VINGTON|DFORD"
  ")|A(?:R(?:N(?:ES CITY|UM)|TLETT)|T(?:TLE CREEK|AVIA)|(?:DG|XT)ER|"
  "NCROFT|LDWIN|GLEY|YARD)|L(?:A(?:IRS(?:BURG|TOWN)|KESBURG|NCHARD)|"
  "O(?:OMFIELD|CKTON)|UE GRASS|ENCOE)|U(?:FFALO(?: C(?:ENTE|T)R)?|R("
  "?:LINGTON|NSIDE|T)|CK(?:INGHAM|EYE)|SSEY)|O(?:(?:ON(?:EVILL)?|D)E"
  "|N(?:APARTE|DURANT)|(?:UTO|YDE)N|XHOLM)|I(?:RMINGHAM|G ROCK))|G(?"
  ":R(?:A(?:N(?:D(?: (?:J(?:UNCTION|CT)|MOUND|RIVER)|VIEW)|VILLE|GER"
  "|T)|(?:VIT)?Y|ETTINGER|FTON)|EE(?:N(?: (?:M(?:OUNTAI|T)N|ISLAND)|"
  "(?:VILL)?E|FIELD)|LEY)|I(?:NNELL|SWOLD|MES)|U(?:NDY CENT|V)ER)|A("
  "?:R(?:DEN (?:GROVE|CITY)|N(?:AVILLO|ER)|(?:RISO|WI)N|BER)|L(?:VA|"
  "T))|I(?:L(?:M(?:ORE CITY|AN)|BERT(?:VILLE)?|LETT GROVE)|FFORD|BSO"
  "N)|U(?:T(?:HRIE C(?:ENTE|T)R|TENBERG)|ERNSEY)|O(?:O(?:SE LAKE|DEL"
  "L)|LDFIELD|WRIE)|L(?:ADBROOK|ENWOOD|IDDEN)|E(?:NEVA|ORGE))|A(?:L("
  "?:L(?:E(?:(?:RTO|MA)N|NDORF)|ISON)|B(?:I(?:ON|A)|ERT CITY|URNETT)"
  "|T(?:(?:A VIST)?A|O(?:ONA|N))|(?:GON|PH)A|EXANDER|VORD|DEN)|R(?:C"
  "(?:ADIA|HER)|(?:EDA|GY)LE|I(?:SPE|ON)|NOLDS PARK|LINGTON|MSTRONG|"
  "THUR)|N(?:D(?:OVER|REW)|(?:AMOS|IT)A|KENY|THON)|U(?:(?:DUBO|BUR)N"
  "|R(?:ELI|OR)A|STINVILLE)|T(?:ALISSA|LANTIC|KINS)|S(?:PINWALL|BURY"
  "|HTON)|(?:(?:PLING|F)T|KR)ON|CK(?:WORTH|LEY)|D(?:AIR|EL)|M(?:ANA|"
  "ES)|INSWORTH|YRSHIRE|GENCY|VOCA)|P(?:A(?:C(?:IFIC J(?:UNCTION|CT)"
  "|KWOOD)|(?:N(?:AM|OR)|ULLIN)A|R(?:KERSBURG|NELL)|T(?:TERS)?ON|L(?"
  ":MER|O))|R(?:O(?:MISE CITY|TIVIN|LE)|AIRIE(?: CITY|BURG)|I(?:NCET"
  "ON|MGHAR)|ES(?:COTT|TON))|L(?:EASANT(?: (?:V(?:ALLE|L)Y|HILL)|VIL"
  "LE|ON)|A(?:INFIELD|NO)|YMOUTH|OVER)|O(?:(?:(?:MER|PEJ)O|LK CIT)Y|"
  "CAHONTAS|RTSMOUTH|STVILLE)|E(?:R(?:S(?:HING|IA)|CIVAL|RY|U)|(?:OS"
  "T|LL)A|TERSON)|I(?:LOT (?:GROVE|MOUND)|ERSON|SGAH)|ULASKI)|D(?:E("
  "?:L(?:AWARE|PHOS|MAR|OIT|HI|TA)|(?:(?:EP RIV|XT)E|WA)R|N(?:ISON|M"
  "ARK|VER)| (?:SOTO|WITT)|C(?:ATUR|ORAH)|S MOINES|FIANCE|DHAM|RBY)|"
  "A(?:V(?:IS CITY|ENPORT)|N(?:VILLE|BURY|A)|LLAS(?: CENTER)?|(?:WS|"
  "YT)ON|KOTA CITY)|O(?:(?:RCHEST|LLIV)ER|N(?:NELLSON|AHUE)|U(?:GHER"
  "TY|DS)|W(?: CITY|S)|ON)|U(?:N(?:(?:COMB|DE)E|KERTON|LAP)|RAN(?:GO"
  "|T)|BUQUE|MONT)|I(?:AGONAL|CKENS|XON|KE)|Y(?:ERSVILLE|SART)|RAKES"
  "VILLE)|R(?:O(?:CK(?: (?:(?:RAPID|FALL)S|VALLEY)|WELL(?: CITY)?|FO"
  "RD)|S(?:E HILL|SIE)|L(?:AND|FE)|W(?:LEY|AN)|BINS|DNEY|YAL|ME)|I(?"
  ":C(?:EVILLE|HLAND|KETTS)|VER(?:(?:DAL|SID)E|TON)|(?:DGEWA|PPE)Y|N"
  "(?:GSTE|AR)D)|E(?:D(?:FIELD| OAK|DING)|M(?:BRANDT|SEN)|(?:INBE|NW"
  "I)CK|A(?:DLYN|SNOR))|A(?:ND(?:AL(?:IA|L)|OLPH)|(?:LSTO|THBU)N|(?:"
  "DCLIFF|K)E|YMOND)|U(?:T(?:HVEN|LAND)|NNELLS|SSELL|BIO|DD)|HODES|Y"
  "AN)|H(?:A(?:R(?:T(?:FORD|WICK|LEY)|PER(?:S FERRY)?|VE(?:STER|Y)|C"
  "OURT|LAN|RIS|DY)|M(?:(?:(?:IL|P)TO|LI)N|BURG)|N(?:LONTOWN|COCK|SE"
  "LL)|VE(?:RHILL|LOCK)|W(?:ARDEN|KEYE)|L(?:BUR|E)|YESVILLE|STINGS|Z"
  "LETON)|O(?:L(?:Y CROSS|STEIN|LAND)|(?:NEY CREE|RNIC)K|(?:PKIN|UGH"
  ")TON|MESTEAD|SPERS)|I(?:LLS(?:BORO)?|GHLANDVILLE|AWATHA|NTON)|U(?"
  ":M(?:BOLDT|ESTON)|BBARD|DSON|XLEY|LL)|E(?:NDERSON|DRICK))|N(?:E(?"
  ":W(?: (?:HA(?:RTFORD|MPTON)|L(?:IBERTY|ONDON)|VI(?:RGINI|ENN)A|(?"
  ":SHARO|ALBI)N|PROVIDE?NCE|MARKET)|(?:HA|E)LL|TON)|(?:MAH|VAD|OL)A"
  ")|O(?:R(?:TH(?: (?:BUENA VISTA|WASHINGTON|ENGLISH|LIBERTY)|BORO|W"
  "OOD)|WA(?:LK|Y)|A SPRINGS)|DAWAY)| (?:BUENA VISTA|WASHINGTON)|(?:"
  "ASHU|UM)A|ICHOLS)|E(?:L(?:K(?: (?:RUN H(?:EIGH|G)TS|HORN)|(?:HA|P"
  "O)RT|ADER)|D(?:O(?:RA(?:DO)?|N)|RIDGE)|L(?:S(?:WORTH|TON)|IOTT)|("
  "?:BERO|GI)N|WOOD|MA|Y)|A(?:RL(?:VILLE|HAM|ING|Y)|GLE GROVE)|D(?:D"
  "YVILLE|GEWOOD)|M(?:METSBURG|ERSON)|S(?:THERVILLE|SEX)|V(?:ANSDALE"
  "|ERLY)|X(?:LINE|IRA)|PWORTH)|F(?:A(?:R(?:M(?:ERSBURG|INGTON)|NHAM"
  "VILLE|RAGUT|LEY)|IR(?:F(?:IELD|AX)|BANK)|YETTE)|O(?:R(?:T (?:(?:A"
  "TKIN|MADI)SON|DODGE)|EST CITY)|N(?:TANELLE|DA)|STORIA)|R(?:E(?:DE"
  "RI(?:CKSBU?RG|KA)|MONT)|UITLAND)|E(?:R(?:GUSON|TILE)|STINA|NTON)|"
  "LO(?:RIS|YD))|T(?:R(?:U(?:ESDALE|RO)|A(?:CY|ER)|OY MILLS|EYNOR|IP"
  "OLI)|H(?:O(?:R(?:N(?:BURG|TON))?|MPSON)|URMAN|AYER)|O(?:(?:ETER|D"
  "D)VILLE|(?:RONT|LED)O)|E(?:EDS GROVE|MPLETON|NNANT|RRIL)|I(?:(?:F"
  "FI|PTO)N|NGLEY|TONKA)|A(?:(?:INT|B)OR|MA)|URIN)|O(?:AK(?:LAND(?: "
  "ACRES)?|(?:VIL|DA)LE)|R(?:AN(?:GE CITY)?|CHARD|IENT)|S(?:(?:KALOO"
  "S|CEOL)A|SIAN|AGE)|T(?:T(?:OSEN|UMWA)|H?O|LEY)|XFORD(?: J(?:UNCTI"
  "ON|CT))?|(?:CHEYEDA|ELWEI|GDE)N|L(?:LIE|DS|IN)|N(?:SLOW|AWA)|DEBO"
  "LT|KOBOJI|YENS)|K(?:E(?:LL(?:E(?:RTON|Y)|OGG)|O(?:(?:SAUQU|T)A|KU"
  "K)|S(?:WICK|LEY)|N(?:SET)?T|YSTONE)|I(?:R(?:K(?:VILLE|MAN)|ON)|N("
  "?:GSLEY|ROSS)|MBALLTON|LLDUFF)|N(?:O(?:XVILL|K)E|IERIM)|A(?:(?:NA"
  "WH|LON)A|MRAR)|LEMME)|V(?:I(?:N(?:CENT|ING|TON)|(?:LLISC|OL)A|CTO"
  "R)|A(?:N (?:HORNE|METER|WERT)|RINA|IL)|O(?:ORHIES|LGA)|ENTURA)|I("
  "?:N(?:D(?:EPENDENCE|IANOLA)|WOOD)|O(?:WA (?:FALLS|CITY)|NIA)|(?:D"
  "A GROV|MOGEN)E|R(?:(?:ETO|WI)N|A))|J(?:A(?:CKSON J(?:UNCTION|CT)|"
  "NESVILLE|MAICA)|E(?:FFERSON|WELL|SUP)|O(?:HNSTON|LLEY|ICE))|U(?:N"
  "(?:I(?:VERSITY P(?:AR)?K|ON(?:VILLE)?)|DERWOOD)|RBAN(?:DALE|A)|DE"
  "LL|TE)|Y(?:A(?:RMOUTH|LE)|ORKTOWN|ETTER)|QU(?:ASQUETON|IMBY)|Z(?:"
  "EARING|WINGLE)))))$"
  ,
  /* -- ID -- ID -- ID -- ID -- ID -- ID -- ID -- ID -- ID -- ID -- */
  "(?:\\b)((?^:(?i:(?:S(?:A(?:INT (?:(?:CHARL|MARI)ES|ANTHONY)|N(?:D"
  "POINT|TA)|WTOOTH CITY|LMON|GLE)|T(?:A(?:R(?: RANCH)?|NLEY)|E(?:IR"
  "MAN|RLING)|(?: MARI|IT)ES|ONE)|P(?:IRIT LAKE|RINGFIELD|ALDING|ENC"
  "ER)|W(?:AN(?: VALLEY|LAKE)|EET)|H(?:O(?:SHONE|UP)|ELLEY)|U(?:GAR "
  "CIT|N VALLE)Y|MELTERVILLE|ODA SPRINGS|ILVERTON)|M(?:O(?:UNTAIN HO"
  "ME(?: A(?: F |F)B)?|NT(?:(?:PELIE|OU)R|EVIEW)|YIE SPRINGS|RELAND|"
  "SCOW|ORE)|A(?:L(?:AD CITY|TA)|CK(?:S INN|AY)|RSING|Y)|E(?:(?:RIDI"
  "|N)AN|(?:LB|S)A|DIMONT)|U(?:R(?:(?:PH|RA)Y|TAUGH)|LLAN)|I(?:D(?:D"
  "LETON|VALE)|NIDOKA)|T(?:N HOME(?: AFB)?| HOME)|CCA(?:MMON|LL))|P("
  "?:A(?:R(?:ADISE HOT(?: SPRINGS)?|KER|IS|MA)|LISADES|TTERSON|YETTE"
  "|UL)|R(?:I(?:EST (?:RIVER|LAKE)|NCETON|CHARD)|AIRIE|ESTON)|I(?:N("
  "?:E(?:HURST)?|GREE)|(?:ONEERVILL|ERC)E|CABO)|O(?:ST FALLS|CATELLO"
  "|NDERAY|RTHILL|TLATCH|LLOCK)|L(?:ACERVILLE|UMMER)|ECK)|C(?:O(?:(?"
  ":COLALL|ND)A|(?:LBUR|OLI)N|(?:UNCI|RRA)L|EUR D ALENE|TTONWOOD|BAL"
  "T)|A(?:R(?:EY(?:WOOD)?|MEN)|S(?:TLEFORD|CADE)|LD(?:WELL|ER)|MBRID"
  "GE|TALDO)|L(?:A(?:RK(?: FORK|IA)|YTON)|EARWATER|IFTON)|H(?:UBBUCK"
  "|ALLIS|ESTER)|ENTERVILLE|RAIGMONT|ULDESAC)|H(?:A(?:R(?:PSTER|RISO"
  "N|VARD)|(?:GERMA|ZELTO|NSE)N|YDEN(?: LAKE)?|M(?:METT|ER)|ILEY|USE"
  "R)|O(?:L(?:LISTER|BROOK)|(?:[PW]|MEDAL)E|RSESHOE BE?ND)|I(?:DDEN "
  "SP(?:RIN)?GS|LL CITY)|E(?:ADQUARTERS|YBURN)|USTON)|G(?:R(?:A(?:N("
  "?:GEVILLE|D VIEW)|(?:SMER|C)E)|EEN(?:CREEK|LEAF))|A(?:RDEN (?:VAL"
  "LE|CIT)Y|NNETT)|E(?:NE(?:SEE|VA)|ORGETOWN)|IBBONSVILLE|LENNS FERR"
  "Y|OODING)|A(?:M(?:(?:ERICAN F(?:AL)?| FAL)LS|MON)|T(?:OMIC CITY|L"
  "ANTA|HOL)|R(?:(?:IM|C)O|BON)|(?:BERDEE|SHTO)N|(?:CEQUI|HSAHK)A|L("
  "?:BION|MO)|NDERSON DAM|VERY)|B(?:L(?:A(?:CKFOOT|NCHARD)|OOMINGTON"
  "|ISS)|A(?:N(?:CROFT|KS)|YVIEW|SALT)|O(?:NNERS FERRY|VILL|ISE)|E(?"
  ":LLEVUE|RN)|U(?:RLEY|HL)|RUNEAU)|D(?:A(?:LTON G(?:ARDE|D)NS|(?:RL"
  "ING|Y)TON)|I(?:(?:NGL|XI)E|ETRICH)|O(?:(?:NNELL|WNE)Y|VER)|E(?:SM"
  "ET|ARY|CLO)|(?:RIGG|UBOI)S)|L(?:A(?:VA HOT SP(?:RIN)?GS|KE FORK|C"
  "LEDE|PWAI)|E(?:WIS(?:VILLE|TON)|(?:AD|N)ORE|MHI|THA)|O(?:NE STAR|"
  "WMAN)|UCILE)|F(?:E(?:R(?:DINAN|NWOO)D|ATHERVILLE|LT|NN)|R(?:UIT(?"
  ":LAND|VALE)|ANKLIN)|I(?:SH HAVEN|LER|RTH)|AIRFIELD|ORT HALL)|R(?:"
  "I(?:G(?:GINS|BY)|(?:DDL|RI)E|CHFIELD)|O(?:CK(?:Y BAR|LAND)|GERSON"
  "|BERTS)|E(?:UBENS|XBURG)|ATHDRUM|UPERT)|W(?:E(?:ST(?: MAGIC|ON)|I"
  "(?:PPE|SER)|NDELL)|A(?:R(?:DNER|REN)|LLACE|YAN)|I(?:NCHEST|LD)ER|"
  "HITE BIRD|ORLEY)|N(?:E(?:W(?: (?:CENTERVILLE|PLYMOUTH|MEADOWS)|DA"
  "LE)|ZPERCE)|O(?:R(?:TH FORK|DMAN)|TUS)|A(?:PLES|MPA))|T(?:E(?:N(?"
  ":DOY|SED)|TON(?:IA)?|RRETON)|WIN (?:FALL|LAKE)S|(?:AMARAC|IPANU)K"
  "|R(?:IUMPH|OY)|HATCHER)|K(?:E(?:UTERVILLE|NDRICK|LLOGG|TCHUM)|I(?"
  ":NG(?: HILL|STON)|MBERLY)|OO(?:TENAI|SKIA)|AMIAH|UNA)|I(?:N(?:DIA"
  "N VALLEY|KOM)|DAHO (?:FALLS|CITY)|SLAND PARK|RWIN|ONA)|E(?:L(?:K "
  "(?:RIVER|CITY|HORN)|LIS|BA)|A(?:STPORT|GLE)|MMETT|DEN)|O(?:R(?:OF"
  "INO|EANA)|A(?:KLEY|SIS)|L(?:DTOWN|A)|NAWAY|SBURN|VID)|J(?:ULIAETT"
  "A|ACKSON|EROME)|VI(?:CTOR|OLA)|YELLOW PINE|UCON))))$"
  ,
  /* -- IL -- IL -- IL -- IL -- IL -- IL -- IL -- IL -- IL -- IL -- */
  "(?:\\b)((?^:(?i:(?:S(?:T(?:O(?:N(?:E(?: PARK|FORT)|INGTON)|CK(?:L"
  "AND|TON)|Y)|R(?:EA(?:MWOOD|TOR)|A(?:SBURG|WN)|ONGHURST)| (?:(?:FR"
  "ANCISVL|AUGUSTIN)E|CHARLES)|E(?:WARD(?:SON)?|ELEVILLE|RLING|GER)|"
  "A(?:N(?:DARD(?: CITY)?|FORD)|UNTON)|I(?:LLMAN V(?:ALLE|L)|CKNE)Y)"
  "|A(?:I(?:NT(?: (?:(?:A(?:UGUSTI|N)N|FRANCISVILL)E|J(?:OSEPH|ACOB)"
  "|CHARLES|LIBORY|DAVID|PETER|ELMO)|E MARIE)|LOR SP(?:RIN)?GS)|N(?:"
  "D(?:OVAL|WICH)| JOSE)|U(?:K VILLAGE|NEMIN|GET)|L(?:ISBURY|EM)|V(?"
  ":ANNA|OY)|WYERVILLE|YBROOK|DORUS)|H(?:E(?:R(?:(?:ID|M)AN|RARD)|L("
  "?:BYVILLE|DON)|FFIELD)|A(?:(?:WNEETOW|NNO)N|RPSBURG|BBONA|TTUC)|I"
  "(?:RL(?:AND|EY)|PMAN|LOH)|O(?:BONIER|REWOOD)|UMWAY)|O(?:UTH(?: (?"
  ":(?:(?:ELG|PEK)I|WILMINGTO|SUBURBA?)N|B(?:ARRINGTON|ELOIT)|CHICAG"
  "O HEIGHTS|HOLLAND|ROXANA)|ERN VIEW)|LON MILLS|MONAUK|RENTO)|C(?:O"
  "TT(?: A(?:IR FORCE BASE|FB)|VILLE)|H(?:ILLER PARK|AUMBURG|ELLER)|"
  "IOT(?:O MILLS|A)|ALES MOUND)|U(?:M(?:M(?:ER(?: HILL|FIELD)|IT(?: "
  "ARGO)?)|NER)|(?:GAR GROV|BLETT)E|LLIVAN|TTER)|P(?:RING(?: (?:(?:V"
  "ALLE|BA)Y|GROVE)|ERTON|FIELD)|A(?:R(?:LAND|TA)|ULDING)|EER)|I(?:("
  "?:BLE|CIL)Y|D(?:ELL|NEY)|M(?:PSON|S)|NCLAIR|LVIS|GEL)|E(?:(?:YMOU"
  "|SSE|CO)R|ATON(?:VILLE)?|(?:NEC|REN)A|WARD)| (?:CHICAGO H(?:EI(?:"
  "GHTS)?|TS)|(?:BARR|WILM)INGTON)|W(?:AN(?:WICK|SEA)|EET WATER)|MIT"
  "H(?:FIELD|SHIRE|BORO|TON)|(?:NICART|YCAMOR|KOKI)E|LEEPY HOLLOW)|M"
  "(?:A(?:R(?:I(?:(?:ETT|SS)A|NE|ON)|QUETTE (?:HEIG)?HTS|TIN(?:SVILL"
  "E|TON)|S(?:EILLES|HALL)|K(?:HAM)?|YVILLE|ENGO|OA)|N(?:(?:TEN|IT)O"
  "|CHESTER|HATTAN|SFIELD|VILLE|LIUS)|C(?:HESNEY P(?:AR)?K|O(?:MB|N)"
  "|EDONIA|KINAW)|(?:(?:DIS|QU|Z)O|EYSTOW)N|T(?:T(?:ES|O)ON|HERVILLE"
  ")|S(?:ON(?: CITY)?|COUTAH)|PLE(?: PARK|TON)|(?:GNOLI|KAND)A|L(?:D"
  "EN|TA)|HOMET|YWOOD|UNIE)|O(?:UN(?:T (?:(?:(?:VERN|ZI)O|AUBUR)N|P("
  "?:ROSPECT|ULASKI)|CAR(?:ROL|ME)L|(?:OLIV|ERI)E|GREENWOOD|STERLING"
  "|MORRIS)|D(?: CITY|S))|N(?:T(?:G(?:OME|M)RY|ICELLO|ROSE)|ROE CENT"
  "ER|MOUTH|EE)|R(?:RIS(?:ON(?:VILLE)?)?|TON(?: GROVE)?|O)|(?:SSVILL"
  "|MENC|LIN)E|D(?:E(?:STO)?|OC)|(?:WEAQU|KEN)A|OSEHEART|ZIER)|I(?:L"
  "(?:L(?:E(?:R(?:SVILLE| CITY)|DGEVILLE)|(?:BROO|CREE)K| SHOALS|ING"
  "TON|STADT)|(?:TO|A)N|FORD|MINE)|D(?:DLE(?:SWORTH|GROVE|TOWN)|LOTH"
  "IAN)|N(?:O(?:OKA|NK)|ERAL|IER)|(?:TCHEL|CHAE)L)|E(?:R(?:RI(?:ONET"
  "T(?:E PAR| P)K|TT)|(?:EDOSI|N)A)|T(?:(?:AMOR|TAW)A|ROPOLIS|CALF)|"
  "D(?:I(?:NAH|A)|ORA)|N(?:DO(?:TA|N)|ARD)|L(?:ROSE PARK|VIN)|CHANIC"
  "SBURG|PPEN)|U(?:L(?:BERRY GR(?:OVE|V)|KEYTOWN)|R(?:PHYSBORO|RAYVI"
  "LLE|DOCK)|N(?:DELEIN|CIE)|DDY)|C(?: (?:C(?:O(?:NNELL|OK)|LURE)|LE"
  "AN(?:SBORO)?|NABB)|(?:HENR|VE)Y|CULLOM LAKE)|T (?:GREENWOOD|PROSP"
  "ECT|STERLING|ZION))|C(?:A(?:R(?:(?:PENTERSV(?:IL)?L|T(?:ERVILL|HA"
  "G))E|BON(?: (?:CLIFF|HILL)|DALE)|L(?:(?:INVIL|Y)LE|OCK)|R(?:IER M"
  "ILLS|OLLTON)|M(?:AN|I)|OL STREAM|Y)|M(?:P(?: (?:GROVE|POINT)|BELL"
  " HILL|US)|BRI(?:DGE|A)|(?:ERO|DE)N|ARGO)|L(?:UMET (?:CITY|PARK)|E"
  "DONIA|HOUN)|S(?:EY(?:VILLE)?|TLETON)|(?:ZENOV|HOK)IA|NT(?:RALL|ON"
  ")|(?:PRO|TLI)N|VE IN ROCK|BERY|CHE|IRO)|O(?:L(?:U(?:MB(?:IA|US)|S"
  "A)|LI(?:NSVILLE|SON)|(?:CHESTE|MA)R|(?:ET|ON)A|FAX|P)|U(?:NTRY(?:"
  " CLUB HILLS|SIDE)|LTERVILLE)|R(?:N(?:LAND|ELL)|TLAND|DOVA)|A(?:L "
  "(?:VALLE|CIT)Y|TSBURG)|N(?:GERVILLE|CORD)|(?:[BW]D|FFE)EN|M(?:PTO"
  "N|ER)|TTAGE HILLS|OKSVILLE|ELLO)|H(?:A(?:N(?:DLERVILLE|NAHON|A)|M"
  "(?:BERSBURG|PAIGN)|T(?:SWORTH|HAM)|(?:RLESTO|PI)N|DWICK)|E(?:ST(?"
  ":ER(?:FIELD)?|NUT)|RR(?:Y VALLE)?Y|BANSE|NOA)|I(?:CAGO(?: (?:(?:H"
  "EIG)?HTS|RIDGE))?|LLICOTHE)|RIS(?:TOPHER|MAN))|L(?:A(?:R(?:E(?:N("
  "?:DON H(?:IL)?LS|CE)|MONT)?|KS(?:BURG|DALE))|Y(?:TON(?:VILLE)?| C"
  "ITY))|E(?:VELAND|MENTS)|I[FN]TON)|R(?:E(?:S(?:T(?: ?HILL|WOOD|ON)"
  "|CENT CITY)|AL SPRINGS|VE COEUR|TE)|O(?:SSVILLE|PSEY)|YSTAL LAKE)"
  "|E(?:DAR(?: POINT|VILLE)|NTR(?:EVILLE|ALIA)|RRO GORDO)|I(?:S(?:SN"
  "A PARK|CO|NE)|CERO|MIC)|U(?:STER PARK|LLOM|RRAN|TLER|BA)|(?:N?TRY"
  " CLB HL|YPRES)S)|B(?:E(?:L(?:L(?:E(?:V(?:ILL|U)| RIV)E|FLOWER|MON"
  "T|WOOD)|VIDERE|KNAP)|A(?:R(?:DSTOWN|SDALE)|VERVILLE|CH PARK|SON)|"
  "R(?:(?:KELE|R)Y|W(?:ICK|YN)|LIN)|N(?:S(?:ENVILLE|ON)|TON|LD)|ECHE"
  "R(?: CITY)?|THA(?:LTO|NY)|DFORD PARK|CKEMEYER|MENT)|R(?:O(?:WN(?:"
  "S(?:TOWN)?|FIELD|ING)|AD(?:LANDS|VIEW|WELL)|OK(?:FIELD|PORT|LYN)|"
  "(?:UGH|C)TON)|A(?:D(?:FORD(?:TON)?|LEY)|CEVILLE|IDWOOD)|I(?:DGE(?"
  ":PORT|VIEW)|MFIELD|GHTON|STOL)|E(?:CKENRIDG|ES)E|USSELS|YANT)|U(?"
  ":R(?:N(?:(?:T PRAIRI|SID)E|HAM)|LINGTON|R RIDGE|BANK|EAU)|FFALO(?"
  ": (?:PR(?:AIRIE)?|GROVE|HART))?|CK(?:INGHAM|LEY|NER)|N(?:KER HILL"
  "|COMBE)|L(?:L VALLEY|PITT)|SHNELL|TLER|DA)|A(?:R(?:T(?:ONVILLE|EL"
  "SO|LETT)|R(?:INGTON|Y)?|DOLPH|NHILL|CLAY|STOW)|Y(?:VIEW GARDE(?:N"
  "S)?|LIS)|T(?:CHTOWN|AVIA|ES|H)|NN(?:OCKBURN|ER)|ILEYVILLE|LDWIN|D"
  "ER|SCO)|L(?:U(?:F(?:F(?: (?:SPRINGS|CITY)|S)|ORD)|E (?:ISLA|MOU)N"
  "D)|A(?:NDINSVILL|CKSTON)E|OOMING(?:DALE|TON))|O(?:N(?:(?:DVILL|NI"
  ")E|E GAP|FIELD)|L(?:I(?:NGBROOK|VIA)|ES)|URBONNAIS|ODY|WEN)|I(?:S"
  "(?:(?:HOP HI|SE)LL|MARCK)|G(?:GS(?:VILLE)?| ROCK)|BLE GROVE|NGHAM"
  "|RDS)|YRON)|L(?:A(?: (?:(?:P(?:RAIRI|LAC)|(?:MOI|SA)LL|FAYETT|HAR"
  "P|ROS)E|GRANGE(?: (?:HIGHLANDS|P(?:AR)?K))?)|KE(?: (?:B(?:ARRINGT"
  "ON|LUFF)|FOR(?:EST|K)|IN THE HILLS|ZURICH|VILLA)|MOOR|WOOD)|N(?:("
  "?:(?:ESVILL)?|GLEYVILL)E|CASTER|SING|ARK)|W(?:RENCEVIL|NDA)LE|C(?"
  ":LEDE|ON)|GRANGE HLDS|THAM|FOX|URA|DD)|I(?:N(?:COLN(?:S(?: NEW SA"
  "LEM|HIRE)| NW SL|WOOD)?|DEN(?:HURST|WOOD))|T(?:TLE(?: (?:INDIAN|Y"
  "ORK)|TON)|CHFIELD|ERBERRY)|V(?:INGSTON|ERPOOL)|BERTY(?:VILLE)?|SL"
  "E|MA)|O(?:N(?:G(?: (?:GROVE|POINT)|VIEW)|DON MILLS)|V(?:E(?:S PAR"
  "K|JOY)|INGTON)|(?:UISVILL|OGOOTE|RAIN)E|(?:CKPOR|STAN)T|W(?:POINT"
  "|DER)|M(?:BARD|AX)|D(?:GE|A)|AMI|GAN)|E(?:(?:(?:XINGT|BAN)O|WISTO"
  "W)N|LAND(?: GROVE)?|E(?: CENTER)?|N(?:ZBURG|A)|AF RIVER|ONORE| RO"
  "Y|MONT|RNA)|Y(?:N(?:N(?: CENTER|VILLE)|CHBURG|WOOD|DON)|ONS)|K (?"
  ":BARRINGTON|IN THE HLS)|U(?:DLOW|THER))|W(?:A(?:L(?:NUT(?: HILL)?"
  "|SH(?:VILLE)?|TONVILLE)|S(?:H(?:INGTON(?: P(?:AR)?K)?|BURN)|CO)|T"
  "(?:ER(?:LOO|MAN)|S(?:EKA|ON)|AGA)|R(?:REN(?:SBURG|VILLE)?|SAW)|YN"
  "E(?:SVILLE| CITY)?|U(?:CONDA|KEGAN)|DSWORTH|GGONER|PELLA|VERLY)|I"
  "(?:L(?:L(?:OW(?: (?:SP(?:RIN)?GS|HILL)|BROOK)|I(?:AMS(?:FIELD|VIL"
  "LE)|SVILLE)|EYS)|M(?:INGTON|ETTE)|TON CENTER|SONVILLE)|N(?:(?:THR"
  "OP H(?:ARBO|B)|CHESTE|DSO)R|NE(?:BAGO|TKA)|FIELD|SLOW)|TT)|E(?:ST"
  "(?: (?:(?:BROOKLY|UNIO)N|P(?:EORIA|OINT)|FRANKFORT|CHICAGO|LIBERT"
  "Y|DUNDEE|SALEM|YORK)|ER(?:N SPR(?:IN)?GS|VELT)|CHESTER|FIELD|VILL"
  "E|MONT)|(?:L(?:LINGT|D)|DR)ON|NONA)|O(?:O(?:D(?: (?:RIVER|DALE)|S"
  "(?:TOCK|ON)|LA(?:ND|WN)|RIDGE|HULL)|SUNG)|(?:NDER|LF) LAKE|R(?:DE"
  "N|TH)|MAC)|H(?:IT(?:E H(?:EATH|ALL)|TINGTON)|E(?:EL(?:ING|ER)|ATO"
  "N))|Y(?:OMING|ANET)| FRANKFORT|RIGHTS)|P(?:A(?:L(?:O(?:S (?:H(?:E"
  "IGHT|ILL)S|PARK)|MA)|(?:ES|A)TINE|M(?:YRA|ER))|R(?:K(?: (?:FOREST"
  "|RIDGE|CITY)|ERSBURG)|IS)|N(?:(?:(?:AM)?|OL)A|THER CREEK)|T(?:TER"
  "SON|OKA)|W(?: PAW|NEE)|(?:XT|YS)ON|PINEAU)|R(?:AIRIE(?: (?:DU ROC"
  "HER|CITY|VIEW)|VIEW)|O(?:SPECT (?:HEIG)?HTS|PHETSTOWN)|E(?:EMPTIO"
  "N|NTICE)|INCE(?:VILLE|TON)| DU ROCHER)|O(?:(?:RT B(?:ARRINGT|YR)O"
  "|SE)N|NT(?:OO(?:N BEACH|SUC)|IAC)|PLAR (?:GROVE|CITY)|CAHONTAS|TO"
  "MAC|MONA|LO)|E(?:O(?:RIA(?: (?:HEIG)?HTS)?|TONE)|R(?:[CR]Y|KS|U)|"
  "ARL(?: CITY)?|CATONICA|TERSBURG|NFIELD|SOTUM|KIN)|I(?:ER(?:SON ST"
  "A(?:TION)?|RON)|N(?:CKNEYVILL|GREE GROV)E|TTS(?:FIELD|BURG)|PER C"
  "ITY|SGAH|ASA)|L(?:A(?:IN(?:VI(?:LLE|EW)|FIELD)|TO CENTER|NO)|EASA"
  "NT (?:PL(?:AI)?NS|HILL|VIEW)|YMOUTH)|U(?:LASKI|TNAM)|H(?:OENIX|IL"
  "O)|T BARRINGTON)|H(?:A(?:R(?:WOOD H(?:EIGH|G)?TS|RIS(?:BURG|TOWN)"
  "|T(?:SBURG|FORD)|V(?:E[LY]|ARD)|(?:DI|MO)N|CO)|M(?:P(?:SHIRE|TON)"
  "|(?:LETS)?BURG|ILTON|MOND|EL)|N(?:OVER(?: PARK)?|NA CITY)|ZEL (?:"
  "CREST|DELL)|WTHORN W(?:OO)?DS|GA(?:RSTOW|MA)N|INESVILLE|VANA)|O(?"
  ":L(?:IDAY HILLS|LOWAYVILLE|COMB|DER)|P(?:E(?:DALE|WELL)|KINS PARK"
  ")|ME(?:R(?: GLEN)?|TOWN|WOOD)|FFMAN(?: EST(?:ATES)?)?|OP(?:ESTON|"
  "POLE)|DGKINS|YLETON)|E(?:R(?:RI(?:CK|N)|(?:AL|O)D|VEY CITY|SCHER)"
  "|N(?:N(?:EPIN|ING)|(?:DERS|T)ON|RY)|(?:BRO|MA)N|WITTSVILLE|YWORTH"
  "|TTICK|CKER)|I(?:LL(?:S(?:(?:DAL|ID)E|BORO)|VIEW)|N(?:DSBORO|CKLE"
  "Y|SDALE|TON|ES)|GH(?:LAND(?: PARK)?|WOOD)|CKORY HILLS|DALGO)|U(?:"
  "NT(?:SVILLE|LEY)|M(?:BOLDT|E)|(?:BL|E)Y|TSONVILLE|DSON|RST|LL))|R"
  "(?:O(?:C(?:K(?: (?:ISLAND|FALLS|CITY)|(?:BRIDG|DAL)E|(?:FOR|WOO)D"
  "|PORT|TON)|HE(?:STER|LLE))|UND L(?:AKE(?: (?:HEIGHTS|BEACH|PARK))"
  "?|K (?:PARK|BCH|HTS))|S(?:E(?:(?:VI)?LLE|MONT)|(?:ICLAR|SVILL|CO)"
  "E|AMOND)|B(?:(?:B(?:IN)?|ERT)S|INSON|Y)|(?:M(?:EOVILL)?|ODHOUS|AN"
  "OK)E|LLING M(?:EADO|D)WS|YAL(?: LAKES|TON)?|XANA)|I(?:VER(?: (?:F"
  "OREST|GROVE)|(?:DAL|SID)E|WOODS|TON)|D(?:G(?:E FARM|WAY)|DLE HILL"
  "|OTT)|CH(?:(?:LA|MO)ND|TON PARK|VIEW)|N(?:GWOO|AR)D|GGSTON|O)|A(?"
  ":(?:PIDS CIT|MSE)Y|N(?:TOUL|KIN|SOM)|D(?:FORD|OM)|Y(?:MOND)?|LEIG"
  "H|RITAN)|E(?:D(?: ?BUD|DICK|MON)|(?:YNOLD|E)S|NAULT)|U(?:S(?:HVIL"
  "LE|SELL)|TLAND|MA))|G(?:R(?:A(?:N(?:D(?: (?:CHAIN|RIDGE|TOWER)|VI"
  "EW)|T(?: PARK|SBURG)|ITE CITY|VILLE)|Y(?:(?:SLAK|VILL)E|MONT)|FTO"
  "N)|E(?:EN(?: (?:VALLEY|ROCK)|VI(?:LLE|EW)|FIELD|UP)|AT LAKES)|I(?"
  ":GGSVILLE|DLEY)|OVELAND)|O(?:L(?:DEN(?: (?:EAGL|GAT)E)?|CONDA|F)|"
  "OD(?:(?: HOP|WIN)E|FIELD)|R(?:EVILLE|HAM)|D(?:FR|L)EY)|E(?:R(?:MA"
  "N(?:T(?:OWN(?: HILLS)?|WN HLS)| VALLEY)|LAW)|N(?:E(?:SEO|VA)|OA)|"
  "ORGETOWN|FF)|L(?:EN(?:DALE (?:HEIG)?HTS| (?:CARBO|ELLY)N|VIEW|WOO"
  "D|ARM|COE)|A(?:DSTONE|SFORD))|A(?:L(?:E(?:SBURG|NA)?|(?:ATI|V)A|T"
  ")|RD(?:EN PR(?:AIRIE)?|NER)|GES LAKE|YS)|I(?:L(?:(?:MA|SO)N|LESPI"
  "E|BERTS)|(?:FFO|RA)RD|BSON CITY)|URNEE)|E(?:L(?:L(?:I(?:S(?: GROV"
  "|VILL)E|OTT)|SWORTH|ERY)|K(?: GROVE V(?:ILLAGE|LG)|VILLE|HART)|M("
  "?:WOOD(?: PARK)?|HURST)|D(?:ORADO|ENA|RED)|(?:VASTO|BUR|GI)N|IZAB"
  "ETH(?:TOWN)?|(?: PAS|C)O|W(?:OOD|IN)|EROY|SAH)|A(?:ST(?: (?:(?:DU"
  "(?:BUQU|NDE)|MOLIN)E|(?:ALTO|LYN)N|SAINT LOUIS|CARONDELET|GALESBU"
  "RG|PEORIA)|ON)|(?:GAR|RL)VILLE)|D(?:E(?:LSTEIN|NBURG)|WARDS(?:VIL"
  "LE)?|DYVILLE|GEWOOD|INBURG)|V(?:ERGREEN P(?:AR)?K|ANS(?:VILLE|TON"
  "))| (?:SAINT LOUIS|CARONDELET|GALESBURG)|N(?:FIELD|ERGY|ION|OS)|M"
  "(?:(?:INGTO|DE)N|MA)|S(?:MOND|SEX)|(?:UREK|OL)A|FFINGHAM|QUALITY|"
  "CKARD|XETER|WING|GAN|RIE)|A(?:L(?:(?:(?:GONQU|V)I|ORTO|DE)N|T(?:O"
  "(?: PASS|NA?)|AMONT)|E(?:X(?:ANDER|IS)|DO)|B(?:ANY|ERS|ION)|LE(?:"
  "NDALE|RTON)|(?:HAMBR|PH|M)A|S(?:EY|IP))|R(?:LINGTON(?: (?:HEIG)?H"
  "TS)?|C(?:(?:ADI|OL)A|HER)|M(?:INGTON|STRONG)|G(?:ENTA|O)|ENZVILLE"
  "|OMA PARK|ROWSMITH|NOLD|THUR)|N(?:D(?:ALUSIA|OVER|REW)|NA(?:POLIS"
  "|WAN)?|C(?:HOR|ONA)|TIOCH)|S(?:H(?:L(?:AND|EY)|MORE|KUM|TON)|SUMP"
  "TION|TORIA)|T(?:W(?:ATER|OOD)|TERBERRY|KINSON|LANTA|HENS)|D(?:DI("
  "?:EVILLE|SON)|RIAN|AIR)|U(?:(?:GUST|ROR)A|BURN)|B(?:BOTT PARK|ING"
  "DON)|V(?:(?:IST)?ON|A)|PPLE RIVER|MBOY|KIN)|F(?:O(?:X (?:R(?:IVER"
  " (?:VALLEY GARDENS|GR(?:OVE|V))|V VLY GN)|VALLEY|LAKE)|R(?:EST (?"
  ":CITY|PARK|VIEW)|REST(?:ON)?|T SHERIDAN|D HEIGHTS|SYTH)|OSLAND|WL"
  "ER)|A(?:IR(?:VIEW(?: (?:HEIG)?HTS)?|MO(?:NT CITY|UNT)|FIELD|BURY)"
  "|R(?:M(?:ER(?:SVILLE| CITY)|ING(?:DALE|TON))|INA)|(?:NCY PRAIRI|Y"
  "ETTEVILL)E)|R(?:ANK(?:LIN(?: (?:GR(?:OVE|V)|PARK))?|FORT(?: (?:HE"
  "IG)?HTS)?)|E(?:E(?:MAN SPUR|BURG|PORT)|DERICK))|I(?:(?:DELIT|NDLA"
  ")Y|(?:ELDO|THIA)N|LLMORE|SHER|ATT)|L(?:A(?:T ROCK|NAGAN)|O(?:SSMO"
  "OR|RA))|E(?:NTON|RRIS)|ULT(?:ON|S))|N(?:E(?:W(?: (?:B(?:E(?:DFORD"
  "|RLIN)|(?:OSTO|ADE)N|URNSIDE)|(?:DOUGLA|MEMPHI|ATHEN)S|H(?:OLLAND"
  "|AVEN)|L(?:IBERTY|ENOX)|C(?:ANTON|ITY)|WINDSOR|SALEM)|MAN(?:SVILL"
  "E)?|BURG|ARK|TON)|PONSET|LSON|OGA|BO)|O(?:R(?:T(?:H(?: (?:(?:(?:B"
  "ARRINGT|HENDERS)O|PEKI)N|RIVERSIDE|CHICAGO|AURORA)|BROOK|FIELD|WO"
  "ODS|LAKE)|ONVILLE)|RI(?:S(?: CITY)?|DGE)|MA(?:NDY|L)|A)|KOMIS|BLE"
  ")|A(?:T(?:IONAL STOCK YARDS|L STOCK YD)|P(?:ERVILLE|LES)|S(?:HVIL"
  "LE|ON)|CHUSA|UVOO)| (?:(?:BARRINGT|HENDERS)ON|RIVERSIDE)|I(?:L(?:"
  "WOOD|ES)|ANTIC|OTA))|D(?:A(?:L(?:(?:LAS|TON) CITY|ZELL|E)|N(?:V(?"
  ":ILLE|ERS)|FORTH|A)|VIS(?: J(?:UNCTION|CT))?|H(?:LGREN|INDA)|(?:R"
  "IE|WSO)N|MIANSVILLE|KOTA)|E(?:ER(?: (?:(?:CREE|PAR)K|GROVE)|FIELD"
  ")| (?:LAND|SOTO)|L(?:AVAN|ONG)|W(?:ITT|EY)|S PLAINES|NNISON|CATUR"
  "|TROIT|KALB|PUE)|O(?:W(?:N(?:E(?:RS GROVE|Y)|S)|ELL)?|N(?:(?:NELL"
  "SO|OVA)N|GOLA)|R(?:CHESTER|SEY)|L(?:LVILLE|TON)|VER)|U(?:N(?:D(?:"
  "AS|EE)|FERMLINE|KEL|LAP)| (?:QUOIN|BOIS)|RAND|VALL|PO)|I(?:X(?:MO"
  "OR|ON)?|ETERICH|VERNON|AMOND)|WIGHT)|O(?:AK(?: (?:BR(?:OOK(?: MAL"
  "L BRANCH)?|K MALL)|FOREST|LAWN|PARK)|BROOK TER(?:RACE)?|WOOD(?: H"
  "ILLS)?|L(?:AND|EY)|DALE|FORD)|L(?:D (?:MILL CR(?:EE)?K|BERLIN)|YM"
  "PIA F(?:IE)?LDS|IVE BRANCH|MSTED|NEY)|R(?:LAND (?:HILLS|PARK)|A(?"
  ":NGE)?VILLE|E(?:ANA|GON)|I(?:ENT|ON))|N(?:(?:ARG|EID)A|TARIOVILLE"
  ")|(?:S(?:WEG|C)|WANEC)O|(?:KAWVILL|CONE)E|TT(?:ERVILLE|AWA)|(?:QU"
  "AWK|MAH)A|G(?:LESBY|DEN)|P(?:DYKE|HIEM)|H(?:LMAN|IO)|D(?:ELL|IN)|"
  " FALLON|BLONG|ZARK)|T(?:O(?:W(?:ER (?:LAKES|HILL)|ANDA)|L(?:(?:ED"
  "|ON)O|UCA)|(?:NIC|PEK)A|RONTO|ULON|VEY)|A(?:YLOR(?: (?:SP(?:RIN)?"
  "GS|RIDGE)|VILLE)|M(?:AROA|PICO|MS)|BLE GROVE|LLULA)|H(?:O(?:M(?:P"
  "SONVILLE|ASBORO|SON)|RNTON)|A(?:WVILLE|YER)|IRD LAKE|EBES)|R(?:O("
  "?:Y(?: GROVE)?|UT VALLEY)|I(?:UMPH|VOLI|LLA)|E(?:MONT|NTON))|E(?:"
  "MPLE HILL|UTOPOLIS|NNESSEE|HERAN|CHNY|XICO)|I(?:L(?:DE|TO)N|NLEY "
  "PARK|MEWELL|SKILWA|CE)|U(?:NNEL HILL|SCOLA))|K(?:I(?:N(?:GS(?:TON"
  "(?: MINES?)?)?|DERHOOK|MUNDY|CAID|SMAN)|L(?:BOURNE|DEER)|RK(?:LAN"
  "|WOO)D)|A(?:N(?:(?:(?:EVILL)?|KAKE)E|SAS)|R(?:BERS RIDGE|NAK)|MPS"
  "VILLE|SBEER|PPA)|E(?:N(?:ILWORTH|NEY|T)|EN(?:SBURG|ES)|ITHSBURG|Y"
  "ESPORT|MPTON|WANEE|LL)|NOXVILLE)|V(?:I(?:LLA(?: (?:(?:GROV|RIDG)E"
  "|PARK)|GE OF LAKEWOOD)|R(?:GI(?:NIA|L)|DEN)|(?:CTORI|ENN|OL)A)|E("
  "?:R(?:(?:SAILL|GENN)ES|M(?:ILION|ONT)|NON(?: HILLS)?|ONA)|N(?:EDY"
  "|ICE))|A(?:N(?: ORIN|DALIA)|L(?:MEY|I)ER|RNA)|LG OF LAKEWD|OLO)|I"
  "(?:N(?:D(?:IAN(?: (?:HEAD P(?:AR)?|CREE)K|OLA)| HEAD P(?:AR)?K|US"
  "TRY)|G(?:LESIDE|RAHAM)|VERNESS|A)|R(?:VING(?:TON)?|OQUOIS)|LLI(?:"
  "NOIS CITY|OPOLIS)|(?:SLAND LAK|VESDAL)E|(?:TASC|PAV|OL|UK)A)|J(?:"
  "E(?:(?:R(?:SEYVILL|OM)|ISEYVILL)E|FFERSON P(?:AR)?K|WETT)|O(?:HNS"
  "(?:TON CITY|ONVILLE|BURG)|NESBORO|LIET|PPA|Y)|A(?:C(?:KSONVILLE|O"
  "B)|NESVILLE)|U(?:NCTION|STICE))|U(?:NI(?:VERSITY P(?:AR)?K|ON(?: "
  "HILL)?|TY)|(?:R(?:BAN|S)|TIC)A|LLIN)|Y(?:A(?:TES(?: CITY|VILLE)|("
  "?:NTISVIL)?LE)|ORKVILLE)|Z(?:EIGLER|ION)|QUINCY|XENIA))))$"
  ,
  /* -- IN -- IN -- IN -- IN -- IN -- IN -- IN -- IN -- IN -- IN -- */
  "(?:\\b)((?^:(?i:(?:C(?:A(?:M(?:P(?: ATT(?:ERBU?|RB)RY|BELLSBURG)|"
  "B(?:RIDGE CI?T)?Y|DEN)|R(?:T(?:ERSBURG|HAGE)|(?:EFRE|LISL)E|BON|M"
  "EL)|N(?:NEL(?:BURG|TON)|AAN)|STLETON|YUGA|TES)|O(?:L(?:UMB(?:IA C"
  "ITY|US)|LEGEVILLE|BURN|FAX)|A(?:L(?: CITY|MONT)|TESVILLE)|R(?:Y(?"
  ":DON)?|TLAND|UNNA)|N(?:NERSVILL|VERS)E|MMISKEY|VINGTON)|H(?:A(?:R"
  "L(?:OTTESV(?:IL)?LE|ESTOWN)|LMERS|NDLER)|RIS(?:TMAS L(?:AKE VILLA"
  "GE|K)|NEY)|ESTER(?:FIELD|TON)|URUBUSCO|ILI)|L(?:A(?:RKS(?: HILL|V"
  "ILLE|BURG)|Y(?: CITY|POOL|TON))|E(?:AR CREEK|RMONT)|I(?:FFORD|NTO"
  "N)|VR MIL ACAD|OVERDALE)|R(?:A(?:N(?:E(?: NAV(?:AL DEPO| DP)T)?|D"
  "ALL)|(?:WFORDSVI?|IGVI)LLE)|O(?:THERSVILLE|SS PLAINS|WN POINT|MWE"
  "LL))|E(?:NT(?:ER(?:POINT|VILLE|TON)|RAL)|(?:DAR (?:GROV|LAK)|LEST"
  "IN)E)|U(?:(?:LV|TL)ER|MBERLAND)|YNTHIANA|ICERO)|S(?:A(?:INT (?:M("
  "?:ARY OF THE WOODS|EINRAD)|JO(?:HN|E)|ANTHONY|BERNICE|CROIX|LEON|"
  "PAUL)|N(?:D(?:BORN|FORD)|TA CLAUS| PIERRE)|L(?:AMONIA|EM)|RATOGA)"
  "|T(?:A(?:R(?: CITY|LIGHT)|TE LINE|NFORD|UNTON)|(?:OCKWEL|ENDA)L|R"
  "(?:AUGHN|OH)|I[LN]ESVILLE| MARY OF WD)|H(?:E(?:LB(?:Y(?:VILLE)?|U"
  "RN)|PARDSVILLE|RIDAN)|I(?:PSHEWANA|RLEY)|ARPSVILLE|OALS)|U(?:L(?:"
  "PHUR(?: SP(?:RIN)?GS)?|LIVAN)|M(?:AVA R(?:ESOR|S)TS|MITVILLE)|NMA"
  "N)|O(?:UTH(?: (?:(?:MILFOR|BEN)D|WHITLEY)|PORT)|MER(?:VILLE|SET)|"
  "LSBERRY)|P(?:E(?:NCER(?:VILLE)?|ED(?:WAY)?)|RING(?:VILLE|PORT)|IC"
  "ELAND|URGEON)|C(?:H(?:NE(?:LLVILLE|IDER)|ERERVILLE)|OT(?:TSBURG|L"
  "AND)|IPIO)|E(?:L(?:LERSBURG|MA)|(?:DAL|RV)IA|ELYVILLE|YMOUR)|I(?:"
  "LVER LAKE|BERIA|DNEY|MS)|W(?:ITZ CITY|EETSER|AYZEE)|(?:MITHVILL|Y"
  "RACUS)E)|M(?:O(?:N(?:T(?:E(?:ZUMA|REY)|MORENCI|GOMERY|ICELLO|PELI"
  "ER)|RO(?:E(?:V(?:ILLE|L)| CITY)?|VIA)|GO|ON)|UNT (?:S(?:AINT FRAN"
  "CIS|UMMIT)|PLEASANT|VERNON|AYR)|R(?:RIS(?:TOWN)?|GANTOWN|OCCO)|OR"
  "E(?:S(?: HILL|VILLE)|LAND)|DOC)|I(?:L(?:L(?:(?:HOUSE|TOW)N|ERSBUR"
  "G| CREEK)|(?:TO|A)N|FORD|ROY)|CHI(?:GAN(?: CITY|TOWN)|ANA SH(?:OR"
  "E|R)S)|D(?:DLE(?:BURY|TOWN)|LAND)|SHAWAKA|TCHELL|AMI)|A(?:R(?:(?:"
  "(?:TIN|Y)SVIL|K(?:LEVIL)?)LE|I(?:AH HILL|ON)|SH(?:FIELD|ALL)|ENGO"
  ")|(?:UCKPOR|GNE)T|(?:TTHEW|Y)S|C(?:KE)?Y|DISON|NILLA|XWELL)|E(?:D"
  "(?:ARYVILLE|ORA)|R(?:RILLVILLE|OM)|(?:TAMOR|CC)A|LLOTT|MPHIS|NTON"
  "E|XICO)|T (?:ST FRANCIS|PLEASANT)|U(?:N(?:STER|CIE)|LBERRY)|C COR"
  "DSVILLE)|B(?:R(?:O(?:OK(?:(?:STO|LY)N|VILLE)?|WNS(?:VILLE|BURG|TO"
  "WN))|I(?:DGE(?:PORT|TON)|NGHURST|STO[LW]|MFIELD)|A(?:NCHVILLE|DFO"
  "RD|ZIL)|UCEVILLE|EMEN|YANT)|U(?:R(?:N(?:E(?:TTSVILLE|Y)|S HARBOR)"
  "|R(?: OAK|OWS)|LINGTON|KET)|CK(?: CREEK|SKIN)|FFALO(?:VILLE)?|TLE"
  "R(?:VILLE)?|NKER HILL)|E(?:(?:ECH GROV|LLMOR|RN)E|N(?:TONVILLE|NI"
  "NGTON)|VERLY SH(?:ORE|R)S|THLEHEM|DFORD)|O(?:(?:(?:WLING GRE|RD)E"
  "|GGSTOW|URBO)N|ON(?:E GROV|VILL)E|S(?:WELL|TON))|L(?:O(?:OM(?:ING"
  "(?:DALE|TON)|FIELD)|CHER)|ANFORD|UFFTON)|A(?:T(?:TLE GROUND|ESVIL"
  "LE|H)|(?:RGERSVILL|INBRIDG)E)|I(?:CKNELL|RDSEYE|PPUS))|W(?:E(?:ST"
  "(?: (?:(?:(?:MIDDLE|NEW)T|HARRIS)ON|L(?:AFAYETTE|EBANON)|COLLEGE "
  "CORNER|BADEN SPRINGS|TERRE HAUTE)|P(?:O(?:IN|R)T|HALIA)|FIELD|VIL"
  "LE)|BSTER)|A(?:L(?:(?:(?:KER)?T|DR)ON|LACE)|(?:SHINGTO|YNETOW)N|N"
  "A(?:MAKER|TAH)|(?:KARUS|WAK)A|T(?:ERLOO|SON)|R(?:REN|SAW)|DESVILL"
  "E|VELAND|BASH)|I(?:L(?:L(?:IAMS(?:BURG|PORT)?|OW BRANCH)|KINSON)|"
  "N(?:(?:ONA LAK|GAT)E|CHESTER|DFALL|AMAC|SLOW))| (?:(?:TERRE HAU|L"
  "AFAYET)TE|BADEN SPRGS|COLLEGE COR|MIDDLETON)|O(?:L(?:COTT(?:VILLE"
  ")?|FLAKE)|ODB(?:RIDGE|URN)|RTHINGTON)|H(?:E(?:AT(?:FIEL|LAN)D|ELE"
  "R)|IT(?:E(?:STOWN|LAND)|ING))|YATT)|N(?:E(?:W(?: (?:(?:(?:L(?:EBA"
  "N|ISB)|TRENT)O|GOSHE)N|W(?:A(?:SHINGTO?N|VERLY)|HITELAND)|C(?:A(?"
  ":RLIS|ST)LE|HICAGO)|P(?:A(?:LESTINE|RIS)|OINT)|M(?:IDDLETO?WN|ARK"
  "ET)|A(?:UGUSTA|LBANY)|R(?:ICHMOND|OSS)|HA(?:RMONY|VEN)|SALISBURY)"
  "|B(?:ERRY|URGH)|PORT|TOWN)|BRASKA|EDHAM)|O(?:R(?:TH (?:(?:MANCHE|"
  "WEB)STER|(?:JUDS|VERN)ON|TERRE HAUTE|LIBERTY|SALEM)|MAN|A)|(?:BLE"
  "SVILL|TRE DAM)E)|A(?:P(?:OLEON|PANEE)|VILLETON|SHVILLE|BB)| (?:TE"
  "RRE HAUTE|MANCHESTER)|INEVEH)|L(?:A(?:(?: (?:F(?:ONTAIN|AYETT)|CR"
  "OSS|PORT)|NESVILL|FAYETT)E|KE(?: (?:STATION|VILLAGE|CICOTT)|VILLE"
  "|TON)|WRENCE(?:BURG)?|(?:CONI|DOG)A|(?:RWIL|URE)L|GR(?:ANGE|O)|P("
  "?:AZ|EL)|OTTO|MAR)|I(?:BERTY(?: (?:C(?:ENTE|T)R|MILLS))?|N(?:(?:D"
  "E|TO)N|COLN CITY|N GROVE)|TTLE YORK|GONIER|VONIA|ZTON)|E(?:(?:XIN"
  "GT|BAN)ON|WIS(?:VILLE)?|ITERS FORD|O(?:POLD)?|AVENWORTH|ESBURG|RO"
  "Y)|O(?:(?:SANTVILL|OGOOTE)E|GANSPORT|NG BEACH|WELL)|Y(?:NN(?:VILL"
  "E)?|ONS)|UCERNE)|F(?:R(?:E(?:E(?:LANDVILLE|TOWN|DOM)|D(?:ERICKSBU"
  "?RG|ONIA)|NCH LICK|MONT)|AN(?:K(?:(?:LI|TO)N|FORT)|C(?:ESVILLE|IS"
  "CO))|IENDSHIP)|O(?:R(?:T(?: (?:BRANCH|RITNER|WAYNE)|VILLE)|AKER|E"
  "ST)|UNTAIN(?: CITY|TOWN)|WLER(?:TON)?|LSOMVILLE|NTANET)|A(?:IR(?:"
  "(?: OA|BAN)KS|MOUNT|LAND)|RM(?:ERSBURG|LAND)|LMOUTH)|L(?:O(?:R(?:"
  "ENCE|A)|YDS KNOBS)|AT ROCK)|I(?:LLMORE|SHERS|NLY)|UL(?:TON|DA)|ER"
  "DINAND)|P(?:A(?:R(?:IS (?:CROSS|X)ING|KER(?: CITY)?|AGON)|T(?:RI("
  "?:CKSBURG|OT)|OKA)|LMYRA|XTON|OLI)|E(?:N(?:(?:NVILL|C)E|DLETON)|R"
  "(?:RYSVILLE|SHING|U)|T(?:ERSBURG|ROLEUM)|KIN)|L(?:EASANT (?:M(?:I"
  "L)?LS|LAKE)|AIN(?:FIELD|VILLE)|YMOUTH)|I(?:ERCE(?:VILLE|TON)|(?:T"
  "TSBOR|MENT)O|NE VILLAGE)|O(?:RT(?:LAND|AGE|ER)|SEYVILLE|LAND|NETO"
  ")|R(?:AIRIE(?: CREEK|TON)|INCETON|EBLE)|UTNAMVILLE)|H(?:A(?:R(?:T"
  "(?:FORD CITY|SVILLE)|(?:DIN|ROD)SBURG|MONY|LAN)|(?:GERSTOW|ZLETO|"
  "YDE)N|M(?:ILTON|MOND|LET)|N(?:OVER|NA)|UBSTADT|TFIELD)|O(?:L(?:LA"
  "ND|TON)|B(?:ART|BS)|AGLAND|GTOWN|[PW]E|MER)|E(?:L(?:M(?:SBURG|ER)"
  "|TONVILLE)|NRYVILLE|MLOCK|BRON)|U(?:NT(?:ING(?:BURG|TON)|ERTOWN)|"
  "(?:DS|R)ON)|I(?:LL(?:S(?:BORO|DALE)|ISBURG)|GHLAND)|YMERA)|G(?:R("
  "?:EEN(?:S(?:B(?:ORO|URG)| FORK)|(?:CAST|VIL|DA)LE|(?:FIEL|WOO)D|T"
  "OWN)|A(?:N(?:TSBURG|DVIEW|GER)|SS CREEK|YSVILLE|BILL|MMER)|I(?:SS"
  "OM A(?:IR RESERVE BASE|RB)|FFI(?:TH|N))|OVERTOWN)|A(?:L(?:VESTON|"
  "ENA)|S(?: CITY|TON)|R(?:RETT|Y))|O(?:S(?:PORT|HEN)|LDSMITH|ODLAND"
  ")|E(?:N(?:TRYVILLE|EVA)|ORGETOWN)|(?:LENWOO|UILFOR)D|WYNNEVILLE)|"
  "R(?:O(?:C(?:K(?:FIELD|VILLE|PORT)|HESTER)|S(?:E(?:DALE|LAWN|WOOD)"
  "|SVILLE)|A(?:N(?:OKE|N)|CHDALE)|M(?:E(?: CITY)?|NEY)|LLING PR(?:A"
  "IRIE)?|YAL CENTER)|E(?:ELSVILLE|NSSELAER|MINGTON|YNOLDS|DKEY|GO)|"
  "I(?:CH(?:LA|MO)ND|DGEVILLE|SING SUN|LEY)|US(?:S(?:ELL|IA)|H)VILLE"
  "|A(?:GSDALE|MSEY))|E(?:L(?:IZABETH(?:TOWN)?|(?:BERFEL|WOO)D|LETTS"
  "VILLE|KHART|NORA)|A(?:ST (?:ENTERPRISE|CHICAGO)|(?:GLE CREE|RL PA"
  "R)K|TON)|D(?:WARDSPORT|INBURGH)|VANS(?:VILLE|TON)|C(?:KERT|ONOM)Y"
  "|MI(?:NENCE|SON)| ENTERPRISE|TNA GREEN|NGLISH)|A(?:T(?:T(?:ERBURY"
  "|ICA)|LANTA|HENS|WOOD)|L(?:B(?:ANY|ION)|EXANDRIA|AMO|TON)|R(?:C(?"
  ":ADI|OL)A|LINGTON|GOS)|N(?:D(?:ERSON|REWS)|GOLA)|U(?:(?:BUR|STI)N"
  "|RORA)|V(?:O(?:CA|N)|ILLA)|M(?:B(?:IA|OY)|O)|(?:CT|KR)ON|DVANCE|S"
  "HLEY)|T(?:E(?:(?:MPLET|NNYS)ON|RRE HAUTE|LL CITY|FFT)|A(?:YLORSVI"
  "LLE|NGIER|SWELL|LBOT)|I(?:P(?:PECANOE|TON)|ME/LIFE)|R(?:A(?:IL CR"
  "EEK|FALGAR)|OY)|O(?:BINSPORT|PEKA)|H(?:ORNTOWN|AYER)|WELVE MILE|U"
  "NNELTON|YNER)|D(?:E(?:(?:EDSVILL|MOTT)E|C(?:ATU|KE)R|L(?:ONG|PHI)"
  "|N(?:HAM|VER)|P(?:AUW|UTY)|RBY)|A(?:(?:RLING|Y)TON|(?:LEVIL)?LE|N"
  "(?:VILLE|A))|U(?:N(?:REITH|KIRK)|B(?:LIN|OIS)|GGER|PONT)|ILLSBORO"
  "|ONALDSON|YER)|O(?:AK(?:LAND(?: CITY|ON)|VILLE|FORD|TOWN)|T(?:IS("
  "?:CO)?|TERBEIN|WELL)|R(?:L(?:EANS|AND)|ESTES|A)|S(?:CEOLA|GOOD|SI"
  "AN)|WENS(?:VILLE|BURG)|(?:NWA|XFO)RD|LDENBURG|OLITIC|BER|DON)|K(?"
  ":I(?:NG(?:S(?:FORD (?:HEIG)?HTS|BURY)|MAN)|MMELL|RKLIN)|E(?:N(?:("
  "?:TLAN|NAR)D|DALLVILLE)|YSTONE|MPTON|WANNA)|N(?:IGHTS(?:VILLE|TOW"
  "N)|OX)|O(?:KOMO|LEEN|UTS)|URTZ|YANA)|V(?:A(?:L(?:P(?:ARAIS)?O|LON"
  "IA|EENE)|N BUREN)|E(?:R(?:SAILLES|NON)|EDERSBURG|LPEN|VAY)|INCENN"
  "ES)|U(?:N(?:I(?:ON(?: (?:MILLS|CITY)|(?:VIL|DA)LE)|VERSAL)|DERWOO"
  "D)|(?:RBAN|TIC)A|PLAND)|J(?:A(?:S(?:ONVILLE|PER)|MESTOWN)|EFF(?:E"
  "RSONVI?LLE)?|ONES(?:VILLE|BORO)|UDSON)|I(?:N(?:G(?:LEFIELD|ALLS)|"
  "DIANAPOLIS|WOOD)|DAVILLE|RELAND)|Y(?:O(?:UNG AMERICA|RKTOWN|DER)|"
  "EOMAN)|Z(?:ANE|ION)SVILLE|XMAS LK VLG|QUINCY))))$"
  ,
  /* -- KS -- KS -- KS -- KS -- KS -- KS -- KS -- KS -- KS -- KS -- */
  "(?:\\b)((?^:(?i:(?:C(?:O(?:L(?:(?:DWAT|LY)ER|(?:ON|B)Y|UMBUS|WICH"
  ")|N(?:WAY(?: SP(?:RIN)?GS)?|CORDIA)|U(?:N(?:CIL GROV|TRYSID)E|RTL"
  "AND)|(?:TTONW(?:OOD FAL|D F)L|AT)S|(?:(?:FFE)?YVILL|OLIDG)E|PELAN"
  "D|RNING|DELL)|A(?:R(?:L(?:TON|YLE)|BONDALE|ONA)|(?:WKER CIT|SSODA"
  ")Y|(?:MBRIDG|THARIN)E|N(?:TON|EY)|LDWELL)|L(?:E(?:AR(?:VIEW CI?TY"
  "|WATER)|MENTS)|A(?:Y(?: CENTER|TON)|FLIN)|I(?:FTON|MAX)|YDE)|H(?:"
  "E(?:R(?:RYVAL|OKE)E|TOPA|NEY)|A(?:(?:NUT|S)E|UTAUQUA|PMAN))|E(?:N"
  "T(?:R(?:OPOLIS|ALIA)|ERVILLE)|DAR(?: (?:POINT|VALE))?)|U(?:L(?:LI"
  "SON|VER)|NNINGHAM|MMINGS|BA)|I(?:RCLEVILLE|MARRON)|RESTLINE)|M(?:"
  "A(?:R(?:(?:YSVILL|QUETT)E|I(?:ENTHAL|ON))|N(?:(?:CHES)?TER|HATTAN"
  "|KATO)|(?:TFIELD GR(?:EE)?|DISO)N|PLE(?: (?:CITY|HILL)|TON)|(?:CK"
  "SVILL|IZ)E|Y(?:FIELD|ETTA)|HASKA)|O(?:UN(?:D(?: (?:VALLE|CIT)Y|RI"
  "DGE)|T HOPE)|R(?:R(?:OWVILLE|ILL)|GANVILLE|LAND|AN)|N(?:TEZUMA|UM"
  "ENT)|LINE|SCOW|DOC)|C(?: (?:(?:FARLAN|DONAL)D|C(?:RACKEN|UNE)|PHE"
  "RSON|LOUTH)|CONNELL AFB|PHERSON)|I(?:L(?:TON(?:VALE)?|FORD|AN)|SS"
  "ION(?: (?:HILL|WOOD)S)?|NNE(?:APOLIS|OLA))|E(?:D(?:ICINE L(?:ODGE"
  "|DG)|ORA)|R(?:IDEN|RIAM)|N(?:TOR|LO)|LVERN|ADE)|U(?:L(?:(?:LINVIL"
  "L|VAN)E|BERRY)|SCOTAH|RDOCK|NDEN))|S(?:T(?:A(?:FFORD|NLEY|RK)|U(?"
  ":TTGART|DLEY)| BENEDICT|RONG CITY|ERLING|ILWELL|OCKTON)|A(?:INT ("
  "?:(?:FRANCI|MARY)S|GEORGE|JOHN|PAUL)|(?:BETH|TANT|LIN)A|VONBURG|W"
  "YER)|H(?:A(?:WNEE(?: M(?:ISSIO|S)N)?|RON(?: SP(?:RIN)?GS)?)|IELDS"
  ")|C(?:OTT(?:SVILLE| CITY)|(?:HOENCHE|RANTO)N|A(?:MMON|NDIA))|E(?:"
  "D(?:GWICK|AN)|VER(?:ANCE|Y)|LDEN|NECA|WARD)|O(?:UTH H(?:UTCHINSO|"
  "AVE)N|L(?:DIER|OMON))|Y(?:LV(?:AN GROVE|IA)|(?:CAMOR|RACUS)E)|U(?"
  ":MMERFIELD|BLETTE|N CITY|SANK)|P(?:RING HILL|EARVILLE|IVEY)|I(?:L"
  "VER LAKE|MPSON)|M(?:ITH CENTER|OLAN)| HUTCHINSON)|B(?:E(?:L(?:(?:"
  "L(?:E(?: PLAIN|VILL)|AIR)|V(?:IDER|U)|(?: AI|P)R)E|(?:MON|OI)T)|N"
  "(?:T(?:LEY|ON)|NINGTON|EDICT|DENA)|A(?:UMONT|TTIE|VER)|R(?:RYTO)?"
  "N|VERLY|ELER)|U(?:R(?:D(?:E(?:TT|N)|ICK)|LING(?:AME|TON)|R(?: OAK"
  "|TON)|NS)|C(?:KLIN|YRUS)|SH(?:ONG|TON)|NKER HILL|FFALO|HLER)|A(?:"
  "R(?:N(?:ARD|ES)|TLETT)|(?:ILEYVILL|ZIN)E|XTER SP(?:RIN)?GS|LDWIN "
  "CITY|SEHOR|VARIA)|L(?:U(?:E (?:RAPIDS|MOUND)|FF CITY)|AINE|OOM)|R"
  "(?:O(?:OKVILLE|WNELL|NSON)|E(?:WSTER|MEN))|O(?:NNER SPRI?NGS|GUE)"
  "|I(?:RD CITY|SON)|YERS)|L(?:A(?:K(?:E (?:OF THE FOREST|QUIVIRA|CI"
  "TY)|IN)|(?: (?:CROSS|HARP)|(?:FONTAI|CYG)N)E|N(?:CASTER|GDON|SING"
  "|E)|W(?:RENCE|TON)|T(?:IMER|HAM)|MONT|RNED)|E(?:O(?:N(?:A(?:RDVIL"
  "LE)?)?|TI)|A(?:VENWORTH|WOOD)|B(?:ANON|O)|N(?:EX|OR)A|COMPTON| RO"
  "Y|HIGH|VANT|WIS)|I(?:N(?:COLN(?:VILLE)?|N(?: VALLEY)?|DSBORG|WOOD"
  ")|BER(?:AL|TY)|TTLE RIVER|EBENTHAL)|O(?:NG(?:(?: ISLAN|FOR)D|TON)"
  "|UIS(?:VILLE|BURG)|ST SPRINGS|RRAINE|GAN)|U(?:DELL|CAS|RAY)|Y(?:N"
  "DON|ONS)|K OF THE FST)|W(?:E(?:S(?:T(?:WOOD(?: H(?:IL)?LS)?|(?: M"
  "INERA|FAL)L|MORELAND|PHALIA)|KAN)|L(?:L(?:S(?:VILLE)?|INGTON)|DA)"
  "|(?:BBE|I)R|TMORE)|A(?:L(?:D(?:RON|O)|LACE|KER|NUT|TON)|K(?:E(?:F"
  "IELD|ENEY)|ARUSA)|T(?:ERVILLE|HENA)|(?: KEENE|VERL)Y|SHINGTON|MEG"
  "O)|I(?:L(?:LI(?:AMSBURG|S)|S(?:EY|ON)|MORE)|N(?:CHESTER|FIELD|DOM"
  "|ONA)|CHITA)|H(?:IT(?:E(?: C(?:LOUD|ITY)|WATER)|ING)|E(?:ATON|ELE"
  "R))|OOD(?:BINE|STON)|RIGHT)|H(?:A(?:R(?:(?:DTN|P)ER|VEYVILLE|TFOR"
  "D|LAN)|V(?:EN(?:SVILLE)?|ILAND|ANA)|L(?:LOWELL|STEAD)|N(?:OVER|ST"
  "ON)|(?:MI|ZE)LTON|YS(?:VILLE)?|DDAM)|O(?:L(?:LENBERG|YROOD|COMB|T"
  "ON)|(?:ISING|R)TON|(?:[MP]|XI)E|WARD|YT)|I(?:LL(?:S(?:BORO|DALE)|"
  " CITY)|A(?:TTVILLE|WATHA)|GHLAND)|U(?:(?:(?:TCHIN|D)S|GOT|R)ON|N("
  "?:NEWELL|TER)|MBOLDT)|E(?:R(?:(?:INGT|ND)ON|KIMER)|(?:IZ|PL)ER|SS"
  "TON|ALY))|P(?:R(?:E(?:TTY PR(?:AIRI?E)?|S(?:COTT|TON))|A(?:IRIE V"
  "(?:I(?:LLAGE|EW)|LG)|TT)|(?:OTECTI|INCET)ON)|A(?:R(?:(?:TRIDG|ADI"
  "S)E|K(?: CITY|ER)?|SONS)|L(?:MER|CO)|WNEE ROCK|XICO|OLA)|E(?:N(?:"
  "ALOSA|OKEE)|R(?:RY|U)|TROLIA|ABODY|CK)|I(?:E(?:RCEVILLE|DMONT)|TT"
  "SBURG|QUA)|L(?:E(?:ASANTON|VNA)|AIN(?:VILLE|S))|O(?:T(?:TER|WIN)|"
  "WHATTAN|MONA|RTIS)|HILLIPSBURG|FEIFER)|A(?:L(?:T(?:A(?: VISTA|MON"
  "T)|O(?:ONA|N))|M(?:EN)?A|EXANDER|[DL]EN|BERT)|R(?:(?:(?:CAD|GON)I"
  "|M)A|KANSAS CITY|LINGTON|NOLD)|N(?:T(?:ELOPE|ONINO|HONY)|D(?:OVER"
  "|ALE))|T(?:(?:LANT|TIC)A|CHISON|WOOD|HOL)|U(?:(?:GUST|ROR)A|BURN)"
  "|B(?:BYVILL|ILEN)E|S(?:HLAND|SARIA)|ME(?:RICU)?S|D(?:MIRE|A)|G(?:"
  "END|R)A|XTELL)|G(?:A(?:R(?:D(?:EN (?:PLAIN|CITY)|NER)|(?:FIEL|LAN"
  ")D|NETT)|L(?:E(?:SBURG|NA)|(?:ATI|V)A)|YLORD|S)|R(?:E(?:E(?:N(?:S"
  "BURG|LEAF|WICH)?|LEY)|AT BEND|NOLA)|A(?:INFIELD|NTVILLE)|I(?:NNEL"
  "L|DLEY))|O(?:(?:ODLAN|DDAR)D|ESSEL|RHAM|FF|VE)|L(?:A(?:SCO|DE)|EN"
  " ELDER)|E(?:UDA SPRINGS|NESEO|M)|IRARD|YPSUM)|R(?:O(?:S(?:E(?: HI"
  "LL|DALE)|SVILLE|ALIA)|(?:ELAND PAR|C)K|BINSON|XBURY|LLA|ZEL)|A(?:"
  "N(?:D(?:OLPH|ALL)|TOUL|SOM)|D(?:IUM|LEY)|YMOND|MONA|GO)|E(?:(?:DF"
  "IEL|XFOR)D|PUBLIC|ADING|SERVE)|US(?:SELL(?: SP(?:RINGS|G))?|H CEN"
  "TER)|I(?:C(?:H(?:FIEL|MON)D|E)|VERTON|LEY))|E(?:L(?:K(?: (?:FALLS"
  "|CITY)|HART)|L(?:I(?:NWOOD|S)|SWORTH)|(?:MDAL|SMOR)E| DORADO|BING"
  "|WOOD)|D(?:(?:GERT|S)ON|WARDSVILLE|MOND|NA)|N(?:TERPRISE|GLEWOOD|"
  "SIGN)|AST(?:BOROUGH|ON)|M(?:PORIA|METT)|S(?:KRIDGE|BON)|U(?:DOR|R"
  "EK)A|FFINGHAM|VEREST|RIE)|N(?:E(?:W(?: (?:C(?:AMBRIA|ENTURY)|AL(?"
  ":BANY|MELO)|STRAWN)|TON)|O(?:SHO (?:RAPID|FALL)S|DESHA)|(?:TAWAK|"
  "KOM)A|SS CITY|AL)|OR(?:T(?:ON(?:VILLE)?|H NEWTON)|W(?:ICH|AY)|CAT"
  "UR)|A(?:(?:SHVILL|VARR)E|(?:TOM|RK)A)|I(?:CKERSON|OTAZE))|F(?:O(?"
  ":R(?:T (?:LEAVENWORTH|DODGE|RILEY|SCOTT)|MOSO|D)|(?:STORI|NTAN)A|"
  "WLER)|R(?:E(?:DONIA|EPORT)|ANK(?:FORT|LIN)|ONTENAC|IEND)|A(?:L(?:"
  "L RIVER|UN)|IR(?:VIEW|WAY)|RLINGTON)|T (?:LEAVNWRTH|RILEY)|LORENC"
  "E|ULTON)|O(?:S(?:A(?:GE CITY|WATOMIE)|KALOOSA|BORNE|WEGO)|L(?:(?:"
  "ATH|P)E|SBURG|MITZ)|VER(?:LAND PAR|BROO)K|(?:FFERL|ZAWKI)E|AK(?:H"
  "ILL|LEY)|G(?:ALLAH|DEN)|(?:BERL|D)IN|N(?:EID|AG)A|T(?:TAWA|IS)|PO"
  "LIS|XFORD|KETO)|D(?:E(?:N(?:(?:IS|T)ON|SMORE|NIS)|L(?:AVAN|PHOS|I"
  "A)|ERFIELD| SOTO|ARING|XTER|RBY)|O(?:(?:UGLAS|WN)S|DGE CITY|RRANC"
  "E|VER)|U(?:N(?:DEE|LAP)|LUTH|RHAM)|(?:IGHTO|RESDE)N|A(?:NVILLE|MA"
  "R)|WIGHT)|K(?:I(?:N(?:G(?:SDOW|MA)N|CAID|SLEY)|RWIN|SMET|OWA)|A(?"
  ":N(?:O(?:POLIS|RADO)|SAS CITY)|LVESTA)|E(?:N(?:SINGTON|DALL)|CHI|"
  "LLY))|T(?:O(?:(?:WAND|PEK)A|NGANOXIE|RONTO)|(?:I(?:MKE|PTO)|URO)N"
  "|R(?:(?:IBUN|EEC)E|OY)|E(?:CUMSEH|SCOTT)|A(?:LMAGE|MPA)|HAYER|YRO"
  ")|V(?:A(?:LLEY (?:CENTER|FALLS)|SSAR)|I(?:(?:CTORI|OL)A|RGIL)|ERM"
  "ILLION|LIETS)|I(?:N(?:D(?:EPENDENCE|USTRY)|GALLS|MAN)|(?:O(?:NI|L"
  ")|UK)A|SABEL)|J(?:E(?:NNINGS|TMORE|WELL)|(?:AMESTOW|OHNSO)N|UNCTI"
  "ON CITY)|U(?:NIONTOWN|LYSSES|DALL|TICA)|Y(?:ATES CENT|OD)ER|QU(?:"
  "ENEMO|INTER)|Z(?:URICH|ENDA)))))$"
  ,
  /* -- KY -- KY -- KY -- KY -- KY -- KY -- KY -- KY -- KY -- KY -- */
  "(?:\\b)((?^:(?i:(?:S(?:T(?:A(?:M(?:PING GR(?:OUN)?D|BAUGH)|N(?:VI"
  "LLE|FORD|LEY|TON)|(?:CY FO)?RK|FFORDSVI?LLE|TIC|B)|E(?:PHENS(?:BU"
  "RG|PORT)?|(?:UBENVIL|E)LE|ARNS|LLA)| (?:MA(?:TTHEWS|RY)|CATHARINE"
  "|JOSEPH)|O(?:NE(?:Y FORK)?|P(?:OVER)?)|INNETT|URGIS|RUNK)|A(?:INT"
  " (?:C(?:ATHARINE|HARLES)|(?:FRANCI|HELEN)S|MA(?:TTHEWS|RY)|JOSEPH"
  "|PAUL)|L(?:(?:YERSVILL|DE)E|T (?:LICK|GUM)|VISA|EM)|ND(?:Y HOOK|E"
  "RS|GAP)|SS(?:AFRAS|ER)|M(?:UELS|PLE)|CRAMENTO|DIEVILLE|RDIS|WYER|"
  "UL)|O(?:UTH(?: (?:(?:CARROLLT|WILLIAMS|UNI)ON|FORT MITCHELL|PORTS"
  "MOUTH|SHORE)|GATE)|FT SHELL|MERSET|LDIER|NORA)|E(?:B(?:ASTIANS BR"
  "(?:ANCH)?|REE)|(?:NTERVILL| RE)E|XTONS CREEK|VENTY SIX|WELLTON|MI"
  "NARY|DALIA|ITZ|CO)|U(?:MM(?:ER(?: SHAD|SVILL)E|IT?T)|L(?:PHUR(?: "
  "WELL)?|LIVAN)|N(?:NYBROOK|FISH)|B(?:LETT|TLE)|DITH|SIE)|H(?:E(?:L"
  "B(?:Y(?:VILLE| GAP)|IANA)|PHERDSVI?LLE)|AR(?:ON GROVE|PSBURG)|IVE"
  "LY)|I(?:L(?:VER(?: GROVE|HILL)|ER)|MPSONVILLE|ZEROCK|DNEY|TKA)|MI"
  "(?:TH(?:S (?:CREEK|GROVE)|(?:FIEL|LAN)D| MILLS)?|LAX)|P(?:RING(?:"
  " LICK|FIELD)|E(?:IGHT|NCE)|OTTSVILLE|ARTA)| (?:(?:CARROLLT|WILLIA"
  "MS)ON|FT MITCHELL|PORTSMOUTH)|C(?:IENCE HILL|OTTSVILLE|RANTON|UDD"
  "Y|ALF)|W(?:A(?:MP(?: BRANCH|TON)|NPOND)|EEDEN)|L(?:A(?:UGHTERS|DE"
  "|T)|OANS VALLEY|EMP)|YM(?:SONIA|BOL)|KYLINE|NOW)|C(?:A(?:N(?:E(?:"
  "Y(?:VILLE)?| VALLEY)|N(?:EL CITY|ON)|ADA|MER|TON|OE)|R(?:R(?:(?:S"
  "VILL|I)E|OLLTON)|(?:CASSONN|LISL)E|[TV]ER|Y)|L(?:V(?:(?:ERT CIT|A"
  "R)Y|IN)|IFORNIA|LAWAY|HOUN)|MP(?:BELLS(?:VI?LLE|BURG)| DIX|TON)|T"
  "LETTSBURG|INS STORE|SEY CREEK|VE CITY|WOOD|DIZ)|O(?:L(?:D(?: SPR("
  "?:GS(?:-HIGHLAND HTS| HI)|ING)|IRON)|UMB(?:IA|US)|LEGE HILL)|N(?:"
  "(?:STANTIN|FLUENC)E|(?:LE|WA)Y|CORD)|R(?:N(?:ETTS|ISH)VILLE|(?:YD"
  "O|BI)N|INTH)|(?:OPERSVIL|TT)LE|XS CREEK|VINGTON|ALGOOD|BHILL|MBS)"
  "|R(?:E(?:S(?:CENT (?:SP(?:RINGS|GS?)|PARK)|T(?:VIEW H(?:IL)?LS|WO"
  "OD))|ELSBORO)|A(?:N(?:E NEST|KS)|YN(?:OR|E)|B ORCHARD)|O(?:M(?:WE"
  "LL|ONA)|(?:FTO|W)N|CKETT|PPER)|U(?:TCHFIELD|MMIES)|ITTENDEN|YSTAL"
  ")|L(?:E(?:A(?:R(?: CR(?:EEK(?: SPRINGS)?|K SPG)|FIELD)|TON)|MENTS"
  "VILLE|RMONT)|O(?:VER(?: BOTTOM|PORT)|SPLINT)|A(?:Y(?: CITY|HOLE)?"
  "|RKSON)|I(?:F(?:FORD|TY)|NTON|MAX))|U(?:MBERL(?:AND(?: COLLEGE)?|"
  "ND CLG)|N(?:NINGHAM|DIFF)|T(?:SHIN|UNO)|(?:LV|ST)ER|RDSVILLE|B RU"
  "N)|H(?:A(?:P(?:PELL|LIN)|VIES|D)|E(?:STNUTBURG|VROLET|NOA))|E(?:N"
  "T(?:ER(?:TOWN)?|RAL CI?TY)|RULEAN|CILIA)|Y(?:NTHIANA|RUS)|I(?:NDA"
  "|SCO))|B(?:E(?:T(?:H(?:E(?:L(?:RIDGE)?|SDA)|AN(?:NA|Y)|LEHEM)|S(?"
  ":Y LAYNE|EY))|A(?:R(?: BRANCH|VILLE)|U(?:MONT|TY)|VER(?: DAM)?|TT"
  "YVILLE)|E(?:CH(?: (?:CREEK|GROVE)|MONT)| SPRING)|L(?:LEVUE|CHER|F"
  "RY|TON)|V(?:INSVILLE|ERLY)|N(?:HAM|TON)|R(?:EA|RY)|DFORD)|R(?:O(?"
  ":W(?:N(?:S(?: (?:(?:CROSS|X)ROADS|FORK)|VILLE)|ING)|DER)|OK(?:S(?"
  ":VILLE)?|LYN)|AD BOTTOM|DHEAD|NSTON|MLEY)|A(?:DFORDSVI?LLE|NDENBU"
  "RG)|YAN(?:TS(?: STOR|VILL)E)?|I(?:GHT SHADE|NKLEY)|E(?:EDING|MEN)"
  "|UIN)|A(?:R(?:NETTS CR(?:EE)?K|D(?:STOWN|WELL)|BOURVILLE|RIER|LOW"
  ")|(?:TTLETOW|KERTO|UGHMA)N|ILEY (?:SWITCH|CREEK)|L(?:LARDSVILLE|K"
  "AN)|N(?:DANA|NER)|SKETT|GDAD|XTER|YS)|U(?:R(?:N(?:ING FORK|SIDE|W"
  "ELL|A)|K(?:(?:ESVILL)?E|HART)|(?:LINGTO|GI)N|DINE)|CK(?:INGHAM|HO"
  "RN|NER)|T(?:TERFLY|LER)|S(?:[HY]|KIRK)|ECHEL|FFALO|LAN)|L(?:A(?:N"
  "(?:DVILLE|CHET)|I(?:RS MILL|NE)|CK(?:FORD|EY)|ZE)|UE(?: (?:DIAMON"
  "D|RIVER)|HOLE)|OOMFIELD|EDSOE)|O(?:N(?:N(?:IEVILLE|YMAN)|D(?:VILL"
  "E)?)|W(?:(?:LING GRE)?EN)?|ON(?:EVILLE|S CAMP)|STON|AZ)|I(?:G(?: "
  "(?:C(?:LIFTY|REEK)|LAUREL|SPRING|ROCK)|HILL|GS)|MBLE)|Y(?:BEE|PRO"
  "))|M(?:A(?:R(?:SH(?:ES S(?:IDI|D)NG|ALLVILLE)|Y(?: ALICE|DELL)?|I"
  "(?:BA|ON)|T(?:HA|IN)|ROWBONE|CUM)|Y(?:S(?:VILLE|LICK)|FIELD|KING|"
  "TOWN)|N(?:I(?:TOU|LA)|CHESTER|NSVILLE)|MMOTH CAVE(?: NATIONAL PAR"
  "K)?|(?:L(?:LI|ON)|DISONVILL|ZI)E|S(?:ON(?:IC HOME)?|HFORK)|G(?:NO"
  "LIA|GARD)|C(?:KVILLE|EO)|U(?:LDEN|D)|PLE MOUNT|JESTIC|TTHEW)|O(?:"
  "U(?:NT (?:(?:(?:WASHINGT|HERM|VERN)O|EDE)N|S(?:TERLING|HERMAN)|OL"
  "IVET|PISGAH)|THCARD|SIE)|R(?:GAN(?:FIELD|TOWN)|RI(?:S FORK|LL)|NI"
  "NG VIEW|TONS GAP|EHEAD)|O(?:RE(?:S CREEK|FIELD)|LEYVILLE|N)|NT(?:"
  "ICELLO|PELIER)|ZELLE|LUS)|I(?:L(?:L(?:ERS(?:BURG|TOWN)|S(?:TONE)?"
  "| SPRINGS|TOWN|WOOD)|(?:BUR|TO)N|FORD|O)|D(?:DLE(?:SBORO|BURG|TOW"
  "N)|WAY)|(?:STLETO|RACL|Z)E|N(?:ERVA|NIE)|TCHELLSBURG|MA)|C(?: (?:"
  "(?:ANDREW|ROBERT)S|D(?:ANIELS|OWELL)|(?:HENR|QUAD)Y|K(?:INNEY|EE)"
  "|CARR)|COMBS|VEIGH)|E(?:L(?:B(?:OURNE|ER)|VIN)|A(?:DOW CREEK|LLY|"
  "NS)|ETING CREEK|NTOR|TA)|U(?:NFORDVILLE|SES MILLS|LDRAUGH|RRAY)|T"
  " (?:WASHINGTON|STERLING)|YRA)|W(?:E(?:ST(?: (?:L(?:OUISVILLE|IBER"
  "TY)|P(?:ADUCAH|OINT)|SOMERSET|VAN LEAR|IRVINE)|(?:BEN|WOO)D|PORT|"
  "VIEW)|B(?:B(?:S CR(?:OSS ROA|S R)DS|VILLE)|STER)|L(?:CHS CREEK|LI"
  "NGTON)|EKSBURY|NDOVER)|A(?:L(?:L(?:IN(?:S CREEK|GFORD)|SEND)|KER("
  "?:TOWN)?|NUT GROVE|TON|DO)|R(?:BRANCH|FIELD|SAW)|TER(?: VALLEY|VI"
  "EW)|Y(?:NESBURG|LAND)|(?:VERL|DD)Y|SHINGTON|NETA|CO|X)|I(?:L(?:L("
  "?:I(?:AMS(?:BURG|PORT|TOWN)|SBURG)|OW SHADE|ARD)|(?:SONVILL|MOR)E"
  "|D(?:CAT|ER|IE))|N(?:D(?: CAVE|SOR|Y)|CHESTER|STON|GO)|(?:TTENSVI"
  "LL|CKLIFF)E|DECREEK)|H(?:I(?:T(?:E(?: (?:(?:PLAIN|MILL)S|CITY|OAK"
  ")|S(?:VILLE|BURG)|HOUSE)|LEY CITY)|CK)|E(?:AT(?:CROFT|LEY)|ELWRIG"
  "HT))|O(?:O(?:D(?:B(?:UR[NY]|INE)|MAN|S)|LLUM|TON)|L(?:F(?: COAL)?"
  "|VERINE)|RTH(?:INGTON|VILLE)|NNIE)| LOUISVILLE|URTLAND|RIGLEY)|P("
  "?:E(?:N(?:DLET(?:ON(?: COUNTY)?|N CNTY)|ROD)|(?:WEE VALLE|ABOD)Y|"
  "RRY(?: PARK|VILLE)|(?:LLVILL|MBROK)E|(?:YTON|TER)SBURG|O(?:PLES|N"
  "IA)|BWORTH)|A(?:R(?:K(?:(?:ERS LAK|SVILL)E| (?:HILLS|CITY))?|TRID"
  "GE|NELL|ROT|IS)|INT(?:SVILLE| LICK)|YNE(?:VILLE| GAP)|T(?:HFORK|S"
  "EY)|DUCAH|W PAW)|I(?:N(?:E(?: (?:MOUNTAIN|RIDGE|KNOT|TOP)|VILLE)|"
  "SONFORK)|PPA PASSES|KEVILLE|TTSBURG|LGRIM|SO)|R(?:I(?:N(?:CETON|T"
  "ER)|(?:MROS|C)E)|E(?:STON(?:SBURG)?|MIUM)|O(?:V(?:IDENCE|O)|SPECT"
  ")|YSE)|L(?:EASURE(?: R(?:IDGE PARK|DGE)|VILLE)|UM(?:MERS L(?:ANDI"
  "N|ND)G| SPRINGS)|ANK)|O(?:W(?:ERSBURG|DERLY)|(?:PLARVIL|O)LE|MERO"
  "YTON|RT ROYAL|INTER)|U(?:LASKI|BLIC|EBLO|TNEY)|H(?:(?:YLLI|ELP)S|"
  "ILPOT))|H(?:A(?:R(?:D(?:IN(?:SBURG)?|Y(?:VILLE)?|BURLY|SHELL)|ROD"
  "S(?: CREEK|BURG)|(?:TFOR|NE|OL)D|LAN|PER)|L(?:L(?:IE)?|DEMAN|FWAY"
  "|O)|Z(?:EL(?: GREEN)?|ARD)|(?:M(?:PTO|LI)|NSO)N|T(?:FIELD|TON)|D("
  "?:DIX|LEY)|GER(?:HILL)?|WESVILLE|PPY)|I(?:GH(?:LAND H(?:EIGH|G)TS"
  "|GROVE|WAY)|LL(?:SBORO|VIEW)|CK(?:MAN|ORY)|N(?:DMAN|KLE)|S(?:EVIL"
  ")?LE|T(?:CHINS|E)|M(?:YAR|A)| HAT|PPO|RAM)|O(?:(?:P(?:KINSVILL)?|"
  "D(?:GENVILL)?)E|L(?:L(?:YBUSH|AND)|MES MILL)|(?:WARDSTOW|SKINSTO)"
  "N|RSE (?:BRANCH|CAVE)|N(?:EYBEE|AKER))|E(?:N(?:D(?:ERSON|RICKS)|S"
  "HAW)|L(?:ECHAWA|LIER|TON)|ID(?:ELBERG|RICK)|AD OF GRASSY?|R(?:NDO"
  "N|D)|STAND|BRON)|U(?:(?:STON|EYS)VILLE|NT(?:SVILLE|ER)|D(?:SON|DY"
  ")|LEN|FF)|YDEN)|L(?:O(?:G(?: MOUNTAIN|ANSPORT|VILLE)|C(?:UST(?: H"
  "ILL)?|KPORT)|U(?:IS(?:VILLE|A)|ELLEN)|VEL(?:ACEVILLE|Y)|W(?:MANSV"
  "ILLE|ES)|N(?:DON|E)|ST CREEK|DIBURG|OKOUT|RETTO|YALL|AD|LA)|A(?: "
  "(?:(?:FAYETT|GRANG)E|CENTER)|W(?:RENCEBURG|TON)|(?:RKSLAN|GRANG)E"
  "|N(?:CASTER|GLEY)|TONIA(?: LAKES)?|UR(?:EL FORK|A)|KESIDE PARK|MB"
  "(?:RIC)?|CKEY)|E(?:B(?:ANON(?: J(?:UNCTIO|CT)N)?|URN)|(?:(?:DBETT"
  "|TCH)E|JUNIO)R|A(?:THERWOOD|NDER)|WIS(?:BURG|PORT)|E(?: CITY|CO)|"
  "NO(?:RE|X)|ITCHFIELD|XINGTON)|I(?:TT(?:LE(?: SANDY)?|CARR)|N(?:DS"
  "EYVILLE|EFORK)|V(?:INGSTON|ERMORE)|CK(?: CREEK|BURG)|(?:BERT|L)Y|"
  "GON)|Y(?:N(?:NVILLE|DON|CH)|TTEN)|U(?:DLOW|CAS)|LOYD)|F(?:O(?:R(?"
  ":T (?:(?:CAMPB|MITCH)ELL|THOMAS|KNOX)|D(?:S(?: BRANCH|VILLE))?|ES"
  "T HILLS|AKER)|U(?:NTAIN RUN|RMILE)|(?:GER|X)TOWN|STER|NDE)|A(?:L("
  "?:L(?:S(?:(?: OF)? ROUGH|BURG)| ROCK)|MOUTH|CON)|IR(?:FIELD|DALE|"
  "PLAY|VIEW)|R(?:M(?:INGTON|ERS)|LER)|NCY FARM|UBUSH)|R(?:E(?:D(?:V"
  "ILLE|ONIA)|NCHBURG|EBURN|W)|A(?:NK(?:LI(?:NTO)?N|FORT)|KES|ZER)|I"
  "(?:SBY|TZ)|OZEN CREEK)|L(?:A(?:T(?: (?:FOR|LIC)K|WOODS|GAP)?|HERT"
  "Y)|EMING(?: NEON|SBURG)?|ORENCE)|I(?:S(?:H(?:ERVILLE|TRAP)|TY)|N("
  "?:CHVILLE|LEY)|REBRICK|LLMORE|ELD)|E(?:R(?:N CREEK|GUSON)|DSCREEK"
  ")|T (?:MITCHELL|WRIGHT)|U(?:LT(?:ON|Z)|GET))|R(?:O(?:C(?:K(?:Y(?:"
  "BRANCH| HILL)|HO(?:LDS|USE)| CREEK|FIELD|PORT)|HESTER)|B(?:INSON "
  "CR(?:EE)?K|ARDS)|U(?:S(?:SEAU|E)|NDHILL)|W(?:LETTS|ENA|DY)|S(?:SL"
  "YN|INE)|YALTON|GERS|XANA|ARK)|E(?:D(?:BU(?:SH|D)| BIRD|FOX)|YNOLD"
  "S STA(?:TION)?|NFRO VALLEY|GINA|LIEF|VELO|ED)|A(?:C(?:ELAND|COON)"
  "|Y(?:MOND|WICK)|VEN(?:NA)?|BBIT HASH|DCLIFF|NSOM)|I(?:C(?:H(?:ARD"
  "S(?:VILLE|ON)|MOND)|ETOWN)|(?:[ST]N|V)ER|NEYVILLE)|U(?:S(?:SELL(?"
  ": SP(?:RIN)?GS|VILLE)?|H)|MSEY|TH)|YLAND H(?:G(?:HT|TS)|EIGHTS)|R"
  " DONNELLY|HODELIA)|G(?:R(?:A(?:Y(?:S(?: KNOB|ON)| HAWK)?|VEL SWIT"
  "CH|H(?:AM|N)|ND RIVERS|SSY CREEK|DYVILLE|CEY?|TZ)|E(?:EN(?: (?:HA"
  "LL|ROAD)|SBURG|VILLE|WOOD|UP)|GORY|THEL)|OLIER BOOKS)|A(?:R(?:R(?"
  ":ISON|ARD|ETT)|FIELD|NER)|(?:PVIL|USDA)LE|YS CREEK|LVESTON|MALIEL"
  ")|U(?:L(?:NARE|STON)|(?:THRI|AG)E|ERRANT|NLOCK|STON)|L(?:EN(?:(?:"
  "DAL|CO)E|S FORK| DEAN|VIEW)|ASGOW)|I(?:L(?:L(?:MORE|Y)|BERTSVILLE"
  ")|FFORD|RDLER)|O(?:O(?:SE ROCK|DY)|(?:RDO|SHE)N|LDEN POND)|E(?:OR"
  "GE|RMAN)TOWN|HENT|YPSY)|E(?:L(?:K(?:(?: HOR|TO)N|HORN CITY|ATAWA|"
  "FORK)|I(?:ZA(?:BETHTOWN|VILLE)|AS|HU)|(?:S(?:MER|I)|LIOTTVILL)E|A"
  "MTON|MROCK|NA|YS)|A(?:ST(?: (?:P(?:INEVILLE|OINT)|BERNSTADT|MC DO"
  "WELL)|VIEW|WOOD|ERN)|RLINGTON)|M(?:ERSON(?: ORCUTTS GROCERY)?|M(?"
  ":ALEN)?A|INENCE|LYN)| (?:BERNSTADT|MC DOWELL|PINEVILLE|TOWN)|D(?:"
  "DYVILLE|GEWOOD|MONTON|NA)|R(?:(?:IL|M)INE|LANGER)|(?:IGHTY EIGH|N"
  "DICOT)T|S(?:TILL|SIE)|T(?:OILE|TY)|V(?:ARTS|ER)|BERLE|UBANK|KRON|"
  "OLIA|WING|ZEL)|D(?:E(?:(?:A(?:TSVILL|N)| MOSSVILL|FO)E|M(?:O(?:SS"
  "VILLE|CRAT)|A)|N(?:(?:NIS)?TON|VER)|L(?:PHI|T)A|BORD|WITT|XTER|CO"
  "Y)|A(?:V(?:I(?:S(?:BURG|PORT)|D)|ELLA)|WSON SP(?:RIN)?GS|Y(?:HOIT"
  "|TON)|N(?:VILLE|A)|BOLT|ISY)|R(?:Y(?: (?:CREEK|RIDGE)|HILL)|A(?:K"
  "E(?:SBORO)?|FFIN)|EYFUS|IFT)|U(?:N(?:(?:NVILL|DE)E|(?:BA|MO)R)|BR"
  "E|CO)|O(?:RTON(?: BRANCH)?|NGOLA|VER)|I(?:SPUTANTA|NGUS|ZNEY|XON|"
  "CE)|WA(?:LE|RF)|YCUSBURG)|T(?:H(?:O(?:USANDSTICKS|RNTON)|REE(?: P"
  "OINT|FORKS)|E(?:ALK|LM)A|SANDSTICKS)|O(?:M(?:PKINSVILLE|AHAWK)|L("
  "?:LESBORO|ER|U)|URISTVILLE|PMOST|TZ)|A(?:YLOR(?:SVILLE| MILL)|L(?"
  ":BERT|LEGA|CUM)|TEVILLE|NKSLEY)|U(?:R(?:NERS STA(?:TION)?|KEY(?: "
  "CREEK)?)|T(?:OR KEY|TLE))|R(?:I(?:(?:BBE|NIT)Y|MBLE)|A(?:PPIST|M)"
  "|ENTON|OSPER)|I(?:N(?:Y TOWN|SLEY|A)|LINE)|E(?:ABERRY|DDERS)|Y(?:"
  "NER|PO)| VILLE)|A(?:L(?:L(?:E(?:N(?:SVILLE)?|GRE)|OCK)|(?:EXANDRI"
  "|PH)A|VA(?:TON)?|(?:TR|M)O|CALDE|BANY)|R(?:G(?:ILLITE|O)|(?:JA)?Y"
  "|LINGTON|TEMUS)|U(?:(?:BUR|STI)N|GUSTA|XIER)|D(?:A(?:IRVILLE|MS)|"
  "OLPHUS)|N(?:C(?:HORAGE|O)|NVILLE)|(?:BERDEE|ARO|COR)N|SH(?:CAMP|L"
  "AND|ER)|GES BROOKSI?DE|MBURGEY|VAWAM|FLEX|THOL)|N(?:E(?:W(?: (?:C"
  "(?:ONCORD|ASTLE)|H(?:AVEN|OPE)|LIBERTY|ZION)|FOUNDLAND|PORT)|(?:V"
  "ISDAL|LS)E|AFUS|RINX|BO|ON|D)|A(?:P(?:OLEON|FOR)|ZARETH|RROWS|NCY"
  "|OMI)|O(?:RT(?:H MIDDLETOWN|ONVILLE)|CTOR)|I(?:CHOLASVILLE|PPA)| "
  "MIDDLETOWN|UMBER ONE)|O(?:L(?:D(?: LANDING|TOWN)|IVE HILL|MSTEAD|"
  "YMPIA|ATON|LIE)|W(?:EN(?:SBORO|TON)?|INGSVILLE)|R(?:(?:CUTTS GROC"
  "|KNE)Y|LANDO)|AK(?:(?: GROV|VILL)E|LAND)|(?:SCALOOS|KOLON|NEID)A|"
  "IL (?:SPRINGS|VALLEY)|VEN FORK|FFUTT|PHIR|GLE)|K(?:E(?:TTLE(?: IS"
  "LAND)?|N(?:TON|VIR)|A(?:TON|VY)|RBY KNOB|ENE|ITH|VIL)|I(?:NGS M(?"
  ":OUNTAI|T)N|RKSEY|MPER|TE)|N(?:O(?:TTSVILLE|B LICK)|IFLEY)|A(?:LI"
  "OPI|YJAY)|(?:UTTAW|ON)A|RYPTON|YROCK)|J(?:E(?:FF(?:ERSON(?:VI?LLE"
  "|TOWN))?|N(?:KINS|SON)|REMIAH|TSON)|O(?:N(?:ESVILLE|ANCY|ICAN)|HN"
  "(?:S RUN|ETTA)|B)|A(?:M(?:ESTOWN|BOREE)|CK(?:HOR|SO)N|RVIS|BEZ)|U"
  "NCTION CITY|INKS)|V(?:A(?:N(?:C(?:EBURG|LEVE)| LEAR|ZANT)?|L(?:LE"
  "Y STAT(?:IO)?N|ERIA)|RNEY|DA)|I(?:N(?:E GROVE|CENT)|C(?:TORY|CO)|"
  "LLA HILLS|RGIE|PER)|E(?:R(?:(?:SAILL|TRE)ES|ONA)|ST)|OLGA)|I(?:N("
  "?:DE(?:PENDENCE|X)|G(?:RAM|LE)|SKO|EZ)|S(?:LAND(?: CITY)?|O(?:NVI"
  "LLE|M))|V(?:Y(?: GROVE|TON)|EL)|RVIN(?:GTON|E)|UKA)|U(?:NION(?: S"
  "TAR|TOWN)?|P(?:PER TYGART|TON)|L(?:YSSES|VAH)|RBAN|TICA)|Y(?:E(?:"
  "(?:ADDIS|RKE)S|LLOW ROCK)|O(?:CUM(?: CREEK)?|SEMITE))|QU(?:I(?:CK"
  "SAND|NCY)|ALITY)|Z(?:ACHARIAH|OE)))))$"
  ,
  /* -- LA -- LA -- LA -- LA -- LA -- LA -- LA -- LA -- LA -- LA -- */
  "(?:\\b)((?^:(?i:(?:C(?:H(?:A(?:T(?:AIGNIER|HAM)|(?:RENTO|UVI)N|(?"
  ":LMETT|S)E)|E(?:NEYVILLE|STNUT)|O(?:UDRANT|PIN)|URCH POINT)|A(?:M"
  "(?:P(?: BEAUREGARD|TI)|ERON)|R(?:(?:LIS|VIL)LE|ENCRO)|(?:L(?:HOU|"
  "VI)|NKTO)N|S(?:PIANA|TOR)|DE)|O(?:L(?:LINSTON|UMBIA|FAX)|TTON(?: "
  "VALLEY|PORT)|NVE(?:RSE|NT)|W ISLAND|USHATTA|VINGTON)|L(?:A(?:R(?:"
  "ENCE|KS)|YTON)|OUTIERVILLE|I[FN]TON)|E(?:NT(?:ER(?: POINT|VILLE)|"
  "RAL)|CILIA)|R(?:OW(?:VILLE|LEY)|E(?:STON|OLE))|YPRE(?:MORT P(?:OI"
  "N)?T|SS)|U(?:T OFF|LLEN)|P BEAUREGARD)|S(?:A(?:INT (?:(?:MA(?:RTI"
  "NVILL|URIC)|FRANCISVILL|ROS)E|BE(?:NEDICT|RNARD)|J(?:OSEPH|AMES)|"
  "GABRIEL|LANDRY|AMANT)|REPTA|LINE)|T(?: (?:(?:FRANCISV|MARTINVL)LE"
  "|BENEDICT)|AR(?:KS|T)|ERLINGTON|ONEWALL)|I(?:M(?:MESPORT|SBORO|PS"
  "ON)|(?:EP|NG)ER|CILY ISLAND|BLEY|KES)|U(?:N(?:S(?:HINE|ET))?|MMER"
  "FIELD|GARTOWN|LPHUR)|P(?:E(?:ARSVILLE|NCER)|RING(?:FIELD|HILL))|C"
  "(?:OT(?:LANDVILLE|T)|HRIEVER)|H(?:REVEPORT|ONGALOO|ERIDAN)|O(?:ND"
  "HEIMER|RRENTO|UTHERN)|L(?:A(?:UGHTER|GLE)|IDELL)|WARTZ)|B(?:A(?:R"
  "(?:KSDALE AFB|ATARIA)|T(?:ON ROUGE|CHELOR)|S(?:TROP|ILE|KIN)|L(?:"
  "DWIN|L)|YOU GOULA|INS|KER)|E(?:L(?:L(?:E (?:CHAS|RO)SE| CITY)|CHE"
  "R|MONT)|R(?:NICE|WICK)|NT(?:LEY|ON)|THANY)|R(?:(?:I(?:DGE CIT|TTA"
  "N)|USL)Y|(?:OUSSAR|YCELAN)D|A(?:ITHWAITE|NCH)|EAUX BRIDGE)|O(?:(?"
  ":(?:RDELON|OTH)VILL|YC)E|(?:GALUS|NIT)A|U(?:TTE|RG)|SSIER CITY)|U"
  "(?:(?:TTE LAROS|CKEY|ECH|NKI)E|R(?:NSIDE|AS)|SH)|LAN(?:CHARD|KS)|"
  "IENVILLE)|M(?:O(?:N(?:T(?:E(?:GUT|REY)|GOMERY|PELIER|Z)|ROE)|R(?:"
  "GAN(?: CITY|ZA)|(?:EAUVILL|S)E|ROW|A)|UN(?:T (?:HERMON|AIRY)|D)|O"
  "RINGSPORT|SS BLUFF|DESTE)|A(?:R(?:(?:THA|KS)VILLE|I(?:NGOUI|O)N|R"
  "ERO)|N(?:S(?:FIELD|URA)|DEVILLE|GHAM|Y)|UR(?:EPAS|ICE)|DISONVILLE"
  "|THEWS|MOU)|E(?:R(?:(?:RYVILL| ROUG)E|MENTAU|AUX)|L(?:(?:VILL|ROS"
  ")E|DER)|TAIRIE|AUX)|I(?:T(?:CHELL|TIE)|(?:LTO|NDE)N|DLAND|RA))|L("
  "?:A(?:KE(?: (?:PROVIDENCE|CHARLES|ARTHUR)|LAND)|(?:BA(?:DIEVILL|R"
  "R)|F(?:AYE|I)TT| PLAC)E|C(?:A(?:SSINE|MP)|OMBE)|R(?:OSE|TO)|WTELL"
  ")|O(?:NG(?:STREET|VILLE|LEAF)|R(?:EAUVILLE|ANGER)|(?:GANS|CK)PORT"
  "|TTIE)|E(?:(?:(?:ES|ON)VILL|COMPT)E|B(?:LANC|EAU)|TTSWORTH| MOYEN"
  "|ANDER|NA)|I(?:(?:NVILL|BUS|LLI)E|V(?:INGSTON|ONIA)|SBON)|U(?:TCH"
  "ER|LING)|K PROVIDENCE|YDIA)|P(?:O(?:RT (?:SULPHUR|VINCENT|ALLEN|B"
  "ARRE)|INT(?:E A LA HACHE| CLAIR)|NCHATOULA|WHATAN|LLOCK)|I(?:NE(?"
  ": (?:PRAIRI|GROV)|VILL)E|(?:LOTTOW|TKI)N|ERRE PART|ONEER)|L(?:A(?"
  ":(?:(?:TTEN|UCHE)VILL|QUEMIN)E|IN DEALING)|EASANT HILL)|A(?:INCOU"
  "RTVI?LLE|R(?:ADI|K)S|TTERSON|LMETTO|ULINA)|R(?:I(?:NCETON|DE)|AIR"
  "IEVILLE|OVENCAL)|E(?:ARL RIVER|LICAN|RRY)|T A LA HACHE)|G(?:R(?:A"
  "(?:N(?:D (?:C(?:HENIER|OTEAU|ANE)|ISLE)|T)|M(?:BLING|ERCY)|Y(?:SO"
  "N)?)|E(?:EN(?:W(?:EL(?:L SPRIN| SP)GS|OOD)|SBURG)|TNA)|OSSE TETE)"
  "|A(?:R(?:D(?:EN CITY|NER)|YVILLE)|L(?:LIANO|VEZ))|O(?:LD(?:EN MEA"
  "DOW|ONNA)|NZALES|UDEAU|RUM)|I(?:L(?:BERT|LIAM)|BS(?:LAND|ON)|RARD"
  ")|L(?:ENMORA|OSTER|YNN)|E(?:ORGETOWN|ISMAR)|UEYDAN|HEENS)|D(?:E(?"
  ":N(?:HAM SP(?:RIN)?G|NIS MILL)S|S(?: ALLEMANDS|TREHAN)|L(?:CAMBRE"
  "|HI|TA)|R(?:IDDER|RY)|QUINCY|VILLE)|O(?:N(?:ALDSONVI?LLE|NER)|(?:"
  "WNSVILL|YLIN)E|DSON)|U(?:P(?:LESSIS|ONT)|B(?:BERLY|ACH)|LAC|SON)|"
  "RY (?:CREEK|PRONG)|A(?:RROW|VANT)|IXIE)|F(?:O(?:R(?:T (?:NECESSIT"
  "Y|POLK)|EST(?: HILL)?|DOCHE|BING)|LSOM)|R(?:(?:ANKLI(?:NTO)?|IERS"
  "O)N|(?:ENCH)? SETTLEMENT|OGMORE)|L(?:OR(?:IEN|A)|ATWOODS|UKER)|A("
  "?:RMERVILLE|IRBANKS)|E(?:RRIDAY|NTON)|I(?:ELDS|SHER)|T NECESSITY|"
  "ULLERTON)|H(?:A(?:R(?:(?:AHA|MO)N|RISONBURG|DWOOD|VEY)|Y(?:NESVIL"
  "LE|ES)|M(?:BURG|MOND)|LL SUMMIT|CKBERRY|HNVILLE|UGHTON|NNA)|O(?:L"
  "(?:LY RIDGE|DEN)|RNBECK|SSTON|DGE|MER|UMA)|E(?:(?:NDERSO|FLI)N|S("
  "?:SM|T)ER)|I(?:LLSDALE|NESTON|CKS)|USSER)|A(?:R(?:C(?:HIBALD|ADIA"
  ")|NAUDVILLE|ABI)|B(?:ITA SPRINGS|BEVILLE)|N(?:G(?:OLA|IE)|ACOCO)|"
  "V(?:ERY ISLAND|ONDALE)|L(?:EXANDRIA|BANY|TO)|M(?:(?:ELI)?A|ITE)|T"
  "(?:LANTA|HENS)|(?:DDI|KER)S|IMWELL|SHLAND|CME)|R(?:O(?:S(?:E(?:(?"
  ":DAL|PIN)E|LAND)|A)|BE(?:LINE|RT)|ANOKE|DESSA|UGON)|I(?:(?:CHWOO|"
  "NGGOL)D|VER RIDGE|DGECREST)|A(?:Y(?:VILL|N)E|CELAND|GLEY|MAH)|E(?"
  ":DDELL|SERVE|EVES)|U(?:STON|BY)|HINEHART)|E(?:L(?:M(?: GROVE|WOOD"
  "|ER)|IZABETH|TON)|(?:NTERPRIS|MPIR|UNIC|FFI)E|V(?:AN(?:GELINE|S)|"
  "ERGREEN)|R(?:WINVILLE|ATH|OS)|(?:STHERWOO|DGAR)D|(?:XTENSIO|GA)N|"
  "AST POINT|THEL|CHO|OLA|PPS)|W(?:A(?:(?:SHINGTO|RDE)N|T(?:ERPROOF|"
  "SON)|KEFIELD|VERLY|LKER)|I(?:NN(?:FIELD|SBORO)|L(?:DSVILLE|SON)|S"
  "NER)|E(?:ST(?:(?: MONRO|LAK)E|WEGO)|YANOKE|LSH)|HITE(?: CASTLE|HA"
  "LL)|OODWORTH)|T(?:A(?:L(?:ISHEEK|LULAH)|NGIPAHOA|YLOR)|H(?:E(?: B"
  "LUFFS|RIOT)|IBODAUX)|U(?:RKEY CREEK|LLOS|NICA)|R(?:ANSYLVANIA|EES"
  "|OUT)|E(?:RRY(?:TOWN)?|MPLE)|I(?:CKFAW|OGA)|ORBERT)|N(?:E(?:W(?: "
  "(?:(?:ORLEAN|ROAD)S|IBERIA|SARPY|ZION)|ELLTON|LLANO)|GREET)|A(?:T"
  "(?:CH(?:ITOCHES|EZ)|ALBANY)|POLEONVILLE)|O(?:R(?:WOOD|CO)|BLE))|K"
  "(?:E(?:(?:ITHVILL|ATCHI)E|N(?:TWOOD|NER)|LLY)|I(?:L(?:BOURNE|LONA"
  ")|NDER)|R(?:OTZ SPRINGS|AEMER)|(?:APLA|OLI)N|URTHWOOD)|J(?:E(?:N("
  "?:NINGS|A)|ANERETTE|FFERSON)|A(?:(?:MESTOW|CKSO)N|RREAU)|O(?:NES("
  "?:VILLE|BORO)?|YCE)|IGGER)|V(?:I(?:(?:NTO|VIA)N|LLE PLATTE|DALIA|"
  "OLET|CK)|E(?:N(?:TRESS|ICE)|RDA)|A(?:CHERIE|RNADO))|O(?:AK(?: (?:"
  "GROV|RIDG)|DAL)E|(?:PELOUSA|TI)S|IL CITY|BERLIN|SCAR|LLA)|I(?:N(?"
  ":DEPENDENCE|NIS)|(?:O[TW]|D)A|BERVILLE)|U(?:NCLE SAM|RANIA)|Z(?:A"
  "CHARY|WOLLE)|YOUNGSVILLE|QUITMAN))))$"
  ,
  /* -- MA -- MA -- MA -- MA -- MA -- MA -- MA -- MA -- MA -- MA -- */
  "(?:\\b)((?^:(?i:(?:W(?:E(?:ST(?: (?:B(?:R(?:IDGEWATER|OOKFIELD)|O"
  "(?:YLSTON|XFORD)|ARNSTABLE)|S(?:(?:TOCKBRIDG|OMERVILL)E|PRINGFIEL"
  "D)|H(?:A(?:TFIELD|RWICH)|YANNISPORT)|W(?:AR(?:EHAM|REN)|HATELY)|C"
  "H(?:ESTERFIELD|ATHAM|OP)|M(?:ILLBURY|EDFORD)|T(?:OWNSEND|ISBURY)|"
  "(?:FAL|YAR)MOUTH|NEW(?:BURY|TON)|(?:GROTO|LYN)N|(?:DENN|OT)IS|ROX"
  "BURY)|(?:F(?:IEL|OR)|WOO)D|PORT(?: P(?:OIN)?T)?|O(?:VER AFB|N)|BO"
  "ROUGH|HAMPTON|MINSTER)|LL(?:ESLEY(?: H(?:IL)?LS)?|FLEET)|N(?:DELL"
  "(?: DEPOT)?|HAM)|YMOUTH|BSTER)| (?:S(?:(?:TOCKBRIDG|OMERVILL)E|PR"
  "INGFIELD)|B(?:R(?:IDGEWATER|OOKFIELD)|ARNSTBLE)|(?:CHESTERFL|TOWN"
  "SEN)D|H(?:YANNISPRT|ATFIELD)|(?:FAL|YAR)MOUTH)|I(?:N(?:CH(?:E(?:N"
  "DON(?: SPRINGS)?|STER)|DON SPGS)|T(?:ER HILL|HROP)|DSOR)|L(?:LI(?"
  ":AMS(?:BURG|TOWN)|MANSETT)|KINSONVIL?LE|MINGTON|BRAHAM))|A(?:R(?:"
  "E(?:HAM)?|D HILL|WICK|REN)|(?:SHINGTO|TERTOW|BA)N|L(?:POLE|THAM|E"
  "S)|(?:KEFIEL|YLAN)D|VERLEY|QUOIT)|H(?:IT(?:E HORSE BEACH|INSVILLE"
  "|MAN)|T HORSE BCH|EELWRIGHT|ATELY)|O(?:R(?:THINGTON|CESTER|ONOCO)"
  "|OD(?:S HO|VIL)LE|(?:LLASTO|BUR)N)|RENTHAM)|S(?:O(?:UTH(?: (?:W(?"
  ":E(?:LLFLEET|YMOUTH)|AL(?:POLE|THAM))|D(?:E(?:ERFIELD|NNIS)|ARTMO"
  "UTH)|HA(?:MILTON|RWICH|DLEY)|E(?:GREMONT|ASTON)|C(?:HATHAM|ARVER)"
  "|L(?:ANCASTER|EE)|B(?:OSTON|ARRE)|ATTLEBORO|YARMOUTH|GRAFTON|ORLE"
  "ANS)|B(?:OROUGH|RIDGE)|AMPTON|FIELD|WICK)|MER(?:VILLE|SET))| (?:D"
  "(?:ARTMOUTH|EERFIELD)|WE(?:LLFLEET|YMOUTH)|(?:ROYALS|HAMIL)TON|CH"
  "ELMSFORD|ATTLEBORO|LANCASTER|EGREMONT|YARMOUTH)|H(?:E(?:L(?:BURNE"
  " F(?:AL)?LS|DONVILLE)|FFIELD|RBORN)|IRLEY(?: C(?:ENTE|T)R)?|A(?:T"
  "TUCKVILLE|RON)|(?:REW|UTE)SBURY)|A(?:L(?:ISBURY(?: B(?:EA)?CH)?|E"
  "M)|GAMORE(?: B(?:EA)?CH)?|ND(?:ISFIELD|WICH)|UGUS|VOY)|T(?:O(?:NE"
  "H(?:ILL COL(?:LEGE)?|AM)|CKBRIDGE|UGHTON|W)|ILL RIVER|URBRIDGE|ER"
  "LING)|I(?:LVER BEACH|MONS ROCK|ASCONSET)|P(?:(?:RINGFIE|F)LD|ENCE"
  "R)|U(?:NDERLAND|DBURY|TTON)|WA(?:MPSCOTT|NSEA)|CITUATE|QUANTUM|EE"
  "KONK)|N(?:O(?:R(?:T(?:H(?: (?:C(?:H(?:ELMSFORD|ATHAM)|A(?:MBRIDGE"
  "|RVER))|A(?:TTLEBORO|MHERST|NDOVER|DAMS)|(?:(?:MARSH|HAT)FIEL|OXF"
  "OR)D|(?:PEMBROK|SCITUAT|UXBRIDG)E|E(?:AST(?:HAM|ON)|GREMONT)|B(?:"
  "ROOKFIELD|ILLERICA)|D(?:ARTMOUTH|IGHTON)|W(?:EYMOUTH|ALTHAM)|FALM"
  "OUTH|GRAFTON|READING|QUINCY|TRURO)|FIELD(?: M(?:OUN)?T HERMON)?|B"
  "(?:OROUGH|RIDGE)|AMPTON)|ON)|W(?:ELL|OOD)|FOLK)|N(?:ANTUM|QUITT))"
  "|E(?:W(?:TON(?: (?:L(?:OWER FALLS| F)|U(?:PPER FALLS| F)|H(?:IGHL"
  "AN|L)DS|CENT(?:ER|RE))|VILLE)?| (?:MARLBORO(?:U(?:GH)?)?|B(?:RAIN"
  "TREE|EDFORD)|ASHFORD|SALEM|TOWN)|BURY(?:PORT)?)|EDHAM(?: H(?:EIGH"
  "|G)TS)?)| (?:(?:PEMBROK|SCITUAT|UXBRIDG)E|B(?:ROOKFIELD|ILLERICA)"
  "|C(?:HELMSFORD|AMBRIDGE)|D(?:ARTMOUTH|IGHTON)|(?:MARSH|HAT)FIELD|"
  "(?:FAL|WEY)MOUTH|ATTLEBORO|EGREMONT)|A(?:(?:NTUCKE|HAN)T|TICK)|UT"
  "TING LAKE)|M(?:A(?:R(?:S(?:HF(?:IELD(?: HILLS)?|LD HLS)|TONS M(?:"
  "IL)?LS)|LBOROUGH|BLEHEAD|ION)|N(?:CH(?:ESTER(?: BY THE SEA)?|AUG)"
  "|SFIELD|OMET)|TTAP(?:OISETT|AN)|SHPEE|YNARD|LDEN)|I(?:L(?:L(?:(?:"
  "ERS FALL|I)S| RIVER|VILLE|BURY)|TON(?: V(?:ILLAGE|LG))?|FORD)|DDL"
  "E(?:BORO(?:UGH)?|FIELD|TON)|SSION HILL|NOT)|O(?:N(?:T(?:(?:GOMER|"
  "ERE)Y|AGUE)|UMENT B(?:EA)?CH|RO(?:E BRIDG)?E|PONSETT|SON)|UNT (?:"
  "(?:WASHINGT|HERM)ON|TOM))|E(?:D(?:F(?:IEL|OR)D|WAY)|N(?:EMSHA|DON"
  ")|RRIMAC|LROSE|THUEN)|T (?:WASHINGT|HERM)ON)|E(?:A(?:ST(?: (?:W(?"
  ":A(?:TERTOWN|LPOLE|REHAM)|EYMOUTH)|(?:T(?:EMPLE|AUN)|ARLING|PRINC"
  "E)TON|(?:D(?:OUGLA|ENNI)|O(?:RLEAN|TI))S|B(?:R(?:IDGEWATER|OOKFIE"
  "LD)|OSTON)|F(?:ALMOUTH|REETOWN)|L(?:ONGMEADOW|YNN)|(?:SAND|HAR)WI"
  "CH|CAMBRIDGE|MANSFIELD)|HAM(?:PTON)?|ON)| FALMOUTH)| (?:(?:(?:PRI"
  "NC|TEMPL)E|ARLING)TON|BR(?:IDGEW(?:ATE|T)R|OOKFIELD)|(?:FALMOUT|S"
  "ANDWIC)H|WA(?:TERTOWN|REHAM)|HA(?:MPTON|RWICH)|LONGMEADOW|CAMBRID"
  "GE|MANSFIELD)|(?:GREMON|VERET)T|DGARTOWN|LMWOOD|RVING|SSEX)|B(?:R"
  "(?:O(?:OK(?:LINE(?: V(?:ILLAGE|LG))?|FIELD)|CKTON)|I(?:DGEWATER|M"
  "FIELD|GHTON)|A(?:NT ROCK|INTREE|DFORD)|YANTVILLE|EWSTER)|E(?:R(?:"
  "(?:NARDSTO|LI)N|K(?:SHIRE|LEY))|L(?:CHERTOWN|LINGHAM|MONT)|DFORD|"
  "VERLY|CKET)|O(?:STON(?: C(?:OLLEGE|LG))?|X(?:BORO(?:UGH)?|FORD)|("
  "?:NDSVILL|URN)E|(?:YLS|L)TON)|A(?:(?:R(?:NSTABL|R)|LDWINVILL)E|Y "
  "STATE V(?:ILLAGE|LG)|BSON PARK|SS RIVER)|U(?:ZZARDS BAY|RLINGTON|"
  "CKLAND)|LA(?:CKSTONE|NDFORD)|ILLERICA|YFIELD)|H(?:A(?:R(?:VARD(?:"
  " SQ(?:UARE)?)?|WICH(?: PORT)?|DWICK)|N(?:S(?:COM AFB|ON)|COCK|OVE"
  "R)|T(?:(?:CHVILL|HORN)E|FIELD)|M(?:ILTO|PDE)N|YDENVILLE|VERHILL|["
  "DW]LEY|LIFAX)|O(?:L(?:L(?:ISTON|AND)|BROOK|YOKE|DEN)|P(?:KINTON|E"
  "DALE)|USATONIC)|U(?:(?:(?:BBARDS|NTING)T|DS)ON|MAROCK|LL)|Y(?:ANN"
  "IS(?: PORT)?|DE PARK)|IN(?:SDALE|GHAM)|EATH)|C(?:H(?:A(?:R(?:L(?:"
  "TON(?: (?:D(?:EPO?|P)T|CITY))?|E(?:STOWN|MONT))|TLEY)|THAM)|E(?:S"
  "(?:T(?:ER(?:FIELD)?|NUT HILL)|HIRE)|L(?:MSFORD|SEA)|RRY VALLEY)|I"
  "(?:COPEE|LMARK))|A(?:R(?:LISLE|VER)|MBRIDGE|TAUMET|NTON)|O(?:(?:H"
  "ASSE|TUI)T|N(?:CORD|WAY)|LRAIN)|U(?:MM(?:INGTON|AQUID)|TTYHUNK|SH"
  "MAN)|L(?:ARKSBURG|INTON)|ENTERVILLE)|A(?:S(?:H(?:L(?:EY FALLS|AND"
  ")|B(?:URNHAM|Y)|FIELD)|SONET)|T(?:TLEBORO(?: F(?:AL)?LS)?|HOL)|RL"
  "INGTON(?: (?:HEIG)?HTS)?|C(?:USHNET|CORD|TON)|M(?:ESBURY|HERST)|L"
  "(?:LSTON|FORD)|UBURN(?:DALE)?|(?:BINGT|V)ON|(?:NDOV|Y)ER|QUINNAH|"
  "GAWAM|DAMS)|L(?:E(?:(?:OMIN|ICE)STER|(?:XINGTO|YDE)N|NOX(?: DALE)"
  "?|E(?:DS)?|VERETT)|A(?:KE(?: PLEASANT|VILLE)|N(?:CASTER|ESBORO)|W"
  "RENCE)|I(?:N(?:COLN|WOOD)|TTLETON)|O(?:NGMEADOW|WELL)|U(?:NENBURG"
  "|DLOW)|YNN(?:FIELD)?)|R(?:O(?:C(?:H(?:ESTER|DALE)|K(?:LAND|PORT))"
  "|XBURY(?: (?:CROSS|X)ING)?|W(?:LEY|E)|SLINDALE|YALSTON)|A(?:YNHAM"
  "(?: C(?:ENTE|T)R)?|NDOLPH)|E(?:AD(?:VILLE|ING)|HOBOTH|VERE)|U(?:S"
  "SELL|TLAND)|ICHMOND)|G(?:R(?:E(?:EN(?: HARBOR|FIELD|BUSH)|AT BARR"
  "INGTON)|O(?:VE(?: HALL|LAND)|TON)|A(?:N(?:VILLE|BY)|FTON))|(?:T B"
  "ARRINGTO|EORGETOW|OSHE)N|L(?:OUCESTER|ENDALE)|A(?:Y HEAD|RDNER)|I"
  "L(?:BERTVILLE|L))|P(?:R(?:I(?:DES CR(?:OSSI|SS)NG|NCETON)|OVINCET"
  "OWN)|E(?:(?:TERS|L)HAM|PPERELL|MBROKE|ABODY|RU)|L(?:AIN(?:FIELD|V"
  "ILLE)|YM(?:OUTH|PTON))|I(?:TTSFIELD|NEHURST)|A(?:LMER|XTON)|HILLI"
  "PSTON|OCASSET)|D(?:O(?:(?:RCHEST(?:(?:ER CENT)?E|R CT)|VE)R|UGLAS"
  ")|E(?:NNIS(?: ?PORT)?|ERFIELD|DHAM|VENS)|U(?:DLEY(?: HILL)?|NSTAB"
  "LE|XBURY)|A(?:RTMOUTH|NVERS|LTON)|R(?:ACUT|URY)|IGHTON)|T(?:U(?:F"
  "TS UNIV(?:ERSITY)?|RNERS FALLS)|E(?:ATICKET|MPLETON|WKSBURY)|O(?:"
  "(?:WNSE|LLA)N|PSFIEL)D|H(?:REE RIVERS|ORNDIKE)|Y(?:NGSBORO|RINGHA"
  "M)|AUNTON|RURO)|F(?:A(?:L(?:L RIVER|MOUTH)|IRHAVEN|YVILLE)|I(?:TC"
  "HBURG|SKDALE)|O(?:RESTDALE|XBORO)|RA(?:MINGHAM|NKLIN)|LOR(?:ENCE|"
  "IDA)|EEDING HILLS)|O(?:AK(?: BLUFFS|HAM)|R(?:LEANS|ANGE)|TIS(?: A"
  "NGB)?|CEAN BLUFF|STERVILLE|XFORD|NSET)|V(?:I(?:LLAGE OF NAGOG WOO"
  "DS|NEYARD H(?:AVE|V)N)|LG NAGOG WDS)|U(?:P(?:HAMS CORNER|TON)|XBR"
  "IDGE)|I(?:NDIAN ORCH(?:ARD)?|PSWICH)|J(?:AMAICA PLAI|EFFERSO)N|K("
  "?:ATES CORNER|INGSTON)|YARMOUTH PORT|QUINCY))))$"
  ,
  /* -- MD -- MD -- MD -- MD -- MD -- MD -- MD -- MD -- MD -- MD -- */
  "(?:\\b)((?^:(?i:(?:C(?:H(?:E(?:S(?:APEAK(?:E (?:C(?:IT)?Y|BEACH)|"
  " BCH)|TER(?:TOWN)?)|V(?:Y CHASE|ERLY)|LTENHAM|WSVILLE)|A(?:RL(?:O"
  "TTE? HALL|ESTOWN)|(?:NC|S)E|PTICO)|URCH(?: (?:CREEK|HILL)|VILLE|T"
  "ON)|IL(?:LUM|DS))|O(?:L(?:(?:UMBI|OR)A|TONS POINT|LEGE PARK|MAR M"
  "ANOR|ESVILLE)|CK(?:YS(?: HT VLY|VIL)|EYSVILLE)|R(?:RIGANVILLE|DOV"
  "A)|TTAGE CITY|BB ISLAND|OKSVILLE|NOWINGO|MPTON)|A(?:P(?:ITOL H(?:"
  "EIGH|G)TS|E SAINT CLAIRE)|L(?:IFORNIA|VERTON|LAWAY)|M(?:P SPRINGS"
  "|BRIDGE)|(?:BIN JOH|VETOW)N|(?:TONSVILL|SCAD)E|R(?:DIFF|ROLL))|R("
  "?:O(?:(?:CHER|FT)ON|WNSVILLE)|(?:E(?:SAPTOW|LLI)|UMPTO)N|ISFIELD|"
  "APO)|L(?:A(?:RKS(?:VILLE|BURG)|IBORNE)|E(?:AR SPRING|MENTS)|I[FN]"
  "TON)|U(?:MBERLAND|RTIS BAY)|E(?:NTREVILLE|CILTON)|PE ST CLAIRE)|S"
  "(?:A(?:INT (?:M(?:ARYS(?: CITY)?|ICHAELS)|(?:CHARL|INIGO|JAM)ES|L"
  "EONARD)|N(?:DY SPRING|G RUN)|(?:BILLASVILL|VAG)E|LISBURY)|T(?: M("
  "?:ARYS CITY|ICHAELS)|EVENS(?:VILLE|ON)|HRN MD FAC|ILL POND|OCKTON"
  "|REET)|P(?:AR(?:KS(?: GLENCOE?)?|ROWS P(?:OIN)?T)|RING(?: GAP|DAL"
  "E)|ENCERVILLE)|H(?:A(?:RP(?:SBURG|TOWN)|DY SIDE|LLMAR)|ERWOOD(?: "
  "F(?:ORE|R)ST)?|OWELL)|U(?:B(?:URB MARYLAN|N M)D FAC|(?:NDER|IT)LA"
  "ND|DLERSVILLE)|E(?:A(?:T PLEASANT|BROOK)|VERN(?:A PARK)?|CRETARY)"
  "|O(?:UTHERN MD FACILITY|LOMONS)|I(?:LVER SPRING|MPSONVILLE)|C(?:A"
  "GGSVILLE|OTLAND)|WAN(?: POINT|TON)|MITHSBURG|YKESVILLE|NOW HILL)|"
  "B(?:R(?:O(?:O(?:K(?:L(?:ANDV(?:ILLE|L)|YN(?: PARK)?)|EVILLE)|MES "
  "IS(?:LAND)?)|WNSVILLE)|A(?:D(?:DOCK (?:HEIG)?HTS|SHAW)|NDYWINE)|Y"
  "AN(?:S ROAD|TOWN)|ENTWOOD|UNSWICK|INKLOW)|E(?:N(?:TLEY SP(?:RIN)?"
  "GS|EDICT|SON)|L(?: A(?:LTON|IR)|TSVILLE|CAMP)|T(?:H(?:LEHEM|ESDA)"
  "|TERTON)|R(?:WYN (?:HEIG)?HTS|LIN)|VERLEY BCH|ALLSVILLE)|A(?:R(?:"
  "NESVILLE|CLAY|STOW|TON)|L(?:TIMORE|DWIN)|INBRIDGE)|I(?:(?:SHOPVIL"
  "L|VALV)E|G (?:SPRING|POOL)|TTINGER)|U(?:R(?:KITT|TON)SVILLE|CKEYS"
  "TOWN|SHWOOD|TLER)|O(?:ONSBORO|RING|ZMAN|WIE|YDS)|L(?:ADENSBURG|OO"
  "MINGTON)|WI AIRPORT)|M(?:A(?:R(?:Y(?:LAND (?:CITY|LINE)|DEL)|DELA"
  "(?: SP(?:RIN)?GS)?|ION(?: STA(?:TION)?)?|LOW H(?:EIGH|G)TS|RIOTTS"
  "V(?:ILLE|L)|BURY)|N(?:CHESTER|OKIN)|D(?:ISON|DOX)|UGANSVILLE|SSEY"
  "|YO)|O(?:UNT(?: (?:WASHINGTON|VICTORIA|RAINIER|SAVAGE|AIRY)|AIN L"
  "AKE PARK)|N(?:T(?:GOM(?:ERY VILLAGE|RY VLG)|PELIER)|ROVIA|KTON)|R"
  "GANZA)|I(?:D(?:DLE(?: RIVER|BURG|TOWN)|L(?:OTHIAN|AND))|LL(?:ERS("
  "?:VILLE)?|INGTON)|TCHELLVILLE)|T(?: (?:WASHINGTON|LAKE PARK|VICTO"
  "RIA)|IN LK PARK)|C(?:D(?:ONOGH RUN|ANIEL)| HENRY|COOLE)|(?:ECHANI"
  "CSVI?|YERSVI)LLE|NT LAKE PARK|D CITY)|L(?:A(?:N(?:DOVER(?: H(?:IL"
  ")?LS)?|HAM(?: SEABROOK)?|GLEY PARK|SDOWNE)|(?:(?:YTONSVIL|VA)L|KE"
  " SHOR)E|DIESBURG| PLATA|UREL|RGO)|I(?:N(?:THICUM(?: (?:HEIG)?HTS)"
  "?|K?WOOD|EBORO)|(?:BERTYTOW|SBO)N|TTLE ORLEANS)|O(?:N(?:ACONING|G"
  " GREEN)|(?:CH RAVE|THIA)N|VEVILLE)|U(?:TH(?:ERVILLE(?: TIMONIUM)?"
  "|VLE TIMON)|SBY|KE)|E(?:(?:ONARD|WIS)TOWN|XINGTON P(?:AR)?K)|TL O"
  "RLEANS|YNCH)|W(?:E(?:ST(?: (?:HYATTSVILLE|FRIENDSHIP|RIVER)|(?:MI"
  "NST|OV)ER|ERNPORT|LAKE)|LCOME|NONA)|O(?:O(?:D(?:LA(?:ND BCH|WN)|S"
  "(?:BORO|TOCK)|BINE)|LFORD)|RTON)|A(?:SHINGT(?:ON GROVE|N GRV)|L(?"
  ":KERSVILLE|DORF)|RWICK)|H(?:ITE(?: (?:PLAINS|MARSH|HALL)|FORD)|AL"
  "EYVILLE|EATON)|I(?:LL(?:IAMSPORT|ARDS)|N(?:DSOR MILL|GATE)|TTMAN)"
  "| (?:HYATTSVILLE|FRIENDSHIP|BETHESDA)|YE MILLS)|P(?:O(?:RT (?:REP"
  "UBLIC|DEPOSIT|TOBACCO)|(?:OLES|WELL)VILLE|INT OF ROCKS|COMOKE CIT"
  "Y|MFRET|TOMAC)|A(?:R(?:K(?: HALL|VILLE|TON)|SONSBURG)|T(?:UXENT R"
  "IV(?:ER)?|APSCO)|SADENA)|R(?:I(?:NCE(?: FREDERICK|SS ANNE)|CE)|NC"
  " FREDERCK|ESTON)|I(?:N(?:EY POINT|TO)|(?:KE|TT)SVILLE|SGAH)|ERRY("
  "?: (?:POINT|HALL)|VILLE|MAN)|T OF ROCKS|YLESVILLE|HOENIX)|F(?:O(?"
  ":R(?:T (?:(?:(?:GEORGE G )?MEAD|RITCHI)E|WASHINGTON|DETRICK|HOWAR"
  "D)|EST(?: H(?:(?:EIGH)?TS|ILL)|VILLE)|K)|WBELSBURG)|R(?:IENDS(?:V"
  "ILLE|HIP)|E(?:DERICK|ELAND)|OSTBURG|UITLAND|ANKLIN)|A(?:IR(?:MOUN"
  "T(?: H(?:EIGHTS|GT))?|PLAY)|LLSTON|ULKNER)|(?:U(?:NKSTOW|LTO)|T W"
  "ASHINGTO)N|I(?:SHING CREEK|NKSBURG)|EDERALSBURG|LINTSTONE)|G(?:R("
  "?:E(?:EN(?:(?:MOUN|BEL)T|SBORO)|AT MILLS)|A(?:(?:N(?:TSVILL|IT)|S"
  "ONVILL)E|CEHAM))|A(?:RR(?:ETT PARK|ISON)|ITHER(?:SBURG)?|LE(?:SVI"
  "LLE|NA)|MBRILLS|PLAND)|L(?:EN(?: (?:BURNIE|ECHO|ARM)|(?:N DAL|CO)"
  "E|ARDEN|WOOD|ELG)|YNDON)|I(?:BSON ISLAND|RDLETREE)|O(?:L(?:DSBORO"
  "|TS)|VANS)|E(?:ORGE|RMAN)TOWN|UNPOWDER|WYNN OAK)|H(?:A(?:(?:VRE D"
  "E GRAC|LETHORP)E|N(?:COCK|OVER)|R(?:MANS|WOOD)|GERSTOWN|MPSTEAD)|"
  "I(?:LL(?:CREST H(?:EIGH|G)?TS|SBORO)|GH(?:LAND(?: BCH|TOWN)?|FIEL"
  "D))|U(?:NT(?: VALLEY|INGTOWN)|GHESVILLE|RLOCK|TTON)|E(?:(?:(?:NDE"
  "RS|BR)O|LE)N|REFORD)|Y(?:ATTS(?:VILLE|TOWN)|DES)|OLL(?:AND POINT|"
  "YWOOD)|VRE DE GRACE)|N(?:O(?:RTH(?: (?:B(?:E(?:THESDA|ACH)|RENTWO"
  "(?:OD)?)|E(?:NGLEWOOD|AST)|POTOMAC)|WOOD)| (?:BRENTWOOD|POTOMAC)|"
  "TTINGHAM)|E(?:W(?: (?:M(?:ARKET|IDWAY)|CARROLLTO?N|WINDSOR)|BURG|"
  "COMB|ARK)|AVITT)| (?:B(?:RENTWOOD|ETHESDA)|ENGLEWOOD|POTOMAC)|A(?"
  ":N(?:TICOKE|JEMOY)|VAL ACADEMY))|R(?:O(?:CK(?:(?:Y RIDG|VILL)E| ("
  "?:POINT|HALL))|(?:LAND PAR|YAL OA)K|SE(?: HAVEN|DALE)|HRERSVILLE)"
  "|I(?:V(?:IERA BEACH|ERDALE|A)|D(?:GE(?:LY)?|ERWOOD)|S(?:ING SU|O)"
  "N)|A(?:NDALLSTOWN|SPEBURG|WLINGS)|E(?:ISTERSTOWN|HOBETH)|U(?:SSET"
  "T|XTON)|HODESDALE)|D(?:A(?:R(?:(?:LINGTO|NESTOW)N|ES BEACH)|M(?:E"
  "(?:S QUARTER|RON)|ASCUS)|VIDSONVILLE|NIELS|YTON)|E(?:AL(?: ISLAND"
  "|E)|NT(?:SVILLE|ON)|(?:LMA|TOU)R|ER PARK|RWOOD)|I(?:STRICT (?:HEI"
  "G)?HTS|CKERSON)|R(?:AYDEN|UID)|UN(?:DAL|KIR)K|O(?:WELL|UBS))|A(?:"
  "N(?:NAPOLIS(?: J(?:UNCTION|CT))?|DREWS A(?:IR FORCE BASE|FB))|B(?"
  ":E(?:R(?:DEEN(?: PROVING GROUND)?| PROV GRD)|LL)|INGDON)|R(?:LING"
  "TON|BUTUS|NOLD)|D(?:AMSTOWN|ELPHI)|S(?:PEN HILL|HTON)|CC(?:IDENT|"
  "OKEEK)|QUASCO|VENUE|LLEN)|E(?:L(?:L(?:ICOTT CITY|ERSLIE)|K(?: MIL"
  "LS|RIDGE|TON)|DERSBURG)|A(?:ST(?: (?:NEW MARKET|CASE)|PORT|ON)|RL"
  "EVILLE)|D(?:GE(?:W(?:ATER(?: BCH)?|OOD)|MERE)|EN)|CKHART MINES| N"
  "EW MARKET|MMITSBURG|UDOWOOD|SSEX|WELL)|T(?:A(?:YLORS IS(?:LAND)?|"
  "LL TIMBERS|KOMA PARK|NEYTOWN)|RA(?:CYS L(?:ANDIN|ND)G|PPE)|EMPLE("
  "?: HILLS|VILLE)|I(?:LGHMAN|MONIUM)|O(?:DDVILLE|WSON)|Y(?:LERTO|AS"
  "KI)N|USCARORA|HURMONT)|U(?:P(?:P(?:ER(?: (?:FA(?:IRM(?:OUN)?T|LLS"
  ")|MARLBORO)|CO)|R MARLBORO)|R MARLBORO)|NI(?:ON(?: BRIDG|VILL)E|V"
  "ERSITY PA(?:RK)?)|RBANA)|O(?:CEAN (?:PI?NES|CITY)|X(?:ON HILL|FOR"
  "D)|WING(?:S MILL)?S|L(?:DTOWN|NEY)|RCHARD BEACH|AKLAND|DENTON|ELL"
  "A)|K(?:E(?:N(?:NEDYVILLE|SINGTON)|EDYSVILLE|TTERING|YMAR)|I(?:NGS"
  "VILLE|TZMILLER)|NOXVILLE)|I(?:N(?:DIAN HEAD|GLESIDE)|(?:JAMSVILL|"
  "SSU)E|LCHESTER|RONSIDES)|J(?:E(?:FFERSON|NNINGS|SSUP)|A(?:RRETTS|"
  "CKSON)VILLE|OPPA)|QU(?:EEN(?: ANNE|STOWN)|ANTICO)|V(?:ALLEY LEE|I"
  "ENNA)))))$"
  ,
  /* -- ME -- ME -- ME -- ME -- ME -- ME -- ME -- ME -- ME -- ME -- */
  "(?:\\b)((?^:(?i:(?:S(?:O(?:UTH(?: (?:G(?:OULDSBORO|ARDINER)|B(?:E"
  "RWICK|RISTOL)|P(?:ORTLAND|ARIS)|C(?:ASCO|HINA)|HARPSWELL|THOMASTO"
  "N|FREEPORT|WINDHAM)|WEST H(?:ARBO|B)R|PORT)|MERVILLE|RRENTO|LON)|"
  "A(?:N(?:DY (?:(?:R(?:IVE|V)R PL|POIN)T|BAY TWP)|GERVILLE|FORD)|IN"
  "T (?:A(?:GATHA|LBANS)|FRANCIS|GEORGE|DAVID)|L(?:SBURY COVE|EM TWP"
  ")|RGENTVILLE|BATTUS|CO)|T(?:O(?:CK(?:TON SP(?:RIN)?GS|HOLM)|N(?:I"
  "NGTON|EHAM)|W)|E(?:(?:TSO|UBE)N|EP FALLS)|A(?:CYVILLE|NDISH|RKS)|"
  "R(?:ATTON|ONG)| JOHN PLT|ILLWATER)|E(?:B(?:A(?:SCO EST(?:ATE)?S|G"
  "O(?: LAKE)?)|OEIS PLT|EC)|A(?:L (?:HARBOR|COVE)|RS(?:MON|POR)T)|D"
  "GWICK)|H(?:ER(?:MAN(?: (?:STA(?:TION)?|MILLS))?|IDAN)|A(?:PLEIGH|"
  "WMUT)|IRLEY MILLS)| (?:G(?:OULDSBORO|ARDINER)|HARPSWELL|THOMASTON"
  "|FREEPORT|PORTLAND)|I(?:LVER RIDGE(?: TWP)?|NCLAIR|DNEY)|PR(?:ING"
  "(?:FIELD|VALE)|UCE HEAD)|W(?:AN(?:S ISLAND|VILLE)|EDEN)|U(?:LLIVA"
  "N|MNER|NSET|RRY)|M(?:YRNA MILLS|ITHFIELD)|QUIRREL IS(?:LAND)?|CAR"
  "BOROUGH|KOWHEGAN)|C(?:A(?:R(?:R(?:YING PLACE TOWN TWP|ABASSETT VA"
  "LLEY|OLL PLT)|A(?:BASET VLY|TUNK)|Y(?:NG PL TWP| PLT)|(?:DVILL|TH"
  "AG)E|IBOU|MEL)|P(?:E (?:(?:PORPOIS|COTTAG)E|ELIZ(?:ABETH)?|NEDDIC"
  "K)|ITOL IS(?:LAND)?)|S(?:T(?:LE HILL|INE)|WELL|CO)|M(?:BRIDGE|DEN"
  ")|N(?:AA|TO)N|LAIS)|H(?:A(?:IN OF P(?:ONDS TWP|NDS)|(?:MBERLAI|PM"
  "A)N|RL(?:ESTON|OTTE))|E(?:BEAGUE IS(?:LAND)?|STER(?:VILLE)?|RRYFI"
  "ELD|LSEA)|INA(?: V(?:ILLAGE|LG))?)|O(?:R(?:N(?:VILLE|ISH)|IN(?:NA"
  "|TH)|EA)|LUMBIA(?: F(?:AL)?LS)?|(?:DYVILLE|PLIN) PLT|N(?:CORD|NOR"
  ") TWP|OPER(?:S MILLS)?|BURN GORE|STIGAN)|U(?:MB(?:ERL(?:AND(?: (?"
  ":FORESIDE|CENTER))?|ND CTR)| FORESIDE)|SHING(?: IS(?:LAND)?)?|(?:"
  "NDYS HARBO|TLE)R)|R(?:O(?:SS LA?KE TWP|USEVILLE)|ANBERRY I(?:SLE)"
  "?S|YSTAL)|L(?:I(?:F(?:F ISLAND|TON)|NTON)|AYTON LAKE)|ENTER(?: LO"
  "VELL|VILLE)|YR PLT)|W(?:E(?:S(?:T(?: (?:B(?:OOTHBAY HARBOR|A(?:LD"
  "WIN|TH)|ETHEL)|(?:ROCKPOR|TREMON|MINO)T|F(?:ARMINGTON|ORKS)|(?:NE"
  "W|EN)FIELD|P(?:OLAND|ARIS)|SCARBOROUGH|KENNEBUNK|GARDINER)|(?:MAN"
  "LAN|FIEL)D|PORT IS(?:LAND)?|BROOK|ON)|LEY)|L(?:L(?:INGTON|S)|D)|B"
  "STER PLT|EKS MILLS)|I(?:N(?:T(?:ER(?:(?:VILLE PL|POR)T| HARBOR)|H"
  "ROP)|D(?:HAM|SOR)|SLOW|N)|L(?:LI(?:AMSBURG TWP|MANTIC)|IAMSBG TWP"
  "|TON)|SCASSET)|A(?:L(?:(?:LAGRAS|E)S|D(?:OBOR)?O|POLE|THAM)|(?:SH"
  "(?:INGTO|BUR)|RRE)N|TER(?:VILLE|BORO|FORD)|(?:IT|YN|D)E)| (?:BO(?"
  ":OTHB(?:AY HA(?:RBOR)?|Y HBR)|WDOIN)|SCARBOROUGH|FARMINGTON|KENNE"
  "BUNK)|OO(?:DLAND(?: WASHINGTON COUNTY)?|LWICH)|HIT(?:NEYVILLE|EFI"
  "ELD|ING)|NTERVLLE PLT|YTOPITLOCK)|B(?:R(?:O(?:WN(?:V(?:ILLE(?: JU"
  "NCTION)?|LLE JCT)|FIELD)|OK(?:S(?:VILLE)?|(?:LI|TO)N))|I(?:DG(?:E"
  "WATER|TON)|GHTON PLT|STOL)|AD(?:FORD|LEY)|E(?:MEN|WER)|YANT POND|"
  "UNSWICK)|E(?:L(?:GRADE(?: L(?:AKE|K)S)?|(?:FAS|MON)T)|A(?:VER COV"
  "E|LS)|N(?:EDICTA|TON)|R(?:NARD|WICK)|DDINGTON|THEL)|A(?:R(?: (?:H"
  "ARBOR|MILLS)|NARD TWP|ING PLT)|ILEY(?: ISLAND|VILLE)|N(?:CROFT|GO"
  "R)|SS HARBOR|TH)|U(?:CK(?:S(?: HARBOR|PORT)|FIELD)|R(?:LINGTON|NH"
  "AM)|STINS IS(?:LAND)?|XTON)|I(?:DDEFORD(?: P(?:OO)?L)?|RCH (?:HAR"
  "BOR|ISLAND)|NGHAM)|O(?:OTHBAY(?: H(?:ARBO|B)R)?|W(?:DOIN(?:HAM)?|"
  "ERBANK))|L(?:A(?:NCHARD TWP|INE)|UE HILL)|YRON)|M(?:A(?:T(?:TA(?:"
  "MISC(?:ONTIS)? TWP|WAMKEAG)|INICUS)|C(?:HIAS(?:PORT)?|WAHOC PLT| "
  "MAHAN)|R(?:S(?:HFIELD| HILL)|IAVILLE)|D(?:RID TWP|AWASKA|ISON)|S("
  "?:ON TWP|ARDIS)|YFIELD TWP|NCHESTER|PLETON|XFIELD)|O(?:N(?:T(?:IC"
  "ELLO|VILLE)|(?:HEGA|SO)N|MOUTH|ROE)|UNT (?:DESERT|VERNON|CHASE)|X"
  "IE GORE(?: TWP)?|O(?:SE RIVER|DY)|R(?:O PLT|RILL)|LUNKUS TWP|SCOW"
  ")|E(?:D(?:DYBEMPS|FORD|OMAK|WAY)|R(?:E POINT|RILL|CER)|CHANIC F(?"
  ":AL)?LS|XICO)|I(?:L(?:LINOCKET|TON TWP|BRIDGE|FORD|O)|N(?:TURN|OT"
  ")))|N(?:O(?:R(?:TH(?: (?:S(?:HAPLEIGH|ULLIVAN)|B(?:RIDGTON|ERWICK"
  ")|WATER(?:BORO|FORD)|(?:MON|YAR)MOUTH|(?:ANSO|HAVE)N|NEW PORTLAND"
  "|VASSALBORO|FRYEBURG|TURNER|JAY)|EAST H(?:ARBO|B)R|FIELD|PORT)|RI"
  "DGEWOCK|WAY)|BLEBORO)|EW(?: (?:(?:GLOUCESTE?|HARBO)R|(?:PORTLAN|V"
  "INEYAR)D|S(?:HARO|WEDE)N|LIMERICK|CANADA)|CASTLE|BURGH|FIELD|AGEN"
  "|PORT|RY)| (?:S(?:HAPLEIGH|ULLIVAN)|WATER(?:BORO|FORD)|(?:MON|YAR"
  ")MOUTH|NEW PORTLA?ND|VASSALBORO|BRIDGTON|FRYEBURG)|A(?:SHVILLE PL"
  "T|PLES))|E(?:A(?:ST(?: (?:(?:P(?:ARSONSFIEL|OLAN)|DIXFIEL|ORLAN)D"
  "|M(?:ILLINOCKET|OXIE TWP|ACHIAS)|W(?:I(?:NTHROP|LTON)|ATERBORO)|B"
  "(?:LUE HILL|OOTHBAY|ALDWIN)|VASSALBORO|LIVERMORE|ANDOVER|NEWPORT|"
  "HOLDEN)|BROOK|PORT|ON)|GLE LAKE)| (?:M(?:ILLINOCKET|OXIE TWP)|(?:"
  "VASSAL|WATER)BORO|PARSONFIELD|BLUE HILL|LIVERMORE|STONEHAM)|L(?:L"
  "(?:IOTTSVILLE TWP|SWORTH)|IOT(?:SVLE TWP)?)|D(?:MUNDS TWP|DINGTON"
  "|GECOMB|INBURG)|STCOURT STA(?:TION)?|BEEMEE TWP|NFIELD|MBDEN|USTI"
  "S|XETER|TNA)|P(?:I(?:TTS(?:T(?:ON(?: ACADEMY GRANT TWP)?|N ACDMY)"
  "|FIELD)|ERCE POND(?: TWP)?|NE POINT)|A(?:R(?:LIN P(?:ON)?D TWP|SO"
  "NSFIELD|KMAN|IS)|L(?:ERMO|MYRA)|SSADUMKEAG|TTEN)|O(?:RT(?:(?:AG(?"
  ":E LAK)?| CLYD)E|LAND|ER)|LAND(?: SPRING)?|ND COVE|WNAL)|E(?:R(?:"
  "KINS TWP|HAM|RY|U)|M(?:AQUID|BROKE)|(?:JEP|NOB)SCOT|AKS ISLAND)|R"
  "(?:E(?:NTISS TWP|SQUE ISLE)|OSPECT(?: H(?:ARBO|B)R)?|INCETON)|L(?"
  ":(?:EASANT (?:P(?:OIN)?|RIDGE PL)|SNT RDG PL)T|YMOUTH)|HI(?:PPSBU"
  "RG|LLIPS))|L(?:I(?:N(?:COLN(?:V(?:ILLE(?: CENTER)?|L CTR)| C(?:EN"
  "TE|NT)R)?|NEUS)|T(?:TLE(?: D(?:IAMOND ISLAND|EER ISLE)|TON)|CHFIE"
  "LD)|M(?:E(?:STONE|RICK)|INGTON)|VERMORE(?: F(?:AL)?LS)?|L(?:Y BAY"
  " TWP|LE)|SBON(?: FALLS)?|BERTY)|A(?:(?:M(?:BERT LAK|OIN)|KEVILL|G"
  "RANG)E|NG TWP)|O(?:NG (?:POND TWP|ISLAND)|RING CM CTR|[VW]ELL)|E("
  "?:(?:WIST|BAN)ON|XINGTON TWP|E(?:DS)?|VANT)|TL(?: DEER|E DIA) IS|"
  "U(?:DLOW|BEC)| L BEAN CO|YMAN)|F(?:R(?:E(?:NCH(?:TO?WN TWP|VILLE|"
  "BORO)|E(?:MAN TWP|PORT|DOM))|YE(?: ISLAND|BURG)|ANK(?:FORT|LIN)|I"
  "ENDSHIP)|A(?:RMING(?:T(?:ON(?: FALLS)?|N FLS)|DALE)|IRFIELD|LMOUT"
  "H|YETTE)|ORT (?:KENT(?: MILLS)?|FAIRFIELD)|LETCHERS L(?:ANDING TW"
  "P|DG)|T (?:FAIRFIELD|KENT MLS))|H(?:A(?:R(?:RI(?:NGT|S)ON|T(?:FOR"
  "|LAN)D|BORSIDE|PSWELL|MONY)|M(?:(?:PDE|LI)N|MOND)|N(?:COCK|OVER)|"
  "YNESVILLE|LLOWELL)|O(?:L(?:LIS CENTER|DEN)|(?:DGD|ULT)ON|WLAND|PE"
  ")|E(?:R(?:SEY(?:TOWN TWP)?|MON)|BRON)|I(?:GHLAND PLT|NCKLEY|RAM)|"
  "U(?:LLS COVE|DSON)|RSYTOWN TWP)|G(?:R(?:E(?:EN(?:V(?:ILLE(?: JUNC"
  "TION)?|LLE JCT)|F(?:IE)?LD TWP|BUSH|WOOD|E)|AT (?:DIAMOND ISLA|PO"
  ")ND)|A(?:ND (?:L(?:AKE STREA|K STR)M|ISLE)|Y)|T DIA IS)|AR(?:FIEL"
  "D PLT|DINER|LAND)|LEN(?:WOOD PLT| COVE|BURN)|O(?:ULDSBORO|RHAM)|("
  "?:UILFOR|ILEA)D|EORGETOWN)|D(?:E(?:N(?:N(?:YSVILLE|ISTOWN)|MARK)|"
  "AD R(?:IVE|V)R TWP|ER ISLE|BLOIS|TROIT|DHAM|XTER|RBY)|I(?:AMOND ("
  "?:IS(?:LAND)?|COVE)|X(?:FIELD|MONT))|A(?:N(?:FORTH|VILLE)|MARISCO"
  "TTA|LLAS PLT|YTON)|R(?:E(?:W PLT|SDEN)|YDEN)|(?:OVE?|V)R FOXCROFT"
  "|YER BROOK|URHAM)|A(?:L(?:B(?:ANY TWP|ION)|EXANDER|LAGASH|FRED|TO"
  "N|NA)|R(?:GYLE TWP|ROWSIC|UNDEL)|U(?:(?:GUST|ROR)A|BURN)|D(?:AMST"
  "OWN TWP|DISON)|(?:(?:PPLE|C)T|V)ON|T(?:KINSON|HENS)|M(?:HERST|ITY"
  ")|N(?:DOVER|SON)|SHLAND|BBOT)|O(?:R(?:R(?:S ISLAND|INGTON)|NEVILL"
  "E TWP|IENT|LAND|ONO)|L(?:D (?:ORCH(?:ARD BEA|D B)CH|TOWN)|AMON)|("
  "?:AK(?:FIEL|LAN)|WLS HEA)D|T(?:IS(?:FIELD)?|TER CREEK)|X(?:FORD|B"
  "OW)|CEAN PARK|GUNQUIT|QUOSSOC|SBORN)|R(?:O(?:CK(?:(?:LAN|WOO)D|PO"
  "RT)|QUE BLUFFS|BBINSTON|UND POND|XBURY|ME)|UMFORD(?: (?:C(?:ENTE|"
  "T)R|POINT))?|A(?:N(?:DOLPH|GELEY)|YMOND)|E(?:ADFIELD|ED PLT)|I(?:"
  "CHMOND|PLEY))|T(?:H(?:O(?:MASTON|RNDIKE)|E FORKS PLT)|R(?:E(?:SCO"
  "TT TWP|NTON|VETT)|OY)|E(?:NANTS H(?:ARBO|B)R|MPLE)|OPS(?:FIELD|HA"
  "M)|ALMADGE|URNER)|I(?:S(?:L(?:E(?: (?:OF SPRINGS|AU HAUT)|S(?:BOR"
  "O|FORD))|AND FALLS)| OF SPRINGS)|ND(?:IAN (?:STREAM(?: TWP)?|ISLA"
  "ND|TWP)|USTRY))|K(?:E(?:N(?:NEBUNK(?:PORT)?|DUSKEAG|TS HILL)|ZAR "
  "FALLS)|I(?:NG(?:MAN(?: TWP)?|FIELD)|TTERY(?: POINT)?)|NOX)|J(?:O("
  "?:HNSON MOUNTAIN TWP|NES(?:BORO|PORT))|A(?:CK(?:MA|SO)N|Y)|HNSN M"
  "TN TWP|EFFERSON)|V(?:A(?:N(?: BUREN|CEBORO)|SSALBORO)|E(?:RONA IS"
  "LAND|AZIE)|I(?:NALHAVEN|ENNA))|U(?:P(?:PER FR(?:ENCHVILLE|NCHVL)|"
  "TON)|NI(?:ON|TY))|Y(?:ORK(?: (?:HARBOR|BEACH))?|ARMOUTH)|QUIMBY))"
  "))$"
  ,
  /* -- MH -- MH -- MH -- MH -- MH -- MH -- MH -- MH -- MH -- MH -- */
  "(?:\\b)((?^:(?i:(?:MAJURO|EBEYE))))$"
  ,
  /* -- MI -- MI -- MI -- MI -- MI -- MI -- MI -- MI -- MI -- MI -- */
  "(?:\\b)((?^:(?i:(?:S(?:A(?:INT (?:C(?:LAIR(?: SHORES)?|HARLES)|JO"
  "(?:SEPH|HNS)|IGNACE|HELEN|LOUIS)|N(?:D(?: (?:CREEK|POINT|LAKE)|US"
  "KY)|FORD)|U(?:LT S(?:AINTE)? MARIE|GATUCK)|G(?:INAW|OLA)|L(?:INE|"
  "EM)|MARIA|RANAC|WYER)|T(?:E(?:RLING(?: (?:HEIG)?HTS)?|VENSVILLE|P"
  "HENSON)|A(?:N(?:DISH|WOOD|TON)|MBAUGH|LWART)|(?: CL(?:AIR SHR|R S"
  "HORE)|URGI)S|RON(?:ACH|GS)|OCKBRIDGE)|O(?:UTH(?: (?:B(?:OARDMAN|R"
  "ANCH)|R(?:OCKWOOD|ANGE)|(?:HAVE|LYO)N)|FIELD|GATE)|MERSET(?: C(?:"
  "ENTE|T)R)?|DUS)|P(?:R(?:ING(?:F(?:IELD(?: TOWNSHIP)?|LD TWP)| (?:"
  "ARBOR|LAKE)|PORT)|UCE)|A(?:LDING|RTA))|H(?:E(?:LBY(?: T(?:OWNSHI|"
  "W)P|VILLE)?|R(?:IDAN|WOOD)|PHERD)|AFTSBURG|INGLETON)|U(?:PERIOR T"
  "(?:OWNSHI|W)P|M(?:PTER TWP|NER)|TTONS BAY|NFIELD)|E(?:LFRIDGE(?: "
  "ANGB)?|NE(?:CA|Y)|BEWAING|ARS)|I(?:LVER(?: LAKE|WOOD)|DN(?:AW|EY)"
  "|X LAKES)|C(?:H(?:OOLCRAFT|AFFER)|OTT(?:VILLE|S))| (?:BOARDMAN|RO"
  "CKWOOD)|M(?:ITHS CREEK|YRNA)|YLVAN (?:BEACH|LAKE)|KAN(?:DIA|EE)|W"
  "ARTZ CREEK|NOVER)|B(?:R(?:O(?:WN(?:ST(?:OWN(?: T(?:OWNSHI|W)P)?|W"
  "N TWP)| CITY)|(?:OKLY|HMA|NSO)N|CKWAY)|U(?:CE(?: (?:(?:CROSS|X)IN"
  "G|T(?:OWNSHI|W)P))?|NSWICK|TUS)|I(?:DG(?:E(?:WATER|PORT)|MAN)|(?:"
  "GH|T)TON|MLEY)|E(?:(?:CKENRIDG|EDSVILL)E|THREN)|A(?:N(?:CH|T)|MPT"
  "ON|DLEY))|E(?:R(?:RIEN (?:C(?:ENTE|T)R|SPR(?:IN)?GS)|GLAND|VILLE|"
  "KLEY|LIN)|L(?:L(?:EV(?:ILL|U)|AIR)E|DING|MONT)|A(?:VER(?: ISLAND|"
  "TON)|R LAKE)|N(?:T(?:ON HARBOR|LEY)|ZONIA)|(?:ECHWOO|DFOR)D|VERLY"
  " HILLS|SSEMER|ULAH)|A(?:R(?:(?:AG|OD)A|TON CITY|K RIVER|RYTON|BEA"
  "U)|Y (?:HARBOR|SHORE|CITY|PORT|VIEW)|N(?:(?:NISTE|GO)R|CROFT)|T(?"
  ":TLE CREEK|H)|D AXE|LDWIN|ILEY)|L(?:OOM(?:F(?:IELD(?: (?:T(?:OWNS"
  "HI|W)P|VILLAGE|HILLS))?|LD (?:HLS|TWP))|INGDALE)|A(?:CK RIVER|NCH"
  "ARD)|ISSFIELD)|U(?:R(?:T(?:(?:CHVILL| LAK)E|ON)?|LINGTON|R OAK|NI"
  "PS)|C(?:HANAN|KLEY))|I(?:R(?:MINGHAM|CH RUN)|G (?:RAPIDS|BAY)|NGH"
  "AM FARMS|TELY)|O(?:IS BLANC IS(?:LAND)?|YNE (?:FALLS|CITY)|ON)|YR"
  "ON(?: CENTER)?)|C(?:O(?:M(?:MERCE T(?:OWNSHI|W)P|STOC(?:K PAR)?K|"
  "INS)|L(?:UMB(?:IAVILLE|US)|O(?:MA|N)|DWATER|EMAN)|P(?:PER (?:HARB"
  "OR|CITY)|EMISH)|N(?:STANTINE|CORD|KLIN|WAY)|R(?:(?:NEL|A)L|UNNA)|"
  "O(?:PERSVILLE|KS)|V(?:INGTON|ERT)|TTRELLVILLE|HOCTAH)|A(?:R(?:SON"
  "(?: CITY|VILLE)|L(?:ETON|AND)|ROLLTON|P LAKE|NEY|O)|S(?:S(?:OPOLI"
  "S| CITY)|EVILLE|NOVIA|PIAN|CO)|N(?:ADIAN LAKES?|NONSBURG|TON)|L(?"
  ":EDONIA|UMET)|D(?:ILLAC|MUS)|MDEN|PAC)|L(?:A(?:R(?:K(?:S(?:VILLE|"
  "TON)|LAKE)|E)|Y(?:TON(?: TWP)?)?|WSON)|I(?:NTON(?: T(?:OWNSHI|W)P"
  ")?|FFORD|MAX|O)|(?:OVERDAL|YD)E)|H(?:A(?:RL(?:EVOIX|OTTE)|S(?:SEL"
  "L|E)|MPION|NNING|THAM)|E(?:S(?:TERFIELD|ANING)|BOYGAN|LSEA)|I(?:P"
  "PEWA LAKE|NA)|RISTMAS)|E(?:DAR(?: (?:SPRINGS|RIVER|LAKE)|VILLE)?|"
  "NT(?:R(?:AL LAK|EVILL)|ER LIN)E|MENT CITY|RESCO)|R(?:OS(?:S VILLA"
  "GE|WELL)|YSTAL(?: FALLS)?)|U(?:R(?:RAN|TIS)|STER))|M(?:A(?:R(?:(?"
  ":(?:QU|L)ETT|YSVILL|N)E|I(?:NE CITY|ON)|CELLUS|ENISCO|SHALL|TIN)|"
  "N(?:I(?:ST(?:IQU|E)E|TOU BEACH)|C(?:HESTER|ELONA)|TON)|C(?:KINA(?"
  ":C IS(?:LAND)?|W CITY)|ATAWA|OMB)|Y(?:(?:VILL|BE)E|FIELD)|PLE (?:"
  "RAPIDS|CITY)|DISON (?:HEIG)?HTS|S(?:S CITY|ON)|TTAWAN)|I(?:CHI(?:"
  "GA(?:N (?:C(?:ENTE|T)R|METROPLEX)|MME)|ANA)|L(?:L(?:ERSBURG|INGTO"
  "N|BROOK)|FORD|AN)|D(?:DLE(?:VILLE|TON)|LAND)|(?: METR|KAD)?O|NDEN"
  " CITY)|O(?:UNT (?:(?:CLEMEN|MORRI)S|PLEASANT)|N(?:T(?:(?:AGU|ROS)"
  "E|GOMERY)|ROE)|R(?:ENCI|RICE|LEY|AN)|S(?:HERVILLE|COW)|(?:TTVILL|"
  "LIN)E|ORESTOWN|HAWK)|E(?:RRI(?:WEATHER|LL|TT)|(?:TAMOR|COST)A|N(?"
  ":OMINEE|DON)|LVIN(?:DALE)?|(?:MPHI|AR)S|SICK)|U(?:S(?:KEGON(?: (?"
  ":HEIG)?HTS)?|SEY)|N(?:I(?:SING|TH)|GER)|LL(?:ETT LAKE|IKEN)|IR)|C"
  "(?: (?:MILLA|BAI)N|BRIDES)|T PLEASANT)|H(?:A(?:R(?:RI(?:S(?:ON(?:"
  " T(?:OWNSHI|W)P)?|VILLE)?|ETTA)|B(?:OR (?:SP(?:RIN)?GS|BEACH|POIN"
  "T)|ERT)|T(?:(?:FOR|LAN)D)?|SENS IS(?:LAND)?|PER WOODS|DWOOD|VEY)|"
  "M(?:BURG(?: TWP)?|TRAMCK|ILTON)|(?:GAR SHORE|WK)S|S(?:TINGS|LETT)"
  "|N(?:COCK|OVER)|ZEL PARK|DLEY|LE)|O(?:UGHTON(?: LAKE(?: HEIGHTS)?"
  ")?|L(?:L(?:AND|Y)|T(?:ON)?)|W(?:ARD CITY|ELL)|P(?:KINS|E)|(?:ME|N"
  "O)R|XEYVILLE|RTON)|U(?:BB(?:ARD(?: LAKE|STON)|ELL)|NTINGT(?:ON WO"
  "O|N W)DS|DSON(?:VILLE)?|LBERT)|I(?:G(?:HLAND(?: PARK)?|GINS LAKE)"
  "|CKORY C(?:ORNE|RN)RS|LL(?:SDALE|MAN))|E(?:R(?:MANSVILLE|RON|SEY)"
  "|S(?:PERIA|SEL)|NDERSON|MLOCK)|(?:GHTN LK |TN LK HG)HTS)|W(?:A(?:"
  "L(?:L(?:(?:OON|ED) LAK|AC)E|KER(?:VILLE)?|HALLA|DRON|ES)|T(?:ER(?"
  ":FORD(?: TOWNSHIP)?|S(?:MEET)?|VLIET)|TON)|SHINGT(?:ON(?: T(?:OWN"
  "SHI|W)P)?|N TWP)|Y(?:LAND|NE)|KEFIELD|RREN)|E(?:ST(?: (?:B(?:LOOM"
  "FIELD|RANCH)|OLIVE)|PHALIA|LAND|ON)|(?:BBERVILL|TMOR)E|LLS(?:TON)"
  "?|QUETONSING|IDMAN)|H(?:IT(?:E(?: (?:PI(?:GEON|NE)|CLOUD|LAKE)|HA"
  "LL)|T(?:EMORE|AKER)|MORE LAKE)|EELER)|O(?:LVERINE(?: L(?:AKE|K))?"
  "|OD(?:HAVEN|LAND))|I(?:L(?:LI(?:AMS(?:BURG|TON)|S)|SON)|XOM|NN)|Y"
  "(?:ANDOTTE|OMING)| BLOOMFIELD)|P(?:O(?:RT(?: (?:H(?:URON|OPE)|ELI"
  "ZABETH|SANILAC|AUSTIN)|LAND|AGE)|INT(?:E AUX PINS| AUX PIN)|TTERV"
  "ILLE|MPEII|NTIAC|WERS|SEN)|E(?:R(?:R(?:ONVILLE|INTON|Y)|KINS)|T(?"
  ":ERSBURG|OSKEY)|L(?:LSTON|KIE)|SHAWBESTOWN|ARL BEACH|NTWATER|WAMO"
  "|CK)|A(?:R(?:CHMENT|ADISE|IS|MA)|L(?:M(?:YRA|ER|S)|O)|INESDALE|W "
  "PAW)|I(?:NC(?:ONNING|KNEY)|(?:TTS|CK)FORD|ER(?:PORT|SON)|GEON)|R("
  "?:ES(?:QUE ISLE|COTT)|(?:UDEN|ATT)VILLE|INCETON)|L(?:EASANT (?:R("
  "?:IDGE|DG)|LAKE)|AINWELL|YMOUTH)|T ELIZABETH|ULLMAN)|G(?:R(?:A(?:"
  "N(?:D(?: (?:(?:MARAI|RAPID)S|J(?:UNCTION|CT)|B(?:EACH|LANC)|HAVEN"
  "|LEDGE)|VILLE)|T(?: T(?:OWNSHI|W)P)?)|SS LAKE|YLING|WN)|OSSE (?:P"
  "OINTE(?: (?:(?:SHORE|FARM|WOOD)S|PARK))?|ILE)|E(?:EN(?:(?:LAN|WOO"
  ")D|VILLE|BUSH)|GORY))|A(?:L(?:ESBURG|IEN)|RDEN(?: CITY)?|Y(?:LORD"
  ")?|GETOWN|ASTRA|INES)|O(?:OD(?: HART|ELLS|ISON|RICH)|ETZVILLE|ULD"
  " CITY|BLES|WEN)|L(?:EN(?:N(?:IE)?| ARBOR|DORA)|AD(?:STONE|WIN))|E"
  "(?:ORGETOWN T(?:OWNSHI)?P|RMFASK|NESEE)|I(?:BRALTAR|LFORD)|ULLIVE"
  "R|WINN)|L(?:A(?:KE(?: (?:L(?:EELANAU|INDEN)|O(?:DESSA|RION)|AN(?:"
  "GELUS|N)|ISABELLA|STATION|GEORGE|CITY)|VI(?:LLE|EW)|LAND|PORT|SID"
  "E)?|THRUP V(?:ILLAGE|LG)|M(?:BERTVILLE|ONT)|W(?:RENCE|TON)|C(?:HI"
  "NE|OTA)|NS(?:ING|E)|INGSBURG| SALLE|URIUM|PEER)|I(?:N(?:COLN(?: P"
  "ARK)?|WOOD|DEN)|T(?:TLE LAKE|CHFIELD)|MESTONE|VONIA)|E(?:(?:XING|"
  "WIS)TON|ON(?:IDAS|ARD)|N(?:NON|OX)|VERING|LAND|SLIE|ROY)|U(?:(?:N"
  "A PI|TH)ER|(?:DING|P)TON|ZERNE|M)|O(?:NG LAKE|RETTO|WELL)|Y(?:ONS"
  "|NN))|R(?:O(?:C(?:HESTER(?: H(?:IL)?LS)?|K(?:(?:FOR|LAN|WOO)D)?)|"
  "S(?:E(?: CITY|VILLE|BUSH)|COMMON)|(?:GERS CIT|THBUR|DNE)Y|M(?:ULU"
  "S|EO)|YAL OAK|LLIN|OS)|I(?:VE(?:R(?:(?: ROUG|DAL|SID)E|VIEW)|S J("
  "?:UNCTION|CT))|CH(?:(?:LA|MO)ND|VILLE)|(?:DGEWA|LE)Y|GA)|A(?:ISIN"
  "V(?:ILLE|L) TWP|PID (?:RIVER|CITY)|Y(?: TWP)?|VENNA|MSAY|LPH|CO)|"
  "E(?:E(?:D CITY|SE)|PUBLIC|ADING|DFORD|MUS)|U(?:SSELL IS(?:LAND)?|"
  "(?:MEL|B)Y|DYARD|TH)|HODES)|F(?:R(?:E(?:E(?: SOIL|LAND|PORT)|NCHT"
  "OWN|DERIC|MONT)|A(?:NK(?:ENMUTH|FORT|LIN)|SER)|UITPORT|ONTIER)|A("
  "?:R(?:MINGT(?:ON(?: H(?:IL)?LS)?|N HLS)|WELL|GO)|IR(?: HAVEN|GROV"
  "E|VIEW)|LMOUTH)|O(?:R(?:T GRATIOT|ESTVILLE)|ST(?:ER CITY|ORIA)|WL"
  "ER(?:VILLE)?|UNTAIN)|E(?:N(?:NVILLE|WICK|TON)|R(?:RYSBURG|NDALE)|"
  "LCH)|I(?:L(?:ER CITY|ION)|(?:FE LAK|BR)E)|L(?:AT ROCK|USHING|INT)"
  "|ULTON)|A(?:L(?:L(?:E(?:N(?: PARK|DALE|TON)?|GAN)|OUEZ)|(?:ANSO|D"
  "E)N|G(?:ONAC|ER)|B(?:ION|A)|M(?:ONT|A)|P(?:EN|H)A|TO)|U(?: (?:SAB"
  "LE|TRAIN|GRES)|BURN(?: HILLS)?|GUSTA)|T(?:LA(?:NT(?:IC MINE|A)|S)"
  "|HENS|TICA)|D(?:DISON(?: T(?:OWNSHI|W)P)?|RIAN|A)|R(?:(?:CADI|MAD"
  ")A|GYLE|NOLD)|N(?:CHORVILLE|N ARBOR)|(?:ZALI|MAS|VOC)A|(?:PPLEGAT"
  "|CM)E|(?:FT|KR)ON|HMEEK|SHLEY)|N(?:O(?:R(?:T(?:H(?: (?:ST(?:REET|"
  "AR)|LAKEPORT|MUSKEGON|BRANCH|ADAMS)|VILLE(?: T(?:OWNSHIP|W))?|POR"
  "T)|ON SHORES)|VELL|WAY)|TTAWA|VI)|E(?:W(?: (?:B(?:ALTIMORE|UFFALO"
  "|OSTON)|H(?:UDSO|AVE)N|LOTHROP|TROY|ERA)|BERRY|AYGO|PORT)|GAUNEE)"
  "|A(?:TIONAL (?:CITY|MINE)|SHVILLE|UBINWAY|POLEON|ZARETH|DEAU|HMA)"
  "| (?:LAKEPORT|MUSKEGON)|I(?:SULA|LES)|UNICA)|E(?:A(?:ST(?: (?:GRA"
  "ND RA(?:PIDS)?|L(?:ANSING|EROY)|DETROIT|JORDAN|CHINA|TAWAS)|PO(?:"
  "INTE|RT)|LAKE)|GLE(?: (?:HARBO|RIVE)R)?|TON RAPIDS|U CLAIRE)|L(?:"
  "K(?: RAPIDS|TON)|M(?: HALL|IRA)|LSWORTH|BERTA|WELL|SIE)|D(?:(?:EN"
  "VILL|MOR)E|WARDSBURG)|S(?:SEXVILLE|CANABA)|(?:BEN JUNCTIO|WE)N|C("
  "?:KERMAN|ORSE)|(?:NGADIN|RI)E|M(?:METT|PIRE)|UREKA|VART)|D(?:E(?:"
  " (?:TOUR V(?:ILLAG|LL)E|WITT)|ARBORN(?: (?:HEIG)?HTS)?|C(?:KER(?:"
  "VILLE)?|ATUR)|ER(?:FIELD|TON)|(?:TROI|WIT)T|FORD|LTON|XTER)|O(?:W"
  "(?:AGIAC|LING)|DGEVILLE|LLAR BAY|UGLAS|RR)|R(?:UMMOND IS(?:LAND)?"
  "|AYTON PL(?:AI)?NS|YDEN)|A(?:VIS(?:BURG|ON)|NSVILLE|GGETT|FTER)|U"
  "(?:NDEE|RAND|TTON)|IMONDALE)|O(?:AK(?:L(?:AND(?: T(?:OWNSHI|W)P)?"
  "|EY)| (?:GROVE|PARK))|N(?:(?:ONDAG|EKAM)A|TONAGON|AWAY|STED)|R(?:"
  "(?:CHARD LAK|TONVILL)E|LEANS|ION)|T(?:(?:T(?:AWA|ER) LAK|ISVILL)E"
  "|SEGO)|S(?:S(?:INEKE|EO)|HTEMO|CODA)|L(?:D MISSION|IVET)|W(?:ENDA"
  "LE|OSSO)|(?:XFOR|VI)D|ME(?:NA|R)|CQUEOC|KEMOS|DEN)|T(?:R(?:E(?:ET"
  "OPS VIL(?:LAGE)?|N(?:ARY|TON))|O(?:UT (?:CREEK|LAKE)|Y)|A(?:VERSE"
  " CITY|UNIK)|UFANT)|H(?:REE (?:RIVER|OAK)S|OMPSON(?:VILLE)?)|E(?:M"
  "PERANCE|CUMSEH|KONSHA)|U(?:S(?:COLA|TIN)|RNER)|O(?:PINABEE|IVOLA|"
  "WER)|A(?:WAS CITY|YLOR)|WIN(?: LAKE|ING)|IPTON)|K(?:E(?:N(?:T(?: "
  "CITY|WOOD|ON)|OCKEE|DALL)|W(?:EENAW BAY|ADIN)|EGO HARBOR|ARSARGE)"
  "|I(?:N(?:GS(?:FORD|LEY|TON)|(?:CHELO|D)E|ROSS)|MBALL)|A(?:L(?:(?:"
  "KASK|EV)A|AMAZOO)|(?:WKAW|R)LIN))|I(?:N(?:D(?:EPENDENCE|IAN RIVER"
  ")|TERLOCHEN|GALLS|KSTER)|R(?:ON(?: (?:MOUNTAIN|RIVER)|WOOD|S)|A)|"
  "(?:THAC|ONI)A|D(?:LEWILD|A)|MLAY CITY|SHPEMING)|V(?:A(?:N(?:D(?:E"
  "RBILT|ALIA)| BUREN TWP)|SSAR)|E(?:R(?:NON(?: CITY)?|MONTVILLE)|ST"
  "ABURG)|ICKSBURG|ULCAN)|J(?:O(?:NES(?:VILLE)?|HANNESBURG)|A(?:(?:M"
  "ESTOW|CKSO)N|SPER)|E(?:NISON|ROME|DDO))|U(?:NI(?:ON(?: (?:CITY|LA"
  "KE|PIER)|VILLE)?|V(?:ERSITY CENTE| CT)R)|TICA|BLY)|Y(?:PSILANTI|A"
  "LE)|QUIN(?:NESEC|CY)|ZEELAND))))$"
  ,
  /* -- MN -- MN -- MN -- MN -- MN -- MN -- MN -- MN -- MN -- MN -- */
  "(?:\\b)((?^:(?i:(?:S(?:A(?:INT (?:C(?:L(?:AIR|OUD)|HARLES)|P(?:AU"
  "L(?: PARK)?|ETER)|(?:BONIFACIU|FRANCI)S|A(?:NTHONY|UGUSTA)|L(?:OU"
  "IS PARK|EO)|M(?:ICHAEL|ARTIN)|J(?:OSEPH|AMES)|HILAIRE|STEPHEN|VIN"
  "CENT)|U(?:K (?:CENTRE|RAPIDS)|M)|N(?:DSTONE|TIAGO|BORN)|R(?:GEANT"
  "|TELL)|CRED HEART|GINAW|VAGE|WYER|BIN|LOL)|T(?: (?:ANTH(?:ONY(?: "
  "VILLAGE)?|NY VLG)|(?:LOUIS|PAUL) PARK|BONIFACIUS)|A(?:N(?:CHFIELD"
  "|TON)|RBUCK|PLES|CY)|E(?:WART(?:VILLE)?|(?:PH)?EN)|RA(?:NDQUIST|T"
  "HCONA)|O(?:CKTO|RDE)N|URGEON LAKE|ILLWATER)|P(?:RING(?: (?:L(?:AK"
  "E(?: PARK)?|K PK)|VALLEY|GROVE|PARK)|FIELD)|ICER)|O(?:U(?:TH (?:I"
  "NTERNATIONAL FALLS|S(?:AIN)?T PAUL|HAVEN)|DAN)|LWAY)|H(?:E(?:(?:R"
  "BUR|VLI)N|LLY)|A(?:KOPEE|FER)|OREVIEW)|I(?:LVER (?:CREEK|LAKE|BAY"
  ")|DE LAKE)|W(?:A(?:N(?: RIVER|VILLE)|TARA)|IFT)|E(?:A(?:FORTH|RLE"
  "S)|BEKA|DAN)|UN(?:FISH LAKE|BURG)|L(?:EEPY EYE|AYTON)|C(?:HROEDER"
  "|ANDIA)| INTL FALLS|QUAW LAKE|VEA)|B(?:R(?:O(?:O(?:K(?:LYN (?:C(?"
  ":ENTE|T)R|PARK)|S(?:TON)?| PARK)|TEN)|W(?:N(?:S(?:(?:VIL|DA)LE| V"
  "ALLEY)|TON)|ERVILLE))|E(?:CKENRIDGE|EZY POINT|WSTER)|I(?:(?:CELY|"
  "MSO)N|TT)|A(?:INERD|NDON|HAM)|UNO)|E(?:L(?:L(?:E PLAINE|CHESTER|I"
  "NGHAM)|GRADE|TRAMI|VIEW)|A(?:VER (?:CREEK|BAY)|RDSLEY)|N(?:EDICT|"
  "SON|A)|C(?:IDA|KER)|R(?:OUN|THA)|MIDJI|THEL|JOU)|A(?:R(?:N(?:ESVI"
  "LLE|UM)|R(?:ETT|Y))|(?:TTLE LAK|UDETT)E|(?:BBIT|YPOR)T|(?:DG|XT|K"
  ")ER|LATON|CKUS|GLEY)|L(?:O(?:OMING(?: PRAIRIE|TON)|MKEST)|U(?:E E"
  "ARTH|FFTON)|A(?:CKDUCK|INE)|MNG PRAIRIE)|U(?:R(?:NS(?: T(?:OWNSHI"
  "|WNSH)P|VILLE)|TRUM)|FFALO(?: LAKE)?|TTERFIELD|CKMAN|YCK|HL)|I(?:"
  "G(?: (?:FALLS|LAKE)|ELOW|FORK)|R(?:D ISLAND|CHDALE)|NGHAM LAKE|WA"
  "BIK)|O(?:W(?:STRING|LUS)|Y(?: RIVER|D)|RUP|VEY|CK)|YRON)|M(?:A(?:"
  "R(?:I(?:NE (?:ON SAINT CROI|ST CR)X|ETTA)|(?:(?:KVIL|B)L|GI)E|(?:"
  "SHA|CE)LL)|PLE(?: (?:(?:GROV|LAK)E|PLAIN)|WOOD|TON)|N(?:TORVILLE|"
  "CHESTER|KATO)|D(?:ISON(?: LAKE)?|ELIA)|H(?:TO(?:MEDI|WA)|NOMEN)|("
  "?:GNOLI|ZEPP)A|Y(?:NARD|ER)|KINEN|BEL|X)|I(?:N(?:N(?:E(?:T(?:ONKA"
  "(?: (?:BEACH|MILLS))?|NKA (?:BCH|MLS)|RISTA)|SOTA (?:L(?:AKE|K)|C"
  "ITY)|(?:ISK|OT)A|APOLIS)| CITY)|ETONKA (?:BCH|MLS))|L(?:A(?:CA|N)"
  "|LVILLE|TONA|ROY)|DDLE RIVER|ZPAH)|O(?:UN(?:TAIN (?:IRON|LAKE)|D("
  "?:S ?VIEW)?)|NT(?:(?:EVIDE|ICELL)O|GOMERY|ROSE)|R(?:RIS(?:TOWN)?|"
  "(?:GA|TO)N|A)|O(?:SE LAKE|RHEAD)|TLEY)|E(?:N(?:DOTA(?: (?:HEIG)?H"
  "TS)?|AHGA|TOR)|D(?:I(?:CINE LAKE|NA)|FORD)|R(?:RIFIELD|IDEN)|LR(?"
  ":OS|UD)E|ADOWLANDS)|C(?:(?: GRAT|INTOS)H|GREGOR|KINLEY)|URDOCK|YR"
  "TLE)|C(?:O(?:L(?:(?:(?:ERAI|OG)N|LEGEVILL)E|UMB(?:IA (?:HEIG)?HT|"
  "U)S|D SPRING)|TT(?:ON(?:WOOD)?|AGE GROVE)|M(?:STOCK|FREY)|O(?:N R"
  "APIDS|K)|R(?:CORAN|RELL)|URTLAND|HASSET|BDEN|KATO|NGER|SMOS)|L(?:"
  "AR(?:K(?:S GROVE|FIELD)|A CITY|EMONT|ISSA)|E(?:AR(?: LAKE|BROOK|W"
  "ATER)|VELAND|MENTS)|I(?:THERALL|NTON|MAX)|O(?:NTARF|QUET))|A(?:R("
  "?:L(?:ISLE|TON|OS)|VER)|N(?:NON FALLS|[TY]ON|BY)|L(?:EDONIA|LAWAY"
  "|UMET)|S(?:TLE ROCK|S LAKE)|M(?:BRIDGE|PBELL))|R(?:O(?:S(?:SLAKE|"
  "BY)|WN COLLEGE|OKSTON|MWELL)|YSTAL(?: BAY)?|ANE LAKE)|H(?:A(?:N(?"
  ":HASSEN|DLER)|TFIELD|MPLIN|SKA)|IS(?:AGO CITY|HOLM)|OKIO)|E(?:DAR"
  "(?: E(?:AST BETHE| BETH)L)?|NTER(?: CITY|VILLE)|YLON)|U(?:SHING|L"
  "VER|RRIE)|(?:IRCLE PINE|YRU)S)|W(?:A(?:L(?:T(?:ERS|HAM)|NUT GROVE"
  "|DORF|KER)|T(?:ER(?:VILLE|TOWN)|KINS|SON)|(?:(?:DE|WI)N|CONI|YZAT"
  ")A|N(?:(?:NASK|D)A|AMINGO)|R(?:R(?:OAD|EN)|SAW|BA)|S(?:KISH|ECA)|"
  "(?:HKO|UBU)N|BAS(?:HA|SO)|ITE PARK|VERLY)|I(?:L(?:L(?:(?:OW RIVE|"
  "MA)R|ERNIE|IAMS)|MONT|DER|TON)|N(?:T(?:HROP|ON)|NEBAGO|STED|DOM|G"
  "ER|ONA)|RT)|E(?:ST(?: (?:(?:LAKELAN|CONCOR)D|S(?:AIN)?T PAUL|UNIO"
  "N)|BROOK)|L(?:C(?:OME|H)|LS)|BSTER|NDELL)|H(?:I(?:TE (?:BEAR (?:T"
  "(?:OWNSHI)?P|L(?:AKE|K))|EARTH)|PHOLT)|(?:EATO|ALA)N)|O(?:OD(?: L"
  "AKE|STOCK|BURY)|L(?:F LAKE|VERTON)|RTHINGTON)| (?:S(?:AIN)?T PAUL"
  "|LAKELAND)|R(?:ENSHALL|IGHT)|Y(?:OMING|KOFF))|L(?:A(?:KE(?: (?:(?"
  ":(?:B(?:RONS|ENT)|WILS)O|LILLIA)N|(?:GEORG|SHOR)E|C(?:RYSTAL|ITY)"
  "|HUBERT|ITASCA|ELMO|PARK)|(?:FIEL|LAN)D|VILLE)|N(?:DFALL V(?:ILLA"
  "GE|LG)|CASTER|ESBORO|SING)|(?:(?:FAYET|POR)T|UDERDAL)E| (?:CRESCE"
  "NT|SALLE)|MBERTON|STRUP)|I(?:T(?:TLE(?: (?:(?:MARAI|FALL)S|CANADA"
  "|SAUK)|FORK)|CHFIELD)|N(?:O LAKES|DSTROM)|SMORE)|E(?: (?:(?:CENTE"
  "|SUEU)R|ROY)|STER PR(?:AIRIE)?|WIS(?:VILLE|TON)|O(?:NARD|TA)|NGBY"
  ")|O(?:N(?:(?:G(?: (?:PRAIRI|LAK)|VILL)|SDAL)E|DON)|UISBURG|CKHART"
  "|RETTO|MAN|WRY)|U(?:(?:TSE|CA)N|VERNE)|Y(?:LE|ND))|H(?:A(?:M(?: L"
  "AKE|BURG|MOND|PTON|EL)|N(?:LEY FALLS|COCK|OVER|SKA)|R(?:DWICK|TLA"
  "ND|MONY|RIS)|(?:Y(?:FIEL|WAR)|TFIEL)D|L(?:LOCK|STAD|MA)|W(?:ICK|L"
  "EY)|CKENSACK|ZEL RUN|STINGS|DLEY)|O(?:L(?:L(?:AND(?:ALE)?|OWAY)|D"
  "INGFORD|MES CITY|YOKE|T)|(?:FFMA|USTO)N|P(?:KINS|E)|WARD LAKE|YT "
  "LAKES|VLAND|KAH|MER)|E(?:N(?:D(?:R(?:ICKS|UM)|ERSON)|RIETTE|NING)"
  "|R(?:MA(?:NTOW)?N|ON LAKE)|IDELBERG|CTOR|WITT)|I(?:LL(?: CITY|MAN"
  "|TOP|S)|N(?:CKLEY|ES)|TTERDAL|BBING)|U(?:TCHINSON|MBOLDT|NTLEY|GO"
  "))|R(?:O(?:C(?:K(?: CREEK|VILLE|FORD)|HE(?:STER|RT))|S(?:E(?: CRE"
  "EK|MOUNT|VILLE|AU)|COE|S)|(?:BBINSDAL|UND LAK)E|LL(?:INGSTONE|AG)"
  "|OSEVELT|YALTON|THSAY|GERS)|E(?:D(?: (?:LAKE FALLS|WING)|WOOD FAL"
  "LS|LAKE|BY)|A(?:DS LAN)?DING|(?:NVILL|VER)E|MER)|U(?:S(?:H(?:FORD"
  "(?: V(?:ILLAGE|LG))?| CITY|MORE)|SELL)|T(?:LEDGE|HTON))|A(?:N(?:D"
  "(?:OLPH|ALL)|IER)|Y(?:MOND)?|CINE|DIUM|MSEY)|I(?:C(?:H(?:(?:FIEL|"
  "MON|WOO)D|VILLE)|E)|VERTON)|L FALLS)|N(?:E(?:W(?: (?:(?:(?:BRIGHT"
  "|LOND)O|AUBUR)N|M(?:ARKET|UNICH)|YORK M(?:IL)?LS|(?:PRAGU|HOP)E|R"
  "ICHLAND|GERMANY|ULM)|FOLDEN|PORT)|RSTRAND|TT LAKE|LSON|VIS)|O(?:R"
  "(?:TH(?: (?:S(?:AIN)?T PAUL|MANKATO|REDWOOD|BRANCH|OAKS)|FIELD|OM"
  "E|ROP)|WOOD(?: YOUNG AMERICA)?|CROSS)|(?: OAK|YE)S)|A(?:S(?:H(?:W"
  "AUK|UA)|SAU)|YTAHWAUSH|VARRE)|I(?:ELSVILLE|COLLET|MROD|SSWA)| SAI"
  "NT PAUL|YA)|G(?:R(?:A(?:N(?:D(?: (?:M(?:ARAIS|EADOW)|PORTAGE|RAPI"
  "DS)|Y)|ITE FALLS|ADA|GER)|CEVILLE|SSTON)|E(?:EN(?:W(?:AL|OO)D| IS"
  "LE|BUSH)|Y EAGLE)|OVE CITY|YGLA)|O(?:OD(?:(?:RIDG|HU)E| THUNDER|L"
  "AND|VIEW)|LDEN VALLEY|NVICK)|A(?:R(?:(?:DEN CIT)?Y|(?:RISO|VI)N|F"
  "IELD)|YLORD|TZKE)|L(?:EN(?:(?:VILL|CO)E|WOOD)|YNDON)|I(?:L(?:BERT"
  "|MAN)|BBON)|E(?:ORGETOWN|NEVA)|HE(?:EN|NT)|ULLY)|P(?:E(?:(?:L(?:I"
  "CAN)? RAPID|QUOT LAKE)S|N(?:N(?:INGTON|OCK)|GILLY|CER)|(?:MBERT|T"
  "ERS)ON|R(?:HAM|LEY)|ASE)|I(?:NE(?: (?:SPRINGS|ISLAND|RIVER|CITY)|"
  "WOOD)|PESTONE|LLAGER|ERZ|TT)|A(?:RK(?:ERS PR(?:AIRIE)?| RAPIDS|VI"
  "LLE)|(?:YNESVILL|LISAD)E)|R(?:I(?:N(?:CETON|SBURG)|OR LAKE)|ESTON"
  "|OCTOR)|L(?:A(?:INVIEW|TO)|YMOUTH|UMMER)|O(?:N(?:SFORD|EMAH)|RTER"
  ")|UPOSKY)|E(?:L(?:L(?:ENDALE|SWORTH)|K(?: RIVER|TON|O)|(?:BOW LAK"
  "|MOR)E|Y(?:SIAN)?|IZABETH|DRED|ROSA|GIN)|A(?:ST(?: (?:G(?:RAND FO"
  "RKS|ULL LAKE)|BETHEL)|ON)|G(?:LE (?:BEND|LAKE)|AN))|D(?:EN (?:PRA"
  "IRIE|VALLEY)|GERTON|INA)| G(?:RAND FORKS|ULL LAKE)|M(?:(?:BARRAS|"
  "MON)S|ILY)|V(?:AN(?:SVILLE)?|ELETH)|R(?:SKINE|HARD)|S(?:SIG|KO)|X"
  "CELSIOR|ITZEN|UCLID|FFIE|YOTA|CHO)|F(?:O(?:R(?:T (?:SNELLING|RIPL"
  "EY)|EST(?: LAKE|ON)|BES)|(?:UNTAI|SSTO)N|XHOME|LEY)|A(?:R(?:MINGT"
  "ON|IBAULT|WELL)|LCON H(?:EIGH|G)TS|IR(?:MONT|FAX))|R(?:EE(?:BORN|"
  "PORT)|A(?:NKLIN|ZEE)|O(?:NTENAC|ST)|IDLEY)|E(?:R(?:GUS FALLS|TILE"
  ")|DERAL DAM|LTON)|I(?:NLA(?:YSON|ND)|FTY LAKES|SHER)|L(?:O(?:ODWO"
  "OD|RENCE|M)|ENSBURG)|ULDA|DCI)|A(?:L(?:B(?:ERT(?:(?: LE)?A|VILLE)"
  "|ANY|ORN)|(?:EXANDRI|TUR|PH)A|D(?:RICH|EN)|MELUND|VARADO)|N(?:G(?"
  ":LE INLET|ORA|US)|NANDALE|DOVER|OKA)|R(?:DEN HILLS|LINGTON|GYLE|C"
  "O)|D(?:A(?:MS)?|OLPH|RIAN)|U(?:(?:DUBO|STI)N|RORA)|PPLE(?: VALLEY"
  "|TON)|(?:ITKI|FTO)N|M(?:IRET|BOY)|H GWAH CHING|S(?:HBY|KOV)|VO(?:"
  "CA|N)|TWATER|KELEY)|D(?:E(?:ER(?: (?:CREEK|RIVER)|WOOD)|L(?:A(?:V"
  "AN|NO)|LWOOD|HI)|N(?:NISON|T)|TROIT LAKES| GRAFF|XTER)|A(?:N(?:VE"
  "RS|UBE)|R(?:FUR|WIN)|(?:WS|YT)ON|L(?:TON|BO)|KOTA|SSEL)|U(?:LUTH("
  "?: FEDERAL PRISON)?|N(?:D(?:AS|EE)|NELL)|QUETTE|MONT)|O(?:(?:DGE "
  "CENT|WN)ER|N(?:ALDSON|NELLY)|V(?:RAY|ER)|RAN)|LTH FED PRIS|ILWORT"
  "H)|O(?:AK(?: (?:PARK(?: H(?:EIGH|G)?TS)?|ISLAND|GROVE)|DALE|LAND)"
  "|R(?:ON(?:OC)?O|TONVILLE|LEANS|MSBY|R)|S(?:A(?:KIS|GE)|(?:SE|L)O|"
  "TRANDER)|T(?:(?:ISC|SEG)O|TERTAIL)|(?:(?:LIV|NAM)I|WATONN)A|G(?:I"
  "LVIE|EMA)|K(?:ABENA|LEE)|D(?:ESSA|IN)|UTING)|T(?:A(?:(?:LMO|UNT)O"
  "N|YLORS FALLS|CONITE|MARACK|OPI)|W(?:I(?:N (?:VALLEY|LAKES)|G)|O "
  "HARBORS)|H(?:IEF R(?:IVER FAL|VR F)LS|EILMAN)|R(?:A(?:CY|IL)|IMON"
  "T|OSKY|UMAN)|O(?:IVOLA|FTE|WER|GO)|(?:URTLE RIV|YL)ER|EN(?:STRIKE"
  "|NEY)|INTAH)|K(?:E(?:N(?:(?:SINGT|Y)ON|NE(?:DY|TH)|T)|L(?:L(?:Y L"
  "AKE|IHER|OGG)|SEY)|R(?:KHOVEN|RICK)|TTLE RIVER|EWATIN)|A(?:N(?:AR"
  "ANZ|DIYOH)I|S(?:OTA|SON)|BETOGAMA|RLSTAD)|I(?:N(?:GSTON|NEY)|LKEN"
  "NY|ESTER|MBALL)|(?:NIFE RIV|LOSSN)ER)|V(?:E(?:R(?:N(?:ON CENTER|D"
  "ALE)|MILLION|GAS|DI)|S(?:ELI|TA))|I(?:(?:(?:CTOR|RGIN)I|OL)A|[KN]"
  "ING|LLARD)|ADNAIS (?:HEIG)?HTS)|I(?:N(?:T(?:ERNATIONA)?L FALLS|VE"
  "R GROVE(?: HEIGHTS)?|DEPENDENCE)|S(?:A(?:BELLA|NTI)|LE)|(?:R(?:ON"
  "T)?O|HLE)N|VANHOE|ONA)|J(?:A(?:C(?:OB|K)SON|NESVILLE|SPER)|E(?:FF"
  "ER|NKIN)S|O(?:HNSO|RDA)N)|Z(?:UMBRO(?: FALLS|TA)|IM(?:MERMAN)?)|U"
  "(?:(?:PSAL|TIC)A|NDERWOOD|LEN)|YOUNG AMERICA))))$"
  ,
  /* -- MO -- MO -- MO -- MO -- MO -- MO -- MO -- MO -- MO -- MO -- */
  "(?:\\b)((?^:(?i:(?:C(?:A(?:R(?:(?:T(?:ERVILL|HAG)|UTHERSVI?LL)E|("
  "?:L JUNCTI|ROLLT)ON|DWELL)|P(?:E (?:GIRARDEAU|FAIR)|LINGER M(?:IL"
  ")?LS)|M(?:DEN(?: POINT|TON)?|PBELL|ERON)|L(?:(?:IFOR|EDO)NIA|HOUN"
  "|LAO)|I(?:NSVILLE|RO)|S(?:SVILL|CAD)E|T(?:AWISSA|RON)|N(?:ALOU|TO"
  "N)|ULFIELD|BOOL|DET)|O(?:N(?:C(?:EP(?:TION JUNC)?TION|ORDIA)|RAN|"
  "WAY)|(?:(?:TTLE|ATS)VILL|MMERC)E|L(?:E CAMP|UMBIA|LINS)|O(?:K STA"
  "|TER)|R(?:NING|DER)|U(?:RTOIS|CH)|(?:FFE|SB)Y|WGILL)|H(?:E(?:R(?:"
  "(?:OKEE HOMESTEAD VILLAG|RYVILL)E|KEE HMSTD)|ST(?:NUTRIDGE|ERFIEL"
  "D))|A(?:RLESTON|DWICK|FFEE|MOIS)|IL(?:LICOTH|HOWE)E|ULA)|L(?:A(?:"
  "R(?:K(?:S(?:(?:VIL|DA)LE|BURG)|TON)?|ENCE)|YTON)|I(?:MAX SPR(?:IN"
  ")?GS|FTON HILL|NTON)|E(?:VE(?:LAND|R)|ARMONT)|UBB|YDE)|R(?:E(?:VE"
  " COEUR|IGHTON|SCENT)|O(?:SS TIMBERS|CKER)|YSTAL (?:LAKES|CITY)|A("
  "?:IG|NE))|E(?:NT(?:ER(?:VI(?:LLE|EW)|TOWN)?|RALIA)|DAR(?: (?:CITY"
  "|HILL)|CREEK))|U(?:RRYVILLE|BA)|PE GIRARDEAU|NCPTON JCTN)|S(?:A(?"
  ":INT(?: (?:C(?:ATHARINE|HARLES|LAIR)|P(?:A(?:TRICK|UL)|ETERS)|(?:"
  "THOMA|LOUI)S|J(?:OSEPH|AMES)|A(?:LBANS|NN)|ELIZABETH|ROBERT|MARY)"
  "|E GENEVIEVE)|(?:DDLEBROOK|NTA F|RCOXI)E|V(?:ANNAH|ERTON)|L(?:ISB"
  "URY|EM)|PPINGTON|GINAW)|T(?:E(?:(?:(?:WARTS|FFEN)VILL| GENEVIEV)E"
  "|E(?:(?:LVIL)?LE|DMAN)|LLA|T)|O(?:T(?:TS CIT|ESBUR)Y|UT(?:SVILLE|"
  "LAND)|CKTON|VER)| (?:CATHARINE|ELIZABETH|PETERS)|A(?:N(?:BERRY|TO"
  "N)|RK CITY)|RA(?:FFORD|SBURG)|UR(?:DIVANT|GEON))|U(?:L(?:PHUR SP("
  "?:RINGS|G)|LIVAN)|M(?:MERSVILLE|NER)|NRISE BEACH|GAR CREEK|CCESS)"
  "|O(?:U(?:TH (?:WEST C(?:IT)?Y|GREENFIELD|FORK)|DER)|LO)|E(?:D(?:G"
  "EWICKVI?LLE|ALIA)|N(?:ATH|ECA)|LIGMAN|YMOUR)|H(?:E(?:L(?:B(?:YVIL"
  "LE|INA)|L KNOB|DON)|RIDAN)|OOK)|P(?:(?:RINGFIEL|ICKAR)D|OKANE|ART"
  "A)|C(?:O(?:TT CITY|PUS)|HELL CITY)|(?:Y(?:CAMOR|RACUS)|KIDMOR)E|I"
  "(?:L(?:EX|VA)|KESTON|BLEY)|WE(?:ET SPRINGS|DEBORG)|MITH(?:VILLE|T"
  "ON)| GREENFIELD|QUIRES|LATER)|B(?:R(?:A(?:N(?:SON(?: WEST)?|DSVIL"
  "LE)|GG(?:ADOCIO| CITY)|(?:SHEA|YME)R|DLEYVILLE|ZEAU)|O(?:OK(?:LIN"
  "E(?: STA)?|FIELD)|WN(?:WOOD|ING)|NAUGH|SELEY)|E(?:CK(?:ENRIDGE(?:"
  " HILLS)?|NRDG HLS)|NTWOOD)|I(?:(?:(?:(?:DGE|GH)T|MS)O|NKTOW)N|XEY"
  "|AR)|U(?:N(?:SWICK|ER)|MLEY)|LNGTON JCTN)|E(?:L(?:L(?:E(?:VIEW)?|"
  "FLOWER| CITY)|GRADE|TON)|R(?:KELEY|RYMAN|TRAND|GER|NIE)|N(?:TON(?"
  ": CITY)?|DAVIS)|TH(?:ANY|EL)|AUFORT|ULAH|VIER)|L(?:A(?:CK(?:W(?:A"
  "TER|ELL)|BURN)?|IRSTOWN|ND)|O(?:OM(?:FIELD|SDALE)|DGETT)|UE (?:SP"
  "RINGS|EYE)|YTHEDALE)|U(?:R(?:LINGTON JUNCTION|FORDVILLE)|C(?:K(?:"
  "LIN|NER)|YRUS)|T(?:TERFIELD|LER)|N(?:CETON|KER)|FFALO|ELL)|O(?:NN"
  "(?:OTS MILL|E TERRE)|(?:WLING GREE|URBO)N|L(?:CKOW|IVAR)|S(?:WORT"
  "H|S)|IS D ARC|ONVILLE|GARD)|A(?:R(?:N(?:(?:HAR|ET)T|ARD)|ING)|T(?"
  ":TLEFIELD|ES CITY)|KERSFIELD|LLWIN)|I(?:R(?:CH TREE|MINGHAM)|LLIN"
  "GS|SMARCK|GELOW|XBY))|M(?:A(?:R(?:T(?:IN(?:S(?:VILLE|BURG)| CITY)"
  "|HASVILLE)|Y(?:LAND (?:HEIG)?HTS|VILLE)|S(?:H(?:FIELD|ALL)|TON)|V"
  "EL CAV(?:E PAR| P)K|(?:IONVILL|CELIN)E|BLE HILL|QUAND)|C(?:O(?:MB"
  "|N)|KS CREEK)|Y(?:SVILLE|VIEW|WOOD)|N(?:CHESTER|SFIELD)|P(?:AVILL"
  "E|LEWOOD)|L(?:TA BEND|DEN)|ITLAND|TTHEWS|DISON)|O(?:UN(?:T(?: (?:"
  "STERLING|MORIAH|VERNON)|AIN (?:GR(?:OVE|V)|VIEW))|D(?: CITY|VILLE"
  "))|N(?:T(?:GOMERY C(?:IT)?Y|I(?:CELLO|ER)|R(?:EAL|OSE))|ROE CITY|"
  "ETT)|R(?:RIS(?:VILLE|ON)|SE MILL|EHOUSE|LEY|A)|S(?:COW MILLS|BY)|"
  "O(?:RESVILLE|DY)|BERLY|KANE)|I(?:L(?:L(?:ER(?:SVILLE)?| SPRING|CR"
  "EEK)|FORD|AN|O)|N(?:E(?:R(?:AL POINT)?| LA MOTTE|OLA)|DENMINES)|D"
  "DLE(?: BROOK|TOWN)|SSOURI CITY|AMI)|E(?:R(?:RIAM (?:WOODS VILLAGE"
  "|VLG)|CER)|ADVILLE|MPHIS|T[AZ]|NDON|XICO)|C(?: (?:G(?:IRK|EE)|BRI"
  "DE|CLURG|FALL)|KITTRICK)|T STERLING|YRTLE)|L(?:A(?:KE (?:S(?:(?:A"
  "IN)?T LOUIS|HERWOOD|PRING)|W(?:INNEBAGO|AUKOMIS)|TAPA?WINGO|LOTAW"
  "ANA|ANNETTE|OZARK)| (?:(?:GRANG|BELL|MONT)E|RUSSELL|PLATA)|M(?:BE"
  "RT A(?:IRPO|RP)RT|AR|PE)|(?:(?:BAD|UR)I|CLED)E|T(?:H(?:ROP|AM)|OU"
  "R)|N(?:CASTER|AGAN)|DDONIA|QUEY|REDO|WSON)|E(?:A(?:D(?:INGTON|WOO"
  "D)|SBURG)|(?:(?:XINGT|BAN)O|WISTOW)N|E(?:S SUMMIT|TON)|S(?:TERVIL"
  "L|LI)E|O(?:NAR|POL)D|N(?:TNER|OX)|(?:VAS|MA)Y|COMA)|O(?:N(?:E(?: "
  "JACK|DELL)|G LANE)|CK(?: SPRINGS|WOOD)|W(?:RY CITY|NDES)|UIS(?:BU"
  "RG|IANA)|OSE CREEK|MA LINDA|HMAN|DI)|I(?:N(?:N(?: CREEK|EUS)?|COL"
  "N)|BER(?:AL|TY)|LBOURN|CKING|GUORI|VONIA)|U(?:(?:TESVILL|CERN)E|E"
  "BBERING|DLOW|RAY)|K WINNEBAGO|YNCHBURG)|W(?:E(?:S(?:T(?: (?:PLAIN"
  "S|ALTON|LINE)|PHALIA|BORO|ON)|CO)|L(?:L(?:INGTON|SVILLE)|DON SPRI"
  "NG)|B(?:STER GR(?:OVE|V)S|B CITY)|A(?:THERBY(?: LAKE)?|UBLEAU)|NT"
  "(?:ZVILLE|WORTH))|A(?:L(?:NUT (?:GROV|SHAD)E|DRON|KER)|R(?:REN(?:"
  "SBURG|TON)|DELL|SAW)|S(?:H(?:INGTO|BUR)N|OLA)|Y(?:NESVILLE|LAND)|"
  "(?:PPAPELL|C)O|VERLY|TSON)|I(?:L(?:L(?:IAMS(?:VILLE|BURG|TOWN)|OW"
  " SP(?:RIN)?GS|ARD)|DWOOD)|N(?:D(?:YVILLE|SOR)|(?:IGA|STO)N|FIELD|"
  "ONA)|TTENBERG)|H(?:ITE(?:MAN A(?:IR FORCE BASE|FB)|WATER|SIDE|OAK"
  ")|E(?:AT(?:LAND|ON)|ELING))|O(?:O(?:D HEIGHTS|LDRIDGE)|RTH(?:INGT"
  "ON)?|LF ISLAND)|YA(?:CONDA|TT)|RIGHT CITY|THRBY LAKE)|P(?:O(?:RT("
  "?:AGE(?: DES SIOUX|VILLE)|LAND)|WE(?:RS(?:VILL|IT)E|LL)|N(?:CE DE"
  " LEON|TIAC)|T(?:TERSVILLE|OSI)|L(?:(?:LOC)?K|O)|INT LOOKOUT|PLAR "
  "BLUFF|CAHONTAS|MONA|YNOR)|A(?:R(?:K(?: HILLS|VILLE)|NELL|IS|MA)|T"
  "T(?:ON(?:SBURG)?|ERSON)|S(?:COLA|SAIC)|YNESVILLE|CIFIC|INTON|LMYR"
  "A)|L(?:E(?:ASANT (?:H(?:ILL|OPE)|V(?:ALLE|L)Y)|VNA)|AT(?:T(?:E (?"
  ":WOODS|CITY)|SBURG)|O))|I(?:E(?:RCE CITY|DMONT)|(?:CKERIN|TTSBUR)"
  "G|LOT (?:GROVE|KNOB)|NEVILLE)|R(?:TG DE S(?:IOU|OUI)X|(?:INCE|ES)"
  "TON|AIRIE HOME|OTEM)|E(?:R(?:RY(?:VILLE)?|KINS)|(?:ACE VALLE|VEL)"
  "Y|CULIAR)|U(?:R(?:D(?:IN|Y)|CELL)|XICO)|HIL(?:ADELPHIA|LIPSBURG))"
  "|H(?:A(?:R(?:T(?:S(?:BURG|HORN)|VILLE)|RIS(?:ONVILLE|BURG)?|D(?:E"
  "NVILLE|IN)|VIELL|WOOD)|L(?:L(?:SVILLE|TOWN)|F WAY|E)|(?:ZELWOO|TF"
  "IEL)D|YTI(?: HEIGHTS)?|WK POINT|MILTON|NNIBAL)|O(?:L(?:L(?:I(?:ST"
  "ER|DAY)|AND)|(?:TS SUMMI)?T|COMB|DEN)|US(?:TON(?: LAKE|IA)?|E SPR"
  "INGS)|MEST(?:EAD VLG|OWN)|R(?:NERSVILLE|TON)|PKINS)|U(?:M(?:(?:AN"
  "SVILL)?E|PHREYS)|N(?:TSVILLE|NEWELL)|G(?:HESVILLE|GINS)|R(?:DLAND"
  "|LEY))|I(?:G(?:H(?: (?:POINT|RIDGE|HILL)|LANDVILLE)|(?:GINSVILL|B"
  "E)E)|LLSBORO|RAM)|E(?:R(?:M(?:ITAGE|ANN)|CULANEUM)|N(?:RIETTA|LEY"
  ")|M(?:ATIT|PL)E|LENA))|G(?:R(?:A(?:N(?:D(?: PASS|VIEW|IN)|(?:T CI"
  "T|B)Y|GER)|Y(?: SUMMIT|RIDGE)|(?:IN VALLE|SS)Y|VOIS MILLS|HAM|FF)"
  "|EEN(?: (?:C(?:ASTLE|ITY)|RIDGE)|(?:FIEL|WOO)D|VILLE|TOP)|OVE(?:S"
  "PRING|R)|UBVILLE)|A(?:(?:INESVILL|SCONAD)E|R(?:DEN CITY|RISON)|L("
  "?:LATIN|ENA|T)|TEWOOD)|O(?:R(?:DONVILLE|IN)|LDEN(?: CITY)?|OD(?:M"
  "A|SO)N|(?:BL|W)ER)|L(?:EN(?:ALLEN|WOOD|COE)|A(?:DSTONE|SGOW)|OVER"
  ")|I(?:L(?:MAN CITY|LIAM)|B(?:SON|BS)|DEON|PSY)|E(?:NTRY|RALD)|UIL"
  "FORD)|F(?:R(?:E(?:NCH V(?:ILLAGE|LG)|(?:ISTAT|MON)T|E(?:BURG|MAN)"
  "|DERICKTOWN)|ANK(?:CLAY|FORD|LIN)|O(?:NTENAC|HNA)|IEDHEIM)|A(?:IR"
  "(?: (?:GROVE|PLAY)|DEALING|PORT|VIEW|FAX)|R(?:(?:BE|RA)R|MINGTON|"
  "LEY)|UCETT|YETTE|LCON|GUS)|O(?:R(?:T(?: LEONARD WOOD|ESCUE|UNA)|E"
  "ST CITY|ISTELL|DLAND|SYTH)|UR SEASONS|STER|LEY)|L(?:OR(?:I(?:SSAN"
  "T|DA)|ENCE)|E(?:MINGTON|TCHER)|AT RIVER|INTHILL)|E(?:R(?:RELVIEW|"
  "GUSON)|NTON|STUS)|I(?:LLMORE|SK)|T LEONARD WD|ULTON)|R(?:O(?:C(?:"
  "K(?:(?:Y (?:COMFOR|MOUN)| POR)T|(?:BRIDG|VILL)E|AWAY B(?:EA)?CH)|"
  "HEPORT)|S(?:E(?:NDALE|BUD)|COE)|(?:GERS|TH)VILLE|B(?:ERTSVILLE|Y)"
  "|MBAUER|ACH|LLA)|I(?:CH(?:MOND(?: (?:HEIG)?HTS)?|(?:WOO|AR)DS| HI"
  "LL|LAND)|VE(?:R(?:MINES|SIDE)|S)|DGE(?:DALE|WAY)|SCO)|A(?:Y(?:(?:"
  "MO(?:NDVILL|R)|VILL)E|TOWN)|VENWOOD|NDOLPH|CINE)|E(?:EDS(?: SPRIN"
  "G)?|PUBLIC|YNOLDS|DFORD|NICK|VERE|A)|U(?:S(?:H(?: HILL|VILLE)|SEL"
  "LVILLE)|TLEDGE|ETER)|HINELAND)|N(?:E(?:W(?: (?:B(?:LOOMF(?:IE)?LD"
  "|OSTON)|HA(?:(?:MPTO|VE)N|RTFORD)|F(?:LORENCE|RANKLIN)|M(?:ADRID|"
  "ELLE)|OFFENBURG|CAMBRIA|LONDON|POINT|WELLS)|TO(?:NIA|WN)|BURG|ARK"
  ")|ELYVILLE|CK CITY|LSON|OSHO|VADA)|O(?:R(?:TH(?: (?:KANSAS CI|COU"
  "N)TY|WEST PLAZA|MOOR)|BORNE|MANDY|WOOD)|(?:TTINGHIL|E)L|V(?:INGER"
  "|ELTY)|BLE)|A(?:P(?:OLE|T)ON|YLOR)|W P(?:LAZA|OINT)| KANSAS CITY|"
  "I(?:ANGU|X)A)|E(?:L(?:L(?:I(?:SVILLE|NGTON)|SINORE)| DORADO SP(?:"
  "RINGS|G)|K(?: CREEK|LAND)|D(?:RIDGE|ON)|M(?:IRA|ER|O)|SBERRY|VINS"
  ")|X(?:C(?:EL(?:SIOR (?:SP(?:RINGS|G)|EST)|LO)|LSOR SPRGS)|ETER)|A"
  "(?:ST(?: (?:PRAIRI|LYNN)E|ON)|GLE(?: ROCK|VILLE)|RTH CITY)|D(?:G("
  "?:AR SPRINGS|ERTON)|WARDS|INA)|U(?:(?:DOR|REK)A|(?:GEN|NIC)E)|M(?"
  ":INENCE|DEN|MA)|T(?:TERVILLE|HEL)|VERTON|OLIA|SSEX|WING)|A(?:L(?:"
  "T(?:ENBURG|AMONT|ON)|LEN(?:DALE|TON)|(?:EXANDRI|M)A|BA(?:NY)?|DRI"
  "CH)|R(?:C(?:(?:ADI|OL)A|HIE)|B(?:ELA|YRD)|ROW ROCK|MSTRONG|GYLE|N"
  "OLD|AB)|N(?:N(?:A(?:POLIS|DA)|ISTON)|DERSON|TONIA|ABEL)|S(?:H(?: "
  "GROVE|BURN|LAND)|BURY)|U(?:(?:GUST|ROR)A|XVASSE|STIN)|M(?:STERDAM"
  "|AZONIA|ORET|ITY)|V(?:A(?:LON)?|ONDALE|ILLA)|(?:PPLETON CIT|GENC)"
  "Y|D(?:VANCE|RIAN)|TLANTA|FFTON)|D(?:E(?:E(?:R(?:FIELD|ING)|PWATER"
  ")|S(?: (?:PERES|ARC)|LOGE)| (?:KALB|SOTO|WITT)|(?:NV|XT)ER|VILS E"
  "LBOW|ARBORN|FIANCE|LTA)|A(?:R(?:DENNE PR(?:AIRIE)?|LINGTON)|(?:VI"
  "S|DE|N)VILLE|(?:LTO|W)N|ISY)|U(?:(?:GGINSVILL|K)E|T(?:CHTOWN|ZOW)"
  "|NNEGAN|ENWEG|DLEY|RHAM)|O(?:(?:NIPHA|E RU)N|WNING|VER|RA)|I(?:AM"
  "OND|GGINS|TTMER|XON)|R(?:EXEL|URY))|K(?:I(?:N(?:G(?:S(?:VILLE|TON"
  ")|(?:DOM)? CITY)|LOCH)|M(?:BERLING C(?:IT)?Y|MSWICK)|R(?:K(?:SVIL"
  "LE|WOOD)|BYVILLE)|SSEE MILLS|DDER)|E(?:(?:YTESVILL|WANE)E|ARNEY|N"
  "NETT|LSO)|NO(?:B (?:NOSTER|LICK)|X CITY)|A(?:NSAS CITY|HOKA|ISER)"
  "|O(?:ELTZTOWN|SHKONONG))|T(?:R(?:I(?:PLETT|MBLE)|E(?:LOAR|NTON)|U"
  "XTON|OY)|H(?:O(?:RNFIELD|MPSON)|EODOSIA|AYER)|A(?:LLAPOOSA|NEYVIL"
  "LE|RKIO|YLOR)|U(?:RNE(?:RS|Y)|SCUMBIA|NAS)|E(?:BBETTS|CUMSEH|RESI"
  "TA)|I(?:FF(?: CITY)?|PTON|NA)|W(?:N AND CNTRY|IN OAKS)|OWN AND CO"
  "UNTRY)|V(?:I(?:LLA(?:GE OF (?:FOUR SEASONS|LOCH LLOYD)| RIDGE)|(?"
  ":ENN|ST)A|BURNUM|CHY)|A(?:N(?:D(?:ALIA|USER)| BUREN|ZANT)|LLE(?:S"
  " MINES|Y PARK))|LG (?:LOCH LOYD|OF 4 SSNS)|ER(?:SAILLES|ONA)|ULCA"
  "N)|O(?:L(?:D(?: (?:APPLETON|MONROE)|FIELD)|IVETTE|EAN|NEY)|(?:AK "
  "(?:GROV|RIDG)|WENSVILL)E|R(?:(?:EGO|A)N|ONOGO|RICK)|S(?:AGE BEACH"
  "|CEOLA|BORN)|TT(?:ERVILLE|O)| FALLON|VERLAND|DESSA|ZARK|XLY)|J(?:"
  "E(?:R(?:ICO SPR(?:IN)?GS|OME)|N(?:NING|KIN)S|FFERSON CI?TY)|A(?:M"
  "ES(?:(?:TOW|O)N|PORT)|CKSON(?:VILLE)?|DWIN|SPER|NE)|O(?:NESBURG|P"
  "LIN))|U(?:NI(?:ON(?: STAR|VILLE|TOWN)?|VERSITY C(?:IT)?Y|TY VILLA"
  "GE)|R(?:BANA|ICH)|DALL|LMAN|TICA)|I(?:(?:(?:BER|ON)I|SABELL|ANTH)"
  "A|N(?:DEPENDENCE|NSBROOK)|R(?:ON(?:DALE|TON)|WIN)|MPERIAL)|QU(?:I"
  "(?:TMAN|NCY)|EEN CITY|LIN)|ZA(?:NONI|LMA)|YUKON))))$"
  ,
  /* -- MP -- MP -- MP -- MP -- MP -- MP -- MP -- MP -- MP -- MP -- */
  "(?:\\b)((?^:(?i:(?:(?:SAIP|TINI)AN|ROTA))))$"
  ,
  /* -- MS -- MS -- MS -- MS -- MS -- MS -- MS -- MS -- MS -- MS -- */
  "(?:\\b)((?^:(?i:(?:S(?:T(?:E(?:NNIS (?:SP(?:ACE CENTER| CT)|CTR)|"
  "WART|ENS)|O(?:NE(?:VILLE|WALL)|VALL)|A(?:R(?:KVILLE)?|TE LINE)|RI"
  "NGER|URGIS)|A(?:N(?:D(?:ERSVILLE|Y HOOK|HILL)|ATORIUM)|R(?:EPTA|D"
  "IS|AH)|L(?:TILLO|LIS)|TARTIA|UCIER|VAGE)|H(?:E(?:R(?:ARD|MAN)|LBY"
  ")|A(?:(?:NN|R)ON|W)|U(?:QUALAK|BUTA))|I(?:LVER C(?:REEK|ITY)|BLEY"
  "|DON)|U(?:M(?:RALL|MIT|NER)|NFLOWER)|E(?:BASTOPOL|NATOBIA|MINARY)"
  "|C(?:O(?:BEY|OBA|TT)|HLATER)|(?:MITH(?:VIL|DA)L|KEN)E|L(?:ATE SPR"
  "ING|EDGE)|O(?:UTHAVEN|NTAG|SO)|W(?:AN LAKE|IFTOWN))|M(?:O(?:UN(?:"
  "T (?:PLEASANT|OLIVE)|D BAYOU)|N(?:T(?:ICELLO|PELIER)|EY)|R(?:GAN("
  "?: CITY|TOWN)|TON)|S(?:S(?: POINT)?|ELLE)|OR(?:EVILLE|HEAD))|A(?:"
  "T(?:H(?:ERVILLE|ISTON)|TSON)|(?:D(?:ISO|DE)|BE|CO)N|R(?:I(?:ETTA|"
  "ON)|KS)|Y(?:ERSVILLE|HEW)|G(?:NOLIA|EE)|NT(?:ACHI|E)E)|I(?:N(?:ER"
  "AL WELLS|TER CITY)|(?:SSISSIPPI STAT|Z)E|CHIGAN CITY|DNIGHT)|C(?:"
  " (?:C(?:A(?:LL CREEK|RLEY)|OOL)|ADAMS|HENRY|NEILL|LAIN)|COMB)|E(?"
  ":(?:ADVILL|TCALF)E|RI(?:DIAN|GOLD)|NDENHALL)|S STATE UNIV|T PLEAS"
  "ANT|YRTLE)|C(?:O(?:L(?:UMB(?:US(?: AFB)?|IA)|LINS(?:VILLE)?|DWATE"
  "R)|(?:NEHATT|AHOM|IL)A|FFEEVILLE|URTLAND|RINTH|MO)|A(?:R(?:R(?:OL"
  "LTON|IERE)|THAGE|SON|Y)|L(?:HOUN CITY|EDONIA)|(?:N(?:AA|TO)|MDE)N"
  "|SCILLA)|L(?:E(?:RMONT H(?:ARBO|B)R|VELAND)|AR(?:KSDALE|A)|INTON)"
  "|R(?:YSTAL SP(?:RIN)?GS|O(?:WDER|SBY)|AWFORD|ENSHAW|UGER)|H(?:A(?"
  ":T(?:AWA|HAM)|RLESTON)|U(?:RCH HILL|NKY)|OCTAW)|E(?:NTREVILLE|DAR"
  "BLUFF))|P(?:A(?:S(?:S CHRIS(?:TIA?N)?|CAGOULA)|(?:NTHER BUR|TTISO"
  ")N|R(?:CHMAN|IS)|C(?:HUTA|E)|ULDING)|O(?:RT(?: GIBSON|ERVILLE)|P("
  "?:LARVILL)?E|CAHONTAS|TTS CAMP|NTOTOC)|E(?:R(?:KINSTON|CY)|ARL(?:"
  "INGTON)?|LAHATCHIE|TAL)|I(?:N(?:EY WOODS|OLA)|C(?:AYUNE|KENS)|TTS"
  "BORO)|R(?:AIRIE(?: POINT)?|E(?:NTISS|STON))|H(?:IL(?:ADELPHIA|IPP"
  ")|EBA)|U(?:CKETT|LASKI|RVIS)|LANTERSVILLE)|B(?:E(?:L(?:LEFONTAINE"
  "|D?EN|MONT|ZONI)|N(?:TON(?:IA)?|NDALE|OIT)|AUMONT|CKER|ULAH)|A(?:"
  "Y S(?:(?:AIN)?T LOUI|PRING)S|I(?:LEY|RD)|TESVILLE|SSFIELD|LDWYN|N"
  "NER)|R(?:OOK(?:(?:HAVE|LY)N|SVILLE)|A(?:ND|XT)ON|UCE)|O(?:(?:ONEV"
  "IL|Y)LE|GUE CHITTO|LTON)|I(?:G(?:BEE VALLEY| CREEK)|LOXI)|U(?:(?:"
  "RNSVILL|D)E|CKATUNNA)|LUE (?:MOUNTAIN|SPRINGS)|Y(?:HALIA|RAM))|L("
  "?:A(?:KE(?: CORMORANT|SHORE)?|M(?:(?:BER|ON)T|AR)|(?:FAYETT|WRENC"
  ")E|U(?:DERDALE|REL))|E(?:A(?:KESVILLE|RNED|F)|XINGTON|LAND|NA)|O("
  "?:UI(?:S(?:VILL)?E|N)|NG BEACH|RMAN)|U(?:MBERTON|CEDALE|DLOW|LA)|"
  "I(?:TTLE ROCK|BERTY)|K CORMORANT|YON)|T(?:I(?:P(?:LERSVILLE|PO)|S"
  "HOMINGO|E PLANT|LLATOBA|NSLEY)|(?:H(?:O(?:MASTOW|RNTO)|AXTO)|YLER"
  "TOW)N|U(?:NICA(?: RESORTS?)?|TWILER|PELO|LA)|O(?:(?:CCOPOL|OMSUB)"
  "A|MNOLEN|UGALOO)|AYLOR(?:SVILLE)?|RE(?:BLOC|MONT)|CHULA|ERRY)|H(?"
  ":O(?:L(?:L(?:Y (?:SPRINGS|BLUFF|RIDGE)|ANDALE)|COMB)|U(?:STON|LKA"
  ")|RN LAKE)|A(?:R(?:RIS(?:VILLE|TON)|PERVILLE)|TTIESBURG|ZLEHURST|"
  "MILTON)|E(?:R(?:MANVILLE|NANDO)|IDELBERG)|I(?:CKORY(?: FLAT)?|LLS"
  "BORO)|URLEY)|W(?:A(?:L(?:NUT(?: GROVE)?|THALL|LS)|TER(?: VALLEY|F"
  "ORD)|Y(?:NESBORO|SIDE)|SHINGTON|VELAND)|I(?:N(?:(?:STON|TER)VILLE"
  "|ONA)|GGINS)|E(?:S(?:(?:T POIN)?T|SON)|BB|IR)|H(?:ITFIELD|EELER)|"
  "OOD(?:VILLE|LAND))|G(?:R(?:E(?:EN(?:WOOD(?: SP(?:R(?:INGS)?|G))?|"
  "VILLE)|NADA)|ACE)|L(?:EN(?: ALLAN|DORA)?|OSTER)|O(?:(?:ODMA|LDE)N"
  "|RE SPRINGS)|U(?:N(?:NISO|TOW)N|LFPORT)|A(?:(?:LL|TT)MAN|UTIER)|E"
  "ORGETOWN)|R(?:O(?:(?:BINSONVILL|XI|M)E|SE(?: HILL|DALE)|LLING FOR"
  "K)|I(?:CH(?:LAND|TON)?|DGELAND|ENZI|PLEY)|E(?:D(?: BANKS|WOOD)|NA"
  " LARA|FORM)|A(?:(?:NDOLP|LEIG)H|YMOND)|U(?:LEVILLE|TH))|N(?:E(?:W"
  "(?: (?:A(?:UGUSTA|LBANY)|SITE)|(?:HEBR|T)ON)|TTLETON|SBIT|ELY)|A("
  "?:(?:VAL AIR STA|S) MERIDIAN|TCHEZ)|O(?:RTH CARROLLTON|XAPATER)|I"
  "(?:TTA YUMA|CHOLSON)| CARROLLTON)|D(?:U(?:N(?:CAN|DEE)|CK HILL|BL"
  "IN|RANT|MAS)|E(?:LTA CITY| KALB|CATUR|NNIS|RMA)|I(?:AMONDHEAD|BER"
  "VILLE)|A(?:LEVILLE|RLING)|ODDSVILLE| LO|REW)|A(?:(?:R(?:(?:KABUT|"
  "CO)L|TESI)|(?:GRICO|NGUIL)L)A|(?:V(?:AL)?O|CKERMA)N|B(?:BEVILLE|E"
  "RDEEN)|L(?:LIGATOR|GOMA)|S(?:HLAND|KEW)|MORY)|F(?:A(?:L(?:KNER|CO"
  "N)|RRELL|YETTE)|R(?:IARS POINT|ENCH CAMP)|LO(?:R(?:ENCE|A)|WOOD)|"
  "O(?:XWORTH|REST)|ERNWOOD|ITLER|ULTON)|E(?:L(?:LI(?:SVILLE|OTT)|IZ"
  "ABETH)|(?:SCATAWP|UPOR)A|D(?:INBURG|WARDS)|N(?:TERPRISE|ID)|T(?:H"
  "EL|TA)|ASTABUCHIE|GYPT|CRU)|V(?:A(?:N(?:C(?:LEAV)?E| VLEET)|(?:(?"
  ":RDAM|UGH)A|IDE)N|LLEY PARK)|IC(?:KSBURG|TORIA)|OSSBURG|ERONA)|O("
  "?:AK(?: VALE|LAND)|(?:KOLON|SYK)A|CEAN SPRINGS|LIVE BRANCH|XFORD|"
  "VETT)|K(?:O(?:S(?:CIUSKO|SUTH)|KOMO)|IL(?:MICHAEL|N)|EESLER AFB|R"
  "EOLE)|I(?:N(?:D(?:EPENDENCE|IANOLA)|VERNESS)|(?:TTA BEN|SOL|UK)A)"
  "|U(?:NI(?:ON(?: CHURCH)?|VERSITY)|TICA)|J(?:A(?:CKSON|YESS)|ONEST"
  "OWN)|YAZOO CITY|QUITMAN))))$"
  ,
  /* -- MT -- MT -- MT -- MT -- MT -- MT -- MT -- MT -- MT -- MT -- */
  "(?:\\b)((?^:(?i:(?:S(?:A(?:N(?:D(?: (?:SPRINGS|COULEE)|ERS)|TA RI"
  "TA)|INT (?:(?:IGNATIU|REGI)S|XAVIER|MARIE)|(?:LTES|VAG)E|CO)|T(?:"
  "EVENSVILLE| IGNATIUS|ANFORD|OCKETT|RYKER)|I(?:L(?:VER (?:GATE|STA"
  "R)|ESIA)|DNEY|MMS)|U(?:N(?: RIVER|BURST)|(?:MATR|L)A|PERIOR)|H(?:"
  "E(?:PHERD|RIDAN|LBY)|AWMUT|ONKIN)|(?:QUARE BUTT|EELEY LAK|PRINGDA"
  "L)E|W(?:EET GRASS|AN LAKE)|O(?:NNETTE|MERS)|COBEY)|B(?:I(?:G(?: ("
  "?:S(?:AND|K)Y|TIMBER|ARM)|FORK|HORN)|LLINGS|DDLE|RNEY)|R(?:O(?:AD"
  "(?:VIEW|US)|CK(?:TON|WAY)|WNING)|IDGER|USETT|ADY)|O(?:(?:(?:X E|U"
  ")LD|NN)ER|Y(?:ES|D)|ZEMAN)|A(?:(?:LLANTIN|INVILL)E|KER|SIN|BB)|E("
  "?:L(?:GRADE|FRY|T)|ARCREEK)|L(?:ACK EAGLE|OOMFIELD)|U(?:FFALO|SBY"
  "|TTE)|YNUM)|C(?:O(?:L(?:UMB(?:IA F(?:AL)?L|U)S|STRIP)|N(?:DON|NER"
  "|RAD)|R(?:VALLIS|AM)|FFEE CREEK|OKE CITY|HAGEN)|A(?:(?:NYON|T) CR"
  "EEK|R(?:DWELL|TER)|MERON|PITOL|SCADE)|R(?:A(?:IG|NE)|OW AGENCY|ES"
  "TON)|H(?:ESTER|INOOK|OTEAU|ARLO)|U(?:LBERTSON|T BANK|STER)|L(?:YD"
  "E PARK|INTON|ANCY)|IRCLE)|W(?:I(?:L(?:L(?:OW CREEK|ARD)|SALL)|N(?"
  ":IFRED|NETT|STON)|S(?:E RIVER|DOM)|BAUX)|H(?:IT(?:E(?: SULPHUR SP"
  "RINGS|(?:HAL|TAI)L|WATER|FISH)|LASH)|T SPHR SPGS)|EST(?: (?:YELLO"
  "WSTONE|GLACIER)|BY)|A(?:(?:LKERVILL|SHO)E|RM SPRINGS)|O(?:LF (?:C"
  "REEK|POINT)|RDEN)| YELLOWSTONE|YOLA)|M(?:A(?:R(?:TIN(?: CITY|SDAL"
  "E)|YSVILLE|ION)|L(?:MSTROM A(?: F |F)B|TA)|NHATTAN)|O(?:N(?:TANA "
  "CITY|ARCH)|(?:IES|OR)E|CCASIN|SBY|LT)|I(?:L(?:L(?: IRO|TOW)N|ES C"
  "ITY|DRED)|SSOULA)|E(?:L(?:STON|VILL|ROS)|DICINE LAK)E|C(?: (?:ALL"
  "ISTER|LEOD)|CABE)|USSELSHELL)|H(?:A(?:R(?:L(?:OWTON|EM)|(?:RISO|D"
  "I)N)|M(?:ILTON|MOND)|THAWAY|UGAN|VRE|LL|YS)|O(?:(?:MESTEA|GELAN)D"
  "|T SPRINGS|BSON)|E(?:L(?:MVILLE|ENA)|ART BUTTE|RON)|I(?:N(?:SDALE"
  "|GHAM)|GHWOOD|LGER)|U(?:N(?:GRY HORSE|TLEY)|SON)|YSHAM)|F(?:O(?:R"
  "(?:T(?: (?:(?:HARRIS|BENT)ON|S(?:MITH|HAW)|PECK)|INE)|EST GROVE|S"
  "YTH)|UR BUTTES|X)|R(?:O(?:MBERG|ID)|ENCHTOWN|AZER)|L(?:O(?:RENC|W"
  "ERE)|AXVILL)E|A(?:IR(?:FIELD|VIEW)|LLON)|ISHTAIL|ERDIG)|G(?:A(?:R"
  "(?:R(?:YOWE|ISO)N|DINER|NEILL)|L(?:LATIN G(?:ATEWA|TW)Y|ATA))|R(?"
  ":E(?:AT FALLS|ENOUGH|YCLIFF)|A(?:SS RANG|NTSDAL)E)|L(?:EN(?:DIVE|"
  "TANA)?|ASGOW)|E(?:RALDINE|YSER)|OLD CREEK|ILDFORD)|P(?:O(?:L(?:EB"
  "RIDGE|ARIS|SON)|(?:MPEYS? PIL|P)LAR|W(?:DERVILLE|ER)|TOMAC|NY)|A("
  "?:R(?:K CITY|ADISE)|BLO)|L(?:E(?:NTYWOOD|VNA)|AINS)|R(?:(?:OCT|Y)"
  "OR|AY)|E(?:ERLESS|NDROY)|HILIPSBURG|INESDALE)|R(?:A(?:Y(?:NESFOR|"
  "MON)D|DERSBURG|PELJE|VALLI|MSAY)|E(?:(?:D(?: LODG|STON)|SERV)E|ED"
  " POINT|XFORD)|O(?:(?:BERT|LLIN)S|S(?:EBUD|COE)|UNDUP|NAN|Y)|I(?:C"
  "H(?:LAND|EY)|NGLING)|UDYARD|YEGATE)|L(?:A(?:KE(?: MC ?DONALD|SIDE"
  ")|M(?:E DEER|BERT)|RSLAN|UREL|VINA)|O(?:DGE GRASS|NEPINE|THAIR|RI"
  "NG|LO|MA)|I(?:N(?:COLN|DSAY)|VINGSTON|BBY|MA)|E(?:WISTOWN|DGER)|U"
  "(?:STRE|THER)|LOYD)|T(?:H(?:OMPSON F(?:AL)?L|REE FORK)S|R(?:O(?:U"
  "T CREEK|Y)|ACY|EGO)|W(?:IN BRIDGES|O DOT)|O(?:WNSEND|STON)|E(?:IG"
  "EN|RRY)|URNER)|E(?:AST (?:GLACIER PARK|HELENA)| GLACIER P(?:ARK?|"
  "K)|(?:KALA|URE)KA|L(?:LISTON|MO)|VERGREEN|MIGRANT|THRIDGE|DGAR|NN"
  "IS|SSEX)|D(?:E(?:ER LODGE| BORGIA|CKER|NTON|LL)|I(?:(?:LL|X)ON|VI"
  "DE)|A(?:GMAR|YTON|RBY)|U(?:PUYER|TTON)|RUMMOND|ODSON)|A(?:N(?:(?:"
  "ACOND|GEL)A|TELOPE)|L(?:BERTON|ZADA|DER)|(?:BSAROK|RL)EE|(?:CT|V)"
  "ON|SHLAND|UGUSTA)|J(?:O(?:(?:PLI|RDA)N|LIET)|EFFERSON CI?TY|UDITH"
  " GAP|ACKSON)|V(?:I(?:RGINIA CITY|CTOR|DA)|A(?:NDALIA|LIER|UGHN)|O"
  "LBORG)|O(?:L(?:IVE|NEY)|ILMONT|UTLOOK|PHEIM|VANDO|TTER)|N(?:(?:IA"
  "RAD|ASHU)A|O(?:RRIS|XON)|EIHART|YE)|K(?:(?:REML|EV)IN|I(?:NSEY|LA"
  ")|ALISPELL)|I(?:N(?:VERNESS|GOMAR)|SMAY)|Z(?:ORTMAN|URICH)|YELLOW"
  "TAIL|ULM))))$"
  ,
  /* -- NC -- NC -- NC -- NC -- NC -- NC -- NC -- NC -- NC -- NC -- */
  "(?:\\b)((?^:(?i:(?:S(?:T(?:A(?:N(?:TONSBURG|FIELD|LEY)|TE(?:SVILL"
  "E| ROAD)|L(?:LINGS|EY)|CY|R)|O(?:N(?:E(?:VILLE|WALL)|Y POINT)|KES"
  "(?:DALE)?|VALL)|E(?:DMAN|LLA|M)|UMPY POINT)|E(?:VE(?:N (?:SPRING|"
  "DEVIL|LAKE)S|RN)|YMOUR JOHNSON A(?: F |F)B|A(?:BOARD|GROVE|LEVEL)"
  "|(?:DALI|MOR|LM)A)|A(?:L(?:TER PATH|EMBURG|ISBURY|UDA|VO)|(?:INT "
  "PAU|W MIL)LS|N(?:DY RIDGE|FORD)|XAPAHAW|PPHIRE|RATOGA)|O(?:UTH(?:"
  " (?:BRUNSWICK|MILLS)|ERN (?:PI?N|SHOR)ES|(?:MON|POR)T|RN SHORE)|P"
  "HIA)|U(?:GAR (?:M(?:OUNTAI|T)N|GROVE)|N(?:SET BEACH|BURY)|(?:RF C"
  "IT|PPL)Y|MMERFIELD)|H(?:A(?:NNON(?: PLAZA)?|RPSBURG|LLOTTE|WBORO)"
  "|E(?:RRILLS FO?RD|LBY)|ILOH)|C(?:(?:ALY M(?:OUNTAI|T)|RANTO)N|OT("
  "?:T(?:VILLE|S)|LAND NECK))|P(?:(?:R(?:ING (?:HOP|LAK)|UCE PIN)|IN"
  "DAL)E|E(?:NCER|ED)|ARTA)|W(?:AN(?:QUARTER|NANOA|SBORO)|EPSONVILLE"
  ")|I(?:L(?:ER CITY|OAM)|M(?:PSON|S))|N(?:OW (?:CAMP|HILL)|EADS FER"
  "RY)|M(?:ITHFIELD|YRNA)| BRUNSWICK|KYLAND|JAFB|YLVA)|C(?:A(?:R(?:O"
  "L(?:INA (?:SHOR(?:ES)?|B(?:EA)?CH)|EEN)|RBORO|THAGE|Y)|S(?:T(?:LE"
  " HAYNE|ALIA)|WELL BEACH|HIERS|AR)|M(?:(?:ERO|DE)N|P LEJEUNE)|PE ("
  "?:CARTERET|FEAR)|N(?:D(?:LE|O)R|TON)|L(?:ABASH|YPSO)|TAWBA)|O(?:N"
  "(?:NELLY(?:S SP(?:RINGS|G)| SPG)|CORD|ETOE|OVER|WAY)|L(?:ER(?:IDG"
  "E|AIN)|UMB(?:IA|US)|LETTSVILLE|FAX|ON)|R(?:(?:DOV|OLL)A|APEAKE|NE"
  "LIUS)|M(?:FORT|O)|OLEEMEE|VE CITY|INJOCK|FIELD|UNCIL|ATS)|H(?:I(?"
  ":N(?:A GROVE|QUAPIN)|MNEY ROCK)|ER(?:RY(?: POINT|VILLE)|OKEE)|A(?"
  ":PEL HILL|DBOURN|RLOTTE)|OCOWINITY)|L(?:A(?:R(?:E(?:MONT|NDON)|KT"
  "ON)|YTON)|I(?:FFSIDE|NTON|MAX)|E(?:VELAND|MMONS)|YDE)|E(?:DAR (?:"
  "M(?:OUNTAI|T)N|ISLAND|FALLS|GROVE|POINT)|RRO GORDO)|R(?:E(?:S(?:W"
  "ELL|TON)|EDMOOR)|O(?:SSNOR|US)E|AMERTON|UMPLER)|U(?:L(?:BERSON|LO"
  "WHEE)|M(?:BERLAND|NOCK)|RRI(?:TUCK|E)))|M(?:A(?:R(?:S(?:H(?:ALL(?"
  ":BERG)?|VILLE)| HILL|TON)|GARETTSV(?:ILLE|L)|I(?:ETTA|ON)|BLE|VIN"
  ")|N(?:NS HARBOR|SON|TEO)|G(?:GIE VALLEY|NOLIA)|(?:(?:DIS|XT)O|IDE"
  ")N|C(?:CLESFIELD|ON)|Y(?:SVILLE|ODAN)|(?:TTHEW|MER)S|PLE(?: HILL)"
  "?|URY)|O(?:UNT(?: (?:(?:MOURN|OLIV)E|(?:HOLL|AIR)Y|PLEASANT|GILEA"
  "D|ULLA)|AIN HOME)|R(?:AVIAN F(?:AL)?LS|(?:GANTO|VE)N|EHEAD CITY|R"
  "ISVILLE)|N(?:T(?:EZUMA|REAT)|(?:CUR|RO)E)|ORES(?:VILLE|BORO)|CKSV"
  "ILLE|YOCK)|I(?:N(?:NE(?:SOTT B(?:EA)?CH|APOLIS)|ERAL SP(?:RIN)?GS"
  "|T HILL)|L(?:L(?:ERS CREEK| SPRING|S RIVER)|WAUKEE|TON)|D(?:DLE(?"
  ":BURG|SEX)|WAY PARK|LAND)|C(?:AVILLE|RO)|SENHEIMER)|C(?: (?:(?:LE"
  "ANS|ADEN)VILLE|FARLAN|GRADY)|CUTCH(?:EON FIE|N F)LD)|E(?:RR(?:Y H"
  "ILL|ITT)|BANE|SIC)|T (?:PLEASANT|HOLLY)|UR(?:FREESBORO|PHY))|B(?:"
  "A(?:R(?:IUM SP(?:RI)?NGS|N(?:ARD|E)SVILLE|BER|CO)|L(?:D HEAD ISL("
  "?:AND)?|SAM(?: GROVE)?)|T(?:TLEBORO| CAVE|H)|DIN(?: LAKE)?|KERSVI"
  "LLE|NNER ELK|YBORO|HAMA|ILEY)|E(?:L(?:VI(?:DER|LL)E|EWS CREEK|LAR"
  "THUR|HAVEN|MONT)|A(?:R(?: CREEK|GRASS)|UFORT)|ECH M(?:OUNTAIN|NT)"
  "|N(?:NETT|SON)|TH(?:ANIA|EL)|SSEMER CITY|ULAVILLE)|U(?:R(?:LINGTO"
  "N|NSVILLE|GAW)|(?:IES CREE|LLOC)K|T(?:TERS|NER)|NN(?:LEVEL)?|FFAL"
  "O LAKE|XTON)|O(?:(?:ILING SP(?:RIN)?G|WDEN)S|O(?:N(?:VILL)?E|MER)"
  "|L(?:IVIA|TON)|GER CITY|NLEE|STIC)|R(?:O(?:WNS SUMMIT|ADWAY)|(?:A"
  "SSTOW|IDGETO)N|E(?:NTWOO|VAR)D|YSON CITY|UNSWICK)|L(?:A(?:CK (?:M"
  "(?:OUNTAI|T)N|CREEK)|DENBORO|NCH)|O(?:UNTS CREE|WING ROC)K)|I(?:L"
  "TMORE (?:F(?:ORE|R)ST|LAKE)|SCOE)|YNUM)|W(?:A(?:L(?:L(?:BURG|ACE)"
  "|NUT COVE|STONBURG|KERTOWN)|R(?:REN(?:SVILLE|TON)|SAW|NE)|(?:YNES"
  "VILL|NCHES)E|DE(?:SBORO)?|KE FOREST|SHINGTON|GRAM|XHAW|THA|VES|CO"
  ")|I(?:L(?:L(?:I(?:AM)?STON|OW SPRING|ARD)|SON(?:S MILLS)?|KESBORO"
  "|MINGTON|BAR)|N(?:T(?:ERVILLE|ON)|STON SALEM|NABOW|DSOR|FALL|GATE"
  ")|SE)|E(?:S(?:LEY(?:AN COL(?:LEGE)?| CHAPEL)|T(?: (?:JEFFERSON|EN"
  "D)|FIELD))|N(?:TWORTH|DELL)|L(?:COME|DON)|AVERVILLE|DDINGTON|BSTE"
  "R)|HI(?:T(?:E(?: (?:PLAINS|OAK)|VILLE|HEAD)|AKERS|SETT|TIER)|SPER"
  "(?:ING PI| P)NES)|RI(?:GHTSVILLE BEA|TSVLLE B)CH|OOD(?:L(?:AND|EA"
  "F)|FIN)| JEFFERSON)|L(?:A(?:KE(?: (?:SANTEETLAH|JUNALUSKA|WACCAMA"
  "W|TOXAWAY|LURE|PARK)|VIEW)|UR(?:EL (?:SP(?:RIN)?GS|HILL|PARK)|INB"
  "URG)|(?:W(?:SONVIL|NDA)L| GRANG|TTIMOR)E|N(?:SING|DIS)|SKER)|I(?:"
  "N(?:VILLE(?: F(?:AL)?LS)?|(?:COLNTO|DE)N|WOOD)|TTLE(?: SWITZERLAN"
  "D|TON)|L(?:ESVILLE|LINGTON)|BERTY)|E(?:WIS(?:TON(?: WOODVILLE)?|V"
  "ILLE)|(?:ICESTE|NOI)R|MON SPRINGS|XINGTON|ASBURG|LAND)|O(?:W(?:LA"
  "ND|ELL|GAP)|NG(?:ISLAN|WOO)D|UISBURG|CUST)|U(?:MBER(?: BRIDGE|TON"
  ")|CAMA)|K (?:SANTEETLAH|JUNALUSKA)|TL SWITZRLND|YNN)|P(?:I(?:N(?:"
  "E(?: (?:(?:LEVE|HAL)L|KNOLL SHORES)|TO(?:PS|WN)|Y CREEK|BLUFF|HUR"
  "ST|VILLE|OLA)|K HILL|NACLE)|LOT M(?:OUNTAI|T)N|SGAH FOREST|KEVILL"
  "E|TTSBORO)|O(?:L(?:K(?:VILLE|TON)|LOCKSVILLE)|P(?:E A(?: F |F)B|L"
  "AR BRANCH)|WELLS(?: POINT|VILLE)|INT HARBOR|TECASI)|R(?:O(?:(?:CT"
  "ORVILL|VIDENC)E|SPECT HILL)|INCE(?:VILLE|TON))|E(?:N(?:DLETON|LAN"
  "D|ROSE)|L(?:ETIER|HAM)|ACHLAND|MBROKE)|L(?:EASANT (?:G(?:ARDE|D)N"
  "|HILL)|UMTREE|YMOUTH)|A(?:R(?:KTON|MELE)|TTERSON|W CREEK|NTEGO)|F"
  "AFFTOWN|URLEAR|KS)|H(?:A(?:R(?:R(?:ELLS(?:VILLE)?|IS(?:BURG)?)|KE"
  "RS IS(?:LAND)?|BINGER|MONY)|M(?:P(?:TONVILLE|STEAD)|ILTON|LET)|L("
  "?:LSBORO|IFAX)|Y(?:ESVILLE|S)|W RIVER|ZELWOOD|TTERAS|VELOCK|SSELL"
  ")|O(?:L(?:L(?:Y (?:SPRINGS|RIDGE)|ISTER)|DEN BEACH)|B(?:BSVILLE|U"
  "CKEN|GOOD)|(?:T SPRING|PE MILL)S|(?:OKERTO|FFMA)N|RSE SHOE)|I(?:G"
  "H(?: (?:SHOALS|POINT)|(?:FALL|LAND)S)|L(?:LSBOROUGH|DEBRAN)|DDENI"
  "TE|CKORY)|E(?:N(?:DERSON(?:VI?LLE)?|RI(?:ETTA|CO))|RTFORD)|U(?:NT"
  "ERSVILLE|RDLE MILLS|BERT|DSON|SK))|R(?:O(?:A(?:NOKE RAPID(?:S(?: "
  "AIR FORCE STA)?)?|RING (?:RIVER|GAP))|CK(?:Y (?:MOU|POI)NT|INGHAM"
  "|WELL)|B(?:BINS(?:VILLE)?|ERSONVILLE)|S(?:E(?: HILL|BORO)|MAN)|N("
  "?:OK RPD AFS|DA)|D(?:ANTHE|UCO)|X(?:BORO|OBEL)|LESVILLE|UGEMONT|W"
  "LAND|PER)|I(?:CH(?: SQUARE|FIELD|LANDS)|DGE(?:CREST|WAY)|EGELWOOD"
  ")|E(?:SEARCH TRIANGLE PARK|D (?:SPRINGS|OAK)|IDSVILLE|X)|U(?:THER"
  "F(?:ORD(?: COLLEGE|TON)|RD COL)|RAL HALL|FFIN)|A(?:NDLEMAN|EFORD|"
  "LEIGH|MSEUR)|HODHISS|TP)|G(?:R(?:A(?:N(?:ITE (?:Q(?:UAR)?RY|FALLS"
  ")|TSBORO|DY)|SSY CREEK|HAM)|EEN(?: (?:M(?:OUNTAI|T)N|LEVEL)|SBORO"
  "|VILLE)|I(?:MESLAND|FTON)|OVER)|L(?:EN(?:D(?:ALE SP(?:RIN)?GS|ON)"
  "| (?:ALPINE|RAVEN)|VILLE|WOOD)|ADE VALLEY|OUCESTER)|A(?:R(?:YSBUR"
  "G|LAND|NER)|TES(?:VILLE)?|STON(?:IA)?)|O(?:LD(?:S(?:BORO|TON)| HI"
  "LL)|DWIN)|E(?:R(?:MAN)?TON|ORGE)|IBSON(?:VILLE)?|U(?:MBERRY|LF))|"
  "E(?:L(?:IZABETH(?: CI?TY|TOWN)|LE(?:NBORO|RBE)|ON(?: COLLEGE)?|K("
  "?: PARK|IN)|M CITY)|A(?:ST (?:F(?:AYETTEVILLE|LAT ROCK)|SPENCER|B"
  "END|LAKE)|GLE (?:SPRINGS|ROCK)|RL)|N(?:(?:GELHAR|FIEL)D|O VALLEY|"
  "NICE|KA)|D(?:E(?:NTO)?N|NEYVILLE|WARD)| F(?:AYETTEVI?LLE|LAT ROCK"
  ")|VER(?:GREEN|ETTS)|T(?:OWAH|HER)|R(?:NUL|WIN)|MERALD ISLE|URE(?:"
  "KA)?|FLAND)|A(?:L(?:EX(?:ANDER(?: M(?:IL)?LS)?|IS)|BE(?:MARLE|RTS"
  "ON)|(?:AM|LI)ANCE|TAMAHAW|MOND)|T(?:LANTIC(?: B(?:EA)?CH)?|KINSON"
  ")|R(?:A(?:PAHOE|RAT)|CHDALE|DEN)|U(?:TRYVILLE|LANDER|RORA)|N(?:SO"
  "NVILLE|DREWS|GIER)|SH(?:E(?:VILLE|BORO))?|(?:DVANC|HOSKI|QUON)E|M"
  "F G(?:REENS| )BORO|(?:BERDEE|VO)N|YD(?:LETT|EN)|PEX)|F(?:A(?:I(?:"
  "R(?: BLUFF|FIELD|MONT|VIEW)|SON|TH)|L(?:(?:LST|C)ON|KLAND)|(?:YET"
  "TE|RM)VILLE)|O(?:R(?:EST CITY|T BRAGG)|XFIRE V(?:ILLAGE|LG)|U(?:R"
  " OAKS|NTAIN)|NTANA DAM)|R(?:ANK(?:LIN(?:VILLE|TON)?)?|EMONT|ISCO)"
  "|E(?:ARRINGTON(?: VILLAGE)?|RGUSON)|L(?:E(?:ETWOOD|TCHER)|AT ROCK"
  ")|UQUAY VARINA)|T(?:A(?:R(?:AWA TER(?:RACE)?| HEEL|BORO)|YLORSVIL"
  "LE|BOR CITY|POCO)|R(?:ENT(?: WOODS|ON)|I(?:PLETT|NITY)|O(?:UTMAN|"
  "Y)|APHILL|YON)|O(?:P(?:SAIL BEACH|TON)|(?:BACCO|WNS)VILLE|AST|DD)"
  "|U(?:R(?:NERSBURG|KEY)|CKASEGEE|XEDO)|H(?:OMASVILLE|URMOND)|I(?:M"
  "BERLAKE|LLERY)|E(?:ACHEY|RRELL)|YNER)|N(?:E(?:W(?: (?:(?:LONDO|BE"
  "R)N|HILL)|TON(?: GROVE)?|LAND|PORT|ELL)|BO)|A(?:VA(?:L HOS(?:PITA"
  "L)?|SSA)|GS HEAD|SHVILLE|KINA|PLES)| (?:TOPSAIL B(?:EA)?CH|WILKES"
  "BORO)|OR(?:TH WILKESBORO|LINA|WOOD|MAN))|K(?:I(?:N(?:G(?:S(?: M(?"
  ":OUNTAI|T)|TOW)N)?|STON)|LL DEVIL H(?:ILLS|L)|TT(?:Y HAWK|RELL)|P"
  "LING)|E(?:N(?:ANSVILLE|LY)|L(?:FORD|LY)|RNERSVILLE)|N(?:OTTS ISLA"
  "ND|IGHTDALE)|ANNAPOLIS|URE BEACH)|D(?:U(?:R(?:ANTS NECK|HAM)|(?:B"
  "LI|N)N|DLEY|CK)|E(?:EP (?:GAP|RUN)|N(?:TON|VER)|LCO)|A(?:VI(?:DSO"
  "N|S)|N(?:BURY|A)|LLAS)|O(?:BSON|VER)|ILLSBORO|REXEL)|O(?:AK(?: (?"
  ":ISLAND|RIDGE|CITY)|BORO)|C(?:EAN ISL(?:E BEA| B)CH|RACOKE)|L(?:I"
  "(?:VIA|N)|D FORT)|R(?:IENTAL|RUM)|XFORD|TTO)|J(?:A(?:CKSON(?: SP("
  "?:RIN)?GS|VILLE)?|MES(?:VILLE|TOWN)|RVISBURG)|ON(?:AS RIDG|ESVILL"
  ")E|(?:EFFERSO|ULIA)N)|V(?:A(?:L(?:(?:DES)?E|LE CRUCIS)|N(?:CEBORO"
  "|DEMERE)|UGHAN|SS)|ILAS)|I(?:N(?:DIAN (?:BEACH|TRAIL)|GOLD)|RON S"
  "TATION|VANHOE|CARD)|Z(?:I(?:ONVILLE|RCONIA)|EBULON)|Y(?:A(?:DKIN|"
  "NCEY)|OUNGS)VILLE|UN(?:ION (?:GROVE|MILLS)|AKA)))))$"
  ,
  /* -- ND -- ND -- ND -- ND -- ND -- ND -- ND -- ND -- ND -- ND -- */
  "(?:\\b)((?^:(?i:(?:B(?:U(?:F(?:FALO(?: SP(?:RINGS|G))?|ORD)|R(?:L"
  "INGTON|NSTAD|T)|C(?:HANAN|YRUS)|XTON|TTE)|E(?:R(?:(?:GE|LI)N|THOL"
  "D|WICK)|L(?:COURT|FIELD|DEN)|N(?:EDICT|TLEY)|(?:ULA|AC)H)|A(?:T(?"
  ":TLEVIEW|HGATE)|L(?:DWIN|FOUR|TA)|R(?:NEY|TON)|CKOO|NTRY|KER)|R(?"
  ":A(?:NTFORD|DDOCK|MPTON)|I(?:ARWOOD|NSMADE)|E[IM]EN|OCKET)|O(?:W("
  "?:(?:DO|MA)N|ESMONT|BELLS)|NETRAILL|TTINEAU|RDULAC)|I(?:S(?:MARCK"
  "|BEE)|NFORD)|LA(?:ISDELL|NCHARD))|M(?:A(?:N(?:DA(?:REE|N)|TADOR|F"
  "RED|NING|VEL)|R(?:(?:IO|TI)N|MARTH|SHALL)|P(?:LETON|ES)|X(?:BASS)"
  "?|(?:ID|Z)A|YVILLE|DDOCK|KOTI)|I(?:N(?:OT(?: AFB)?|NEWAUKAN|TO)|L"
  "(?:(?:LAR)?TON|NOR)|CHIGAN)|O(?:N(?:TPELIER|ANGO)|(?:ORETO|UNTAI)"
  "N|(?:FFI|T)T|HALL)|C(?:(?:KENZI|VILL)E|C(?:LUSKY|ANNA)|GREGOR|HEN"
  "RY|LEOD)|E(?:R(?:RICOURT|CER)|D(?:IN|OR)A|KINOCK|LVILLE|NOKEN)|UN"
  "ICH|YLO)|S(?:T(?:R(?:A(?:UBVILLE|SBURG)|EETER)|A(?:N(?:LEY|TON)|R"
  "KWEATHER)|E(?:RLING|ELE)|IRUM)|A(?:INT (?:ANTHONY|MICHAEL|THOMAS|"
  "JOHN)|N(?:(?: HAVE|BOR)N|ISH)|RLES|WYER)|H(?:E(?:RWOOD|YENNE|LDON"
  ")|IELDS|ARON)|O(?:U(?:TH(?: HEART|AM)|RIS)|LEN)|E(?:L(?:FRIDGE|Z)"
  "|NTI?NEL BUTTE)|P(?:RINGBROOK|IRITWOOD)|Y(?:KESTON|DNEY)|U(?:RREY"
  "|TTON)|I(?:BLEY|LVA)|CRANTON)|C(?:A(?:R(?:(?:RINGT|S)ON|TWRIGHT|B"
  "URY|PIO)|L(?:EDONIA|VIN|IO)|N(?:NON BALL|DO)|VALIER(?: AFS)?|SSEL"
  "TON|THAY|YUGA)|O(?:L(?:GA(?:TE|N)|EHARBOR|UMBUS|FAX)|U(?:RTENAY|L"
  "EE)|OPERSTOWN|GSWELL|NCRETE|RINTH|TEAU)|H(?:A(?:RLSON|SELEY|FFEE)"
  "|URCHS FERRY|RISTINE)|R(?:YSTAL(?: SP(?:RIN)?GS)?|(?:OSB|AR)Y|ETE"
  ")|L(?:(?:EVELAN|IFFOR)D|YDE)|UMMINGS|ENTER)|G(?:R(?:A(?:N(?:D(?: "
  "(?:FORKS(?: AFB)?|RAPIDS)|IN)|VILLE)|SSY BUTTE|CE CITY|FTON)|E(?:"
  "AT BEND|NORA))|A(?:R(?:D(?:NE|A)R|RISON)|L(?:ESBURG|CHUTT)|(?:SCO"
  "YN|CKL)E)|L(?:EN(?:(?: ULLI|BUR)N|FIELD)|A(?:DSTONE|SSTON))|O(?:L"
  "(?:DEN VALLEY|VA)|ODRICH|RHAM)|ENESEO|WINNER|UELPH|FAFB|ILBY)|W(?"
  ":I(?:L(?:L(?:OW CITY|ISTON)|D(?: RIC|ROS)E|TON)|N(?:DSOR|G)|MBLED"
  "ON|SHEK)|A(?:L(?:HALLA|COTT|ES|UM)|(?:HPETO|SHBUR)N|TFORD CITY|RW"
  "ICK)|H(?:IT(?:E (?:SHIELD|EARTH)|MAN)|E(?:ATLAND|ELOCK))|E(?:ST(?"
  ": FARGO|FIELD|HOPE)|(?:BST|RN)ER)|O(?:L(?:FORD|SETH)|ODWORTH)|YND"
  "MERE)|H(?:A(?:N(?:N(?:A(?:FORD|H)|OVER)|KINSON|SBORO)|M(?:(?:ILTO"
  "|PDE)N|BERG|LET|AR)|(?:ZE(?:LTO)?|TTO)N|R(?:WOOD|LOW|VEY)|(?:STIN"
  "G|YNE)S|LLIDAY|VANA|GUE)|E(?:NS(?:LER|EL)|(?:AT|BR)ON|I(?:MDA)?L|"
  "TTINGER)|O(?:(?:OPL|RAC|P)E|NEYFORD)|U(?:RDSFIELD|NTER|FF)|I(?:LL"
  "SBORO|CKSON))|F(?:O(?:R(?:T(?: (?:R(?:ANSOM|ICE)|TOTTEN|CLARK|YAT"
  "ES)|UNA)|EST RIVER|DVILLE|BES|MAN)|XHOLM)|A(?:IR(?:FIELD|MOUNT|DA"
  "LE)|RGO)|I(?:N(?:GAL|LEY)|LLMORE)|R(?:EDONIA|ONTIER|YBURG)|L(?:A("
  "?:SHER|XTON)|ORA)|(?:ESSENDE|ULLERTO)N)|L(?:A(?:N(?:(?:GDO|KI)N|S"
  "FORD|DA)|K(?:E WILLIAMS|OTA)|R(?:IMORE|SON|K)|MOURE|WTON)|I(?:(?:"
  "N(?:COL|TO)|SBO)N|(?:TCHVILL|GNIT)E|DGERWOOD)|E(?:(?:FO|H)R|ONARD"
  "|EDS|ITH|ROY|AL)|O(?:STWOOD|RAINE|MA)|U(?:VERNE|DDEN))|D(?:E(?:(?"
  ":VILS LAK|LAMER)E|N(?:BIGH|HOFF)|S LACS|ERING)|A(?:(?:HLE|WSO)N|V"
  "ENPORT|ZEY)|U(?:N(?:N CENTER|SEITH)|RBIN)|O(?:NNYBROOK|UGLAS|DGE|"
  "YON)|R(?:A(?:YTON|KE)|ISCOLL)|ICK(?:INSON|EY)|WIGHT)|A(?:R(?:(?:V"
  "ILL|EN)A|GUSVILLE|NEGARD|DOCH|THUR)|L(?:(?:KAB|AM)O|EXANDER|FRED|"
  "MONT|ICE|SEN)|B(?:ERCROMBIE|SARAKA)|M(?:BROSE|ENIA|IDON)|N(?:AMOO"
  "SE|TLER|ETA)|D(?:RIAN|AMS)|SHLEY|GATE|PPAM|YR)|R(?:O(?:L(?:ETTE|L"
  "A)|S(?:EGLEN|S)|BINSON|CKLAKE|GERS|TH)|E(?:(?:ILES ACRE|YNOLD)S|G"
  "(?:ENT|AN)|EDER)|I(?:VER(?:DAL|SID)E|CHARDTON)|A(?:LEIGH|WSON|UB|"
  "Y)|U(?:TLAND|GBY|SO)|HAME|YDER)|P(?:E(?:T(?:ERSBURG|TIBONE)|(?:KI"
  "|N)N|MBINA|RTH)|A(?:R(?:K RIVER|SHALL)|LERMO|GE)|O(?:RT(?:LAND|AL"
  ")|WERS LAKE)|I(?:LLSBURY|NGREE|SEK)|R(?:AIRIE ROSE|OSPER)|L(?:EAS"
  "ANT LAKE|AZA))|N(?:E(?:W(?: (?:(?:ROCKFOR|ENGLAN)D|LEIPZIG|HRADEC"
  "|SALEM|TOWN)|BURG)|KOMA|CHE)|O(?:R(?:T(?:H(?: RIVER|GATE|WOOD)|ON"
  "VILLE)|WICH|MA)|ONAN|ME)|A(?:(?:POLE|NS)ON|SH)|IAGARA)|E(?:L(?:L("
  "?:ENDALE|IOTT)|DRIDGE|GIN)|D(?:M(?:UNDS|ORE)|INBURG|GELEY)|M(?:ER"
  "ADO|BDEN|RICK|MET)|N(?:GLEVALE|DERLIN)|(?:GELA|SMO)ND|CKELSON|PPI"
  "NG|RIE)|T(?:O(?:W(?:ER CITY|NER)|L(?:LEY|NA)|KIO)|A(?:PPEN|YLOR|G"
  "US)|U(?:RTLE LAK|TTL)E|R(?:OTTERS|ENTON)|EM(?:PLE|VIK)|HOMPSON|IO"
  "GA)|K(?:E(?:N(?:MARE|SAL)|MPTON|ENE|LSO)|I(?:N(?:DRED|TYRE)|LLDEE"
  "R|EF)|A(?:RLSRUHE|THRYN)|LOTEN|RAMER|NOX|ULM)|J(?:U(?:D(?:SON)?|A"
  "NITA)|O(?:HNSTOWN|LIETTE)|AMESTOWN|ESSIE)|O(?:R(?:R(?:IN)?|ISKA)|"
  "SNABROCK|BERON|VERLY|AKES|XBOW)|V(?:E(?:NTURI|RON|LV)A|O(?:LTAIRE"
  "|SS)|ALLEY CITY)|U(?:N(?:DERWOOD|ION)|PHAM)|Z(?:A(?:HL|P)|EELAND)"
  "|Y(?:PSILANTI|ORK)|INKSTER))))$"
  ,
  /* -- NE -- NE -- NE -- NE -- NE -- NE -- NE -- NE -- NE -- NE -- */
  "(?:\\b)((?^:(?i:(?:B(?:E(?:A(?:VER (?:C(?:ROSSING|ITY)|XING)|TRIC"
  "E)|L(?:(?:VIDER|GRAD)E|L(?:EVUE|WOOD)|DEN)|N(?:N(?:INGTON|ET)|KEL"
  "MAN|EDICT)|R(?:TRAND|WYN)|E(?:MER)?)|R(?:O(?:WN(?:VILL|LE)E|ADWAT"
  "ER|KEN BOW|CK)|U(?:N(?:SWICK|ING|O)|LE)|A(?:D(?:SHAW|Y)|INARD)|I("
  "?:DGEPORT|STOW)|EWSTER)|A(?:R(?:TLE(?:TT|Y)|NESTON)|(?:NCROF|SSET"
  ")T|TTLE CREEK|YARD)|L(?:OOM(?:INGTON|FIELD)|UE (?:SPRINGS|HILL)|A"
  "(?:DEN|IR))|U(?:R(?:CHARD|WELL|R)|SHNELL|TTE)|O(?:YS ?TOWN|ELUS|O"
  "NE)|I(?:G SPRINGS|NGHAM)|YRON)|S(?:T(?:A(?:PLE(?:HURST|TON)|MFORD"
  "|NTON)|E(?:ELE CITY|INAUER|RLING|LLA)|R(?:A(?:TTON|NG)|OMSBURG)| "
  "COLUMBANS|OCKVILLE|UART)|A(?:INT (?:(?:LIBO|MA)RY|EDWARD|HELENA|P"
  "AUL)|R(?:ONVILLE|GENT)|LEM)|P(?:R(?:ING(?:FIELD|VIEW)|AGUE)|A(?:L"
  "DING|RKS)|ENCER)|U(?:T(?:HERLAND|TON)|(?:PERIO|MNE)R|RPRISE)|C(?:"
  "OT(?:TSBLUFF|IA)|(?:HUYL|RIBN)ER)|H(?:EL(?:TON|BY)|ICKLEY|UBERT)|"
  "OUTH (?:SIOUX CITY|BEND)|I(?:LVER CREEK|DNEY)|E(?:NECA|WARD)| SIO"
  "UX CITY|MITHFIELD|YRACUSE|WANTON|NYDER)|C(?:O(?:R(?:(?:DOV|NLE)A|"
  "TLAND)|(?:TESFIEL|NCOR|ZA)D|L(?:ERIDGE|UMBUS|ON)|(?:MSTOC|O)K|WLE"
  "S|DY)|R(?:A(?:(?:B ORCHA|WFO)RD|IG)|E(?:(?:IGH|S)TON|TE)|O(?:OKS|"
  "F)TON)|E(?:DAR (?:(?:BLUFF|RAPID)S|CREEK)|NT(?:RAL CITY|ER)|RESCO"
  ")|A(?:M(?:BRIDGE|PBELL)|R(?:LETON|ROLL)|LLAWAY|IRO)|H(?:A(?:M(?:B"
  "ERS|PION)|P(?:PELL|MAN)|DRON)|ESTER)|L(?:A(?:RKS(?:ON)?|Y CENTER|"
  "TONIA)|EARWATER)|U(?:LBERTSON|RTIS))|H(?:A(?:R(?:RIS(?:BURG|ON)|T"
  "INGTON|VARD|DY)|Y(?:ES CENTER| SPRINGS)|M(?:PTON|LET)|(?:IGLE|DA)"
  "R|L(?:LAM|SEY)|STINGS|ZARD)|O(?:L(?:(?:MESVILL|DREG)E|BROOK|STEIN"
  "|LAND)|(?:SKIN|WELL)S|(?:OP|M)ER|RDVILLE)|E(?:N(?:D(?:ERSON|LEY)|"
  "RY)|R(?:SHEY|MAN)|MINGFORD|ARTWELL|BRON)|U(?:M(?:BOLDT|PHREY)|BB("
  "?:ARD|ELL)|NTLEY)|I(?:LDRETH|CKMAN)|YANNIS)|M(?:A(?:R(?:QUETTE|SL"
  "AND|TELL)|S(?:ON CITY|KELL)|D(?:ISON|RID)|L(?:COLM|MO)|(?:NLE|C)Y"
  "|X(?:WELL)?|YWOOD|GNET)|I(?:L(?:L(?:IGAN|ARD|ER|S)|BURN|FORD)|N(?"
  ":ATARE|DEN)|TCHELL)|C(?: COO(?:L J(?:UNCTION|CT)|K)|COOK|GREW|LEA"
  "N)|E(?:AD(?:OW GROVE)?|R(?:RIMAN|NA)|LBETA|MPHIS)|O(?:R(?:SE BLUF"
  "F|RILL)|OREFIELD|NROE)|U(?:R(?:DOCK|RAY)|LLEN))|W(?:A(?:L(?:T(?:H"
  "ILL|ON)|LACE)|TER(?:BURY|LOO)|U(?:NET|S)A|(?:HO|C)O|SHINGTON|KEFI"
  "ELD|VERLY|YNE)|I(?:N(?:NE(?:BAGO|TOON)|S(?:IDE|LOW))|L(?:LOW ISLA"
  "ND|SONVILLE|BER|COX)|SNER)|E(?:ST(?:ER(?:VILLE|N)| POINT|ON)|(?:L"
  "LFLEE|ISSER)T|EPING WATER)|O(?:OD (?:RIVER|LAKE)|LBACH)|HIT(?:(?:"
  "ECLA|NE)Y|MAN)|Y(?:MORE|NOT))|P(?:A(?:L(?:M(?:YRA|ER)|ISADE)|(?:P"
  "ILLI|XT)ON|WNEE CITY|NAMA|RKS|GE)|L(?:A(?:TT(?:E CENTER|SMOUTH)|I"
  "NVIEW)|EASANT(?: DALE|ON)|YMOUTH)|R(?:(?:IMROS|AGU)E|OSSER)|E(?:T"
  "ERSBURG|NDER|RU)|I(?:CKRELL|ERCE|LGER)|O(?:TTER|NCA|LK)|HILLIPS|U"
  "RDUM)|A(?:L(?:(?:M(?:ERI)?|EXANDRI|D)A|L(?:IANCE|EN)|BION|VO)|R(?"
  ":C(?:ADIA|HER)|LINGTON|APAHOE|NOLD|THUR)|N(?:S(?:ELMO|LEY)|GORA)|"
  "M(?:E(?:LIA|S)|HERST)|SH(?:LAND|TON|BY)|T(?:KINSON|LANTA)|U(?:BUR"
  "N|RORA)|INSWORTH|XTELL|DAMS|GNEW|VOCA|BIE|YR)|L(?:E(?:(?:(?:XINGT"
  "|BAN)O|W(?:ELLE|ISTO))N|MOYNE|SHARA|IGH)|O(?:U(?:ISVILLE|P CITY)|"
  "(?:DGEPOL|NG PIN)E|OMIS|RTON)|I(?:N(?:COLN|DSAY|WOOD)|TCHFIELD|BE"
  "RTY|SCO)|A(?:(?:KESID|WRENC)E| ?VISTA|UREL|MAR)|Y(?:MAN|NCH|ONS))"
  "|D(?:A(?:V(?:E(?:NPORT|Y)|ID CITY)|(?:(?:LT|WS)O|YKI)N|N(?:NEBROG"
  "|BURY)|KOTA CITY)|E(?:(?:CATU|SHLE)R| WITT|WEESE|NTON)|O(?:RCHEST"
  "ER|NIPHAN|UGLAS|DGE)|U(?:N(?:NING|BAR|CAN)| BOIS)|I(?:X(?:ON)?|CK"
  "ENS|LLER)|WIGHT)|R(?:O(?:S(?:E(?:LAND|MONT)?|ALIE)|C(?:KVILLE|A)|"
  "GERS|YAL)|I(?:CH(?:FIEL|LAN)D|VER(?:DALE|TON)|SING CITY)|E(?:PUB("
  "?:LICAN)? CITY|D CLOUD|YNOLDS)|A(?:(?:LSTO|GA)N|NDOLPH|VENNA|YMON"
  "D)|U(?:S(?:HVILLE|KIN)|LO))|G(?:R(?:E(?:E(?:NWOOD|LEY)|SHAM|TNA)|"
  "A(?:N(?:D ISLAND|T)|FTON))|O(?:THENBURG|EHNER|RDON)|I(?:L(?:TNER|"
  "EAD)|BBON)|E(?:N(?:EV|O)A|RING)|L(?:ADSTONE|ENVIL)|U(?:IDE ROCK|R"
  "LEY)|AR(?:RISON|LAND))|O(?:R(?:(?:CHAR)?D|LEANS)|S(?:CEOLA|HKOSH|"
  "MOND)|(?:GALLAL|HIOW|MAH)A|FFUTT A(?: F |F)B|AK(?:DALE|LAND)?|C(?"
  ":TAVIA|ONTO)|DE(?:SSA|LL)|N(?:EILL|G)|VERTON|XFORD|BERT|TOE)|E(?:"
  "L(?:K(?: CREEK|HORN)|M(?: CREEK|WOOD)|S(?:MER|I)E|(?:YRI|B)A|LSWO"
  "RTH|WOOD|GIN)|D(?:DYVILLE|ISON|GAR)|ND(?:ICOTT|ERS)|M(?:ERSON|MET"
  ")|RICSON|USTIS|XETER|AGLE|WING)|N(?:E(?:W(?:(?:MAN GROV|CASTL)E|P"
  "ORT)|(?:HAWK|MAH)A|L(?:IGH|SON)|BRASKA CITY|NZEL)|OR(?:TH (?:PLAT"
  "TE|BEND|LOUP)|FOLK|MAN|A)|I(?:CKERSON|OBRARA)|AP(?:ONEE|ER))|F(?:"
  "A(?:IR(?:FIELD|BURY|MONT)|R(?:WELL|NAM)|LLS CITY)|O(?:R(?:T CALHO"
  "UN|DYCE)|NTANELLE|STER)|R(?:ANKLIN|EMONT|IEND)|U(?:LLERTON|NK)|I("
  "?:LLEY|RTH))|T(?:A(?:BLE ROCK|LMAGE|RNOV|YLOR)|R(?:(?:ENT|Y)ON|UM"
  "BULL)|H(?:EDFORD|URSTON)|E(?:CUMSE|KAMA)H|ILDEN|OBIAS)|V(?:E(?:RD"
  "(?:IGRE|EL|ON)|NANGO)|AL(?:PARAISO|ENTINE|LEY)|IRGINIA)|J(?:OHNS("
  "?:ON(?: LAKE)?|TOWN)|U(?:NIATA|LIAN)|A(?:CKSO|NSE)N)|K(?:E(?:N(?:"
  "ESAW|NARD)|YSTONE|ARNEY)|I(?:LGORE|MBALL))|I(?:N(?:DIANOLA|AVALE|"
  "LAND|MAN)|MPERIAL|THACA)|U(?:N(?:ADILLA|ION)|EHLING|LYSSES|PLAND|"
  "TICA)|Y(?:UTAN|ORK)))))$"
  ,
  /* -- NH -- NH -- NH -- NH -- NH -- NH -- NH -- NH -- NH -- NH -- */
  "(?:\\b)((?^:(?i:(?:W(?:E(?:ST(?: (?:S(?:TEWARTSTOWN|WANZEY)|CHEST"
  "ERFIELD|PETERBOROUGH|NOTTINGHAM|LEBANON|OSSIPEE)|MORELAND)|NTWORT"
  "H(?:S LOCATION)?|BSTER|ARE)|A(?:TERV(?:ILLE VALLE|L VL)Y|R(?:NER|"
  "REN)|SHINGTON|LPOLE)|O(?:LFEBORO(?: F(?:AL)?LS)?|ODS(?:VILLE|TOCK"
  ")|NALANCET)|I(?:N(?:D(?:HAM|SOR)|CHESTER|NISQUAM)|L(?:MOT|TON))| "
  "(?:STEWARTSTWN|CHESTERFLD|NOTTINGHAM|PETERBORO)|NTWRTHS LCTN|HITE"
  "FIELD)|N(?:O(?:RTH(?: (?:S(?:A(?:NDWICH|LEM)|TRATFORD|WANZEY|UTTO"
  "N)|W(?:OODSTOCK|ALPOLE)|HA(?:VERHILL|MPTON)|CONWAY)|(?:UMBERLA?N|"
  "FIEL|WOO)D)|TTINGHAM)|E(?:W(?: (?:(?:(?:HAMP|BOS)T|LOND)ON|IPSWIC"
  "H|CASTLE|DURHAM)|TON(?: J(?:UNCTION|CT))?|(?:MARKE|POR)T|FIELDS|I"
  "NGTON|BURY)|LSON)| (?:S(?:TRATFORD|ANDWICH)|HAVERHILL|WOODSTOCK)|"
  "ASHUA)|C(?:ENTER (?:S(?:TRAFFORD|ANDWICH)|TUFTONBORO|BARNSTEAD|OS"
  "SIPEE|CONWAY|HARBOR)|TR (?:S(?:TRAFFORD|ANDWICH)|BARNSTEAD|TUFTNB"
  "ORO|OSSIPEE)|H(?:A(?:RLESTOWN|THAM)|ESTER(?:FIELD)?|ICHESTER|OCOR"
  "UA)|O(?:N(?:TOOCOOK|CORD|WAY)|RNISH(?: FLAT)?|LEBROOK)|A(?:N(?:TE"
  "RBURY|AAN|DIA)|MPTON|RROLL)|LAR(?:KSVILLE|EMONT)|ROYDON)|S(?:T(?:"
  "RA(?:T(?:FORD|HAM)|FFORD)|EWARTSTOWN|INSON LAKE|ODDARD|ARK)|O(?:U"
  "TH (?:(?:HAMP|SUT)TON|(?:TAM|AC)WORTH|NEWBURY)|MERSWORTH)|A(?:N(?"
  ":BORN(?:VILLE|TON)|D(?:WICH|OWN))|L(?:ISBURY|EM))|U(?:N(?:APEE|CO"
  "OK)|GAR HILL|LLIVAN|RRY)|P(?:RINGFIEL|OFFOR)D|H(?:ELBURNE|ARON)|I"
  "LVER LAKE| TAMWORTH|EABROOK|WANZEY)|M(?:O(?:U(?:NT (?:WASHINGTON|"
  "SUNAPEE)|LTONBORO(?:UGH)?)|N(?:T VERNON|ROE))|I(?:L(?:TON(?: MILL"
  "S)?|FORD|AN)|RROR LAKE|DDLETON)|A(?:RL(?:BOROUGH|OW)|D(?:BURY|ISO"
  "N)|NCHESTER|SON)|E(?:R(?:RIMACK|EDITH|IDEN)|LVIN V(?:ILLAGE|LG))|"
  "T WASHINGTON|UNSONVILLE)|H(?:A(?:R(?:TS L(?:OCATIO|CT)N|RISVILLE)"
  "|MP(?:TON(?: FALLS)?|STEAD)|LES L(?:OCATIO|CT)N|N(?:COCK|OVER)|VE"
  "RHILL)|O(?:L(?:DERNES|LI)S|PKINTON|OKSETT)|I(?:LL(?:SBORO(?:UGH)?"
  ")?|NSDALE)|E(?:NNIKER|BRON)|UDSON)|E(?:A(?:ST (?:H(?:AMPSTEAD|EBR"
  "ON)|(?:LEMPST|ANDOV)ER|WAKEFIELD|KINGSTON|CANDIA|DERRY)|TON CENTE"
  "R)|NFIELD(?: C(?:ENTE|T)R)?| (?:HAMPSTEA|WAKEFIEL)D|L(?:LSWORTH|K"
  "INS)|P(?:PING|SOM)|FFINGHAM|XETER|RROL|TNA)|G(?:R(?:EEN(?:(?:FIEL"
  "|LAN)D|VILLE)|A(?:NTHAM|FTON)|OVETON)|IL(?:MANTON(?: I(?:RON WORK"
  "S|W))?|FORD|SUM)|O(?:(?:FFSTOW|SHE)N|RHAM)|LEN(?:CLIFF)?|EORGES M"
  "ILLS|UILD)|L(?:I(?:T(?:CHFIELD|TLETON)|(?:NCOL|SBO)N)|Y(?:M(?:E(?"
  ": CENTER)?|AN)|NDEBOROUGH)|A(?:N(?:CASTER|DAFF|GDON)|CONIA)|O(?:N"
  "DONDERRY|CHMERE|UDON)|E(?:MPSTER|BANON|E))|B(?:R(?:E(?:TTON WOODS"
  "|NTWOOD)|OOK(?:FIELD|LINE)|ADFORD|ISTOL)|E(?:(?:N(?:NING)?TO|RLI)"
  "N|THLEHEM|DFORD|LMONT)|A(?:R(?:RINGTON|NSTEAD|TLETT)|TH)|O(?:SCAW"
  "EN|W))|D(?:U(?:(?:NBARTO|BLI)N|MMER|RHAM)|A(?:N(?:VILLE|BURY)|LTO"
  "N)|E(?:ER(?:FIELD|ING)|RRY)|(?:REWS|IX)VILLE|O(?:RCHEST|V)ER)|A(?"
  ":L(?:TON(?: BAY)?|EXANDRIA|LENSTOWN|STEAD|BANY)|(?:TKINSO|UBUR)N|"
  "SH(?:UELOT|LAND)|N(?:DOVER|TRIM)|CWORTH|MHERST)|P(?:E(?:TERBOROUG"
  "H|MBROKE|NACOOK|LHAM)|I(?:TTS(?:FIELD|BURG)|ERMONT|KE)|L(?:AI(?:N"
  "FIELD|STOW)|YMOUTH)|ORTSMOUTH)|R(?:O(?:LLINSFORD|CHESTER|XBURY)|A"
  "(?:NDOLPH|YMOND)|I(?:CHMOND|NDGE)|YE(?: BEACH)?|UMNEY)|F(?:R(?:AN"
  "(?:C(?:ESTOWN|ONIA)|KLIN)|E(?:EDOM|MONT))|ITZWILLIAM|ARMINGTON)|T"
  "(?:(?:(?:HORN|IL)TO|WIN MOUNTAI)N|AMWORTH|EMPLE|ROY)|K(?:E(?:(?:A"
  "RSARG|EN)E|NSINGTON)|INGSTON)|J(?:A(?:CKSON|FFREY)|EFFERSON)|O(?:"
  "R(?:ANGE|FORD)|SSIPEE)|INTERVALE|UNION))))$"
  ,
  /* -- NJ -- NJ -- NJ -- NJ -- NJ -- NJ -- NJ -- NJ -- NJ -- NJ -- */
  "(?:\\b)((?^:(?i:(?:M(?:O(?:N(?:MOUTH (?:J(?:UNCTION|CT)|B(?:EA)?C"
  "H)|T(?:(?:V(?:IL|A)L|AGU)E|CLAIR)|ROE(?: T(?:OWNSHI|W)P|VILLE)?)|"
  "UNT(?: (?:(?:EPHRAI|FREEDO)M|(?:LAURE|ROYA)L|ARLINGTON|HOLLY|TABO"
  "R)|AIN(?: L(?:AKE|K)S|SIDE))|R(?:RIS(?: PLAINS|TOWN)|GANVILLE)|O("
  "?:RESTOWN|NACHIE))|A(?:N(?:(?:A(?:(?:LAP|SQU)A|HAWKI)|NINGTO)N|CH"
  "ESTER(?: T(?:OWNSHIP|W))?|T(?:OLOKING|UA)|VILLE)|R(?:L(?:BORO|TON"
  ")|GATE CITY|TINSVILLE|MORA)|(?:URICETOW|DISO|TAWA)N|Y(?:S LANDING"
  "|WOOD)|PLE(?: SHADE|WOOD)|(?:GNOLI|LAG)A|HWAH)|I(?:L(?:L(?:STONE "
  "T(?:OWNSHI|W)P|(?:INGTO|BUR|TOW)N|VILLE)|FORD|MAY)|D(?:DLE(?:VILL"
  "E|TOWN|SEX)|LAND PARK)|N(?:E HILL|OTOLA)|CKLETON|ZPAH)|E(?:RC(?:H"
  "ANT|ER)VILLE|DFORD(?: LAKES)?|TUCHEN|NDHAM)|C(?: (?:GUIRE AFB|AFE"
  "E)|KEE CITY)|YSTIC ISLA?NDS|T ARLINGTON|ULLICA HILL)|S(?:O(?:UTH("
  "?: (?:HA(?:RRISON TOWNSHIP|CKENSACK)|(?:SEAVILL|ORANG)E|BOUND BRO"
  "OK|PLAINFIELD|DENNIS|AMBOY|RIVER)|AMPTON)|MER(?:S(?: POIN|E)T|(?:"
  "VIL|DA)LE))|T(?:A(?:FFORD T(?:OWNSHI|W)P|N(?:HOPE|TON))|O(?:CK(?:"
  "HOLM|TON)|NE HARBOR)|I(?:LLWATER|RLING)|RAT(?:HMERE|FORD)|EWARTSV"
  "ILLE)|E(?:A(?: (?:(?:BRIGH|GIR)T|ISLE CITY)|SIDE (?:H(?:EIGH|G)TS"
  "|PARK)|BROOK)|RGEANTSVI?LLE|W(?:AREN|ELL)|CAUCUS)| (?:HA(?:RRISN "
  "TWP|CKENSACK)|BOUND BROOK|PLAINFIELD|SEAVILLE)|H(?:I(?:P BOTTOM|L"
  "OH)|ORT HILLS|REWSBURY|AMONG)|A(?:DDLE (?:BROOK|RIVER)|YREVILLE|N"
  "DYSTON|LEM)|C(?:HOOLEYS M(?:OUNTAI|T)N|OTCH PLAINS)|P(?:RING(?: L"
  "AKE|FIELD)|OTSWOOD|ARTA)|U(?:CCASUNNA|RF CITY|MMIT|SSEX)|W(?:ARTS"
  "WOOD|EDESBORO)|(?:ICKLER|MITH)VILLE|KILLMAN)|W(?:E(?:ST(?: (?:C(?"
  ":OLLINGSWOOD(?: HEIGHTS)?|A(?:LDWELL|PE MAY)|REEK)|(?:(?:PATERS|T"
  "RENT)O|BERLI)N|WI(?:LDWOOD|NDSOR)|(?:DEPT|MIL)FORD|LONG BRANCH|AL"
  "LENHURST|NEW YORK|ORANGE)|(?:FIEL|WOO)D|AMPTON|VILLE|MONT)|EHAWKE"
  "N|NONAH)|A(?:L(?:L(?:PACK C(?:ENTE|T)R| TOWNSHIP|INGTON)?|DWICK)|"
  "T(?:ERFORD W(?:OR)?KS|CHUNG)|SHINGTON(?: TWPS)?|R(?:ETOW|RE)N|(?:"
  "NAQU|YN)E)|OO(?:D(?:B(?:URY(?: (?:HEIG)?HTS)?|(?:RIDG|IN)E)|CLIFF"
  " L(?:AKE|K)| RIDGE|STOWN)|LWICH T(?:OWNSHI|W)P)|I(?:L(?:LI(?:AMST"
  "OWN|NGBORO)|DWOOD(?: CRE?ST)?)|N(?:FIELD PARK|DSOR|SLOW)|CKATUNK)"
  "|H(?:I(?:T(?:E(?:HOUSE(?: STATION)?| HSE STA|SBORO)|ING)|PPANY)|A"
  "RTON)| (?:C(?:OLL(?:S HGT)?S|ALDWELL)|LONG BRANCH|ALLENHURST)|RIG"
  "HTSTOWN|YCKOFF)|P(?:O(?:RT (?:M(?:ONMOUTH|URRAY)|RE(?:PUBLIC|ADIN"
  "G)|ELIZABETH|NORRIS)|M(?:PTON (?:PL(?:AI)?N|LAKE)S|ONA)|INT PLEAS"
  "ANT B(?:EACH|ORO)|TTERSVILLE)|I(?:NE (?:B(?:EACH|ROOK)|VALLEY|HIL"
  "L)|LESGR(?:OVE(?: TOWNSHIP)?|V TWP)|T(?:TS(?:GROVE|TOWN)|MAN)|CAT"
  "INNY ARS(?:ENAL)?|SCATAWAY)|E(?:NN(?:S(?:(?: GROV|VILL)E|AUKEN)|I"
  "NGTON)|R(?:RINEVILLE|TH AMBOY)|(?:DRICKTOW|MBERTO)N|(?:QUANNO|APA"
  ")CK)|A(?:R(?:K RIDGE|SIPPANY|AMUS|LIN)|L(?:ISADES P(?:AR)?K|MYRA)"
  "|ULSBORO|TERSON|SSAIC)|R(?:INCETON(?: J(?:UNCTION|CT))?|OSPECT PA"
  "RK|T ELIZABETH)|L(?:AIN(?:FIELD|SBORO)|EASANTVILLE|UCKEMIN)|T PLE"
  "AS(?:ANT(?: B(?:EACH)?)?| BCH)|HILLIPSBURG)|B(?:E(?:R(?:LIN(?: T("
  "?:OWNSHI|W)P)?|KELEY (?:HEIG)?HTS|NARDSVILLE|GENFIELD)|L(?:L(?:E("
  "?: MEAD|VILLE)|MAWR)|VIDERE|FORD|MAR)|ACH(?: HAVEN|WOOD)|DMINSTER"
  "|VERLY)|R(?:I(?:DGE(?:WATER|PORT|TON)|(?:GANTIN|ELL)E|CK)|O(?:OK("
  "?:LAWN|SIDE)|WNS MILLS|ADWAY)|A(?:NCH(?:VILLE|BURG)|DLEY BEACH))|"
  "A(?:R(?:NEGAT(?: L(?:IGH|G)T)?|RINGTON)|Y(?:(?:VILL|ONN)E| HEAD)|"
  "SKING RIDGE|PTISTOWN|TSTO)|U(?:RL(?:INGTON(?: (?:TOWNSHIP|CITY))?"
  "|NGTN (?:CITY|TWP))|T(?:TZVILLE|LER)|DD LAKE|ENA)|L(?:A(?:CKWOOD("
  "?: TER(?:RACE)?)?|IRSTOWN|WENBURG)|OOM(?:INGDALE|FIELD|SBURY))|O("
  "?:(?:RDENTOW|ONTO)N|UND BROOK|GOTA)|IRMINGHAM)|L(?:A(?:KE(?: (?:H"
  "(?:OPATCONG|IAWATHA)|COMO)|HURST(?: NAEC?)?|WOOD)|W(?:RENCE(?: T("
  "?:OWNSHI|W)P|VILLE)?|NSIDE)|URE(?:NCE H(?:ARBO|B)R|L SP(?:RIN)?GS"
  ")|N(?:DI(?:SVILLE|NG)|OKA HARBOR)|(?:(?:VALL|FAY)ETT|MBERTVILL)E|"
  "YTON)|I(?:TTLE (?:EGG HARBOR(?: TWP)?|F(?:ALLS|ERRY)|SILVER|YORK)"
  "|N(?:C(?:OLN PARK|ROFT)|DEN(?:WOLD)?|WOOD)|BERTY CO(?:RNE)?R|VING"
  "STON)|O(?:NG(?: (?:B(?:EACH(?: TOWNSHIP)?|CH TWP|RANCH)|VALLEY)|P"
  "ORT)|GAN T(?:OWNSHI|W)P|C(?:H ARBOUR|UST)|DI)|E(?:E(?:DS POINT|SB"
  "URG)|ON(?:ARDO|IA)|DGEWOOD|BANON)|UMBERTON(?: T(?:OWNSHI|W)P)?|Y("
  "?:NDHURST|ONS)|K HOPATCONG|TL EGG HBR)|H(?:A(?:R(?:RI(?:NGTON P(?"
  ":AR)?K|SON(?:VILLE)?)|D(?:YSTON|WICK)|VEY CEDARS)|DDON(?: (?:H(?:"
  "EIGH|G)?TS|T(?:OWNSHI|W)P)|FIELD)|M(?:ILTON(?: SQ(?:UARE)?)?|(?:M"
  "ON|P)TON|BURG)|INESP(?:ORT(?: TOWNSHIP)?|RT TWP)|S(?:BROUCK (?:HE"
  "IG)?HTS|KELL)|CKE(?:TTSTOWN|NSACK)|NCOCKS BR(?:IDGE|G)|W(?:THORNE"
  "|ORTH)|LEDON|ZLET)|I(?:GH(?:LAND(?: (?:L(?:AKE|K)S|PARK)|S)| BRID"
  "GE|TSTOWN)|LLS(?:(?:DAL|ID)E|BOROUGH)|(?: NELL|BERNI)A)|O(?:P(?:E"
  "(?:LAWN|WELL)?|ATCONG)|(?:LMDE|WEL)L| HO KUS|BOKEN)|E(?:ISLERVILL"
  "E|LMETTA|WITT))|C(?:A(?:PE MAY(?: (?:C(?:OURT HOUSE|H)|P(?:OIN)?T"
  "))?|R(?:NEYS POIN|LSTAD|TERE)T|L(?:DWELL|IFON)|MDEN)|L(?:I(?:F(?:"
  "F(?:SIDE P(?:AR)?K|WOOD)|TON)|NTON)|A(?:RK(?:SB(?:ORO|URG))?|YTON"
  ")|EMENTON|OSTER)|O(?:L(?:O(?:GNE|NIA)|UMB(?:IA|US)|LINGSWOOD|TS N"
  "ECK)|NVENT STA(?:TION)?|RBIN CITY|OKSTOWN)|H(?:E(?:S(?:TER(?:FIEL"
  "D)?|ILHURST)|RRY HILL)|A(?:T(?:HAM(?: TWP)?|SWORTH)|NGEWATER))|R("
  "?:E(?:AM RIDGE|SSKILL)|AN(?:BURY|FORD)|OSSWICKS)|EDAR(?: (?:KNOLL"
  "S|BROOK|GROVE)|VILLE)|INNAMINSON)|N(?:E(?:W(?: (?:M(?:ONMOUTH|ILF"
  "ORD)|(?:LISB|VERN)ON|PROVIDE?NCE|BRUNSWICK|GRETNA|EGYPT)|F(?:OUND"
  "LAN|IEL)D|TON(?:VILLE)?|PORT|ARK)|SHANIC STA(?:TION)?|PTUNE(?: CI"
  "TY)?|TCONG)|OR(?:TH(?: (?:(?:(?:ARLINGT|HALED)O|MIDDLETOW)N|B(?:R"
  "(?:UNSWICK|ANCH)|ERGEN)|(?:PLAINFIEL|WILDWOO)D|CA(?:LDWELL|PE MAY"
  "))|FIELD|VALE)|MA(?:NDY B(?:EA)?CH)?|WOOD)| (?:(?:MIDDLETOW|ARLIN"
  "GTO)N|(?:PLAINFIEL|WILDWOO)D|CA(?:LDWELL|PE MAY)|BRUNSWICK)|A(?:T"
  "IONAL PAR|VESIN)K|UTLEY)|E(?:A(?:ST(?: (?:(?:BRUNSWIC|NEWAR)K|(?:"
  "MILLSTON|ORANG)E|(?:HANOVE|WINDSO)R|RUTHERFORD)|AMPT(?:ON(?: TOWN"
  "SHIP)?|N TWP))|TONTOWN)|GG H(?:ARBOR (?:T(?:OWNSHI|W)P|C(?:IT)?Y)"
  "|BR (?:CITY|TWP))|NGL(?:EW(?:OOD(?: CLIFFS)?|D CLFS)|ISHTOWN)| (?"
  ":RUTHERFORD|BRUNSWICK|MILLSTONE)|L(?:M(?:WOOD PARK|ER)|IZABETH|WO"
  "OD)|D(?:GEWATER(?: PA?RK)?|ISON)|S(?:TELL MANOR|SEX FELLS)|W(?:IN"
  "G|AN)|MERSON|VESHAM|RIAL)|R(?:O(?:C(?:K(?:Y HILL|LEIGH|AWAY)|HELL"
  "E PARK)|SE(?:L(?:LE(?: PARK)?|AND)|NHAYN|MONT)|XBURY T(?:OWNSHI|W"
  ")P|BBINSVILLE|OSEVELT|EBLING)|I(?:VER(?:(?: (?:EDG|VAL)|[DV]AL|SI"
  "D)E|TON)|DGE(?:FIELD(?: P(?:AR)?K)?|WOOD)|CH(?:LAN|WOO)D|NG(?:WOO"
  "D|OES)|O GRANDE)|A(?:N(?:COCAS|DOLPH)|(?:HWA|MSE)Y|RITAN)|U(?:THE"
  "RFORD|NNEMEDE|MSON)|E(?:ADINGTON|D BANK))|F(?:R(?:E(?:DON(?: T(?:"
  "OWNSHI|W)P)?|NCHTOWN|EHOLD)|ANKLIN(?: (?:L(?:AKE|K)S|PARK)|VILLE)"
  "?)|A(?:IR(?:(?: (?:HAVE|LAW)|TO)N|FIELD|VIEW)|R(?:MINGDALE| HILLS"
  ")|NWOOD)|OR(?:T(?: (?:MONMOUTH|HANCOCK|DIX|LEE)|ESCUE)|KED RIVER|"
  "DS)|L(?:OR(?:HAM PARK|ENCE)|A(?:GTOWN|NDERS)|EMINGTON)|IELDSBORO)"
  "|G(?:L(?:EN(?: (?:R(?:IDGE|OCK)|GARDNER)|DORA|WOOD)|OUC(?:ESTER C"
  "(?:IT)?|STR CIT)Y|A(?:SS(?:BORO|ER)|DSTONE))|RE(?:EN(?: (?:(?:BRO"
  "O|CREE)K|VILLAGE)|DELL|WICH)|YSTONE P(?:AR)?K|AT MEADOWS|NLOCH)|I"
  "(?:BBS(?:BORO|TOWN)|LLETTE)|A(?:R(?:FIEL|WOO)D|LLOWAY)|UTTENBERG|"
  "OSHEN)|T(?:O(?:W(?:NS(?:END(?:S INLE| INL)T|HIP OF WASHINGTON)|AC"
  "O)|MS RIVER|TOWA)|E(?:N(?:AFLY|NENT)|TERBORO|ANECK)|U(?:CK(?:ERTO"
  "N|AHOE)|RNERSVILLE)|H(?:REE BRIDGES|OROFARE)|I(?:NTON FALLS|TUSVI"
  "LLE)|R(?:ANQUILITY|ENTON)|WP WASHIN(?:GT|TO)N|ABERNACLE)|A(?:L(?:"
  "L(?:EN(?:HURST|DALE|TOWN|WOOD)|(?:AMUCH|OWA)Y)|P(?:INE|HA))|T(?:L"
  "ANTIC (?:H(?:IGHLAN|L)DS|CITY)|CO)|V(?:ON BY(?: THE)? SEA|ALON|EN"
  "EL)|N(?:NANDALE|DOVER)|B(?:ERDEE|SECO)N|U(?:DUBON|GUSTA)|SBURY(?:"
  " PARK)?|DELPHIA)|D(?:E(?:L(?:A(?:WARE|NCO|IR)|(?: HAVE|RA)N|MONT)"
  "|E(?:RFIELD S(?:TREE)?T|PWATER)|N(?:NIS)?VILLE|MAREST|AL)|O(?:R(?"
  ":CHESTER|OTHY)|VER)|IVIDING CR(?:EE)?K|U(?:NELLEN|MONT)|AYTON)|O("
  "?:CEAN(?: (?:G(?:ROV|AT)E|CITY|VIEW)|VILLE|PORT)?|AK(?:L(?:AND|YN"
  ")| RIDGE|HURST)|LD(?: (?:BRIDGE|TAPPAN)|WICK)|RA(?:DELL|NGE)|SBOR"
  "NSVILLE|GDENSBURG|XFORD)|K(?:E(?:N(?:DALL PARK|ILWORTH|VIL)|A(?:("
  "?:SBE|RN)Y|NSBURG)|YPORT)|I(?:RKW(?:D VRHES|OOD)|N(?:GST|NEL)ON))"
  "|I(?:N(?:D(?:USTRIAL)? HILLSIDE|TERLAKEN)|S(?:LAND H(?:EIGH|G)TS|"
  "ELIN)|R(?:VINGTON|ONIA)|MLAYSTOWN)|U(?:P(?:PER (?:SADDLE RIVE|MON"
  "TCLAI)|R MONTCLAI)R|NION(?: (?:BEACH|CITY))?| SADDLE RIV)|V(?:I(?"
  ":N(?:CENTOWN|ELAND)|ENNA|LLAS)|E(?:R(?:NON|ONA)|NTNOR CITY)|AUXHA"
  "LL|OORHEES)|J(?:O(?:HNSONBURG|BSTOWN)|A(?:MESBURG|CKSON)|ERSEY CI"
  "TY|ULIUSTOWN)|QU(?:AKERTOW|INTO)N|YARDVILLE|ZAREPHATH))))$"
  ,
  /* -- NM -- NM -- NM -- NM -- NM -- NM -- NM -- NM -- NM -- NM -- */
  "(?:\\b)((?^:(?i:(?:C(?:O(?:N(?:T(?:INENTAL DIVIDE|NENTAL DV)|CHAS"
  " DAM)|CHITI (?:PUE?BLO|LAKE)|R(?:(?:DOV|ON)A|RALES)|UNSELOR|LUMBU"
  "S|STILLA|YOTE)|A(?:N(?:ON(?:CITO|ES)|NON AFB|JILON)|P(?:(?:ITA|UL"
  "I)N|ROCK)|R(?:RIZOZO|LSBAD|SON)|SA BLANCA|BALLO|USEY)|L(?:I(?:NES"
  " CO(?:RNE)?RS|FF)|O(?:UDCROFT|VIS)|A(?:UNCH|YTON)|EVELAND)|H(?:A("
  "?:M(?:BERINO|ISAL|A)|PARRAL|CON)|URCH ROCK|IMAYO)|E(?:DAR(?: CRES"
  "T|VALE)|RR(?:ILLOS|O)|BOLLA|NTRAL)|U(?:(?:CHILL|NDIY|ERV)O|B(?:ER"
  "O|A))|RO(?:SSROADS|WNPOINT)|IMARRON)|S(?:A(?:N(?: (?:J(?:UAN P(?:"
  "UE)?BLO|O(?:SE|N))|(?:PATRICI|LORENZ|YSIDR)O|(?:CRISTOBA|RAFAE)L|"
  "A(?:NTONIT?O|CACIA)|F(?:ELIPE PB|IDEL)|M(?:IGUEL|ATEO))|T(?:A (?:"
  "ANA PUE(?:BLO)?|(?:TERE|RO)SA|C(?:LARA|RUZ)|FE)|O DOMINGO PUEBLO)"
  "|DIA P(?:UEBLO|ARK)|OSTEE)|(?:CRAMENT|PELL)O|INT VRAIN|LEM)|E(?:("
  "?:N(?:EC)?|BOYET|RAFIN)A|DAN)|T(?: DMNG PBLO|ANLEY|EAD)|H(?:EEP S"
  "PRINGS|IPROCK)|UN(?:LAND PARK|SPOT)|O(?:CORR|LAN)O|ILVER CITY|MIT"
  "H LAKE|PRINGER)|M(?:E(?:S(?:ILLA(?: PARK)?|CALERO|QUITE)|(?:XICAN"
  " SP(?:RIN)?G|DANALE)S|(?:NTMOR|LROS)E)|O(?:N(?:T(?:ICELLO|EZUMA)|"
  "UMENT)|UNT(?:AINAIR| DORA)|R(?:IARTY|A)|GOLLON|SQUERO)|A(?:L(?:JA"
  "MAR|AGA)|(?:XWE|YHI)LL|GDALENA|NUELITO|DRID)|I(?:L(?:NESAND|AN|LS"
  ")|MBRES|AMI)|C (?:ALISTER|DONALD|INTOSH)|ULE CREEK)|L(?:A(?: (?:("
  "?:M(?:ADER|ES)|J(?:AR|OY)|PLAT)A|L(?:OMA|UZ))|KE(?: (?:ARTHU|SUMN"
  "E)R|WOOD)|S (?:(?:TABL|VEG)A|CRUCE)S|GUNA|MY)|O(?:S (?:R(?:ANCHOS"
  "(?: DE ALBUQUERQUE)?|NCHS ABQ)|(?:(?:ALAM|OJ)O|LUNA)S)|VING(?:TON"
  ")?|CO HILLS|RDSBURG|GAN)|IN(?:DRITH|COLN|GO)|E(?:MITAR|DOUX)|U(?:"
  "MBERTON|NA)|LANO)|T(?:R(?:U(?:TH (?:OR CONSEQUENCES|CONSQ)|CHAS)|"
  "E(?:S PIEDRAS|MENTINA)|AMPAS)|A(?:OS(?: SKI V(?:ALLE|L)Y)?|JIQUE|"
  "IBAN|MAYA|TUM)|I(?:(?:ER)?RA AMARILLA|MBERON|JERAS|NNIE)|O(?:HA(?"
  ":JIILEE|TCHI)|RREON|ME)|E(?:(?:RERR|XIC)O|SUQUE)|U(?:CUMCARI|LARO"
  "SA)|HOREAU| OR C|YRONE)|P(?:(?:UE(?:BLO OF ACOM|RTA DE? LUN)|BLO "
  "OF ACOM)A|I(?:N(?:O(?:S ALTOS|N)|EHILL)|E TOWN|CACHO)|E(?:NA(?: B"
  "LANCA|SCO)|(?:RALT|TAC)A|COS|P)|O(?:(?:LVADER|NDEROS)A|JOAQUE|RTA"
  "LES)|A(?:GUATE|STURA)|LA(?:CIT|Y)AS|REWITT)|R(?:A(?:(?:DIUM SPR(?"
  ":IN)?G|NCHOS DE TAO)S|INSVILLE|MAH|TON)|O(?:(?:AD FORK|GER)S|CIAD"
  "A|SWELL|DEO|WE|Y)|E(?:D(?: RIVER|ROCK)|HOBOTH|SERVE|GINA)|U(?:IDO"
  "SO(?: DOWNS)?|THERON)|I(?:O RANCHO|BERA|NCON)|NCH DE TAOS)|A(?:R("
  "?:R(?:OYO (?:HOND|SEC)O|EY)|A(?:BELA|GON)|ENAS VALLEY|TESIA)|L(?:"
  "B(?:UQUERQUE|ERT)|AM(?:OGORDO|EDA)|GODONES|CALDE|TO)|N(?:T(?:ON C"
  "HICO|HONY)|G(?:EL FIRE|US)|IMAS|CHO)|M(?:ISTAD|ALIA)|BIQUIU|ZTEC)"
  "|B(?:E(?:L(?:L(?: RANCH|VIEW)|EN)|R(?:NALILL|IN)O|NT)|U(?:E(?:NA "
  "VISTA|YEROS)|DAGHERS|CKHORN)|L(?:OOMFIELD|UEWATER|ANCO)|R(?:OADVI"
  "EW|IMHALL)|OSQUE(?: FARMS)?|(?:AY)?ARD|INGHAM)|G(?:A(?:L(?:L(?:IN"
  "A|UP)|ISTEO)|R(?:FIELD|ITA)|MERCO)|L(?:EN(?:WOOD|COE|RIO)|ADSTONE"
  "|ORIETA)|R(?:A(?:NTS|DY)|ENVILLE)|O(?:NZALES RA?NCH|LDEN)|(?:UADA"
  "LUPIT|IL)A)|H(?:O(?:L(?:LOMAN A(?:IR FORCE BASE|FB)|MAN)|(?:US|P)"
  "E|BBS|NDO)|I(?:(?:GH ROLLS MOUNTAIN PAR| RLS MTN P)K|LLSBORO)|A(?"
  ":GERMAN|CHITA|NOVER|TCH)|ERNANDEZ|URLEY)|F(?:O(?:RT (?:S(?:TANTON"
  "|UMNER)|WINGATE|BAYARD)|LSOM)|A(?:IR(?:ACRES|VIEW)|RMINGTON|YWOOD"
  ")|L(?:O(?:RA VISTA|YD)|YING H)|ENCE LAKE|RUITLAND)|W(?:HITE(?: (?"
  ":SANDS(?: MISSILE RANGE)?|OAKS|ROCK)|S CITY)|A(?:T(?:ERFLOW|ROUS)"
  "|GON MOUND)|I(?:LL(?:IAMSBURG|ARD)|NSTON)|EED)|V(?:A(?:L(?:LECITO"
  "S|MORA|DEZ)|N(?:DERWAGEN|ADIUM)|D(?:IT)?O|UGHN)|I(?:LLANUEVA|RDEN"
  ")|E(?:GUITA|LARDE))|E(?:L(?: (?:PRAD|RIT)O|EPHANT BU?TTE|IDA)|S(?"
  ":PANOL|TANCI)A|(?:MBUD|NCIN)O|AGLE NEST|DGEWOOD|UNICE)|O(?:JO (?:"
  "CALIENTE|FELIZ|SARCO)|R(?:OGRANDE|GAN)|HKAY OWINGEH|IL CENTER|LD "
  "LAGUNA|SCURO|CATE)|N(?:A(?:VAJO(?: DAM)?|RA VISA|GEEZI|MBE)|EW(?:"
  " LAGUNA|COMB|KIRK)|OGAL)|D(?:E(?:S MOINES|MING|XTER|RRY)|O(?:NA A"
  "N|R)A|U(?:LCE|RAN)|ATIL|IXON)|J(?:EMEZ (?:SPRINGS|PUEBLO)|A(?:MES"
  "TOWN|RALES|L)|ICARILLA)|U(?:N(?:IV OF N(?:EW MEXICO|M)|M)|TE PARK"
  ")|K(?:IRTLAND(?: AFB)?|ENNA)|Y(?:OUNGSVILLE|ATAHEY|ESO)|QU(?:E(?:"
  "MADO|STA)|AY)|Z(?:IA PUEBLO|UNI)|I(?:LFELD|SLETA)))))$"
  ,
  /* -- NV -- NV -- NV -- NV -- NV -- NV -- NV -- NV -- NV -- NV -- */
  "(?:\\b)((?^:(?i:(?:M(?:O(?:UN(?:T(?:AIN (?:SPR(?:INGS|G)|CITY)| C"
  "HARLESTON)|D HOUSE)|NTELLO|APA)|C(?: (?:DERMITT|GILL)|CARRAN)|I(?"
  ":N(?:DEN|A)|LL CITY|DAS)|(?:T CHARLESTO|ANHATTA)N|E(?:SQUITE|RCUR"
  "Y))|C(?:A(?:L(?:I(?:CO BASIN|ENTE)|LVILLE BAY| NEV ARI)|R(?:SON C"
  "ITY|LIN))|O(?:YOTE SP(?:RIN)?GS|(?:LD|RN) CREEK|TTONWOOD CV)|R(?:"
  "ESCENT V(?:ALLE|L)|YSTAL BA)Y)|S(?:P(?:A(?:NISH SP(?:RIN)?G|RK)S|"
  "RING CREEK)|ILVER(?: (?:SP(?:RIN)?GS|CITY)|PEAK)|TA(?:GECOACH|TEL"
  "INE)|(?:ANDY|UN) VALLEY|EARCHLIGHT|CHURZ|LOAN|MITH)|W(?:E(?:(?:ST"
  " WE)?NDOVER|LL(?:INGTON|S))|A(?:SHOE VALLEY|LKER LAKE|DSWORTH)| W"
  "ENDOVER|INNEMUCCA)|B(?:A(?:TTLE M(?:OUNTAI|T)N|KER)|E(?:OWAWE|ATT"
  "Y)|LUE DIAMOND|OULDER CITY|UNKERVILLE)|G(?:O(?:L(?:DFIELD|CONDA)|"
  "ODSPRINGS)|A(?:RDNERVILLE|BBS)|E(?:RLACH|NOA)|LENBROOK)|I(?:N(?:D"
  "IAN SP(?:RINGS(?: AIR FORCE AUX)?|GS)|CLINE V(?:ILLAGE|LG))|MLAY|"
  "SAFA)|L(?:A(?:S VEGAS|MOILLE|UGHLIN)|O(?:GANDALE|CKWOOD|VELOCK)|U"
  "N(?:ING|D)|EE)|P(?:A(?:RADISE V(?:ALLE|L)Y|LM GARDENS|HRUMP|NACA)"
  "|IOCHE|RIMM)|E(?:M(?:IGRANT PASS|PIRE)|L(?:KO|Y)|NTERPRISE|UREKA)"
  "|R(?:OUND M(?:OUNTAI|T)N|U(?:BY VALLEY|TH)|ENO)|V(?:(?:IRGINIA CI"
  "T|ALM)Y|C HIGHLANDS|ERDI)|N(?:(?:ORTH)? LAS VEGAS|ELLIS AFB|IXON)"
  "|D(?:(?:UCKWAT|Y)ER|E(?:ETH|NIO)|AYTON)|A(?:MARGOSA V(?:ALLE|L)Y|"
  "USTIN|LAMO)|H(?:A(?:WTHORNE|LLECK)|ENDERSON|IKO)|J(?:A(?:RBIDGE|C"
  "KPOT)|IGGS|EAN)|O(?:ROVADA|VERTON|WYHEE|ASIS)|T(?:HE LAKES|USCARO"
  "RA|ONOPAH)|(?:ZEPHYR COV|UNIONVILL)E|F(?:ERNLEY|ALLON)|YERINGTON)"
  ")))$"
  ,
  /* -- NY -- NY -- NY -- NY -- NY -- NY -- NY -- NY -- NY -- NY -- */
  "(?:\\b)((?^:(?i:(?:S(?:O(?:U(?:TH(?: (?:F(?:A(?:RMINGDALE|LLSBURG"
  ")|LORAL PARK)|(?:(?:EDMES|DAY)TO|NEW BERLI)N|C(?:HEEKTOWAGA|OLTON"
  "|AIRO)|S(?:CHODACK|ETAUKET|ALEM)|B(?:ETHLEHEM|UTLER|YRON)|R(?:ICH"
  "MOND HILL|UTLAND)|(?:JAMESPOR|KORTRIGH)T|O(?:ZONE PARK|TSELIC)|W("
  "?:ESTERLO|ALES)|GLENS FALLS|HEMPSTEAD|PLYMOUTH|LIMA)|AMPTON|FIELD"
  "S|OLD)|ND BEACH)|DUS(?: (?:CENTER|POINT))?|L(?:SVILLE|VAY)| PLYMO"
  "UTH|MERS|NYEA)|A(?:INT (?:J(?:OHNSVILLE|AMES)|RE(?:GIS FALLS|MY)|"
  "(?:HUBERT|ALBAN)S|BONAVENTURE)|N(?:D(?:S POINT|Y CREEK| LAKE|USKY"
  ")|ITARIA SP(?:RINGS|G)|GERFIELD|BORN)|L(?:ISBURY (?:C(?:ENTE|T)R|"
  "M(?:IL)?LS)|T(?: POINT|AIRE)|AMANCA|EM)|R(?:A(?:TOGA SP(?:RIN)?GS"
  "|NAC(?: LAKE)?)|DINIA)|G(?: HARBOR|APONACK)|CKETS H(?:ARBO|B)R|U("
  "?:GERTIES|QUOIT)|V(?:ANNAH|ONA)|YVILLE|BAEL)|T(?:E(?:RLING(?: F(?"
  ":ORE|R)ST)?|L?LA NIAGARA|WART MANOR|PHENTOWN|AMBURG)|O(?:N(?:Y (?"
  ":(?:BROO|CREE)K|POINT)|E RIDGE)|(?:RM|TT)VILLE|CKTON|W)|A(?:(?:TE"
  "N ISLAN|[FM]FOR)D|N(?:FORDVILLE|LEY)|ATSBURG|R LAKE)|UYV(?:ESANT("
  "?: (?:F(?:ALLS|L)|PLAZA))?|SNT PLZ)| (?:(?:REGIS FL|BONA)S|JOHNSV"
  "ILLE)|R(?:YKERSVILLE|ATFORD)|I(?:LLWATER|TTVILLE))|C(?:H(?:UYLER("
  "?: (?:F(?:AL)?LS|LAKE)|VILLE)?|O(?:DACK L(?:ANDIN|ND)G|HARIE)|(?:"
  "AGHTICO|ROON LA)KE|ENE(?:CTADY|VUS))|OT(?:CHTOWN(?: BRANCH)?|TS(?"
  ":VILLE|BURG)|IA)|AR(?:BOROUGH|SDALE)|I(?:PIO CENTER|O))| (?:F(?:A"
  "(?:RMINGDALE|LLSBURG)|LORAL PARK)|(?:JAMESPOR|KORTRIGH)T|(?:NEW B"
  "ERLI|EDMESTO)N|S(?:CHODACK|ETAUKET)|(?:OZONE PAR|CHEE)K|GLENS FAL"
  "LS|RICHMOND HL|BETHLEHEM|HEMPSTEAD|WESTERLO)|H(?:E(?:LTER IS(?:LA"
  "ND(?: HEIGHTS)?| HT)?|R(?:(?:ID|M)AN|BURNE|RILL)|NOROCK)|A(?:RON "
  "SP(?:RIN)?GS|NDAKEN|DY)|O(?:R(?:TSVILLE|EHAM)|KAN)|I(?:NHOPPLE|RL"
  "EY)|RUB OAK|USHAN)|P(?:R(?:ING(?:F(?:IELD (?:GARDENS|CENTER)|LD C"
  "TR)| (?:VALLEY|BROOK|GLEN)|VILLE|WATER)|(?:NGFLD GDN|AKER)S)|E(?:"
  "NCER(?:PORT|TOWN)?|CULATOR|ONK)|AR(?:ROW ?BUSH|KILL))|L(?:ATE(?:R"
  "V(?:ILLE SPRINGS|LE SPG)| HILL)|OA(?:N(?:SVILLE)?|TSBURG)|EEPY HO"
  "LLOW|INGERLANDS)|I(?:LVER (?:SP(?:RIN)?GS|CREEK|LAKE|BAY)|DNEY(?:"
  " CENTER)?|NCLAIRVILLE|ENA)|E(?:NECA (?:CASTLE|FALLS)|A(?: CLIFF|F"
  "ORD)|L(?:KIRK|DEN)|VERANCE|TAUKET)|M(?:ITH(?:V(?:ILLE(?: FLATS)?|"
  "LE FLTS)| POINT|BORO|TOWN)|ALLWOOD|YRNA)|U(?:N(?:NYSIDE|DOWN)|MMI"
  "T(?:VILLE)?|GAR LOAF|RPRISE|FFERN)|KAN(?:EATELE(?:S FALL)?| FALL)"
  "S|W(?:A(?:N LAKE|IN)|ORMVILLE)|Y(?:LVAN BEACH|RACUSE|OSSET)|NYDER"
  ")|C(?:O(?:L(?:L(?:I(?:NS(?: C(?:ENTE|T)R)?|ERSVILLE)|EGE POINT)|D"
  "(?: (?:SP(?:RING(?: HARBOR)?|G HBR)|BROOK)|EN)|(?:UMBIAVILL|ONI)E"
  "|TON)|R(?:N(?:WALL(?: (?:ON HUDSO|HDS)N|VILLE)?|ING)|TLAND(?:T M("
  "?:ANO|N)R)?|BETTSVILLE|INTH|ONA|AM|FU)|N(?:STA(?:BLE(?:V(?:IL)?LE"
  ")?|NTIA)|E(?:WANGO V(?:ALLE|L)Y|SUS)|NELLY|GERS|KLIN)|P(?:AKE(?: "
  "FALLS)?|ENHAGEN|IAGUE)|OPERS(?: PL(?:AI)?NS|TOWN)|CHECTON(?: C(?:"
  "ENTE|T)R)?|EYMANS(?: HOL(?:LO)?W)?|(?:WLESVILL|XSACKI)E|(?:BLES|T"
  "TE)KILL|HO(?:CTON|ES)|M(?:STO|MA)CK|SSAYUNA)|A(?:S(?:T(?:LE(?:T(?"
  ":ON ON HUDS)?ON| (?:CREEK|POINT))|ORLAND|ILE)|S(?:ADAGA|VILLE))|N"
  "(?:A(?:(?:S(?:ERAG|TOT)|NDAIGU)A|L STREET|JOHARIE|AN)|EADEA|ISTEO"
  "|DOR|TON)|M(?:BRI(?:A (?:HEIG)?HTS|DGE)|ERON(?: MILLS)?|PBE(?:LL "
  "HA)?LL|ILLUS|DEN)|L(?:LICOON(?: C(?:ENTE|T)R)?|EDONIA|VERTON|CIUM"
  ")|R(?:(?:L(?:E PLAC|ISL)|OGA LAK|THAG)E|MEL)|P(?:TREE IS(?:LAND)?"
  "|E VINCENT)|T(?:TARAUGUS|SKILL|O)|(?:YU[GT]|ZENOVI)A|D(?:YVILLE|O"
  "SIA)|IRO)|H(?:E(?:ST(?:NUT R(?:IDGE|DG)|ER(?:TOWN)?)|NANGO (?:BR("
  "?:IDGE|G)|F(?:OR)?KS)|RRY (?:VALLEY|CREEK|GROVE|PLAIN)|(?:EKTOWAG"
  "|LSE)A|MUNG)|A(?:RL(?:OTTEV(?:IL)?LE|TON)|(?:SE MILL|DWICK)S|U(?:"
  "TAUQUA|MONT)|T(?:EAUGAY|HAM)|MPLAIN|PPAQUA|FFEE|ZY)|I(?:PPEWA BAY"
  "|TTENANGO|CHESTER|LDWOLD|NATOWN)|UR(?:CHVILLE|UBUSCO))|L(?:A(?:R("
  "?:EN(?:CE(?: C(?:ENTE|T)R)?|DON)|K(?:S(?:VILLE|ON)| MILLS)|YVILLE"
  ")|Y(?:VILLE|TON)?|VERACK)|I(?:NTON(?: CO(?:RNE)?RS|(?:VIL|DA)LE)?"
  "|FTON(?: (?:SP(?:RIN)?GS|PARK))?|MAX)|E(?:VE(?:RDALE|LAND)|MONS)|"
  "Y(?:MER|DE)|OCKVILLE)|R(?:O(?:TON (?:(?:ON HUDSO|HDS)N|FALLS)|PSE"
  "YVILLE|SS RIVER|WN POINT|MPOND|GHAN)|A(?:NBERRY L(?:AKE|K)|RYVILL"
  "E|GSMOOR)|ITTENDEN|UGERS)|E(?:NT(?:RAL (?:BR(?:IDGE|G)|V(?:ALLE|L"
  ")Y|SQ(?:UARE)?|ISLIP)|ER(?: MORICHES|VILLE|EACH|PORT))|(?:MENT|LO"
  "R)ON|DARHURST|RES)|U(?:(?:DDEBACKVI?LL|TCHOGU)E|YLER|BA)|I(?:NCIN"
  "NATUS|RCLEVILLE|CERO)|TR MORICHES)|W(?:E(?:ST(?: (?:C(?:(?:O(?:XS"
  "ACKI|PAK)|LARKSVILL)E|HA(?:RLTON|ZY)|AMP)|B(?:(?:LOOMFIEL|RENTWOO"
  ")D|A(?:BYLON|NGOR)|URLINGTON)|H(?:A(?:VERSTRAW|RRISON)|E(?:MPSTEA"
  "D|NRIETTA)|URLEY)|S(?:A(?:ND LAK|YVILL)E|TOCKHOLM|ENECA|HOKAN)|E("
  "?:(?:DMES|A)TON|XETER)|(?:GILGO BEAC|RUS)H|DA(?:VENPORT|NBY)|WIN("
  "?:FIELD|DSOR)|F(?:ULTON|ALLS)|LE(?:BANO|YDE)N|P(?:OINT|ARK)|ONEON"
  "TA|MONROE|VALLEY|ISLIP|NYACK|KILL)|(?:F(?:IEL|OR)|MORELAN)D|B(?:R"
  "OOKVI?LLE|URY)|HAMPTON(?: BEACH)?|ER(?:NVILLE|LO)|(?:DAL|GAT)E|ON"
  "S MILLS|PORT|TOWN)|LL(?:S(?:(?: BRIDG|VILL)E|BURG)?|ESLEY IS(?:LA"
  "ND)?)|BSTER(?: CR(?:OSSI|S)NG)?|EDSPORT|VERTOWN)|A(?:L(?:L(?: STR"
  "EET|KILL|ACE)|(?:DE|TO)N|KER VALLEY|ES CENTER|WORTH)|T(?:ER(?:V(?"
  ":ILLE|LIET)| MILL|FORD|PORT|TOWN|LOO)|KINS GLEN)|S(?:HINGT(?:ON(?"
  ":V(?:IL)?LE| MILLS)|N MLS)|SAIC)|R(?:NER(?:VILLE|S)|RENSBURG|WICK"
  "|SAW)|D(?:ING RIVER|DINGTON|SWORTH|HAMS)|PPINGERS F(?:ALLS|L)|VE("
  "?: CREST|RLY)|N(?:AKENA|TAGH)|Y(?:LAND|NE)|MPSVILLE|INSCOTT|WARSI"
  "NG|CCABUC)|H(?:I(?:T(?:E(?: (?:(?:SULPHUR SPRING|PLAIN)S|CREEK|LA"
  "KE)|S(?:(?:VILL|TON)E|BORO)|FACE M(?:OUNTAI|T)N|HALL)|NEY POINT)|"
  "PPLEVILLE)|(?:EATLEY (?:HEIG)?HT|T SPHR SPG)S|ALLONSBURG)| (?:H(?"
  ":A(?:MPTON BCH|VERSTRAW|RRISON)|E(?:MPSTEAD|NRIETTA))|B(?:(?:LOOM"
  "FIEL|RENTWOO)D|URLINGTON)|C(?:LARKSVILL|OXSACKI)E|S(?:AND LAKE|TO"
  "CKHOLM)|GILGO BEACH|DAVENPORT|WINDSOR)|I(?:L(?:L(?:I(?:AMS(?:(?:T"
  "OW|O)N|VILLE)|STON P(?:AR)?K)|S(?:EYVILLE|BORO)|ARD|ET|OW)|(?:(?:"
  "MING)?T|S)ON)|N(?:D(?:HAM|SOR)|GDALE|THROP)|(?:THERB|CCOP)EE)|O(?"
  ":OD(?:(?:RIDG|VILL|GAT|MER)E|B(?:OURNE|URY)|H(?:AVEN|ULL)|S(?:TOC"
  "K|IDE))|RCESTER|LCOTT)|Y(?:(?:NANTSKIL|KAGY)L|ANDANCH|OMING)|URTS"
  "BORO)|B(?:R(?:O(?:OK(?:(?:HAVE|LY)N|TONDALE|FIELD|VIEW)|AD(?: CHA"
  "NNEL|ALBIN)|C(?:KPORT|TON)|NX(?:VILLE)?|WNVILLE)|I(?:AR(?:CLIFF(?"
  ": MANOR)?|WOOD)|DGE(?:HAMPTON|WATER|PORT)|GHTWATERS|ER HILL|SBEN)"
  "|A(?:N(?:T(?:INGHAM| LAKE)?|CHPORT)|INARD(?:SV(?:IL)?LE)?|SHER FA"
  "LLS|DFORD)|E(?:E(?:ZY POIN|SPOR)T|W(?:ERTON|STER)|NTWOOD)|USHTON)"
  "|E(?:L(?:L(?:E(?:ROSE(?: (?:VIL(?:LAGE)?|MANOR))?| HARBOR|VILLE)|"
  "(?:MOR|VAL)E|RS MANOR|PORT|ONA)|(?:FAS|MON)T)|A(?:R(?: (?:MOUNTAI"
  "N|STEARNS)|SVILLE)|VER (?:(?:F(?:AL)?L|DAM)S|RIVER)|CON)|R(?:N(?:"
  "HARDS BAY|E)|(?:GE|LI)N|KSHIRE)|DFORD(?: (?:CO(?:RNE)?R|HILL)S)?|"
  "(?:MUS POIN|ECHHURS)T|TH(?:PAGE|EL))|A(?:R(?:NE(?:S CO(?:RNE)?RS|"
  "VELD)|RY(?:VILLE|TOWN)|DONIA|KER|TON)|L(?:DWIN(?:(?: PLAC|SVILL)E"
  ")?|LSTON (?:LAKE|SPA))|Y(?:(?: SHOR|VILL|SID)E|BERRY|PORT)|N(?:G("
  "?:ALL|OR)|KERS TRUST)|I(?:TING HOLLOW?|NBRIDGE)|T(?:AVIA|H)|KERS "
  "MILLS|BYLON|SOM)|L(?:O(?:OM(?:ING(?: GR(?:OVE|V)|BURG|DALE|TON)|F"
  "IELD|VILLE)|DGETT M(?:IL)?LS|SSVALE)|U(?:E (?:M(?:OUNTAI|T)N LAKE"
  "|POINT)|FF POINT)|A(?:CK (?:CREEK|RIVER)|SDELL|UVELT)|ISS)|O(?:L("
  "?:TON L(?:ANDIN|ND)G|IVAR)|W(?:LING GREEN|MANSVILLE)|(?:ICE|UCK|O"
  "N)VILLE|VINA CENTER|HEMIA|MBAY|STON)|U(?:R(?:L(?:ING(?:TON FLATS|"
  "HAM)|NGTN FLT)|(?:DET)?T|NT HILLS|KE)|LLVILLE|CHANAN|FFALO|SKIRK)"
  "|I(?:BLE SCH(?:OOL PAR| P)K|G (?:INDIAN|FLATS)|NGHAMTON|LLINGS)|Y"
  "RON)|M(?:A(?:R(?:I(?:(?:ETT|LL)A|ON)|T(?:INSBURG|VILLE)|Y(?:KNOLL"
  "|LAND)|C(?:ELLUS|Y)|GARETVILLE|ATHON|LBORO)|S(?:S(?:A(?:PEQUA(?: "
  "P(?:AR)?K)?|WEPIE)|ENA)|TIC(?: BEACH)?|ONVILLE|PETH)|N(?:HA(?:SSE"
  "T(?: HIL(?:LS)?)?|TTAN)|(?:NS|OR)VILLE|CHESTER|LIUS)|L(?:DEN (?:("
  "?:ON )?HUDSON|BRIDGE)|(?:VER|O)NE|[BT]A|LORY)|PLE(?: (?:SPRINGS|V"
  "IEW)|CREST)|C(?: DOUGALL|EDON|HIAS)|Y(?:BROOK|FIELD|VILLE)|TT(?:I"
  "TUCK|YDALE)|HOPAC(?: FALLS)?|D(?:ISON|RID)|MARONECK|INE)|O(?:UNT("
  "?: (?:(?:V(?:ERN|ISI)|UPT)ON|M(?:ARION|ORRIS)|TREMPER|KISCO|SINAI"
  ")|AIN(?: DA|VIL)LE)|N(?:T(?:E(?:BELLO|ZUMA)|OUR FALLS|GOMERY|ICEL"
  "LO|ROSE|AUK)|(?:GAUP V(?:ALLE|L)|SE)Y|ROE)|R(?:RIS(?:(?:ON)?VILLE"
  "|TOWN)?|I(?:AH(?: CENTER)?|CHES)|AVIA|TON)|H(?:EGAN LAKE|AWK)|DE("
  "?:L CITY|NA)|OER(?:S FORK)?S|TTVILLE|IRA)|I(?:D(?:DLE(?: (?:GR(?:"
  "ANVILL|OV)E|V(?:ILLAGE|LG)|ISLAND|FALLS)|BURGH|VILLE|PORT|TOWN|SE"
  "X)| HUDSON)|L(?:L(?:ER(?: PLACE|TON)|(?: NEC|BROO)K|PORT|WOOD)|(?"
  ":TO|A)N|FORD)|N(?:E(?:(?:OL|RV)A|VILLE|TTO)|OA))|E(?:R(?:ID(?:ALE"
  "|IAN)|RI(?:CK|LL)|EDITH)|C(?:HANICVILLE|KLENBURG)|L(?:(?:LEN)?VIL"
  "L|ROS)E|D(?:(?:IN|US)A|FORD)|N(?:ANDS|DON)|ACHAM|MPHIS|XICO)|C (?"
  ":CON(?:NELLSVIL|ELSVI)LE|DONOUGH|GRAW|LEAN)|U(?:(?:RRAY IS|NNSVIL"
  ")LE|MFORD)|DL GRANVILLE)|P(?:O(?:RT(?: (?:(?:(?:WASHINGT|GIBS|BYR"
  ")O|(?:LEYD|EW)E)N|JE(?:FF(?:ERS(?:ON STATI)?ON| STA)|RVIS)|C(?:HE"
  "STER|RANE)|HENRY|KENT)|ER CO(?:RNE)?RS|LAND(?:VILLE)?|(?:AGE)?VIL"
  "LE)|U(?:GH(?:KEEPSIE|QUAG)|ND RIDGE)|INT (?:LOOKOUT|O WOODS|VIVIA"
  "N)|(?:PLAR RIDG|OLVILL)E|T(?:TERSVILLE|SDAM)|M(?:ONA|PEY)|ESTENKI"
  "LL|ND EDDY|LAND)|A(?:L(?:ATINE BR(?:IDGE|G)|ENVILLE|ISADES|MYRA)|"
  "R(?:IS(?:H(?:VILLE)?)?|KSVILLE|ADOX)|T(?:TERSON(?:V(?:IL)?LE)?|CH"
  "OGUE)|N(?:OR)?AMA|INTED POST|UL SMITHS|VILION|WLING)|I(?:NE (?:(?"
  ":VALLE|CIT)Y|ISLAND|PLAINS|BUSH|HILL)|ER(?:REP(?:ONT MANO|NT MN)R"
  "|CEFIELD|MONT)|T(?:TSFORD|CHER)|LOT KNOB|FFARD|SECO|KE)|E(?:R(?:R"
  "Y(?:SBURG|VILLE)?|KINSVILLE|U)|N(?:N(?:ELLVILLE| YAN)|FIELD)|TER("
  "?:SBURGH?|BORO)|C(?:K SLIP|ONIC)|ARL RIVER|EKSKILL|LHAM)|L(?:A(?:"
  "TT(?:SBURGH|EKILL)|INVI(?:LLE|EW)|NDOME)|E(?:ASANT(?: V(?:ALLE|L)"
  "Y|VILLE)|SSIS)|YMOUTH)|R(?:ATTS(?: HOLLOW|BURGH|VILLE)|E(?:STON H"
  "OL(?:LO)?W|BLE)|T (?:JEFFERSO|WASHINGT)N|OSPECT|INCE)|U(?:L(?:T(?"
  ":NEYVILLE|ENEY)|ASKI)|TNAM (?:STA(?:TION)?|VALLEY)|R(?:CHASE|LING"
  "|DYS))|H(?:IL(?:(?:LIPSPOR|MON)T|ADELPHIA)|OENI(?:CIA|X)|ELPS)|YR"
  "ITES)|H(?:A(?:R(?:T(?:WICK(?: SEMINARY)?|SDALE|FORD)|RI(?:S(?:VIL"
  "LE|ON)?|MAN)|P(?:ERSFIELD|URSVILLE)|FORD(?: MILLS)?)|M(?:(?:ILTO|"
  "DE|LI)N|MOND(?:SPORT)?|PTON(?: BAYS)?|BURG)|N(?:N(?:A(?:WA FALLS|"
  "CROIX)|IBAL)|COCK|KINS)|L(?:COTT(?: C(?:ENTE|T)R|SVILLE)|ESITE|L)"
  "|STINGS(?: (?:ON HUDSO|HDS)N)?|I(?:NES FALLS|LESBORO)|(?:UPPAUG|W"
  "THORN)E|G(?:AMAN|UE)|YT CORNERS|VERSTRAW|DLEY)|O(?:L(?:L(?:AND(?:"
  " PATE?NT)?|OWVILLE|EY|IS)|TSVILLE|BROOK|MES)|P(?:EWELL(?: J(?:UNC"
  "TION|CT))?|KINTON)|W(?:E(?:S CAVE|LLS)|ARD BEACH)|R(?:TONVILLE|SE"
  "HEADS|NELL)|F(?:STRA UNIV|FMEISTER)|NEOYE(?: FALLS)?|OSICK(?: FAL"
  "LS)?|GANSBURG|UGHTON|BART|MER)|U(?:NT(?:INGT(?:(?:ON STATI)?ON|N "
  "STA)|ER)?|L(?:ETTS L(?:ANDIN|ND)G|BERTON)|G(?:HSONVILLE|UENOT)|(?"
  ":BBARDSVILL|M)E|DSON(?: FALLS)?|RLEY(?:VILLE)?)|I(?:GH(?:LAND(?: "
  "(?:(?:F(?:AL)?|M(?:IL)?)LS|LAKE))?| FALLS|MOUNT)|L(?:L(?:S(?:IDE "
  "M(?:ANO|N)R|DALE)|BURN)|TON)|N(?:CKLEY|SDALE)|CKSVILLE|MROD)|E(?:"
  "N(?:DERSON(?: H(?:ARBO|B)R)?|SONVILLE|RIETTA)|M(?:PSTEAD|LOCK)|R("
  "?:KIMER|MON)|ATHCOTE|UVELTON|WLETT|CTOR|LENA)|RTWK SEMINRY|YDE PA"
  "RK)|N(?:OR(?:T(?:H(?: (?:B(?:A(?:(?:BYLO|LDWI)N|NGOR|Y)|R(?:OOKFI"
  "ELD|ANCH)|ELLMORE|LENHEIM|OSTON)|C(?:O(?:HOCTON|LLINS)|H(?:ATHAM|"
  "ILI)|ASTLE|REEK)|(?:GR(?:ANVILL|EEC)|LAWRENC)E|N(?:EW HYDE PARK|O"
  "RWICH)|H(?:OOSICK|UDSON|ILLS)|T(?:ARRYTOWN|ONAWANDA)|M(?:ASSAPEQU"
  "A|ERRICK)|S(?:YRACUSE|ALEM)|R(?:IVER|OSE)|PITCHER|EVANS|JAVA)|VIL"
  "LE|PORT)|ON HILL)|W(?:ICH|OOD)|FOLK)|E(?:W(?: (?:H(?:A(?:M(?:BURG"
  "|PTON)|RTFORD|VEN)|YDE PARK)|YORK(?: (?:M(?:IL)?LS|CITY))?|(?:L(?"
  ":EBAN|ISB)|KINGST)ON|W(?:OODSTOCK|INDSOR)|B(?:ALTIMORE|ERLIN)|R(?"
  ":OCHELLE|USSIA)|MILFORD|SUFFOLK|PALTZ|CITY)|TON(?: FALLS|VILLE)|A"
  "RK(?: VALLEY)?|F(?:IELD|ANE)|BURGH|COMB|PORT)|L(?:SONVILLE|LISTON"
  ")|(?:SCONSE|PONSI)T|VERSINK|DROW)| (?:B(?:ROOKFIELD|ELLMORE|LENHE"
  "IM|ALDWIN)|(?:GRANVILL|LAWRENC|SYRACUS)E|T(?:ARRYTOWN|ONAWANDA)|M"
  "(?:ASSAPEQUA|ERRICK)|WHITE PL(?:AI)?NS|NEW HYDE PK|COHOCTON|Y(?: "
  "C)?)|I(?:AGARA (?:UNIV(?:ERSITY)?|FALLS)|(?:VERVILL|OB)E|CHOL(?:V"
  "ILLE|S)|SKAYUNA|NEVEH)|A(?:TURAL BR(?:IDGE|G)|P(?:ANOCH|LES)|RROW"
  "SBURG|NUET|SSAU)|Y(?:ACK|C)?|UNDA)|E(?:A(?:ST(?: (?:P(?:A(?:TCHOG"
  "UE|LMYRA)|HARSALIA|EMBROKE)|W(?:I(?:LLI(?:AMS|ST)ON|NDHAM)|ORCEST"
  "ER)|S(?:PRINGFIELD|CHODACK|ETAUKET|YRACUSE)|B(?:E(?:THANY|RNE)|LO"
  "OMFIELD|RANCH)|M(?:E(?:REDITH|ADOW)|ORICHES|ARION)|A(?:TLANTIC BE"
  "ACH|MHERST|URORA)|R(?:OC(?:HESTER|KAWAY)|ANDOLPH)|N(?:OR(?:THPORT"
  "|WICH)|ASSAU)|F(?:ISHKILL|REETOWN)|(?:ELMHURS|JEWET)T|C(?:HATHAM|"
  "ONCORD)|GREEN(?:BUS|WIC)H|H(?:AMPTON|OMER)|YAPHANK|DURHAM|QUOGUE|"
  "ISLIP|OTTO)|CHESTER|PORT)|GLE (?:B(?:RIDGE|AY)|HARBOR)|RL(?:VILLE"
  "|TON)|TON)|L(?:L(?:EN(?:BURG(?: (?:C(?:ENTE|T)R|DEP(?:OT)?))?|VIL"
  "LE)|I(?:COTTVILLE|NGTON|SBURG))|M(?:IRA(?: H(?:EIGH|G)?TS)?|(?:HU"
  "RS|ON)T|SFORD|A)|IZA(?:BETHTOWN|VILLE)|(?:DRE|WOO)D|B(?:RIDGE|A)|"
  "KA PARK)| (?:(?:ATLANT(?:IC BEA|C B)C|GREEN(?:BUS|WIC))H|W(?:ILLI"
  "(?:AMS|ST)ON|ORCESTER)|P(?:ATCHOGUE|HARSALIA)|(?:SPRING|BLOOM)FIE"
  "LD|NORTHPORT|ROCHESTER|YAPHANK)|D(?:GE(?:MERE|WOOD)|(?:MESTO|E)N|"
  "DYVILLE|WARDS)|S(?:PERANCE|OPUS|SEX)|ND(?:ICOTT|WELL)|RI(?:EVILLE"
  "|N)|GGERTSVILLE|VANS MILLS|TNA)|L(?:A(?:KE(?: (?:P(?:L(?:EASANT|A"
  "CID)|EEKSKILL)|L(?:INCOLND(?:ALE)?|UZERNE)|(?:G(?:EORG|ROV)|KATRI"
  "N)E|H(?:UNTINGTON|ILL)|RONKONKOMA|SUCCESS|CLEAR|VIEW)|VILLE|MONT|"
  "WOOD)| (?:GU(?:ARDIA AIRPOR|RDA ARP)T|FA(?:RGEVILL|YETT)E)|W(?:(?"
  ":RENC(?:EVILL)?|YERSVILL)E|TONS)|N(?:ESVILLE|CASTER|SING)|URE(?:L"
  "(?:TON)?|NS)|C(?:KAWAN|O)NA|GRANGEVILLE|RCHMONT|THAM)|I(?:V(?:ING"
  "ST(?:ON(?: MANOR)?|N MNR)|ONIA(?: C(?:ENTE|T)R)?|ERPOOL)|TTLE (?:"
  "(?:NEC|YOR)K|GENESE?E|VALLEY|FALLS)|N(?:D(?:ENHURST|LEY)|COLNDALE"
  "|WOOD)|M(?:E(?:STONE|RICK)|A)|S(?:BON|LE)|DO BEACH|LY DALE|BERTY)"
  "|O(?:C(?:K(?:PORT|WOOD|E)|H SHELDRA?KE|UST VALLEY)|NG (?:(?:IS(?:"
  "LAND)? CIT|EDD)Y|BEACH|LAKE)|(?:UDONVILL|ON LAK|RRAIN)E|EHMANNS P"
  "L(?:AZA|Z)|W(?:VILLE|MAN)|DI)|E(?:BANON(?: SP(?:RINGS|G))?|W(?:IS"
  "(?:TON)?| BEACH)|(?:VITTOW|XINGTO)N|ON(?:ARDSVILLE)?|E(?: CENTER|"
  "DS)|ICESTER| ROY)|Y(?:ON(?:(?:S FALL)?S| MOUNTAIN)|N(?:DONVILLE|B"
  "ROOK)|COMING|SANDER)|K (?:HUNTINGTON|RONKONKOMA|PEEKSKILL)|LOYD H"
  "ARBOR)|R(?:O(?:C(?:K(?: (?:CITY F(?:AL)?LS|(?:TAVER|GLE)N|STREAM|"
  "HILL)|AWAY (?:P(?:(?:OIN)?T|ARK)|BEACH?)|VILLE C(?:ENTRE|TR)|Y PO"
  "INT)|H(?:DALE VILL(?:AGE)?|ESTER))|S(?:LYN(?: (?:HEIG)?HTS)?|E(?:"
  "N?DALE|BOOM)?|SBURG|COE)|U(?:ND (?:LAKE|TOP)|SES POINT)|OSEVELT(?"
  ": ISL(?:AND)?|OWN)?|TTERDAM(?: J(?:UNCTION|CT))?|M(?:ULUS|E)|ESSL"
  "EVILLE|NKONKOMA|XBURY|DMAN)|E(?:NSS(?:ELAER(?:V(?:IL)?LE| FALLS)?"
  "|LAER FLS)|D(?:(?:F(?:IEL|OR)|WOO)D| (?:CREE|HOO)K)|ADING C(?:ENT"
  "E|T)R|X(?:VILLE|FORD)|MSEN(?:BURG)?|GO PARK|TSOF)|I(?:CH(?:F(?:(?"
  ":IELD SPRIN|LD SP)GS|ORD)|MOND(?: HILL|VILLE)|VILLE|BURG|LAND)|DG"
  "E(?:MONT|WOOD)?|P(?:ARIUS|LEY)|VERHEAD|FTON)|A(?:(?:QUETTE|INBOW)"
  " LAKE|Y(?:MONDVILLE| BROOK)|N(?:SOMVILLE|DOLPH)|VENA)|U(?:S(?:H(?"
  ":VILLE|FORD)?|SELL)|BY)|HINE(?:CLIFF|BECK)|YE(?: BROOK)?)|A(?:L(?"
  ":EX(?:AND(?:RIA BAY|ER)| BAY)|DE(?:N(?: MANOR)?|R CREEK)|FRED(?: "
  "STA(?:TION)?)?|B(?:(?:ERTS|I)ON|ANY)|T(?:AMONT|ONA?|MAR)|LE(?:NTO"
  "WN|GANY)|P(?:LAUS|INE)|M(?:OND|A)|ABAMA|COVE)|R(?:D(?:SLEY(?: (?:"
  "ON HUDSO|HDS)N)?|EN)|(?:VERN|CAD|GYL)E|K(?:VILLE|PORT)|LINGTON|MO"
  "NK)|U(?: SABLE (?:FO?RKS|CHASM)|S(?:ABLE CHASM|TERLITZ)|R(?:IESVI"
  "LLE|ORA)|BURN)|N(?:NANDALE(?: ON HUDSON)?|CRAM(?:DALE)?|G(?:ELIC|"
  "OL)A|D(?:OVER|ES)|TWERP)|M(?:ITY(?: HARBOR|VILLE)|A(?:GANSETT|WAL"
  "K)|E(?:NIA|S)|STERDAM|HERST)|D(?:AMS(?: (?:CENTER|BASIN))?|DIS(?:"
  "LEIGH P(?:AR)?K|ON)|IRONDACK)|T(?:H(?:OL(?: SPRINGS)?|ENS)|LANT(?"
  ":IC B(?:EA)?CH|A)|TICA)|P(?:(?:ALACHI|PLETO)N|ULIA STA(?:TION)?)|"
  "V(?:ERILL PARK|O(?:CA|N)|A)|S(?:H(?:VILLE|LAND)|TORIA)|K(?:WESASN"
  "E|RON)|C(?:CORD|RA)|QUEBOGUE|IRMONT|FTON)|G(?:R(?:E(?:E(?:N(?:F(?"
  ":IELD (?:CENTER|PARK)|LD (?:PARK|CTR))|W(?:OOD(?: L(?:AKE|K))?|IC"
  "H)|(?:V(?:IL|A)L)?E|(?:HURS|POR)T| ISLAND|LAWN)|CE)|AT (?:VALLEY|"
  "RIVER|BEND|NECK)|NELL|IG)|A(?:N(?:D (?:ISLAND|GORGE)|ITE SP(?:RIN"
  ")?GS|VILLE)|HAMSVILLE|FTON)|O(?:VELAND|TON))|L(?:EN(?: (?:(?:AUBR"
  "|SP)EY|(?:HEA|WIL)D|COVE|OAKS|PARK)|WOOD(?: L(?:ANDIN|ND)G)?|(?:V"
  "IL|DA)LE|F(?:IEL|OR)D|S FALLS|MONT|HAM)|OVERSVILLE|ASCO)|A(?:R(?:"
  "D(?:EN CITY(?: (?:S(?:OUTH)?|P(?:ARK)?))?|INER)|R(?:ATTSVILLE|ISO"
  "N)|NERVILLE)|L(?:LUPVILLE|WAY)|(?:NSEVO|SP)ORT|INESVILLE|BRIELS)|"
  "E(?:N(?:E(?:SEO|VA)|OA)|R(?:MANTOWN|RY)|ORGETOWN|TZVILLE)|O(?:LDE"
  "NS BR(?:IDGE|G)|UVERNEUR|DEFFROY|WANDA|RHAM|SHEN)|UIL(?:D(?:ERLAN"
  "D(?: CENTER)?|RLND CTR)|FORD)|IL(?:B(?:ERTSVILLE|OA)|GO BEACH)|HE"
  "NT)|F(?:O(?:R(?:T (?:(?:(?:J(?:ACK|OHN)S|COVINGT)O|T(?:ILD|OTT)E|"
  "PLAI|AN)N|H(?:AMILTON|UNTER)|MONTGOMERY|SALONGA|EDWARD|DRUM)|EST("
  "?: HILLS|BURGH|VILLE|PORT))|NDA)|A(?:R(?:M(?:ERSV(?:ILLE STATION|"
  "L STA)|ING(?:(?:VIL|DA)LE|TON))| ROCKAWAY|NHAM)|IR(?: HA(?:RBOR|V"
  "EN)|PORT)|L(?:LSBURG|CONER)|YETT(?:EVILL)?E|NCHER|BIUS)|R(?:E(?:E"
  "(?:VILLE|HOLD|PORT|DOM)|MONT C(?:ENTE|T)R|SH MEADOWS|WSBURG|DONIA"
  ")|ANK(?:LIN(?: S(?:P(?:RIN)?GS|Q(?:UARE)?)|VILLE)?|FORT)|IENDSHIP"
  "|ONTENAC)|I(?:SH(?:ERS(?: (?:L(?:ANDIN|ND)G|ISL(?:AND|E)))?|S EDD"
  "Y|KILL)|N(?:E(?:VIEW)?|DLEY LAKE)|RE IS(?:LAND)? PINES|LLMORE)|L("
  "?:E(?:ISCHMANNS|ETWOOD)|OR(?:AL PARK|IDA)|Y CREEK|ANDERS|USHING)|"
  "E(?:LTS MILLS|URA BUSH|RNDALE)|T (?:MONTGOMERY|COVINGTON)|ULTON(?"
  ":VILLE|HAM)?)|D(?:E(?: (?:KALB J(?:UNCTION|CT)|(?:PEYS|RUY)TER|WI"
  "TT)|L(?:AN(?:CEY|SON)|PHI FALLS|EVAN|MAR|HI)|ER(?: (?:RIVER|PARK)"
  "|FIELD)|P(?:AUVILLE|OSIT|EW)|(?:WITTVILL|GRASS)E|N(?:MARK|VER)|AN"
  "SBORO|FERIET|XTER|RBY)|A(?:V(?:ENPORT(?: C(?:ENTE|T)R)?|IS PARK)|"
  "N(?:NEMORA|SVILLE)|RIEN CENTER|L(?:TON|E)|YTON)|O(?:(?:(?:RMA|W)N"
  "S|LGE)VILLE|VER PLAINS|BBS FERRY|UGLASTON)|I(?:CKINSON C(?:ENTE|T"
  ")R|AMOND POINT|X HILLS)|U(?:RHAM(?:VILLE)?|N(?:KIRK|DEE)|ANESBURG"
  ")|R(?:ES|Y)DEN)|O(?:L(?:D (?:(?:BETHPA|FOR)GE|WESTBURY|CHATHAM)|I"
  "VE(?:BRIDGE|REA)|MSTEDVILLE|COTT|EAN)|AK(?:(?:LAND G(?:ARDE|D)N|S"
  " CORNER)S| (?:ISLAND|BEACH|HILL)|FIELD|DALE)|R(?:I(?:SKANY(?: F(?"
  ":AL)?LS)?|ENT)|CHARD PARK|ANGEBURG|WELL)|N(?:TARIO(?: C(?:ENTE|T)"
  "R)?|(?:E(?:ONT|ID)|CHIOT)A)|S(?:WEG(?:ATCHIE|O)|SINING)|W(?:(?:AS"
  "C|EG)O|LS HEAD)|T(?:(?:EG|T)O|ISVILLE)|CEAN(?: BEACH|SIDE)|(?:GDE"
  "NS|BERN)BURG|(?:UAQUAG|DESS)A|X(?:FORD|BOW)|YSTER BAY|ZONE PARK|H"
  "IO|VID)|T(?:H(?:O(?:M(?:PSON(?: R(?:IDGE|DG)|VILLE)|SON)|US(?:AND"
  " ISLAND PAR| IS P)K|RNWOOD)|E(?:(?:NDAR|RES)A| BRONX)|REE MI?LE B"
  "AY|IELLS|URMAN)|R(?:O(?:U(?:T CREEK|PSBURG)|Y)|I(?:BES HILL|NITY)"
  "|U(?:MANSBURG|XTON)|EADWELL)|A(?:(?:CONIC LAK|NNERSVILL)E|(?:(?:L"
  "LM|PP)A|RRYTOW)N|GHKANIC|HAWUS|BERG)|U(?:(?:PPER LAK|CKAHO)E|XEDO"
  " PARK|SCARORA|NNEL|LLY|RIN)|I(?:OGA CENTER|CONDEROGA|LLSON|VOLI)|"
  "O(?:(?:WN OF TO)?NAWANDA|MKINS COVE)|N OF TONA|YRONE)|K(?:E(?:N(?"
  ":(?:OZA LAK|MOR)E|T(?: LAKES)?|DALL|NEDY)|W GARDEN(?:(?:S HILL)?S"
  "| HL)|E(?:NE(?: VALLEY)?|SEVILLE)|RHONKSON|UKA PARK)|I(?:N(?:G(?:"
  "S(?: P(?:OINT|ARK)|TON)| FERRY)|DERHOOK)|LL(?: BUCK|AWOG)|RK(?:VI"
  "LLE|WOOD)|AMESHA LAKE|SMET)|N(?:O(?:X(?:BORO)?|WLESVILLE)|ICKERBO"
  "CKER|APP CREEK)|A(?:T(?:TSKILL BAY|ONAH)|UNEONGA L(?:AKE|K)|NONA)"
  "|RUMVILLE)|V(?:A(?:N (?:BUREN (?:P(?:OIN)?T|BAY)|HORNESV(?:IL)?LE"
  "|ETTEN)|L(?:LEY (?:COTTAGE|STREAM|FALLS)|HALLA|ATIE|OIS)|ILS GATE"
  "|RYSBURG)|E(?:R(?:NON(?: CENTER)?|(?:PLANC|BAN)K|ONA(?: BEACH)?|M"
  "ONTVILLE|SAILLES)|TERANS ADM(?:INISTRATIO)?N|NICE CENTER|STAL)|(?"
  ":OORHEESVILL|LY COTTAG)E|ICTOR(?:Y MILLS)?)|J(?:A(?:M(?:ES(?:VILL"
  "E|PORT|TOWN)|AICA)|CKSON(?: (?:HEIG)?HTS|VILLE)|VA (?:VILLAGE|CEN"
  "TER)|SPER|Y)|O(?:HN(?:S(?:ON(?: CITY|VILLE)?|BURG|TOWN)| F KENNED"
  "Y AIRPORT)|RDAN(?:VILLE)?)|E(?:FFERSON(?: V(?:ALLE|L)Y|VI?LLE)?|R"
  "ICHO|WETT)|F KENNEDY AP)|I(?:S(?:L(?:AND(?: PARK|IA)|IP(?: TERRAC"
  "E)?)|CHUA)|N(?:D(?:IAN LAKE|USTRY)|TERLAKEN|WOOD|LET)|R(?:VING(?:"
  "TON)?|ONDEQUOIT)|THACA(?: COLL(?:EGE)?)?|LION|ONIA)|U(?:N(?:ION(?"
  ": (?:SPRINGS|HILL)|(?:VIL|DA)LE)|ADILLA)|P(?:PER (?:S(?:AINT REGI"
  "S|T REG)|JAY)|TON)|LSTER PARK|TICA)|Y(?:O(?:RK(?:TOWN (?:HEIG)?HT"
  "S|(?:SHIR|VILL)E)?|UNGS(?:VILLE|TOWN)|NKERS)|APHANK|ULAN)|QU(?:EE"
  "NS(?: V(?:ILLAGE|LG)|BURY)?|AKER STREET|OGUE)))))$"
  ,
  /* -- OH -- OH -- OH -- OH -- OH -- OH -- OH -- OH -- OH -- OH -- */
  "(?:\\b)((?^:(?i:(?:M(?:A(?:R(?:T(?:IN(?:S(?: FERRY|VILLE|BURG))?|"
  "EL)|I(?:(?:A STEI|O)N|ETTA)|BLE(?: CLIFF|HEAD)|(?:SHALL|YS)VILLE|"
  "K CENTER|ATHON|ENGO)|Y(?:FIELD(?: (?:V(?:ILLAGE|LG)|(?:HEIG)?HTS)"
  ")?|NARD)|GN(?:ETIC SP(?:RIN)?GS|OLIA)|L(?:(?:(?:IN)?T|AG)A|VERN)|"
  "N(?:CHESTER|SFIELD|TUA)|PLE(?: HEIGHTS|WOOD)|S(?:(?:SILL)?ON|URY)"
  "|C(?:EDONIA|KSBURG)|(?:INEVILL|UME)E|D(?:EIRA|ISON)|TAMORAS|XIMO)"
  "|I(?:L(?:L(?:E(?:R(?:S(?:VILLE|BURG|PORT)| CITY)|DGEVILLE)|FIELD|"
  "BURY)|FORD(?: C(?:ENTE|T)R)?|TON CENTER|AN)|D(?:DLE(?:B(?:URG(?: "
  "HEIGHTS)?|R(?:G HTS|ANCH))| (?:POINT|BASS)|FIELD|PORT|TOWN)|LAND|"
  "VALE)|N(?:ER(?:AL (?:RIDGE|CITY)|VA)|GO(?: J(?:UNCTION|CT))?|FORD"
  "|STER)|AMI(?: UNIV(?:ERSITY)?|SBURG|VILLE|TOWN))|O(?:UNT (?:S(?:A"
  "INT JOSEPH|TERLING)|(?:BLANCHAR|GILEA)D|P(?:LEASANT|ERRY)|V(?:ICT"
  "ORY|ERNON)|(?:LIBERT|COR)Y|H(?:EALTHY|OPE)|WASHING(?:TON)?|EATON|"
  "ORAB)|N(?:T(?:GOMERY|PELIER|EZUMA|VILLE)|RO(?:EVILL)?E|CLOVA)|R(?"
  ":R(?:ISTOWN|AL|OW)|ELAND H(?:IL)?LS|AINE)|OREFIELD|WRYSTOWN|GADOR"
  "E|XAHALA|SCOW)|E(?:N(?:TOR(?: ON TH(?:E LAK)?E)?|DON)|CHANIC(?:S("
  "?:BURG|TOWN))?|(?:SOPOTAMI|TAMOR)A|L(?:MOR|ROS)E|D(?:INA|WAY))|C("
  "?: (?:C(?:(?:UTCHENV(?:IL)?L|LUR)E|OMB)|D(?:ERMOTT|ONALD)|ARTHUR|"
  "GUFFEY)|CONNELSV(?:IL)?LE)|T (?:ST(?: JOSEPH|ERLING)|BLANCHARD|PL"
  "EASANT)|U(?:NROE FALLS|RRAY CITY))|S(?:T(?:O(?:N(?:E CREEK|Y RIDG"
  "E)|CK(?:DALE|PORT)|UT(?:SVILLE)?|W)|R(?:A(?:SBURG|TTON)|ONGSVILLE"
  "|EETSBORO|UTHERS|YKER)|E(?:WART(?:SVILLE)?|UBENVILLE|RLING)| (?:L"
  "OUISVIL|CLAIRSV)LE|ILLWATER|AFFORD)|A(?:INT (?:(?:JOHN|MARY|PARI)"
  "S|LOUISV(?:ILLE|L)|CLAIRSVILLE|BERNARD|HENRY)|L(?:E(?:SVILLE|M)|I"
  "NEVILLE)|R(?:DI(?:NIA|S)|AHSVILLE)|GAMORE H(?:IL)?LS|ND(?:YVILLE|"
  "USKY)|YLER PARK|VANNAH|BINA)|H(?:A(?:R(?:ON(?: CENTER|VILLE)|PSBU"
  "RG)|KER (?:HEIG)?HTS|WNEE(?: HILLS)?|(?:DYSI)?DE|NDON|UCK)|E(?:FF"
  "IELD (?:V(?:ILLAGE|LG)|L(?:AKE|K))|R(?:RODSVILLE|WOOD)|LBY)|I(?:N"
  "ROCK|LOH)|REVE)|O(?:UTH(?: (?:BLOOM(?:INGVILLE|FIELD)|(?:CHARLEST"
  "|LEBAN)ON|(?:AMHERS|POIN)T|S(?:ALEM|OLON)|WEBSTER|EUCLID|VIENNA)|"
  "INGTON)|MER(?:(?:VIL|DA)LE|SET|TON)|NORA|LON)|U(?:MM(?:IT(?: STA("
  "?:TION)?|VILLE)|ERF(?:IEL|OR)D)|L(?:PHUR SP(?:RIN)?GS|LIVAN)|GAR("
  "?: GROVE|CREEK)|NBURY)|Y(?:LVANIA(?: T(?:OWNSHI|W)P)?|CAMORE(?: V"
  "(?:ALLE|L)Y)?|RACUSE|MMES)|E(?:V(?:EN (?:HILLS|MILE)|ILLE)|(?:DAL"
  "I|LM)A|NECAVILLE|BRING|AMAN)|P(?:RING(?: VALLEY|FIELD|BORO|DALE)|"
  "ENCER(?:VILLE)?|ARTA)| (?:BLOOM(?:INGVIL(?:LE)?|FIELD)|CHARLESTON"
  "|ZANESVILLE)|C(?:IO(?:TO(?: FURNA?C|VILL)E)?|OTT(?:OWN)?)|I(?:NKI"
  "NG SP(?:RIN)?G|LVER LAKE|DNEY)|MITH(?:FIELD|VILLE)|WANTON)|C(?:O("
  "?:L(?:UMB(?:IA(?: STA(?:TION)?|NA)|US(?: GR(?:OVE|V))?)|L(?:EGE ("
  "?:CO(?:RNE)?R|HL)|INS(?:VILLE)?)|ERAIN(?: T(?:OWNSHI|W)P)?|G HILL"
  " STA|DWATER|TON)|N(?:CORD T(?:OWNSHI|W)P|TINENTAL|ESVILLE|GRESS|N"
  "EAUT|OVER|VOY)|AL(?: (?:GROVE|RUN)|TON)|MMERCIAL P(?:OIN)?T|(?:SH"
  "OC|VING)TON|R(?:TLAND|NING)|OLVILLE|PLEY)|A(?:R(?:RO(?:LL(?:TON)?"
  "|THERS)|BON(?: HILL|DALE)|DINGTON|THAGENA|LISLE|EY)|N(?:AL (?:W(?"
  ":INCHESTE|[HN]CHST)R|FULTON)|FIELD|TON)|M(?:P(?: DENNISON|BELL)|("
  "?:ERO|DE)N|BRIDGE)|L(?:(?:EDONI|CUTT)A|DWELL)|S(?:T(?:ALIA|INE)|S"
  "TOWN)|TAWBA|BLE|DIZ|IRO)|H(?:E(?:S(?:TER(?:VILLE|HILL|LAND)?|(?:A"
  "PEAK|HIR)E)|RRY FORK)|A(?:NDLERSVI?LLE|GRIN FALLS|R(?:DON|M)|TFIE"
  "LD|UNCEY)|I(?:L(?:LICOTHE|O)|PPEWA LAKE|CKASAW)|RISTIANSBU?RG)|L("
  "?:A(?:R(?:KS(?:VILLE|BURG)|INGTON)|Y(?: CENTER|SVILLE|TON))|E(?:V"
  "E(?:LAND(?: (?:HEIG)?HTS)?|S)|RMONT C(?:OU)?NTY)|I(?:NTON(?: C(?:"
  "OU)?NTY)?|FTON)|(?:OVERDAL|YD)E)|U(?:YAHOGA (?:(?:HEIG)?HT|F(?:AL"
  ")?L)S|(?:STA|TLE)R|MBERLAND|RTICE|BA)|I(?:N(?:C(?:INNATI(?: AIRPO"
  "RT ANNEX)?|Y AMF)| ARPRT ANX)|RCLEVILLE)|R(?:O(?:OKSVILLE|WN CITY"
  "|TON)|E(?:ST(?:LINE|ON)|OLA)|IDERSVILLE)|E(?:NTER(?:VILLE|BURG)|D"
  "ARVILLE|LINA|CIL)|Y(?:NTHIANA|GNET))|W(?:A(?:SHINGTO(?:N(?: (?:CO"
  "URT HOUSE|TOWNSHIP)|V(?:IL)?LE)| TWP)|L(?:NUT (?:CREEK|HILLS)|TON"
  " HILLS|HONDING|BRIDGE|DO)|R(?:REN(?:SV(?:ILLE HEIG|L )HTS)?|N(?:O"
  "CK|ER)|SAW)|Y(?:NE(?:S(?:FIELD|VILLE|BURG))?|LAND)|TER(?:VILLE|FO"
  "RD|TOWN|LOO)|KE(?:FIELD|MAN)|ITE HILL|PAKONETA|DSWORTH|USEON|VERL"
  "Y)|E(?:ST(?: (?:M(?:AN(?:CHESTER|SFIELD)|IL(?:LGROVE|TON))|(?:(?:"
  "FARMING|ELK)T|JEFFERS)ON|C(?:ARROLLTON|HESTER)|L(?:AFAYETTE|IBERT"
  "Y)|PO(?:RTSMOUTH|INT)|UNI(?:ON|TY)|ALEXANDRIA|RUSHVILLE|SALEM)|(?"
  ":(?:ER)?VILL|LAK)E|FIELD C(?:ENTE|T)R|WOOD|ON)|LL(?:S(?:VILLE|TON"
  ")|INGTON))|I(?:L(?:L(?:I(?:AMS(?:FIELD|BURG|PORT|TOWN)|STON)|O(?:"
  "W(?: WOOD|ICK)|UGHBY)|SHIRE|ARD)|(?:BERFORC|KESVILL)E|M(?:INGTON|"
  "OT))|N(?:D(?:HAM|SOR)|TERSVILLE|GETT RUN|CHESTER|ESBURG|ONA)|CKLI"
  "FFE)| (?:(?:(?:CARROLL|FARMING)T|JEFFERS)ON|M(?:AN(?:CHESTER|SFIE"
  "LD)|ILLGROVE)|(?:LAFAYETT|RUSHVILL)E|ALEXANDRIA|PORTSMOUTH)|O(?:O"
  "(?:D(?:S(?:FIELD|TOCK)|(?:VILL|MER)E)|STER)|(?:RTHINGTO|LF RU)N)|"
  "H(?:I(?:TE(?:H(?:OUSE|ALL)| COTTAGE)|PPLE)|EELERSBURG|ARTON)|R(?:"
  "IGHT PAT(?:TER(?:SON(?: AFB)?)?)?|EN)|P(?: AIR BASE|AFB)|SHNGTN C"
  "T HS|YOMING)|B(?:E(?:L(?:L(?:E(?: (?:CENTER|VALLEY)|(?:FONTAIN|VU"
  ")E)|(?:VILL|AIR)E|BROOK)|MO(?:NT|RE)|OIT|PRE)|R(?:LIN(?: (?:(?:HE"
  "IG)?HTS|CENTER))?|GHOLZ|KEY|EA)|A(?:VER(?:CREEK|DAM)?|CH(?: CITY|"
  "WOOD)|LLSVILLE)|NT(?:ON(?: RIDG|VILL)|LEYVILL)E|T(?:HE(?:SDA|L)|T"
  "SVILLE)|DFORD(?: (?:HEIG)?HTS)?|(?:VERL|XLE)Y)|R(?:O(?:OK(?:LYN(?"
  ": (?:HEIG)?HTS)?| PARK|FIELD|VILLE)|AD(?:VIEW (?:HEIG)?HTS|WAY)|W"
  "N(?: COUNTY|SVILLE))|I(?:(?:DGEPOR|LLIAN)T|(?:STOLVILL|C)E|NKHAVE"
  "N)|A(?:D(?:Y LAKE|FORD|NER)|TENAHL)|E(?:CKSVILLE|WSTER|MEN)|UNSWI"
  "CK|YAN)|L(?:A(?:(?:KESLE|IN)E|DENSBURG|NCHESTER|CKLICK)|OOM(?:ING"
  "(?:BURG|DALE)|(?:VIL|DA)LE)|U(?:E (?:(?:CREE|ROC)K|ASH)|FFTON)|IS"
  "SFIELD)|A(?:R(?:T(?:LETT|ON)|NESVILLE|BERTON|LOW)|(?:KERSVILL|Y V"
  "ILLAG)E|I(?:NBRIDGE|RDSTOWN)|LTI(?:MORE|C)|T(?:AVIA|H)|NNOCK|SCOM"
  ")|U(?:R(?:G(?:HILL|OON)|KETTSVILLE|BANK|TON)|C(?:K(?:EYE LAKE|LAN"
  "D|S)|HTEL|YRUS)|F(?:FALO|ORD)|TLER)|O(?:W(?:ERS(?:VILLE|TON)|LING"
  " GREEN)|URNEVILLE|ARDMAN|LIVAR|TKINS|NO)|I(?:G PRAIRIE|RMINGHAM|D"
  "WELL)|YESVILLE)|N(?:E(?:W(?: (?:B(?:(?:LOOM(?:INGTO|NGT)|OSTO|REM"
  "E)N|AVARIA|EDFORD)|M(?:A(?:RSHF(?:IE)?LD|TAMORAS|DISON)|IDDLETO?W"
  "N)|S(?:TRAITSV(?:ILLE|L)|PRINGF(?:IE)?LD)|P(?:HIL(?:ADELPHI)?A|LY"
  "MOUTH|ARIS)|L(?:(?:E(?:XINGT|BAN)|OND)ON|YME)|W(?:A(?:SHINGTO?N|T"
  "ERFORD)|ESTON)|R(?:I(?:CHMOND|EGEL)|UMLEY|OME)|H(?:A(?:MPSHIRE|VE"
  "N)|OLLAND)|C(?:ARLISLE|ONCORD)|A(?:LBANY|THENS)|KNOXVILLE|VIENNA)"
  "|TO(?:N(?: FALLS|SVILLE)|WN)|BUR(?:GH (?:HEIG)?HTS|Y)|COMERSTOWN|"
  "PORT|ARK)|(?:APOLI|FF)S|V(?:ILLE|ADA)|(?:GLE)?Y|LSONVILLE)|O(?:R("
  "?:T(?:H(?: (?:(?:(?:(?:HAMP|CAN)T|JACKS)O|GEORGETOW)N|R(?:O(?:BIN"
  "S|YALT)ON|IDGEVILLE|ANDALL)|B(?:EN(?:TON|D)|LOOMFIELD|ALTIMORE)|L"
  "(?:EWISBURG|AWRENCE|IMA)|(?:FAIRFIEL|OLMSTE)D|KINGSVILLE|INDUSTRY"
  "|STAR)|(?:FIEL|WOO)D)|ON)|W(?:ALK|ICH|OOD))|V(?:ELTY|A))| (?:R(?:"
  "O(?:BINS|YALT)ON|IDGEVILLE)|B(?:LOOMFIELD|ALTIMORE)|L(?:EWISBURG|"
  "AWRENCE)|C(?:OLLEGE HL|ANTON)|GEORGETOWN|KINGSVILLE|FAIRFIELD|IND"
  "USTRY)|A(?:SH(?:VILLE|PORT)|(?:POLEO|NKI)N|VARRE)|ILES)|L(?:A(?:K"
  "E(?:SIDE(?: MARBLEHEAD)?|(?:LIN|MOR)E|VI(?:LLE|EW)| MILTON|WOOD)|"
  "N(?:GSVILLE|CASTER|SING)|(?:GRANG|CARN| RU)E|F(?:AYETTE|FERTY)|UR"
  "(?:ELVILLE|A)|T(?:HAM|TY)|INGS)|I(?:BERTY (?:T(?:W(?:NSHI)?|OWNSH"
  "I?|NS)P|C(?:ENTE|T)R)|T(?:TLE HOCKI?NG|CHFIELD|HOPOLIS)|ND(?:ENWA"
  "LD|SEY)|MA(?:VILLE)?|SBON)|O(?:N(?:DON(?:DERRY)?|G BOTTOM)|WE(?:L"
  "L(?:VILLE)?|R SALEM)|CK(?:BOURNE|LAND)|U(?:DON|IS)VILLE|R(?:E CIT"
  "Y|AIN)|VELAND|GAN|DI)|E(?:E(?:S(?: CREEK|VILLE|BURG)|TONIA)|WIS(?"
  ": CENTER|VILLE|BURG|TOWN)|(?:XINGT|BAN)ON|AVITTSBURG|IPSIC|MOYNE)"
  "|U(?:C(?:AS(?:VILLE)?|KEY)|DLOW FALLS)|Y(?:N(?:CHBURG|DHURST|X)|O"
  "NS)|KSID MARBLHD)|H(?:A(?:R(?:R(?:IS(?:VILLE|BURG|ON)|OD)|LEM SP("
  "?:RIN)?GS|T(?:VILLE|FORD)|BOR VIEW|VEYSBURG|PSTER)|M(?:ILTON(?: T"
  "(?:OWNSHI|W)P)?|(?:MOND|ER)SVILLE|DEN|LER)|N(?:GING ROCK|OVERTON|"
  "NIBAL)|(?:Y(?:DEN|ES)|LLS)VILLE|V(?:ERHILL|ILAND)|SKINS)|O(?:L(?:"
  "L(?:AN(?:SBURG|D)|OWAY)|(?:MESVILL|GAT)E|IDAY CITY)|ME(?:R(?:VILL"
  "E)?|WORTH)|PE(?:DALE|WELL)|(?:USTO|OVE)N|CKINGPORT|YTVILLE|WARD)|"
  "I(?:G(?:HLAND(?: (?:H(?:(?:EIGH|G)?T|(?:IL)?L)S|COUNTY))?|GINSPOR"
  "T)|LL(?:SBORO|IARD)|DEAWAY HLS|CKSVILLE|NCKLEY|RAM)|U(?:B(?:ER HE"
  "IGHTS|BARD)|NTS(?:VILLE|BURG)|(?:DS|R)ON)|E(?:MLOCK|BRON|LENA|ATH"
  ")|GLND COUNTY)|P(?:O(?:RT(?: (?:W(?:ASHINGTON|ILLIAM)|(?:JEFFERS|"
  "CLINT)ON)|SMOUTH|LAND|AGE)|W(?:HATAN P(?:OIN)?T|ELL)|L(?:AND|K)|E"
  "TOWN|MEROY|TSDAM)|E(?:RRY(?:S(?:VILLE|BURG))?|T(?:TISVILLE|ERSBUR"
  "G)|N(?:NSVILLE|INSULA)|MBER(?:VILLE|TON)|PPER PIKE|EBLES|DRO)|A(?"
  ":R(?:MA(?: HEIGHTS)?|K(?:DALE|MAN)|IS)|(?:(?:LESTI|Y)N|INESVILL)E"
  "|T(?:ASKALA|RIOT)|ULDING|NDORA)|L(?:EASANT(?: (?:PL(?:AI)?N|CITY|"
  "HILL)|VILLE)|AIN(?: CITY|FIELD)|YMOUTH)|I(?:(?:CKERING|KE)TON|E(?"
  ":DM|RP)ONT|NEY FORK|TSBURG|ONEER|QUA)|R(?:T (?:JEFFERSO|WASHINGT)"
  "N|O(?:CTORVILLE|SPECT))|H(?:IL(?:LIPSBURG|O)|ONETON)|UT IN BAY)|R"
  "(?:O(?:C(?:K(?:Y RI(?:DGE|VER)| C(?:REEK|AMP)|BRIDGE|FORD)|HESTER"
  ")|S(?:S(?: COUNTY|VILLE|BURG|FORD)?|E(?:VILLE|LAWN|WOOD))|(?:AMIN"
  "G SH(?:ORE|R)|GER)S|(?:BERTSVILL|M)E|OTSTOWN|UNDHEAD)|I(?:CH(?:MO"
  "ND(?: (?:(?:HEIG)?HTS|DALE))?|(?:FIEL|WOO)D)|DGE(?:VILLE CORNERS|"
  "WAY)|(?:SINGSU|TTMA)N|NARD MILLS|O GRANDE|PLEY)|U(?:S(?:S(?:ELL(?"
  ":S P(?:OIN)?T|VILLE)?|IA)|H(?:SYLVANIA|VILLE))|DOLPH|TLAND)|A(?:Y"
  "(?:(?:LA|MO)ND)?|D(?:CLIFF|NOR)|(?:RDE|WSO)N|NDOLPH|VENNA|CINE)|E"
  "(?:(?:MINDER|ED?S)VILLE|(?:YNOLDSBUR|ADIN)G|PUBLIC|NO)|DGVILLE CO"
  "RS)|A(?:L(?:L(?:E(?:NSVILLE|DONIA)|IANCE)|(?:EXANDRI|PH)A|V(?:ORD"
  "TON|ADA)|BANY|GER)|R(?:LINGTON(?: (?:HEIG)?HTS)?|C(?:A(?:DIA|NUM)"
  "|HBOLD)|MSTRONG M(?:IL)?LS)|D(?:A(?:MS(?: (?:COUNTY|MILLS)|VILLE)"
  ")?|(?:DYSTO|RIA)N|E(?:LPHI|NA))|U(?:BURN T(?:OWNSHI|W)P|STIN(?:BU"
  "RG|TOWN)|(?:GUST|ROR)A)|M(?:E(?:SVILLE|LIA)|S(?:TERDAM|DEN)|HERST"
  "|ANDA|LIN)|N(?:D(?:ERSON|OVER)|T(?:IOCH|WERP)|(?:SONI|N)A)|SH(?:L"
  "(?:AND|EY)|TABULA|VILLE)|V(?:ON(?:(?: LAK|DAL)E)?|A)|T(?:WATER|HE"
  "NS|TICA)|(?:BERDEE|KRO)N|PPLE CREEK)|G(?:R(?:A(?:N(?:D(?:VIEW(?: "
  "HEIGHTS)?| R(?:APIDS|IVER))|VILLE)|Y(?:SVILLE|TOWN)|TI(?:OT|S)|FT"
  "ON)|E(?:EN(?: (?:SPRINGS|CAMP)|F(?:IEL|OR)D|VILLE|TOWN|WICH)?|LTO"
  "N)|O(?:VE(?:R HILL| CITY|PORT)|ESBECK))|A(?:R(?:FIELD (?:HEIG)?HT"
  "S|RETTSVILLE)|L(?:L(?:IPOLIS|OWAY)|ENA|ION)|TES MILLS|HANNA|MBIER"
  ")|L(?:EN(?:(?:DAL|CO)E|FORD|MONT)|ANDORF|OUSTER)|E(?:(?:ORGE|RMAN"
  ")TOWN|N(?:EV|O)A|TTYSBURG)|I(?:BSONBURG|LBOA|RARD)|O(?:(?:RDO|SHE"
  ")N|MER)|U(?:YSVILLE|ERNSEY)|NADENHUTTEN|YPSUM)|F(?:A(?:IR(?:PO(?:"
  "RT H(?:ARBO|B)R|INT)|VIEW(?: PARK)?|(?:BOR|LAW)N|FIELD)|RM(?:ER(?"
  ":S(?:VILLE|TOWN))?|DALE)|YETTE(?: COUNTY|VILLE)?)|R(?:A(?:NK(?:L("
  "?:IN(?: FURNACE)?|N FRNCE)|FORT)|ZEYSBURG)|E(?:DERICK(?:SBU?RG|TO"
  "WN)|(?:EPOR|MON)T|SNO)|IENDSHIP)|O(?:R(?:T (?:JENNINGS|RECOVERY|L"
  "ORAMIE|SENECA)|EST)|STORIA|WLER)|L(?:E(?:TCHER|MING)|AT ROCK|USHI"
  "NG|ORIDA|Y)|E(?:ESBURG|LICITY)|ULTON(?:HAM)?|INDLAY)|E(?:A(?:ST(?"
  ": (?:C(?:L(?:EVELAND|ARIDON)|ANTON)|SP(?:RINGFIELD|ARTA)|LI(?:VER"
  "POOL|BERTY)|FULTONHAM|PALESTINE|ROCHESTER|ORWELL)|LAKE)|TON)| (?:"
  "(?:SPRINGFIEL|CLEVELAN)D|FULTONHAM|LIVERPOOL|PALESTINE|ROCHESTER)"
  "|L(?:L(?:SWORTH|ISTON)|(?:YRI|ID|B)A|(?:KTO|GI)N|DORADO|MORE)|D(?"
  ":GE(?:WATER|RTON)|(?:IS)?ON)|N(?:GLEWOOD|ON)|VANSPORT|MPIRE|UCLID"
  "|TNA)|D(?:E(?:L(?:AWARE|LROY|PHOS|TA)|ER(?:SVILLE|FIELD)|(?:CATU|"
  "SHLE)R|XTER(?: CITY)?|R(?:WENT|BY)| GRAFF|FIANCE|NNISON)|A(?:Y(?:"
  " HEIGHTS|TON)|(?:RBYDA|NVIL)LE|MASCUS|LTON)|U(?:N(?:(?:BRIDG|DE)E"
  "|CAN FALLS|KIRK)|BLIN|PONT)|O(?:NNELSVILLE|YLESTOWN|RSET|VER|LA)|"
  "I(?:LLONVALE|AMOND)|RESDEN)|O(?:AK(?:WOOD(?: V(?:ILLAGE|LG))?| H("
  "?:ARBOR|ILL))|R(?:(?:ANGE|R)VILLE|EGON(?:IA)?|IENT|WELL)|L(?:D (?"
  ":WASHINGTO?N|FORT)|MSTED FALLS)|T(?:T(?:AWA(?: HILLS)?|OVILLE)|WA"
  "Y)|(?:K(?:OLO|EA)N|CEOL)A|S(?:TRANDER|GOOD)|BE(?:RLIN|TZ)|WENSVIL"
  "LE|HIO CITY|VERPECK|NTARIO|XFORD)|T(?:I(?:(?:LTONSVILL|MBERLAK)E|"
  "PP(?:ECANOE| CITY)|FFIN|RO)|R(?:E(?:MONT CITY|NTON)|I(?:MBLE|NWAY"
  ")|O(?:TWOOD|Y))|H(?:O(?:RNVILLE|MPSON)|UR(?:STO|MA)N|E PLAINS)|O("
  "?:R(?:ONTO|CH)|NTOGANY|LEDO)|U(?:PPERS PL(?:AI)?N|SCARAWA)S|A(?:L"
  "LMADGE|RLTON|FT)|ERRACE PARK|WINSBURG)|K(?:I(?:N(?:GS(?: (?:ISLAN"
  "D|MILLS)|VILLE|TON)|SMAN)|R(?:KERSVILLE|TLAND|BY)|L(?:BOURNE|LBUC"
  "K)|(?:MBOLT|DR)ON|P(?:LING|TON)|TTS HILL)|E(?:N(?:T(?:ON)?|SINGTO"
  "N)|TT(?:LERSVILLE|ERING)|LLEYS IS(?:LAND)?|ENE|RR)|A(?:LIDA|NSAS)"
  "|UNKLE)|U(?:NI(?:O(?:N(?:V(?:ILLE(?: CENTER)?|LLE CTR)| (?:FURNAC"
  "E|CITY)|PORT|TOWN)?|POLIS)|V(?:ERSITY (?:H(?:EIGHTS|TS?)|OF DAYTO"
  "N)| DAYTON))|PPER (?:ARL(?:INGTO|NGT)N|SANDU?SKY)|RBAN(?:CREST|A)"
  "|HRICHSVILLE|TICA)|J(?:A(?:C(?:KS(?:ON(?: (?:C(?:ENTE|T)R|BELDEN)"
  "|VILLE|TOWN)?|N BELDEN)|OBSBURG)|MESTOWN|SPER)|E(?:R(?:OMESVILLE|"
  "RY CITY|USALEM)|FFERSON(?:VI?LLE)?|WE(?:LL|TT)|NERA)|UNCTION CITY"
  "|OHNSTOWN)|V(?:A(?:N(?: (?:BUREN|WERT)|DALIA|LUE)|LLEY (?:CITY|VI"
  "EW)|UGHNSVILLE)|E(?:R(?:SAILLES|MILION|ONA)|NEDOCIA)|I(?:N(?:CENT"
  "|TON)|CKERY|ENNA))|I(?:ND(?:IAN SP(?:RIN)?GS|EPENDENCE)|R(?:ON(?:"
  "DALE|TON)|WIN)|S(?:LE SAIN| S)T GEORGE|(?:BERI|THAC)A|DAHO)|Y(?:O"
  "(?:RK(?:SHIR|VILL)E|UNGSTOWN)|ELLOW SP(?:RIN)?GS)|Z(?:A(?:NES(?:F"
  "IELD|VILLE)|LESKI)|OAR(?:VILLE)?)|QU(?:(?:AKER|EEN) CIT|INC)Y|XEN"
  "IA))))$"
  ,
  /* -- OK -- OK -- OK -- OK -- OK -- OK -- OK -- OK -- OK -- OK -- */
  "(?:\\b)((?^:(?i:(?:C(?:O(?:L(?:LINSVILLE|BERT|CORD|EMAN|ONY)|(?:M"
  "(?:ANCH|MERC)|ALGAT|YL)E|(?:(?:VINGT|OKS)O|PA)N|UN(?:CIL HILL|TYL"
  "INE)|N(?:NERVILLE|CHO)|W(?:LINGTON|ETA)|R(?:DELL|N))|A(?:R(?:T(?:"
  "WRIGHT|ER)|NE(?:GIE|Y)|(?:DI|ME)N|RIER)|N(?:(?:ADIA|TO)N|UTE|EY)|"
  "L(?:UMET|ERA|VIN)|M(?:ARGO|ERON)|S(?:HION|TLE)|TOOSA|PRON|CHE|DDO"
  ")|H(?:E(?:(?:ROKE|YENN)E|COTAH|LSEA|STER)|A(?:TTANOOGA|NDLER)|O(?"
  ":UTEAU|CTAW)|ICKASHA)|L(?:E(?:O(?: SPRINGS|RA)|ARVIEW|VELAND)|A(?"
  ":R(?:EMORE|ITA)|YTON)|INTON)|R(?:O(?:MWELL|WDER)|AWFORD|ESCENT)|E"
  "(?:NTRA(?:HOM|LI)A|MENT)|US(?:TER CITY|HING)|YRIL)|M(?:A(?:R(?:(?"
  ":IETT|TH)A|L(?:AND|OW)|BLE CITY|SHALL|AMEC)|N(?:N(?:SVILLE|FORD)|"
  "CHESTER|ITOU|GUM)|Y(?:SVILLE)?|COMB|DILL|SON|ZIE|UD)|O(?:UN(?:TAI"
  "N (?:PARK|VIEW)|DS)|O(?:RE(?:LAND)?|DYS)|N(?:KEY ISLAND|ROE)|RRIS"
  "(?:ON)?|FFETT|YERS)|I(?:L(?:L(?: CREEK|ERTON)|BURN|FAY|O)|DWEST C"
  "ITY|AMI|NCO)|E(?:D(?:ICINE PARK|FORD)|E(?:KER|RS)|RIDIAN|AD|NO)|U"
  "(?:S(?:(?:KOGE)?E|TANG)|L(?:DROW|HALL)|TUAL)|C(?:(?: MILLA|CURTAI"
  ")N|ALESTER|LOUD))|S(?:T(?:R(?:O(?:NG CITY|UD)|A(?:TFORD|NG)|INGTO"
  "WN)|I(?:L(?:LWATER|WELL)|DHAM|GLER)|ONEWALL|ERLING|UART)|A(?:(?:N"
  "D SPRING|INT LOUI)S|(?:PULP|SAKW|VANN)A|L(?:LISAW|INA)|WYER|YRE)|"
  "P(?:E(?:NCER(?:VILLE)?|RRY)|A(?:VINAW|RKS)|RINGER|IRO)|H(?:A(?:(?"
  ":MRO|TTU)CK|DY POINT|WNEE|RON)|IDLER)|E(?:MINOLE|NTINEL|ILING|LMA"
  "N)|(?: COFFEY|MITH)VILLE|(?:CHULTE|ULPHU)R|W(?:EETWATER|INK)|(?:K"
  "IATOO|LIC)K|O(?:UTHARD|PER)|N(?:YDER|OW))|B(?:O(?:(?:ISE CIT|LE)Y"
  "|K(?:CHITO|OSHE)|W(?:LEGS|RING)|SWELL|YNTON)|R(?:O(?:KEN (?:ARR|B"
  ")OW|MIDE)|A(?:(?:DLE)?Y|GGS|MAN)|ISTOW)|E(?:(?:RNIC|SSI)E|A(?:RDE"
  "N|VER)|TH(?:ANY|EL)|NNINGTON|GGS)|U(?:R(?:N(?:EYVILLE|S FLAT)|LIN"
  "GTON|BANK)|FFALO|TLER|NCH)|L(?:A(?:NC(?:HARD|O)|CKWELL|IR)|UEJACK"
  "ET|OCKER)|A(?:R(?:TLESVILLE|NSDALL)|TTIEST|CHE|KER|LKO)|I(?:(?:G "
  "CABI|SO)N|LLINGS|NGER|XBY)|Y(?:ARS|RON))|W(?:A(?:R(?:R ACRES|DVIL"
  "LE|NER)|T(?:ONGA|SON|TS)|(?:PANUCK|KIT)A|SHI(?:NGTON|TA)|U(?:KOMI"
  "S|RIKA)|N(?:ETTE|N)|YN(?:OKA|E)|INWRIGHT|GONER|LTERS|DE)|E(?:L(?:"
  "L(?:STON|ING)|EETKA|CH|TY)|(?:TUM|WO)KA|BBERS FALLS|ATHERFORD|STV"
  "ILLE)|H(?:ITE(?:FIELD|SBORO| OAK)|EATLAND)|I(?:L(?:(?:BURT|S)ON|L"
  "OW)|STER)|Y(?:N(?:NEWOOD|ONA)|ANDOTTE)|RIGHT CITY|OODWARD)|H(?:A("
  "?:R(?:DE(?:N CI|S)TY|TSHORNE|MON|RAH)|S(?:TINGS|KELL)|ILEYVILLE|L"
  "LETT|WORTH|YWOOD|MMON|NNA)|O(?:L(?:LIS(?:TER)?|DENVILLE)|(?:FFMA|"
  "PETO|DGE)N|(?:BAR|Y)T|NOBIA|MINY|OKER|WE)|E(?:N(?:NE(?:SSEY|PIN)|"
  "RYETTA|DRIX)|A(?:DRICK|LDTON|VENER)|LENA)|I(?:TCH(?:COCK|ITA)|LLS"
  "DALE|NTON)|U(?:LBERT|NTER|GO)|YDRO)|P(?:O(?:N(?:CA CITY|D CREEK|T"
  "OTOC)|C(?:ASSET|OLA)|R(?:TER|UM)|OLEVILLE|TEAU)|A(?:W(?:HUSKA|NEE"
  ")|N(?:AM|OL)A|ULS VALLEY|RK HILL|DEN|OLI)|E(?:R(?:KINS|NELL|RY)|("
  "?:NSACOL|ORI)A|CKHAM|GGS)|I(?:C(?:KENS|HER)|TTSBURG|EDMONT)|R(?:("
  "?:OCT|Y)OR|(?:AG)?UE|ESTON)|U(?:RCELL|TNAM)|HAROAH|LATTER)|T(?:U("
  "?:L(?:LAHASSEE|SA)|S(?:KAHOMA|SY)|PELO|RPIN|TTLE)|E(?:R(?:LTON|RA"
  "L)|X(?:HOM|OL)A|CUMSEH|MPLE)|A(?:L(?:IHIN|AL|OG)A|HLEQUAH|TUMS|FT"
  ")|H(?:(?:ACKERVILL|E VILLAG)E|OMAS)|I(?:NKER AFB|SHOMINGO|PTON)|O"
  "(?:NKAWA|M)|WIN OAKS|YRONE|RYON)|L(?:O(?:N(?:E (?:GROVE|WOLF)|GDA"
  "LE)|C(?:UST GROVE|O)|VELAND|OKEBA|GAN|YAL)|E(?:(?:XINGT|BAN)ON|(?"
  ":FLO|QUI)RE|(?:NAPA|HIG)H|ON(?:ARD)?|EDEY)|A(?:N(?:G(?:STON|LEY)|"
  "E)|M(?:ONT|AR)|VERNE|HOMA|WTON)|U(?:CIEN|THER)|INDSAY)|F(?:O(?:R("
  "?:T (?:(?:GIB|TOW)SON|S(?:UPPLY|ILL)|COBB)|AKER|GAN)|S(?:TER|S)|Y"
  "IL|X)|A(?:IR(?:LAND|MONT|VIEW|FAX)|R(?:RIS|GO)|NSHAWE|XON|Y)|I(?:"
  "T(?:TSTOWN|ZHUGH)|NLEY)|R(?:E(?:DERICK|EDOM)|ANCIS)|T TOWSON|LETC"
  "HER|ELT)|A(?:L(?:B(?:ANY|ERT|ION)|(?:DERSO|LE)N|TUS(?: AFB)?|INE|"
  "EX|VA)|R(?:(?:CADI|KOM)A|APAHO|DMORE|NETT)|D(?:A(?:IR|MS)?|DINGTO"
  "N)|M(?:ORITA|BER|ES)|N(?:ADARKO|TLERS)|(?:CHILL|PACH)E|T(?:WOOD|O"
  "KA)|FTON|SHER|VANT|GRA)|R(?:A(?:T(?:LIFF CITY|TAN)|(?:MON|VI)A|ND"
  "LETT|LSTON)|E(?:D(?: (?:ROC|OA)K|BIRD)|NTIESVILLE|YDON|ED)|O(?:S("
  "?:STON|E)|OSEVELT|LAND|CKY|FF)|I(?:NG(?:(?:WOO|OL)D|LING)|PLEY)|U"
  "(?:SH SPRINGS|BOTTOM|FE)|YAN)|D(?:E(?:L(?: CITY|AWARE)|W(?:AR|EY)"
  "|ER CREEK|PEW|VOL)|A(?:V(?:I(?:DSON|S)|ENPORT)|COMA|ISY|LE)|U(?:("
  "?:NCA|STI)N|R(?:ANT|HAM)|KE)|I(?:(?:LL CIT|SNE)Y|BBLE)|O(?:UG(?:H"
  "ERTY|LAS)|VER)|RUM(?:RIGHT|MOND))|G(?:R(?:A(?:N(?:DFIELD|ITE|T)|C"
  "EMONT|HAM|DY)|EENFIELD|OVE)|O(?:L(?:D(?:SBY|EN)|TRY)|ODWELL|TEBO|"
  "ULD|WEN|RE)|A(?:R(?:BER|VIN)|[GT]E|NS)|E(?:(?:NE AUT|A)RY|RONIMO)"
  "|LEN(?:POOL|COE)|U(?:THRIE|YMON))|O(?:K(?:E(?:ENE|MAH)| ST UNV AD"
  "M|A(?:RCHE|Y)|LAHOMA CITY|MULGEE|TAHA)|(?:C(?:HELAT|TAVI)|PTIM|ME"
  "G)A|AK(?:(?:LAN|WOO)D|HURST|S)|R(?:IENTA|LANDO)|S(?:AGE|CAR)|VERB"
  "ROOK|LUSTEE|OLOGAH|ILTON|WASSO)|K(?:I(?:AMICHI(?: CHRISTIAN MISSI"
  "ON)?|N(?:G(?:FISHER|STON)|TA)|EFER|OWA)|E(?:N(?:DRICK|EFIC|TON)|L"
  "LYVILLE|TCHUM|OTA|YES|MP)|A(?:W(?: CITY)?|NSAS)|RE(?:MLIN|BS)|NOW"
  "LES|ONAWA)|N(?:I(?:C(?:HOLS HILLS|OMA PARK)|NNEKAH)|EW(?:(?: LIM|"
  "ALL)A|CASTLE|KIRK)|O(?:R(?:TH MIAMI|MAN)|WATA|BLE)|A(?:SH(?:OBA)?"
  "|RDIN))|E(?:L(?:M(?:ORE CITY|WOOD|ER)|(?:DORAD| REN)O|K CITY|GIN)"
  "|A(?:GLE(?: CITY|TOWN)|RLSBORO|KLY)|U(?:FAUL|CH)A|(?:DMON|NI)D|RI"
  "CK)|V(?:I(?:N(?:ITA|SON)|LLAGE|AN|CI)|E(?:R(?:(?:DE|NO)N|A)|LMA)|"
  "ALLIANT)|I(?:(?:N(?:DIA(?:HOM|NOL)|OL)|SABELL)A|DABEL)|J(?:E(?:N("
  "?:NING|K)S|T)|ONES|AY)|Y(?:A(?:RNABY|LE)|UKON)|QU(?:INTON|APAW)|U"
  "NION CITY))))$"
  ,
  /* -- OR -- OR -- OR -- OR -- OR -- OR -- OR -- OR -- OR -- OR -- */
  "(?:\\b)((?^:(?i:(?:C(?:A(?:N(?:YON(?: CITY|VILLE)|NON BEACH|BY)|M"
  "(?:AS VALLEY|P SHERMAN)|(?:VE JUNCTI|RLT)ON|SCAD(?:E LOCKS|IA)|YU"
  "SE)|R(?:A(?:WFORDSVI?LL|TER LAK|BTRE|N)E|ES(?:CENT(?: LAKE)?|WELL"
  ")|OOKED RIVER(?: RANCH)?|KD RVR RNCH)|O(?:(?:(?:TTAGE GRO)?V|QUIL"
  "L)E|R(?:(?:NELIU|VALLI)S|BETT)|L(?:UMBIA CITY|TON)|OS BAY|BURG|ND"
  "ON)|H(?:RISTMAS V(?:ALLE|L)Y|(?:ARLESTO|ILOQUI)N|E(?:SHIRE|MULT))"
  "|L(?:A(?:TSKANIE|CKAMAS)|OVERDALE)|U(?:L(?:P CREEK|VER)|RTIN)|ENT"
  "RAL POINT)|M(?:A(?:R(?:YLHURST|COLA|ION)|(?:(?:UP|L)I|PLETO)N|N(?"
  ":ZANITA|NING)|YVILLE|DRAS)|O(?:UNT (?:HOOD PARKDALE|VERNON|ANGEL)"
  "|N(?:MOUTH|UMENT|ROE)|LALLA|SIER|RO)|E(?:D(?:ICAL SP(?:RIN)?GS|FO"
  "RD)|R(?:RILL|LIN)|TOLIUS|ACHAM|HAMA)|I(?:L(?:TON FR(?:EEWATE|WT)R"
  "|L CITY|WAUKIE)|TCHELL|DLAND|KKALO)|C(?:(?:KENZIE BRIDG|MINNVILL)"
  "E| KENZIE BR(?:IDGE|G)|NARY)|YRTLE (?:CREEK|POINT)|U(?:LINO|RPHY)"
  "|T HOOD PRKDL)|S(?:U(?:M(?:MER(?: LAK|VILL)E|PTER)|BLIMITY|THERLI"
  "N|NRIVER)|A(?:INT (?:BENEDICT|HELENS|PAUL)|GINAW|LEM|NDY)|H(?:E(?"
  ":R(?:IDAN|WOOD)|DD)|A(?:DY COVE|NIKO))|I(?:L(?:VER(?: LAKE|TON)|E"
  "TZ)|(?:STER|XE)S)|C(?:OTTS(?: MILLS|BURG)|APPOOSE|IO)|E(?:A(?:L R"
  "OCK|SIDE)|(?:NEC|LM)A)|PR(?:A(?:GUE RIVER|Y)|INGFIELD)|T(?:A(?:NF"
  "IELD|YTON)| BENEDICT)|W(?:EET |ISS)HOME|OUTH BEACH)|W(?:I(?:L(?:("
  "?:DER|SON)VILLE|L(?:AMINA|IAMS)|BUR)|N(?:CHEST(?:ER(?: BAY)?|R BA"
  "Y)| BAY|STON))|A(?:L(?:T(?:ERVILLE|ON)|DPORT|LOWA)|R(?:RE(?:NTO)?"
  "N|M SPRINGS)|MIC|SCO)|E(?:ST(?:(?: (?:STAYTO|LIN)|O)N|F(?:ALL|IR)"
  "|LAKE|PORT)|DDERBURN|LCHES)|O(?:OD(?: VILLAGE|BURN)|LF CREEK)|H(?"
  ":ITE CITY|EELER))|B(?:R(?:O(?:(?:OK(?:ING)?|THER)S|WNSVILLE|ADBEN"
  "T|GAN)|I(?:D(?:AL VEIL|GEPORT)|GHTWOOD))|L(?:AC(?:K BUTTE RANCH|H"
  "LY)|K BTTE RNCH|UE RIVER|ODGETT|Y)|A(?:(?:KER|Y) CITY|N(?:DON|KS)"
  "|TES)|E(?:A(?:VER(?:CREEK|TON)?|TTY)|ND)|U(?:(?:TTE FALL|RN)S|XTO"
  "N)|O(?:ARDMAN|NANZA|RING)|IRKENFELD)|G(?:R(?:A(?:N(?:(?:D ROND|IT"
  ")E|TS PASS)|SS VALLEY)|E(?:ENLEAF|SHAM))|L(?:EN(?:EDEN B(?:EA)?CH"
  "|DALE|WOOD)|(?:ADSTON|ID)E)|A(?:R(?:IBALDI|DINER)|LES CREEK|STON|"
  "TES)|O(?:VERNMENT C(?:AM)?P|LD (?:BEACH|HILL))|E(?:ARHART|RVAIS)|"
  "ILCHRIST)|P(?:O(?:RT(?: ORFOR|LAN)D|WE(?:LL BUTTE|RS)|ST)|R(?:IN("
  "?:EVILLE|CETON)|AIRIE CITY|OSPECT)|A(?:(?:CIFIC CIT|ISLE)Y|ULINA)"
  "|I(?:STOL RIVER|LOT ROCK)|L(?:EASANT HILL|USH)|H(?:ILOMATH|OENIX)"
  "|ENDLETON)|T(?:I(?:MBER(?:LINE LODGE)?|LL(?:AMOOK|ER)|DEWATER|GAR"
  "D)|H(?:E DALLES|URSTON)|OL(?:OVANA PARK|EDO)|E(?:RREBONN|NMIL)E|R"
  "(?:OUTDALE|AIL)|U(?:ALATIN|RNER)|A(?:NG|L)ENT|MBRLINE LDG|YGH VAL"
  "LEY)|A(?:L(?:(?:LEG|B)ANY|(?:OH|SE)A|VADORE)|D(?:A(?:IR VILLAGE|M"
  "S)|RIAN|EL)|R(?:CH CAPE|LINGTON|OCK)|S(?:H(?:LAN|WOO)D|TORIA)|(?:"
  "PPLEGAT|NTELOP)E|U(?:MSVILLE|RORA)|(?:THEN|ZALE)A|GNESS|MITY)|D(?"
  ":A(?:Y(?:S CREEK|VILLE|TON)|L(?:LAS|E)|MASCUS|IRY)|E(?:(?:ER ISLA"
  "N|ADWOO)D|POE BAY|TROIT|XTER)|I(?:AMOND(?: LAKE)?|LLARD)|U(?:(?:N"
  "D|RK)EE|FUR)|O(?:NALD|RENA)|R(?:EWSEY|AIN))|R(?:O(?:CKAWAY(?: B(?"
  ":EA)?CH)?|SE(?: LODGE|BURG)|GUE RIVER)|I(?:C(?:KREALL|HLAND)|(?:V"
  "ERSID|DDL)E|TTER|LEY)|E(?:EDSPORT|DMOND|MOTE)|HODODENDRON|AINIER|"
  "UFUS)|H(?:A(?:(?:L(?:FWA|SE)|PPY VALLE)Y|R(?:(?:BO|PE)R|RISBURG)|"
  "MMOND|INES)|E(?:R(?:MISTON|EFORD)|PPNER|LIX|BO)|U(?:NTINGTON|BBAR"
  "D)|I(?:LLSBORO|NES)|OOD RIVER)|L(?:A(?:(?: (?:GRAND|PIN)|FAYETT)E"
  "|KE(?: OSWEGO|SIDE|VIEW)|NGLOIS|WEN)|O(?:(?:STI|RA)NE|NG CREEK|GS"
  "DEN|WELL)|E(?:(?:XINGT|BAN)ON|ABURG)|INCOLN CITY|YONS)|N(?:E(?:W("
  "?: PINE CR(?:EE)?K|BERG|PORT)|TARTS(?: BAY)?|SKOWIN|HALEM|OTSU)|O"
  "(?:R(?:TH (?:P(?:LAINS|OWDER)|BEND)|WAY)|TI)|YSSA)|F(?:O(?:R(?:T "
  "(?:KLAMATH|ROCK)|EST GROVE)|S(?:SIL|TER)|X)|A(?:LL(?: CREEK|S CIT"
  "Y)|IRVIEW)|R(?:ENCHGLEN|IEND)|LORENCE|IELDS)|O(?:AK(?:(?: GROV|RI"
  "DG)E|LAND)|RE(?:GON CITY|TECH)|T(?:TER ROCK|IS)|CEANSIDE| BRIEN|N"
  "TARIO|DELL|PHIR|XBOW)|J(?:O(?:(?:RDAN VALLE|HN DA)Y|SEPH)|A(?:CKS"
  "ONVILLE|MIESON|SPER)|UN(?:CTION CITY|TURA)|EFFERSON)|I(?:D(?:LEYL"
  "D PARK|ANHA)|(?:NDEPENDENC|ON)E|R(?:ONSIDE|RIGON)|M(?:BLER|NAHA)|"
  "SLAND CITY)|E(?:(?:NTERPRIS|DDYVILL|UGEN)E|L(?:(?:KTO|GI)N|MIRA)|"
  "AGLE (?:CREEK|POINT)|STACADA|CHO)|K(?:I(?:N(?:G CITY|ZUA)|MBERLY)"
  "|E(?:N[OT]|IZER|RBY)|LAMATH FALLS)|U(?:M(?:ATILL|PQU)A|NI(?:ON|TY"
  ")|KIAH)|V(?:(?:E(?:RNONI|NET)|ID)A|ALE)|Y(?:A(?:CHATS|MHILL)|ONCA"
  "LLA)|ZIGZAG))))$"
  ,
  /* -- PA -- PA -- PA -- PA -- PA -- PA -- PA -- PA -- PA -- PA -- */
  "(?:\\b)((?^:(?i:(?:S(?:H(?:A(?:W(?:NEE(?: ON D(?:ELAWAR)?E)?|(?:A"
  "NES|VILL)E)|R(?:PS(?:VILLE|BURG)|ON(?: HILL)?|TLESVILLE)|D(?:Y(?:"
  " GROV|SID)E|E GAP)|MOKIN(?: DAM)?|NKSVILLE|VERTOWN)|I(?:PP(?:EN(?"
  ":SBURG|VILLE)|INGPORT)|R(?:EMANSTOWN|LEYSBURG)|NGLEHOUSE|CKSHINNY"
  "|LLINGTON)|E(?:(?:AKLEYVIL|RMANS DA)LE|NAN(?:DOAH|GO)|FFIELD|LOCT"
  "A|PPTON)|O(?:EMAKERSV(?:IL)?LE|HOLA)|REWSBURY|UNK)|T(?:R(?:A(?:(?"
  ":TTANVILL|BAN)E|USSTOWN|FFORD|SBURG)|O(?:NGSTOWN|UDSBURG))|A(?:R("
  "?: JUNCTION|LIGHT|RUCCA|FORD)|TE (?:COLLEG|LIN)E|HLSTOWN)| (?:B(?"
  ":ENEDICT|ONIFACE)|CL(?:AI)?RSVILLE|PETERSBURG|DAVIDS)|O(?:CK(?:ER"
  "TOWN|DALE)|N(?:EBORO|Y RUN)|UCHSBURG|YSTOWN|WE)|E(?:EL(?:VILLE|TO"
  "N)|VENS(?:VILLE)?|WARTSTOWN|RLING)|U(?:MP CREEK|RGEON)|ILLWATER)|"
  "A(?:INT (?:(?:DAVID|THOMA|JOHN)S|CLAIR(?:SV(?:ILLE)?)?|B(?:ENEDIC"
  "T|ONIFACE)|M(?:ICHAEL|ARYS)|PETERS(?:BURG)?)|L(?:I(?:SBURY|NA|X)|"
  "T(?:SBURG|ILLO)|FORD(?:VILLE)?|(?:UNG|ON)A|LADASBURG)|(?:(?:(?:DS"
  "BURY|BINS)VI|SSAMANSVI?)LL|GAMOR)E|N(?:DY (?:RIDG|LAK)E|ATOGA)|Y("
  "?:LORSBURG|RE)|X(?:ONBURG|TON)|CRAMENTO|EGERTOWN|RVER)|P(?:R(?:IN"
  "G(?: (?:C(?:HURCH|REEK|ITY)|BROOK TOWNSHIP|M(?:ILLS|OUNT)|G(?:ROV"
  "E|LEN)|HOUSE|RUN)|(?:VIL|DA)LE|FIELD|BORO|TOWN|S)|A(?:NKLE M(?:IL"
  ")?L|GG)S|NG BRK TWP|UCE CREEK|OUL)|A(?:RTANSBURG|NGLER)|INNERSTOW"
  "N)|O(?:U(?:TH(?: (?:W(?:ILLIAMSPORT|AVERLY)|MO(?:NTROSE|UNTAIN)|A"
  "BINGTON TOWNSHIP|(?:CANAA|GIBSO)N|H(?:EIGHT|ILL)S|(?:FO|PA)RK|STE"
  "RLING)|(?:EASTER|AMPTO)N|VIEW|WEST)|DER(?:SBURG|TON))|NESTOWN|LEB"
  "URY|MERSET)|U(?:M(?:M(?:IT (?:STA(?:TION)?|HILL)|ER(?:(?:VIL|DA)L"
  "E|HILL))|NEYTOWN)|GAR(?: (?:GROVE|NOTCH|RUN)|LOAF)|(?:TERSVILL|PL"
  "E)E|SQUEHANNA|NBURY)|C(?:H(?:(?:UY(?:LKILL HAVE|KL HAV)|AEFFERSTO"
  "?W)N|(?:NEC|WEN)KSVILLE|E(?:LLSBURG|NLEY))|OT(?:TDALE|LAND|RUN)|E"
  "NERY HILL|RANTON|IOTA)|E(?:L(?:(?:LERSVILL|INSGROV)E|TZER)|VEN (?"
  ":VALLEY|FIELD)S|W(?:ICKLEY|ARD)|(?:MINOL|CAN)E|ANOR|NECA)|I(?:N(?"
  ":KING SP(?:RIN)?|NAMAHONIN)G|(?:X MILE RU|MPSO|DMA)N|LVER(?: SPRI"
  "NG|DALE)|PESVILLE|GEL)| (?:WILLIAMSP(?:ORT?|RT)|MO(?:NTROSE|UNTAI"
  "N)|ABINGTO?N TWP|CONNELLSVL|STERLING)|W(?:E(?:ET VALLEY|NGEL)|I(?"
  ":FTWATER|SSVALE)|A(?:RTHMORE|TARA)|OYERSVILLE)|M(?:I(?:TH(?:FIELD"
  "|MILL|TON)|CKSBURG)|O(?:KE(?:TOW|RU)N|CK)|ETHPORT)|L(?:AT(?:E(?: "
  "RUN|DALE)|INGTON)|I(?:PPERY ROCK|CKVILLE|GO)|OVAN)|Y(?:(?:(?:BERT"
  "|KE)SVILL|CAMOR)E|LVAN(?: DELL|IA))|N(?:YDER(?:SBURG|TOWN)|OW SHO"
  "E)|K(?:IPPACK|YTOP)|QUIRREL HILL)|M(?:O(?:UNT(?: (?:P(?:LEASANT(?"
  ": MILLS)?|OCONO|ENN)|(?:HOLLY SPRING|MORRI)S|B(?:RADDOCK|ETHEL)|W"
  "(?:ASHINGTON|OLF)|(?:LEBAN|UNI)ON|C(?:ARMEL|OBB)|J(?:EWETT|OY)|(?"
  ":GR|A)ETNA|OLIVER)|AIN(?: TOP|HOME)|VILLE)|N(?:T(?:GOMERY(?:V(?:I"
  "L)?LE)?| (?:CLARE|ALTO)|OUR(?:SVILLE)?|ANDON|ROSE)|ROE(?: T(?:OWN"
  "SHI|W)P|VILLE|TON)|O(?:CACY STA(?:TION)?|NGAHELA)|ESSEN|ACA)|R(?:"
  "RIS(?:(?:VIL|DA)LE| RUN)?|(?:GA(?:NTOW)?|AN|TO)N|EA)|O(?:N T(?:OW"
  "NSHI|W)P|SIC)|H(?:RSVILLE|NTON)|(?:CANAQU|DEN)A|S(?:HANNON|COW)|Y"
  "LAN)|A(?:R(?:I(?:ON(?: (?:HEIGHTS?|CENTER))?|E(?:NVILLE|TTA)|ANNA"
  ")|S(?:HALLS CR(?:EE)?K|TELLER)?|TIN(?:S(?: CREEK|BURG)|DALE)?|C(?"
  ":US HOOK|HAND)|KLE(?:YSBURG|TON)|Y(?:SVILLE| D)| LIN|WOOD|BLE)|N("
  "?:O(?:R(?:VILLE)?|A)|NS CHOICE|CHESTER|SFIELD|AYUNK|HEIM)|D(?:ISO"
  "N(?: T(?:OWNSHI|W)P|BURG)?|ERA)|C(?:(?:KEYVILL|UNGI)E|ARTHUR)|HA("
  "?:NOY (?:PLANE|CITY)|FFEY)|PLE(?:TON DEP(?:OT)?| GLEN)|T(?:AMORAS"
  "|TAWANA|HER)|Y(?:FIELD|PORT|TOWN)|IN(?:ESBURG|LAND)|(?:SONTOW|LVE"
  "R)N|XATAWNY|MMOTH)|I(?:L(?:L(?:ER(?:S(?:VILLE|BURG|TOWN)|TON)| (?"
  ":VILLAGE|CREEK|HALL|RUN)|(?:MON|RIF)T|V(?:IL|A)LE|S(?:BORO)?|HEIM"
  ")|FORD(?: SQ(?:UARE)?)?|AN(?:VILLE)?|MONT PARK|NESVILLE|ESBURG|DR"
  "ED|ROY|TON)|D(?:DLE(?:B(?:UR(?:Y CENTER|G)|RY CTR)| C(?:ITY (?:EA"
  "|WE)ST|REEK)|PORT|TOWN)| CITY (?:EA|WE)ST|LAND|WAY)|N(?:ER(?:AL ("
  "?:SP(?:RIN)?GS|POINT)|S(?: MILL|VILLE))|ISINK H(?:IL)?LS|GOVILLE)"
  "|FFLIN(?:VILLE|BURG|TOWN)?|QUON)|C(?: (?:C(?:ON(?:NELLS(?:B(?:UR)"
  "?G|TOWN)|ELSTOWN)|L(?:ELLANDTOWN|URE))|K(?:E(?:ES ROCKS|AN)|NIGHT"
  "(?:STOWN)?)|(?:(?:SHERRYS|VEY)TOW|GRAN)N|(?:ALISTERV(?:IL)?L|INTY"
  "R)E|E(?:WENSVILLE|LHATTAN)|DONALD|MURRAY)|K(?:NIGHT(?:STOWN)?|E(?"
  ":ESPORT|AN))|(?:CLELLANDT|SHERRYSTO)WN|GEES MILLS|MURRAY|ADOO)|E("
  "?:R(?:I(?:ON STA(?:TION)?|DIAN)|(?:RITTS|TZ)TOWN|CER(?:SBURG)?)|A"
  "D(?:OW(?: LANDS|BROOK)|VILLE)|S(?:SIAH COLL(?:EGE)?|HOPPEN)|N(?:G"
  "ES MILLS|DENHALL|TCLE)|L(?:ROSE(?: PARK)?|CROFT)|CHANICS(?:VI?LLE"
  "|BURG)|YERSDALE|HOOPANY|XICO|DIA)|T (?:PLEASANT(?: M(?:ILLS)?)?|("
  "?:HOLLY SPG|MORRI)S|(?:WASHINGT|LEBAN)ON|BRADDOCK|OLIVER)|U(?:N(?"
  ":C(?:Y VALLE)?Y|HALL|SON)|(?:RRYSVILL|S)E|IR)|YERSTOWN)|C(?:O(?:N"
  "(?:N(?:E(?:AUT(?: LAK|VILL)|LLSVILL)E|OQU(?:ENESSIN|NS)G)|E(?:MAU"
  "GH|STOGA)|CORD(?:VILLE)?|SHOHOCKEN|FLUENCE|YNGHAM|WAY)|L(?:L(?:(?"
  ":OMSVIL|INGDA)LE|EGE(?: HILL|VILLE))|UMB(?:IA(?: (?:CROSS ROADS|X"
  " RD))?|US)|(?:MA|VE)R|EBROOK)|R(?:NW(?:ELLS (?:HEIG)?HTS|ALL)|A(?"
  ":OPOLIS|L)|LISS|SICA|RY)|A(?:L(?: (?:TOWNSHIP|CENTER)|DALE|PORT)|"
  "TESVILLE)|O(?:(?:LSPRIN|KSBUR)G|PERS(?:BURG|TOWN))|B(?:BS L(?:AKE"
  " PRESERVE|K PRES)|URN)|U(?:DERSPORT|RTDALE|LTERS|PON)|(?:WAN(?:SV"
  "ILL|ESQU)|MMODOR)E|C(?:HRAN(?:VILLE|TON)|OLAMUS)|(?:GAN STATI|VIN"
  "GT)ON|KEBURG|DORUS|PLAY)|A(?:R(?:(?:(?:(?:BON)?DA|VERSVIL)L|NEGI)"
  "E|L(?:ISLE(?: B(?:ARRAC|R)KS)?|TON)|(?:ROLLTOW|SO)N|MICHAELS)|M(?"
  ":BR(?:IDG(?:E SPRIN| SP)GS|A)|P(?:(?:BELL)?TOWN| HILL)|MAL)|S(?:T"
  "(?:LE SHAN(?:NO)?N|ANEA)|S(?:ANDRA|VILLE)|HTOWN)|L(?:LE(?:NSBURG|"
  "RY)|IFORNIA|UMET|VIN)|N(?:ADENSIS|ONSBURG|TON)|TA(?:SAUQU|WISS)A|"
  "IRNBROOK|DOGAN|BOT)|H(?:E(?:S(?:T(?:ER(?: (?:(?:(?:HEIG)?HT|SPR(?"
  ":IN)?G)S|T(?:OWNSHI|W)P)|BROOK)?|NUT R(?:IDGE|DG)| SPRINGS)|WICK)"
  "|RRY(?: TRE|VILL)E|LTENHAM|YNEY)|A(?:M(?:BERS(?:VILLE|BURG)|PION)"
  "|NDL(?:ERS VALLE|RS VL)Y|L(?:K HILL|FONT)|DDS FORD|RLEROI|THAM)|I"
  "(?:(?:NCHILL|COR)A|LDS)|URCHVILLE|RISTIANA)|L(?:A(?:R(?:K(?:S(?: "
  "(?:SUMMIT|GREEN|MILLS)|VILLE|BURG))?|I(?:(?:NGT)?ON|DGE)|EN(?:DON"
  "|CE))|YS(?:VILLE|BURG)|IRTON)|I(?:F(?:TON(?: (?:HEIG)?HTS)?|FORD)"
  "|NTON(?:VILLE)?|MAX)|E(?:AR(?:FIELD|VILLE)|ONA)|YMER|UNE)|R(?:A(?"
  ":N(?:BERRY(?: T(?:OWNSHI|W)P)?|ESVILLE)|(?:IGSVILL|BTRE)E|FTON|LE"
  "Y)|E(?:S(?:C(?:ENT|O)|SONA?)|EKSIDE|IGHTON|AMERY)|O(?:S(?:S(?:ING"
  "VILLE| FORK)|BY)|(?:YDO|W)N)|U(?:M LYNN|CIBL)E|YSTAL SP(?:RIN)?G)"
  "|E(?:NT(?:ER(?: (?:SQUARE|VALLEY)|VILLE|PORT)|R(?:AL(?: CITY|IA)|"
  "E HALL))|DAR(?:HURST| RUN|S)|CIL)|U(?:R(?:(?:WEN|LL|TI)S|RY)VILLE"
  "|(?:STER CIT|DD)Y|MBOLA)|YCLONE)|W(?:E(?:S(?:T(?: (?:L(?:E(?:(?:I"
  "SENRIN|ECHBUR)G|BANON)|AWN)|MI(?:DDLE(?:TOWN|SEX)|(?:FFLI|LTO)N)|"
  "S(?:(?:ALIS|UN)BURY|PRINGFIELD)|H(?:OMESTEAD|AZLETON|ICKORY)|P(?:"
  "ITTS(?:BURG|TON)|OINT)|C(?:ONSHOHOCKEN|HESTER)|AL(?:EXANDER|IQUIP"
  "PA)|BRI(?:DGEWATER|STOL)|E(?:LIZABETH|ASTON)|W(?:YOMING|ILLOW)|DE"
  "CATUR|READING|FINLEY|NEWTON|GROVE|VIEW|YORK)|M(?:ORELAND CI|RLND "
  "C)TY|F(?:IEL|OR)D|L(?:AND|INE)|O(?:VER|N)|PORT|TOWN)|COSVILLE)|LL"
  "(?:S(?: TANNERY|VILLE|BORO)|ERSBURG)|(?:RNERS|ED)VILLE|I(?:SSPO|K"
  "E)RT|ATHERLY|BSTER|XFORD|NDEL)|A(?:R(?:R(?:I(?:OR(?:S MARK| RUN)|"
  "NGTON)|EN(?: CENTER|DALE)?)|FORDSBURG|MINSTER)|L(?:L(?:INGFORD|AC"
  "ETON)?|NUT(?: BOTTOM|PORT)|TERSBURG|STON)|SH(?:INGTON(?: (?:(?:CR"
  "OSS|X)ING|BORO)|V(?:IL)?LE)?| BORO)|T(?:ER(?:F(?:ALL|ORD)|VILLE|M"
  "AN)|SONTOWN|TSBURG)|Y(?:NE(?:SB(?:ORO|URG))?|MART)|(?:PWALLOPE|GO"
  "NTOW)N|VERLY|BASH|MPUM)|I(?:L(?:L(?:IAM(?:S(?: T(?:OWNSHI|W)P|(?:"
  "TOW|O)N|BURG|PORT)| PENN ANNEX (?:EA|WE)ST)|OW (?:STREET|GROVE|HI"
  "LL))|K(?:ES BARRE(?: TOWNSHIP)?|INSBURG)|M(?:ERDING|ORE)|(?:BURTO"
  "|PE)N|DWOOD|COX)|N(?:D(?: (?:RIDGE|GAP)|(?:BE|SO)R)|(?:BURN|GAT)E"
  "|FIELD)|C(?:KHAVEN|ONISCO)|DNOON|TMER)| (?:(?:LE(?:ISENRIN|ECHBUR"
  ")|PITTSBUR)G|S(?:PRINGFIELD|ALISBURY)|AL(?:EXANDER|IQUIPPA)|H(?:O"
  "MESTEAD|AZLETON)|MIDDLE(?:TOWN|SEX)|BRIDGEWATER|CNSHOHOCKEN|ELIZA"
  "BETH)|O(?:R(?:TH(?:INGTON|VILLE)|MLEYSBURG|CESTER)|O(?:D(?:L(?:AN"
  "D|YN)|BURY|WARD)?|LRICH)|MELSDORF|XALL)|Y(?:N(?:NEWOOD|DMOOR|COTE"
  ")|A(?:LUSING|NO)|OM(?:ISS)?ING|COMBE|SOX)|H(?:IT(?:E(?: (?:HAVEN|"
  "MILLS|DEER)|HALL)?|AKER|SETT|NEY)|EATLAND)|M PENN ANX [EW]|LKS BA"
  "RR TWP|RIGHTSVILLE|SHNGTN XING)|B(?:E(?:A(?:VER(?: (?:M(?:EADO|D)"
  "W|SPR(?:IN)?G|FALL)S|DALE|TOWN)?|R (?:CREEK(?: T(?:OWNSHIP|W))?|L"
  "AKE)|CH (?:HAVEN|LAKE)|LLSVILLE)|L(?:L(?:E(?:(?:V(?:ILL|U)|FONT)E"
  "| V(?:ERNON|RN BR))|WOOD|VUE)|MONT HILLS|SANO)|N(?:T(?:LEYVILLE|O"
  "N)|DERSVILLE|EZETTE?| AVON|SALEM)|R(?:W(?:ICK|YN)|RYSBURG|NVILLE|"
  "LIN)|TH(?:EL(?: PARK)?|LEHEM|ANY)|C(?:HTELSVILLE|CARIA)|D(?:MINST"
  "ER|FORD)|(?:SSEM|Y)ER|ECH CREEK)|R(?:O(?:O(?:K(?:L(?:INE|YN)|HAVE"
  "N|VILLE)|MALL)|WN(?:S(?:VILLE|TOWN)|FIELD|DALE)|D(?:HEADSVI?LLE|B"
  "ECKS)|CK(?:PORT|TON|WAY)|AD TOP|GUE)|A(?:N(?:D(?:Y CAMP|AMORE)|CH"
  "(?:DALE|TON))|D(?:FORD(?:WOODS)?|ENVILLE|DOCK)|CK(?:ENRIDGE|NEY)|"
  "VE)|I(?:DGE(?:VILLE|PORT)|S(?:BIN|TOL)|ER HILL)|E(?:(?:EZE|NT)WOO"
  "D|INIGSVILLE|SSLER)|U(?:NNERVILLE|SH VALLEY|IN)|YN (?:ATHYN|MAWR)"
  ")|L(?:A(?:I(?:RS(?: MILLS|VILLE)|N)|N(?:D(?:BURG|ON)|CHARD)|CK (?"
  ":HORSE|LICK)|KE(?:SLEE|LY)|WNOX)|O(?:OM(?:ING G(?:R(?:OVE|V)|LEN)"
  "|FIELD|SBURG)|SSBURG)|UE (?:RIDGE S(?:UMMIT|M)|B[AE]LL))|U(?:R(?:"
  "N(?:T CABINS|SIDE|HAM)|(?:GETTSTOW|LINGTO)N)|CK(?: HILL F(?:AL)?L"
  "S|INGHAM)|L(?:K MAIL C(?:ENTE|T)|GE)R|(?:ENA VIST|NOL)A|T(?:ZTOWN"
  "|LER)|FFALO MILLS|SHKILL)|A(?:R(?:T(?:O(?:NSVILLE)?)?|NES(?:VILLE"
  "|BORO)|KING|REE)|KERS(?: SUMMIT|TOWN)|I(?:NBRIDGE|RDFORD)|L(?:A C"
  "YNWYD|LY)|(?:USMA|DE)N|STRESS|NGOR|TH)|O(?:W(?:MANS(?:(?:VIL|DA)L"
  "E|TOWN)|ERS)|Y(?:ER(?:TOWN|S)|NTON)|ILING SPR(?:IN)?GS|(?:OTHWY|B"
  "TOW)N|S(?:WELL|TON)|ALSBURG|LIVAR|VARD)|I(?:G(?: (?:COVE TANN(?:E"
  "RY)?|RUN)|LER(?:VILLE)?)|R(?:D(?: IN HAND|SBORO)|CHRUNVILLE|MINGH"
  "AM))|YRNEDALE)|L(?:A(?:N(?:D(?:I(?:S(?:VILLE|BURG)|NGVILLE)|ENBER"
  "G)|S(?:(?:D(?:OWN|AL))?E|FORD)|G(?:ELOTH|HORNE)|CASTER|ESBORO)|KE"
  "(?: (?:C(?:ITY|OMO)|HARMONY|WINOLA|ARIEL|LYNN)|VILLE|WOOD)|U(?:R("
  "?:EL(?:(?: RU|TO)N|DALE)|YS STA(?:TION)?)|GHLINTOWN)|(?: (?:BELL|"
  "PLUM|JOS)|IRDSVILL|PORT)E|M(?:AR(?:TINE)?|BERTON|PETER|OTT)|W(?:R"
  "ENC(?:EVILL)?E|(?:TO)?N)|R(?:(?:KSVILL|G)E|IMER)|T(?:TIMER MI?NES"
  "|ROBE)|C(?:EYVILLE|KAWAXEN)|FAYETTE H(?:IL)?L|VE(?:ROCK|LLE)|HASK"
  "A|YTON)|E(?:M(?:O(?:NT(?: F(?:URNACE|RNCE?))?|YNE)|ASTERS)|WIS(?:"
  "B(?:ERRY|URG)|(?: RU|TOW)N|VILLE)|C(?:ONTES M(?:IL)?LS|K(?: KILL|"
  "RONE))|E(?:CHBURG|TSDALE|SPORT|PER)|H(?:IGH(?: VALLEY|TON)|MAN)|N"
  "(?:(?:HARTS|OX)VILLE|NI)|(?:VITTOW|BANO)N| RAYSVILLE|ISENRING|DER"
  "ACH|STER|OLA|ROY)|I(?:N(?:E(?: L(?:EXINGTO|XNGT)N|SVILLE)|COLN UN"
  "IV(?:ERSITY)?|(?:GLESTOW|DE)N|(?:FIEL|WOO)D)|T(?:TLE(?: M(?:(?:EA"
  "DO|D)WS|ARSH)|STOWN)|ITZ)|M(?:E(?:STONE|KILN|PORT|RICK)|A)|(?:B(?"
  ":ERT|RAR)|LL)Y|G(?:HTSTREET|ONIER)|(?:CKING|ON)VILLE|ST(?:ONBURG|"
  "IE)|VERPOOL)|O(?:W(?:ER (?:BURRELL|GWYNEDD|PAXTON|SHAFT)|BER)|C(?"
  ":UST(?: GAP|DALE)|K HAVEN)|Y(?:S(?:VILLE|BURG)|ALHANNA)|R(?:DS VA"
  "LLEY|ETTO)|GAN(?:VILLE|TON)|ST CREEK|NG POND|PEZ)|U(?:(?:(?:NDYS "
  "LA|ZER)N|MBERVILL)E|C(?:ERNEMINES|INDA)|THERSBURG|DLOW|RGAN|XOR)|"
  "Y(?:ND(?:ELL|ORA)|ON STATION|KENS)|LEWELLYN)|P(?:O(?:RT(?: (?:(?:"
  "C(?:LINT|ARB)O|TREVORTO?)N|ALLEGANY|GRIFFITH|MATILDA|ROYAL)|ERS(?"
  ": SIDELING|VILLE)|LAND(?: M(?:IL)?LS)?|S SIDLING|AGE)|CO(?:NO (?:"
  "L(?:AK(?:E PRESERV)?E|K PRS)|SUMMIT|MANOR|PINES)|PSON)|TT(?:S(?:("
  "?: GROV|VILL)E|TOWN)|ERSDALE)|INT (?:PLEASANT|MARION)|YNTELLE|MER"
  "OY|LK)|E(?:N(?:N(?: (?:ST(?:ATE UNIVERSITY| UNIV)|VALLEY|HILLS|RU"
  "N)|S(?:(?:YLVANIA FURNAC|DAL)E| (?:CREE|PAR)K|BURG)|DEL)?|(?:LL|R"
  ")YN| ARGYL|BROOK|FIELD)|R(?:K(?:IOMENVI?LL|ASI)E|RYOPOLIS)|ACH (?"
  ":BOTTOM|GLEN)|T(?:ERSBURG|ROLIA)|CKVILLE|QUEA)|A(?:R(?:K(?:E(?:R("
  "?: FORD)?|SBURG)|HILL)?|ADISE(?: V(?:ALLE|L)Y)?|(?:DEES|RY)VILLE|"
  "(?:NASSU|SON|I)S)|LM(?:ER(?: T(?:OWNSHI|W)P|TON)?|YRA)?|TT(?:ERSO"
  "N (?:HEIG)?HTS|ON)|X(?:TON(?:VILLE|IA)|INOS)| FURNACE|UPACK|OLI)|"
  "I(?:T(?:TS(?:TON(?: T(?:OWNSHI|W)P)?|BURGH|FIELD)|(?:CAIR|MA)N)|N"
  "E(?: (?:GR(?:OVE(?: MILLS)?|V MLS)|FORGE|BANK)|VILLE)|L(?:GRIM G("
  "?:ARDE|D)NS|LOW)|CTURE ROCKS|PERSVILLE)|L(?:EASANT(?: (?:H(?:(?:I"
  "L)?LS|ALL)|M(?:OUN)?T|UNI?TY|GAP)|VILLE)|AIN(?:S(?: T(?:OWNSHI|W)"
  "P)?|FIELD)|UM(?:(?:STEADVI?|VI)LLE)?|YMOUTH(?: M(?:EETI|T)NG)?)|R"
  "(?:O(?:SPE(?:CT(?: PARK)?|RITY)|MPTON)|I(?:MOS(?: SECANE)?|(?:CED"
  "A|NG)LE)|ESTO(?:N PARK)?)|H(?:IL(?:(?:ADELPHI)?A|IPSBURG)|OENIXVI"
  "LLE)|U(?:NXSUTAWNEY|LASKI|RITAN)|(?:GH INT ARPR|T PLEASAN)T)|N(?:"
  "E(?:W(?: (?:B(?:E(?:RLIN(?:V(?:IL)?LE)?|THLEHEM|DFORD)|(?:RI(?:GH"
  "TO|TAI)|OSTO)N|LOOMF(?:IE)?LD|ALTIMORE|UFFALO)|(?:K(?:ENSINGTO?|I"
  "NGSTOW)|WILM(?:INGTO|NGT))N|P(?:HIL(?:ADELPHI)?A|AR(?:IS|K)|ROVID"
  "E?NCE)|G(?:E(?:RMANTOW?N|NEVA)|ALILEE)|LOND(?:ON(?: TOWNSHIP)?|N "
  "TWP)|C(?:UMBERLA?ND|OLUMBIA|ASTLE)|F(?:REE(?:PORT|DOM)|LORENCE)|A"
  "L(?:EXANDRIA?|BANY)|E(?:NTE?RPRIS|AGL)E|(?:RINGGOL|OXFOR)D|MIL(?:"
  "LPORT|FORD)|S(?:TANTON|ALEM)|HO(?:LLAND|PE)|TRIPOLI|DERRY)|TO(?:W"
  "N(?: SQ(?:UARE)?)?|N HAM(?:ILTO|LT)N)|PORT(?:VILLE)?|LONDON TWP|F"
  "OUNDLAND|MANSTOWN|VILLE|BURG|ELL|RY)|S(?:(?:HANNO|COPE)CK|QUEHONI"
  "NG)|VILLE IS(?:LAND)?|E(?:DMORE|LYTON)|(?:MACOLI|LSO)N|FFS(?:VILL"
  "E)?)|O(?:R(?:TH(?: (?:B(?:E(?:LLE VERNON|ND)|INGHAM)|WA(?:(?:SHIN"
  "GTO|RRE)N|LES)|(?:HUNTINGDO|IRWI)N|SPRINGFIELD|VERSAILLES|CHARLER"
  "OI|LEECHBURG|APOLLO|EAST)|ERN CAMBRIA|UMBERLA?ND|AMPTON|POINT)|MA"
  "LVILLE|RISTOWN|VELT|WOOD)|(?: HUNTINGDO|BLESTOW|XE)N|TTINGHAM)| ("
  "?:(?:BELL(?:E V(?:ERNO|R)| VERNO)|(?:HUNTINGD|WASHINGT)O)N|C(?:HA"
  "RLEROI|AMBRIA)|SPRINGFIELD|VERSAILLES|LEECHBURG)|A(?:TRONA (?:HEI"
  "G)?HTS|NT(?:ICOKE|Y GLO)|R(?:BERTH|VON)|ZARETH)|I(?:C(?:HOLSO|KTO"
  "W)N|NE(?:POINTS|VEH)|SBET)|U(?:(?:ANGOL|MIDI)A|REMBERG| MINE))|H("
  "?:A(?:R(?:RIS(?:ON(?: (?:V(?:ALLE|L)|CIT)Y|VILLE)|VILLE|BURG)|T(?"
  ":S(?:VILLE|TOWN)|LETON)|LE(?:YSVILLE|IGH)|(?:BORCREE|WIC)K|MON(?:"
  "SBURG|Y)|VEYS LAKE|FORD)|Z(?:E(?:L(?: HURST|WOOD)|N)|LE(?: TOWNSH"
  "I?P|TON))|M(?:PDEN T(?:OWNSHI|W)P|(?:ILTO|LI)N|BURG)|N(?:OVER(?: "
  "T(?:OWNSHI|W)P)?|NASTOWN)|L(?:L(?:STEAD|TON|AM)|IFAX)|W(?:(?:K RU"
  "|THOR)N|LEY)|VER(?:FORD|TOWN)|T(?:FIELD|BORO)|STINGS|DLEY)|O(?:L("
  "?:L(?:(?:YWOO|AN)D|IDAYSBURG|SOPPLE)|BROOK|ICONG|TWOOD|MES)|P(?:E"
  "(?:LAND|WELL)| BOTTOM|WOOD)|NE(?:Y (?:BROOK|GROVE)|SDALE)|ME(?:(?"
  ":STEA|WOO)D|R CITY)?|O(?:VERSVILLE|KSTOWN)|U(?:TZDALE|STON)|KENDA"
  "UQUA|STETTER|RSHAM|WARD)|U(?:N(?:TING(?:DON(?: V(?:ALLE)?Y)?|TON "
  "M(?:ILLS|L))|LOCK CREEK|KER)|(?:(?:TCHIN|D)SO|STONTOW)N|MMELS(?: "
  "WHARF|TOWN)|GHES(?:VILLE|TOWN)|BLERSBURG|LMEVILLE|EY)|E(?:R(?:M(?"
  ":I(?:TAG|NI)E|AN)|RICK C(?:ENTE|T)R|EFORD|NDON|SHEY)|L(?:L(?:ERTO"
  "WN|AM)|FENSTEIN)|N(?:DERSONVI?|RYVI)LLE|I(?:DELBERG|LWOOD)|SSTON|"
  "GINS)|I(?:LL(?:(?:S(?:(?:VIL|DA)L|GROV)|DAL)E|IARDS|TOWN|ER)|(?:D"
  "DEN VALLE|CKOR)Y|GHSPIRE|BBS)|Y(?:DE(?: PARK|TOWN)?|N(?:DMAN|ER))"
  ")|E(?:A(?:ST(?: (?:S(?:M(?:ITHFIELD|ETHPORT)|PRINGFIELD|TROUDSBUR"
  "G)|P(?:ETERSBURG|ITTSBURGH|ROSPECT)|F(?:ALLOWFIELD TOWNSHIP|REEDO"
  "M)|L(?:AN(?:CASTER|SDOWNE)|IBERTY)|B(?:(?:ANGO|UTLE)R|ERLIN|RADY)"
  "|M(?:C KEESPORT|ILLSBORO)|VANDERGRIFT|GREENVILLE|WATERFORD|NORRIT"
  "ON|HICKORY|TEXAS|EARL|YORK)|ON)|(?:GLE(?:S MER|VILL)|U CLAIR)E|RL"
  "(?:INGTON|VILLE))| (?:S(?:M(?:ITHFIELD|ETHPORT)|PRINGFIELD|TROUDS"
  "BURG)|(?:FALLOWFIEL|WATERFOR)D|P(?:ETERSBURG|ITTSBURGH)|M(?:CKEES"
  "PORT|ILLSBORO)|LAN(?:CASTER|SDOWNE)|VANDERGRIFT|GREENVILLE)|L(?:L"
  "(?:IOTTSBURG|WOOD CITY|SWORTH|PORT)|IZABETH(?:V(?:IL)?LE|TOWN)?|D"
  "(?:ER(?:SVILLE|TON)|RED)|(?:(?:VERS|T)O|GI|WY)N|K(?:INS PARK|LAND"
  ")|M(?:HURST|ORA)?|YSBURG|RAMA|CO)|D(?:GE(?:WORTH|MONT|LY)|D(?:ING"
  "TON|YSTONE)|INB(?:ORO|URG)|WARDSVILLE|MON)|M(?:E(?:RALD|IGH)|IGSV"
  "ILLE|LENTON|PORIUM|SWORTH|MAUS)|V(?:ANS(?: CITY|VILLE)|ER(?:ETT|S"
  "ON))|N(?:O(?:N VALLEY|LA)|DEAVOR|TRIKEN)|X(?:(?:CELSIO|ETE)R|PORT"
  "|TON)|R(?:DENHEIM|WINNA|NEST|IE)|S(?:PYVILLE|SINGTON)|BE(?:NSBURG"
  "|RVALE)|T(?:TERS|NA)|IGHTY FOUR|QUINUNK|PHRATA|FFORT|YNON)|F(?:O("
  "?:R(?:T(?: (?:(?:L(?:ITTLETO?|OUDO)|WASHINGTO)N|HILL)|Y FORT)|EST"
  "(?: (?:GROVE|CITY)|VILLE)|KS(?: T(?:OWNSHI|W)P|VILLE)|D C(?:LIFF|"
  "ITY)|BES ROAD|CE)|X(?:CROFT SQ(?:UARE)?|BURG)|UNTAIN(?: HILL|VILL"
  "E)|L(?:CROFT|SOM)|GELSVILLE|MBELL)|A(?:IR(?:VIEW(?: V(?:ILLAGE|LG"
  "))?|(?:LESS H(?:IL)?L|OAK)S|(?:CHANC|HOP)E|MOUNT CI?TY|FIELD|BANK"
  ")|LL(?:S(?: CREEK|INGTON)?|ENTIMBER)|R(?:R(?:ANDSVILLE|ELL)|MINGT"
  "ON)|(?:CTORYVILL|WN GROV)E|YETTE(?: CITY|VILLE)|NNETTSBURG)|R(?:E"
  "(?:E(?:(?:MANS)?BURG|LAND|PORT|DOM)|D(?:ERICK(?:SBU?RG|TOWN)?|ONI"
  "A)|NCHVILLE)|A(?:N(?:KLIN(?: C(?:ENTE|T)R|TOWN)?|CONIA)|CKVILLE|Z"
  "ER)|IE(?:DENS(?:BURG)?|NDSVILLE)|(?:OST|Y)BURG)|L(?:E(?:ET(?:VILL"
  "E|WOOD)|MING(?:TON)?)|O(?:R(?:EFFE|IN)|URTOWN)|I(?:CKSVILLE|NTON)"
  ")|E(?:ASTERVILLE TREVOSE|RN(?: GLEN|DALE)|(?:NE)?LTON)|I(?:SHER(?"
  ":TOWN)?|NLEYVILLE)|STRVL TRVOSE|T WASHINGTON|URLONG)|G(?:R(?:E(?:"
  "E(?:N(?:FI(?:ELD TOWNSHI|LD TW)P|S(?:B(?:ORO|URG)|TONE)| (?:LANE|"
  "PARK)|(?:CAST|VIL)LE|T(?:OWN|REE)|OCK)|LEY)|AT BEND)|A(?:N(?:VILL"
  "E(?: S(?:UMMI|M)T)?|T(?:VILLE|HAM)|D VALLEY)|(?:CETO|MPIA)N|(?:DY"
  "|PE)VILLE|Y(?:SVILLE)?|SSFLAT|TZ)|OVE(?: CITY|R)|INDSTONE)|L(?:EN"
  "(?: (?:R(?:I(?:DDLE(?: LIMA)?|CHEY)|DL LIMA|OCK)|CAMPBELL|MILLS|H"
  "OPE|LYON)|(?:MOOR|VILL|CO)E|(?:OLDE|DO)N|S(?:HAW|IDE)|WILLARD)|A("
  "?:S(?:SPORT|GOW)|DWYNE))|A(?:R(?:D(?:EN(?: CITY|VILLE)|NERS)|(?:A"
  "RDS FOR|RET)T|NET VALLEY|LAND)|L(?:(?:LITZI|ETO)N|ILEE)|N(?:ISTER"
  "|S)|STONVILLE|INES|P)|I(?:L(?:BERT(?:SVILLE|ON)?|LETT)|B(?:SON(?:"
  "IA)?|BON GLADE)|RARD(?:VILLE)?|FFORD|NTER|PSY)|E(?:ORGE(?: SCHOOL"
  "|TOWN)|(?:RMANSVILL|NESE)E|IGERTOWN|TTYSBURG)|O(?:OD(?: SPRING|VI"
  "LLE)|RDON(?:VILLE)?|ULDSBORO|WEN CITY)|WYNEDD(?: V(?:ALLE|L)Y)?|U"
  "(?:LPH|YS) MILLS)|R(?:O(?:C(?:K(?:HILL FURN(?:ACE)?|(?: GLE|TO)N|"
  "LEDGE|WOOD)|HESTER(?: M(?:IL)?LS)?)|(?:U(?:(?:ZER|SE)VILL|LETT)|M"
  "(?:ANSVILL)?|GERSVILL)E|ARING (?:B(?:R(?:OOK TWP|A?NCH)|K TP)|SP("
  "?:RIN)?G)|S(?:E(?: VALLEY|TO)|S(?:VILLE|ITER)|COE|LYN)|B(?:E(?:RT"
  "SDALE|SONIA)|INSON)|(?:YERSFOR|WLAN)D|N(?:CO|KS)|HRERSTOWN|XBURY)"
  "|E(?:A(?:DING(?: STA(?:TION)?)?|MSTOWN)?|N(?:(?:OV)?O|FREW)|B(?:E"
  "RSBURG|UCK)|ED(?:SVILLE|ERS)|D (?:HILL|LION)|V(?:ERE|LOC)|YNOLDSV"
  "ILLE|HRERSBURG|INHOLDS|PUBLIC|XMONT|CTOR|FTON|W)|I(?:C(?:H(?:(?:E"
  "YVIL|MONDA)LE|LAND(?:TOWN)?|FIELD|BORO)|E(?:S LANDING|VILLE))|D(?"
  ":DLESBURG|LEY PARK|GWAY)|(?:EGELSVILL|VERSID)E|NG(?:GOLD|TOWN)|ME"
  "RSBURG|LLTON|XFORD)|U(?:S(?:H(?:VILLE|LAND)|SELL(?:TON)?)|RAL (?:"
  "VALLEY|RIDGE)|(?:FFS DAL|TLEDG)E)|A(?:N(?:S(?:HAW|OM)|KIN)|[CV]IN"
  "E|ILROAD|LSTON|DNOR|MEY)|HEEMS|YDAL)|D(?:A(?:L(?:LAS(?:TOWN)?|MAT"
  "IA|TON)|N(?:(?:IELS)?VILLE|BORO)|(?:(?:WS|YT)O|ISYTOW)N|R(?:LINGT"
  "ON|RAGH|BY)|(?:GUS MINE|MASCU)S|VI(?:DSVILLE|STOWN)|U(?:BERVILLE|"
  "PHIN))|U(?:N(?:CAN(?:SVILLE|NON)|L(?:EVY|O)|MORE|BAR)|B(?:OIS(?:T"
  "OWN)?|LIN)|(?:QUESN|SHOR)E|R(?:HAM|YEA)|KE CENTER| BOIS|DLEY|PONT"
  ")|E(?:L(?:A(?:WARE WATER GAP|NO)|MONT|TA)| (?:WATER GAP|LANCEY|YO"
  "UNG)|RR(?:ICK CIT)?Y|V(?:AULT|ON)|N(?:VER|BO)|FIANCE|WART)|I(?:CK"
  "(?:ERSON RUN|SON CI?TY)|LL(?:SBURG|INER|TOWN)|NGMANS F(?:ER)?RY|X"
  "ONVILLE|STANT|MOCK)|O(?:(?:UGLASSVILL|RNSIF)E|N(?:ALDSON|EGAL|ORA"
  ")|YLES(?:BURG|TOWN)|WNINGTOWN|VER)|R(?:E(?:XEL HILL|SHER)|IFT(?:W"
  "OOD|ING|ON)|UM(?:ORE|S)|AVOSBURG|Y RUN)|YSART)|A(?:L(?:L(?:E(?:N("
  "?:SVILLE|PORT|TOWN|WOOD)|GHENY)|ISON(?: PARK)?|PORT)|B(?:RIGHTSVI"
  "?LLE|URTIS|ION|A)|(?:IQUIPP|TOON)A|E(?:XANDRIA|PPO)|VER(?:TON|DA)"
  "|UM BANK|DAN)|R(?:C(?:(?:ADI|OL)A|HBALD)|M(?:STRONG|BRUST|AGH)|(?"
  ":ISTE|TEMA)S|D(?:MORE|ARA)|ENDTSVILLE|NO(?:LD|T)|SENAL|ONA)|N(?:D"
  "(?:ALUSIA|REAS)|N(?:ANDA|VIL)LE|TES FORT|ALOMINK|ITA)|S(?:H(?:L(?"
  ":AND|EY)|FIELD|VILLE)|P(?:INWALL|ERS)|TON)|(?:U(?:DUBO|LTMA|BUR|S"
  "TI)|B(?:BOTTSTOW|INGTO)|KRO)N|D(?:A(?:MS(?:VILLE|BURG|TOWN)|H)|(?"
  ":DISO|RIA)N)|V(?:O(?:N(?:DAL|MOR)E|CA)|ALON|ELLA|IS)|T(?:LA(?:SBU"
  "RG|NTIC)|GLEN|HENS)|M(?:B(?:ERSON|RIDGE|LER)|ITY)|C(?:(?:KERMANVI"
  "LL|M)E|OSTA)|QUASHICOLA|ARONSBURG|IRVILLE|POLLO)|T(?:R(?:E(?:(?:X"
  "LERTOW|DYFFRI)N|VO(?:RTON|SE)|ICHLERS|SCKOW|MONT)|O(?:UT(?:VILLE|"
  " RUN)|XELVILLE|OPER|Y)|U(?:MBAU(?:ERSVI|RSV)|CKSVI)LLE|A(?:(?:NSF"
  "|IN)ER|FFORD|PPE))|A(?:(?:NNERSVILL|LMAG)E|M(?:IMENT|AQUA)|YLOR(?"
  ":STOWN)?|R(?:ENTUM|RS)|FTON|TAMY)|H(?:O(?:M(?:PSO(?:NTOW)?N|ASVIL"
  "LE)|RN(?:HURST|DALE|TON))|R(?:EE SPRINGS|OOP))|I(?:(?:TUSVILL|DIO"
  "UT)E|M(?:E WARNER|BLIN)|O(?:N(?:EST)?|G)A|RE HILL|PTON)|U(?:R(?:T"
  "LE(?: CREEK|POINT)|BOTVILLE|KEY CITY)|NKHANNOCK|LLYTOWN|SCARORA)|"
  "O(?:W(?:ER CITY|NVILLE|ANDA)|(?:UGHKENAM|PT)ON|BYHANNA|RRANCE|DD)"
  "|Y(?:LER(?:S(?:VILLE|BURG|PORT)| HILL)|RONE)|E(?:MPLE(?:TON)?|RRE"
  " HILL|LFORD)|WIN ROCKS)|K(?:E(?:N(?:NE(?:T(?:T SQUARE| SQ)|RDELL)"
  "|T)|M(?:BLESVILLE|PTON)|L(?:AYRES|TON)|ISTERVILLE|RSEY)|I(?:N(?:G"
  "(?:S(?:LEY|TON)| OF PRUSSIA)|TNERSVILLE|ZERS)|TTANNING|MBERTON|RK"
  "WOOD|LBUCK)|A(?:R(?:NS CITY|THAUS)|N(?:TNER|E)|SKA)|U(?:LP(?:SVIL"
  "LE|MONT)|(?:NKLE|TZ)TOWN)|N(?:OX(?:(?: DA|VIL)LE)?|G OF PRUSSA)|L"
  "(?:EINFELTERSV(?:ILLE)?|INGERSTOWN)|O(?:RN KREST|SSUTH|PPEL)|RE(?"
  ":SGEVILLE|AMER)|YLERTOWN)|J(?:E(?:N(?:KIN(?:S T(?:OWNSHI|W)P|TOWN"
  ")|NERS(?:TOWN)?)|R(?:SEY (?:MILLS|SHORE)|MYN|OME)|FFERSON(?: H(?:"
  "IL)?LS|VI?LLE)?|ANNETTE|SSUP)|A(?:C(?:KSON(?: (?:T(?:OWNSHI|W)P|C"
  "(?:ENTE|T)R))?|OB(?:S CREEK|US))|M(?:ES(?: C(?:REEK|ITY)|TOWN)|IS"
  "ON))|O(?:HNS(?:ONBURG|TOWN)|NES(?: MILLS|TOWN)|(?:SEPHIN|FFR)E|LI"
  "ETT)|U(?:NE(?:DALE|AU)|LIAN)|IM THORPE)|O(?:R(?:R(?:STOWN|TANNA)|"
  "E(?:FIEL|LAN)D|(?:VIST|S)ON|ANGEVILLE|WIGSBURG|BISONIA|MSBY)|L(?:"
  "D (?:ZIONSVI?LL|FORG)E|IVE(?:BURG|R)|YPHANT|ANTA|EY)|AK(?:LAND(?:"
  " MILLS)?|(?: RIDG|DAL)E|FORD|MONT|S)|S(?:CEOLA(?: MILLS)?|TERBURG"
  "|WAYO)|B(?:SERVATORY|ERLIN)|G(?:ONTZ CAMPUS|DEN)|VERBROOK H(?:IL)"
  "?LS|(?:TTSVIL|HIOPY)LE|N(?:EIDA|O)|IL CITY|XFORD)|U(?:P(?:P(?:ER("
  "?: (?:(?:MAKEFIEL|HOLLAN)D|(?:BLACK EDD|DARB)Y|S(?:AIN)?T CLAIR)|"
  "STRASBU?RG)|R (?:BLCK EDY|ST CLAIR))|R MAKEFIELD)|NI(?:ON(?: (?:C"
  "ITY|DALE)|VILLE|TOWN)|T(?:Y(?: HOUS|VILL)E|ED)|VERSITY P(?:AR)?K)"
  "|L(?:YSSES|STER|EDI)|(?:RSIN|TIC)A|WCHLAND)|V(?:A(?:N(?:D(?:ER(?:"
  "GRIF|BIL)T|LING)| (?:VOORHIS|METER)|PORT)|L(?:LEY (?:T(?:OWNSHI|W"
  ")P|FORGE|VIEW)|ENCIA|IER))|I(?:(?:RGINVIL|NTONDA)LE|LLA(?: MARI|N"
  "OV)A|CKSBURG)|E(?:N(?:ANGO|ETIA|US)|STABURG|RONA)|O(?:WINCKEL|LAN"
  "T))|I(?:N(?:D(?:IAN(?:(?:OL)?A| HEAD)|USTRY)|TERCOURSE|KERMAN|GOM"
  "AR)|M(?:MACULATA|PERIAL|LER)|R(?:V(?:INE|ONA)|WIN)|CKESBURG|DAVIL"
  "LE|SABELLA|VYLAND)|Y(?:O(?:RK(?: (?:NE?W SALEM|SPRINGS|HAVEN)|ANA"
  ")?|UNG(?:S(?:VILLE|TOWN)|WOOD)|E)|A(?:TES(?:VILLE|BORO)|RDLEY)|(?"
  ":EA(?:GERTOW|DO)|UKO)N)|Z(?:I(?:ON(?:(?: GROV|SVILL)E|HILL)|EGLER"
  "S?VILLE)|E(?:LIENOPL|RB)E|ULLINGER)|QU(?:A(?:K(?:ERTOWN|AKE)|RRYV"
  "ILLE)|E(?:(?:NTI|E)N|CREEK)|INCY)))))$"
  ,
  /* -- PR -- PR -- PR -- PR -- PR -- PR -- PR -- PR -- PR -- PR -- */
  "(?:\\b)((?^:(?i:(?:C(?:A(?:PARRA(?: (?:TER(?:RACE)?|HILLS))?|(?:B"
  "O ROJ|TAN)O|ROLINA|STANER|MUY)|O(?:LLEGE PARK|NDADO)|IALES|UPEY)|"
  "SA(?:N(?: (?:(?:SEBASTI|GERM)AN|J(?:OSE|UAN)|ANTONIO)|TURCE(?: ST"
  "ATION)?)|BANA (?:GRANDE|HOYOS|SECA)|INT JUST)|B(?:A(?:R(?:RIO OBR"
  "ERO|CELONETA)|JADERO|YAMON)|O(?: OBRERO|QUERON))|M(?:A(?:YAGUEZ|R"
  "ICAO|NATI)|I(?:NILLAS|RAMAR)|O(?:ROVIS|CA))|F(?:(?:ERNAN)?DEZ JUN"
  "COS|(?:OR)?T BUCHANAN|LORIDA)|A(?:N(?:GELES|ASCO)|GUAD(?:ILL)?A|D"
  "JUNTAS|RECIBO)|P(?:T(?:A DE TIERRA|O NUEVO)|UERTO NUEVO|ENUELAS)|"
  "L(?:A(?:(?:S MARI|J)A|RE)S|OIZA STREET|EVITTOWN)|G(?:UA(?:Y(?:ANI"
  "LLA|NABO)|NICA)|ARROCHALES|PO)|R(?:I(?:O PIEDRAS|NCON)|OSARIO|AME"
  "Y)|V(?:EGA (?:ALT|BAJ)A|IEJO SA?N JUAN)|T(?:OA (?:ALT|BAJ)A|RUJIL"
  "LO ALTO)|H(?:AT(?:O REY|ILLO)|ORMIGUEROS)|(?:(?:DOR|UTU)AD|YAUC)O"
  "|IS(?:LA VERDE|ABELA)|(?:ENSENAD|JAYUY)A|65TH INFANTRY|OLD SAN JU"
  "AN|QUEBRADILLAS))))$"
  ,
  /* -- PW -- PW -- PW -- PW -- PW -- PW -- PW -- PW -- PW -- PW -- */
  "(?:\\b)((?^:(?i:PALAU)))$"
  ,
  /* -- RI -- RI -- RI -- RI -- RI -- RI -- RI -- RI -- RI -- RI -- */
  "(?:\\b)((?^:(?i:(?:N(?:ORTH (?:S(?:MITHFIELD|CITUATE)|PROVIDENCE|"
  "KINGSTOWN)| (?:S(?:MITHFIELD|CITUATE)|PROVIDENCE|KINGSTOWN)|EW(?:"
  " SHOREHAM|PORT)|ARRAGANSETT)|W(?:EST(?: (?:GREENWICH|KINGSTON|WAR"
  "WICK)|ERLY)|OO(?:D RIVER J(?:UNCTION|T)|NSOCKET)|A(?:R(?:WICK|REN"
  ")|KEFIELD)| GREENWICH|YOMING)|P(?:R(?:UDENCE ISL(?:AND)?|OVIDENCE"
  ")|O(?:INT JUDI|RTSMOU)TH|A(?:WTUCKET|SCOAG)|EACE DALE)|(?:L(?:I(?"
  ":TTLE COMPTO|NCOL)| COMPTO)|(?:K(?:INGST|ENY)|TIVERT)O|J(?:AMESTO"
  "W|OHNSTO))N|C(?:H(?:ARLESTOWN|EPACHET)|ENTRAL FALLS|UMBERLAND|LAY"
  "VILLE|AROLINA|OVENTRY|RANSTON)|S(?:(?:(?:OUTH)? KING|AUNDER)STOWN"
  "|L(?:ATERSVILLE|OCUM)|MITHFIELD|CITUATE|HANNOCK)|E(?:AST (?:PROVI"
  "DENCE|GREENWICH)| (?:PROVIDENCE|GREENWICH)|SCOHEAG|XETER)|B(?:R(?"
  ":OWN STATION|ADFORD|ISTOL)|LOCK ISLAND|URRILLVILLE|ARRINGTON)|H(?"
  ":OP(?:E(?: VALLEY)?|KINTON)|AR(?:RISVILLE|MONY))|F(?:O(?:RESTDALE"
  "|STER)|RIAR STATION|ISKEVILLE)|R(?:I(?:VERSIDE|CHMOND)|OCKVILLE|U"
  "MFORD)|M(?:A(?:PLE|N)VILLE|IDDLETOWN)|A(?:DAMSVILLE|SHAWAY|LBION)"
  "|G(?:REEN(?:VILL)?|LENDAL)E|VALLEY FALLS|OAKLAND))))$"
  ,
  /* -- SC -- SC -- SC -- SC -- SC -- SC -- SC -- SC -- SC -- SC -- */
  "(?:\\b)((?^:(?i:(?:S(?:A(?:INT (?:(?:MATTHEW|CHARLE)S|HELENA ISLA"
  "ND|STEPHEN|GEORGE)|L(?:TERS|LEY|UDA|EM)|N(?:DY SPRINGS|TEE)|RDINI"
  "A)|U(?:M(?:MER(?:VILLE|TON)|TER)|LLIVANS IS(?:LAND)?|RFSIDE B(?:E"
  "A)?CH|NSET)|H(?:A(?:W A(?: F |F)B|RON)|OALS J(?:UNCTION|CT)|ULERV"
  "ILLE|ELDON)|T(?:A(?:R(?:TEX|R)|TE PARK)| (?:HELENA I|MATTHEW)S)|E"
  "(?:ABROOK(?: ISL(?:AND)?)?|LLERS|NECA)|I(?:(?:MPSONVIL|X MI)LE|LV"
  "ERSTREET)|O(?:UTH OF THE BORDER|CIETY HILL)|P(?:ARTANBURG|RINGFIE"
  "LD)|(?: OF BORD|LAT)ER|C(?:RANTON|OTIA)|M(?:OAKS|YRNA)|YCAMORE|WA"
  "NSEA)|C(?:H(?:E(?:R(?:RY GROVE(?: BEACH)?|OKEE F(?:AL)?LS|AW)|S(?"
  ":TER(?:FIELD)?|NEE))|A(?:RLESTON(?: AFB)?|P(?:PELLS|IN)|S AFB))|A"
  "(?:M(?:(?:ERO|DE)N|POBELLO)|(?:LHOUN FALL|NADY|DE)S|T(?:EECHEE|AW"
  "BA)|(?:RLISL|YC)E|INHOY|SSATT)|O(?:(?:OSAWHATCHI|TTAGEVILL|P)E|N("
  "?:(?:ESTE|VERS)E|WAY)|RD(?:ESVILLE|OVA)|W(?:PENS|ARD)|LUMBIA)|L(?"
  ":E(?:ARWATER|VELAND|MSON)|I(?:[FN]TON|O)|ARKS HILL|OVER)|RO(?:SS("
  "?: (?:ANCHOR|HILL))?|CKETVILLE)|ENT(?:ENARY|RAL))|B(?:A(?:T(?:ESB"
  "URG(?:-LEESVILLE)?|SBRG-LEVIL|H)|LLENTINE|RNWELL|MBERG)|E(?:L(?:V"
  "EDERE|TON)|TH(?:ERA|UNE)|NNETTSVILLE|ECH ISLAND|AUFORT)|L(?:A(?:C"
  "K(?:S(?:BURG|TOCK)|VILLE)|IR)|YTHEWOOD|ENHEIM|UFFTON)|O(?:(?:W(?:"
  "LING GREE|MA)|RDE)N|ILING SP(?:RIN)?GS|NNEAU)|R(?:A(?:NCHVILLE|DL"
  "EY)|ITTONS NECK|UNSON)|U(?:RTON BRANCH|CKSPORT|FFALO)|ISHOPVILLE)"
  "|L(?:A(?:N(?:D(?:RUM|O)|CASTER|GLEY|E)|KE (?:WYLIE|CITY|VIEW)|D(?"
  ":YS ISLAND|SON)| FRANCE|URENS|MAR|TTA)|I(?:T(?:TLE (?:M(?:OUNTAI|"
  "T)N|R(?:IVER|OCK))|CHFIELD)|BERTY(?: HILL)?|NCOLNVILLE|VINGSTON)|"
  "O(?:N(?:G(?: CREEK|S)|E STAR)|(?:WNDESVILL|DG)E|CKHART|BECO|RIS)|"
  "E(?:ESVILLE|XINGTON)|Y(?:NCHBURG|DIA|MAN)|U(?:GOFF|RAY))|M(?:O(?:"
  "UNT(?: (?:C(?:ROGHAN|ARMEL)|PLEASANT)|AIN REST|VILLE)|N(?:T(?:MOR"
  "ENCI|ICELLO)|CKS CORNER|ETTA)|DOC|ORE)|A(?:R(?:I(?:ETTA|ON)|TIN)|"
  "(?:DISO|ULDI)N|Y(?:ESVILLE|O)|NNING)|C(?: (?:C(?:O(?:NNELLS|RMICK"
  "|LL)|LELLANVILLE)|BEE)|CLELLANVLE)|U(?:RRELLS INLE?T|LLINS)|(?:T "
  "PLEASAN|EGGET)T|I(?:NTURN|LEY)|YRTLE BEACH)|W(?:A(?:R(?:E SHOALS|"
  "RENVILLE|D)|L(?:TERBORO|HALLA|LACE)|DMALAW IS(?:LAND)?|(?:TERLO|N"
  "D)O|GENER)|E(?:ST(?: (?:COLUMBIA|UNION)|MINSTER|VILLE)|(?:DGEFIEL"
  "|LLFOR)D)|I(?:LLI(?:AMS(?:TON)?|STON)|N(?:NSBORO|DSOR)|SACKY)|HIT"
  "(?:E (?:(?:ROC|OA)K|STONE)|MIRE)|OODRUFF)|G(?:R(?:E(?:E(?:N(?: (?"
  ":POND|SEA)|(?:PON|WOO)D|VILLE)|LEYVILLE|R)|AT FALLS|SHAM)|A(?:NIT"
  "EVILLE|Y COURT|MLING)|OVER)|A(?:(?:LIVANTS F(?:ER)?R|FFNE)Y|(?:DS"
  "DE|STO)N|RNETT|BLE)|L(?:EN(?:N SPRINGS|DALE)|OVERVILLE)|I(?:FFORD"
  "|LBERT)|OOSE CREEK|EORGETOWN)|P(?:A(?:R(?:RIS ISLAND|KSVILLE)|WLE"
  "YS ISL(?:AND)?|COLET(?: MILLS)?|(?:XVILL|ULIN)E|GELAND|MPLICO|TRI"
  "CK)|I(?:N(?:E(?:(?:LAN|WOO)D|VILLE)|OPOLIS)|EDMONT|CKENS)|E(?:L(?"
  ":ION|ZER)|NDLETON|RRY|AK)|O(?:RT ROYAL|MARIA|STON)|LUM BRANCH|ROS"
  "PERITY)|R(?:I(?:DGE(?: SPRING|VILLE|LAND|WAY)|CH(?:BURG|LAND)|VER"
  " HILLS|MINI|TTER|ON)|O(?:UND (?:ROCK|O)|WESVILLE|CK HILL|EBUCK)|E"
  "(?:(?:EVES|ID)VILLE|MBERT)|U(?:SSELLVILLE|FFIN|BY)|A(?:VENEL|INS)"
  ")|H(?:O(?:LLY(?: HILL|WOOD)|(?:PKIN|DGE)S|NEA PATH|RATIO)|I(?:L(?"
  ":TON HEA(?:D ISLAN)?D|DA)|CKORY GROVE)|A(?:R(?:DEE|LEY|TS)VILLE|M"
  "(?:PTON|ER)|NAHAN)|E(?:ATH SPRINGS|MINGWAY)|UGER)|N(?:OR(?:TH(?: "
  "(?:MYRTLE BEACH|CHARLESTON|AUGUSTA))?|RIS|WAY)|E(?:W(?: (?:ELLENT"
  "|ZI)ON|(?:BER)?RY)|SMITH|ESES)| (?:CHARLESTON|LITCHFIELD|MYRTLE B"
  "CH)|I(?:NETY SIX|CHOLS))|D(?:A(?:(?:VIS STATI|RLINGT)ON|UFUSKIE I"
  "S(?:LAND)?|L(?:ZELL|E)|NIEL ISLAND)|E(?:WEES ISLAND|NMARK)|O(?:RC"
  "HESTER|NALDS)|U(?:E WEST|NCAN)|(?:RAYT|ILL)ON)|E(?:D(?:GE(?:FIELD"
  "|MOOR)|ISTO(?: ISLAND)?)|A(?:S(?:TOVER|LEY)|RLY BRANCH)|L(?:L(?:I"
  "OTT|OREE)|GIN|KO)|(?:UTAWVILL|NORE)E|FFINGHAM|HRHARDT|STILL)|F(?:"
  "O(?:R(?:T (?:M(?:OTTE|ILL)|LAWN)|K)|UNTAIN INN|LLY BEACH)|(?:LO(?"
  ":YD DAL|RENC)|INGERVILL)E|AIR(?:F(?:OREST|AX)| PLAY)|RIPP ISLAND|"
  "URMAN)|T(?:R(?:AVELERS RE?ST|ENTON|IO|OY)|I(?:(?:MMONS|GER)VILLE|"
  "LLMAN)|A(?:MASSEE|YLORS|TUM)|(?:URBE|OWN)VILLE|HE CITADEL|EGA CAY"
  ")|J(?:O(?:HNS(?: ISLAND|ONVILLE|TON)|NESVILLE|ANNA)|E(?:NKINSVILL"
  "E|FFERSON|RICHO)|A(?:CKSON(?:BORO)?|MESTOWN))|A(?:L(?:LENDALE|COL"
  "U|VIN)|TLANTIC B(?:EA)?CH|(?:DAMS RU|IKE)N|ND(?:ERSON|REWS)|BBEVI"
  "LLE|RCADIA|WENDAW|YNOR)|K(?:I(?:N(?:GS(?: CREEK|TREE)|ARDS)|AWAH "
  "ISLAND)|(?:NIGHTSVILL|LIN)E|E(?:RSHAW|LTON))|I(?:SL(?:E OF PALMS|"
  "ANDTON)|N(?:DIAN LAND|MAN)|RMO|VA)|O(?:(?:CEAN DRIV|KATI)E|LA(?:N"
  "TA|R)|RANGEBURG|SWEGO)|VA(?:(?:RNVILL|UCLUS)E|N(?: WYCK|CE))|Y(?:"
  "O(?:NGES ISLAND|RK)|EMASSEE)|U(?:N(?:ION|A)|LMER)|QUINBY))))$"
  ,
  /* -- SD -- SD -- SD -- SD -- SD -- SD -- SD -- SD -- SD -- SD -- */
  "(?:\\b)((?^:(?i:(?:C(?:A(?:R(?:T(?:HAGE|ER)|PENTER)|N(?:(?:ISTOT|"
  "OV)A|TON)|MP CROOK|STLEWOOD|PUTA|VOUR)|O(?:L(?:(?:MA|TO)N|UMBIA|O"
  "ME)|R(?:S(?:ICA|ON)|ONA)|TTONWOOD|NDE)|H(?:E(?:RRY CREEK|LSEA|STE"
  "R)|A(?:MBERLAIN|NCELLOR))|L(?:A(?:R(?:EMONT|K)|IRE CITY)|EAR(?: L"
  "AKE|FIELD))|R(?:E(?:IGHTON|SBARD)|O(?:CKER|OKS)|AZY HORSE)|E(?:NT"
  "(?:RAL CITY|ERVILLE)|DARBUTTE)|USTER)|S(?:T(?: (?:LAWRENCE|CHARLE"
  "S)|O(?:NEVILLE|CKHOLM)|RA(?:NDBURG|TFORD)|ICKNEY|EPHAN|URGIS)|A(?"
  ":INT (?:(?:CHARLE|FRANCI)S|(?:LAWRENC|ONG)E)|LEM)|P(?:E(?:ARFISH("
  "?: C(?:ANYO|Y)N)?|NCER)|RINGFIELD)|I(?:LVER CITY|OUX FALLS|SSETON"
  "|NAI)|H(?:ADEHILL|ERMAN)|C(?:OTLAND|ENIC)|UMM(?:ERSE|I)T|E(?:NECA"
  "|LBY)|OUTH SHORE|KY RANCH|MITHWICK)|W(?:A(?:(?:K(?:OND|PAL)|ST)A|"
  "L(?:L(?:ACE)?|KER)|T(?:ERTOWN|AUGA)|(?:VERL|UBA)Y|R(?:NER|D)|NBLE"
  "E|GNER)|E(?:S(?:SINGT(?:ON(?: SPRINGS)?|N SPG)|TPORT)|(?:TONK|COT"
  "|WEL)A|NTWORTH|BSTER)|O(?:O(?:NSOCKET|D)|UNDED KNEE|RTHING|LSEY)|"
  "I(?:L(?:LOW LAKE|MOT)|N(?:FRED|NER)|TTEN)|HITE(?: (?:RIVER|LAKE|O"
  "WL)|HORSE|WOOD)?)|B(?:R(?:I(?:DGEWATER|STOL|TTON)|A(?:ND(?:ON|T)|"
  "DLEY)|ENTFORD|OOKINGS|YANT|UCE)|U(?:FFALO(?: (?:RIDGE|GAP))?|R(?:"
  "(?:BAN|DOC)K|KE)|LLHEAD|SHNELL|TLER)|E(?:L(?:LE FOURCH|VIDER)E|RE"
  "SFORD|THLEHEM|MIS)|A(?:T(?:ESLAND|H)|NCROFT|RNARD|DGER|LTIC)|O(?:"
  "NESTEEL|X ELDER|WDLE)|I(?:G STONE CI?TY|SON)|L(?:ACK HAWK|UNT))|M"
  "(?:I(?:L(?:L(?:BORO|ER)|ESVILLE|BANK)|SSION(?: (?:RIDGE|HILL))?|("
  "?:RAND|N)A|TCHELL|DLAND)|A(?:R(?:(?:IO|VI)N|T(?:IN|Y)|CUS)|N(?:DE"
  "RSON|SFIELD)|DISON)|O(?:(?:N(?:TROS|RO)|BRIDG)E|UN(?:T VERNON|D C"
  "ITY)|RRISTOWN)|C(?: (?:LAUGHLIN|INTOSH)|COOK LAKE)|E(?:CKLING|LLE"
  "TTE|ADOW|NNO)|U(?:D BUTTE|RDO))|H(?:A(?:R(?:R(?:IS(?:BURG|ON)|OLD"
  ")|TFORD)|(?:MIL|ZE)L|Y(?:ES|TI))|O(?:(?:UGHTO|VE)N|W(?:ARD|ES)|T "
  "SPRINGS|LABIRD|SMER)|E(?:R(?:R(?:EID|ICK)|EFORD|MOSA)|TLAND|CLA|N"
  "RY)|U(?:R(?:LEY|ON)|MBOLDT|DSON)|I(?:LL CITY|TCHCOCK|GHMORE))|L(?"
  ":A(?:KE (?:(?:PRESTO|NORDE)N|ANDES|CITY)|N(?:GFORD|TRY|E)|(?: PLA"
  "N|BOL)T)|O(?:NG(?: VALLEY|LAKE)|W(?:ER BRULE|RY)|DGEPOLE|OMIS)|E("
  "?:(?:BAN|MM)ON|STERVILLE|TCHER|NNOX|OLA|AD)|I(?:TTLE EAGLE|LY)|U("
  "?:DLOW|CAS)|YONS)|R(?:O(?:C(?:K(?:ERVILLE|HAM)|HFORD)|S(?:EBUD|HO"
  "LT|WELL|COE|LYN)|WENA)|E(?:D(?:FIELD| OWL|IG)|V(?:ILLO|A)|E HEIGH"
  "TS|LIANCE|NNER)|A(?:(?:VINI|MON)A|PID CITY|YMOND|LPH)|U(?:NNING W"
  "ATER|TLAND)|IDGEVIEW)|A(?:L(?:(?:EXANDRI|PEN)A|CESTER|TAMONT|BEE|"
  "LEN)|R(?:T(?:ESIAN|AS)|LINGTON|DMORE|MOUR)|G(?:ENCY V(?:ILLAGE|LG"
  ")|AR)|S(?:TORIA|HTON)|(?:BERDEE|VO)N|(?:KASK|UROR)A|CADEMY|MHERST"
  "|NDOVER|THOL)|F(?:OR(?:T (?:(?:PIERR|MEAD)E|THOMPSON)|ESTBURG)|A("
  "?:I(?:R(?:BURN|VIEW|FAX)|TH)|ULKTON|RMER)|R(?:E(?:DERICK|EMAN)|AN"
  "KFORT|UITDALE)|L(?:ANDREAU|ORENCE)|E(?:DORA|RNEY)|IRESTEEL|ULTON)"
  "|P(?:I(?:E(?:R(?:PONT|RE)|DMONT)|NE RIDGE|CKSTOWN)|R(?:(?:ESH|OV)"
  "O|AIRIE CITY|INGLE)|AR(?:(?:MELE|AD)E|K(?:STON|ER))|LA(?:NKINTON|"
  "INVIEW|TTE)|O(?:RCUPINE|LLOCK)|UKWANA|EEVER|HILIP)|G(?:A(?:R(?:(?"
  ":DEN CIT)?Y|RETSON)|NN VALLEY|YVILLE)|L(?:EN(?:CROSS|HAM)|AD VALL"
  "EY)|R(?:E(?:NVILLE|GORY)|OTON)|E(?:TTYSBURG|DDES)|OODWIN)|D(?:E(?"
  ":L(?:L RAPIDS|MONT)|(?:NB|WE)Y|ADWOOD|MPSTER| SMET)|A(?:(?:KOTA D"
  "UNE|LLA|VI)S|NTE)|I(?:MOCK|XON)|OL(?:AND|TON)|RAPER|UPREE)|E(?:L("
  "?:K(?: POINT|TON)|LSWORTH AFB|M SPRINGS)|(?:AGLE BUTT|STELLIN)E|("
  "?:(?:TH|G)A|RWI)N|D(?:GEMONT|EN)|NNING|UREKA|MERY)|N(?:E(?:W(?: ("
  "?:(?:UNDERWOO|HOLLAN)D|EFFINGTON)|ELL)|MO)|OR(?:TH(?: SIOUX CITY|"
  "VILLE)|BECK|RIS)| SIOUX CITY|ISLAND|UNDA)|T(?:R(?:AIL CITY|ENT|IP"
  "P)|U(?:THILL|LARE|RTON)|O(?:LSTOY|RONTO)|HUNDER HAWK|IMBER LAKE|W"
  "IN BROOKS|YNDALL|ABOR|EA)|O(?:(?:N(?:AK|ID)|TTUMW|ACOM|GLAL|WANK)"
  "A|R(?:IENT|TLEY|AL)|K(?:ATON|REEK)|L(?:DHAM|IVET)|ELRICHS|PAL)|V("
  "?:E(?:(?:R(?:MILLI|D)O|BLE)N|TAL)|AL(?:LEY SP(?:RIN)?GS|E)|I(?:BO"
  "RG|ENNA|RGIL|VIAN)|OL(?:GA|IN))|K(?:E(?:Y(?:APAHA|STONE)|NNEBEC|L"
  "DRON)|A(?:DOKA|YLOR)|RANZBURG|IMBALL|YLE)|I(?:R(?:OQUOIS|ENE)|(?:"
  "SABE|DEA)L|NTERIOR|PSWICH|ONA)|U(?:NION CENTER|TICA)|J(?:EFFERSON"
  "|AVA)|YA(?:NKTON|LE)|ZE(?:ONA|LL)|QUINN))))$"
  ,
  /* -- TN -- TN -- TN -- TN -- TN -- TN -- TN -- TN -- TN -- TN -- */
  "(?:\\b)((?^:(?i:(?:C(?:O(?:L(?:L(?:EGE(?: (?:GROV|DAL)|DAL)E|I(?:"
  "ERVILLE|NWOOD))|ONIAL H(?:EIGH|G)TS|UMBIA)|N(?:CORD(?: FARR(?:AGU"
  "T)?)?|ASAUGA)|R(?:NERSVILLE|RYTON|DOVA)|TT(?:AGE GROVE|ONTOWN)|(?"
  ":OKEVILL|UNC)E|AL(?:FIELD|MONT)|(?:VINGTO|WA)N|KER ?CREEK|PPERHIL"
  "L|SBY|MO)|H(?:A(?:P(?:MANSBORO|EL HILL)|RL(?:ESTON|OTTE)|TTANOOGA"
  ")|E(?:STNUT M(?:OU)?ND|WALLA)|U(?:RCH HILL|CKEY)|RISTIANA)|A(?:(?"
  ":R(?:YVILL|THAG)|NE RIDG)E|STALI(?:AN SPRIN|N SP)GS|(?:M(?:PAIG|D"
  "E)|LHOU)N)|U(?:MB(?:ERL(?:AND (?:FURNACE|CITY|GA?P)|ND CTY)| GAP)"
  "|NNINGHAM|LLEOKA)|R(?:O(?:SS(?: PLAINS|VILLE)|CKETT M(?:IL)?LS)|A"
  "(?:B ORCHA|WFO)RD|UMP)|L(?:A(?:RK(?:S(?:VILLE|BURG)|RANGE)|IRFIEL"
  "D)|I[FN]TON|EVELAND)|E(?:DAR (?:GROVE|HILL)|NTERVILLE|LINA)|MBRLN"
  "D FRNCE|YPRESS INN)|S(?:A(?:INT (?:ANDREWS|JOSEPH)|L(?:E CREEK|TI"
  "LLO)|ULSBURY|NTA FE|VANNAH|MBURG|RDIS)|P(?:RING(?: (?:C(?:REEK|IT"
  "Y)|HILL)|FIELD|VILLE)|E(?:EDWELL|NCER)|ARTA)|H(?:A(?:R(?:PS CHAPE"
  "L|ON)|DY VALLEY|WANEE)|E(?:LBYVILLE|RWOOD)|ILOH)|O(?:UTH(?: (?:PI"
  "TTSBURG|FULTON)|SIDE)|DDY DAISY|MERVILLE)|U(?:(?:RGOINSVILL|GAR T"
  "RE)E|MM(?:ITVILLE|ERTOWN)|NBRIGHT)|T(?:RAW(?:BERRY)? PLAINS|ANTON"
  "(?:VILLE)?|EWART)|E(?:(?:VIERVILL|QUATCHI|WANE)E|(?:YMOU|LME)R)|I"
  "(?:L(?:VER POINT|ERTON)|GNAL M(?:OUNTAI|T)N)|M(?:ITHVILLE|ARTT|YR"
  "NA)| PITTSBURG|COTTS HILL|NEEDVILLE|WEETWATER|LAYDEN)|B(?:E(?:E(?"
  ":RSH(?:EBA SPRIN|BA SP)GS|CH(?: BLUFF|GROVE))|L(?:L(?:(?: BUCKL|E"
  "VU)E|S)|VIDERE|FAST)|TH(?:EL SP(?:RIN)?GS|PAGE)|(?:AN STATI|NT)ON"
  ")|R(?:U(?:(?:SH CREE|NSWIC)K|CETON)|I(?:CEVILLE|GHTON|STOL)|AD(?:"
  "YVILLE|FORD|EN)|OWNSVILLE|ENTWOOD)|U(?:FFALO V(?:ALLE|L)Y|R(?:LIS"
  "ON|NS)|MPUS MILLS|ENA VISTA|LLS GAP|CHANAN|TLER)|L(?:O(?:OMING(?:"
  "TON SPRINGS|DALE)|UNTVILLE)|MNGTON SPGS|UFF CITY|AINE)|A(?:TH SPR"
  "INGS|NEBERRY|KEWELL|RTLETT|XTER)|O(?:N(?:E CAVE| AQUA)|LIVAR|GOTA"
  ")|I(?:G (?:SANDY|ROCK)|RCHWOOD)|Y(?:RDSTOWN|BEE))|M(?:O(?:UNT(?: "
  "(?:(?:PLEASAN|JULIE)T|CARMEL)|AIN (?:CITY|HOME))|R(?:RIS(?:(?:TOW"
  "|O)N| CHAPEL)|LEY)|N(?:TE(?:AGLE|REY)|ROE)|S(?:HEIM|COW|S)|ORESBU"
  "RG|HAWK)|I(?:L(?:L(?:I(?:GAN COLL(?:EGE)?|NGTON)|EDGEVILLE)|(?:TO"
  "|A)N)|(?:TCHELLVILL|CHI)E|D(?:DLETON|WAY)|NOR HILL|STON)|A(?:N(?:"
  "CHESTER|SFIELD)|DISON(?:VILLE)?|R(?:YVILLE|TIN)|S(?:COT|ON)|YNARD"
  "VILLE|URY CITY|CON)|C (?:(?:(?:LEMORESV(?:IL)?|MINNVIL)L|KENZI)E|"
  "DONALD|EWEN)|E(?:D(?:INA|ON)|LROSE|MPHIS|RCER)|T(?: (?:PLEASANT|C"
  "ARMEL)|N HOME)|U(?:RFREESBORO|LBERRY|NFORD))|P(?:A(?:R(?:(?:KER ("
  "?:CROSS|X)ROAD|SON|I)S|ROTTSVILLE)|L(?:M(?:ER(?:SVILLE)?|YRA)|L M"
  "ALL))|O(?:W(?:ELL(?:S CR(?:OSSROADS|SRD))?|DER SP(?:RIN)?GS)|CAHO"
  "NTAS|RTLAND|STELLE)|I(?:(?:GEON FORG|KEVILL)E|N(?:EY FLATS|SON)|C"
  "KWICK DAM|PERTON|ONEER)|LEASANT(?: (?:SHA?DE|HILL|VIEW)|VILLE)|E("
  "?:T(?:ERSBURG|ROS)|(?:GR|LH)AM)|R(?:IMM SPRINGS|OSPECT|UDEN)|U(?:"
  "LASKI|RYEAR)|HILADELPHIA)|L(?:A(?:(?: (?:FOLLETT|GRANG|VERGN)|FAY"
  "ETT)E|KE(?: CITY|LAND|SITE)|UREL BL(?:OOME|M)RY|NC(?:ASTER|ING)|("
  "?:CO|VI)NIA|WRENCEBURG|SCASSAS)|O(?:(?:OKOUT M(?:OUNTAI|T)|NE MOU"
  "NTAI)N|U(?:ISVILLE|DON)|BELVILLE|RETTO|WLAND)|E(?:(?:XINGT|BAN)ON"
  "|NO(?:IR CITY|X)|WISBURG|OMA)|I(?:(?:VINGSTO|NDE)N|MESTONE|BERTY)"
  "|U(?:(?:PTON CIT|RA)Y|TT(?:RELL|S))|Y(?:N(?:CHBURG|NVILLE)|LES))|"
  "H(?:A(?:R(?:R(?:I(?:MA|SO)N|OGATE)|T(?:SVILLE|FORD))|MP(?:SHIRE|T"
  "ON)|LLS)|U(?:R(?:RIC(?:ANE MI|NE M)LLS|ON)|NT(?:INGDON|SVILLE|LAN"
  "D)|MBOLDT)|I(?:CK(?:ORY (?:V(?:ALLE|L)Y|HILL)|MAN)|L(?:LSBORO|HAM"
  ")|XSON)|E(?:N(?:DERSON(?:VI?LLE)?|NING|RY)|LENWOOD|RMITAGE|ISKELL"
  ")|O(?:LL(?:OW ROCK|ADAY)|RN(?:BEAK|SBY)|HENWALD))|W(?:A(?:T(?:TS "
  "BAR DAM|ERTOWN|AUGA)|RT(?:BURG|RACE)|LL(?:AND|ING)|YNESBORO|SHBUR"
  "N|VERLY)|HIT(?:E(?: (?:(?:HOUS|PIN)E|BLUFF)|S(?: CREEK|BURG|IDE)|"
  "VILLE)|LEYVILLE|WELL)|I(?:L(?:LI(?:AMSPORT|STON)|DER(?:SVILLE)?)|"
  "N(?:CHESTER|FIELD))|OOD(?:LA(?:ND M(?:IL)?LS|WN)|BURY)|EST(?:PO(?"
  ":IN|R)T|MORELAND)|YNNBURG|RIGLEY)|G(?:R(?:A(?:N(?:D(?: J(?:UNCTIO"
  "N|CT)|VIEW)|VILLE)|Y(?:SVILLE)?)|EEN(?:B(?:RIER|ACK)|EVILLE|FIELD"
  ")|UETLI LAAGE?R|IMSLEY)|A(?:T(?:LINBURG|ES)|LLA(?:TIN|WAY)|INESBO"
  "RO|SSAWAY|DSDEN)|O(?:OD(?:LETTSVI?LLE|SPRING)|RDONSVILLE)|L(?:ADE"
  "VILLE|EASON)|E(?:ORGE|RMAN)TOWN|I(?:LT EDGE|BSON)|U(?:ILD|YS))|R("
  "?:O(?:CK(?: (?:BRIDGE|ISLAND)|(?:FOR|WOO)D|VALE)|(?:GER|S)SVILLE|"
  "AN MOUNTAIN|BBINS|YAL)|I(?:D(?:GE(?:TOP|LY)|DLETON)|C(?:EVILLE|KM"
  "AN)|VE(?:RWATCH|S)|PLEY)|E(?:D B(?:(?:OILING SPRIN|LNG SP)GS|ANK)"
  "|A(?:DYVILLE|GAN)|LIANCE)|U(?:T(?:HERFORD|LEDGE)|SSELLVILLE|GBY)|"
  "A(?:VENSCROFT|MER))|T(?:E(?:N(?:NESSEE R(?:IDGE|DG)| MILE)|L(?:LI"
  "CO PL(?:AI)?NS|FORD))|R(?:E(?:ZEVANT|ADWAY|NTON)|A(?:CY CITY|DE)|"
  "IMBLE|OY)|H(?:O(?:MPSONS ST(?:ATIO)?N|RN HILL)|REE WAY)|U(?:SCULU"
  "M COLL|RTLETOWN|LLAHOMA)|A(?:L(?:LASSEE|BOTT)|ZEWELL|FT)|I(?:PTON"
  "(?:VILLE)?|GRETT)|O(?:WNSEND|ONE))|D(?:E(?:C(?:ATUR(?:VILLE)?|HER"
  "D)|L(?:(?: RI|AN)O|LROSE)|N(?:MARK|VER)|ER LODGE|FEATED|VONIA)|U("
  "?:CK(?: RIVER|TOWN)|KEDOM|NLAP|FF)|I(?:CK(?:SON|EL)|XON SPRINGS)|"
  "A(?:(?:RDE|YTO)N|NDRIDGE)|O(?:WELLTOWN|VER|YLE)|R(?:UMMONDS|ESDEN"
  ")|YER(?:SBURG)?)|F(?:A(?:IR(?:F(?:IELD GLA|LD GL)DE|VIEW)|R(?:RAG"
  "UT|NER)|YETTEVILLE|LL BRANCH)|R(?:IENDS(?:VILLE|HIP)|ANK(?:EWING|"
  "LIN)|UITVALE)|I(?:N(?:GER|LEY)|SHERVILLE|VE POINTS)|L(?:A(?:G PON"
  "D|TWOODS)|INTVILLE)|O(?:RT PILLOW|STERVILLE))|A(?:L(?:L(?:ARDT|ON"
  "S|RED)|(?:EXANDRI|CO)A|TAMONT|GOOD|PINE|AMO)|R(?:NOLD A F B|[LR]I"
  "NGTON|DMORE|THUR)|(?:(?:PIS|FT)O|UBURNTOW)N|N(?:DERSONVILLE|TIOCH"
  ")|T(?:HENS|WOOD|OKA)|DAMS(?:VILLE)?|SHLAND CITY)|E(?:L(?:(?:(?:IZ"
  "ABETH|K)TO|GI)N|LENDALE|MWOOD|ORA)|A(?:G(?:LEVILLE|AN)|ST RIDGE|T"
  "ON|DS)|N(?:GLEWOOD|VILLE)|STILL SP(?:RIN)?GS|T(?:HRIDGE|OWAH)|V(?"
  ":ENSVILLE|A)|(?:IDSO|RW?I)N)|O(?:L(?:IVE(?:R SP(?:RIN)?GS|HILL)|D"
  " (?:HICKORY|FORT))|AK(?:(?: RIDG|DAL)E|(?:FIEL|LAN)D)|(?:COE|ZON)"
  "E|N(?:EIDA|LY)|OLTEWAH|RLINDA|BION)|K(?:I(?:M(?:B(?:ERLIN H(?:EIG"
  "HTS|GT)|ALL)|MINS)|NGS(?:TON(?: SP(?:RIN)?GS)?|PORT))|E(?:NTON|LS"
  "O)|YLES FORD|NOXVILLE|ARNS|ODAK)|N(?:EW(?: (?:JOH(?:NSONVIL|SONV)"
  "LE|TAZEWELL|MARKET)|BERN|COMB|PORT)|O(?:R(?:MANDY|ENE|RIS)|LENSVI"
  "LLE)|ASHVILLE|UNNELLY|IOTA)|J(?:A(?:CKS(?: CREEK|BORO|ON)|MESTOWN"
  "|SPER)|O(?:HNSON CITY|NESBOROUGH|ELTON)|E(?:FFERSON CI?TY|LLICO))"
  "|I(?:(?:NDIAN MOUN|DLEWIL)D|RON CITY)|UNI(?:ON(?: CITY|VILLE)|COI"
  ")|V(?:ANLEER|ONORE|IOLA)|Y(?:ORKVILLE|UMA)|QUEBECK))))$"
  ,
  /* -- TX -- TX -- TX -- TX -- TX -- TX -- TX -- TX -- TX -- TX -- */
  "(?:\\b)((?^:(?i:(?:S(?:A(?:N(?: (?:(?:(?:ELIZAR|YGNAC)I|BENIT|ISI"
  "DR|DIEG)O|A(?:N(?:TONI|GEL)O|UGUSTINE)|(?:PERLIT|SAB)A|(?:JUA|LEO"
  ")N|FELIPE|MARCOS)|T(?:A (?:(?:(?:ELE|AN)N|MARI|ROS)A|FE)|O)|D(?:E"
  "RSON|IA)|FORD|GER)|L(?:T(?: FLAT|ILLO)|(?:INEN|AD)O)|R(?:(?:A(?:G"
  "OS|TOG)|IT)A|GENT)|INT (?:HEDWIG|JO)|BIN(?:E PASS|AL)|G(?:ERTON|I"
  "NAW)|V(?:ANNAH|OY)|C(?:HSE|UL)|M NORWOOD|DLER|TIN)|U(?:N(?:R(?:IS"
  "E BEACH|AY)|SET(?: VALLEY)?|NYVALE| CITY|DOWN)|L(?:PHUR (?:SP(?:R"
  "IN)?GS|BLUFF)|LIVAN CITY| ROSS)|THERL(?:AND SPRINGS|ND SPG)|M(?:M"
  "ERFIELD|NER)|RFSIDE B(?:EA)?CH|GAR LAND|BLIME|DAN)|H(?:E(?:P(?:PA"
  "RD AFB|HERD)|R(?:ID|M)AN|LBYVILLE|NANDOAH|FFIELD)|A(?:(?:VANO PAR"
  "|MROC)K|(?:LLOWA|F)TER|DY SHORES)|I(?:NER|RO)|OREACRES)|T(?:A(?:["
  "FM]FORD|NTON|PLES|R)|E(?:RLING CITY|PHENVILLE)|O(?:(?:NEWA|WE)LL|"
  "CKDALE)|R(?:A(?:TFORD|WN)|EETMAN)|INNETT| PAUL)|O(?:U(?:TH(?: (?:"
  "P(?:ADRE ISLAND|LAINS)|TEXARKANA|HOUSTON|BEND)|LA(?:KE|ND)|MAYD)|"
  "R LAKE)|MER(?:VILLE|SET)|CORRO|NORA)|E(?:A(?:G(?:OVILLE|RAVES)|BR"
  "OOK|DRIFT|LY)|LMA(?:N CITY)?|G(?:UIN|NO)|CURITY SVC|VEN POINTS|BA"
  "STIAN|MINOLE|YMOUR)|I(?:E(?:NNA PLANT(?:ATION)?|RRA BLANCA)|L(?:V"
  "ER(?:TON)?|SBEE)|M(?:ONTON|MS)|N(?:GLE)?TON|DNEY)|P(?:RING(?: BRA"
  "NCH|LAKE|TOWN)?|(?:ICEWOO|OFFOR)D|EA(?:RMAN|KS)|U(?:RGE)?R|LENDOR"
  "A|ADE)|C(?:H(?:ULENBURG|WERTNER|ERTZ)|OT(?:TSVILLE|LAND)|ROGGINS|"
  "URRY)|W(?:EE(?:T(?: HOME|WATER)|NY)|INNEY SWI?TCH)|M(?:I(?:TH(?:V"
  "ILLE|LAND)|LEY)|YER)| (?:PADRE ISL ?E|TEXARKANA)|K(?:ELLYTOWN|IDM"
  "ORE)|L(?:IDELL|ATON|OCUM)|N(?:YDER|OOK)|YLVESTER)|C(?:O(?:L(?:L(?"
  ":E(?:GE(?: STA(?:TION)?|PORT)|YVILLE)|INSVILLE)|ORADO CITY|DSPRIN"
  "G|MESNEIL|UMBUS|EMAN)|T(?:TON(?:W(?:OOD SHORE|D SHR)S| CENTER)|UL"
  "LA)|M(?:(?:ANCH|MERC)E|B(?:INE|ES)|STOCK|FORT|O)|P(?:PE(?:R(?: CA"
  "NYON|AS COVE)|LL)|EVILLE)|N(?:C(?:(?:EPCIO|A)N|ORD)|(?:VERS|RO)?E"
  ")|R(?:PUS CHRISTI|SICANA|RIGAN|INTH)|O(?:(?:KVILL|LIDG)E|PER)|(?:"
  "YANOS|AHOM)A|V(?:INGTON|E)|UPLAND|ST)|A(?:R(?:R(?:IZO SP(?:RIN)?G"
  "S|OLLTON)|(?:THAG|MIN)E|L(?:SBAD|TON)|BON)|M(?:P(?: (?:VERDE|WOOD"
  ")|BELL(?:TON)?)|(?:ERO|DE)N)|N(?:YON(?: LAKE)?|(?:ADIA|TO)N|UTILL"
  "O)|L(?:L(?:I(?:SBURG|HAM))?|DWELL|VERT)|S(?:T(?:LE HILLS|ROVILLE|"
  "ELL)|ON)|T(?: SPRING|ARINA)|DDO(?: MILLS)?|CTUS|YUGA)|H(?:A(?:N(?"
  ":N(?:ELVIEW|ING)|DLER)|P(?:MAN RANCH|PELL HILL)|RLOTTE|TFIELD)|I("
  "?:NA(?: (?:SPRING|GROVE))?|L(?:LICOTHE|DRESS|TON)|CO(?:TA)?|RENO)"
  "|RI(?:ST(?:OVAL|INE)|ESMAN)|E(?:ROKEE|STER))|L(?:A(?:R(?:KSV(?:IL"
  "LE(?: CITY)?|LE CTY)|ENDON)|YTON|UDE)|E(?:AR L(?:AKE SHORE|K SHR)"
  "S|(?:MVILL|BURN)E|VELAND)|UT(?:CH CITY|E)|(?:ODIN|YD)E|I(?:FTON|N"
  "T))|R(?:O(?:S(?:S(?: PLAIN|ROAD)S|BY(?:TON)?)|W(?:ELL|LEY)|CKETT)"
  "|A(?:N(?:FILLS GAP|DALL|E)|WFORD)|YSTAL (?:BEACH|CITY)|E(?:EDMOOR"
  "|SSON)|P CHRISTI)|E(?:DAR (?:(?:CREE|PAR)K|HILL|LANE)|NT(?:ER(?: "
  "POINT|VILLE)?|RALIA)|L(?:ESTE|INA)|E VEE)|U(?:N(?:NINGHAM|EY)|T A"
  "ND SHOOT|SHING|ERO|MBY)|I(?:TY BY THE SEA|(?:BOL|SC)O)|YPRESS(?: "
  "MILL)?|TY BY THE SE)|B(?:R(?:O(?:OK(?:S(?: (?:C(?:ITY BASE|B)|AFB"
  ")|IDE V(?:ILLAGE|L)|HIRE|TON)|E(?:SMITH|LAND))|WN(?:S(?:VILLE|BOR"
  "O)|(?:FIEL|WOO)D)|N(?:SON|TE)|ADDUS|CK)|I(?:DGE(?: CITY|PORT)|ARC"
  "LIFF|SCOE|GGS)|A(?:CKETTVILLE|SHEAR|ZORIA|NDON|DY)|E(?:CKENRIDGE|"
  "MOND|NHAM)|U(?:CEVILLE|NI)|Y(?:SO|A)N)|E(?:N(?: (?:FRANKLIN|WHEEL"
  "ER|ARNOLD|BOLT)|AVIDES|BROOK|JAMIN|D)|L(?:L(?:(?:VILL|AIR|EVU)E|M"
  "EAD|S)|MONT|TON)|E(?: (?:CAVES?|HOUSE)|VILLE)|A(?:(?:CH CIT|SLE)Y"
  "|UMONT)|R(?:(?:GHEI|TRA)M|CLAIR)|(?:CKVILL|B)E|D(?:FORD|IAS)|VERL"
  "Y HILLS|ST)|A(?:R(?:T(?:ONVILLE|LETT)|K(?:SDALE|ER)|N(?:HART|UM)|"
  "DWELL|STOW|RY)|L(?:C(?:ONES (?:HEIG)?HT|H SPRING)S|LINGER|MORHEA)"
  "|Y(?:OU VISTA| CITY|SIDE|TOWN|VIEW)|N(?:QUETE|DERA|GS)|T(?:ESVILL"
  "E|SON)|I(?:LEY|RD)|CLIFF|GWELL|STROP)|L(?:U(?:E(?: (?:MOUND|RIDGE"
  ")|GROVE)|FF(?: DALE|TON)|M)|O(?:OM(?:ING(?: GR(?:OVE|V)|TON)|BURG"
  ")|SSOM)|E(?:(?:IBLERVILL|DSO)E|SSING)|A(?:CK(?:WELL)?|N(?:KET|CO)"
  "))|U(?:R(?:K(?:E(?:VILLE|TT)?|BURNETT)|(?:L(?:INGT|ES)|T)ON|NET)|"
  "C(?:HANAN DAM|KHOLTS)|L(?:VERDE|LARD|A)|FFALO(?: GAP)?|SHLAND|[DN"
  "]A)|O(?:N(?: (?:WIER|AMI)|HAM)|Y(?:S RANCH|D)|(?:GAT|VIN)A|(?:ERN"
  "|WI)E|O(?:KER|TH)|LING|RGER|STON)|I(?:G(?: (?:BEND NATIONAL PARK|"
  "S(?:PRING|ANDY)|WELLS|LAKE)|GS FIELD|FOOT)|ROME|SHOP|VINS)|G BND "
  "NTL PK|Y(?:ERS|NUM))|M(?:A(?:R(?:T(?:IN(?:SVIL|DA)LE)?|(?:SHAL|YN"
  "EA)L|(?:ATHO|LI)N|I(?:ETTA|ON)|BLE FALLS|KHAM|QUEZ|FA)|GNOLIA(?: "
  "SP(?:RIN)?GS)?|N(?:SFIELD|CHACA|VEL|OR)|Y(?:SFIELD|DELLE|PEARL)?|"
  "T(?:A(?:GORDA|DOR)|HIS)|(?:DISONVIL|P)LE|U(?:RICEVILLE|D)|L(?:AKO"
  "FF|ONE)|(?:STER)?SON|CDONA|XWELL|BANK)|O(?:U(?:N(?:T(?: (?:(?:SEL"
  "MA|VERNO)N|ENTERPRISE|PLEASANT|CALM)|AIN (?:CITY|HOME))|D)|LTON)|"
  "N(?:T(?:A(?:GUE|LBA)| BELVIEU|E ALTO|GOMERY)|ROE CITY|AHANS)|R(?:"
  "GAN(?:S POIN(?:T RESOR)?T| MILL)?|(?:TO|A)N|SE)|O(?:DY|RE)|BEETIE"
  "|SCOW)|C(?: (?:(?:(?:QUEE|KIN)N|CA(?:ULL|M))EY|GREGOR|DADE|LEOD|N"
  "EIL)|D(?:ONALD OBS(?:ERVATORY)?|ADE)|(?:(?:QUEE|KIN)NE|C(?:AME|O)"
  ")Y|(?:(?:MAH|LE)A|FADDI)N|A(?:LLEN|DOO)|NEIL)|I(?:L(?:L(?:ERSVIEW"
  "|ICAN|SAP)|A(?:NO|M)|FORD|ES)|N(?:E(?:RAL(?: WELLS)?|OLA)|DEN|GUS"
  ")|D(?:L(?:OTHIAN|AND)|FIELD|KIFF|WAY)|SS(?:OURI CITY|ION)|RANDO C"
  "ITY|AMI|CO)|E(?:R(?:T(?:ENS|ZON)|I(?:DIAN|T)|CEDES|ETA|KEL)|ADOW("
  "?:S PLACE|LAKES)?|(?:YERSVILL|SQUIT)E|L(?:ISSA|VIN)|N(?:TONE|ARD)"
  "|(?:DIN|XI)A|GARGEL|MPHIS)|U(?:L(?:(?:DOO|LI)N|ESHOE)|R(?:CHISON|"
  "PHY)|ENSTER|MFORD|NDAY)|T (?:(?:SYLVA|VERNO)N|ENTERPRISE|PLEASANT"
  ")|YRA)|L(?:A(?:KE(?: (?:C(?:REEK|ITY)|LIMESTONE|JACKSON|DALLAS|KI"
  "OWA|WORTH)|W(?:OOD V(?:ILLAGE|LG)|AY)|HILLS|SIDE|VIEW)| (?:(?:V(?"
  ":ERNI|ILL)|BLANC|FERI|JOY)A|(?:GRANG|COST|SALL)E|M(?:ARQUE|ESA)|P"
  "(?:ORTE|RYOR)|WARD)|C(?:KLAND(?: A(?: F |F)B)?|Y LAKEVIEW)|N(?:E("
  "?: CITY|VILLE)|CASTER|GTRY|TANA)|G(?:UNA (?:VISTA|PARK)|O VISTA)|"
  "UGHLIN A(?: F |F)B|M(?:PASAS|ESA)|(?:DONI|SAR)A|V(?:ERNIA|ON)|R(?"
  ":EDO|UE)|IRD HILL|ZBUDDIE|JITAS|TEXO|WN)|O(?:N(?:G(?: (?:BRANCH|M"
  "OTT)|VIEW)|E (?:STAR|OAK)|DON)|S(?: (?:(?:FRES|EBA)N|INDI)O|T PIN"
  "E)S|R(?:EN(?:ZO|A)|AINE)|CK(?:HART|NEY)|V(?:ELADY|ING)|(?:G CABI|"
  "H)N|(?:UIS|WAK)E|(?:LI|ME)TA|(?:PE|ZA)NO|DI|OP|TT)|E(?:V(?:I STRA"
  "USS(?: EVACUEE CTR)?|ELLAND)|ON(?: (?:JUNCTION|VALLEY)|A(?:RD)?)|"
  "A(?:(?:GUE CIT|DA|KE|R)Y|NDER)|(?:LIA LAK|WISVILL)E|ES(?:VILLE|BU"
  "RG)|DBETTER|XINGTON|GGETT|NORAH|FORS|MING|ROY)|I(?:N(?:D(?:ALE|SA"
  "Y|EN)|(?:COL)?N|GLEVILLE)|TTLE(?: (?:RIVER ACADEMY|ELM)|FIELD)|V("
  "?:E(?:RPOOL| OAK)|INGSTON)|BERTY(?: HILL)?|P(?:SCOMB|AN)|LLIAN|SS"
  "IE)|U(?:(?:MBERTO|FKI)N|(?:EDER|CA)S|BBOCK|LING)|Y(?:FORD|ONS|TLE"
  ")|K LIMESTONE|TL RVR ACAD|LANO)|P(?:O(?:RT(?: (?:A(?:R(?:ANSAS|TH"
  "UR)|CRES)|(?:O CONNO|BOLIVA)R|MANSFIELD|ISABEL|LAVACA|NECHES)|LAN"
  "D|ER)|INT(?: (?:COMFORT|VENTURE)|BLANK)?|T(?:TS(?:VILLE|BORO)|EET"
  "|H)|N(?:TOTOC|DER)|W(?:DERLY|ELL)|OLVILLE|LLOK|YNOR|ST)|A(?:N(?:O"
  "(?:RAMA V(?:ILLAGE|LG)|LA)|(?:NA MARI|DOR)A|HANDLE|TEGO)|L(?:M(?:"
  "HURST|VIEW|ER)|O PINTO|ESTINE|ACIOS|UXY)|TT(?:ON(?:VILLE)?|ISON)|"
  "R(?:ADISE|K ROW|IS)|I(?:NT ROCK|GE)|(?:SADEN|MP)A|DUCAH|WNEE)|R(?"
  ":O(?:VID(?:ENCE VILLAGE|NCE VIL)|GRESO(?: L(?:AKE|K)S)?|(?:CTO|SP"
  "E)R)|AIRIE (?:HILL|VIEW|LEA)|I(?:NCETON|DDY|CE)|E(?:SIDIO|MONT)|T"
  " MANSFIELD)|E(?:N(?:(?:NING|DLE)TON|ELOPE|ITAS|WELL)|A(?:R(?: VAL"
  "LEY|LAND|SALL)|STER)|T(?:T(?:US|Y)|ERSBURG|ROLIA)|RR(?:Y(?:TON)?|"
  "IN)|C(?:AN GAP|OS)|GGY|P)|L(?:A(?:N(?:TERSVILLE|O)|IN(?:VIEW|S)|C"
  "EDO)|E(?:ASANTON|DGER)|UM)|I(?:NE(?:HURST|LAND)|LOT POINT|PE CREE"
  "K|TTSBURG|CKTON|ERCE)|U(?:R(?:MELA|DON)|TNAM)|(?:FLUGERVILL|YOT)E"
  "|H(?:ILLIPS|ARR))|W(?:E(?:S(?:T(?: (?:(?:UNIVERSITY PLAC|ORANG)E|"
  "LAKE H(?:IL)?LS|COLUMBIA|TAWAKONI|POINT)|WORTH V(?:ILLAGE|LG)|MIN"
  "STER|BROOK|HOFF|LAKE|ON)?|LACO)|L(?:L(?:(?:INGTO|BOR|MA)N|S)|CH)|"
  "B(?:BERVILLE|STER)|I(?:(?:MA)?R|NERT)|(?:ESATCH|TMOR)E|ATHERFORD)"
  "|I(?:L(?:L(?:OW (?:CITY|PARK)|S POINT|IS)|FORD HALL(?: USAF HOSP)"
  "?|DORADO|MER|SON)|N(?:D(?:(?:THOR|CRE)ST|OM)|N(?:SBORO|IE)|CHESTE"
  "R|FIELD|GATE|TERS|ONA|K)|C(?:HITA FALLS|KETT)|MBERLEY|ERGATE)|A(?"
  ":L(?:L(?:IS(?:VILLE)?|ER)?|NUT SP(?:RIN)?GS|BURG)|R(?:RE(?:NTO)?N"
  "|ING|DA)|T(?:ER VALLEY|AUGA)|(?:XAHACHI|YSID)E|K(?:E VILLAGE|A)|S"
  "(?:HINGTON|KOM)|DSWORTH|ELDER|CO)|H(?:IT(?:E(?: (?:SETTLEMENT|DEE"
  "R|OAK)|(?:HOUS|FAC)E|WRIGHT|SBORO)|(?:SET)?T|HARRAL|NEY)|EEL(?:OC"
  "K|ER)|(?:ART)?ON|T SETTLEMT)|O(?:OD(?:S(?:BORO|ON)|LA(?:KE|WN)|CR"
  "EEK|VILLE|WAY)|LF(?:E CITY|FORTH)|RTHAM|DEN)|RIGHTSBORO| UNIV PL|"
  "YLIE)|R(?:O(?:C(?:K(?:(?: IS)?LAND|W(?:ALL|OOD)|SPRINGS|DALE|PORT"
  ")|HE(?:STER|LLE))|S(?:E(?:NBERG|BUD)|S(?:TON|ER)?|HARON|ANKY|COE)"
  "|A(?:N(?:S PRAIRI|OK)E|RING SP(?:RI)?NGS)|UND (?:M(?:OUNTAI|T)N|R"
  "OCK|TOP)|B(?:(?:INSO|STOW)N|ERT LEE|Y)|MA(?:N FOREST|YOR)?|G(?:AN"
  "VILLE|ERS)|W(?:LETT|ENA)|(?:XTO|TA)N|LLINGWOOD|PESVILLE|YSE CITY|"
  "OSEVELT)|I(?:C(?:H(?:LAND(?: (?:SP(?:RIN)?G|H(?:IL)?L)S)?|(?:MON|"
  "WOO)D|ARDS(?:ON)?)|E)|O (?:(?:BRAV|HOND|FRI)O|GRANDE C(?:IT)?Y|(?"
  ":MEDIN|VIST)A)|V(?:ER(?: OAKS|SIDE)|IERA)|SING STAR|NGGOLD|ESEL|D"
  "GE)|A(?:N(?:DOLPH(?: A(?:IR(?: FORCE BASE)?|(?: F |F)B))?|(?:SOM "
  "CANYO|KI)N|CHO VIEJO|GER)|Y(?:MONDVILLE|WOOD)|I(?:NBOW|SIN)|TCLIF"
  "F|VENNA|LLS)|E(?:D(?: (?:(?:ROC|OA)K|SPRINGS)|WATER|FORD)|A(?:LIT"
  "OS|GAN)|(?:FUGI|N)O|CYCLE|KLAW)|U(?:N(?:AWAY BAY|GE)|LE|SK)|(?:HO"
  "M|Y)E)|H(?:A(?:R(?:(?:L(?:INGE|ETO)|DI)N|KER (?:HEIG)?HTS|(?:ROL|"
  "WOO)D|T(?:LEY)?|GILL|PER)|L(?:L(?:ETT)?SVILLE|E CENTER|TOM CITY)|"
  "M(?:(?:ILTO|LI)N|SHIRE)|S(?:KELL|LET|SE)|W(?:KINS|LEY)|NKAMER|PPY"
  ")|I(?:G(?:H(?:LAND(?: (?:VILL(?:AGE)?|HAVE?N)|S)| ISLAND)|GINS)|L"
  "L(?: COUNTRY VILLAGE|TOP LAKES|ISTER|SBORO)|D(?:E(?: A |A)WAY|ALG"
  "O)|C(?:KORY CREEK|O)|TCHCOCK)|O(?:LL(?:Y(?: L(?:AKE RA|K R)NCH|WO"
  "OD P(?:AR)?K)|IDAY|AND)|R(?:SESHOE BA|IZON CIT)Y|N(?:EY GROVE|DO)"
  "|C(?:HHEIM|KLEY)|W(?:ARDWICK|E)|(?:UST|BS)ON|OKS)|E(?:A(?:R(?:TLA"
  "ND|NE)|TH(?:RIDGE)?)|N(?:DERSON|RIETTA)|R(?:MLEIGH|EFORD)|MP(?:ST"
  "EAD|HILL)|(?:WIT|X)T|BBRONVILLE|IDENHEIMER|LOTES|DLEY)|U(?:N(?:T("
  "?:INGTON|SVILLE)?|GERFORD)|(?:GHES SP(?:RIN)?G|DSON OAK)S|F(?:SMI"
  "TH|FMAN)|T(?:CHINS|TO)|BBARD|MBLE|RST|LL)|L CNTRY VLG|YE)|G(?:R(?"
  ":A(?:N(?:D(?: (?:PRAIRI|SALIN)E|FALLS|VIEW)|GER(?:LAND)?|ITE SHLS"
  "|BURY)|PE(?: CREEK|LAND|VINE)|FORD|HAM)|E(?:EN(?:VILLE|WOOD)|GORY"
  ")|O(?:VE(?:TON|S)|ESBECK|OM)|U(?:LLA|VER)|IDIRON)|A(?:R(?:DEN(?: "
  "(?:(?:VALLE|CIT)Y|RIDGE)|DALE)|(?:LAN|WOO)D|CIASVILLE|RISON|Y)|L("
  "?:(?:VESTO|LATI)N|ENA PARK)|(?:TESVILL|US)E|I(?:NESVILLE|L)|NADO)"
  "|O(?:L(?:D(?:S(?:BORO|MITH)|THWAITE|EN)|IAD)|R(?:DON(?:VILLE)?|MA"
  "N|EE)|OD(?:FEL?LOW AFB|RICH)|ULDBUSK|NZALES|DLEY|BER)|L(?:EN(?: ("
  "?:FLORA|ROSE)|N HEIGHTS)|A(?:DEWAT|ZI)ER|IDDEN)|U(?:N(?: BARREL C"
  "(?:IT)?Y|TER)|(?:STIN|THRI)E|ERRA|Y)|I(?:L(?:(?:CHRIS|LET)T|MER)|"
  "R(?:ARD|VIN)|DDINGS)|E(?:ORGE(?: WEST|TOWN)|RONIMO|NEVA))|D(?:E(?"
  ":L(?: (?:VALLE|RIO)|L CITY|MITA)|N(?:(?:IS|T)ON|VER CITY|NIS)|C(?"
  ":KER PR(?:AIRIE)?|ATUR)| (?:BERRY|KALB|LEON)|(?:RMOT|TROI|POR)T|("
  "?:WEY|AN)VILLE|S(?:DEMONA|OTO)|V(?:ERS|INE)|ER PARK)|A(?:L(?:LA(?"
  ":RDSVILLE|S)|HART|E)|(?:(?:YT|M)O|W(?:SO)?)N|N(?:CIGER|EVANG|BURY"
  ")|I(?:NGERFIELD|SETTA)|RROUZETT|VILLA)|O(?:U(?:G(?:LASS(?:VILLE)?"
  "|HERTY)|BLE OAK|CETTE)|D(?:D CITY|SON|GE)|N(?:IE|NA)|RCHESTER|GWO"
  "OD|BBIN|OLE|SS)|I(?:CK(?:INSON|ENS)|M(?:E BOX|MITT)|A(?:LVILLE|NA"
  ")|BOLL|LLEY|NERO|KE)|R(?:I(?:PPING SP(?:RIN)?GS|FTWOOD|SCOLL)|YDE"
  "N)|U(?:N(?:CANVILLE|LAY|N)|M(?:ONT|AS)|BLIN)|FW(?: AIRPORT)?|YESS"
  " AFB| HANIS)|T(?:E(?:N(?:N(?:(?:ESSEE)? COLONY|YSON)|AHA)|L(?:E(?"
  ":GRAPH|PHONE)|FERNER|L)|X(?:A(?:S CITY|RKANA)|LINE|ON)|R(?:RELL(?"
  ": HILLS)?|LINGUA)|(?:AGU|MPL)E|HUACANA)|H(?:O(?:M(?:ASTON|PSONS)|"
  "RN(?:DALE|TON))|E (?:(?:WOODLAND|HILL)S|COLONY)|R(?:EE RIVERS|OCK"
  "MORTON|ALL)|ICKET)|A(?:YLOR(?: L(?:AKE VILLAGE|K VLG))?|R(?:PLEY|"
  "ZAN)|L(?:CO|PA)|HOKA|TUM|FT)|R(?:O(?:PHY CLUB|UP|Y)|INI(?:DAD|TY)"
  "|ENT(?:ON)?|USCOTT)|O(?:M(?: BEAN|BALL)|(?:RNILL|KI)O|YAH(?:VALE)"
  "?|LAR|W)|U(?:(?:L(?:ET|I)|SCOL)A|R(?:NERTOWN|KEY))|I(?:(?:MPSO|LD"
  "E)N|KI ISLAND|VOLI|OGA)|Y(?:LER|NAN|E)|WITTY)|A(?:L(?:A(?:MO(?: H"
  "EIGHTS)?|NREED)|T(?:A(?: LOMA|IR)|ON?)|L(?:E(?:YTO)?|ISO)N|B(?:A("
  "?:NY)?|ERT)|V(?:ARADO|ORD|IN)|I(?:CE|EF)|PINE|EDO)|R(?:C(?:(?:ADI"
  "|OL)A|HER CITY)|T(?:ESIA WELLS|HUR CITY)?|ANSAS PASS|LINGTON|MSTR"
  "ONG|GYLE|P)|N(?:D(?:ERSON|REWS|ICE)|(?:GLET|S)ON|T(?:HONY|ON)|(?:"
  "NO)?NA|AHUAC)|T(?:(?:ASCO(?:CIT|S)|LANT)A|HENS)|U(?:ST(?:WELL|IN)"
  "|BREY|RORA)|B(?:ERNATHY|ILENE|BOTT)|D(?:(?:DISO|RIA)N|KINS)|V(?:I"
  "NGER|ALON|ERY|OCA)|M(?:ARILLO|HERST|ES)|S(?:PERMONT|HERTON)|(?:GU"
  "A DULC|ZL)E|C(?:KERLY|TON|E)|(?:FTO|IKE)N|PPLE SPRINGS|QUILLA|XTE"
  "LL)|F(?:A(?:L(?:CON(?: (?:HEIG)?HTS)?|FURRIAS|LS CITY)|R(?:MERS(?"
  ": BRA?NCH|VILLE)|NSWORTH|WELL)|IR(?: OAKS(?: RANCH)?|FIELD|VIEW)|"
  "(?:YETTEVILL|T)E|BENS|NNIN)|O(?:R(?:T (?:S(?:AM HOUS|TOCK)TON|H(?"
  ":ANCOCK|OOD)|(?:BLIS|DAVI)S|MC ?KAVETT|WORTH)|EST(?: HILL|BURG)?|"
  "(?:RESTO|SA)N|NEY)|WLERTON|LLETT)|R(?:E(?:D(?:ERICKSBU?RG|ONIA)?|"
  "E(?:PORT|R)|SNO)|I(?:ENDSWOOD|ONA|SCO|TCH)|AN(?:K(?:STO|LI)N|CITA"
  "S)|UITVALE|OST)|L(?:O(?:RE(?:SVILL|NC)E|WER ?MOUND|YDADA|MOT)|AT("
  "?:ONIA)?|UVANNA|INT|YNN)|I(?:ELDTON|SCHER|FE)|E(?:NTRES|RRI)S|UL("
  "?:SHEAR|TON)|T SM HOUSTON)|E(?:L(?: (?:C(?:ENIZ|AMP)|INDI|LAG|PAS"
  ")O|M(?:ENDORF| MOTT|ATON|O)|YSIAN F(?:IE)?LDS|DORADO(?: AFS)?|(?:"
  "KHA|BE)RT|(?:ECTR|S)A|IASVILLE|LINGER|GIN)|A(?:ST(?: (?:TAWAKONI|"
  "BERNARD)|LAND|ON)|GLE (?:LAKE|PASS)|R(?:LY|TH))|N(?:C(?:HANTED OA"
  "KS?|IN(?:AL|O))|(?:OCH|NI)S|ERGY|LOE)|D(?:(?:MONSO|E)N|(?:RO|D)Y|"
  "GEWOOD|INBURG|COUCH|NA)|V(?:A(?:DALE|NT)|ERMAN)|S(?:TELLINE|CAPEE"
  "S)|U(?:STACE|LESS)|C(?:LETO|TOR)|(?:OL|R)A|TOILE|GYPT|MORY)|N(?:E"
  "(?:W(?: (?:B(?:(?:OSTO|ADE)N|RAUNFELS)|(?:WAVERL|CANE)Y|SUMMERF(?"
  ":IE)?LD|D(?:IANA|EAL)|LONDON|HOME|ULM)|CASTLE|ARK|TON)|(?:IMAN MA"
  "RCU|CHE)S|DERLAND|EDVILLE|VADA|MO)|O(?:R(?:T(?:H(?: (?:(?:BRAN|ZU"
  "L)CH|RICHLAND HILLS|HOUSTON)|FIELD)|ON)|MAN(?:GEE|NA)|DHEIM)|LAN("
  "?:VILLE)?|(?:VIC|M)E|TREES|CONA)|A(?:VA(?:L AIR STATION/ JRB|SOTA"
  ")|(?:COGDOCH|PL)ES|(?:TALI|D)A|S(?:/JRB|H)|ZARETH)|I(?:EDERWALD|X"
  "ON)| RICHLND HLS|URSERY)|K(?:I(?:NG(?:S(?:V(?:ILLE(?: NAVAL AIR S"
  "TATION)?|L(?: NAVAL|LE NAS))|BURY|LAND)|WOOD)|L(?:(?:DA|GO)RE|LEE"
  "N)|R(?:BY(?:VILLE)?|VIN))|E(?:N(?:N(?:E(?:DALE|Y)|ARD)|D(?:LETON|"
  "ALIA)|EDY|T)|R(?:R(?:VILLE|ICK)|ENS|MIT)|M(?:P(?:NER)?|AH)|LL(?:Y"
  " USA|ER)|E(?:CHI|NE))|N(?:I(?:CKERBOCKER|PPA)|O(?:X CITY|TT))|A(?"
  ":RN(?:ES CITY|ACK)|(?:MA|T)Y|UFMAN)|R(?:U(?:GERVILLE|M)|ESS)|O(?:"
  "(?:UNTZ|SS)E|PPERL)|L(?:ONDIKE|EIN)|URTEN|YLE)|O(?:L(?:D(?: (?:R("
  "?:IVER-WINFRE|VR-WNFR)E|GLORY|OCEAN)|EN)|M(?:OS PARK|ITO)|NEY|TON"
  ")|AK(?: (?:POINT|LEAF)|(?:LAN|WOO)D|HURST|VILLE|ALLA)|R(?:ANGE(?:"
  " GROVE|FIELD)?|E CITY|CHARD|LA)|(?:(?:KLAUNI|ILT)O| BRIE)N|D(?:E("
  "?:SSA|LL|M)|ONNELL)|(?:NALASK|MAH|ZON)A|V(?:ERTON|ILLA|ALO)|TT(?:"
  "INE|O)|YSTER CREEK|GLESBY)|V(?:A(?:L(?:LE(?:Y (?:SPRING|MILLS|VIE"
  "W)| DE ORO)|E(?:NTINE|RA))|N(?: (?:ALSTYNE|VLECK|HORN)|DER(?:BILT"
  "|POOL)|COURT)?)|I(?:LLAGE (?:OF THE H|M)ILLS|GO PARK|CTORIA|NTON|"
  "DOR)|E(?:R(?:(?:HALE|NO)N|IBEST|A)|ALMOOR|NUS|GA)|O(?:N ORMY|LENT"
  "E|TAW|CA|SS)|LG O THE HLS| A HOSPITAL)|J(?:O(?:NES(?: CREEK|VILLE"
  "|BORO|TOWN)|(?:URDANTO|AQUI)N|S(?:EPHINE|HUA)|HNSON CITY|INERVILL"
  "E)|A(?:CKS(?:ONVILLE|BORO)|MAICA BEACH|RRELL|SPER|YTON)|E(?:R(?:S"
  "EY V(?:ILLAGE|LG)|MYN)|FFERSON|WETT)|U(?:STI(?:CEBURG|N)|(?:NCTI|"
  "DS)ON))|I(?:N(?:D(?:IAN LAKE|USTRY)|G(?:LESIDE|RAM)|EZ)|R(?:E(?:D"
  "ELL|NE)|A(?:AN)?|VING)|O(?:WA PARK|LA)|TA(?:SCA|LY)|MPERIAL|VANHO"
  "E|DALOU|ZORO)|QU(?:I(?:N(?:TANA|LAN)|T(?:AQUE|MAN))|E(?:EN CITY|M"
  "ADO)|A(?:NAH|IL))|U(?:NIVERSAL CI?TY|MBARGER|HLAND|TOPIA|VALDE)|Y"
  "(?:O(?:RKTOWN|AKUM)|AN(?:CEY|TIS))|Z(?:A(?:VALL|PAT)A|EPHYR)))))$"
  ,
  /* -- UT -- UT -- UT -- UT -- UT -- UT -- UT -- UT -- UT -- UT -- */
  "(?:\\b)((?^:(?i:(?:S(?:A(?:N(?:TA(?: CLARA|QUIN)|DY)|L(?:T LAKE C"
  "I?TY|INA|EM)|RATOGA SP(?:RIN)?GS|INT GEORGE)|U(?:N(?:(?:NYSID|DAN"
  "C)E|SET)|GARVILLE|THERLAND|MMIT)|T(?:ANSBURY P(?:AR)?K| GEORGE|ER"
  "LING|OCKTON)|P(?:RING(?:(?:VIL|DA)LE| CITY)|ANISH FORK)|OUTH (?:("
  "?:JORDA|OGDE)N|SALT LAKE|WEBER)|N(?:OW(?:VILLE|BIRD)|YDERVILLE)|("
  "?: SALT LAK|YRACUS)E|(?:MITHFIEL|IGUR)D|C(?:OFIELD|IPIO)|EVIER|LC"
  "|SL)|M(?:O(?:N(?:T(?:EZUMA CR(?:EE)?K|ICELLO)|UMENT V(?:ALLE|L)Y|"
  "ROE|A)|UNT(?: (?:PLEASANT|CARMEL)|AIN (?:GREEN|HOME))|R(?:GAN|ONI"
  ")|DENA|AB)|A(?:R(?:RIOTT-SLATERVILLE CITY|YSVALE)|N(?:T(?:UA|I)|I"
  "LA)|PLETON|YFIELD|MMOTH|GNA)|I(?:L(?:LVILLE|FORD)|D(?:VALE|WAY)|N"
  "ERSVILLE)|E(?:XICAN HAT|ADOW|NDON)|T(?: PLEASANT|N GREEN)|S(?: CI"
  "TY|C)|URRAY|YTON)|C(?:O(?:TTONW(?:OOD(?: HEIGHTS(?: CITY)?)?|D HG"
  "TS)|(?:LLINS|PPER)TON|R(?:INNE|NISH)|(?:ALVILL|V)E)|E(?:NT(?:RAL("
  "?: V(?:ALLE|L)Y)?|ER(?:FIELD|VILLE))|DAR (?:(?:VALLE|CIT)Y|HILLS|"
  "FORT))|A(?:N(?:YON POINT|NONVILLE)|STLE (?:VALLEY|DALE)|CHE J(?:U"
  "NCTION|CT))|L(?:(?:A(?:RKST|WS)|INT)ON|E(?:ARFIEL|VELAN)D)|I(?:RC"
  "LEVILLE|SCO)|HESTER|ROYDON)|H(?:O(?:L(?:LADAY(?: C(?:OTTONWOO|TW)"
  "D)?|DEN)|NEYVILLE|OPER|WELL)|I(?:L(?:L A(?:IR FORCE BASE|FB)|DALE"
  ")|GHLAND|NCKLEY|TE)|A(?:LLS (?:CROSS|X)ING|N(?:KSVILLE|NA)|RRISVI"
  "LLE|TCH)|E(?:N(?:RIEVILLE|EFER)|BER CITY|RRIMAN|LPER)|U(?:NT(?:IN"
  "GTON|SVILLE)|RRICANE)|Y(?:DE PARK|RUM))|B(?:R(?:I(?:(?:AN HEA|DGE"
  "LAN)D|GH(?:AM CITY|TON))|YCE(?: C(?:ANYON(?: CITY)?|YN CTY))?|OOK"
  "SIDE)|E(?:A(?:R RIVER C(?:IT)?Y|VER)|N(?:JAMI|SO)N|RYL)|I(?:NGHAM"
  " C(?:ANYO|Y)N|G WATER|CKNELL)|L(?:U(?:FF(?:DALE)?|EBELL)|ANDING)|"
  "O(?:U(?:NTIFUL|LDER)|NANZA)|ULLFROG|ALLARD)|W(?:E(?:ST (?:VALLE(?"
  ":Y CIT)?Y|(?:JORDA|HAVE)N|BOUNTIFUL|POINT)|LL(?:INGTON|SVILLE)|ND"
  "OVER)|A(?:SHINGTON(?: T(?:ERRACE|R))?|L(?:LSBURG|ES)|NSHIP)|OOD(?"
  ":(?:LAND H(?:IL)?L|S CROS)S|RUFF)| (?:VALLEY CITY|BOUNTIFUL)|HITE"
  "(?: MESA|ROCKS)|ILLARD)|P(?:A(?:R(?:K (?:VALLE|CIT)Y|A(?:GONAH|DI"
  "SE)|(?:OWA|TOU)N)|NGUITCH|YSON)|L(?:EASANT (?:GR(?:OVE|V)|VIEW)|A"
  "IN CITY|YMOUTH)|R(?:OV(?:IDENCE|O)|ICE)|IN(?:E VALLEY|TURA)|E(?:N"
  "ROSE|RRY|OA)|ORTAGE)|R(?:I(?:VER(?:(?:DAL|SID)E| HEIGHTS|TON)|CH("
  "?:FIEL|MON)D)|O(?:CK(?:Y R(?:IDGE TO|DG T)WN|VILLE)|OSEVELT|Y)|ED"
  "(?: CANYON|MOND)|AND(?:LETT|OLPH)|USH VALLEY)|T(?:R(?:O(?:UT CREE"
  "K|PIC)|E(?:MO)?NTON|IDELL)|A(?:YLOR(?:SVILLE)?|BIONA|LMAGE)|O(?:("
  "?:QUERVIL|OE)LE|RREY)|H(?:ATCHER|OMPSON|ISTLE)|E(?:ASDALE|RRA)|IC"
  "ABOO)|F(?:A(?:R(?:MINGTON|R WEST)|IR(?:FIELD|VIEW)|YETTE)|R(?:UIT"
  "(?: HEIGHTS|LAND)|ANCIS|EMONT)|O(?:UNTAIN GR(?:EE)?N|RT DUCHESNE)"
  "|I(?:ELDING|LLMORE)|ERRON)|L(?:A(?:KE(?: PO(?:WELL|INT)|SIDE|TOWN"
  ")| (?:VERKIN|SAL)|POINT|YTON)|E(?:(?:(?:AMING|WIS)TO|VA)N|EDS|HI)"
  "|I(?:BERTY|NDON)|Y(?:NNDYL|MAN)|O(?:GAN|A))|G(?:R(?:EEN(?: RIVER|"
  "HAVEN|VILLE|WICH)|OUSE CREEK|ANTSVILLE)|AR(?:DEN CITY|RISON|LAND)"
  "|U(?:N(?:NISON|LOCK)|SHER)|LEN(?:DALE|WOOD)|ENOLA|OSHEN)|E(?:(?:A"
  "(?:GLE M(?:OUNTAI|T)|ST CARBO)|DE)N|L(?:(?:K RIDG|SINOR)E|BERTA|W"
  "OOD|MO)|N(?:TERPRISE|OCH)|(?:UREK|RD)A|SCALANTE|PHRAIM|MERY|CHO)|"
  "A(?:L(?:T(?:A(?:MONT)?|ON(?:AH)?)|PINE)|N(?:NABELLA|TIMONY|ETH)|M"
  "(?:ERICAN FORK|ALGA)|U(?:RORA|STIN)|PPLE VALLEY|DAMSVILLE|BRAHAM|"
  "XTELL)|D(?:U(?:C(?:K CR(?:EEK VILLAGE|K VLG)|HESNE)|TCH JOHN|GWAY"
  ")|E(?:ER (?:MOUNTAIN|VALLEY)|WEYVILLE|SERET|LTA)|AMMERON V(?:ALLE"
  "|L)Y|RAPER)|N(?:E(?:W(?: HARMONY|CASTLE|TON)|OLA|PHI)|ORTH (?:(?:"
  "LOGA|OGDE)N|SALT LAKE)| SALT LAKE|APLES)|K(?:A(?:N(?:A(?:RRAVILLE"
  "|B)|ESVILLE|OSH)|YSVILLE|MAS)|E(?:NILWORTH|ARNS)|OOSHAREM|INGSTON"
  ")|O(?:R(?:(?:ANGE|DER)VILLE|EM)|A(?:K(?: CIT|LE)Y|SIS)|GDEN|PHIR|"
  "URAY)|V(?:E(?:RN(?:AL|ON)|NICE|YO)|I(?:NEYARD|RGIN))|J(?:(?:UNCTI"
  "O|ENSE)N|OSEPH)|ZION N(?:ATIONA|T)L PARK|I(?:BAPAH|VINS)|UINTAH))"
  "))$"
  ,
  /* -- VA -- VA -- VA -- VA -- VA -- VA -- VA -- VA -- VA -- VA -- */
  "(?:\\b)((?^:(?i:(?:S(?:T(?:A(?:N(?:LEY(?:TOWN)?|ARDSVILLE)|FFORD("
  "?:SVI?LLE)?|R TANNERY|TE FARM|UNTON)|E(?:VENS(?:VILLE|BURG)|PHENS"
  "(?: CITY|ON)|ELES TAVE?RN|RLING)| (?:(?:STEPHN|DAVID)S CH|GEORGE)"
  "|ON(?:E(?: RIDGE|GA)|Y CREEK)|U(?:AR(?:TS DRAF)?T|DLEY)|RA(?:SBUR"
  "G|TFORD))|A(?:INT (?:(?:STEPHEN|DAVID)S CHURCH|CHARLES|PAUL)|N(?:"
  "D(?:Y (?:LEVEL|POINT|HOOK)|STON)|FORD)|L(?:(?:LIE MA|TVILL)E|UDA|"
  "EM)|X(?:IS|E))|H(?:E(?:N(?:ANDOAH(?: CAVERNS)?|DOAH CVRN)|RANDO|L"
  "BY)|A(?:(?:CKLEFORD|RP)S|D(?:WELL|OW)|WSVILLE)|I(?:PMAN|LOH)|ORTT"
  " GAP)|P(?:R(?:ING(?: GROVE|FIELD)|OUSES CORN(?:ER)?)|O(?:T(?:SYLV"
  "ANIA|TSWOOD)|UT SPRING)|E(?:RRYVILLE|EDWELL|NCER)|ARTA)|U(?:DLEY "
  "SP(?:RIN)?GS|(?:MERDUC|FFOL)K|THERL(?:AND|IN)|(?:PPL|RR)Y|LLY STA"
  "TION|S(?:SEX|AN)|GAR GROVE)|E(?:VE(?:N (?:(?:FOUNT(?:AI)?N|CORNER"
  ")S|MILE F(?:OR)?D)|RN)|A(?:LSTON|FORD|VIEW)|DLEY|LMA)|O(?:UTH(?: "
  "(?:NORFOLK|BOSTON|RIDING|HILL)|BRIDGE)|MER(?:VILLE|SET))|C(?:OTTS"
  "(?:VILLE|BURG)|H(?:UYLER|LEY))|W(?:O(?:RDS CREEK|OPE)|EET BRIAR)|"
  "I(?:NGERS GLEN|MPSONS)|KIP(?:PERS|WITH)|YRI(?:NG)?A|MITHFIELD|NEL"
  "L)|C(?:H(?:A(?:R(?:L(?:OTTE(?: C(?:OURT HOUSE| H)|SV(?:IL)?LE)|ES"
  " CITY)|ITY)|N(?:TILLY|CE)|SE CITY|MPLAIN|THAM)|E(?:S(?:TER(?:FIEL"
  "D| GAP)?|APEAKE)|RITON|CK)|I(?:NCOTEAGUE(?: ISLAND)?|LHOWIE)|URCH"
  "(?: (?:ROAD|VIEW)|VILLE)|RIST(?:IANSBU?RG|CHURCH))|A(?:R(?:R(?:OL"
  "LTON|SVILLE)|TERSVILLE|DINAL|SON|ET)|S(?:TLE(?:WOOD|TON)|ANOVA|CA"
  "DE)|P(?:E(?: CHARLES|VILLE)|RON)|L(?:LA(?:NDS|WAY|O)|VERTON)|T(?:"
  "HARPIN|AWBA|LETT)|UTHORNVILLE|VE SPRING|MPBELL|NA)|O(?:L(?:O(?:NI"
  "AL (?:H(?:EIGH|G)TS|B(?:EA)?CH)|GNE)|E(?:MAN FALLS|S POINT)|LINSV"
  "ILLE|UMBIA)|V(?:ESVILLE|INGTON)|B(?:BS CREEK|HAM)|U(?:RTLAND|NCIL"
  ")|N(?:AWAY|CORD)|(?:EBUR|RBI)N|PPER HILL|MMUNITY)|L(?:I(?:N(?:CH("
  "?:BURG|PORT|CO)|TWOOD)|F(?:TON(?: FORGE)?|FORD))|A(?:R(?:KSVILLE|"
  "EMONT)|UDVILLE)|E(?:AR BROOK|VELAND)|USTER SP(?:RIN)?GS|OVER(?:DA"
  "LE)?)|R(?:O(?:SS J(?:UNCTION|NCT)|Z(?:IER|ET)|CKETT)|I(?:GLERSVIL"
  "LE|PPLE CREEK|DERS|MORA|TZ)|(?:A(?:DDOCK|IGS)VILL|EW)E|YSTAL HILL"
  ")|E(?:NT(?:ER CROSS|REVILLE)|DAR BLUFF|RES)|U(?:L(?:PEPER|LEN)|MB"
  "ERLAND|NNINGHAM)|ISMONT)|B(?:R(?:O(?:AD(?:LANDS| RUN|FORD|WAY)|WN"
  "(?:SBURG|TOWN)|OK(?:NEAL|E)|DNAX)|A(?:N(?:DY STA(?:TION)?|CHVILLE"
  ")|MBLETON|CEY)|I(?:DGEWATER|GHTWOOD|STO[LW])|E(?:MO BLUFF|AKS)|U("
  "?:CETOW|INGTO)N)|E(?:L(?:L(?:E(?:V(?:IEW|UE)| HAVEN)|AMY)|SPRING)"
  "|N(?:T(?: MOUNTAIN|ONVILLE)| HUR|A)|A(?:VER(?:LETT|DAM)|LETON|UMO"
  "NT)|R(?:RYVILLE|GTON)|DFORD|E)|A(?:R(?:(?:BOUR|HAM)SVILLE|REN SP("
  "?:RIN)?GS)|S(?:(?:KERVILL|Y)E|SETT|TIAN)|ILEYS (?:CROSSROA|XR)DS|"
  "T(?:TERY PARK|ESVILLE)|N(?:CO|DY)|COVA|VON)|U(?:R(?:N(?:T CHIMNEY"
  "|SVILLE|LEYS)|KE(?:S GARDEN|VILLE)?|R HILL|GESS)|FFALO J(?:UNCTIO"
  "N|CT)|C(?:KINGHAM|HANAN)|ENA VISTA|MPASS)|O(?:(?:(?:HANN|ST)O|WLI"
  "NG GREE|ISSEVAI)N|Y(?:D(?: TAVER|TO)N|KINS|CE)|ONES(?: MILL|VILLE"
  ")|(?:N AI|LA)R)|L(?:A(?:CK(?:S(?:BURG|TONE)|RIDGE|WATER)|(?:IR|KE"
  ")S|ND)|UE(?: (?:GRASS|RIDGE)|FIELD|MONT)|OXOM)|I(?:G (?:STONE GAP"
  "|ISLAND|ROCK)|R(?:CHLEAF|DSNEST)|SHOP)|YBEE)|M(?:A(?:N(?:A(?:SSAS"
  "(?: PARK)?|KIN SABOT)|GOHICK|NBORO|QUIN)|R(?:ION(?:VILLE)?|TINSVI"
  "LLE|SHALL|KHAM|YUS)|S(?:S(?:IES MILL|ANUTTEN)|ON NECK|COT)|DISON("
  "?: (?:(?:HEIG)?HT|MILL)S)?|(?:PPSVIL|VISDA)LE|T(?:TAPONI|HEWS)|X("
  "?: MEADOWS|IE)|C(?:HIPONGO|ON)|URERTOWN|IDENS)|O(?:N(?:T(?:E(?:BE"
  "LLO|ZUMA|REY)|PELIER(?: STATION)?|ICELLO|CLAIR|FORD|ROSS|VALE)|ET"
  "A|ROE)|U(?:NT (?:(?:JACKS|VERN)ON|S(?:IDNEY|OLON)|CRAWFORD|WEATHE"
  "R|HOLLY)|TH(?: OF)? WILSON)|R(?:RISVILLE|ATTICO)|(?:DEST TOW|O)N|"
  "(?:BJAC|LLUS)K|S(?:ELE|B)Y)|I(?:D(?:DLE(?:B(?:ROOK|URG)|TOWN)|L(?"
  ":OTHIAN|AND))|L(?:L(?:ERS TAVE?RN|BORO|WOOD)|FORD|ES)|N(?:E(?: RU"
  "N|RAL)|T SPRING)|SSION HOME|TCHELLS)|E(?:R(?:R(?:Y POINT|IFIELD)|"
  "EDITHVILLE)|A(?:DOW(?:S(?: OF)? DAN|VIEW)|RS)|CHANICSVI?LLE|(?:ND"
  "OT|LF)A|HERRIN)|C(?: (?:C(?:LURE|OY)|GAHEYSVILLE|DOWELL|KENNEY|LE"
  "AN)|GAHEYSVILLE|LEAN)|NTPELIER STA|T CRAWFORD|USTOE)|W(?:A(?:R(?:"
  "(?:RENTO|DTOW)N|M SPRINGS|E NECK|FIELD|NER|SAW)|SH(?:INGTON(?:S B"
  "IRTHPLACE)?|GTNS BRHP)|L(?:LOPS IS(?:LAND)?|KERTON|TERS)|T(?:ER(?"
  ": VIEW|FORD)|TSVILLE)|KE(?:FIELD)?|CHAPREAGUE|YNESBORO|VERLY)|I(?"
  ":N(?:TERGR(?:EEN(?: RESORT)?|N RST)|(?:CHESTE|DSO)R|GINA|STON)|L("
  "?:LI(?:AMS(?:VILLE|BURG)|S(?: WHARF)?)|MINGTON|DWOOD|SONS)|COMICO"
  "(?: CHUR(?:CH)?)?|THAMS|RTZ|SE)|O(?:O(?:D(?:S(?: CR(?:OSS ROA|S R"
  ")DS|TOCK)|B(?:ERRY FOR(?:EST)?|RIDGE)|VILLE|FORD|LAWN)|LWINE)|LF("
  "?:TOWN|ORD))|E(?:ST (?:(?:SPRINGFIEL|EN)D|AUGUSTA|MCLEAN|POINT)|Y"
  "ERS CAVE|BER CITY|IRWOOD|EMS)|HIT(?:E(?: (?:P(?:LAINS|OST)|MARSH|"
  "STONE|HALL)|WOOD|TOP)|ACRE)|Y(?:LLIESBURG|THEVILLE)| SPRINGFIELD)"
  "|R(?:O(?:C(?:K(?:B(?:RIDGE BATHS|DGE BATH)|Y (?:MOUNT|GAP)|VILLE|"
  "FISH)|HELLE)|S(?:E(?: HILL|DALE|LAND)|SLYN)|(?:ANOK|W)E|LLINS FOR"
  "K|UND HILL)|E(?:D(?: (?:HOUSE|ASH|OAK)|WOOD|ART)|PUBLIC(?:AN GROV"
  "E|N GRV)|(?:CTORTOW|MINGTO)N|(?:EDVILL|LIANC)E|G(?:ENCY|INA)|S(?:"
  "CUE|TON)|VA)|I(?:C(?:H(?:MOND(?: INT AIRPORT)?| (?:INT AP|CREEK)|"
  "ARDSVILLE|LANDS)|E)|N(?:GGOLD|ER)|DGE(?:WAY)?|[LX]EYVILLE|PPLEMEA"
  "D|VERTON)|A(?:P(?:H(?:ANCK ACAD|INE)|PAHANNOCK ACADEMY|IDAN)|D(?:"
  "FORD|IANT)|CCOON FORD|NDOLPH|WLINGS|VEN)|U(?:TH(?:ER GLEN|VILLE)|"
  "RAL RETREAT|CKERSVILLE|STBURG|BY)|HOADESVILLE)|P(?:O(?:RT(?: (?:R"
  "(?:EPUBLIC|OYAL)|HAYWOOD)|SMOUTH)|(?:QUOSO|WHATA)N|TOMAC(?: FALLS"
  ")?|UND(?:ING MILL)?|CAHONTAS)|A(?:T(?:RICK SP(?:RIN)?GS|TERSON)|R"
  "(?:KSLEY|ROTT|TLOW|IS)|EONIAN SP(?:RIN)?GS|INT(?: BANK|ER)|LMYRA|"
  "MPLIN)|R(?:O(?:V(?:IDENCE FORGE|DENCE FRG)|SPECT)|INCE (?:W(?:ILL"
  "IA)?M|GEORGE)|ATTS)|E(?:N(?:N(?:INGTO?N GAP| LAIRD)|HOOK)|AR(?:IS"
  "BURG|Y)|TERSBURG|MBROKE)|I(?:L(?:GRIMS KNOB|OT)|NE(?:Y RIVER|RO)|"
  "TTSVILLE|MMIT)|U(?:(?:RCELLVILL|NGOTEAGU)E|LASKI)|L(?:EASANT V(?:"
  "ALLE|L)Y|AIN VIEW)|H(?:ILOMONT|ENIX))|L(?:A(?:KE(?: (?:OF(?: THE)"
  "? WOODS|FREDERICK|RIDGE)|SIDE)|N(?:E(?:VIEW|XA)|GLEY AFB|CASTER|S"
  "DOWNE)|(?:WRENCEVILL| CROSS|FAYETT)E|C(?:EY SPRING|KEY)|UREL FORK"
  "|DYSMITH|MBSBURG)|O(?:CUST(?: (?:(?:GROV|DAL)E|HILL)|VILLE)|V(?:E"
  "TTSVILLE|INGSTON)|W(?:ESVILLE| MOOR|RY)|R(?:ETTO|TON)|NG ISLAND|T"
  "TSBURG|UISA)|I(?:T(?:TLE PLYM(?:OU)?TH|HIA)|N(?:(?:COL|DE)N|VILLE"
  ")|G(?:HTFOOT|NUM)|VELY)|E(?:BANON(?: (?:CHUR)?CH)?|E(?: MONT|SBUR"
  "G)|(?:XINGT)?ON|WISETTA|NNIG)|YN(?:CH(?: STATION|BURG)|DHURST)|U("
  "?:NENBURG|RAY)|K FREDERICK)|F(?:O(?:R(?:T (?:B(?:LACKMORE|ELVOIR)"
  "|(?:A P HI|CHISWE)LL|M(?:ITCHELL|ONROE)|(?:DEFIANC|LE)E|(?:VALLE|"
  "STOR)Y|EUSTIS)|K(?: UNION|SVILLE)|EST|D)|STER(?: FALLS)?|NESWOOD)"
  "|A(?:IR(?:F(?:AX(?: STATION)?|IELD)|LAWN)|L(?:LS (?:CHURCH|MILLS)"
  "|MOUTH)|R(?:MVILLE|NHAM)|NCY GAP|BER)|R(?:E(?:E(?: UNIO|MA)N|DERI"
  "CKSBU?RG)|AN(?:K(?:TOW|LI)N|CONIA)|ONT ROYAL|IES)|I(?:(?:(?:NCAST"
  "|ELDA)L|F)E|SHERS(?: HILL|VILLE))|T (?:B(?:LACKMORE|ELVOIR)|MYER)"
  "|(?:X STATIO|ULKS RU)N|L(?:INT HILL|EET|OYD)|BI ACADEMY|ERRUM)|H("
  "?:A(?:R(?:T(?:FIEL|WOO)D|(?:BORTO|MA)N|DY(?:VILLE)?|RISONBURG)|Y("
  "?:(?:FIEL|WOO)D|NESVILLE|MARKET|ES|SI)|M(?:P(?:DEN SYDNEY|TON)|IL"
  "TON)|L(?:L(?:IEFOR|WOO)D|IFAX)|(?:DENSVILL|GU)E|CKS ?NECK|NOVER)|"
  "O(?:LLINS(?: C(?:OLLEGE|LG))?|W(?:ARDSVILLE|ERTONS)|R(?:NTOW|SEPE"
  ")N|T SPRINGS|PEWELL|NAKER|OD)|I(?:GH(?:LAND SP(?:RIN)?GS|TOWN)|L("
  "?:LS(?:VILLE|BORO)|TONS)|WASSEE|NTON)|U(?:D(?:DLESTON|GINS)|(?:ST"
  "L|M)E|R(?:LEY|T)|NTLY)|E(?:A(?:D WATERS|THSVILLE)|RNDON|NRY)|MPDE"
  "N SYDNEY)|N(?:E(?:W(?: (?:C(?:A(?:NTON|STLE)|HURCH)|(?:(?:POI|KE)"
  "N|MARKE)T|(?:BALTIMOR|HOP)E|RIVER)|(?:INGTO|BER|TOW)N|PORT(?: NEW"
  "S)?|COMB HALL|SOMS)|L(?:SON(?:IA)?|LYSFORD))|A(?:T(?:UR(?:AL BR(?"
  ":IDGE(?: STATION)?|G)|L BR STA)|HALIE)|V(?:AL (?:WEAPONS STATION|"
  "BASE)| WPNS STA)|S(?:SAWADOX|ONS)|R(?:ROWS|UNA)|XERA)|O(?:R(?:T(?"
  ":H(?: (?:SPRINGFIELD|TAZEWELL|GARDEN))?|ON(?:SVILLE)?)|FOLK|WOOD|"
  "GE|A)|KESVILLE|TTOWAY)|(?:I(?:CKELSVILL|ND)|UTTSVILL)E| (?:SPRING"
  "FIELD|TAZEWELL))|A(?:L(?:L(?:EGHANY|ISONIA)|(?:EXANDRI|BERT)A|(?:"
  "UM RIDG|DI)E|T(?:AVISTA|ON)|FONSO)|M(?:(?:ELIA C(?:OURT HOU|T H)S"
  "|ISSVILL|ONAT)E|PTHILL|HERST|MON)|R(?:(?:VONI|COL|OD)A|[LR]INGTON"
  "|ARAT|K)|U(?:GUSTA SPR(?:IN)?GS|STINVILLE)|S(?:H(?:BURN|LAND)|SAW"
  "OMAN)|PP(?:ALACHIA|OMATTOX)|N(?:NANDALE|DOVER)|(?:BINGD|[FX]T)ON|"
  "C(?:HILLES|COMAC)|T(?:LANTIC|KINS)|DVANCE MILLS|YL(?:ETT|OR))|D(?"
  ":A(?:(?:RLINGT(?:ON HEIG|N )HT|MASCU|BNEY)S|V(?:IS WHARF|ENPORT)|"
  "LE(?: CITY|VILLE)|(?:HLGRE|YTO)N|N(?:VILL|T)E)|U(?:N(?:N(?: LORIN"
  "G|SVILLE)|GANNON|DAS)|(?:MFRI|LL)ES|(?:BLI|TTO)N|FFIELD|GSPUR)|R("
  "?:A(?:KES BRANCH|PER)|Y(?: FORK|DEN)|EWRYVILLE)|E(?:L(?:TAVILL|AP"
  "LAN)E|ERFIELD|NDRON|WITT)|O(?:(?:E HI|SWE)LL|(?:LPHI|RA)N|GUE)|I("
  "?:SPUTANTA|NWIDDIE|LLWYN|GGS)|YKE)|G(?:R(?:E(?:EN(?:B(?:ACKVIL?LE"
  "|USH)|W(?:OOD|AY)|VILLE| BAY)|AT FALLS|TNA)|A(?:VES MILL|FTON)|IM"
  "STEAD|OTTOES|UNDY)|L(?:A(?:D(?:E (?:SPRING|HILL)|STONE|YS)|SGOW)|"
  "OU(?:CESTER(?: P(?:OIN)?T)?| POINT)|EN (?:WILTO|ALLE|LY)N)|O(?:O("
  "?:D(?:VIEW|E)|CHLAND)|LD(?:BOND|VEIN)|R(?:DONSVILL)?E|SHEN)|A(?:("
  "?:RRISON|INES)VILLE|TE CITY|SBURG|LAX)|UM SPRING|WYNN)|T(?:A(?:N("
  "?:NERSVILLE|GIER)|PPAHANNOCK|MWORTH|ZEWELL|SLEY|BB)|R(?:O(?:UT(?:"
  "VIL|DA)LE|Y)|I(?:ANGLE|PLET)|EVILIANS|AMMEL)|H(?:ORN(?:BURG|HILL)"
  "|E PLAINS|AXTON)|(?:EMPERANCEV(?:IL)?|URBEVIL)LE|O(?:MS BROOK|WNS"
  "END|PPING|ANO)|I(?:MBER(?:VILL|LAK)E|PTOP)|Y(?:E RIVER|RO)|WYMANS"
  " MILL)|E(?:L(?:K(?: (?:GARDEN|CREEK)|WOOD|TON)|(?:LIST|BER)ON)|A("
  "?:ST(?: STONE GAP|VILLE)|RLYSVILLE|GLE ROCK)|(?:V(?:ERGREE|INGTO)"
  "|GGLESTO)N|D(?:WARDSVILLE|INBURG)|(?:HEAR|SMON)T|M(?:PORIA|ORY)|T"
  "(?:TRICK|LAN)|X(?:ETER|MORE)| STONE GAP|NGLESIDE|BONY|WING)|K(?:I"
  "(?:N(?:G(?: (?:(?:AND QUEEN COURT HOUS|GEORG)E|QUEEN CH|WILLIAM)|"
  "STOWNE)|SALE)|LMARNOCK)|E(?:(?:N(?:TS STOR|BRIDG)|YSVILL|OKE)E|E("
  "?:N(?: MOUNTAIN|E)|ZLETOWN|LING)|SWICK|LLER))|J(?:E(?:FFERSON(?: "
  "M(?:ANO|N)R|TON)|WELL (?:VALLEY|RIDGE)|NKINS BR(?:IDGE|G)|TERSVIL"
  "LE|RSEY)|A(?:M(?:ES(?:(?: STOR|VILL)E|TOWN)|AICA)|RRATT|VA)|O(?:R"
  "DAN MINES|NESVILLE))|V(?:I(?:NT(?: HILL F(?:ARMS|RM)|ON)|RGI(?:NI"
  "A B(?:EA)?CH|LINA)|E(?:WTOWN|NNA)|LLA(?:MONT|GE)|CTORIA)|E(?:R(?:"
  "NON HILL|ONA)|S(?:UVIUS|TA)|NIA)|A(?:LENTINES|NSANT)|OLNEY)|O(?:R"
  "(?:(?:DINAR|ISKAN)Y|KNEY SPRI?NGS|ANGE|LEAN)|AK(?: (?:H[AI]LL|GRO"
  "VE)|PARK|WOOD|TON)|N(?:ANCOCK|EMO|LEY)|CCOQUAN|ILVILLE|LDHAMS|PHE"
  "LIA|YSTER)|I(?:N(?:D(?:IAN (?:VALLEY|NECK)|EPENDENCE)|GRAM)|R(?:O"
  "N(?: GATE|TO)|VINGTON)|V(?:ANHOE|OR|Y)|SLE OF WIGHT)|U(?:N(?:I(?:"
  "V(?:ERSITY(?: OF RICHMOND)?| OF RICH)|ON(?: HALL|VILLE))|O)|PPERV"
  "ILLE|RBANNA)|QU(?:I(?:N(?:QUE|TON|BY)|CKSBURG)|ANTICO)|Y(?:A(?:(?"
  ":NCEY MILL|RD)S|LE)|ORKTOWN)|Z(?:A(?:CATA|NONI)|UNI)))))$"
  ,
  /* -- VI -- VI -- VI -- VI -- VI -- VI -- VI -- VI -- VI -- VI -- */
  "(?:\\b)((?^:(?i:(?:C(?:H(?:ARLOTTE AMA(?:LIE)?|RISTIANSTED)|RUZ B"
  "AY)|ST (?:THOMAS|CROIX|JOHN)|FREDERIKSTED|KINGSHILL))))$"
  ,
  /* -- VT -- VT -- VT -- VT -- VT -- VT -- VT -- VT -- VT -- VT -- */
  "(?:\\b)((?^:(?i:(?:W(?:E(?:ST(?: (?:B(?:R(?:A(?:TTLEBORO|INTREE)|"
  "OOKFIELD)|ERLIN|URKE)|D(?:UMMERSTON|ANVILLE|OVER)|C(?:HARLESTON|O"
  "RNWALL)|HA(?:RTFORD|LIFAX|VEN)|W(?:ARDSBORO|INDSOR)|TO(?:WNSHEND|"
  "PSHAM)|RU(?:TLAND|PERT)|ARLINGTO?N|MARLBORO|FAIRLEE|NEWBURY|GLOVE"
  "R|PAWLET)|M(?:INSTER(?: (?:W(?:EST)?|STATION))?|NSTR STA)|F(?:IEL"
  "|OR)D|ON)|(?:BSTERVILL|YBRIDG)E|LLS(?: RIVER)?)|A(?:TER(?:BURY(?:"
  " C(?:ENTE|T)R)?|VILLE|FORD)|(?:LLINGFOR|ITSFIEL)D|R(?:DSBORO|REN)"
  "|SHINGTON)| (?:BR(?:A(?:TTLEBORO|INTREE)|OOKFIELD)|(?:CHARLE|DUMM"
  "ER)STON|TOWNSHEND|WARDSBORO)|I(?:L(?:LI(?:AMS(?:VILLE|TOWN)|STON)"
  "|MINGTON|DER)|N(?:D(?:HAM|SOR)|OOSKI))|HIT(?:E RIV(?:ER JUNCTION|"
  " JCT)|ING(?:HAM)?)|O(?:OD(?:STOCK|BURY|FORD)|RCESTER|LCOTT))|S(?:"
  "T(?: (?:J(?:HNSBRY CT|OHNSBURY)|ALBANS BAY|GEORGE)|RA(?:TTON(?: M"
  "(?:(?:OUNTAI|T)N|NT))?|FFORD)|A(?:RKSBORO|MFORD)|O(?:CKBRIDG|W)E)"
  "|OUTH (?:R(?:OYALTON|EADING|YEGATE)|(?:LONDONDER|DUXBU)RY|B(?:URL"
  "INGTON|ARRE)|CHITTENDEN|STRAFFORD|WOODSTOCK|NEWFANE|POMFRET|HERO)"
  "|A(?:INT (?:JOHNSBURY(?: CENTER)?|ALBANS(?: BAY)?|GEORGE)|XTONS R"
  "IVER|LISBURY|NDGATE)|H(?:E(?:L(?:DON(?: SP(?:RIN)?GS)?|BURNE)|FFI"
  "ELD)|A(?:FTSBURY|RON)|REWSBURY|OREHAM)| (?:(?:(?:BURLING|ROYAL)TO"
  "|CHITTENDE)N|LONDONDERRY|STRAFFORD|WOODSTOCK)|U(?:(?:GARBUSH V(?:"
  "ALLE|L)|DBUR)Y|NDERLAND|TTON)|MUG(?:GLERS NO|LRS N)TCH|PRINGFIELD"
  "|EARSBURG|WANTON)|E(?:AST (?:C(?:O(?:NCORD|RINTH)|HARLESTON|ALAIS"
  ")|(?:B(?:(?:ERKSHI|AR)R|URK)|ORANG)E|(?:(?:WALLING|THET)FOR|FAIRF"
  "IEL)D|(?:SAINT JOHNSBUR|POULTNE)Y|M(?:IDDLEBURY|ONTPELIER)|R(?:AN"
  "DOLPH|YEGATE)|HA(?:RDWICK|VEN)|DO(?:RSET|VER)|ARLINGTON)| (?:(?:("
  "?:CHARLE|DUMMER)S|ARLING)TON|(?:WALLINGFOR|FAIRFIEL)D|M(?:IDDLEBU"
  "RY|ONTPELIER)|ST JOHNSBRY|BERKSHIRE)|SSEX(?: J(?:UNCTION|CT))?|NO"
  "SBURG F(?:AL)?LS|DEN(?: MILLS)?|LMORE)|N(?:OR(?:T(?:H(?: (?:C(?:("
  "?:HITTENDE|LARENDO)N|ONCORD)|H(?:YDE PARK|ARTLAND|ERO)|M(?:ONTPEL"
  "IER|IDDLESEX)|PO(?:MFRET|WNAL)|T(?:HETFORD|ROY)|FERRISBURGH|SPRIN"
  "GFIELD|BENNINGTON)|F(?:IELD(?: F(?:ALLS|L))?|LD FLS))|ON)|WICH)| "
  "(?:(?:C(?:HITTENDE|LARENDO)|BENNINGTO)N|(?:SPRINGFIEL|THETFOR)D|M"
  "(?:ONTPELIER|IDDLESEX)|H(?:YDE PARK|ARTLAND)|FERRISBURGH)|EW(?:PO"
  "RT(?: C(?:ENTE|T)R)?| HAVEN|BURY|FANE))|B(?:R(?:I(?:D(?:GEW(?:ATE"
  "R(?: CORNERS)?|TR COR)|PORT)|STOL)|O(?:WN(?:INGTON|SVILLE)|OK(?:F"
  "IELD|LINE))|A(?:TTLEBORO|INTREE|DFORD|NDON)|DGEWTR CORS|EAD LOAF|"
  "UNSWICK)|E(?:L(?:VIDERE C(?:ENTE|T)R|LOWS FALLS|MONT)|E(?:CHER FA"
  "LLS|BE PLAIN)|(?:N(?:NINGT|S)O|RLI)N|THEL)|A(?:R(?:N(?:ARD|ET)|TO"
  "N|RE)|KERSFIELD|LTIMORE)|O(?:LTON VALLEY|NDVILLE|MOSEEN)|LOOMFIEL"
  "D|URLINGTON)|M(?:O(?:N(?:T(?:GOM(?:ERY(?: CENTER)?|RY CTR)|PELIER"
  ")|KTON)|R(?:RIS(?:VILLE|TOWN)|GAN(?: CTR)?|ETOWN)|UNT (?:HOLLY|TA"
  "BOR|SNOW)|SCOW)|I(?:DDLE(?:T(?:OWN SPRINGS|WN SPG)|SEX(?: C(?:ENT"
  "E|T)R)?|BURY)|LTON)|A(?:NCHEST(?:(?:ER CENT)?E|R CT)R|R(?:SHFIELD"
  "|LBORO)|IDSTONE)|C INDOE F(?:AL)?LS|ENDON)|C(?:A(?:MBRIDGE(?:PORT"
  ")?|(?:STLETO|NAA)N|VENDISH|LAIS|BOT)|H(?:E(?:STER(?: DEPOT)?|LSEA"
  ")|ITTENDEN|ARLOTTE)|O(?:R(?:NWALL|INTH)|LCHESTER|VENTRY|NCORD)|RA"
  "FTSB(?:URY(?: C(?:OMMON|M))?|RY CMN)|LAREND(?:ON SPRIN|N SP)GS|(?"
  ":ENTE|T)R RUTLAND|UTTINGSVILLE)|H(?:A(?:R(?:T(?:LAND(?: (?:FOUR C"
  "ORNE|CO)RS)?|FORD)|DWICK)|NCOCK)|I(?:GHGATE (?:SPR(?:INGS|G)|C(?:"
  "ENTE|T)R)|NESBURG)|YDE(?: PARK|VILLE)|UNTINGTON)|G(?:R(?:A(?:N(?:"
  "(?:(?:ITE)?VIL|D IS)LE|BY)|FTON)|EENSB(?:ORO(?: BEND)?|RO BND)|NS"
  "BORO BEND|OTON)|UIL(?:DHALL|FORD)|(?:ILMA|OSHE)N|AYSVILLE|LOVER)|"
  "L(?:O(?:WE(?:R WATERFORD|LL)|NDONDERRY)|YNDON(?: CENTER|VILLE)?|A"
  "(?:KE ELMOR|NDGROV)E|E(?:ICESTER|MINGTON)|U(?:NENBURG|DLOW)|WR WA"
  "TERFORD|INCOLN)|P(?:E(?:R(?:KINSVILLE|U)|ACHAM)|O(?:ST MILLS|ULTN"
  "EY|WNAL)|A(?:SSUMPSIC|NTON|WLET)|L(?:AINFIELD|YMOUTH)|ROCTOR(?:SV"
  "ILLE)?|ITTSF(?:IEL|OR)D|UTNEY)|R(?:I(?:CH(?:FOR|MON)D|(?:VER|P)TO"
  "N)|ANDOLPH(?: C(?:ENTE|T)R)?|O(?:CHESTER|XBURY)|EAD(?:SBORO|ING)|"
  "U(?:TLAND|PERT)|YEGATE)|J(?:E(?:RICHO(?: C(?:ENTE|T)R)?|FFERSONVI"
  "?LLE)|A(?:Y(?: PEAK)?|CKSONVILLE|MAICA)|O(?:NESVILLE|HNSON))|T(?:"
  "HETFORD(?: C(?:ENTE|T)R)?|(?:AFTSVILL|UNBRIDG)E|O(?:WNSHEND|PSHAM"
  ")|INMOUTH|ROY)|F(?:AIR(?:F(?:IELD|AX)| HAVEN|LEE)|(?:OREST DAL|LO"
  "RENC)E|ERRISBURGH?|RANKLIN)|A(?:D(?:AMANT|DISON)|LB(?:URGH?|ANY)|"
  "RLINGTON|SCUTNEY|NDOVER|VERILL|THENS)|D(?:AN(?:VILLE|BY)|ERBY(?: "
  "LINE)?|UMMERSTON|ORSET)|I(?:SL(?:E LA MOTTE|AND POND)|RASBURG)|V("
  "?:ER(?:GENNES|SHIRE|NON)|ICTORY)|UNDERHILL(?: C(?:ENTE|T)R)?|OR(?"
  ":LEANS|ANGE|WELL)|KILLINGTON|QUECHEE))))$"
  ,
  /* -- WA -- WA -- WA -- WA -- WA -- WA -- WA -- WA -- WA -- WA -- */
  "(?:\\b)((?^:(?i:(?:S(?:O(?:UTH(?: (?:P(?:ARK VILLAG|RAIRI)E|C(?:L"
  "E ELUM|OLBY)|BEND|HILL)|WORTH)|AP LAKE)|E(?:A(?:T(?:TLE|AC)|HURST"
  "|BECK|VIEW)|DRO WOOLLEY|VEN BAYS|QUIM|KIU|LAH)|T(?:E(?:(?:VENSO|H"
  "EKI)N|ILACOOM|PTOE)|A(?:R(?:BUCK|TUP)|NWOOD)|RATFORD)|P(?:OKANE(?"
  ": V(?:ALLE|L)Y)?|R(?:INGDAL|AGU)E|AN(?:AWAY|GLE))|U(?:N(?:SET HIL"
  "L|NYSIDE)|M(?:NER|AS)|QUAMISH|LTAN)|K(?:OK(?:OMISH NATION)?|AMOKA"
  "WA|YKOMISH)|ILV(?:ER(?:(?:DAL|LAK)E| CREEK)|ANA)|NO(?:QUALMIE(?: "
  "P(?:AS)?S)?|HOMISH)|A(?:INT JOHN|MMAMISH|LKUM|TSOP)|H(?:AW ISLAND"
  "|ORELINE|ELTON)| (?:CLE ELUM|PARK VLG))|C(?:O(?:L(?:(?:LEGE PLAC|"
  "VILL)E|BERT|FAX|TON)|U(?:LEE (?:CITY|DAM)|PEVILLE|GAR)|N(?:C(?:ON"
  "ULLY|RETE)|NELL|WAY)|PALIS (?:(?:CROSS|X)ING|BEACH)|SMOPOLIS|VING"
  "TON|WICHE|OK)|A(?:R(?:L(?:SBORG|TON)|(?:NATI|S)ON|BONADO|ROLLS)|M"
  "(?:A(?:NO ISLAND|S)|P MURRAY)|S(?:TLE ROCK|HMERE)|PITAL ONE|THLAM"
  "ET)|H(?:E(?:LAN(?: FALLS)?|HALIS|WELAH|NEY)|I(?:MACUM|NOOK)|ATTAR"
  "OY)|L(?:A(?:(?:RKS|Y)TON|LLAM BAY)|E(?:ARLAKE| ELUM)|YDE HILL|INT"
  "ON)|I(?:TY OF SPOKANE VALLEY|NEBAR)|U(?:R(?:LEW|TIS)|S(?:ICK|TER)"
  ")|ENT(?:ERVILLE|RALIA)|TY SPOK VAL|RESTON)|M(?:A(?:R(?:BLEMOUNT|Y"
  "SVILLE|SHALL|CUS|LIN)|N(?:S(?:FIELD|ON)|CHESTER)|L(?:O(?:NE|TT)?|"
  "AGA|DEN)|PLE (?:VALLEY|FALLS)|DIGAN HOSP(?:ITAL)?|T(?:LOCK|TAWA)|"
  "BTON|ZAMA)|O(?:UNT(?:LAKE TER(?:RACE)?| VERNON)|N(?:TESANO|ITOR|R"
  "OE)|S(?:ES LAKE|SYROCK)|CLIPS|HLER|RTON|XEE)|E(?:T(?:ALINE(?: F(?"
  ":AL)?LS)?|HOW)|(?:RCER ISLAN|A)D|DI(?:CAL LAKE|NA)|NLO|SA)|I(?:L("
  "?:L(?: CREEK|WOOD)|TON)|NERAL|CA)|C(?:C(?:HORD AFB|LEARY)|KENNA)|"
  "UKILTEO)|B(?:E(?:L(?:L(?:INGHAM|EVUE)|FAIR|MONT)|A(?:UX ARTS|VER)"
  "|N(?:TON CITY|GE)|VERLY|THEL)|R(?:I(?:DGEPORT|NNON|ER)|E(?:MERTON"
  "|WSTER)|USH PRAIRIE|OWNSTOWN)|U(?:R(?:L(?:INGTON|EY)|(?:IE|TO)N|B"
  "ANK)|C(?:KLEY|ODA)|ENA)|A(?:INBRIDGE IS(?:LAND)?|TTLE GROUND|Y CE"
  "NTER|RING)|LA(?:KELY IS(?:LAND)?|CK DIAMOND|INE)|O(?:NNEY LAKE|TH"
  "ELL|YDS|W)|I(?:CKLETO|NGE)N)|L(?:A(?:KE(?: (?:(?:STEVEN|TAPP)S|FO"
  "REST PARK)|WOOD|BAY)| (?:C(?:ENT|ONN)ER|GRANDE|PUSH)|C(?:ROSSE|EY"
  ")|MON[AT]|NGLEY|URIER|TAH)|O(?:NG(?:(?: BEA|BRAN)CH|MIRE|VIEW)|O("
  "?:N LAKE|MIS)|PEZ ISLAND|WDEN)|I(?:N(?:COLN|D)|BERTY LAKE|TTLEROC"
  "K|LLIWAUP)|Y(?:N(?:NWOOD|DEN)|MAN|LE)|E(?:AVENWORTH|BAM)|K FOREST"
  " PK|UMMI ISLAND)|W(?:A(?:L(?:L(?:A WAL|U)LA|DRON)|SH(?:OUGAL|TUCN"
  "A)|U(?:COND|N)A|TERVILLE|HKIACUS|ITSBURG|VERLY|PATO|RDEN)|I(?:L(?"
  ":SON CREEK|KESON|BUR)|N(?:THROP|LOCK)|SHRAM)|HI(?:DBEY ISLAND NAV"
  "AL AIR|TE S(?:ALMO|WA)N)|E(?:ST(?: RICHLAND|PORT)|LLPINIT|NATCHEE"
  ")|OOD(?:INVILLE|LAND|WAY))|P(?:A(?:R(?:K(?:LAND|ER)|ADISE INN)|C("
  "?:IFIC(?: BEACH)?|KWOOD)|L(?:ISADES|OUSE)|TER(?:SON|OS)|SCO)|O(?:"
  "RT (?:(?:TOWNSEN|ORCHAR)D|ANGELES|HADLOCK|GAMBLE|LUDLOW)|INT ROBE"
  "RTS|MEROY|ULSBO)|R(?:ES(?:COTT|TON)|OSSER)|E(?:SHASTIN| ELL)|U(?:"
  "YALLUP|LLMAN)|L(?:YMOUTH|AZA))|R(?:O(?:C(?:K(?:(?: ISLAN|FOR)D|PO"
  "RT)|HE(?: HARBO|STE)R)|(?:(?:YAL CIT)?|LLINGBA)Y|S(?:ALIA|BURG|LY"
  "N)|OSEVELT|NALD)|E(?:D(?:MOND|ONDO)|(?:ARDA|NTO)N|PUBLIC|TSIL)|I("
  "?:(?:TZVILL|VERSID)E|C(?:HLAND|E)|DGEFIELD)|A(?:(?:VENSDA|ND)LE|I"
  "NIER|YMOND)|YDERWOOD|USTON)|N(?:O(?:R(?:TH(?: (?:B(?:ONNEVILLE|EN"
  "D)|LAKEWOOD)|PORT)|MANDY PARK|DLAND)|OKSACK)|E(?:W(?:(?:MAN LAK|C"
  "ASTL)E|PORT)|AH BAY|SPELEM|ILTON)|A(?:S(?: WHIDBEY|ELLE)|HCOTTA|P"
  "AVINE|CHES)| (?:BONNEVILLE|LAKEWOOD)|INE MILE F(?:AL)?LS)|E(?:A(?"
  ":ST(?: (?:WENATCHEE|OLYMPIA)|SOUND|ON)|TONVILLE)|L(?:M(?:ER CITY|"
  "A)|ECTRIC CITY|LENSBURG|TOPIA|BE|K)|N(?:(?:DICOT|TIA)T|UMCLAW)|D("
  "?:GEWOOD|MONDS|WALL)|V(?:ER(?:ETT|SON)|ANS)|(?:SPANOL|PHRAT)A| WE"
  "NATCHEE|THEL)|G(?:R(?:A(?:N(?:D(?: COULEE|VIEW)|ITE FALLS|GER)|Y("
  "?:S RIVER|LAND)|PEVIEW|HAM)|EEN(?:ACRES|BANK))|O(?:LD(?:ENDALE| B"
  "AR)|OSE PRAIRIE|RST)|LE(?:N(?:WOOD|OMA)|ED)|I(?:G HARBOR|FFORD)|A"
  "(?:RFIELD|LVIN)|EORGE)|A(?:N(?:DERSON IS(?:LAND)?|A(?:CORTES|TONE"
  "))|L(?:(?:GON|MIR)A|(?:BIO|LY)N)|R(?:DENVOIR|LINGTON|IEL)|(?:BERD"
  "EE|PPLETO|UBUR)N|IRWAY H(?:EIGH|G)TS|M(?:ANDA PARK|BOY)|S(?:HFORD"
  "|OTIN)|D(?:DY|NA)|CME)|O(?:AK(?:(?:ESDA|VIL)LE| HARBOR|BROOK)|R(?"
  ":O(?:VILLE|NDO)|IENT|TING|CAS)|(?:L(?:YMPI|ALL|G)|NALASK|DESS)A|C"
  "EAN (?:SHORES|CITY|PARK)|T(?:IS ORCHARDS|HELLO)|(?:UTLOO|MA)K|YST"
  "ERVILLE|KANOGAN)|F(?:A(?:IR(?:CHILD A(?:IR FORCE BASE|FB)|FIELD)|"
  "RMINGTON|LL CITY)|O(?:R(?:(?:T LEWI|K)S|D)|UR LAKES|X ISLAND)|R(?"
  ":(?:UIT|EE)LAND|IDAY HARBOR)|E(?:DERAL WAY|RNDALE)|I(?:RCREST|FE)"
  "|T LEWIS)|T(?:O(?:U(?:CHET|TLE)|PPENISH|KELAND|NASKET|LEDO)|U(?:M"
  "(?:WATER|TUM)|KWILA|LALIP)|R(?:I CITIES|OUT LAKE|ACYTON)|A(?:H(?:"
  "OLAH|UYA)|COMA)|E(?:NINO|KOA)|HOR(?:NTON|P)|IETON|WISP)|D(?:E(?:E"
  "R (?:MEADOWS|HARBOR|PARK)|S(?:ERT AIRE| MOINES)|MING)|A(?:(?:LLES"
  "|VEN)PORT|(?:RRING|Y)TON|NVILLE)|I(?:AMOND|XIE)|U(?:PONT|VALL)|RY"
  "DEN|OTY)|H(?:A(?:R(?:R(?:INGTON|AH)|TLINE)|(?:MIL|T)TON|NSVILLE|Y"
  ")|U(?:NT(?:S POINT|ERS)|MPTULIPS|SUM)|O(?:O(?:DSPORT|PER)|QUIAM|B"
  "ART|ME)|EISSON)|K(?:E(?:N(?:NEWICK|MORE|T)|L(?:LER|SO)|TTLE FALLS"
  "|YPORT)|I(?:NGSTON|RKLAND|TTITAS)|A(?:HLOTUS|POWSIN|LAMA)|LICKITA"
  "T)|V(?:A(?:N(?:COUVER|TAGE)|LLEY(?:FORD)?|(?:SHO|UGH)N|DER)|ERADA"
  "LE)|U(?:N(?:I(?:VERSITY PL(?:ACE)?|ON(?: GAP|TOWN)?)|DERWOOD)|SK)"
  "|I(?:N(?:D(?:IANOLA|EX)|CHELIUM)|SSAQUAH|LWACO|ONE)|Y(?:A(?:(?:RR"
  "OW POIN|COL)T|KIMA)|ELM)|QUI(?:N(?:AULT|CY)|LCENE)|ZILLAH|JOYCE))"
  "))$"
  ,
  /* -- WI -- WI -- WI -- WI -- WI -- WI -- WI -- WI -- WI -- WI -- */
  "(?:\\b)((?^:(?i:(?:S(?:T(?:O(?:CK(?:BRIDGE|HOLM)|NE LAKE|UGHTON|D"
  "DARD)|E(?:VENS POINT|TSONVILLE|UBEN)|A(?:R (?:PRAIRI|LAK)E|NLEY)|"
  " (?:CROIX FL|FRANCI)S|UR(?:GEON BAY|TEVANT)|R(?:ATFORD|UM)|I(?:TZ"
  "ER|LES))|A(?:INT (?:C(?:ROIX FALLS|LOUD)|FRANCIS|GERMAIN|NAZIANZ)"
  "|L(?:V(?:ATORIAN CENTE|TRIAN CT)R|EM)|N(?:D CREEK|BORN)|UK(?: CIT"
  "Y|VILLE)|X(?:EVILLE|ON)|RONA|YNER)|H(?:E(?:BOYGAN(?: F(?:AL)?LS)?"
  "|L(?:L LAKE|DON)|RWOOD)|A(?:WANO|RON)|ULLSBURG|OREWOOD|IOCTON)|O("
  "?:UTH (?:(?:MILWAUKE|RANG|WAYN)E|BYRON)|L(?:DIERS? GROVE|ON SPRIN"
  "GS)|MERS(?:ET)?|BIESKI)|P(?:RING(?: (?:VALLEY|GREEN)|BROOK|FIELD)"
  "|(?:ENC|OON)ER|ARTA)|U(?:(?:MMIT LAK|N PRAIRI)E|LLIVAN|PERIOR|AMI"
  "CO|RING|SSEX)|I(?:LVER (?:CLIFF|LAKE)|STER BAY|NSINAWA|REN)|E(?:X"
  "TONVILLE|YMOUR|NECA)|C(?:ANDINAVIA|HOFIELD)| MILWAUKEE|LINGER)|B("
  "?:A(?:R(?:NE(?:VELD|S)|RON(?:ETT)?|ABOO)|Y(?: (?:CITY|VIEW)|FIELD"
  "|SIDE)|ILEYS H(?:ARBO|B)R|L(?:SAM LAKE|DWIN)|N(?:CROFT|GOR)|BCOCK"
  "|SSETT|GLEY)|R(?:O(?:WN(?:SVILLE| DEER|TOWN)|OK(?:FIELD|LYN|S)|DH"
  "EAD|KAW)|I(?:LL(?:ION)?|GGSVILLE|STOL)|AN(?:TWOOD|DON|CH)|U(?:SSE"
  "LS|[CL]E)|YANT)|E(?:L(?:(?:LEV(?:ILL|U)|DENVILL)E|(?:MON|OI)T|GIU"
  "M)|N(?:(?:NET|OI)T|ET LAKE|TON)|A(?:VER(?: DAM)?|R CREEK)|(?:ETOW"
  "|RLI)N)|L(?:A(?:CK (?:RIVER FALLS|CREEK|EARTH)|NCHARDVI?LLE|IR)|O"
  "OM(?:INGTON| CITY|ER)|UE (?:MOUNDS|RIVER)|K RIVER FLS|ENKER)|U(?:"
  "T(?:TE(?: DES MORTS|RNUT)|LER)|R(?:LINGTON|NETT)|FFALO CITY)|O(?:"
  "ULDER J(?:UNCTION|CT)|(?:SCOB|NDU)EL|Y(?:CEVILLE|D)|WLER)|I(?:G ("
  "?:FALLS|BEND)|R(?:NAM|CH)WOOD)|TE DES MORTS|YRON)|M(?:A(?:R(?:I(?"
  ":NETTE|BEL|ON)|SH(?:FIELD|ALL)|(?:ATHO|KESA)N|QUETTE|ENGO)|N(?:IT"
  "OW(?:ISH WATERS|SH WTR|OC)|CHESTER|AWA)|(?:ZOMANI|YVILL|LON)E|(?:"
  "(?:DI)?S|UST)ON|T(?:TOON|HER)|PLE(?:WOOD)?|IDEN ROCK)|O(?:N(?:T(?"
  ":(?:IC)?ELLO|FORT|REAL)|DOVI|ICO|ONA|ROE)|UNT(?: (?:HO(?:REB|PE)|"
  "STERLING|CALVARY)|AIN)|(?:RRISONVILL|SINE)E|DENA|QUAH)|I(?:L(?:L("
  "?:(?:STO|TOW)N|ADORE)|(?:TO|A)N|WAUKEE)|N(?:O(?:CQUA|NG)|ERAL POI"
  "NT|DORO)|DDLE(?: INLET|TON)|SHICOT|KANA)|E(?:N(?:OMON(?:EE F(?:AL"
  ")?LS|IE)|ASHA)|R(?:RI(?:LL(?:AN)?|MAC)|CER|TON)|D(?:FORD|INA)|L(?"
  ":ROSE|LEN)|QUON)|U(?:S(?:CODA|KEGO)|KWONAGO)|C (?:NAUGHTON|FARLAN"
  "D)|T STERLING)|W(?:A(?:U(?:(?:[BZ]EK|WATOS|TOM)A|(?:MAND|NAK)EE|K"
  "(?:ESHA|AU)|P(?:ACA|UN)|SAU(?:KEE)?)|S(?:H(?:INGTON IS(?:LAND)?|B"
  "URN)|COTT)|TER(?:FORD|TOWN|LOO)|L(?:WORTH|DO|ES)|RRENS|BENO)|I(?:"
  "N(?:NE(?:CONNE|BAGO)|D(?: LAKE|SOR)|(?:CHES)?TER)|L(?:L(?:IAMS BA"
  "Y|ARD)|D ROSE|[ST]ON|MOT)|SC(?:ONSIN)? (?:RAPID|DELL)S|T(?:TENBER"
  "G|HEE))|E(?:ST(?: (?:MILWAUKEE|ALLIS|SALEM|BEND|LIMA)|B(?:ORO|Y)|"
  "FIELD|PORT|ON)|Y(?:ERHAEUSER|AUWEGA)|B(?:B LAKE|STER)|NTWORTH)|O("
  "?:OD(?:(?:FOR|LAN)D|VILLE|WORTH|RUFF|MAN)|NEWOC)|H(?:ITE(?:FISH B"
  "AY| LAKE|WATER|HALL|LAW)|EELER)|Y(?:EVILLE|OCENA)| MILWAUKEE|RIGH"
  "TSTOWN)|C(?:A(?:M(?:P(?: (?:DOUGLAS|LAKE)|BELLSPORT)|BRI(?:DGE|A)"
  "|ERON)|S(?:C(?:ADE|O)|SVILLE|HTON)|T(?:A(?:RACT|WBA)|O)|(?:LEDON|"
  "ZENOV)IA|(?:ROLIN|BL)E|DOTT|NTON|VOUR)|O(?:L(?:(?:UMBU|LIN)S|EMAN"
  "|GATE|FAX|OMA|BY)|M(?:BINED LO?CKS|STOCK)|(?:TTAGE GROV|CHRAN)E|("
  "?:ON VALLE|UDERA)Y|RN(?:UCOPIA|ELL)|N(?:OVER|RATH)|BB)|L(?:A(?:M "
  "(?:FALLS|LAKE)|YTON)|E(?:AR LAKE|VELAND)|INTON(?:VILLE)?|YMAN)|H("
  "?:I(?:PPEWA F(?:AL)?LS|L(?:TON|I))|E(?:LSEA|TEK)|ASEBURG)|U(?:(?:"
  "BA CIT|DAH)Y|S(?:HING|TER)|MBERLAND|RTISS|TLER)|E(?:DAR(?: GROVE|"
  "BURG)|NTURIA|CIL)|R(?:OSS PLAINS|ANDON|IVITZ))|P(?:O(?:RT(?: (?:W"
  "(?:ASHINGTON|ING)|EDWARDS)|ERFIELD|AGE)|Y(?: SIPPI|NETTE)|T(?:OSI"
  "|TER)|WERS LAKE|PLAR|SKIN|UND)|R(?:AIRIE (?:DU (?:CHIEN|SAC)|FARM"
  ")|E(?:S(?:QUE ISLE|COTT)|NTICE)|(?:T WASHINGT|INCETO)N| DU (?:CHI"
  "EN|SAC))|L(?:A(?:IN(?:FIELD)?|TTEVILLE)|EASANT PR(?:AIRIE)?|UM CI"
  "TY|YMOUTH|OVER)|E(?:(?:L(?:ICAN|L) LAK|WAUKE|MBIN|NC)E|(?:ARSO|PI"
  ")N|SHTIGO)|A(?:(?:TCH GROV|CKWAUKE)E|R(?:DEEVILLE|K FALLS)|LMYRA)"
  "|I(?:CKE(?:REL|TT)|GEON FALLS|NE RIVER|TTSVILLE)|H(?:(?:ILLI|EL)P"
  "S|LOX)|UL(?:CIFER|ASKI))|H(?:A(?:R(?:T(?:FOR|LAN)D|SHAW)|N(?:NIBA"
  "L|COCK|OVER)|ZEL(?: GREEN|HURST)|(?:GER CIT|TLE)Y|W(?:THORNE|KINS"
  ")|M(?:BURG|MOND)|LES CORNERS|(?:UG|V)EN|YWARD)|O(?:L(?:(?:LANDAL|"
  "COMB)E|MEN)|R(?:TONVILLE|ICON)|WARD(?:S GROVE)?|NEY CREEK|ULTON|B"
  "ART)|I(?:L(?:L(?:S(?:BORO|DALE)|POINT)|BERT|ES)|GH(?: ?BRIDGE|LAN"
  "D)|NGHAM|XTON)|E(?:AFFORD J(?:UNCTION|CT)|R(?:BSTER|TEL)|LENVILLE"
  "|WITT)|U(?:ST(?:ISFORD|LER)|BERTUS|MBIRD|DSON|RLEY))|L(?:A(?:KE(?"
  ": (?:(?:NEBAGAM|DELT)ON|TOMAHAWK|GENEVA|MILLS)|WOOD)| (?:CROSS|PO"
  "INT|FARG|VALL)E|N(?:D O LAKES|CASTER|NON)|C DU FLAMB(?:EA)?U|DYSM"
  "ITH|RSEN|ONA)|I(?:(?:(?:VINGST|SB)O|NDE)N|TTLE (?:SUAMICO|CHUTE)|"
  "ME RIDGE|LY)|O(?:N(?:E ROCK|G LAKE)|(?:RETT|MIR)A|(?:WEL|YA)L|GAN"
  "VILLE|DI)|Y(?:N(?:DON STA(?:TION)?|XVILLE)|ONS)|E(?:(?:OPOL|W)IS|"
  "BANON|NA)|U(?:XEMBURG|BLIN|CK)|K NEBAGAMON|TL SUAMICO)|A(?:R(?:(?"
  ":G(?:ONN|YL)|BOR VITA)E|MSTRONG CR(?:EE)?K|K(?:ANSAW|DALE)|(?:LIN"
  "GTO|PI)N|(?:CADI|EN)A)|L(?:M(?:A(?: CENTER)?|ENA|OND)|L(?:ENTON|O"
  "UEZ)|(?:TOON|GOM)A|BANY|VIN)|M(?:HERST(?: J(?:UNCTION|CT))?|BERG|"
  "ERY)|SH(?:(?:WAUBENO|IPPU)N|LAND)|U(?:BURNDALE|GUSTA)|B(?:BOTSFOR"
  "D|RAMS)|THE(?:LSTANE|NS)|(?:PPLE|F)TON|N(?:TIGO|IWA)|V(?:ALON|OCA"
  ")|D(?:AMS|ELL))|G(?:R(?:E(?:EN(?: (?:(?:VALLE|BA)Y|LAKE)|(?:FIEL|"
  "WOO)D|(?:VIL|DA)LE|BUSH|LEAF)|SHAM)|A(?:N(?:D (?:CHUTE|MARSH|VIEW"
  ")|T(?:SBURG|ON))|FTON|TIOT))|L(?:E(?:N(?: (?:FLORA|HAVEN)|WOOD CI"
  "TY|BEULAH|DALE)|ASON)|IDDEN)|E(?:N(?:OA(?: CITY)?|ESEE DEPOT)|RMA"
  "NTOWN)|A(?:L(?:ESVILLE|LOWAY)|YS MILLS)|IL(?:MA(?:NTO)?N|LETT|E)|"
  "O(?:(?:ODMA|RDO)N|THAM)|URNEY)|R(?:I(?:C(?:H(?:LAND C(?:ENTE|T)R|"
  "FIELD)|E LAKE)|VER (?:FA|HI)LLS|DGE(?:LAND|WAY)|(?:B LAK|NGL)E|O("
  "?: CREEK)?|PON)|O(?:C(?:K(?: (?:SPRING|FALL)S|(?:FIEL|LAN)D)|HEST"
  "ER)|S(?:ENDALE|HOLT)|THSCHILD|YALTON|BERTS)|E(?:E(?:DS(?:VILLE|BU"
  "RG)|SEVILLE)|AD(?:FIELD|STOWN)|DGRANITE|WEY)|A(?:NDO(?:M LAKE|LPH"
  ")|DISSON|CINE)|U(?:BICON|DOLPH)|HINELANDER)|F(?:O(?:R(?:EST(?: J("
  "?:UNCTION|CT)|VILLE)|T (?:ATKINSON|MCCOY))|X(?: (?:POINT|LAKE)|BO"
  "RO)|N(?:D DU LAC|TANA)|UNTAIN CITY|OTVILLE)|R(?:AN(?:K(?:SVILLE|L"
  "IN)|CIS CREEK)|E(?:D(?:ERIC|ONIA)|EDOM|MONT)|IE(?:NDSHIP|SLAND))|"
  "A(?:LL (?:CREEK|RIVER)|IR(?:CHILD|WATER))|E(?:N(?:(?:NIMOR|C)E|WO"
  "OD)|RRYVILLE)|I(?:SH CREEK|TCHBURG|FIELD)|LORENCE)|N(?:E(?:W(?: ("
  "?:(?:(?:HOLSTE|BERL)I|L(?:ISB|OND)O|FRANKE|AUBUR)N|RICHMOND|MUNST"
  "ER|GLARUS|POST)|BURG|ALD|TON)|L(?:SON(?:VILLE)?|MA)|(?:CED|EN)AH|"
  "O(?:PIT|SHO)|ILLSVILLE|SHKORO|KOOSA)|OR(?:TH(?: (?:F(?:OND DU LAC"
  "|REEDOM)|(?:PRAIRI|LAK)E|WOODS BEACH)|FIELD)|WALK)| (?:FOND DU LA"
  "C|WOODS BEACH)|A(?:SHOTAH|VARINO)|I(?:AGARA|CHOLS))|E(?:L(?:K(?:H"
  "(?:ART LAKE|ORN)| MOUND)|L(?:ISON BAY|SWORTH)|M(?: GROVE|WOOD)|D("
  "?:ORADO|ERON)|AND|CHO|EVA|ROY|TON)|A(?:ST(?: (?:ELLSWORTH|TROY)|M"
  "AN)|U (?:CLAIR|GALL)E|GLE(?: RIVER)?)|D(?:G(?:E(?:WATER|RTON)|AR)"
  "|MUND|EN)|(?:GG HARB|NDEAV)OR|M(?:BARRASS|ERALD)| ELLSWORTH|VANSV"
  "ILLE|PHRAIM|TTRICK|XELAND|UREKA)|D(?:E(?:L(?:A(?:FIELD|VAN)|LWOOD"
  "|TA)|ER(?:(?: PAR|BROO)K|FIELD)| (?:FOREST|PERE|SOTO)|NMARK|RONDA"
  ")|O(?:(?:YLESTOW|USMA)N|WN(?:SVILLE|ING)|DG(?:EVILL)?E|RCHESTER)|"
  "A(?:R(?:LINGTO|IE)N|L(?:LAS|TON|E)|N(?:BURY|E)|IRYLAND)|R(?:UMMON"
  "D|ESSER)|U(?:NBAR|RAND)|ICKEYVILLE)|T(?:H(?:IENSVILLE|REE LAKES|E"
  "RESA|ORP)|I(?:SCH MILLS|GERTON|LLEDA|PLER)|R(?:E(?:MPEALEAU|VOR|G"
  "O)|IPOLI)|O(?:MAH(?:AWK)?|WNSEND|NY)|U(?:NNEL CITY|RTLE LAKE)|W(?"
  ":IN LAKE|O RIVER)S|AY(?:CHEEDAH|LOR))|O(?:CON(?:TO(?: FALLS)?|OMO"
  "WOC)|N(?:(?:ALASK|EID)A|TARIO)|AK(?: CREEK|FIELD|DALE)|S(?:CEOLA|"
  "HKOSH|SEO)|R(?:FORDVILLE|EGON)|G(?:DENSBURG|EMA)|KAUCHEE|OSTBURG|"
  "DANAH|JIBWA|XFORD|MRO|WEN)|K(?:E(?:N(?:DALL|OSHA|NAN)|WA(?:SKUM|U"
  "NEE)|LLNERSVILLE|MPSTER|SHENA)|I(?:NG(?:STON)?|EL(?:ER)?|MBERLY)|"
  "A(?:NSASVILLE|UKAUNA)|N(?:OWLES|APP)|OHLER|RAKOW)|J(?:U(?:N(?:CTI"
  "ON CITY|EAU)|MP RIVER|DA)|A(?:NESVILLE|CKSON)|OHNSON CREEK|EFFERS"
  "ON|IM FALLS)|I(?:R(?:ON (?:RI(?:DGE|VER)|BELT)|MA)|N(?:DEPENDENCE"
  "|GRAM)|(?:XONI|OL)A)|V(?:I(?:(?:ROQU|OL)A|CTORY)|E(?:R(?:NON|ONA)"
  "|SPER)|A(?:N DYNE|LDERS))|U(?:N(?:I(?:ON (?:CENTER|GROVE)|TY)|DER"
  "HILL)|PSON)|Y(?:ELLOW LAKE|UBA)|Z(?:ACHOW|ENDA)))))$"
  ,
  /* -- WV -- WV -- WV -- WV -- WV -- WV -- WV -- WV -- WV -- WV -- */
  "(?:\\b)((?^:(?i:(?:S(?:T(?:O(?:(?:UTS MILL|LLING)S|N(?:Y BOTTOM|E"
  "WOOD))|A(?:N(?:DING STONE|AFORD)|TTS MILLS|R CITY)|R(?:ANGE CREEK"
  "|EETER)|(?:EPHENSO|UMPTOW)N|I(?:CKNEY|RRAT)|NDG STONE)|A(?:N(?:D("
  "?: (?:RIDGE|FORK)|(?:YVILL|STON)E)|OMA)|INT (?:(?:ALBAN|MARY)S|GE"
  "ORGE)|L(?:T(?: ROCK|WELL)|EM)|(?:R(?:AH AN|TO)|XO)N|(?:ULSVILL|BI"
  "N)E|M BLACK)|H(?:E(?:N(?:ANDOAH JUNCTION|DOAH JCT)|(?:PHERDSTOW|R"
  "MA)N)|O(?:RT (?:CREEK|GAP)|ALS|CK)|A(?:(?:RPLE|NK)S|DY SPRING)|I("
  "?:(?:RLE|VEL)Y|NNSTON)|REWSBURY)|P(?:R(?:I(?:NG(?: (?:VALLEY|DALE"
  "|HILL)|FIELD)|GG)|AGUE)|E(?:LT|NC)ER|URLOCKVILLE|ANISHBURG)|U(?:M"
  "(?:M(?:ER(?:SVILL|LE)E|IT POINT)|ERCO)|(?:PERI|RVEY)OR|GAR GROVE|"
  "NDIAL|TTON)|O(?:M(?:MERVILLE FO|ERVLLE F)RK|UTH(?: CHARLESTON|SID"
  "E)|PHIA|D)|I(?:(?:S(?:TERS|SON)VILL|NKS GROV)E|M(?:PS)?ON|AS)|W(?"
  ":I(?:T(?:CHBACK|ZER)|SS)|EET(?: SPRINGS|LAND))|E(?:NECA ROCKS|CON"
  "DCREEK|LBYVILLE|EBERT|TH)|M(?:ITH(?:FIELD|VILLE|BURG|ERS)|OOT)|LA"
  "(?:(?:B |TY)FORK|NESVILLE)|C(?:OTT DEPOT|ARBRO|HERR)|K(?:YGUSTY|E"
  "LTON)|(?:NOWSHO|QUIR)E| CHARLESTON|YLVESTER)|B(?:E(?:L(?:L(?:(?:E"
  "VILL)?E|BURN|WOOD)|INGTON|GIUM|MONT|VA)|R(?:KELEY SP(?:RIN)?GS|WI"
  "ND|GOO|EA)|N(?:S RUN|TREE|WOOD)|E(?:CH BOTTOM|SON)|A(?:RDS FORK|V"
  "ER)|TH(?:LEHEM|ANY)|CK(?:WITH|LEY)|VERLY)|R(?:A(?:N(?:D(?:ONVILL|"
  "YWIN)E|CHLAND)|D(?:SHAW|LEY)|MWELL)|U(?:CETON M(?:IL)?LS|SHY FORK"
  "|NO)|O(?:WN(?:SVILLE|TON)|HARD|OKS)|E(?:(?:EDE|NTO)N|TZ)|I(?:DGEP"
  "ORT|STOL))|A(?:R(?:R(?:ACKVILLE|ETT)|T(?:LEY|OW)|BOURSVILLE|NABUS"
  ")|L(?:D(?: KNOB|WIN)|L(?:ENGEE|ARD))|N(?:DYTOWN|CROFT)|KER(?:TON)"
  "?|ISDEN|XTER|YARD)|L(?:A(?:CK(?:BERRY CITY|SVILLE)|NDVILLE|IR)|UE"
  "(?: (?:CREEK|GOOSE|JAY)|FIELD|WELL)|O(?:OM(?:INGROSE|ERY)|UNT)|CK"
  "BERRY CTY)|I(?:G (?:C(?:HIMNEY|REEK)|S(?:PRINGS|ANDY)|OTTER|BEND|"
  "RUN)|(?:NGHA)?M|RCH RIVER|CKMORE)|U(?:R(?:N(?:(?:T HOUS|SVILL)E|W"
  "ELL)|(?:LING)?TON)|CK(?:HANNON|EYE)|NKER HILL|FFALO|D)|O(?:O(?:ME"
  "R|TH)|(?:MON|L)T|RDERLAND|B WHITE|WDEN|GGS|ZOO))|C(?:O(?:AL(?: (?"
  ":MOUNTAIN|CITY)|DALE|WOOD|TON)|R(?:[AE]|IN(?:NE|TH)|L(?:ISS|EY)|T"
  "ON)|L(?:DWATER CREEK|LIERS|CORD|FAX)|(?:TT(?:AGEVIL)?L|OL RIDG)E|"
  "(?:[PW]E|BUR)N|VE(?: GAP|L)|UNTRY CLUB|XS MILLS|MFORT|STA)|A(?:M("
  "?:DEN(?: ON G(?:AULE|L)Y)?|P CREEK|ERON)|N(?:AAN VALLEY|EBRAKE|NE"
  "LTON|VAS)|P(?:ON (?:SPRINGS|BRIDGE)|ELS)|R(?:(?:OLIN|ETT)A|BON)|S"
  "(?:S(?:VILLE)?|CADE)|BIN(?: CREEK|S)|L(?:DWELL|VIN)|IRO)|H(?:A(?:"
  "R(?:L(?:TON H(?:EIGH|G)TS|ES(?: TOW|TO)N)|MCO)|P(?:MANVILLE|EL)|("
  "?:TTARO|UNCE)Y)|E(?:RRY RUN|STER)|LOE)|R(?:A(?:IG(?:SVILL|MOOR)E|"
  "W(?:FORD|LEY)|B ORCHARD)|O(?:SS LANES|WN HILL)|(?:ICH|ES)TON|UM(?"
  ":PLER)?)|L(?:E(?:AR (?:CREE|FOR)K|NDENIN|VELAND|M)|I(?:F(?:FTOP|T"
  "ON)|NTONVILLE|O)|A(?:RKSBURG|Y)|OTHIER)|E(?:NT(?:ER POINT|RALIA|U"
  "RY)|DAR(?: GROV|VILL)E|REDO)|U(?:(?:LLODE|RTI)N|CUMBER|ZZART|NARD"
  ")|(?:IRCLEVILL|YCLON)E)|M(?:A(?:R(?:TINSBURG|FRANCE|LINTON|IANNA|"
  "MET)|(?:(?:XWELT|DIS)O|SO(?:NTOW)?)N|T(?:H(?:ENY|IAS)|EWAN|OAKA)|"
  "Y(?:S(?:VILLE|EL)|BEURY)|C(?: ARTHUR|FARLAN)|N(?:NINGTON|HEIM)?|P"
  "LE(?: LAKE|WOOD)|B(?:SCOTT|EN|IE)|L(?:LORY|DEN)|H(?:ONE|AN)|IDSVI"
  "LLE|MMOTH)|O(?:UN(?:T(?: (?:C(?:ARBON|LARE)|(?:OLIV|HOP)E|(?:ALT|"
  "NEB)O|LOOKOUT|STORM|ZION|GAY)|AIN)|DSVILLE)|N(?:T(?:(?:ERVILL|ROS"
  ")E|C(?:ALM|OAL)|ANA MINES|GOMERY)|AVILLE|ONGAH)|R(?:GANTOWN|RISVA"
  "LE)|ATSVILLE|OREFIELD|HAWK|YERS|ZART)|I(?:N(?:E(?:HAHA SPG|RAL WE"
  "LL)S|N(?:EHAHA SPRINGS|ORA)|DEN|GO)|L(?:L(?: (?:CREEK|POINT)|(?:S"
  "TON|VILL)E|WOOD)|TON|AM)|D(?:DLE(?:BOURNE|WAY)|KIFF|WAY)|AMI)|E(?"
  ":AD(?:O(?:W(?: (?:B(?:RIDGE|LUFF)|CREEK)|BROOK)|R))?|DLEY|TZ)|C(?"
  ": (?:CO(?:NNELL|MAS)|DOWELL|GRAWS)|(?:MECHE|ALPI)N|WHORTER)|U(?:R"
  "RAYSVILLE|LLENS|NDAY)|YR(?:TLE|A))|W(?:I(?:L(?:L(?:IAMS(?:(?:TOW|"
  "O)N|BURG)|OW (?:ISLA|BE)ND)|S(?:ON(?:BURG|DALE)?|IE)|EY(?: FORD|V"
  "ILLE)|KINSON|DCAT|BUR|COE)|N(?:D(?:SOR (?:HEIG)?HTS|ING GULF)|IFR"
  "EDE|FIELD|ONA)|TCHER|DEN|CK)|H(?:IT(?:E(?: (?:SULPHUR SPRINGS|HAL"
  "L|DAY|OAK)|SVILLE|HALL)|M(?:AN|ER)|TAKER|BY)|T S(?:ULPHUR (?:SPG)"
  "?|PHR SPG)S|AR(?:NCLIFFE|TON)|EELING)|A(?:L(?:KER(?:SVILLE)?|L(?:"
  "BACK|ACE)|TON)|R(?:(?:DENSVILL|RIORMIN)E|WOOD)?|(?:Y(?:SID|N)|ITE"
  "VILL)E|(?:SHINGTO|DESTOW)N|VERLY|NA)|E(?:ST(?: (?:L(?:IBERTY|OGAN"
  ")|(?:HAMLI|UNIO)N|COLUMBIA|MILFORD)|O(?:VER|N))|BSTER SP(?:RIN)?G"
  "S|L(?:LSBURG|CH)|IRTON|NDEL)|O(?:LF(?: (?:SUMMIT|PEN)|CREEK|E)|O("
  "?:LLY BUGGER|DVILLE)|RTH(?:INGTON)?)|Y(?:OMING|ATT|MER|CO)|RISTON"
  ")|P(?:E(?:T(?:ERS(?:BURG|TOWN)|ROLEUM|TUS)|N(?:(?:CE SPRING|TRES)"
  "S|NSBORO)|(?:YTON|OR)A|ACH CREEK|CKS MILL|MBERTON|RKINS)|A(?:R(?:"
  "KERSBURG|COAL|SONS)|TTERSON CR(?:EE)?K|(?:YNE|CK)SVILLE|LE(?:STIN"
  "E|RMO)|GE(?:TON)?|DEN CITY|NTHER|W PAW|X)|I(?:N(?:E(?: (?:BLUFF|G"
  "ROVE)|Y VIEW|VILLE)|CH)|CK(?:AWAY|ENS)|EDMONT|PESTEM|GEON)|R(?:I("
  "?:NCE(?:WICK|TON)?|CHARD)|O(?:C(?:IOUS|TOR)|SPERITY)|E(?:MI|NT)ER"
  "|ATT)|O(?:INT(?: PLEASANT|S)|W(?:ELLTO|HATA)N|RTERS FALLS|ND GAP|"
  "CA|OL)|U(?:R(?:GITSVILL|SGLOV)E|LLMAN)|L(?:EASANT V(?:ALLE|L)|IN)"
  "Y|T PLEASANT|HILIPPI)|G(?:R(?:E(?:EN(?: (?:S(?:ULPHUR SPRINGS|PRI"
  "NG)|VALLEY|BANK)|VILLE|WOOD)|AT CACAPON)|A(?:N(?:T(?:SVILLE| TOWN"
  ")|VILLE)|SSY M(?:EADO|D)WS|FTON)|I(?:MMS L(?:ANDIN|ND)G|FFITHSV(?"
  ":IL)?LE)|N SPHR SPGS)|L(?:EN(?: (?:(?:(?:MORG|JE)A|EASTO)N|F(?:ER"
  "RIS|ORK)|DA(?:NIEL|LE)|ROGERS|WHITE)|HAYES|VILLE|GARY|WOOD|DON)?|"
  "A(?:D(?:E SPRINGS|Y)|SGOW|CE))|A(?:L(?:L(?:(?:IPOLIS FERR|OWA)Y|A"
  "GHER)|IPOLIS FRY)|ULEY (?:BRIDGE|MILLS)|R(?:RISON|Y)|(?:SSAWA)?Y|"
  "NDEEVILLE|P MILLS)|I(?:L(?:B(?:ERT|OA)|MER)|VEN)|E(?:RRARDSTOWN|N"
  "OA|M)|OR(?:MANIA|DON)|HENT|YPSY)|L(?:A(?:N(?:D(?:ES STA(?:TION)?|"
  "VILLE)|SING|ARK|HAM)|(?:HMANSVILL|VALETT)E|K(?:(?:E RIDG)?E|IN)|U"
  "REL (?:VALLEY|PARK)|SHMEET|YLAND|WTON)|O(?:C(?:K(?:BRIDGE|NEY)|HG"
  "ELLY)|ST (?:C(?:REEK|ITY)|RIVER)|O(?:NEYVILLE|KOUT)|N(?:GACRE|DON"
  ")|R(?:ENTZ|ADO)|(?:VER|GA)N|BATA)|E(?:S(?:(?:AG|LI)E|TER)|T(?:TER"
  " GAP|ART)|(?:IVAS| RO)Y|(?:CKI|NOR)E|E(?:WOOD|T)|FT HAND|WISBURG|"
  "RONA|VELS|HEW|ON)|I(?:TTLE(?: (?:BIRCH|FALLS)|TON)|M(?:ESTONE H(?"
  ":IL)?L|A)|N(?:D(?:SIDE|EN)|N)|LLY PARK|VERPOOL|ZEMORES|BERTY)|Y(?"
  ":N(?:NCAMP|CO)|BURN)|U(?:MBERPORT|NDALE))|H(?:A(?:R(?:M(?:ONY(?: "
  "GROVE)?|AN)|PER(?:S FERRY)?|RIS(?:VILLE|ON)|T(?:FORD|S)|VEY)|(?:M"
  "(?:BLETO|PDE|LI)|ZEL(?:GREE|TO)|LLTOW)N|N(?:SFORD|COCK|DLEY|OVER)"
  "|Y(?:MON|WOO)D|CKER VALLEY|STINGS|VACO)|E(?:N(?:D(?:ERSON|RICKS)|"
  "LAWSON|SLEY)|R(?:N(?:SHAW|DON)|OLD)|L(?:VETIA|EN)|DGESVILLE|MPHIL"
  "L|PZIBAH|ATERS|WETT)|I(?:L(?:TON V(?:ILLAGE|LG)|L(?:SBORO|TOP))|G"
  "H(?: VIEW|LAND)|N(?:TON|ES)|AWATHA|CO)|U(?:(?:TTONSVILL|RRICAN)E|"
  "GHES(?: RIVER|TON)|N(?:TINGTON|DRED))|O(?:R(?:SE SHOE RU?N|NER)|("
  "?:METOW|LDE)N|PEMONT))|R(?:O(?:CK(?: (?:C(?:A(?:STL|V)E|REEK)|VIE"
  "W)|PORT)?|S(?:E(?:DALE|MONT)|SMORE)|B(?:ERTSBURG|INETTE|SON)|(?:N"
  "CEVERT|ANOK)E|M(?:ANCE|NEY)|DERFIELD|WLESBURG)|A(?:VEN(?:CLIFF|SW"
  "OOD)|C(?:HEL|INE)|M(?:AGE|SEY)|N(?:GER|SON)|(?:YSA|W)L|INELLE|GLA"
  "ND|LEIGH|DNOR)|E(?:D(?: (?:JACKET|CREEK|HOUSE)|STAR)|(?:YNOLDSVIL"
  "L|PLET)E|ED(?:SVILLE|Y)|ADER|NICK)|I(?:[GO]|DGE(?:(?:LE|WA)Y|VIEW"
  ")|VE(?:SVILLE|RTON)|P(?:LEY|PON)|CHWOOD|FFLE)|U(?:SSELVILLE|PERT|"
  "NA)|HODELL)|F(?:R(?:A(?:N(?:K(?:FORD|LIN)|CIS MINE)|ZIERS B(?:OTT"
  "O|T)M|METOWN)|E(?:NCH(?: CREEK|TON)|E(?:PORT|MAN))|I(?:ARS HILL|E"
  "NDLY))|O(?:R(?:T (?:S(?:EYBERT|PRING)|(?:ASHB|GA)Y|NEAL)|RESTER C"
  "(?:ENTE|T)R|EST HILL)|L(?:LANSBEE|SOM|A)|UR STATES|STER)|A(?:LL(?"
  ":ING (?:W(?:ATE|T)RS|ROCK)|S MILL)|IR(?:DALE|MONT|VIEW|LEA)|YETTE"
  "VILLE|RMINGTON|NROCK)|L(?:AT(?:WOODS| TOP)|O(?:WER|E)|EMINGTON)|I"
  "(?:VE FORKS|LBERT|SHER)|E(?:RRELLSBURG|NWICK)|BI)|A(?:L(?:L(?:EN "
  "J(?:UNCTION|CT)|OY)|UM (?:BRIDGE|CREEK)|(?:(?:GO)?M|T)A|EXANDER|B"
  "RIGHT|DERSON|KOL|VY)|R(?:T(?:HUR(?:DALE)?|IE)|N(?:OLDSBURG|ETT)|B"
  "(?:OVA|UCK)LE)|S(?:H(?:(?:FOR|LAN)D|TON)|BURY|TOR|CO)|M(?:(?:HERS"
  "TDA|EAG)LE|BOY|IGO|MA)|(?:(?:CCOVIL|VONDA)L|PPLE GROV)E|N(?:AWALT"
  "|MOORE|THONY|STED)|U(?:(?:GUST|ROR)A|BURN|TO)|D(?:AMSVILLE|RIAN|V"
  "ENT)|BRAHAM|THENS)|N(?:E(?:W(?: (?:M(?:A(?:RTINSVILLE|NCHESTE?R)|"
  "ILTON)|C(?:UMBERLA?ND|REEK)|(?:RICHMO|ENGLA)ND|HAVEN)|B(?:ERNE|UR"
  "G)|(?:HA|E)LL|TOW?N|VILLE|ARK)|(?:MOUR|LLI)S|TTIE|OLA|BO)|O(?:R(?"
  ":T(?:H(?: (?:(?:PARKERSBUR|SPRIN)G|MATEWAN)|FORK)|ON)|MANTOWN)|LA"
  "N|BE)| (?:MARTINSVLLE|PARKERSBURG)|A(?:UGATUCK|LLEN|PIER|OMA)|I(?"
  ":MITZ|CUT|TRO)|UTTER FORT)|D(?:A(?:V(?:I(?:S(?:VILLE)?|N)|Y)|N(?:"
  "(?:VILL|ES)E|IELS)|W(?:MONT|SON|ES)|ILEY|LLAS)|U(?:N(?:MORE|BAR|C"
  "AN|LOW)|PONT CITY|HRING|RBIN|CK|O)|E(?:L(?:BARTON|LSLOW|RAY)|EP W"
  "ATER|COTA|HUE)|R(?:Y(?:(?: CREE|FOR)K|BRANCH)|ENNEN|OOP)|I(?:A(?:"
  "MOND|NA)|(?:LL|XI)E|NGESS)|O(?:R(?:OTHY|CAS)|T(?:HAN|T)|LA))|K(?:"
  "E(?:S(?:LER(?:S CROSS LANE| CR LN)S|SLER)|N(?:(?:OV|N)A|TUCK)|(?:"
  "ARNE|LL)YSVILLE|YS(?:TONE|ER)|R(?:ENS|MIT)|GLEY)|I(?:N(?:G(?:MONT"
  "|STON|WOOD)|C(?:HELOE|AID))|MB(?:ERLY|ALL)|(?:EFF|STL)ER|AHSVILLE"
  "|RBY)|A(?:NAWHA (?:FALLS|HEAD)|YFORD|SSON)|OPPERSTON|NOB FORK|YLE"
  ")|E(?:L(?:K(?:(?: GARDE|HOR)N|VIEW|INS)|L(?:ENBORO|AMORE)|M(?: GR"
  "OVE|IRA)|IZABETH|EANOR|BERT|GOOD|TON)|A(?:ST (?:BANK|GULF|LYNN)|R"
  "LING)|N(?:TERPRISE|GLISH)|V(?:ERETTVILLE|ANS)|(?:XCHANG|SKDAL)E|D"
  "(?:GARTON|MOND)|C(?:CLES|KMAN)|(?:RBAC|GL)ON|MMETT|UREKA|THEL)|T("
  "?:H(?:O(?:R(?:NTON|PE)|MAS)|REE CH(?:URCHE|R)S|URMOND|ACKER)|A(?:"
  "L(?:LMANSVILLE|COTT)|NNER|PLIN|RIFF|MS|D)|E(?:RR(?:A ALTA|Y)|NNER"
  "TON|AYS|SLA)|W(?:I(?:N BRANCH|LIGHT)|O RUN)|R(?:IADELPHIA|O(?:UT|"
  "Y)|UE)|U(?:RTLE CREEK|NNELTON)|O(?:LL GATE|RNADO)|IOGA)|J(?:O(?:N"
  "(?:ES SPRINGS|BEN)|(?:SEPHIN|DI)E|RDAN|LO|B)|U(?:MPING BR(?:ANCH)"
  "?|N(?:CTION|IOR)|STICE|LIAN)|E(?:FF(?:ERSON|REY)|NKINJONES|SSE)|A"
  "(?:CKSONBURG|NE LEW))|O(?:R(?:GA(?:N CAVE|S)|IENT HILL|LANDO|MA)|"
  "(?:LD FIELD|WING)S|AK(?: HILL|VALE)|V(?:ERBROOK|APA)|(?:CEAN|TTAW"
  ")A|N(?:EGO|A)|HLEY|SAGE|MAR|DD)|V(?:A(?:LL(?:EY (?:(?:BEN|HEA)D|C"
  "HAPEL|GROVE|FORK)|SCREEK)|RNEY|DIS|N)|I(?:CTOR|ENNA|VIAN)|ER(?:DU"
  "NVILLE|NER)|ULCAN|OLGA)|I(?:N(?:D(?:(?:EPENDENC|OR)E|IAN MILLS|US"
  "TRIAL)|STITUTE|WOOD)|(?:SABA|TMAN)N|KES FORK|RELAND|VYDALE|AEGER|"
  "DAMAY)|U(?:PPER(?: (?:FALLS|TRACT)|GLADE)|N(?:EEDA|GER|ION)|LER)|"
  "Y(?:(?:OLY|UKO)N|ELLOW SPRING|AWKEY)|QUI(?:N(?:WOOD|CY)|CK)))))$"
  ,
  /* -- WY -- WY -- WY -- WY -- WY -- WY -- WY -- WY -- WY -- WY -- */
  "(?:\\b)((?^:(?i:(?:S(?:A(?:INT STEPHENS|DDLESTRING|ND DRAW|RATOGA"
  "|VERY)|H(?:E(?:RIDAN|LL)|IRLEY BASIN|OSHONI|AWNEE)|T(?:AR V(?:ALL"
  "EY RA|LY R)NCH| STEPHENS|ORY)|U(?:N(?:DANC|RIS)E|PERIOR|SSEX)|WEE"
  "TWAT(?:ER STATION|R STA)|(?:OUTH)? PASS CITY|(?:INCLAI|LATE)R|MOO"
  "T)|M(?:A(?:MMOTH(?: HOT SPRINGS)?|N(?:DERSON|VILLE|TUA)|RBLETON|Y"
  "OWORTH)|O(?:UNTAIN (?:HOME|VIEW)|O(?:RCROFT|SE)|R(?:TO|A)N|NETA)|"
  "E(?:DICINE BOW|ETEETSE|RIDEN)|I(?:D(?:WEST|VAL)|LLS)|C(?: KINNO|F"
  "ADDE)N|UDDY GAP)|B(?:U(?:R(?:(?:RI|N)S|LINGTON)|F(?:FALO|ORD))|A("
  "?:(?:R NUN|SI)N|IROIL|NNER|GGS)|I(?:G (?:PINEY|HORN)|TTER CREEK)|"
  "O(?:(?:ULD|SL)ER|NDURANT|RDEAUX)|E(?:AR RIVER|DFORD|ULAH)|YRON)|L"
  "(?:A(?:(?:(?: BAR|GRAN)G|RAMI)E|N(?:CE CREEK|DER))|O(?:ST (?:SPRI"
  "NGS|CABIN)|NETREE|VELL)|I(?:T(?:TLE|L) AMERICA|N(?:GLE|CH))|U(?:C"
  "KY MACCAMP|SK)|Y(?:SITE|MAN)|E(?:ITER|O))|R(?:O(?:CK(?: (?:SPRING"
  "S|RIVER)|EAGLE)|LLING HILLS|BERTSON|ZET)|A(?:NCHESTER|LSTON|WLINS"
  "|YMOND)|E(?:(?:LIANC|CLUS)E|D DESERT)|I(?:VER(?:SIDE|TON)|NER)|YA"
  "N PARK)|H(?:A(?:M(?:ILTON DOME|SFORK)|R(?:TVILLE|RIMAN)|WK SPRING"
  "S|NNA)|O(?:BACK J(?:UNCTION|CT)|RSE CREEK)|U(?:NTLEY|DSON|LETT)|I"
  "L(?:LSDALE|AND)|YATTVILLE)|P(?:I(?:NE(?: (?:BLUFFS|HAVEN)|DALE)|E"
  "DMONT)|O(?:W(?:DER RIVER|ELL)|INT OF ROCKS)|A(?:RK(?:ERTO|MA)|VIL"
  "LIO)N|RAIRIE C(?:ENTE|T)R|T OF ROCKS)|F(?:O(?:RT (?:(?:(?:WASHAK|"
  "LARAM)I|STEEL)E|BRIDGER)|UR CORNERS|NTENELLE|XPARK)|R(?:ONTIER|AN"
  "NIE|EEDOM)|A(?:IRVIEW|RSON)|T WARREN AFB)|C(?:A(?:R(?:PENTER|LILE"
  ")|SPER)|O(?:(?:WLE|D)Y|KEVILLE|RA)|H(?:UGWATER|EYENNE)|R(?:OWHEAR"
  "T|ESTON)|L(?:EARMONT|ARK)|ENTENNIAL)|A(?:L(?:(?:(?:CO)?V|T)A|(?:L"
  "ENDAL|PIN)E|(?:ADD|B)IN)|R(?:LINGTON|APAHOE|MINTO|VADA)|(?:UBUR|F"
  "TO)N|TLANTIC CITY|CME)|G(?:R(?:AN(?:ITE CANY?ON|GER)|E(?:EN RIVER"
  "|YBULL)|OVER)|A(?:R(?:LAND|RETT)|S HILLS)|LEN(?:ROCK|DO)|ILLETTE|"
  "UERNSEY)|E(?:(?:NCAMPMEN|GBER)T|L(?:K MOUNTAIN|MO)|VANS(?:VILLE|T"
  "ON)|D(?:GERTO|E)N|T(?:HETE|NA)|MBLEM)|T(?:E(?:TON VILLAGE|N SLEEP"
  ")|H(?:ERMOPOLIS|AYNE)|I(?:E SIDING|PTON)|URNERVILLE|ORRINGTON)|W("
  "?:A(?:MSUTTER|LCOTT|PITI)|IL(?:LWOOD|SON)|O(?:RLAND|LF)|HEATLAND|"
  "ESTON|RIGHT|YARNO)|D(?:I(?:AMOND(?:VILLE)?|XON)|E(?:VILS TOW|AV)E"
  "R|(?:OUGLA|UBOI)S|A(?:NIEL|YTON))|K(?:I(?:R(?:TLE|B)Y|NNEAR)|E(?:"
  "MMERER|ELINE|LLY)|ORTES DAM|AYCEE)|J(?:E(?:FFREY CITY|NNY LAKE|LM"
  ")|A(?:CKSON(?: HOLE)?|Y EM))|Y(?:EL(?:LOWSTONE NATIONAL PAR|WSTN "
  "NL P)K|ODER)|N(?:EW(?: HAVEN|CASTLE)|ATRONA|ODE)|O(?:S(?:HOTO|AGE"
  ")|PAL|RIN|TTO)|V(?:AN TASSELL|ETERAN)|U(?:PTON|RIE|VA)|IRON MOUNT"
  "AIN|QUEALY))))$"
    };
