/********************************************************************************
 *   Copyright (C) 2008-2009 by Bram Schoenmakers <bramschoenmakers@kde.nl>     *
 *                                                                              *
 *   This program is free software; you can redistribute it and/or modify       *
 *   it under the terms of the GNU General Public License as published by       *
 *   the Free Software Foundation; either version 2 of the License, or          *
 *   (at your option) any later version.                                        *
 *                                                                              *
 *   This program is distributed in the hope that it will be useful,            *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *   GNU General Public License for more details.                               *
 *                                                                              *
 *   You should have received a copy of the GNU General Public License          *
 *   along with this program; if not, write to the                              *
 *   Free Software Foundation, Inc.,                                            *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .             *
 ********************************************************************************/

#ifndef COORDINATEDIALOG_H
#define COORDINATEDIALOG_H

#include "locationdialog.h"

class KLineEdit;

class CoordinateDialog : public LocationDialog
{
  Q_OBJECT
public:
  CoordinateDialog( QWidget *p_parent = 0 );
  ~CoordinateDialog();

  qreal getLatitude() const;
  qreal getLongitude() const;
  void setLatitude( qreal p_latitude );
  void setLongitude( qreal p_longitude );

private slots:
  void longitudeChanged( const QString &p_longitude );
  void latitudeChanged( const QString &p_latitude );

private:
  void setOkButton();

  bool m_longitude_valid;
  bool m_latitude_valid;

  qreal m_latitude;
  qreal m_longitude;

  KLineEdit *m_longitudeEdit;
  KLineEdit *m_latitudeEdit;
};

#endif // COORDINATEDIALOG_H

