###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_tikiwiki_sec_bypass_vuln.nasl 4254 2009-08-26 19:06:24Z aug $
#
# TikiWiki Authentication Bypass Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901002);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2003-1574");
  script_bugtraq_id(14170);
  script_name("TikiWiki Authentication Bypass Vulnerability");
  desc = "

  Overview: The host is installed with TikiWiki and is prone to Authentication
  Bypass vulnerability.

  Vulnerability Insight:
  The flaw is caused due to improper validation of user login credentials. By
  entering a valid username, an arbitrary or null password, and clicking on the
  'remember me' button.

  Impact:
  Successful exploitation could allows to bypass the authentication process to
  gain unauthorized access to the system with the privileges of the victim.

  Impact Level: Application

  Affected Software/OS:
  TikiWiki Version 1.6.1 on all running platform.

  Fix: Upgrade to version 1.7.1.1 or latest
  http://info.tikiwiki.org/Get+Tiki

  References:
  http://xforce.iss.net/xforce/xfdb/40347
  http://sourceforge.net/tracker/index.php?func=detail&aid=748739&group_id=64258&atid=506846

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of TikiWiki");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod ");
  script_family("Web application abuses");
  script_dependencies("secpod_tikiwiki_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

tw_port = get_http_port(default:80);
if(!tw_port){
  exit(0);
}

tikiVer = get_kb_item("www/" + tw_port + "/TikiWiki");
if(!tikiVer){
  exit(0);
}

tikiVer = eregmatch(pattern:"^(.+) under (/.*)$", string:tikiVer);

if(tikiVer[1] != NULL)
{
  if(version_is_equal(version:tikiVer[1], test_version:"1.6.1")){
    security_hole(tw_port);
  }
}
