###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-060.nasl 5267 2009-10-14 09:14:35Z oct $
#
# MS ATL ActiveX Controls for MS Office Could Allow Remote Code Execution (973965)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Updated By: Antu Sanadi <santu@secpod.com> on 2010-03-23
# Removed the 'hotfix_missing()' function
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901040);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0901", "CVE-2009-2493","CVE-2009-2495");
  script_bugtraq_id(35828, 35830, 35832);
  script_name("MS ATL ActiveX Controls for MS Office Could Allow Remote Code Execution (973965)");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-060.

  Vulnerability Insight:
  Multiple flaws are caused due to,
  - Error in the Microsoft Active Template Library (ATL) within the ATL headers
    that handle instantiation of an object from data streams.
  - Error in the ATL headers, which could allow a string to be read with no ending
    NULL bytes, which could allow an attacker to manipulate a string to read extra
    data beyond the end of the string and thus disclose information in memory.
  - Error in the Microsoft Active Template Library (ATL) headers, which could allow
    attackers to call 'VariantClear()' on a variant that has not been correctly
    initialized, leading to arbitrary code execution.

  Impact:
  Successful exploitation could allow remote attackers to execute arbitrary
  code with SYSTEM privileges, and can cause Denial of Service.

  Impact Level: System/Application

  Affected Software/OS:
  Microsoft Office Outlook 2002/2003/2007
  Microsoft Office Visio Viewer 2007

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-060.mspx

  References:
  http://www.vupen.com/english/advisories/2009/2895
  http://www.microsoft.com/technet/security/bulletin/ms09-060.mspx

  Risk factor : Critical";

  script_description(desc);
  script_summary("Check for the vulnerable DLL file version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_office_products_version_900032.nasl");
  script_require_keys("SMB/WindowsVersion", "SMB/Office/Outlook/Version");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

visVer = get_kb_item("SMB/Office/Outloook/Version");
if(visVer)
{
  #Check for Office OutLook  < 10.0.6856.0 ,11.0.8312.0, 12.0.6514.5000
  if(version_in_range(version:visVer, test_version:"10.0", test_version2:"10.0.6855") ||
     version_in_range(version:visVer, test_version:"11.0", test_version2:"11.0.8311") ||
     version_in_range(version:visVer, test_version:"12.0", test_version2:"12.0.6514.4999"))
  {
    security_hole(0);
    exit(0);
  }
}

visPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion",
                           item:"ProgramFilesDir");
if(visPath)
{
  visPath += "\Microsoft Office\Office12\Vviewer.dll";
  share  = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:visPath);
  visfile =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:visPath);
  visVer = GetVer(file:visfile, share:share);
  if(visVer != NULL)
  {
     #Check for Microsoft Office Visio Viewer < 12.0.6513.5000
    if(version_in_range(version:visVer, test_version:"12.0", test_version2:"12.0.6513.4999")){
     security_hole(0);
    }
  }
}
