###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_firefox_mult_vuln_sep09_win.nasl 4684 2009-09-11 10:59:33Z sep $
#
# Mozilla Firefox Multiple Vulnerabilities - Sep09 (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900843);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3072", "CVE-2009-3077", "CVE-2009-3078", "CVE-2009-3079");
  script_bugtraq_id(36343);
  script_name("Mozilla Firefox Multiple Vulnerabilities - Sep09 (Win)");
  desc = "
  Overview: The host is installed with Firefox browser and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  - Multiple errors in the browser and JavaScript engines can be exploited to
    corrupt memory.
  - An error exists when processing operations performed on the columns of a
    XUL tree element. This can be exploited to dereference freed memory via a
    pointer owned by a column of the XUL tree element.
  - An error exists when displaying text in the location bar using the default
    Windows font. This can be exploited to spoof the URL of a trusted site via
    Unicode characters having a tall line-height.
  - An error in the implementation of the 'BrowserFeedWriter' object can be
    exploited to execute arbitrary JavaScript code with chrome privileges.

  Impact:
  A remote, unauthenticated attacker could execute arbitrary code or cause a
  vulnerable application to crash.

  Impact Level: System/Application

  Affected Software/OS:
  Mozilla Firefox version prior to 3.0.14 and 3.5 before 3.5.3 on Windows.

  Fix: Upgrade to Firefox version 3.0.14 or 3.5.3 or later
  http://www.mozilla.com/en-US/firefox/all.html

  References:
  http://secunia.com/advisories/36671/
  http://www.mozilla.org/security/announce/2009/mfsa2009-47.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-49.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-50.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-51.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_firefox_detect_win.nasl");
  script_require_keys("Firefox/Win/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Win/Ver");
if(!ffVer)
{
  exit(0);
}

# Grep for Firefox version < 3.0.14 and 3.5 < 3.5.3
if(version_is_less(version:ffVer, test_version:"3.0.14") ||
   version_in_range(version:ffVer,test_version:"3.5", test_version2:"3.5.2")){
  security_hole(0);
}
