##############################################################################
#
#  Apache Tomcat Cross-Site Scripting and Security Bypass Vulnerabilities
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/05
#
#  Revision: 1.1 
#
#  Log: schandan
#  Issue #0085
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
############################################################################## 

if(description)
{
 script_id(900021);
 script_bugtraq_id(30494, 30496);
 script_cve_id("CVE-2008-1232", "CVE-2008-2370");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
  script_tag(name:"cvss_base", value:"5.8");
  script_tag(name:"risk_factor", value:"High");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_name("Apache Tomcat Cross-Site Scripting and Security Bypass Vulnerabilities");
 script_summary("Check for vulnerable version of Apache Tomcat");
 desc = "
 Overview : This host is running Apache Tomcat web server, which is prone to
 cross site scripting and security bypass vulnerabilities.

 Vulnerability Insight :

        The flaws are due to,
        - input validation error in the method HttpServletResponse.sendError() which
          fails to properly sanitise before being returned to the user in the
          HTTP Reason-Phrase.
        - the application fails to normalize the target path before removing
          the query string when using a RequestDispatcher.

        Impact : Successful exploitation could cause execution of arbitrary
        HTML code, script code, and information disclosure.

 Impact Level : Application.

 Affected Software/OS :
        Apache Tomcat 4.1.0 - 4.1.37, 5.5.0 - 5.5.26, and 6.0.0 - 6.0.16
	on All Platforms.

 Fix : Upgrade to higher version of 4.x, 5.x, or 6.x series.
 http://tomcat.apache.org/

 References :
 http://secunia.com/advisories/31379/
 http://secunia.com/advisories/31381/

 CVSS Score :
        CVSS Base Score     : 5.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:N)
        CVSS Temporal Score : 4.5
 Risk factor : Medium";
 script_description(desc);
 script_dependencies("http_version.nasl");
 exit(0);
}


 include("http_func.inc");
 include("http_keepalive.inc");

 port = 8080;
 if(!port){
	exit(0);
 }

 sndReq = http_get(item:string("/index.jsp"), port:port);
 rcvRes = http_keepalive_send_recv(port:port, data:sndReq, bodyonly:1);
 if(rcvRes == NULL){
        exit(0);
 }

 if(egrep(pattern:"<title>Apache Tomcat", string:rcvRes))
 {
	# Grep for Apache Tomcat 4.1.0 - 4.1.37, 5.5.0 - 5.5.26, 6.0.0 - 6.0.16
        if(egrep(pattern:"Apache Tomcat/(4\.1(\.[0-2]?[0-9]|\.3[0-7])?|5\.5" +
			 "(\.[01]?[0-9]|\.2[0-6])?|6\.0(\.[0-9]|\.1[0-6])?)" +
			 "[^.0-9]", string:rcvRes)){
                       security_warning(port);
        }
 }
