##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_perl_detect_win.nasl 5569 2009-11-04 09:52:37Z nov $
#
# Perl Version Detection (Windows)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800966);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Perl Version Detection (Windows)");
  desc = "
  Overview : This script retrieves the version of Perl saves the result
  in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set version of Perl in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Perl")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  perlName = registry_get_sz(key:key + item, item:"DisplayName");

  # Check for Strawberry Perl
  if("Strawberry Perl" >< perlName)
  {
    perlVer = registry_get_sz(key:key + item, item:"Comments");
    perlVer = eregmatch(pattern:"Strawberry Perl ([0-9.]+)", string:perlVer);
    if(!isnull(perlVer[1]))
    {
      set_kb_item(name:"Strawberry/Perl/Ver", value:perlVer[1]);
      security_note(data:"Strawberry Perl version " + perlVer[1] +
                                     " was detected on the host");
    }
  }

  # Check for ActivePerl
  if("ActivePerl"  >< perlName)
  {
    perlVer = eregmatch(pattern:"ActivePerl ([0-9.]+)", string:perlName);
    if(!isnull(perlVer[1]))
    {
      set_kb_item(name:"ActivePerl/Ver", value:perlVer[1]);
      security_note(data:"ActivePerl version " + perlVer[1] +
                                    " was detected on the host");
    }
  }
}
