###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_justsystems_ichitaro_prdts_detect.nasl 1144 2009-04-01 13:51:44Z apr $
#
# JustSystems Ichitaro Product(s) Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800542);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("JustSystems Ichitaro Product(s) Version Detection");
  desc ="

  Overview : This script finds the installed product version of Ichitaro
  and Ichitaro viewer and sets the result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set KB for the version of JustSystems Ichitaro Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Justsystem")){
  exit(0);
}

viewerPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                 "\App Paths\TAROVIEW.EXE", item:"Path");
if(viewerPath)
{
  path = viewerPath + "\TAROVIEW.EXE";
  share = ereg_replace(pattern:"([A-Za-z]):.*", replace:"\1$", string:path);
  file = ereg_replace(pattern:"[A-Za-z]:(.*)", replace:"\1", string:path);
  viewerVer = GetVer(file:file, share:share);

  if(viewerVer != NULL)
  {
    set_kb_item(name:"Ichitaro/Viewer/Ver", value:viewerVer);
    security_note(data:"Ichitaro Viewer version " + viewerVer + " running at" + 
                       " location " + viewerPath + " was detected on the host");
  }
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  appName = registry_get_sz(key:key + item, item:"DisplayName");
  if("ATOK" >< appName)
  {
    appVer = eregmatch(pattern:"ATOK ([0-9.]+)", string:appName);
    if(appVer[1] != NULL)
    {
      set_kb_item(name:"Ichitaro/Ver", value:appVer[1]);
      security_note(data:"Ichitaro version " + appVer[1] +
                         " was detected on the host");
    }
    exit(0);
  }
}
