###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for DNS and Resolver Libraries HPSBUX00209
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835151);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "HPSBUX", value: "00209");
  script_name( "HP-UX Update for DNS and Resolver Libraries HPSBUX00209");
  desc = "

  Vulnerability Insight:
  A vulnerability in HP-UX DNS and resolver libraries which may allow remote 
  execution of arbitrary code or creation of a denial of service (DoS). 

  Impact:
  Remote execution of arbitrary code or creation of a denial of service (DoS)

  Affected Software/OS:
  DNS and Resolver Libraries on
  HP-UX releases B.10.10, B.10.20, B.10.24 (VVOS), B.11.00, B.11.04 (VVOS), 
  B.11.11 and B.11.22. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00957990-2

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of DNS and Resolver Libraries");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX10.10")
{

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-RUN", patch_list:['PHNE_27792'], rls:"HPUX10.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.CORE-SHLIBS", revision:".1.1010", rls:"HPUX10.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"BINDv812.INETSVCS-BIND", revision:"B.11.00.01.004", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"BINDv920.INETSVCS-BIND", revision:"B.11.00.01.001", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"bind.INETSVCS-RUN", patch_list:['PHNE_28449'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"upgrade_bind812.INETSVCS-RUN", patch_list:['PHNE_28449'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"BINDv913.INETSVCS-BIND", patch_list:['PHNE_28449'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-RUN", patch_list:['PHNE_28449'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SHLIBS", patch_list:['PHNE_27795'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-64SLIB", patch_list:['PHNE_27795'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.24")
{

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-RUN", patch_list:['PHNE_27879'], rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.C-MIN", patch_list:['PHCO_27882'], rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.CORE-SHLIBS", patch_list:['PHCO_27882'], rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"ProgSupport.PROG-AUX", patch_list:['PHCO_27882'], rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"ProgSupport.PROG-MIN", patch_list:['PHCO_27882'], rls:"HPUX10.24"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.04")
{

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-RUN", patch_list:['PHNE_29634'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-64SLIB", patch_list:['PHNE_27881'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SHLIBS", patch_list:['PHNE_27881'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX10.20")
{

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-RUN", patch_list:['PHNE_27792'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.C-MIN", patch_list:['PHCO_26158'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.CORE-SHLIBS", patch_list:['PHCO_26158'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"ProgSupport.PROG-MIN", patch_list:['PHCO_26158'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"ProgSupport.PROG-AUX", patch_list:['PHCO_26158'], rls:"HPUX10.20"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.22")
{

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS2-RUN", patch_list:['PHNE_28490'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SHLIBS", patch_list:['PHNE_28299'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-64SLIB", patch_list:['PHNE_28299'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"BINDv913.INETSVCS-BIND", revision:"B.11.11.01.002", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"BIND.INETSVCS-RUN", revision:"B.11.11.01.002", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"BINDv920.INETSVCS-BIND", revision:"B.11.11.01.002", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-RUN", patch_list:['PHNE_28450'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SHLIBS", patch_list:['PHNE_27796'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-64SLIB", patch_list:['PHNE_27796'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
