###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apache_mod_deflate_dos_vuln_jul09.nasl 3393 2009-07-13 21:34:34Z jul $
#
# Apache 'mod_deflate' Denial Of Service Vulnerability - July09
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800837);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-1891");
  script_bugtraq_id(35623);
  script_name("Apache 'mod_deflate' Denial Of Service Vulnerability - July09");
  desc = "

  Overview:
  This host is running Apache HTTP Server and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  The flaw is due to error in 'mod_deflate' module which can cause a high CPU
  load by requesting large files which are compressed and then disconnecting.

  Impact:
  Successful exploitation will allow remote attackers to cause Denial of Service
  to the legitimate user by CPU consumption.

  Impact Level: Application

  Affected Software/OS:
  Apache HTTP Server version 2.2.11 and prior

  Fix:
  Fixed in the SVN repository.
  http://svn.apache.org/viewvc?view=rev&revision=791454

  ******
  NOTE: Ignore this warning if above mentioned patch is already applied.
  ******

  References:
  http://secunia.com/advisories/35781
  http://www.vupen.com/english/advisories/2009/1841
  https://rhn.redhat.com/errata/RHSA-2009-1148.html
  https://bugzilla.redhat.com/show_bug.cgi?id=509125

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check version of Apache HTTP Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_apache_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

httpdPort = get_http_port(default:80);
if(!httpdPort){
  exit(0);
}

httpdVer = get_kb_item("www/" + httpdPort + "/Apache");

if(httpdVer != NULL)
{
  if(version_is_less_equal(version:httpdVer, test_version:"2.2.11")){
    security_warning(httpdPort);
  }
}
