# Jasmine Core 3.9 Release Notes

## New features and bug fixes

* Fixed Trusted Types error in `j$.isError_` in Chromium-based browsers
  * Merges [#1921](https://github.com/jasmine/jasmine/pull/1921) from @bjarkler
  * Fixes [#1910](https://github.com/jasmine/jasmine/issues/1910)
  * Fixes [#1653](https://github.com/jasmine/jasmine/issues/1653)

* Better reporting of unhandled promise rejections with truthy but non-`Error`
  reasons on Node
* `Env#execute` returns a promise in environments that support promises
* Renamed `failFast` and `oneFailurePerSpec` config props to `stopOnSpecFailure`
  and `stopSpecOnExpectationFailure`

  The new names are more self-explanatory and consistent with jasmine-npm. The
  old names are deprecated but will still work until the next major release.

* Split `boot.js` into two files to allow the env to be configured in between

  This is mainly intended to support jasmine-browser-runner, which will load
  a script that configures the env in between the two boot files (`boot0.js` and
  `boot1.js`). The single-file `boot.js` will still be included until the next
  major release.

## Ruby deprecation

The Jasmine Ruby gems are deprecated. There will be no further releases after
the end of the Jasmine 3.x series. We recommend that most users migrate to the
[jasmine-browser-runner](https://github.com/jasmine/jasmine-browser)
npm package, which is the direct replacement for the `jasmine` gem.

If `jasmine-browser-runner` doesn't meet your needs, one of these might:

* The [jasmine](https://github.com/jasmine/jasmine-npm) npm package to run
  specs in Node.js.
* The [standalone distribution](https://github.com/jasmine/jasmine#installation)
  to run specs in browsers with no additional tools.
* The [jasmine-core](https://github.com/jasmine/jasmine) npm package if all
  you need is the Jasmine assets. This is the direct equivalent of the
  `jasmine-core` Ruby gem.

## Documentation updates

* Added API docs for `Suite#id` and `Spec#id`
* Marked `Env#hideDisabled` deprecated in jsdocs


------

## Supported environments

jasmine-core 3.9.0 has been tested in the following environments.

| Environment       | Supported versions |
|-------------------|--------------------|
| Node              | 10, 12, 14, 16     |
| Safari            | 8-14               |
| Chrome            | 92                 |
| Firefox           | 91, 78, 68         |
| Edge              | 92                 |
| Internet Explorer | 10, 11             |


_Release Notes generated with _[Anchorman](http://github.com/infews/anchorman)_
