/* $Id: SeqTable_sparse_index.hpp 115433 2007-12-12 16:47:01Z vasilche $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SeqTable_sparse_index.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'seqtable.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: SeqTable_sparse_index_.hpp


#ifndef OBJECTS_SEQTABLE_SEQTABLE_SPARSE_INDEX_HPP
#define OBJECTS_SEQTABLE_SEQTABLE_SPARSE_INDEX_HPP


// generated includes
#include <objects/seqtable/SeqTable_sparse_index_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQ_EXPORT CSeqTable_sparse_index : public CSeqTable_sparse_index_Base
{
    typedef CSeqTable_sparse_index_Base Tparent;
public:
    // constructor
    CSeqTable_sparse_index(void);
    // destructor
    ~CSeqTable_sparse_index(void);

    static const size_t kSkipped = size_t(~0);

    typedef TIndexes::value_type index_type;
    class CConstIterator {
    public:
        enum EBegin {
            eBegin
        };
        enum EEnd {
            eEnd
        };
        CConstIterator(const CSeqTable_sparse_index& sparse, EBegin)
            : m_Index(0),
              m_IndexesIter(sparse.GetIndexes().begin()),
              m_IndexesEnd(sparse.GetIndexes().end())
            {
            }
        CConstIterator(const CSeqTable_sparse_index& sparse, EEnd)
            : m_Index(0),
              m_IndexesIter(sparse.GetIndexes().end()),
              m_IndexesEnd(sparse.GetIndexes().end())
            {
            }
        CConstIterator(const CSeqTable_sparse_index& sparse, index_type index)
            : m_Index(index),
              m_IndexesIter(lower_bound(sparse.GetIndexes().begin(),
                                        sparse.GetIndexes().end(),
                                        index)),
              m_IndexesEnd(sparse.GetIndexes().end())
            {
            }
        
        index_type GetRow(void) const {
            return m_Index;
        }

        bool NoMoreSelected(void) const {
            return m_IndexesIter == m_IndexesEnd;
        }

        bool IsSelected(void) const {
            return m_IndexesIter != m_IndexesEnd && *m_IndexesIter == m_Index;
        }

        CConstIterator& operator++(void) {
            if ( IsSelected() ) {
                ++m_IndexesIter;
            }
            ++m_Index;
            return *this;
        }
        
    private:
        index_type m_Index;
        TIndexes::const_iterator m_IndexesIter, m_IndexesEnd;
    };
    typedef CConstIterator const_iterator;

    index_type GetMinSelectedIndex(void) const {
        const TIndexes& indexes = GetIndexes();
        return indexes.empty()? 0: indexes.front();
    }

    index_type GetMaxSelectedIndex(void) const {
        const TIndexes& indexes = GetIndexes();
        return indexes.empty()? 0: indexes.back();
    }

    const_iterator begin(void) const {
        return CConstIterator(*this, CConstIterator::eBegin);
    }

    const_iterator end(void) const {
        return CConstIterator(*this, CConstIterator::eEnd);
    }

    const_iterator find(index_type index) const {
        return CConstIterator(*this, index);
    }

    size_t GetIndexAt(index_type index) const {
        const TIndexes& indexes = GetIndexes();
        TIndexes::const_iterator iter =
            lower_bound(indexes.begin(), indexes.end(), index);
        if ( iter != indexes.end() && *iter == index ) {
            return iter - indexes.begin();
        }
        else {
            return kSkipped;
        }
    }

    bool IsSelectedAt(index_type index) const {
        const TIndexes& indexes = GetIndexes();
        TIndexes::const_iterator iter =
            lower_bound(indexes.begin(), indexes.end(), index);
        return iter != indexes.end() && *iter == index;
    }

private:
    // Prohibit copy constructor and assignment operator
    CSeqTable_sparse_index(const CSeqTable_sparse_index& value);
    CSeqTable_sparse_index& operator=(const CSeqTable_sparse_index& value);

};

/////////////////// CSeqTable_sparse_index inline methods

// constructor
inline
CSeqTable_sparse_index::CSeqTable_sparse_index(void)
{
}


/////////////////// end of CSeqTable_sparse_index inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQTABLE_SEQTABLE_SPARSE_INDEX_HPP
/* Original file checksum: lines: 86, chars: 2645, CRC32: cdd5d50f */
