/*
 * Copyright (C) 2004, 2005 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <gmodule.h>
#include <libsoup/soup.h>
#include "translate.h"
#include "translate-generic-main.h"
#include "translate-generic-parser.h"
#include "translate-generic-soup-cookie-jar.h"

TranslateGenericDebugFlags translate_generic_debug_flags = 0;

G_MODULE_EXPORT gboolean
translate_module_init (GError **err)
{
  const char *debug;
  char *user_services;

  debug = g_getenv("TRANSLATE_GENERIC_DEBUG");
  if (debug)
    {
      static const GDebugKey keys[] = {
	{ "log-transfers", TRANSLATE_GENERIC_DEBUG_LOG_TRANSFERS }
      };
	
      translate_generic_debug_flags = g_parse_debug_string(debug, keys, G_N_ELEMENTS(keys));
    }
  
  translate_generic_parse(SERVICESFILE);

  user_services = g_build_filename(g_get_home_dir(), ".libtranslate", "services.xml", NULL);
  translate_generic_parse(user_services);
  g_free(user_services);

  /*
   * Work around http://bugzilla.gnome.org/show_bug.cgi?id=64764:
   * initialize the classes we will be accessing concurrently (in
   * translate_service_generic_translate(), which is called by the
   * translate_session_translate() thread pool).
   */
  g_type_class_ref(SOUP_TYPE_SESSION);
  g_type_class_ref(SOUP_TYPE_MESSAGE);
  g_type_class_ref(TRANSLATE_GENERIC_TYPE_SOUP_COOKIE_JAR);

  return TRUE;
}
