#include "sw-item-view-ginterface.h"

#include "sw-marshals.h"

static const DBusGObjectInfo _sw_item_view_iface_object_info;

struct _SwItemViewIfaceClass {
    GTypeInterface parent_class;
    sw_item_view_iface_start_impl start;
    sw_item_view_iface_refresh_impl refresh;
    sw_item_view_iface_stop_impl stop;
    sw_item_view_iface_close_impl close;
};

enum {
    SIGNAL_ITEM_VIEW_IFACE_ItemsAdded,
    SIGNAL_ITEM_VIEW_IFACE_ItemsRemoved,
    SIGNAL_ITEM_VIEW_IFACE_ItemsChanged,
    N_ITEM_VIEW_IFACE_SIGNALS
};
static guint item_view_iface_signals[N_ITEM_VIEW_IFACE_SIGNALS] = {0};

static void sw_item_view_iface_base_init (gpointer klass);

GType
sw_item_view_iface_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (SwItemViewIfaceClass),
        sw_item_view_iface_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "SwItemViewIface", &info, 0);
    }

  return type;
}

/**
 * sw_item_view_iface_start_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Start on interface com.meego.libsocialweb.ItemView.
 */
static void
sw_item_view_iface_start (SwItemViewIface *self,
    DBusGMethodInvocation *context)
{
  sw_item_view_iface_start_impl impl = (SW_ITEM_VIEW_IFACE_GET_CLASS (self)->start);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_item_view_iface_implement_start:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Start D-Bus method
 *
 * Register an implementation for the Start method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_item_view_iface_implement_start (SwItemViewIfaceClass *klass, sw_item_view_iface_start_impl impl)
{
  klass->start = impl;
}

/**
 * sw_item_view_iface_refresh_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Refresh on interface com.meego.libsocialweb.ItemView.
 */
static void
sw_item_view_iface_refresh (SwItemViewIface *self,
    DBusGMethodInvocation *context)
{
  sw_item_view_iface_refresh_impl impl = (SW_ITEM_VIEW_IFACE_GET_CLASS (self)->refresh);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_item_view_iface_implement_refresh:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Refresh D-Bus method
 *
 * Register an implementation for the Refresh method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_item_view_iface_implement_refresh (SwItemViewIfaceClass *klass, sw_item_view_iface_refresh_impl impl)
{
  klass->refresh = impl;
}

/**
 * sw_item_view_iface_stop_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Stop on interface com.meego.libsocialweb.ItemView.
 */
static void
sw_item_view_iface_stop (SwItemViewIface *self,
    DBusGMethodInvocation *context)
{
  sw_item_view_iface_stop_impl impl = (SW_ITEM_VIEW_IFACE_GET_CLASS (self)->stop);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_item_view_iface_implement_stop:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Stop D-Bus method
 *
 * Register an implementation for the Stop method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_item_view_iface_implement_stop (SwItemViewIfaceClass *klass, sw_item_view_iface_stop_impl impl)
{
  klass->stop = impl;
}

/**
 * sw_item_view_iface_close_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Close on interface com.meego.libsocialweb.ItemView.
 */
static void
sw_item_view_iface_close (SwItemViewIface *self,
    DBusGMethodInvocation *context)
{
  sw_item_view_iface_close_impl impl = (SW_ITEM_VIEW_IFACE_GET_CLASS (self)->close);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_item_view_iface_implement_close:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Close D-Bus method
 *
 * Register an implementation for the Close method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_item_view_iface_implement_close (SwItemViewIfaceClass *klass, sw_item_view_iface_close_impl impl)
{
  klass->close = impl;
}

/**
 * sw_item_view_iface_emit_items_added:
 * @instance: The object implementing this interface
 * @arg_items: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ItemsAdded signal on interface com.meego.libsocialweb.ItemView.
 */
void
sw_item_view_iface_emit_items_added (gpointer instance,
    const GPtrArray *arg_items)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, SW_TYPE_ITEM_VIEW_IFACE));
  g_signal_emit (instance,
      item_view_iface_signals[SIGNAL_ITEM_VIEW_IFACE_ItemsAdded],
      0,
      arg_items);
}

/**
 * sw_item_view_iface_emit_items_removed:
 * @instance: The object implementing this interface
 * @arg_items: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ItemsRemoved signal on interface com.meego.libsocialweb.ItemView.
 */
void
sw_item_view_iface_emit_items_removed (gpointer instance,
    const GPtrArray *arg_items)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, SW_TYPE_ITEM_VIEW_IFACE));
  g_signal_emit (instance,
      item_view_iface_signals[SIGNAL_ITEM_VIEW_IFACE_ItemsRemoved],
      0,
      arg_items);
}

/**
 * sw_item_view_iface_emit_items_changed:
 * @instance: The object implementing this interface
 * @arg_items: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ItemsChanged signal on interface com.meego.libsocialweb.ItemView.
 */
void
sw_item_view_iface_emit_items_changed (gpointer instance,
    const GPtrArray *arg_items)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, SW_TYPE_ITEM_VIEW_IFACE));
  g_signal_emit (instance,
      item_view_iface_signals[SIGNAL_ITEM_VIEW_IFACE_ItemsChanged],
      0,
      arg_items);
}

static inline void
sw_item_view_iface_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (sw_item_view_iface_get_type (),
      &_sw_item_view_iface_object_info);

  /**
   * SwItemViewIface::items-added:
   * @arg_items: const GPtrArray * (FIXME, generate documentation)
   *
   * The ItemsAdded D-Bus signal is emitted whenever this GObject signal is.
   */
  item_view_iface_signals[SIGNAL_ITEM_VIEW_IFACE_ItemsAdded] =
  g_signal_new ("items-added",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT64, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))));

  /**
   * SwItemViewIface::items-removed:
   * @arg_items: const GPtrArray * (FIXME, generate documentation)
   *
   * The ItemsRemoved D-Bus signal is emitted whenever this GObject signal is.
   */
  item_view_iface_signals[SIGNAL_ITEM_VIEW_IFACE_ItemsRemoved] =
  g_signal_new ("items-removed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INVALID)))));

  /**
   * SwItemViewIface::items-changed:
   * @arg_items: const GPtrArray * (FIXME, generate documentation)
   *
   * The ItemsChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  item_view_iface_signals[SIGNAL_ITEM_VIEW_IFACE_ItemsChanged] =
  g_signal_new ("items-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT64, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))));

}
static void
sw_item_view_iface_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      sw_item_view_iface_base_init_once (klass);
    }
}
static const DBusGMethodInfo _sw_item_view_iface_methods[] = {
  { (GCallback) sw_item_view_iface_start, g_cclosure_marshal_VOID__POINTER, 0 },
  { (GCallback) sw_item_view_iface_refresh, g_cclosure_marshal_VOID__POINTER, 41 },
  { (GCallback) sw_item_view_iface_stop, g_cclosure_marshal_VOID__POINTER, 84 },
  { (GCallback) sw_item_view_iface_close, g_cclosure_marshal_VOID__POINTER, 124 },
};

static const DBusGObjectInfo _sw_item_view_iface_object_info = {
  0,
  _sw_item_view_iface_methods,
  4,
"com.meego.libsocialweb.ItemView\0Start\0A\0\0com.meego.libsocialweb.ItemView\0Refresh\0A\0\0com.meego.libsocialweb.ItemView\0Stop\0A\0\0com.meego.libsocialweb.ItemView\0Close\0A\0\0\0",
"com.meego.libsocialweb.ItemView\0ItemsAdded\0com.meego.libsocialweb.ItemView\0ItemsRemoved\0com.meego.libsocialweb.ItemView\0ItemsChanged\0\0",
"\0\0",
};


