//start of PostLh2Encoder.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * PostLh2Encoder.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.OutputStream;
import java.lang.Math;
import jp.gr.java_conf.dangan.io.BitOutputStream;
import jp.gr.java_conf.dangan.util.lha.DynamicHuffman;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;

//import exceptions
import java.io.IOException;
import java.io.EOFException;
import java.lang.NullPointerException;

/**
 * -lh2- kp PostLzssEncoderB <br>
 * 
 * <pre>
 * -- revision history --
 * $Log: PostLh2Encoder.java,v $
 * Revision 1.1  2002/12/01 00:00:00  dangan
 * [maintenance]
 *     \[X
 *
 * Revision 1.0  2002/07/31 00:00:00  dangan
 * add to version control
 * [maintenance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1 $
 */
public class PostLh2Encoder implements PostLzssEncoder {

    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  LZSS parameter
    //------------------------------------------------------------------
    //  private static final int DictionarySize
    //  private static final int MaxMatch
    //  private static final int Threshold
    //------------------------------------------------------------------
    /** TCY */
    private static final int DictionarySize = 8192;

    /** őv */
    private static final int MaxMatch       = 256;

    /** ŏv */
    private static final int Threshold      = 3;


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  private static final int CodeSize
    //------------------------------------------------------------------
    /**
     * codẽnt}؂̃TCY 
     * codeȏ̒lꍇ͗]vȃrbgo͂ĕ₤B
     */
    private static final int CodeSize = 286;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  sink
    //------------------------------------------------------------------
    //  private BitOutputStream out
    //------------------------------------------------------------------
    /**
     * -lh2- `̈kf[^̏o͐ rbgo̓Xg[
     */
    private BitOutputStream out;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  dynamic huffman tree
    //------------------------------------------------------------------
    //  private DynamicHuffman codeHuffman
    //  private DynamicHuffman offHiHuffman
    //------------------------------------------------------------------
    /**
     * codekpKInt}
     */
    private DynamicHuffman codeHuffman;

    /**
     * offHikpKInt}
     */
    private DynamicHuffman offHiHuffman;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  current position
    //------------------------------------------------------------------
    //  private int position
    //  private int nextPosition
    //  private int matchLength
    //------------------------------------------------------------------
    /**
     * o͂IWĩTCYJEg
     */
    private int position;

    /**
     * ɗt铮ʒu
     */
    private int nextPosition;

    /**
     * ݏ̈v
     */
    private int matchLength;


    //------------------------------------------------------------------
    //  constructer
    //------------------------------------------------------------------
    //  private PostLh2Encoder()
    //  public PostLh2Encoder( OutputStream out )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private PostLh2Encoder(){   }

    /**
     * -lh2- kp PostLzssEncoder \zB
     * 
     * @param out kf[^󂯎o̓Xg[
     */
    public PostLh2Encoder( OutputStream out ){
        if( out != null ){
            if( out instanceof BitOutputStream ){
                this.out = (BitOutputStream)out;
            }else{
                this.out = new BitOutputStream( out );
            }
            this.codeHuffman  = new DynamicHuffman( PostLh2Encoder.CodeSize );
            this.offHiHuffman = new DynamicHuffman(
                                      PostLh2Encoder.DictionarySize >> 6, 1 );
            this.position     = 0;
            this.nextPosition = 1 << 6;
        }else{
            throw new NullPointerException( "out" );
        }
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PostLzssEncoder
    //------------------------------------------------------------------
    //  write
    //------------------------------------------------------------------
    //  public void writeCode( int code )
    //  public void writeOffset( int offset )
    //------------------------------------------------------------------
    /**
     * 1byte  LZSSk̃f[^́A
     * LZSS ňkꂽkR[ĥvށB<br>
     * 
     * @param code 1byte  LZSSk̃f[^́A
     *             LZSS ňkꂽkR[ĥv
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void writeCode( int code ) throws IOException {
        final int CodeMax = PostLh2Encoder.CodeSize - 1;

        int node  = this.codeHuffman.codeToNode( Math.min( code, CodeMax ) );
        int hcode = 0;
        int hlen  = 0;
        do{
            hcode >>>= 1;
            hlen++;
            if( ( node & 1 ) != 0 ) hcode |= 0x80000000;

            node = this.codeHuffman.parentNode( node );
        }while( node != DynamicHuffman.ROOT );

        this.out.writeBits( hlen, hcode >>> ( 32 - hlen ) );                    //throws IOException


        if( code < 0x100 ){
            this.position++;
        }else{
            this.matchLength = ( code & 0xFF ) + PostLh2Encoder.Threshold;

            if( CodeMax <= code ){
                this.out.writeBits( 8, code - CodeMax );                        //throws IOException
                code = CodeMax;   //updateR[hCodeMaxɂB
            }
        }
        this.codeHuffman.update( code );
    }

    /**
     * LZSS ňkꂽkR[ĥvʒuށB<br>
     * 
     * @param offset LZSS ňkꂽkR[ĥvʒu
     */
    public void writeOffset( int offset ) throws IOException {
        if( this.nextPosition < PostLh2Encoder.DictionarySize ){
            while( this.nextPosition < this.position ){
                this.offHiHuffman.addLeaf( this.nextPosition >> 6 );
                this.nextPosition += 64;

                if( PostLh2Encoder.DictionarySize <= this.nextPosition )
                    break;
            }
        }

        int node  = this.offHiHuffman.codeToNode( offset >> 6 );
        int hcode = 0;
        int hlen  = 0;
        while( node != DynamicHuffman.ROOT ){
            hcode >>>= 1;
            hlen++;
            if( ( node & 1 ) != 0 ) hcode |= 0x80000000;

            node = this.offHiHuffman.parentNode( node );
        }

        this.out.writeBits( hlen, hcode >> ( 32 - hlen ) );                     //throws IOException
        this.out.writeBits( 6, offset );                                        //throws IOException
        this.offHiHuffman.update( offset >> 6 );

        this.position += this.matchLength;
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PostLzssEncoder
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public void flush()
    //  public void close()
    //------------------------------------------------------------------
    /**
     *  PostLzssEncoder Ƀobt@OĂ
     * SĂ 8rbgPʂ̃f[^o͐ OutputStream ɏo͂A
     * o͐ OutputStream  flush() B<br>
     * ̃\bh͈kωȂB
     * 
     * @exception IOException o̓G[ꍇ
     * 
     * @see PostLzssEncoder#flush()
     * @see BitOutputStream#flush()
     */
    public void flush() throws IOException {
        this.out.flush();                                                       //throws IOException
    }

    /**
     * ̏o̓Xg[ƁAڑꂽo̓Xg[A
     * gpĂ\[XJB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        this.out.close();                                                       //throws IOException

        this.out          = null;
        this.codeHuffman  = null;
        this.offHiHuffman = null;
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PostLzssEncoder
    //------------------------------------------------------------------
    //  get LZSS parameter
    //------------------------------------------------------------------
    //  public int getDictionarySize()
    //  public int getMaxMatch()
    //  public int getThreshold()
    //------------------------------------------------------------------
    /**
     * -lh2-` LZSS̃TCY𓾂B
     * 
     * @return -lh2-` LZSS̃TCY
     */
    public int getDictionarySize(){
        return PostLh2Encoder.DictionarySize;
    }

    /**
     * -lh2-` LZSS̍őv𓾂B
     * 
     * @return -lh2-` LZSS̍őv
     */
    public int getMaxMatch(){
        return PostLh2Encoder.MaxMatch;
    }

    /**
     * -lh2-` LZSS̈kA񈳏k臒l𓾂B
     * 
     * @return -lh2-` LZSS̈kA񈳏k臒l
     */
    public int getThreshold(){
        return PostLh2Encoder.Threshold;
    }

}
//end of PostLh2Encoder.java
