/*
 * @(#)JUnitTestInfoJDK13UTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.autodoc.v1.testserver.junit;

import net.sourceforge.groboutils.autodoc.v1.*;
import net.sourceforge.groboutils.autodoc.v1.testserver.*;

import org.easymock.EasyMock;
import org.easymock.MockControl;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests the JUnitTestInfo class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     March 27, 2002
 * @version   $Date: 2003/02/10 22:52:18 $
 */
public class JUnitTestInfoJDK13UTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = JUnitTestInfoJDK13UTest.class;
    
    public JUnitTestInfoJDK13UTest( String name )
    {
        super( name );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    private MockControl logControl;
    private AutoDocLog mockLog;

    private MockControl itControl;
    private AutoDocIT mockIT;

    private MockControl tpControl;
    private AutoDocTP mockTP;
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
        this.logControl = EasyMock.controlFor( AutoDocLog.class );
        this.mockLog = (AutoDocLog)this.logControl.getMock();
        
        this.itControl = EasyMock.controlFor( AutoDocIT.class );
        this.mockIT = (AutoDocIT)this.itControl.getMock();
        
        this.tpControl = EasyMock.controlFor( AutoDocTP.class );
        this.mockTP = (AutoDocTP)this.tpControl.getMock();
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testConstructor1()
    {
        try
        {
            new JUnitTestInfo( null );
            fail("Did not throw IllegalArgumentException.");
        }
        catch (IllegalArgumentException e)
        {
            // test exception
        }
    }
    
    
    public void testConstructor2()
    {
        JUnitTestInfo ti = new JUnitTestInfo( this );
        assertEquals(
            "Did not set suite name correctly.",
            getClass().getName(),
            ti.getSuite() );
        assertEquals(
            "Did not set method name correctly.",
            getName(),
            ti.getMethod() );
    }
    
    
    public void testConstructor3()
    {
        String name = "myName";
        TestSuite ts = new TestSuite();
        ts.setName( name );
        JUnitTestInfo ti = new JUnitTestInfo( ts );
        assertEquals(
            "Did not set suite name correctly.",
            name,
            ti.getSuite() );
        assertEquals(
            "Did not set method name correctly.",
            "run",
            ti.getMethod() );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        InterfaceTestSuite suite = TestInfoUTestI.suite();
        suite.addTestSuite( THIS_CLASS );
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() {
                return new JUnitTestInfo( new Object() );
            }
        } );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        super.tearDown();
    }
}

