#if !defined (__STRATEGY_HPP)
#define __STRATEGY_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if !defined( __COMMON_HPP)
#include <Common.hpp>
#endif

namespace corelinux
{

   DECLARE_CLASS( Strategy );

   /**
   Strategy is a base class for describing families of 
   alogrithms. Strategy lets the alogrithm vary independently
   from clients that use them.
   */

   class Strategy
   {
   public:

                           /// Default Constructor

                           Strategy( void );

                           /** Copy Constructor
                           @param Strategy const reference
                           */

                           Strategy( StrategyCref );

                           /// Virtual Destructor  

      virtual              ~Strategy( void );

      //
      // Operator overloads
      //
               /**
               Assignment operator overload
               @param  Strategy const reference
               @return Strategy reference to self
               */
            
               StrategyRef  operator=( StrategyCref );

               /**
               Equality operator overload
               @param Strategy const reference
               @return true if equal, false otherwise
               */

               bool        operator==( StrategyCref ) const;

               /**
               Non-equality operator overload
               @param Strategy const reference
               @return false if equal, true otherwise
               */

               bool        operator!=( StrategyCref ) const;

   };

}
          
#endif   // if !defined(__STRATEGY_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/13 12:32:21 $
   $Locker:  $
*/


