/*
 * Kopete plugin to display incoming messages in message indicator
 *
 * Copyright 2009-2010 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: GPL v3
 */
#ifndef INDICATORPLUGIN_H
#define INDICATORPLUGIN_H

#include <QObject>

// libindicate-qt
#include <qindicateindicator.h>
#include <qindicateserver.h>

// libkopete
#include <kopete/kopetechatsession.h>
#include <kopete/kopetemessage.h>
#include <kopete/kopeteplugin.h>
#include <kopete/ui/kopeteview.h>

typedef QHash<Kopete::ChatSession*, QIndicate::Indicator*> IndicatorForSessionHash;

class IndicatorPlugin : public Kopete::Plugin
{
    Q_OBJECT

public:
    IndicatorPlugin(QObject* parent, const QVariantList& args);
    ~IndicatorPlugin();

private Q_SLOTS:
    void createIndicatorForChatSession(Kopete::ChatSession*);
    void deleteIndicatorForChatSession(Kopete::ChatSession*);
    void slotViewActivated(KopeteView*);
    void slotMessageReceived(Kopete::Message& msg, Kopete::ChatSession* session);
    void showMainWindow();
    void slotIndicatorDisplay(QIndicate::Indicator*);

    void slotInterestAdded(QIndicate::Interest);
    void slotInterestRemoved(QIndicate::Interest);

    void slotNewEvent(Kopete::MessageEvent* event);
    void slotEventDone(Kopete::MessageEvent* event);

    Q_INVOKABLE bool showCloseWindowMessage();
    Q_INVOKABLE bool shouldExitOnClose();

private:
    QIndicate::Server* m_indicateServer;
    IndicatorForSessionHash m_indicatorForSession;
    int m_interestCount;
    QList<Kopete::MessageEvent*> m_eventList;

    bool isConnectedToListener() const;
};

#endif // INDICATORPLUGIN_H
