/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GTK_METERSCALE_H__
#define __GTK_METERSCALE_H__


#include <gdk/gdk.h>
#include <gtk/gtkadjustment.h>
#include <gtk/gtkwidget.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_METERSCALE(obj)          GTK_CHECK_CAST (obj, gtk_meterscale_get_type (), GtkMeterScale)
#define GTK_METERSCALE_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_meterscale_get_type (), GtkMeterScaleClass)
#define GTK_IS_METERSCALE(obj)       GTK_CHECK_TYPE (obj, gtk_meterscale_get_type ())

#define GTK_METERSCALE_LEFT    1
#define GTK_METERSCALE_RIGHT   2
#define GTK_METERSCALE_TOP     4
#define GTK_METERSCALE_BOTTOM  8

typedef struct _GtkMeterScale        GtkMeterScale;
typedef struct _GtkMeterScaleClass   GtkMeterScaleClass;

struct _GtkMeterScale
{
  GtkWidget widget;

  /* the sides scales are marked on */
  guint direction;

  /* Deflection limits */
  gfloat lower;
  gfloat upper;
  gfloat iec_lower;
  gfloat iec_upper;

  int min_width;
  int min_height;
};

struct _GtkMeterScaleClass
{
  GtkWidgetClass parent_class;
};


GtkWidget*     gtk_meterscale_new               (gint direction,
						 gfloat min,
						 gfloat max);

guint          gtk_meterscale_get_type          (void);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_METERSCALE */
