/*
 * Copyright 2011 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gradle.reporting;

import org.gradle.util.GradleVersion;
import org.w3c.dom.Element;

import java.text.DateFormat;
import java.util.Date;

public abstract class TabbedPageRenderer<T> extends DomReportRenderer<T> {
    private T model;

    protected T getModel() {
        return model;
    }

    protected abstract String getTitle();

    protected String getPageTitle() {
        return getTitle();
    }

    protected abstract DomReportRenderer<T> getHeaderRenderer();

    protected abstract DomReportRenderer<T> getContentRenderer();

    @Override
    public void render(T model, Element parent) {
        this.model = model;

        // <head>
        Element head = append(parent, "head");
        appendWithText(head, "title", getPageTitle());
        Element link = append(head, "link");
        link.setAttribute("rel", "stylesheet");
        link.setAttribute("href", "base-style.css");
        link.setAttribute("type", "text/css");
        link = append(head, "link");
        link.setAttribute("rel", "stylesheet");
        link.setAttribute("href", "style.css");
        link.setAttribute("type", "text/css");
        Element script = append(head, "script");
        script.setAttribute("src", "report.js");
        script.setAttribute("type", "text/javascript");

        // <body>
        Element body = append(parent, "body");

        // Content
        Element content = appendWithId(body, "div", "content");
        appendWithText(content, "h1", getTitle());
        getHeaderRenderer().render(model, content);
        getContentRenderer().render(model, content);

        // Footer
        Element footer = appendWithId(content, "div", "footer");
        Element footerText = append(footer, "p");
        appendText(footerText, "Generated by ");
        appendLink(footerText, "http://www.gradle.org/", String.format("Gradle %s", GradleVersion.current().getVersion()));
        appendText(footerText, String.format(" at %s", DateFormat.getDateTimeInstance().format(new Date())));
    }
}
