package main

import (
	"context"
	"fmt"
	"os"
	"os/signal"
	"syscall"

	"github.com/moby/sys/reexec"
	"github.com/moby/term"

	"github.com/moby/moby/v2/daemon/command"
)

func main() {
	if reexec.Init() {
		return
	}
	ctx := context.Background()

	// Ignore SIGPIPE events. These are generated by systemd when journald is restarted while
	// the docker daemon is not restarted and also running under systemd.
	// Fixes https://github.com/moby/moby/issues/19728
	signal.Ignore(syscall.SIGPIPE)

	// Set terminal emulation based on platform as required.
	_, stdout, stderr := term.StdStreams()

	r, err := command.NewDaemonRunner(stdout, stderr)
	if err != nil {
		_, _ = fmt.Fprintln(stderr, err)
		os.Exit(1)
	}
	if err := r.Run(ctx); err != nil {
		_, _ = fmt.Fprintln(stderr, err)
		os.Exit(1)
	}
}
