import gtk


def on_pop_up_update_activate(popup, app):
    """ Execute when pop-up Update item is selected"""
    print "Update backend pressed", app

def on_pop_up_upgrade_activate (popup, app):
    """ Execute when pop-up Upgrade item is selected """
    print "Upgrade backend pressed", app

def on_b_update_clicked (button, app):
    """ Executed when Update toolbar button is clicked"""
    print "Update selected backends clicked", app
    

def do_popup(app, event):
    """open popup """
    print "Opening popup"
    
    menu = app.xml.get_widget ("backend_pop_up_menu")
    menu.connect ("deactivate", gtk.Widget.hide)
    gtk.Menu.popup(menu, None, None, None, event.button, event.time)

def on_backend_treeview_event(b_treeview, event, app):
    """Check for events """
    if event.type == gtk.gdk.BUTTON_PRESS and event.button == 3:
        do_popup (app, event)

    return False

def backend_toggled_cb (toggle, path, app):
    """ Change the toggle status of the selected backend.
    If a class of backends is choosen (mirrors, merges,..) it
    toggles all the backends of that category

    toggle: is the toggle widget that has been toggled
    path:   represent the item path
    app:    main app

    """
    status = toggle.get_active()
    iter = app.model.get_iter (path)
    
    app.model.set (iter,
                    app.COLUMN_SEL, (not status))
    
    if app.model.iter_has_child (iter):
        child = app.model.iter_children (iter)
        while (isinstance(child, gtk.TreeIter)):
            app.model.set (child, app.COLUMN_SEL, (not status))
            child = app.model.iter_next(child)
            
            app.b_treeview.set_model (app.model)
            

#Toolbar

def quit ():
    gtk.main_quit()    

def on_new_activate (obj, app):
    """Exit the application """
    print app
    print "File->New called"

def on_open_activate (obj, app):
    """ Open a configuration file """
    print "File->Open called"
    open_dialog = gtk.FileChooserDialog("test", action=gtk.FILE_CHOOSER_ACTION_OPEN,
                                        buttons=(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL, gtk.STOCK_OPEN, gtk.RESPONSE_ACCEPT))
    
    r = open_dialog.run()
    if r == gtk.RESPONSE_ACCEPT:
        print open_dialog.get_filename(), "selected"
        del app.conffile
        del app.cnf
        app.conffile = open_dialog.get_filename()
        app.parse_conffile ()
        app.update_backends_treeview ()
    elif r == gtk.RESPONSE_CANCEL:
        pass
    open_dialog.destroy()


def on_save_activate (obj, app):
    """Exit the application """
    print app
    print "File->Save called"


def on_clean_all_activate (obj, app):
    """Exit the application """
    print app
    print "File->Clean called"

    
def on_quit_activate (app):
    """Exit the application """
    print app
    print "File->Exit called"
    quit()


def backend_update (button, app):
    """ Update all selected backends """

