# Helper macro that checks whether a given CMake command exists or not
MACRO(CHECK_CMAKE_COMMAND_EXISTS commandname)
  MESSAGE(STATUS "Looking for CMake command ${commandname}")
  string(TOUPPER ${commandname} commandname_upper)
  IF(COMMAND ${commandname})
    SET(HAVE_${commandname_upper} TRUE)
    MESSAGE(STATUS "Looking for CMake command ${commandname} - found")
  ELSE()
    SET(HAVE_${commandname_upper} FALSE)
    MESSAGE(STATUS "Looking for CMake command ${commandname} - not found")
  ENDIF()
ENDMACRO()
