/*
 * Author: Andrei Zavada <johnhommer@gmail.com>
 *         building on original work by Thomas Nowotny <tnowotny@ucsd.edu>
 *
 * License: GPL-2+
 *
 * Initial version: 2009-04-08
 *
 */


#include <iostream>

#include "param-unit-literals.hh"

#include "standalone-synapses.hh"
#include "types.hh"
#include "model.hh"

#include "config.h"


CNRun::C_StandaloneSynapse::
C_StandaloneSynapse( TUnitType intype,
		     C_BaseNeuron* insource, C_BaseNeuron* intarget,
		     double ing, CModel* inM, int s_mask)
      : C_BaseSynapse (intype, insource, intarget, ing, inM, s_mask),
	C_StandaloneAttributes (__CNUDT[intype].vno)
{
	reset_vars();
	if ( M )
		M->include_unit( this);
	// else
	// 	_status &= ~CN_UENABLED;
}


CNRun::C_StandaloneSynapse::
~C_StandaloneSynapse()
{
	if ( __cn_verbosely > 5 )
		fprintf( stderr, " deleting standalone synapse \"%s\"\n", _label);
}

// C_StandaloneSynapse::~C_StandaloneSynapse()
// {
// 	if ( M->unregister_standalone_synapse( this) )
// 		cerr << "Synapse " << label << " was forgotten by mother model\n";
// }








const double CNRun::__CN_Params_SynapseMap[] = {
//	0.075,
       18.94463,  // Decay rate time constant
	0.25,
	0

};
const char* const CNRun::__CN_ParamNames_SynapseMap[] = {
//	"Synaptic strength g, " __CN_PU_CONDUCTANCE,
	"Decay rate time constant \317\204, " __CN_PU_RATE,
	"Release quantile \316\264",
	"Reversal potential Vrev, " __CN_PU_POTENTIAL
};
const char* const CNRun::__CN_ParamSyms_SynapseMap[] = {
//	"gsyn",
	"tau",
	"delta",
	"Vrev"
};







void
CNRun::CSynapseMxMap::
update_queue()
{
	unsigned k = _source -> n_spikes_in_last_dt();
	while ( k-- )
		_kq.push_back( model_time());

	while ( true ) {
		if ( q() > 0 && model_time() - _kq.front() > P[_tau_] )
			_kq.erase( _kq.begin());
		else
			break;
	}
}


// eof
