TEMPLATE = lib
TARGET = ClickManager
QT += qml quick core dbus xml network
CONFIG += qt plugin

TARGET = $$qtLibraryTarget($$TARGET)
uri = com.ubuntu.click

# Input
SOURCES += \
    clickmanager_plugin.cpp \
    clickmanager.cpp \
    network/network.cpp \
    application.cpp \
    download/downloader.cpp \
    download/downloadmanager.cpp \
    download/downloadtrackeradaptor.cpp \
    download_tracker.cpp \
    download/download_struct.cpp \
    download/group_download_struct.cpp \
    download/hash_algorithm.cpp

HEADERS += \
    clickmanager_plugin.h \
    clickmanager.h \
    network/network.h \
    application.h \
    download/downloader.h \
    download/downloadmanager.h \
    download/metatypes.h \
    download/downloadtrackeradaptor.h \
    download_tracker.h \
    download/download_struct.h \
    download/group_download_struct.h \
    download/hash_algorithm.h

OTHER_FILES = qmldir

!equals(_PRO_FILE_PWD_, $$OUT_PWD) {
    copy_qmldir.target = $$OUT_PWD/qmldir
    copy_qmldir.depends = $$_PRO_FILE_PWD_/qmldir
    copy_qmldir.commands = $(COPY_FILE) \"$$replace(copy_qmldir.depends, /, $$QMAKE_DIR_SEP)\" \"$$replace(copy_qmldir.target, /, $$QMAKE_DIR_SEP)\"
    QMAKE_EXTRA_TARGETS += copy_qmldir
    PRE_TARGETDEPS += $$copy_qmldir.target
}

qmldir.files = qmldir
unix {
    installPath = $$[QT_INSTALL_QML]/$$replace(uri, \\., /)
    qmldir.path = $$installPath
    target.path = $$installPath
    INSTALLS += target qmldir
}

QMAKE_CXXFLAGS += -I /usr/include/ubuntuoneauth-2.0 -I /usr/include/signon-qt5 -I /usr/include/accounts-qt5
LIBS += -lapt-pkg -lubuntuoneauth-2.0 -lsignon-qt5 -laccounts-qt5
