%define ver	2.0
%define rel	6
Summary: Argus Network Auditing Software
Name: argus
Version: %ver
Release: %rel
Copyright: QoSient LLC 2000-2004
Group: Applications/Internet
Source0: ftp://ftp.qosient.com/pub/argus/argus-%{ver}.%{rel}.tar.gz
URL: http://qosient.com/argus

%description
Argus (Audit Record Generation and Utilization System) is an IP network
transaction auditing tool.  The data generated by argus can be used
for a wide range of tasks such as network operations, security
and performance management.

%define argusdir	/usr/local
%define arguslog	/var/log/argus
%define argusdocs	/usr/share/doc/argus-%{ver}
%define argusdata	%{argusdir}/argus

%define argusbin	%{argusdir}/bin
%define argussbin	%{argusdir}/sbin

%prep
%setup -n %{name}-%{ver}.%{rel}
%build
%configure --prefix=/usr
make
mkdir -p %{argusdir}
mkdir -p %{argusbin}
mkdir -p %{argusdocs}
mkdir -p %{argusdata}
mkdir -p %{argusdata}/archive
mkdir -p %{argussbin}
mkdir -p %{arguslog}

cp -Rp support %{argusdocs}
cp -Rp doc/* %{argusdocs}

install -m 0444 -o root -g root README %{argusdata}
install -m 0444 -o root -g root COPYING %{argusdata}

install -m 0555 -o root -g root bin/argusbug %{argusbin}
install -m 0555 -o root -g root bin/argus_* %{argussbin}/argus

install -m 0444 -o root -g root man/man5/* %{_mandir}/man5/
install -m 0444 -o root -g root man/man8/* %{_mandir}/man8/

install -C -m 0600 -o root -g root support/Config/argus.conf /etc/argus.conf
install -m 0755 -o root -g root support/Startup/argus /etc/rc.d/init.d/argus
install -m 0755 -o root -g root support/Archive/argusarchive %{argusbin}/argusarchive

%post
/sbin/chkconfig --add argus

%preun
if [ "$1" = 0 ] ; then
  service argus stop >/dev/null 2>&1
  /sbin/chkconfig --del argus
fi

%postun
if [ "$1" -ge "1" ]; then
  service argus condrestart >/dev/null 2>&1
fi

%files
%defattr(-,root,root)
%{argussbin}/argus
%{argusbin}/argusarchive
%{argusbin}/argusbug
%{argusdata}
%doc %{argusdocs}
%{_mandir}/man5/argus.5
%{_mandir}/man5/argus.conf.5
%{_mandir}/man8/argus.8
/var/log/argus
/etc/rc.d/init.d/argus
%config /etc/argus.conf
