/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.parsers.Parser;
import cz.startnet.utils.pgdiff.parsers.ParserUtils;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgPolicy;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgTable;
import java.text.MessageFormat;

public class CreatePolicyParser {
    public static void parse(PgDatabase pgDatabase, String string) {
        String string2;
        Parser parser = new Parser(string);
        PgPolicy pgPolicy = new PgPolicy();
        parser.expect("CREATE", "POLICY");
        String string3 = parser.parseIdentifier();
        parser.expect("ON");
        String string4 = parser.parseIdentifier();
        String string5 = ParserUtils.getSchemaName(string4, pgDatabase);
        PgSchema pgSchema = pgDatabase.getSchema(string5);
        if (pgSchema == null) {
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindSchema"), string5, string));
        }
        PgTable pgTable = pgSchema.getTable(ParserUtils.getObjectName(string4));
        if (pgTable == null) {
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindTable"), string4, string));
        }
        if (parser.expectOptional("FOR")) {
            string2 = parser.expectOptionalOneOf("ALL", "SELECT", "INSERT", "UPDATE", "DELETE");
            pgPolicy.setCommand(string2);
        } else {
            pgPolicy.setCommand("ALL");
        }
        if (parser.expectOptional("TO")) {
            if (parser.expectOptional("PUBLIC")) {
                pgPolicy.getRoles().add("PUBLIC");
            } else {
                string2 = parser.parseIdentifier();
                pgPolicy.getRoles().add(string2);
                while (string2 != null) {
                    if (parser.expectOptional(",")) {
                        parser.skipWhitespace();
                        string2 = parser.parseIdentifier();
                        pgPolicy.getRoles().add(string2);
                        continue;
                    }
                    string2 = null;
                }
            }
        } else {
            pgPolicy.getRoles().add("PUBLIC");
        }
        if (parser.expectOptional("USING")) {
            parser.expect("(");
            pgPolicy.setUsing(parser.getExpression());
            parser.expect(")");
        }
        if (parser.expectOptional("WITH", "CHECK")) {
            parser.expect("(");
            pgPolicy.setWithCheck(parser.getExpression());
            parser.expect(")");
        }
        pgPolicy.setName(string3);
        pgPolicy.setTableName(pgTable.getName());
        pgTable.addPolicy(pgPolicy);
    }

    private CreatePolicyParser() {
    }
}

