#!/usr/local/bin/perl

use PGPLOT;

print "\n\nTesting advanced point and line plot routines...\n\n";

print "PGPLOT module version $PGPLOT::VERSION\n\n";

pgqinf("VERSION",$val,$len);
print "PGPLOT $val library\n\n";


$dev = "?" unless defined $dev;

pgbegin(0,$dev,1,1);

pgscf(2);       # Set label character font
pgslw(4);       # Set line width
pgsch(1.6);     # Set label character height

pgenv(10.0,30.0,-2.0,6.0,0,0);

pgsci(6);

pglabel("X axis \\gP","Y axis \\gF","Top Label \\gW");

pgsci(7);

$i=-1;
while(<DATA>){
   $i++;
   ($x[$i], $y[$i]) = split(' ');
}
pgline($i,*x,*y);

pgsci(3);

for($i=0; $i<10; $i++) {
   $x[$i] = $i+15;
   $y[$i] = $i-1;
   $e[$i] = 0.9;
   $x1[$i] = $x[$i] - $e[$i];
   $x2[$i] = $x[$i] + 2.0* $e[$i];
   $y1[$i] = $y[$i] - 0.7* $e[$i];
   $y2[$i] = $y[$i] + 0.3* $e[$i];
}


pgpoint(10,\@x,\@y,14);
pgerrx(10,\@x1,\@x2,*y,1);
pgerry(10,*x,*y2,*y1,.1);  # Note we can also pass globs
pgsci(2);
pgsah(1,30,0.5);
pgarro(20,0,25,2);

pgmtext('B', -2.0, 0.95, 1, "This is a test");

pgsci(9);

pgptxt(25,2,35,0,'This way...');

pgqinf("CURSOR",$ans,$l);
if ($ans eq "YES") {

   print "Entering interactive cursor test...\n";
   
   pgsci(4);
   
   print "Enter some points with the cursor\n";
   
   pglcur(5,$n,\@xt,\@yt);
   pgsci(9);
   pgpoint($n,*xt,*yt,20);
   
   for(@xt) { printf "%5.2f ",$_; } print "\n";
   for(@yt) { printf "%5.2f ",$_; } print "\n";
   
   pgsci(2); 
   pgpoly($n,\@xt,\@yt);
}

$l=1; $len=1; # Get past -w
pgiden;

pgend;


__DATA__
    17.000000000000    1.8515548576633
    17.090909090909    1.8907204814559
    17.181818181818    1.9295359694614
    17.272727272727    1.9680015320877
    17.363636363636    2.0061177764022
    17.454545454545    2.0438854788985
    17.545454545455    2.0813053106065
    17.636363636364    2.1183775285123
    17.727272727273    2.1551016548418
    17.818181818182    2.1914761754610
    17.909090909091    2.2274982964675
    18.000000000000    2.2631637990568
    18.090909090909    2.2984670235480
    18.181818181818    2.3334009941233
    18.272727272727    2.3679576705054
    18.363636363636    2.4021282884047
    18.454545454545    2.4359037344501
    18.545454545455    2.4692748984585
    18.636363636364    2.5022329570773
    18.727272727273    2.5347695641881
    18.818181818182    2.5668769479863
    18.909090909091    2.5985479346970
    19.000000000000    2.6297759289711
    19.090909090909    2.6605548795749
    19.181818181818    2.6908792486119
    19.272727272727    2.7207439885008
    19.363636363636    2.7501445190802
    19.454545454545    2.7790766916671
    19.545454545455    2.8075367289695
    19.636363636364    2.8355211378950
    19.727272727273    2.8630266031458
    19.818181818182    2.8900498792887
    19.909090909091    2.9165877047968
    20.000000000000    2.9426367619456
    20.090909090909    2.9681937015030
    20.181818181818    2.9932552421733
    20.272727272727    3.0178183437014
    20.363636363636    3.0418804415552
    20.454545454545    3.0654397220766
    20.545454545455    3.0884954112766
    20.636363636364    3.1110480486517
    20.727272727273    3.1330997194487
    20.818181818182    3.1546542241000
    20.909090909091    3.1757171712601
    21.000000000000    3.1962959901364
    21.090909090909    3.2163998676902
    21.181818181818    3.2360396257475
    21.272727272727    3.2552275607789
    21.363636363636    3.2739772736228
    21.454545454545    3.2923035164850
    21.545454545455    3.3102220796353
    21.636363636364    3.3277497309551
    21.727272727273    3.3449042097046
    21.818181818182    3.3617042642169
    21.909090909091    3.3781697143502
    22.000000000000    3.3943215153121
    22.090909090909    3.4101818004154
    22.181818181818    3.4257738855463
    22.272727272727    3.4411222258316
    22.363636363636    3.4562523231832
    22.454545454545    3.4711905905443
    22.545454545455    3.4859641839488
    22.636363636364    3.5006008167596
    22.727272727273    3.5151285717900
    22.818181818182    3.5295757265490
    22.909090909091    3.5439706045569
    23.000000000000    3.5583414614507
    23.090909090909    3.5727164084470
    23.181818181818    3.5871233678865
    23.272727272727    3.6015900466180
    23.363636363636    3.6161439038134
    23.454545454545    3.6308120817070
    23.545454545455    3.6456212622683
    23.636363636364    3.6605974115804
    23.727272727273    3.6757653780882
    23.818181818182    3.6911483216329
    23.909090909091    3.7067669668871
    24.000000000000    3.7226386953562
    24.090909090909    3.7387765105380
    24.181818181818    3.7551879257226
    24.272727272727    3.7718738281295
    24.363636363636    3.7888273645828
    24.454545454545    3.8060328765675
    24.545454545455    3.8234648968141
    24.636363636364    3.8410872196533
    24.727272727273    3.8588520839843
    24.818181818182    3.8766995601456
    24.909090909091    3.8945572940574
    25.000000000000    3.9123408056662
    25.090909090909    3.9299545354314
    25.181818181818    3.9472937671957
    25.272727272727    3.9642474355297
    25.363636363636    3.9807016791172
    25.454545454545    3.9965438681261
    25.545454545455    4.0116667476424
    25.636363636364    4.0259723198282
    25.727272727273    4.0393751330183
    25.818181818182    4.0518047388756
    25.909090909091    4.0632071938271
    26.000000000000    4.0735455942983
