#ifndef _MTYPE_H
#define _MTYPE_H

#include <iostream>
#include <fstream>
#include <iomanip>

#define CORE_LEVEL 4
#include "CORE/CORE.h"

using namespace std;

#define MAX(x, y)	((x) > (y) ? (x) : (y))
#define MIN(x, y)	((x) > (y) ? (y) : (x))

// Point class definition.
class Point
{ 
public:
	// constructors and destructor.
	Point() { x = y = 0.0; };
	Point( double x, double y ) { this->x = x; this->y = y; }
	~Point(){}

public:
	// operator overloading.
	Point& operator =( const Point& pt ) { x = pt.x; y = pt.y; return (*this); }
	double operator *( const Point& pt ) { return ( x*pt.x + y*pt.y ); }
	bool operator ==( const Point& pt )  { return ( ( x==pt.x && y==pt.y ) ? true:false ); }
	bool operator !=( const Point& pt )  { return ( ( x!=pt.x || y!=pt.y ) ? true:false ); }
	Point operator -( const Point& pt )  { return Point( x-pt.x, y-pt.y ); }
	double get_norm() { return sqrt( (x*x + y*y) ); }
	void normalize() { double len = get_norm(); x /= len; y /= len; }

public:
	// class attribute.
	double x;
	double y;
};

void get_signed_area( Point *Pts, int size, int strategy, ofstream& out );
double get_signed_area_approx( Point p, Point q, Point r, int pivot_idx );
Expr get_signed_area_exact( Point p, Point q, Point r );

int get_pivot_idx_I( Point p, Point q, Point r );
int get_pivot_idx_II( Point p, Point q, Point r );
int get_pivot_idx_III( Point p, Point q, Point r );

double rho( double a, double b );
double rho( Point p0, Point p1 );
double rho( Point p, Point q, Point r, int pivot_idx );
double get_angle( Point p0, Point p1 );
int ExprSign( Expr e );
Expr ExprAbs( Expr e );


#else
#endif // _MTYPE_H

