/* Homework 3, Course in Computational Geometry
 * SNU, Fall 2003
 * Name: Seung-Hyun Yun (shyun@3map.snu.ac.kr
 */

#include "mtype.h"

#define DATA_NUM 100

int main( int argc, char **argv )
{
	register i;
	int strategy;
	
	ifstream in = ifstream( argv[1] );
	ofstream out = ofstream( argv[2] );

	strategy = atoi( argv[3] );
	Point *Pts = new Point[DATA_NUM];

	// read data file.
	for ( i = 0; i < DATA_NUM; i++ )
	{
		in >> Pts[i].x;
		in >> Pts[i].y;
	}

	get_signed_area( Pts, DATA_NUM, strategy, out );

	delete [] Pts;
	
	return 0;
}

void get_signed_area( Point *Pts, int size, int strategy, ofstream& out )
{
	register i, j, k;

	Point p, q, r;

	double	*absolute_error;
	double	*relative_error;

	Expr	average_absolute_error,
			average_relative_error,
			max_absolute_error = Expr( 0 ),
			max_relative_error = Expr( 0 );

	double 	sum_absolute_error = 0,
			sum_relative_error = 0;
			

	int pivot_idx, 
		count_correct_value = 0, 
		count_correct_sign = 0,
		count_inverted_sign = 0,
		count_total = DATA_NUM * ( DATA_NUM - 1 ) * ( DATA_NUM - 2 ) / 6,
		idx = 0;

	absolute_error = new double[count_total];
	relative_error = new double[count_total];

	Expr exact_area, approx_area;

	for ( i = 0; i < size; i++ )
	for ( j = i + 1; j < size; j++ )
	for ( k = j + 1; k < size; k++ )
	{
		p = Pts[i];
		q = Pts[j];
		r = Pts[k];
		double tmp;

		// get pivot method.
		if ( strategy == 1 )
			pivot_idx = get_pivot_idx_I( p, q, r );
		if ( strategy == 2 )
			pivot_idx = get_pivot_idx_II( p, q, r );
		if ( strategy == 3 )
			pivot_idx = get_pivot_idx_III( p, q, r );

		// get approximated area using machine level.
		tmp = get_signed_area_approx( p, q, r, pivot_idx );

		// get exact area using core lib.
		exact_area = get_signed_area_exact( p, q, r );
		
		// to compare approximated area with exact area.
		approx_area = Expr( tmp );

		// get error and sum
		
		if ( exact_area != 0 )
		{
			absolute_error[idx] = ExprAbs( approx_area-exact_area ).doubleValue();
			relative_error[idx] = ( ExprAbs( approx_area - exact_area ) / ExprAbs( exact_area ) ).doubleValue();
			sum_absolute_error = sum_absolute_error + absolute_error[idx];
			sum_relative_error = sum_relative_error + relative_error[idx];
		}
		else
		{
			relative_error[idx] = 0;
			absolute_error[idx] = ExprAbs( approx_area - exact_area ).doubleValue();
			sum_absolute_error = sum_absolute_error + absolute_error[idx];
			sum_relative_error = sum_relative_error + relative_error[idx];
		}
		
		
		// get maximum error.
		if ( absolute_error[idx] > max_absolute_error )
			max_absolute_error = absolute_error[idx];
		if ( relative_error[idx] > max_relative_error )
			max_relative_error = relative_error[idx];

		// count the followings...
		if ( absolute_error[idx] == 0 )
			count_correct_value++;

		if ( ExprSign( approx_area ) == ExprSign( exact_area ) )
			count_correct_sign++;
		if ( ExprSign( approx_area ) != ExprSign( exact_area ) )
			count_inverted_sign++;

		idx++;
	}

	average_absolute_error = sum_absolute_error / count_total;
	average_relative_error = sum_relative_error / count_total;


	double sum_absolute = 0.0;
	double sum_relative = 0.0;

	for ( i = 0; i < count_total; i++ )
	{
		Expr difference_absolute = absolute_error[i] - average_absolute_error;
		Expr difference_relative = relative_error[i] - average_relative_error;
		difference_absolute = difference_absolute * difference_absolute;
		difference_relative = difference_relative * difference_relative;
		sum_absolute = sum_absolute + difference_absolute.doubleValue();
		sum_relative = sum_relative + difference_relative.doubleValue();
	}

	Expr deviation_absolute, deviation_relative;
	out << setprecision(15);

	deviation_absolute = sqrt( sum_absolute / count_total );
	deviation_relative = sqrt( sum_relative / count_total );

	out << "=======================================================" << endl;
	out << "Result" << endl;
	out << "1. The number of time( approx_area == exact_area ) is " 
		<< count_correct_value << endl;
	out << "2. The maximum value of |approx_area-exact_area| is " 
		<< max_absolute_error << endl;
	out << "3. The average value of |approx_area - exact_area| is " 
		<< average_absolute_error << endl;
	out << "4. The standard deviation of |approx_area - exact_area| is " 
		<< deviation_absolute << endl;
	out << "5. The maximum value of |approx_area - exact_area| / |exact_area| is " 
		<< max_relative_error << endl;
	out << "6. The average value of |approx_area - exact_area| / |exact_area| is " 
		<< average_relative_error << endl;
	out << "7. The standard deviation of |approx_area - exact_area| / |exact_area| is " 
		<< deviation_relative << endl;
	out << "8. The number of correct sign is " 
		<< count_correct_sign << endl;
	out << "9. The number of inverted sign is " 
		<< count_inverted_sign << endl;
	out << "=======================================================" << endl;

	delete [] absolute_error;
	delete [] relative_error;

}
int ExprSign( Expr e )
{
	if ( e == 0 )
		return 0;
	if ( e > 0 )
		return 1;
	return -1;
}

double get_signed_area_approx( Point p, Point q, Point r, int pivot_idx )
{
	double area;
	switch( pivot_idx )
	{
	case 1: // rho_p
		area = ( q.x - p.x ) * ( r.y - p.y ) - ( q.y - p.y ) * ( r.x - p.x );
		break;
	case 2: // rho_q
		area = ( r.x - q.x ) * ( p.y - q.y ) - ( r.y - q.y ) * ( p.x - q.x );
		break;
	case 3: // rho_r
		area = ( p.x - r.x ) * ( q.y - r.y ) - ( p.y - r.y ) * ( q.x - r.x );
		break;
	}
	return area;
}
Expr get_signed_area_exact( Point p, Point q, Point r )
{
	Expr px = Expr( p.x );
	Expr py = Expr( p.y );
	Expr qx = Expr( q.x );
	Expr qy = Expr( q.y );
	Expr rx = Expr( r.x );
	Expr ry = Expr( r.y );
	Expr area = ( qx - px ) * ( ry - py ) - ( qy - py ) * ( rx - px );
	return area;
}
int get_pivot_idx_I( Point p, Point q, Point r )
{
	register i;
	int pivot_idx = 1;
	double min, tmp;
	min = rho( p, q, r, 1 );
	for ( i = 2; i < 4; i++ )
	{
		tmp = rho( p, q, r, i );
		if ( tmp < min )
		{
			pivot_idx = i;
			min = tmp;
		}
	}
	return pivot_idx;
}
int get_pivot_idx_II( Point p, Point q, Point r )
{
	double P, Q, R;
	P = get_angle( q-p, r-p );
	Q = get_angle( p-q, r-q );
	R = get_angle( p-r, q-r );
	if ( P > Q )
	{
		if ( P > R )
			return 1; // P > Q,R
		else 
			return 3; // R > P > Q
	}
	else
	{
		if ( Q > R )
			return 2; // Q > P,R
		else
			return 3; // R > Q > P;
	}
	return 1;
}
int get_pivot_idx_III( Point p, Point q, Point r )
{
	double P, Q, R;
	P = get_angle( q-p, r-p );
	Q = get_angle( p-q, r-q );
	R = get_angle( p-r, q-r );
	if ( P < Q )
	{
		if ( P < R )
			return 1; // P < Q,R
		else 
			return 3; // R < P < Q
	}
	else
	{
		if ( Q < R )
			return 2; // Q < P,R
		else
			return 3; // R < Q < P;
	}
	return 1;
}
double rho( double a, double b )
{
	double tmp0 = a / b;
	double tmp1 = b / a;
	tmp0 = fabs( tmp0 );
	tmp1 = fabs( tmp1 );
	double ret = MIN( tmp0, tmp1 );
	return ret;
}

double rho( Point p0, Point p1 )
{
	double ret = MAX( rho( p0.x, p1.x ), rho( p0.y, p1.y ) );
	return ret;
}

double rho( Point p, Point q, Point r, int pivot_idx )
{
	double ret;
	switch( pivot_idx )
	{
	case 1: // rho_p
		ret = MAX( rho( p, q ), rho( p, r ) );
		break;
	case 2: // rho_q
		ret = MAX( rho( q, r ), rho( q, p ) );
		break;
	case 3: // rho_r
		ret = MAX( rho( r, p ), rho( r, q ) );
		break;
	}
	return ret;
}

double get_angle( Point p0, Point p1 )
{
	double cs;
	p0.normalize();
	p1.normalize();

	cs = p0 * p1;
	cs = acos( cs );

	return cs;
}

Expr ExprAbs( Expr e )
{
	Expr ret = e;
	if ( e < 0 )
		ret = -ret;
	return ret;
}

  


