/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.security.auth.callback.Callback;
import org.apache.ws.security.WSSecurityException;

public class PublicKeyCallback
implements Callback {
    private PublicKey publicKey;
    private boolean verified = false;

    public PublicKeyCallback(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setVerified(boolean b) {
        this.verified = b;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public boolean verifyTrust(KeyStore keyStore) throws WSSecurityException {
        if (this.publicKey == null || keyStore == null) {
            return false;
        }
        try {
            Enumeration<String> e = keyStore.aliases();
            while (e.hasMoreElements()) {
                X509Certificate x509cert;
                Certificate cert;
                String alias = e.nextElement();
                Certificate[] certs = keyStore.getCertificateChain(alias);
                if (certs == null || certs.length == 0) {
                    cert = keyStore.getCertificate(alias);
                    if (cert == null) {
                        continue;
                    }
                } else {
                    cert = certs[0];
                }
                if (!(cert instanceof X509Certificate) || !this.publicKey.equals((x509cert = (X509Certificate)cert).getPublicKey())) continue;
                this.verified = true;
                return true;
            }
        }
        catch (KeyStoreException e) {
            return false;
        }
        return false;
    }
}

